/*
  smarter.c - Patch SMARTDrive 5.02 to cache SHSUCDX 2.0.

  Jason Hood, 3 June, 2003.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long DWORD;
typedef void*         NPTR;
typedef void far*     FPTR;

#pragma pack(1)
#include "redir.h"

char shsucdx[] =
{
  0xbbu, 0xabu, 0xebu,		//	mov bx, SMARTDRV_Q
  0xb8u, 0x00, 0x11,		//	mov ax, (REDIR shl 8) + InstallChk
  0xcdu, 0x2f,			//	int 2fh
  0x81u, 0xfbu, 0xbeu, 0xbau,	//	cmp bx, SMARTDRV_R
  0x75, 0x01,			//	jne @F
  0xc3u,			//	ret
  0x29, 0xc0u,			// @@:	sub ax, ax
  0xc3u 			//	ret
};

int main( int argc, char* argv[] )
{
  FILE*  file;
  char	 name[80];
  char*  buf;
  size_t len;

  if (argc == 1)
  {
    char* windir = getenv( "winbootdir" );
    if (windir == NULL) windir = "c:/windows";
    strcpy( name, windir );
    strcat( name, "/smartdrv.exe" );
  }
  else strcpy( name, argv[1] );

  if ((file = fopen( name, "rb" )) == NULL)
  {
    fprintf( stderr, "Unable to open \"%s\".\n", name );
    return 1;
  }
  fseek( file, 0, SEEK_END );
  len = (size_t)ftell( file );
  buf = malloc( len );
  if (!buf)
  {
    fprintf( stderr, "Not enough memory (wanted to allocate %u).\n", len );
    return 2;
  }
  rewind( file );
  fread( buf, 1, len, file );
  fclose( file );

  if (*(short*)(buf + 0x8d15u) != 0x0114 ||	// Verify offsets
      *(short*)(buf + 0x8d23u) != 0x0275)
  {
    fputs( "Not the right SMARTDrive version.\n", stderr );
    return 3;
  }

  if ((file = fopen( "smartcdx.exe", "wb" )) == NULL)
  {
    fputs( "Unable to create SMARTCDX.EXE\n", stderr );
    return 4;
  }

  buf[0x8d0fu] = 0x19;			// Jump past tests
  *(short*)(buf + 0x8d2eu) = 0x9090;	// Remove MOV DI,[DI]

  *(short*)(buf + 0x8d90u) = 0x9090;	// SHSUCDX uses A=0, but MSCDEX uses
  *(short*)(buf + 0x8dc5u) = 0x9090;	//  A=1 - remove SMARTDrive's DEC AL
  *(short*)(buf + 0x8deeu) = 0x9090;
  *(short*)(buf + 0x8df8u) = 0x9090;

  buf[0x8e05u] = sizeof(struct DrvEnt); // Adjust the drive entry size

  // Replace the MSCDEX test with the SHSUCDX test.
  memcpy( buf + 0x8e0cu, shsucdx, sizeof(shsucdx) );

  if (fwrite( buf, 1, len, file ) != len)
  {
    fputs( "Not all bytes written!\n", stderr );
    return 5;
  }

  fclose( file );

  return 0;
}
