;***************************************************************************
;
; SHSUCDX Version 1.4b
; (c) John H. McCoy, October 2000
; csc_hm@shsu.edu
;
; Version 2.0
; Jason Hood, June 2003
; jadoxa@yahoo.com.au
;
;
;  Version 2.0 modifies the filename generation for long ISO entries. Instead
;     of using the first eleven characters, it uses the first eight, skips to
;     the dot, then uses the next three. There is also an option to generate
;     "tilded" entries (similar, but not identical, to Windows), which
;     overcomes same-name limitations. This option (/~[+|-]) is allowed after
;     installation. The block size has been fixed at 2K; set VARBLKSIZE (in
;     undoc.inc and redir.h) to read the block size from the CD. While I was
;     at it, I size-optimised it, so now it only takes 6K for one drive. It
;     also assumes a 386 and loads itself high.
;
;
;  Version 1.4b fixed a problem with findfirst that caused a problem when
;      a program expected getting the volid would also set it up for
;      scanning the root directory with findnext.
;
;  Version 1.4a changed the dos version check so that it will run under MEDos
;     with set ver.  MEDos is version 8
;  Version 1.4 increased the allowed length of directories from 64K bytes to
;     64K sectors (128 M bytes) to solve the problem of lost entries that
;     occurred when a directory exceeded 32 sectors.
;
;  SHSUCDX Version 1.1a
;  (c) John H. McCoy, May 1996
;  Sam Houston St. Univ., TX 77341-2206
;

;     SHSUCDX is an un-loadable CD-ROM redirector substitute for MSCDEX.
;	 Version 1.1a supports up to 10 CD drives.  Each drive is single
;	 sector buffered and the last 10 directory entries are cached.
;	 This version finally fixes (I hope) a problem with handling some
;	 directory entries.  It has also been changes to handle lower case
;	 characters in directory and file names.  LC characters are not
;	 valid, but some NT/Win95 mastering programs put them in.
;
;	 Approx 17K of RAM is needed to install SHSUCDX.  The resident size
;	 for a single drive is less than 11K.  Each additional drive increases
;	 the resident size by 2500 bytes.  Multiple drivers are supported.
;	 The driver name, drive letter, drive unit and number of drives from
;	 each driver can be specified on the command line.
;
;	 SHSUCDX does not attempt to read the CD ROM until an access request
;	 is made.  Thus, the CD drive does not have to be ready when the
;	 redirector is loaded.	If more than 7 seconds elapse between access
;	 requests a media check is made.  The buffers and cache are flushed
;	 and the CD is re-read only if the driver reports a media change.
;	 This reduces network traffic but can result in missing a "fast"
;	 media change on a local drive.
;
;	 When SHSUCDX unloads it marks the drives it used as invalid.
;
;     SHSUCDX has been run with MS-DOS 4, 5, 6 and 7 stand-alone, under
;	 Windows 3.1, and in a specific DOS window under OS2.
;
;     A CD-ROM driver which supports the CD-ROM extensions must be loaded
;	 before loading SHSUCDX.  By default, SHSUCDX looks for a driver
;	 named SHSU-CDN.
;
;     usage:  SHSUCDX [/D:DriverName[,[Drive][,[Unit][,[MaxDrives]]]]]
;
;	 DriverName  1 to 8 characters.
;	 Drive	     First drive letter to assign to drives attached to
;			this driver.
;	 Unit	     First drive unit on this driver to be assigned to a
;			drive letter.  (Allowed range 0 to 99)
;	 MaxDrives   Maximum number of drives on this driver that are to
;			be assigned to drive letters.
;
;	 Note:	The drive letter assigned to units of a second driver will
;	   always be higher than those assigned to the first driver and
;	   those assigned to a third driver will be higher than those
;	   assigned to the second.
;
;	 example: SHSUCDX
;
;	 SHSUCDX finds the first available drive letter and assigns it
;	 to device unit 0 of the default driver SHSU-CDN.  If there is a
;	 second and/or third CD drive they are assigned to the next avail-
;	 able letters in sequence.  Drive letters in use are skipped.  The
;	 first CD supported by a driver is device unit 0 regardless of its
;	 SCSI address.
;
;	 example: SHSUCDX /D:CD001,F,,1  /D:SHSU-CDN,,1
;
;	 SHSUCDX assigns drive F to device unit 0 of the driver CD001.
;	 Units 1 and 2 of driver SHSU-CDN are then assigned to the next
;	 available letters.
;
;	 example: SHSUCDX /D:CD001,,1,1  /D:CD001,,4,1
;
;	 SHSUCDX assigns the first available drive letter to device unit 1
;	 of the driver CD001 and drive unit 4 to the next.  This allows
;	 access to non-contiguous drive units without having to support
;	 un-needed units.
;
;     unload: SHSUCDX [-u|/u]
;
;     The following INT 2F, 15h functions are supported:
;
;	 00	 Get number of CD-ROM drives
;	 01	 Get CD-ROM drive device list
;	 02	 Get Copyright File ID
;	 03	 Get Abstract File ID
;	 04	 Get Bibliographic File ID
;	 05	 Read VTOC
;	 08	 Absolute disk read
;	 0B	 CDROM drive check
;	 0C	 MSCDEX version
;	 0D	 Get CD-ROM drive letters
;	 0F	 Get directory Entry (not canonical) (*)
;	 10	 Send device request
;
;	 *	 This function has been extended to control tilde usage.
;
;   SHSUCDX is a copyright reserved, free use program.
;
;   (c)John H. McCoy, 1994 - 2000 Sam Houston St. Univ., TX 77341-2206
;
; ***************************************************************************
;
;    Microsoft has not documented the redirector functions.  I have borrowed
;      from and am particularly indebted to the authors of:
;
;      A CD-ROM redirector for HighSierra and ISO 9660 disks.
;	  Jim Harper, DDJ, March 1993
;      Inside the ISO-9660 Filesystem Format
;	  William and Lynne Jolitz, DDJ, December 1992
;      Undocumented DOS, Chapter 4.
;	  Andrew Schulman, et. al, Addison Wesley, 1990
;
;    Written for MASM 6.0b.  C functions compiled with MSC 5.1
;    jmh: I've used MASM 6.11d and MSC 8.00c
; ***************************************************************************
;
; Modifications 3-4-94
;   test redir not network bit on call
;   set drive flags for physical network redir on install
;   test for physical network redir before clearing root
;
; Modifications 9-8-2000
;   changed cmds.c to findfirst/findnext
;

option nokeyword:<name type length >
option expr32

; make offsets group relative instead of segment relative
.model small
.386

fptr  typedef  far ptr
nptr  typedef  near ptr

include undoc.inc

True		equ	1h
False		equ	0h
AsciiNul	equ	0
AsciiA		equ	'A'
cr		equ	0dh
lf		equ	0ah
QMark		equ	'?'
CDUNKNOWN	equ	0FFh

;  redirector equates
REDIR		equ	11h
InstallChk	equ	00h
ChDir		equ	05h
Close		equ	06h
Flush		equ	07h
Read		equ	08h
Write		equ	09h
GetSpace	equ	0ch
SetAttr 	equ	0eh
GetAttr 	equ	0fh
Open		equ	16h
FindFirst	equ	1Bh
FindNext	equ	1Ch
Seek		equ	21h
PathName	equ	23h
TOF		equ	2dh		; truncate open file
EOpen		equ	2eh

;  CDS offsets
RootSlashOff	equ	7
DriveOff	equ	2

;  MSCDEX equates
MSCDEX		equ	15h
MSCDEX_Q	equ	0DADAh
MSCDEX_R	equ	0ADADh

SMARTDRV_Q	equ	0EBABh
SMARTDRV_R	equ	0BABEh

;

MAXDRIVES	equ	10
CACHESIZE	equ	10
SECTORSIZE	equ	2048

; declare protos, publics and externals

Main2F		  proto near
SetDDD		  proto near PASCAL DriveLetter:byte
ForUs		  proto near PASCAL DriveLetter:byte
GetCABID	  proto near PASCAL ActionCode:byte, XBufp:fptr
GetDirEntry	  proto near PASCAL Dp:fptr, Pathp:fptr
DoChDir           proto near PASCAL
DoFindFirst	  proto near PASCAL
DoFindNext	  proto near PASCAL
DoGetAttr	  proto near PASCAL
DoOpen		  proto near PASCAL SFTp:fptr
DoRead		  proto near PASCAL SFTp:fptr
DoClose 	  proto near PASCAL SFTp:fptr
CdReadBlk	  proto near PASCAL BlkNo:dword
CdReadLong	  proto near PASCAL IOBuf:fptr, BlkNo:dword, NumBlks:word
CDMediaChanged	  proto near PASCAL
ToIBM		  proto near PASCAL IBMName:nptr,FIDLen:word,Chp:fptr,hint:word
Match		  proto near PASCAL Namep:nptr, TemPlate:nptr
;ToHex		  proto near PASCAL Num:word
MsgOut		  proto near PASCAL msg:near ptr char
SetRoot 	  proto near PASCAL CDSx:fptr
ClrRoot 	  proto near
InitDrive	  proto near PASCAL
ParseCommandLine  proto near

	PUBLIC	  C FN1p, DTApp, SAttrp, SDBp
	PUBLIC	  C DriveNo, NoDrives, DriveOfs
	PUBLIC	  C Drive
	PUBLIC	  C _FLAGS,_AX,_BX,_CX,_DX,_SI,_DI,_ES

DGROUP	group	_TEXT, _DATA, _BSS, C_COMMON, CONST, _INIT

; this is the way C wants it

_TEXT	segment word PUBLIC 'CODE'
	assume cs:DGROUP, ds:DGROUP
_TEXT	ends

_DATA	segment word PUBLIC 'DATA'
	assume ds:DGROUP
_DATA	ends

_BSS	segment word PUBLIC 'BSS'
	assume ds:DGROUP
_BSS	ends

C_COMMON segment word PUBLIC 'BSS'
	 assume ds:DGROUP
C_COMMON ends

CONST	segment word PUBLIC 'CONST'
	assume ds:DGROUP
CONST	ends

_INIT	segment word PUBLIC 'INIT'
	assume cs:DGROUP, ds:DGROUP
_INIT	ends


EndOfCDX segment para STACK
	byte "This STACK SEGMENT is here to satisfy loadhigh when using netx"
EndOfCDX ends

_DATA	segment

	;byte "(c)John H. McCoy, 1996, csc_jhm@shsu.edu"

align 2

local_stack	word	192 dup ('ss')
DriveOfs	word	?, ?	; EAX, but low word is not needed
_ES		word	?
_DI		word	?
_SI		word	?
_BPignored	word	?
_SPignored	word	?
_BX		word	?
_DX		word	?
_CX		word	?
_AX		word	?
top_stack	equ	$

_FLAGS		word	?
_SP		word	?
_SS		word	?
DevHeader	fptr	?
DevStrategy	fptr	?
DevInterrupt	fptr	?
Old2F		fptr	?
FN1p		fptr	?
SAttrp		fptr	?
SDBp		fptr	?
DTApp		fptr	?
Tildes		word	0	; 0 truncate names, -1 append tilde

align 1

Active		byte	1	; 1 not active, 0 active, -ve nested
FirstDriveNo	byte	0
NoDrives	byte	MAXDRIVES
DriveNo 	byte	?
ChainFlag	byte	False


BP_ES		equ	 word ptr [bp+_ES-top_stack]
BP_DI		equ	 word ptr [bp+_DI-top_stack]
BP_BX		equ	 word ptr [bp+_BX-top_stack]
BP_DX		equ	 word ptr [bp+_DX-top_stack]
BP_CX		equ	 word ptr [bp+_CX-top_stack]
BP_AX		equ	 word ptr [bp+_AX-top_stack]
BP_SP		equ	dword ptr [bp+_SP-top_stack]
BP_FLAGS	equ	 word ptr [bp+_FLAGS-top_stack]
BP_FN1p 	equ	dword ptr [bp+FN1p-top_stack]
BP_SDBp 	equ	dword ptr [bp+SDBp-top_stack]
BP_DriveOfs	equ	 word ptr [bp+DriveOfs-top_stack]
BP_NoDrives	equ	 byte ptr [bp+NoDrives-top_stack]
BP_ChainFlag	equ	 byte ptr [bp+ChainFlag-top_stack]


rh_io	rhIOCTL    <<size rhIOCTL,,rhcmdIOCTL_IN,,>,,offset IoCB_MediaChange,2>
rh_rl	rhReadLong <<size rhReadLong,,rhcmdReadLong>>

; ioctl in control blocks

IoCB_MediaChange byte	 9
     MediaChange byte	 ?	; 0    don't know
				; 1    not changed
				; 0FFh media changed
if 0
IoCB_Status	byte	6	; ioctl get status subcommand
		dword	?	; status  bit 0  0 door closed
				;		 1 door open
				;	  bit 1  0 door locked
				;		 1 door unlocked
				;	  bit 4  0 data read only
				;		 1 data read and play audio
				;	  bit 7  0 no prefetching
				;		 1 supports prefetching
				;	  bit 9  0 HSG addressing only
				;		 1 HSG and RedBook audio addr
				;	  bit 11 1 no CD in drive (best guess)

; ioctl out control blocks

IoCB_EjectCD	byte	0	; ioctl out eject subcommand
  ; Note!!  It may be necessary to unlock a drive before the CD can be ejected.

IoCB_LockCD	byte	1	; ioctl out lock/unlock subcommand
		byte	1	; lock code

IoCB_UnLockCD	byte	1	; ioctl out lock/unlock subcommand
		byte	0	; unlock code
endif

CD_Table	word	CD_Number	; 00 Get number of CD-ROM drives
		word	CD_Device	; 01 Get CD-ROM drive device list
		word	CD_CAB		; 02 Get copyright file ID
		word	CD_CAB		; 03 Get abstract file ID
		word	CD_CAB		; 04 Get bibliographic file ID
		word	CD_VTOC 	; 05 Read VTOC
		word	CD_unsupported	; 06 Turn debugging on
		word	CD_unsupported	; 07 Turn debugging off
		word	CD_Read 	; 08 Absolute disk read
		word	CD_unsupported	; 09 Absolute disk write
		word	CD_unsupported	; 0A Reserved
		word	CD_Check	; 0B CDROM drive check
		word	CD_Version	; 0C MSCDEX version
		word	CD_Letters	; 0D Get CD-ROM drive letters
		word	CD_unsupported	; 0E Get/Set vol. descriptor preference
		word	CD_DirEntry	; 0F Get directory entry
		word	CD_Request	; 10 Send device request

_DATA	ends

_TEXT	segment

New2F	proc	far

	dec	cs:Active
	js	Chain

	; is this call for us?
	cmp	ah, REDIR
	je	TestInstall

	cmp	ah, MSCDEX
	je	Main

Chain:
	inc	cs:Active
	jmp	cs:Old2F		; chain out

	; Handle REDIR install checks now, others after saving regs
TestInstall:
	.if al == InstallChk
	  push	bp
	  mov	bp, sp
	  .if [bp].frame.fr_Parm1 == MSCDEX_Q
	    mov    [bp].frame.fr_Parm1, MSCDEX_R
	  .elseif bx == SMARTDRV_Q
	    mov    bx, SMARTDRV_R
	    push   cs
	    pop    es
	    mov    di, offset Drive
	    movzx  cx, cs:NoDrives
	  .endif
	  mov	al, 0ffh
	  pop	bp
	  jmp	Fexit
	.endif

Main:
	; save registers and switch to local stack
	push	ds
	push	bp
	mov	bp, sp
	mov	bp, [bp+2].frame.fr_Flags

	; set up data addressing
	push	cs
	pop	ds

	mov	_FLAGS, bp
	mov	_SP, sp
	mov	_SS, ss

	cli
	push	cs
	pop	ss
	mov	sp, top_stack
	;sti

	mov	bp, sp
	pusha
	push	es
	push	eax

	INVOKE	Main2F

	;  restore registers and switch back to callers stack
	pop	eax
	pop	es
	popa

	cli
	mov	sp, BP_FLAGS
	lss	bp, BP_SP

	mov	[bp+2].frame.fr_Flags, sp
	leave	; mov sp, bp; pop bp
	pop	ds
	;sti

	dec	cs:ChainFlag
	jz	Chain

Fexit:
	inc	cs:Active
	iret

New2F	endp

Main2F	proc	near

	mov	BP_ChainFlag, False
	cld

	.if ah == MSCDEX
	  ; Handle the MSCDEX calls
	  cmp	  al, 10h
	  ja	  CD_unsupported
	  cbw
	  add	  al, al
	  xchg	  bx, ax
	  jmp	  CD_Table[bx]
	.endif

	; handle redirector calls

	cmp	al, PathName		; called frequently enough to
	je	ChainExit		;  warrant the extra bytes
	mov	si, offset DoRead
	cmp	al, Read
	je	RD_Read
	cmp	al, Open
	je	RD_Open
	cmp	al, EOpen
	je	RD_EOpen
	mov	si, offset DoClose
	cmp	al, Close
	je	RD_Close
	mov	si, offset DoFindFirst
	cmp	al, FindFirst
	je	RD_FindFirst
	cmp	al, FindNext
	je	RD_FindNext
	mov	si, offset DoChDir
	cmp	al, ChDir
	je	RD_ChDir
	mov	si, offset DoGetAttr
	cmp	al, GetAttr
	je	RD_GetAttr
	cmp	al, GetSpace
	je	RD_GetSpace
	cmp	al, Seek
	je	RD_Seek

ChainExit:
	inc	BP_ChainFlag ;True	; just chain out. Novell doesn't like
	;jmp	MExit			; it if you call it an error
	ret


RD_Read label	near
RD_Close label	near
	call	RedirForUsSFT
	push	BP_ES
	push	di
	call	si
	jmp	AXExit

RD_GetAttr label near
RD_FindFirst label near
RD_ChDir label	near
	call	RedirForUsFN1
	call	si
	jmp	AXExit

RD_FindNext label near
	les	di, BP_SDBp		; get SDBp
	mov	al, byte ptr es:[di]	; SDBp->DriveLet (A - 0)
	call	RedirForUsFlag
	invoke	DoFindNext
	jmp	AXExit

RD_EOpen label	near
	call	RedirForUsFN1
	les	bx, BP_FN1p
	add	bx, 2e1h - 9eh		; extended open mode (in the SDA)
	test	byte ptr es:[bx-4], 2	; extended open action - replace
	jnz	no_open
	jmp	test_write

RD_Open label	near
	call	RedirForUsFN1
	les	bx, BP_SP
	add	bx, 2+frame.fr_Parm1	; open mode (on the stack)
test_write:
	test	byte ptr es:[bx], 1	; open for write
no_open:
	mov	al, 5
	jnz	ErrAL
	;invoke DoOpen, es::di
	push	BP_ES
	push	BP_DI
	call	DoOpen
	;jmp	AXExit

AXExit:
	mov	_AX, ax
MExit:
	ret


RedirForUsFN1:
	les	di, BP_FN1p
RedirForUsDrive:
	mov	al, es:[di+DriveOff]
	jmp	RedirForUs

RedirForUsSFT:
	mov	ax, es:[di].SFT.Flags
RedirForUsFlag:
	test	al, 40h 		; redir not network when set
	jz	NotForUs		; not for us, chain out
	and	al, 05fh		; this part is actual drive letter
	inc	ax
RedirForUs:
	invoke	ForUs, al
	cmp	ax, 1
	;jb	@F
	jb	MExit
NotForUs:
	pop	ax			; Discard return address
	je	ChainExit
	jmp	Err15			; drive not ready
;@@:
	;ret


RD_GetSpace label near
	call	RedirForUsDrive 	; es:di is curr CDSp
	;invoke DoGetSpace
	mov	bx, BP_DriveOfs
if VARBLKSIZE
	mov	ax, [bx+DrvEnt.BlkSize]
	mov	_CX, ax 		; # bytes/sector
else
	mov	BP_CX, 2048
endif
	sub	ax, ax
	mov	_DX, ax 		; # clusters available
	cmp	word ptr [bx+DrvEnt.VolSize+2], ax
	jnz	@F
	mov	ax, word ptr [bx+DrvEnt.VolSize]
	db	0b1h  ; mov cl, nn
      @@:
	dec	ax
	mov	_BX, ax 		; # clusters on drive
	mov	ax, 1			; # sectors/cluster & Media ID
	jmp	AXNCExit


CD_DirEntry label near			; 0Fh Get Directory Entry
	cmp	cl, 0ffh		; Extra function to toggle tilde usage
	je	Tilde
	test	ch, 1			; Canonical entry not supported
	jnz	Err01
	call	SetForUs		; sets DriveNo, DriveOfs, ES, BX
	invoke	GetDirEntry, si::di, es::bx
	jmp	AXExit
Tilde:
	cmp	ch, 1
	ja	Err01
	je	set
	mov	ax, Tildes
	jmp	AXNCExit
set:
	mov	Tildes, ax		; Trust the user for the correct value
	jmp	NCExit


SetForUs:
	add	cl, 'A'
	;invoke ForUs, cl		; sets DriveNo and DriveOfs
	push	cx
	call	ForUs
	.if !ax
	  mov	  es, BP_ES
	  mov	  bx, BP_BX
	  ret
	.endif
	pop	ax			; Discard return address
Err0F:
	mov	al, 0fh 		; invalid drive
	db	0b9h			; B9 nn nn = mov cx,nnnn
Err15:
	mov	al, 15h 		; drive not ready
	db	0b9h
CD_unsupported label near
Err01:
	mov	al, 01h
ErrAL:
	cbw
	or	BP_FLAGS, 01h
	jmp	AXExit


CD_Request label near			; 10h device request
	add	cl, 'A'
	;invoke SetDDD, cl		; sets DriveNo and DriveOfs
	push	cx
	call	SetDDD
	test	ax, ax
	jz	Err0F
	mov	bx, BP_BX		; restore rh ptr
	;mov	es, BP_ES		; SetDDD doesn't use it
	push	es
	push	bx
	call	DDCall
	pop	bx
	pop	es
	.if es:rh.Command[bx] == rhcmdIOCTL_In	; on some drives we
	  les	  bx, es:rhIOCTL.CBPtr[bx]	; will miss media change
	  mov	  ax, es:[bx]			; if direct access checks
	  .if al == 09h 			; so, if media has changed
	    .if ah != 1 			; set type to unknown to
	      mov     bx, DriveOfs		; force re-read on next
	      mov     [bx+DrvEnt.Type], CDUNKNOWN ; non-direct access
	    .endif
	  .endif
	.endif
	jmp	NCExit			; A Ok from our perspective

CD_Read label	near			; 08h Absolute disk read
	call	SetForUs		; sets DriveNo and DriveOfs, ES, BX
	mov	ax, _DX
	.if ax != 0
	  invoke  CdReadLong, es::bx, si::di, ax
	  cmp	  ax, 100h		; normal device done
	  jne	  Err15 		; drive not ready
	.endif
	sub	ax, ax
	jmp	AXNCExit

CD_VTOC label	near			; 05 Read VTOC
	call	SetForUs		; sets DriveNo and DriveOfs, ES, BX
	mov	ax, _DX
	add	al, 10h 		; assume sector index < 240
	invoke	CdReadLong, es::bx, ax, 1
	cmp	ax, 100h		; normal device done
	jne	Err15			; drive not ready
	mov	si, BP_DriveOfs
	movzx	si, [si+DrvEnt.Type]	; assume known
	xor	si, 25			; 24 -> 1, 25 -> 0
	shl	si, 3			; ISO9660 -> 0, HS -> 8
	movzx	ax, byte ptr es:[bx+si] ; Volume descriptor ID
	.if al != 1 && al != 0ffh	; Primary & Terminator ID's return
	  sub	  al, al		;  themselves; zero for everything else
	.endif
	jmp	AXNCExit

CD_Check label	near			; 0Bh CDROM check
	mov	BP_BX, MSCDEX_R
	add	cl, 'A'
	;invoke SetDDD, cl		; Returns AX = 0 if not supported,
	push	cx			;  non-zero if supported
	call	SetDDD
	;jmp	AXNCExit

AXNCExit:
	mov	_AX, ax
NCExit:
	and	BP_FLAGS, 0FFFEh
	;jmp	MExit
	ret

CD_Number label near			; 00h get number of drive letters
	mov	al, NoDrives
	cbw
	mov	_BX, ax
	mov	al, FirstDriveNo
	mov	_CX, ax
	jmp	NCExit

CD_Device label near			; 01h get drive device list
	mov	si, offset Drive
	xchg	di, ax
	movzx	cx, BP_NoDrives
	@@:
	  mov	  al, [si+DrvEnt.Unit]
	  stosb
	  ;mov	  eax, dword ptr [si+DrvEnt.DevHdrp]
	  ;stosd
	  movsd   ; DevHdrp is first
	  add	  si, sizeof DrvEnt - 4
	loop	@B
	jmp	NCExit

CD_CAB	label	near			; 02h Get copyright file name
	call	SetForUs		; 03h Get abstract file name
	;invoke GetCABID, _AL, es::bx	; 04h Get biblio file name
	push	BP_AX
	push	es
	push	bx
	call	GetCABID
	jmp	NCExit

CD_Version label near			; 0Ch MSCDEX version
	mov	BP_BX, 0216h		; report ver 2.22
	jmp	NCExit

CD_Letters label near			; 0Dh drive letters
	mov	si, offset Drive.No
	xchg	di, ax
	movzx	cx, BP_NoDrives
	@@:
	  movsb
	  add	  si, sizeof DrvEnt - 1
	loop	@B
	jmp	NCExit

RD_Seek label	near
	call	RedirForUsSFT
	mov	es, BP_ES
	mov	eax, es:[di+SFT.FilSiz]
	add	eax, dword ptr BP_DX	; CX:DX
	push	eax
	pop	ax
	pop	BP_DX
	jmp	AXNCExit

Main2F	endp


DDCall	proc	near uses ds si 	; in case device driver wiped out ds
	mov	si, DriveOfs
	mov	eax, dword ptr [si+DrvEnt.Strategyp]
	mov	dword ptr DevStrategy, eax
	mov	eax, dword ptr [si+DrvEnt.Interruptp]
	mov	dword ptr DevInterrupt, eax
	mov	al, [si+DrvEnt.Unit]
	mov	es:rh.SubUnit[bx], al
	call	DevStrategy
	call	cs:DevInterrupt
	ret
DDCall	endp


CdReadBlk proc	near PASCAL BlkNo:dword
	mov	bx, DriveOfs
	mov	eax, [bx+DrvEnt.BufBlkNo]
	sub	eax, BlkNo
	jz	@F
	;invoke CdReadLong ds::[bx+DrvEnt.Bufp], BlkNo, 1
	push	ds
	push	[bx+DrvEnt.Bufp]
	push	BlkNo
	push	1
	call	CdReadLong
	sub	ax, 100h
	push	ax
	mov	eax, BlkNo
	.if !ZERO?
	  or	  eax, -1
	.endif
	mov	[bx+DrvEnt.BufBlkNo], eax
	pop	ax
@@:
	ret
CdReadBlk   endp


CdReadLong proc near PASCAL uses es bx di, IOBufp:fptr,BlkNo:dword,NumBlks:word
	push	ds
	pop	es
	mov	bx, offset rh_rl
	mov	eax, IOBufp
	mov	rhReadLong.Bufp[bx], eax
	mov	eax, BlkNo
	mov	rhReadLong.StartBlk[bx], eax
	mov	ax, NumBlks
	mov	rhReadLong.Count[bx], ax
	;xor	ax, ax				; zero for
	;mov	rhReadLong.AddrMode[bx], al	; hsc addressing
	;mov	rhReadLong.ReadMode[bx], al	; cooked mode
	;mov	word ptr rhReadLong.ISize[bx], ax
	;mov	rhReadLong.ISkip[bx], al
	call	DDCall
	mov	ax, rh_rl.Header.status
	ret
CdReadLong endp

CdMediaChanged proc near PASCAL uses di
	push	ds
	pop	es
	mov	bx, offset rh_io
	call	DDCall
	mov	al, MediaChange
	cbw
	ret
CdMediaChanged	endp


ToIBM	proc	near PASCAL uses di,IBMName:nptr,FIDLen:word,Chp:fptr,hint:word
; This is optimised for speed as much as size.
	mov	bx, IBMName		; The name is blank-padded
	mov	eax, '    '
	mov	[bx], eax
	mov	[bx+4], eax
	mov	[bx+7], eax

	mov	cx, FIDLen		; Names of 0h and 1h are the
	les	di, Chp 		;  current and parent directories
	cmp	cl, 1
	mov	al, es:[di]
	jne	notspecial
	cmp	al, cl
	jbe	special

notspecial:
	.if al == '.'                   ; Ignore a leading dot (no name
	  inc	  di			;  portion) - this may cause
	  dec	  cx			;  non-unique names
	.endif

	mov	ah, 8			; Copy up to eight characters
	call	IBMCopy 		;  for the name
	jnc	ext			; Found the dot
	cmp	byte ptr es:[di], '.'   ; Is the ninth char. the dot?
	je	fext

	mov	ax, hint		; Assume < 2560
	and	ax, Tildes		; Append a tilde
	jz	fext			;  or not
	mov	dl, 10			; Decimal
@@:
	div	dl
	dec	bx
	add	ah, '0'
	mov	[bx], ah
	and	ax, 00ffh
	jnz	@B
	mov	byte ptr [bx-1], '~'
fext:
	mov	al, es:[di]		; Skip remaining name characters
	inc	di
	cmp	al, '.'
	je	ext
	cmp	al, ';'
	je	done
	dec	cx
	jnz	fext
	jmp	done

special:
	mov	al, '.'                 ; "." for current directory
	jb	@F
	mov	ah, al			;  and ".." for parent
@@:
	mov	[bx], ax
	jmp	done

ext:
	mov	bx, IBMName
	dec	cx
	mov	ah, 3			; Copy three characters
	add	bx, 8			;  for the extension
	call	IBMCopy
done:
IBMDone label	near
	ret
ToIBM	endp

IBMcopy proc	near
	mov	al, es:[di]		; Copy characters, stopping at the
	inc	di			;  dot or semi-colon
	cmp	al, '.'
	je	done
	cmp	al, ';'
	je	fin
	cmp	al, 'a'
	jae	upper
store:
	mov	[bx], al
	inc	bx
	dec	cx
	jz	fin
	dec	ah
	jnz	IBMCopy
	stc
done:					; CY = reached limit, NC = found dot
	ret
upper:
	cmp	al, 'z'
	ja	store
	and	al, 0dfh
	jmp	store
fin:
	pop	ax			; Discard return address
	jmp	IBMDone 		; Return from ToIBM
IBMCopy endp

Match	proc	near PASCAL uses si di, Namep:nptr, TemPlate:nptr
; This is optimised more for speed, than size.
	mov	si, TemPlate
	mov	di, NameP
	mov	ax, 11			; Return code - non-0 failed, 0 matched
	sub	bx, bx			; Position
	mov	dl, 1			; Increment
	cmp	byte ptr [si], '?'      ; If it starts with a question mark
	jne	m1			;  go backwards
	mov	bl, 10
	mov	dl, -1
m1:
	mov	dh, [si+bx]
	cmp	dh, '?'
	je	@F
	cmp	[di+bx], dh
	jne	done
@@:
	add	bl, dl
	dec	ax
	jnz	m1
done:
	ret
Match	endp

_TEXT	ends

_INIT	  segment

if 0
ToHex	     proc near PASCAL public uses ax bx cx dx, Num:word
      mov   cl, 4
      mov   ch, 4
      mov   ah, 02h
      mov   dx, Num
      .while ch > 0
	  rol	dx, cl
	  mov	bx, dx
	  and	dx, 0fh
	  .if dl < 0Ah
	      add  dl, '0'
	  .else
	      add  dl, 'A' - 0Ah
	  .endif
	  int	21h
	  mov	dx, bx
	  dec	ch
      .endw
      ret
ToHex	 endp
endif


; set up for one drive minimum
; drive table, cache and buffers are set up dynamically here at run time

align 2
Drive		  DrvEnt   1 dup (<>)	      ;MAXDRIVES dup (<>)
_DirCache	  DirEnt   CACHESIZE dup (<>) ;MAXDRIVES*CACHESIZE dup (<>)
_IOData 	  byte	   SECTORSIZE dup('B')

; insert filler so we don't wipe out INIT when we init drive table and
;   link up dir cache

if (MAXDRIVES-1)*(sizeof DrvEnt+CACHESIZE*sizeof DirEnt)-SECTORSIZE GT 0
 byte (MAXDRIVES-1)*(sizeof DrvEnt+CACHESIZE*sizeof DirEnt)-SECTORSIZE dup (0)
endif

;============================================================================
;  everything below this line is discarded after installing
;    the redirector

;     MSC pacifier

     PUBLIC C  _acrtused

_acrtused     dw    1

; Credits

CopyrightMsg   byte    cr, lf
	       byte    'SHSUCDX Version 2.0',cr,lf
	       byte    '(c)John H. McCoy, October 2000, '
	       byte    'Sam Houston State University',cr,lf
	       byte    '   Jason Hood, June 2003'
	       byte    cr,lf, '$'

DrivesAssigned byte    cr, lf
	       byte    "SHSUCDX Installed.",cr,lf
	       byte    "  Drives Assigned",cr,lf
	       byte    "Drive  Driver   Unit",cr,lf,'$'

UnInstalledMsg byte    cr, lf
	       byte    'SHSUCDX un-installed and memory freed.'
	       byte    cr, lf, '$'

CantUnInstallMsg  byte	  cr, lf
		  byte	  'SHSUCDX can''t un-install.'
		  byte	  cr, lf, '$'

CantInstallMsg byte    '  SHSUCDX can''t install.',cr,lf,'$'

AlreadyInstalledMsg  byte   cr, lf, 'SHSUCDX or MSCDEX is already installed.$'

NoDrivesAvailMsg  byte	cr, lf,'Need More Drive Letters.$'

HighDriveMsg	byte	cr, lf,'Drive letter too high.$'

HighUnitMsg    byte    cr, lf,'Units specified don''t exist.$'

WrongDOSMsg    byte    cr, lf,'Must be DOS 3.3 - 7.xx.$'

CantFindCdMsg  byte    'Can''t open CD driver $'

NotEnoughMemMsg byte   'Not enough memory.  $'

CRLF	       byte    cr, lf, '$'


DrvrEnt        struct
   Name        byte    'SHSU-CDN'
	       byte    0
   DrvrAddr    fptr    ?
   Drive       byte    0
   Unit        byte    0
   NoWanted    byte    0
DrvrEnt        ends

NoDrivers	 byte	 ?
Drivers 	 DrvrEnt  MAXDRIVES dup (<>)  ; one driver per drive is max
DriverIndex	 byte	  ?
DeviceUnit	 byte	  ?
DriveIndex	 byte	  ?
FirstDeviceUnit  byte	  ?
NoDeviceUnits	 byte	  ?
NoAvailUnits	 byte	  ?
NoUnitsWanted	 byte	  ?
LastDOSDrive	 byte	  ?	 ; 1 base
KeepSize	 word	  ?
_PSP		 word	  ?
HighMem 	 word	  ?
IODatap 	 word	  _IOData
DirCachep	 word	  _DirCache
CDSBase 	 fptr	  ?
CDSp		 fptr	  ?	 ; must be recalced for current drive
CDSLen		 word	  ?	 ; for this DOS version

ArgumentNotFound EQU	 2	 ; Unrecognized argument
NoArgumentsFound EQU	 1	 ; No argument in command line
ArgumentFound	 EQU	 0	 ; Ok argument in command line

SetTilde	 equ	 4
UnInstallIt	 equ	 2
DontInstallIt	 equ	 1
InstallIt	 equ	 0

InstallFlag	 byte	 0
QuietFlag	 word	 0

DosVer		 label	  word
   osMajor	 byte	  ?
   osMinor	 byte	  ?
IoctlInBuf	 byte	  5 dup (0)	 ; get devhdr addr
IoctlOutBuf	 byte	  2		 ; reset CD

MsgOut	  proc	near PASCAL public uses ax bx dx, msg:near ptr char
      mov      ah, 02h	     ; display ch function
      mov      bx, msg
      mov      dl, ds:[bx]
      .while (dl != '$' && dl != 0)
	 int	  21h
	 inc	  bx
	 mov	  dl, ds:[bx]
      .endw
      ret
MsgOut	  endp

DisplayDrives	  proc near
      invoke MsgOut, addr DrivesAssigned
      sub      si, si
      sub      cx, cx
      .while (cl < cs:NoDrives)
	 mov	  ah, 02h	; display ch function
	 mov   dl, ' '
	 int	  21h
	 int	  21h
	 mov   dl, byte ptr [si+Drive.Letter]
	 int	  21h
	 mov   dl, ':'
	 int	  21h
	 mov   dl, ' '
	 int	  21h
	 int	  21h
	 int	  21h
	 sub   bx, bx
	 .while (bx < 8)
	    mov      dl, [si+bx+Drive.DriverName]
	    int      21h	; output driver name
	    inc      bx
	 .endw
	 mov   dl, ' '
	 int	  21h
	 int	  21h
	 mov   dl, byte ptr [si+Drive.Unit]
	 .if (dl > 9)		 ; output drive unit
	    xor   dh,dh
	    .while (dl > 9)
	       inc  dh
	       sub  dl, 10
	    .endw
	    xchg    dl, dh
	    add     dl, 30h
	    int     21h 	 ; tens digit
	    xchg    dl, dh
	  .endif
	 add   dl, 30h
	 int	  21h		 ; units digit
	 add   si, sizeof DrvEnt
	 inc   cl
	 invoke MsgOut, addr CRLF
      .endw
	    ret
DisplayDrives  endp

SetRoot     proc near PASCAL uses es ax bx cx di si , CDSx: fptr
	    les   bx, CDSx
	    mov   ax, 0C080h		  ; set physical network & redir bits
	    mov   es:[bx].CDS.Flags, ax
       ; we don't set redirector address.  Should we???
       ; we do now 10-2000
	    mov   word ptr es:[bx].CDS.Redir,offset New2F
	    mov   word ptr es:[bx].CDS.Redir+2,cs
	    mov   es:[bx].CDS.RootOff,RootSlashOff ; root \ in curr_path
       ; Set to CDS to CD root form \\D.\U.
	    mov   al, '\'
	    mov   es:[bx].CDS.CurrPath, al
	    mov   es:[bx+1].CDS.CurrPath, al
	    mov   al, DriveNo
	    add   al, 'A'
	    mov   es:[bx+2].CDS.CurrPath, al
	    mov   al, '.'
	    mov   es:[bx+3].CDS.CurrPath, al
	    mov   al, '\'
	    mov   es:[bx+4].CDS.CurrPath, al
	    mov   al, DeviceUnit
	    add   al, 'A'
	    mov   es:[bx+5].CDS.CurrPath, al
	    mov   al, '.'
	    mov   es:[bx+6].CDS.CurrPath, al
	    mov   al, 0
	    mov   es:[bx+7].CDS.CurrPath, al
	    mov    ax, sizeof DrvEnt
	    mul    DriveIndex
	    mov    bx, ax
	    mov    al, DriveNo
	    mov    [bx+Drive.No], al
	    add    al, 'A'
	    mov    [bx+Drive.Letter], al
	    mov    al, DeviceUnit
	    mov    [bx+Drive.Unit], al
	    mov    ax, word ptr DevHeader
	    mov    word ptr [bx+Drive.DevHdrp], ax
	    mov    ax, word ptr DevHeader+2
	    mov    word ptr [bx+Drive.DevHdrp+2], ax
	    mov    word ptr [bx+Drive.Strategyp+2], ax
	    mov    word ptr [bx+Drive.Interruptp+2], ax
	    mov    ax, word ptr DevStrategy
	    mov    word ptr [bx+Drive.Strategyp], ax
	    mov    ax, word ptr DevInterrupt
	    mov    word ptr [bx+Drive.Interruptp], ax
	    lea    di, [bx+Drive.DriverName]
	    mov    ax, ds
	    mov    es, ax
	    lea    si, [si+Drivers.Name]
	    mov    cx, 4
	    cld
	    rep movsw		    ; ds:si->es:di
	    ret
SetRoot     endp

ClrRoot     proc near uses ds es bx ax cx dx si
; Enter with: CX = NoDrives
;	      ES:DI -> Drive
       lea	si, [di+DrvEnt.No]
       push	es
       pop	ds
       @@B:
	   lodsb
	   cbw
	   push  ax
	   mul	 cs:CDSLen
	   pop	 dx
	   les	 bx, cs:CDSBase
	   add	 bx, ax
	   test  es:[bx].CDS.Flags, 0C080h    ; physical net redir drive ?
	   jz	 @F			      ; couldn't be our drive
	   sub	 ax, ax
	   mov	 es:[bx].CDS.Flags, ax	      ; clear drive flags
	   mov	 eax, '\:A'
	   add	 al, dl
	   mov	 dword ptr es:[bx].CDS.CurrPath, eax
       @@: add	 si, sizeof DrvEnt - 1
       loop @@B
       ret
ClrRoot     endp

InitDrive   proc near PASCAL uses ax bx di si es
   local    DirEntryp:nptr
   local    Bufp:nptr
   local    Ticks:word

   ; fill in drive entry first
      mov   ax, 0040h		  ; get clock ticks from 0040006Ch
      mov   es, ax
      mov   ax, es:[06Ch]
      mov   Ticks, ax
      push  ds
      pop   es
      mov   al, DriveIndex
      cbw
      mov   bx, SectorSize
      mul   bx
      add   ax, word ptr IODatap
      mov   Bufp, ax		  ; addr of buffer for this drive
      mov   al, DriveIndex
      cbw
      mov   bx, CACHESIZE
      mul   bx
      mov   bx, sizeof DirEnt
      mul   bx
      add   ax, DirCachep	  ; DirCache base ptr
      mov   DirEntryp, ax	  ; addr of first cache entry for this drive
      mov   ax, sizeof DrvEnt	  ; assume < 256
      mul   DriveIndex
      add   ax, offset Drive
      mov   bx, ax
      mov   ax, Bufp
      mov   [bx + DrvEnt.Bufp], ax
      mov   al, CDUNKNOWN
      mov   DrvEnt.Type[bx], al
      mov   ax, 0FFFFh
      mov   word ptr DrvEnt.BufBlkNo[bx], ax
      mov   word ptr DrvEnt.BufBlkNo[bx+2], ax
      mov   ax, Ticks
      mov   DrvEnt.LastAccess[bx], ax
   ; link up cache for dir entries
      mov   ax, DirEntryp
      mov   DrvEnt.RootEnt.Forw[bx], ax
      mov   di, ax
      mov   si, ax
      add   si, sizeof DirEnt
      mov   DirEnt.Forw[di], si
      lea   ax, DrvEnt.RootEnt[bx]
      mov   DirEnt.Back[di], ax
      mov   cx, CACHESIZE
      dec   cx
      .while (cx > 0)
	 mov   DirEnt.Back[si], di
	 mov   di, si
	 add   si, sizeof DirEnt
	 mov   DirEnt.Forw[di], si
	 dec   cx
      .endw
      lea   ax, DrvEnt.RootEnt[bx]
      mov   DirEnt.Forw[di], ax 	  ; last entry points forw to root
      mov   DrvEnt.RootEnt.Back[bx], di   ; root points back to last entry

      ret
InitDrive   endp

Init:  PUBLIC Init

   ;  set DS for addressing, move stack and save our psp address
      mov      ax, cs
      mov      ds, ax
      mov      ss, ax
      mov      sp, top_stack
      mov      _PSP, es
      mov      HighMem, ax

   ;  get command line parameters
      invoke ParseCommandLine

   ;  get DOS version
      mov      ah, 30h
      int      21h
      mov      DosVer, ax

   ;  get list of lists address thereby getting DOS seg
      mov      ah, 52h
      int      21h			  ; es:bx is LOLp
      mov      word ptr DTApp+2, es	  ; set seg of DOS ptrs
      mov      word ptr FN1p+2, es
      mov      word ptr SDBp+2, es
      mov      word ptr SAttrp+2, es
      mov      ax, word ptr es:[bx].DOS_LOL.CDS
      mov      word ptr CDSBase, ax
      mov      ax, word ptr es:[bx].DOS_LOL.CDS+2
      mov      word ptr CDSBase+2, ax

   ;  set version specific DOS parameters
      .if osMajor == 3 && osMinor >= 30
	 mov	  CDSLen, 51h
	 mov	  si, 02ceh		       ; version 3.3+ offset
	 mov	  ax, si
	 add	  ax, 0ch
	 mov	  word ptr DTApp, ax
	 mov	  ax, si
	 add	  ax, 92h
	 mov	  word ptr FN1p, ax
	 mov	  ax, si
	 add	  ax, 192h
	 mov	  word ptr SDBp, ax
	 mov	  ax, si
	 add	  ax, 23ah
	 mov	  word ptr SAttrp, ax

      .elseif  osMajor >= 4	  ; assume subsequent versions are the same
	 mov	  CDSLen, 58h	  ; offsets for version 4+
	 mov	  si, 0320h
	 mov	  ax, si
	 add	  ax, 0ch
	 mov	  word ptr DTApp, ax
	 mov	  ax, si
	 add	  ax, 9eh
	 mov	  word ptr FN1p, ax
	 mov	  ax, si
	 add	  ax, 19eh
	 mov	  word ptr SDBp, ax
	 mov	  ax, si
	 add	  ax, 24dh
	 mov	  word ptr SAttrp, ax
      .else
	 jmp	  WrongDOS
      .endif

      .if (InstallFlag == UnInstallIt)
	 jmp   UnInstall
      .endif

   ;  see if we are already installed
      mov      ax, MSCDEX_Q
      push     ax
      mov      ah, REDIR
      mov      al, InstallChk
      int      2fh
      pop      bx
      .if al == 0ffh	    ; redir installed, is it MSCDEX?
	 .if bx == MSCDEX_R
	    .if InstallFlag == SetTilde
	       jmp   InitExit
	    .else
	       jmp   AlreadyInstalled
	    .endif
	 .endif
      .endif

   ;  take advantage of the photo op

      invoke MsgOut, addr CopyrightMsg

   ; find last available drive letter
      mov      ch, es:[bx].DOS_LOL.LastDrive
      dec      ch		   ; lol use 1 for 'A'
      mov      LastDOSDrive, ch

    ; assign drives
      sub      ax, ax
      mov      DriveIndex, al
      mov      DriverIndex, al
      mov      DriveNo, al
      mov      ah, NoDrivers
      .while  (al < ah) 	       ; while DriverIndex < (NoDrivers)
      ; Open device driver and use IOCTL Input sub-command 0 to get
      ;   the device header address.
	 mov	  ax, sizeof DrvrEnt
	 mul	  DriverIndex
	 add	  ax, offset Drivers.Name
	 mov	  dx, ax
	 sub	  al, al		     ; read only
	 mov	  ah, 3Dh
	 int	  21h
	 jnc	  @f			     ; error when carry set
	 jmp	  CantFindCd
      @@:mov	  bx, ax		     ; move handle to bx
	 mov	  ax, 4402h		     ; IOCTL input-get devhdr addr
	 mov	  cx, 5 		     ; dta has cmd code plus a fptr
	 lea	  dx, IoctlInBuf	     ;	 to device header
	 int	  21h
;	 mov	  ax, 4403h		     ; IOCTL output-reset CD
;	 mov	  cx, 1 		     ; dta has cmd code only (1 byte)
;	 lea	  dx, IoctlOutBuf	     ;	 to device header
;	 int	  21h
	 mov	  ah, 3eh		     ; close file handle in bx
	 int	  21h
	 jnc	  @f			     ; error when carry set
	 jmp	  CantFindCd
      @@:
	 les	  bx, dword ptr IoctlInBuf+1
	 mov	  word ptr DevHeader, bx
	 mov	  word ptr DevHeader+2, es
	 mov	  ax, es:[bx+6]
	 mov	  word ptr DevStrategy, ax
	 mov	  word ptr DevStrategy+2, es
	 mov	  ax, es:[bx+8]
	 mov	  word ptr DevInterrupt, ax
	 mov	  word ptr DevInterrupt+2, es
	 mov	  ax, sizeof DrvrEnt
	 mul	  DriverIndex
	 mov	  si, ax
	 mov	  al, [si + Drivers.Unit]	; first unit wanted
	 mov	  ah, es:[bx+21]
	 mov	  NoDeviceUnits, ah
	.if  (ah <= al)
	     invoke MsgOut, addr HighUnitMsg
	     jmp InitErrorExit
	 .endif
	 sub	  ah, al
	 mov	  NoAvailUnits, ah
	 mov	  DeviceUnit, al
	 mov	  al, [si + Drivers.NoWanted]	; units asked for
	 .if (al == 0) || ( al > NoAvailUnits)
	    mov   al, NoAvailUnits
	 .endif
	 mov	  NoUnitsWanted, al
	 mov	  cl,[si + Drivers.Drive]
	 .if  (cl < DriveNo)
	     mov  cl, DriveNo
	 .endif
	 mov	  DriveNo, cl
	 mov	  ah, DriveIndex
     ; ah is DriveIndex   al is NoUnitsWanted
	 .while (ah < MAXDRIVES) && (al > 0)
	    mov      cl, DriveNo
	    call     FindAvailDrive	  ; also sets CDSp for us
	    .if  (cl != ch)
	       invoke MsgOut, addr NoDrivesAvailMsg
	       jmp  InitErrorExit
	    .endif
	    mov      DriveNo, cl
	    invoke SetRoot,CDSp 	  ; uses CDSp, DevHeader, DriveIndex,
					  ; DriveNo and DeviceUnit
	    inc     DriveIndex
	    inc     DriveNo
	    inc     DeviceUnit
	    dec     NoUnitsWanted
	    mov      ah, DriveIndex
	    mov      al, NoUnitsWanted
	 .endw
	 inc	  DriverIndex
	 mov	  al, DriverIndex
	 mov	  ah, NoDrivers
      .endw

      mov   al, DriveIndex
      .if (al == 0)		   ; then no drives were assigned
	 invoke MsgOut, addr HighDriveMsg
	 jmp   InitErrorexit
      .endif
      mov      NoDrives, al

  ;  relocate buffers and init drive structs
      mov      cx, sizeof DrvEnt      ; find Drive Table space needed
      mov      al, NoDrives
      cbw
      mul      cx
      add      ax, offset Drive
      mov      DirCachep, ax	      ; relocate dir cache
      mov      cx, CACHESIZE	      ; find cache space needed
      mov      al, NoDrives
      cbw
      mul      cx
      mov      cx, ax
      mov      ax, sizeof DirEnt
      mul      cx
      add      ax, DirCachep
      mov      IODatap, ax	      ; relocate IOData buffers
      mov      cx, SECTORSIZE	      ; find buffer space needed
      mov      al, NoDrives
      cbw
      mul      cx
      add      ax, IODatap	      ; last byte to keep now in ax
      add      ax, 10Fh 	      ; add 100h for psp and roundup
      mov      cl, 4
      shr      ax, cl		      ; program paragraphs to keep
      mov      KeepSize, ax

  ;  get more space if we need it for buffers
      mov     bx, seg EndOfCDX
      sub     bx, _PSP
      .if     ax > bx
	  mov  bx, ax
	  mov  es, _PSP
	  mov  ah, 04Ah       ; modify block size
	  int  21h
	  jnc  @F
	     invoke MsgOut, addr NotEnoughMemMsg
	     jmp InitErrorExit
       @@:
       .endif

  ;  initialize drive table and link up dir cache

      xor      al, al
      mov      ah, NoDrives
      mov      DriveIndex, 0
      .while   al < ah
	 invoke InitDrive
	 inc DriveIndex
	 inc al
      .endw


  ;  Display drive assignments

      mov      al, Drive.No[0]
      mov      FirstDriveNo, al
      invoke DisplayDrives

  ;  store original 2F vector

      mov      ax, 352Fh
      int      21h
      mov      word ptr Old2F, bx
      mov      word ptr Old2F[2], es

  ;  try and allocate high memory

      mov      ax, 5802h	      ; get current UMB state
      int      21h
      push     ax		      ; save it
      mov      ax, 5800h	      ; get current allocation strategy
      int      21h
      push     ax		      ; save it
      mov      bx, 1		      ; link in UMB
      mov      ax, 5803h
      int      21h
      mov      bx, 40h		      ; high memory, first fit
      mov      ax, 5801h
      int      21h
      mov      bx, KeepSize
      sub      bx, 10h		      ; discount PSP
      mov      ah, 48h
      int      21h
      jc       @F		      ; none available
      mov      HighMem, ax
      dec      ax		      ; MCB of TSR
      mov      es, ax
      inc      ax
      mov      es:[1], ax	      ; make it own itself
      push     ds
      mov      ax, _PSP
      dec      ax		      ; MCB of installer
      mov      ds, ax
      mov      si, 8		      ; copy the MCB name
      mov      di, si
      mov      cx, si
      rep      movsb
      pop      ds
      mov      es, HighMem	      ; copy to the high memory
      sub      si, si
      mov      di, si
      mov      cx, KeepSize	      ; paragraphs
      sub      cx, 10h		      ; discount PSP
      shl      cx, 3		      ; * 8 = words
      rep      movsw
  @@:
      pop      bx		      ; restore allocation strategy
      mov      ax, 5801h
      int      21h
      pop      bx		      ; restore UMB state
      mov      ax, 5803h
      int      21h

  ;  set new 2F vector

      push     ds
      mov      ds, HighMem
      mov      dx, offset New2F
      mov      ax, 252Fh
      int      21h
      mov      word ptr rh_io.CBPtr+2, ds
      pop      ds

 ;  release excess space and tsr

      cmp      HighMem, 0A000h
      jae      @Exit

      mov      es, _PSP
      sub      ax, ax
      xchg     ax, es:[2Ch]	      ; zap evironment pointer in psp
      or       ax, ax		      ; ax := environment ptr
      jz       @f		      ; no environment if zero
      mov      es, ax
      mov      ah, 49h
      int      21h		      ; and release environment
  @@:
      mov      dx, KeepSize
      mov      ax, 3100h
      int      21h		      ; go TSR
  @Exit:
      mov      ax, 4c00h	      ; emergency exit in case we don't TSR
      int      21h

UnInstall:
      mov   bx, SMARTDRV_Q
      mov   ah, REDIR
      mov   al, InstallChk
      int   2fh
      cmp   bx, SMARTDRV_R
      jne   CantUnInstall
      push  es
      mov   ax, 352fh		    ; check if the vector is still ours
      int   21h
      pop   ax
      mov   dx, es
      cmp   ax, dx
      jne   CantUnInstall
      cmp   bx, offset New2F
      jne   CantUnInstall
      mov   es, ax
      invoke ClrRoot
      push  ds
      lds   dx, es:Old2F	    ; restore vector
      mov   ax, 252Fh
      int   21h
      pop   ds
      mov   ax, es
      .if ax < 0A000h		    ; not in high memory?
	 sub ax, 10h		    ; point back to the PSP
	 mov es, ax
      .endif
      mov   ah, 49h		    ; free memory
      int   21h
      invoke MsgOut, addr UnInstalledMsg
      jmp   Initexit

CantUnInstall:
      invoke MsgOut, addr CantUnInstallMsg
      jmp   Initexit

AlreadyInstalled:
      invoke MsgOut, addr AlreadyInstalledMsg
      invoke MsgOut, addr CantInstallMsg
      jmp   Initexit

CantFindCd:
      invoke MsgOut, addr CantFindCdMsg
      mov      ax, sizeof DrvrEnt
      mul      DriverIndex
      add      ax, offset Drivers.Name
      invoke MsgOut, ax
      invoke MsgOut, addr CRLF
      jmp   InitErrorExit

WrongDOS:
      invoke MsgOut, addr WrongDOSMsg
      invoke MsgOut, addr CantInstallMsg
      jmp   InitExit

InitErrorExit:
   .if DriveIndex > 0
      movzx    cx, DriveIndex
      mov      di, offset Drive
      push     ds
      pop      es
      invoke ClrRoot
   .endif
   invoke MsgOut, addr CantInstallMsg
   jmp	 InitExit

InitExit:
   mov	 ah,4ch 		    ; normal terminate
   int	 21h

FindAvailDrive	       proc near uses es bx

;  Finds first available drive letter.
;
;  Entry     cl     Starting letter for search
;
;  Exit      cl == ch	Drive in cl is available
;	     cl != ch	No drive available starting at specified drive


      mov      al, cl
      cbw
      mul      CDSLen
      les      bx, CDSBase
      add      bx, ax		  ; es:bx FirstDriveNo CDSp
      xor      ch, ch
      .while  (cl <= LastDOSDrive)
	 test	  es:[bx].CDS.Flags, 0C000h ; drive in use ?
	 jnz	  @F
	 mov	  ch, cl
	 mov	  word ptr CDSp, bx	     ; set CDSp
	 mov	  word ptr CDSp+2, es
	 .break
   @@:	 inc	  cl
	 add	  bx, CDSLen
      .endw
      ret

FindAvailDrive	       endp

ParseCommandLine       proc near  uses es
   ;* If driver is loaded from config.sys using device=drivername parms
   ;* then rhINIT points to the first character following the drivername
   ;* and a CR follows the last parm.  When loaded by executing, the
   ;* command line is available in the PSP.(len +80h, 1st ch +81h, no CR)

      sub      ch, ch
      mov      di, 80h		  ; command line length psp +80h
      mov      cl, es:[di]
      mov      al, 'U'            ; /U unInstall driver
      call     GetParm
      .if ax == ArgumentFound
	  mov	   InstallFlag, UnInstallIt
	  jmp	   ParseExit
      .endif

      mov      di, 80h		      ; command line length at psp +80h
      sub      ch, ch
      mov      cl, es:[di]
      mov      al, '~'                ; /~[+|-] toggle/set/unset tilde usage
      call     GetParm
      .if ax == ArgumentFound
	 push  cx
	 push  di
	 push  es
	 mov   bx, SMARTDRV_Q
	 mov   ah, REDIR
	 mov   al, InstallChk
	 int   2fh
	 .if bx != SMARTDRV_R
	    push ds
	    pop  es
	 .else
	    mov   InstallFlag, SetTilde
	 .endif
	 push  es
	 pop   fs
	 pop   es
	 pop   di
	 pop   cx
	 .if cx
	    mov   al, es:[di+1]
	    .if al == '+'
	       mov fs:Tildes, 0ffffh
	    .elseif al == '-'
	       mov fs:Tildes, 0
	    .else
	       not fs:Tildes
	    .endif
	 .else
	    not   fs:Tildes
	 .endif
      .endif

      mov      di, 80h		      ; command line length at psp +80h
      sub      ch, ch
      mov      cl, es:[di]
      mov      DriverIndex, 0
      mov      ax, ArgumentFound
   .while  ax == ArgumentFound
      mov      al, 'D'            ; /D:drivername
      call     FindParm
     .if   ax == ArgumentFound
	 mov	  ax, sizeof DrvrEnt
	 mul	  DriverIndex
	 mov	  si, ax
	 mov	  dx, 8
	 call	  MoveName
	 mov al, es:[di]
	 .if   cx == 0
	     jmp     @F
	 .endif
	 .while (al != ',' && al != ' ')
	    inc    di
	    mov al, es:[di]
	    dec    cx
	    .if   cx == 0  || al == '/'
		jmp	@F
	    .endif
	 .endw
	 dec	cx
	 .if   cx == 0
	     jmp     @F
	 .endif
	 inc	di
	 mov al, es:[di]
	 .if al == ' '
	     jmp @F
	 .elseif al != ','                         ; check first driveno
	    .if (al >= 'a' && al <= 'z')
		and    al, 11011111y	       ; upper case it
	    .endif
	    .if (al >= 'A' && al <= 'Z')
		sub    al, 'A'
	    .else
		jmp @F
	    .endif
	    mov  [si+Drivers.Drive], al
	    dec     cx
	    jcxz    @F
	    inc    di
	    mov al, es:[di]
	    .if al != ','
	       jmp @F
	    .endif
	 .endif
	 dec	cx
	 jcxz	  @F
	 inc	di
	 mov al, es:[di]
	 .if al != ','                              ; check firstdeviceunit
	    .if (al >= '0' && al <= '9')
		sub    al, '0'
		mov ah, es:[di+1]		    ; is it two digits?
	       .if (ah >= '0' && ah <= '9')         ; ignore if not a digit
		   shl	  al,1			    ; mul 1st digit by 10
		   mov	  ah, al
		   shl	  al,1
		   shl	  al,1
		   add	  al, ah
		   mov	  ah, es:[di+1] 	    ; and add in 2nd digit
		   sub	  ah, '0'
		   add	  al, ah
		   dec	  cx
		   inc	  di
	       .endif
		mov    [si+Drivers.Unit], al
	    .else
		jmp @F
	    .endif
	    dec     cx
	    jcxz     @F
	    inc    di
	 .endif
	 dec	 cx
	 jcxz	  @F
	 inc	di
	 mov al, es:[di]
	 .if al != ','
	    .if (al >= '0' && al <= '9')
		sub    al, '0'
		mov    [si+Drivers.NoWanted], al
	    .else
		jmp @F
	    .endif
	 .endif
   @@:	inc    DriverIndex
	mov    ax, ArgumentFound
	dec    di		     ; find parm needs ptr -1
     .endif
   .endw
    mov   al, DriverIndex
    .if  al ==0
       inc al
    .endif
    mov   NoDrivers, al
ParseExit:
    ret

ParseCommandLine       endp

MoveName proc near
      sub   bx, bx				   ; es:di points to 1st char
      .repeat					   ; cx chars left on cmd line
	  mov al, es:[di]			   ; dx is length of name field
	  .if ((al == ',') || (cx == 0) || (al==' ') || (al == '/'))
	      mov    byte ptr [si+bx+Drivers.Name], ' '
	  .else
	     .if (al >= 'a' && al <= 'z')
		 and	al, 11011111y		; upper case it
	      .endif
	      mov    byte ptr [si+bx+Drivers.Name], al
	      inc    di
	      dec    cx
	  .endif
	  inc	 bx
      .until bx == dx
      ret
MoveName endp

FindParm proc near

   ; al      parm code we are to find	    /X: or -X:
   ; es:di   first char on command line -1
   ; cx      number of characters left on command line

 GetNext:			      ; this code allows us to handle names
      call     GetParm		      ; like   -C:NET-CD
      cmp      ax, ArgumentFound
      jne      NotFound
      inc      di		      ; found /X or -X, is next char a ':' ?
      dec      cl
      mov      al, es:[di]
      cmp      al, ':'
      je       FoundIt
      loop     GetNext
      mov      ax, ArgumentNotFound
      ret

  FoundIt:
      inc   di				 ; /X:name  make di point @ name
      dec   cl
      mov   ax, ArgumentFound
  NotFound:
   ret

FindParm endp

;* GetParm - Scans command line for argument of form /X or -X  where
;* X = specified ASCII character. Presumes that argument is preceded
;* by a '/' or a '-'. Comparisons are case insensitive.
;*
;* Params: ES:DI = Address of CommandLine -1
;*	   AL	 = Paramater character to scan for
;*	   CX	 = command line length
;*
;* Return: AX	 = One of the following codes:
;*		   NoArgumentsFound  if empty command line
;*		   ArgumentFound  if argument found
;*		   ArgumentNotFound if argument not as specified
;*	   ES:DI = Pointer to found argument
;*	   CX	 = chars left on command line including arg or 0

GetParm PROC NEAR

	mov	ah, NoArgumentsFound	; assume no /X style arguments
	jcxz	exit
	.if (al >= 'a' && al <= 'z')
	    and    al, 11011111y	   ; Make character upper case
	.endif

; Find start of argument

loop1:
	inc	di			;
	mov	dl, es:[di]		; Get character from argument list
	cmp	dl, '/'                 ; Find option prefix '/'
	je	analyze
	cmp	dl, '-'                 ;   or option prefix '-'
	je	analyze

	loop	loop1

	jmp	exit

; '/' or '-' prefix found. Compare command-line character
; with character specified in AL.
analyze:
	inc	di
	dec	cl
	jcxz	exit
	mov	ah, ArgumentFound	  ; Assume argument is okay
	mov	dl, es:[di]
	.if (dl >= 'a' && dl <= 'z')
	    and    dl, 11011111y	   ; Make character upper case
	.endif
	cmp	dl, al
	je	exit			; specified char
	mov	ah, ArgumentNotFound	; Else signal bad argument,
	loop	loop1		  ;   continue scan

exit:
	mov	al, ah
	cbw				; AX = return code
	ret

GetParm ENDP

_INIT	     ends

	    end   Init

