#include "scatt.h"
#include "deprecation.h"
Scatt::Scatt(Molecule *m){
   mol=m;
   f000=0.0;
   Fmax=0.0;
   resd=-1.0f;
 }

QStringList Scatt::loadXRayScatteringFactors(){
    QStringList xsfs;
    QFile atomsf(":cmxray.txt");
    atomsf.open(QIODevice::ReadOnly|QIODevice::Text);
    QByteArray ba=atomsf.readAll();
    QStringList all= QString(ba).split('\n');
    atomsf.close();

    for (int i=0; i<all.size(); i++){
        if (all.at(i).startsWith('#'))continue;
        QStringList tok=all.at(i).split(" ",skipEmptyParts);
        if (tok.size()>9){
            int an =tok.at(1).toInt()-1;
            //W6+   74   *DS 29.4936 1.42755 19.3763 0.104621 13.0544 5.93667 5.06412 11.1972 1.01074
            xsfs.append(QString("%16 SFAC %1 %2 %3 %4 %5 %6 %7 %8 %9 %10 %11 %12 %13 %14 %15!%17 %18\n")
                   .arg(mol->pse(tok.at(1).toInt()-1))
                   .arg(tok.at(3).toDouble())//a1
                   .arg(tok.at(4).toDouble())//b1
                   .arg(tok.at(5).toDouble())//a2
                   .arg(tok.at(6).toDouble())//b2
                   .arg(tok.at(7).toDouble())//a3
                   .arg(tok.at(8).toDouble())//b3
                   .arg(tok.at(9).toDouble())//a4
                   .arg(tok.at(10).toDouble())//b4
                   .arg(tok.at(11).toDouble())//c
                   .arg("fp")//f'
                   .arg("fdp")//f"
                   .arg("mu")//mu
                   .arg((an<94)?static_cast<double>(ff[an].rad):0.0)
                   .arg((an<94)?static_cast<double>(ff[an].mass):0.0)
                   .arg(tok.at(1).toInt())
                   .arg(tok.at(0))
                   .arg(tok.at(2))
                   );
        }
    }
    return xsfs;
}

QStringList Scatt::loadElectronScatteringFactors(){
    QStringList esfs;
    QFile atomsf(":peng_eas");
    atomsf.open(QIODevice::ReadOnly|QIODevice::Text);
    QByteArray ba=atomsf.readAll();
    QStringList all= QString(ba).split('\n');
    atomsf.close();
    //#Element Z a1 a2 a3 a4 b1 b2 b3 b4 s
    // 0       1 2  3  4  5  6  7  8  9  10
    for (int i=0; i<all.size(); i++){
        if (all.at(i).startsWith('#'))continue;
        QStringList tok=all.at(i).split(" ",skipEmptyParts);
        if (tok.size()>9){
            int an =tok.at(1).toInt()-1;
            esfs.append(QString("SFAC %1 %2 %3 %4 %5 %6 %7 %8 %9 %10 %11 %12 %13 %14 %15\n")
                   .arg(tok.at(0))
                   .arg(tok.at(2).toDouble())//a1
                   .arg(tok.at(6).toDouble())//b1
                   .arg(tok.at(3).toDouble())//a2
                   .arg(tok.at(7).toDouble())//b2
                   .arg(tok.at(4).toDouble())//a3
                   .arg(tok.at(8).toDouble())//b3
                   .arg(tok.at(5).toDouble())//a4
                   .arg(tok.at(9).toDouble())//b4
                   .arg(0.0)
                   .arg(0.0)
                   .arg(0.0)
                   .arg(0.0)
                   .arg((an<94)?static_cast<double>(ff[an].rad):0.0)
                   .arg((an<94)?static_cast<double>(ff[an].mass):0.0)
                   );
        }
    }
    all.clear();
    QFile ionsf(":ions_eas");
    ionsf.open(QIODevice::ReadOnly|QIODevice::Text);
    ba=ionsf.readAll();
    all= QString(ba).split('\n');
    ionsf.close();
    for (int i=0; i<all.size(); i++){
        if (all.at(i).startsWith('#'))continue;
        QStringList tok=all.at(i).split(" ", skipEmptyParts);
        if (tok.size()>10){
            int an = tok.at(1).toInt();
            esfs.append(QString("SFAC %1 %2 %3 %4 %5 %6 %7 %8 %9 %10 %11 %12 %13 %14 %15\n")
                   .arg(tok.at(0))
                   .arg(tok.at(2).toDouble())//a1
                   .arg(tok.at(6).toDouble())//b1
                   .arg(tok.at(3).toDouble())//a2
                   .arg(tok.at(7).toDouble())//b2
                   .arg(tok.at(4).toDouble())//a3
                   .arg(tok.at(8).toDouble())//b3
                   .arg(tok.at(5).toDouble())//a4
                   .arg(tok.at(9).toDouble())//b4
                   .arg(tok.at(10).toDouble())//c
                   .arg(0.0)
                   .arg(0.0)
                   .arg(0.0)
                   .arg((an<94)?static_cast<double>(ff[an].rad):0.0)
                   .arg((an<94)?static_cast<double>(ff[an].mass):0.0)
                   );
        }
        //else printf("??%d %s\n",tok.size(),all.at(i).toStdString().c_str());
    }
    return esfs;
}

void Scatt::setSCAT(QStringList tok){
  if (tok.size()<16)return;
  int an = mol->getOZ(tok.at(1));
  if (an<0)return;
  for (int i=0; i<9; i++) {
    ff[an].ab4c[i]=tok.at(2+i).toFloat();
    //    qDebug()<<i+2<<ff[an].ab4c[i];
  }
  ff[an].fpcu=ff[an].fpmo=ff[an].fpag    = tok.at(11).toFloat();
  ff[an].fppcu=ff[an].fppmo=ff[an].fppag = tok.at(12).toFloat();
  ff[an].mucu=ff[an].mumo=ff[an].muag    = tok.at(13).toFloat();
  ff[an].rad=tok.at(14).toFloat();
  ff[an].mass=tok.at(15).toFloat();
}

void Scatt::setDISP(QStringList tok){
  if (tok.size()<4)return;
  int an = mol->getOZ(tok.at(1));
  ff[an].fpcu=ff[an].fpmo=ff[an].fpag    = tok.at(2).toFloat();
  if (tok.size()<4)return;
  ff[an].fppcu=ff[an].fppmo=ff[an].fppag = tok.at(3).toFloat();
  if (tok.size()<5)return;
  ff[an].mucu=ff[an].mumo=ff[an].muag    = tok.at(4).toFloat();

}

float Scatt::fprime(int an,int radiation){
  switch (radiation){
    case SCATTCU: return ff[an].fpcu;
    case SCATTMO: return ff[an].fpmo;
    case SCATTAG: return ff[an].fpag;
    default: return ff[an].fpcu;
  }
}

float Scatt::fdprime(int an,int radiation){
  switch (radiation){
    case SCATTCU: return ff[an].fppcu;
    case SCATTMO: return ff[an].fppmo;
    case SCATTAG: return ff[an].fppag;
    default: return ff[an].fppcu;
  }
}

float Scatt::atomformfactor(int an, float s){
  float erg=0.0;
  for (int i=0; i<4;i++){
    erg+=ff[an].ab4c[2*i]*exp(-ff[an].ab4c[2*i+1]*s);
  }
  erg+=ff[an].ab4c[8];
  return erg;
}

float Scatt::FF(V3 hkl,int radiation,float &phang,float &I){
  const float twopi=M_PIf*2.0f;
  const float twopi2=M_PIf*M_PIf*2.0f;
  phang=0;
  float A=0.f,Aa=0.f;
  float B=0.f,Ba=0.f;
  float s2=sintl2(hkl)*0.25f;
  //printf("s2 %f %f\n",s2,resd);
  if ((s2< mol->hklShellLow)||(s2> mol->hklShellHig)){
    phang=0.0f;

    I=-666.0f;
    return 0.0f;
  }
  if (s2>0.001)resd=fmax(s2,resd);
  QList<float> f0;
  f000=0.0;
  for (int i=0; i<isfac.size(); i++) f0.append(atomformfactor(isfac.at(i),s2));
  for (int i=0; i<xyz.size(); i++){
    float sof = sofs.at(i);
    int an= isfac.at(type.at(i));
    f000+=sof*(an+1);
    float p=(float)(twopi*(xyz.at(i)*hkl));
    float fp=fprime(an,radiation);
    float fpp=fdprime(an,radiation);
    //T = 8*(pi**2)*Uiso*sin(theta/lambda)**2
    if (isos.at(i)) sof*=expf(bet.at(i).m11*s2);
    else {
      sof*=expf(-twopi2* ((hkl*bet.at(i))*hkl));
    }//  */
    float cs=cosf(p),si=sinf(p);
    //float cs=1,si=0.0;
    float a=(f0.at(type.at(i))+fp);
    A+= sof*(a*cs-fpp*si);
    B+= sof*(a*si+fpp*cs);
    Aa+=sof*(a*cs);
    Ba+=sof*(a*si);
  }
  I=A*A+B*B;
  float Ia=Aa*Aa+Ba*Ba;
  phang=atan2f(Ba,Aa)*180.0f/M_PIf;
  phang=fmod(720.01f+phang,360)-0.01f;
  float fc=sqrtf(Ia);
  if (s2>0.001) Fmax=fmax(Fmax,fc);
  return fc;
}
float Scatt::F(int h, int k, int l,int radiation,float &phang,float &disp){
  const float twopi=M_PIf*2.0f;
  const float twopi2=M_PIf*M_PIf*2.0f;
  phang=0;
  float A=0,Aa=0;
  f000=0.0;
  float B=0,Ba=0;
  Matrix N=Matrix(mol->cell.as,0,0,0,mol->cell.bs,0,0,0,mol->cell.cs),beta_,beta;//,ucc;
  float s2=sintl2(h,k,l)*0.25f;
  //printf("Fs2 %f %f\n",s2,resd);
  if (s2>0.001)resd=fmin(0.5/sqrt(s2),resd);
  int ns = mol->cell.symmops.size();
  int na = mol->asymm.size();
  for (int s=0; s<ns; s++){
    for (int i=0; i<na; i++){
      int an = mol->asymm.at(i).an;
      if (an<0) continue;
      bool iso=(mol->asymm.at(i).isIso);
      if (!iso){
        beta=(N*mol->asymm.at(i).uf*N);
        mol->Usym(beta,mol->cell.symmops.at(s),beta_);
      }
      float sof = mol->asymm.at(i).sof;
      f000+=sof*(an+1);
      V3 uvw = mol->cell.symmops.at(s)*mol->asymm[i].frac+mol->cell.trans.at(s);

      V3 hkl(h,k,l);
      float p=twopi*uvw*hkl;
      float f0=atomformfactor(an,s2);
      float fp=fprime(an,radiation);
      float fpp=fdprime(an,radiation);
      //T = 8*(pi**2)*Uiso*sin(theta/lambda)**2
      if (iso) sof*=exp(-4*twopi2*mol->asymm.at(i).uf.m11*s2);
      else {
        sof*=exp(-twopi2* ((hkl*beta_)*hkl));

      }
      float cs=cos(p),si=sin(p);
      A+=sof*((f0+fp)*cs-fpp*si);
      B+=sof*((f0+fp)*si+fpp*cs);
      Aa+=sof*((f0+fp)*cs);
      Ba+=sof*((f0+fp)*si);
    }
  }
  float I=A*A+B*B;
  float Ia=Aa*Aa+Ba*Ba;
  phang=atan2(Ba,Aa)*180.0/M_PI;
  phang=fmod(720.01+phang,360)-0.01;
  disp=I;
  float fc=sqrt(Ia);
  if (s2>0.001) Fmax=fmax(Fmax,fc);
  return fc;
}

QString Scatt::myfcf(QString fn){
  //  qDebug()<<mol->hklf;
  //  qDebug()<<mol->hklScale<<mol->hklSigmaScale;
  if ((mol->hklf<3)||(mol->hklf>4)) return "";
  //  const float twopi=M_PI*2.0;
  const float twopi2=M_PIf*M_PIf*2.0f;

  Rec *lr=NULL,ob;
  QString base=fn, mfcf=fn, hklf=fn;
  hklf=hklf.replace(QRegularExpression("(.res$)|(.ins$)"),".hkl");
  mfcf=mfcf.replace(QRegularExpression("(.res$)|(.ins$)"),".fcf6");
  base=base.replace(QRegularExpression("(.res$)|(.ins$)"),"");
  base=base.section('/', -1);
  FILE *hkl=fopen(hklf.toStdString().c_str(),"rt");
  if (hkl==NULL) {fprintf(stderr,"can't open hkl\n"); return "";}
  int nr=0;
  char line[128];
  int wl=0;
  if (fabs(mol->cell.wave-0.71073)<0.01) wl=SCATTMO;
  else if (fabs(mol->cell.wave-1.5418)<0.01) wl=SCATTCU;
  else if (fabs(mol->cell.wave-0.56083)<0.01) wl=SCATTAG;
  else wl=-1;
  int nnr=0;
  mol->hklShellLow = pow(0.5/mol->hklShellLow,2);
  mol->hklShellHig = pow(0.5/mol->hklShellHig,2);
  //  qDebug()<<"@@"<<mol->hklShellLow<<mol->hklShellHig;
  while (!feof(hkl)){
    if (fgets(line,120,hkl)) {;}
    nnr++;
  }
  rewind(hkl);
  lr=(Rec*) malloc(sizeof(Rec)*nnr);
  FILE *fc6=fopen(mfcf.toStdString().c_str(),"wt");
  if (fc6==NULL) {
    fprintf(stderr,"can't open %s\n",mfcf.toStdString().c_str());
    qDebug()<<"can't open " << mfcf;
    return "";
  }

  //FILE *tst=NULL;//:qfopen("scale_test_123.456","wt");
  if (1) {
    Matrix N=Matrix(mol->cell.as,0,0,0,mol->cell.bs,0,0,0,mol->cell.cs),beta_,beta;//,ucc;
    type.clear();
    bet.clear();
    sofs.clear();
    xyz.clear();
    isos.clear();
    int ns = mol->cell.symmops.size();
    int na = mol->asymm.size();
    for (int s=0; s<ns; s++){
      for (int i=0; i<na; i++){
        int an = mol->asymm.at(i).an;
        if (an<0) continue;
        if (!isfac.contains(an)) isfac.append(an);
        type.append(isfac.indexOf(an));
        bool iso=(mol->asymm.at(i).isIso);
        if (!iso){
          beta=(N*mol->asymm.at(i).uf*N);
          mol->Usym(beta,mol->cell.symmops.at(s),beta_);
        }else{beta_.m11=-4*twopi2*mol->asymm.at(i).uf.m11;}
        isos.append(iso);
        bet.append(beta_);
        float sof = mol->asymm.at(i).sof;
        sofs.append(sof);
        xyz.append(mol->cell.symmops.at(s)*mol->asymm[i].frac+mol->cell.trans.at(s));
      }
    }
  }




  //  printf("wave:%f %f %f %f %d %d wl=%d\n",mol->cell.wave,fabs(mol->cell.wave-0.71073),fabs(mol->cell.wave-1.5418),fabs(mol->cell.wave-0.56083), mol->cell.ns0, mol->cell.symmops.size(),wl);

  /*printf("hklf N=%d s:%g \n%g %g %g\n%g %g %g\n%g %g %g\nsm: %g \n",mol->hklf,mol->hklScale ,
      mol->hklMat.m11,mol->hklMat.m12,mol->hklMat.m13,
      mol->hklMat.m21,mol->hklMat.m22,mol->hklMat.m23,
      mol->hklMat.m31,mol->hklMat.m32,mol->hklMat.m33,
      mol->hklSigmaScale);*/
  while (!feof(hkl)){
    if (fgets(line,120,hkl)) {;}
    if (feof(hkl))continue;
    if (strlen(line)<28) continue;
    char chkl[13],cisig[17];
    for (int ci=0; ci<12; ci++) chkl[ci]=line[ci];
    chkl[12]='\0';
    for (int ci=0; ci<16; ci++) cisig[ci]=line[ci+12];
    cisig[16]='\0';
    sscanf(chkl,"%4d%4d%4d", &ob.ih, &ob.ik, &ob.il);
    sscanf(cisig,"%8f%8f", &ob.fo, &ob.si);
    if ((ob.ih==0)&&(ob.il==0)&&(ob.ik==0)) {
      //      printf("#[%d,%d,%d,%d]%s",nr,ob.ih,ob.ik,ob.il,line);

      break;
    }
    V3 hkl=V3(ob.ih,ob.ik,ob.il)*mol->hklMat;
    ob.ih=hkl.x;
    ob.ik=hkl.y;
    ob.il=hkl.z;
    ob.fo*=mol->hklScale;
    ob.si=(mol->hklScale*mol->hklSigmaScale*ob.si);
    if (mol->hklf==3){
      double xxx=fmax(0.01,ob.si);
      ob.si=2.0*xxx * fabs(fmax(fabs(ob.fo),xxx));
      ob.fo*=ob.fo;
    }
    //ob.fc=FF(hkl,wl,ob.phi,ob.dis);
    //    if ((ob.ih==1)&&(ob.ik==0)&&(ob.il==0)){ printf("%4d%4d%4d %18.9f %18.9f\n",ob.ih,ob.ik,ob.il,ob.fo,ob.si); }
    //   ob.fc=F(ob.ih,ob.ik,ob.il,wl,ob.phi,ob.dis);

    lr[nr]=ob;
    nr++;
  }
  //  qDebug()<<resd <<0.5/sqrt(resd);
  //resd=0.5f/sqrtf(resd);
  //printf("resd %f\n",resd);
  //  for (int iw=0; iw<xyz.size(); iw++){ qDebug()<<type.at(iw)<<sofs.at(iw)<<xyz.at(iw).x<<xyz.at(iw).y<<xyz.at(iw).z; }
  //if (tst!=NULL) fclose(tst);

  float myosf=0.0;
  for (int i=0; i<nr; i++){
    V3 uvw=V3(lr[i].ih,lr[i].ik,lr[i].il);
    V3 m=uvw;
    float p,q=lr[i].phi;
    lr[i].phi=fmod(720.0+q,360.0);
    for (int s=0; s<mol->cell.ns0;s++){
      float t=1.0;
      V3 nhkl=uvw*mol->cell.symmops.at(s);
      //      if((nl<0)||((nl==0)&&(nk<0))||((nl==0)&&(nk==0)&&(nh<0)))
      //if((nl<0)||((nl==0)&&(nk<0))||((nl==0)&&(nk==0)&&(nh<0)))
      if((nhkl.z<0)||((nhkl.z==0)&&(nhkl.y<0))||((nhkl.z==0)&&(nhkl.y==0)&&(nhkl.x<0))) {
        nhkl.x*=-1;
        nhkl.y*=-1;
        nhkl.z*=-1;
        t=-1.0;
      }
      if ((nhkl.z<m.z)||((nhkl.z==m.z)&&(nhkl.y<m.y))||((nhkl.z==m.z)&&(nhkl.y==m.y)&&(nhkl.x<=m.x))) continue;
      m=nhkl;
      //p=u*sy[9][k]+v*sy[10][k]+w*sy[11][k];
      p=uvw*mol->cell.trans.at(s);
      lr[i].phi=fmod(719.99+t*fmod(q-360.0*p,360.0),360.0)+0.01;
      /*      if (m==V3(1,1,0)) {printf("?%4d%4d%4d sym=%d %g \n %4g%4g%4g fo%12.6f si%12.6f fc%12.6f phi%12.3f %d %f %f (%g %g %g)\n",lr[i].ih,lr[i].ik,lr[i].il,s,t,
              nhkl.x,nhkl.y,nhkl.z,
              lr[i].fo,lr[i].si,lr[i].fc,lr[i].phi,i,q,p, mol->cell.trans.at(s).x,mol->cell.trans.at(s).y,mol->cell.trans.at(s).z);}*/
    }
    lr[i].ih=m.x;
    lr[i].ik=m.y;
    lr[i].il=m.z;
  }
  sorthkl(nr,lr);
  int n=-1;
  //  float sw=0.,swxy=0.0,swx=0.0,swy=0.0,swx2=0.0,sfo=0,sfoc=0;
  float swxy=0.0,swx2=0.0,sfo=0,sfoc=0;;
  {int i=0;
    while(i<nr){
      float t=0.;
      float u=0.;
      float v=0.;
      float v2=0.;
      float ws=0;
      int m;
      int k=i;
      while ((i<nr)&&(lr[i].ih==lr[k].ih)&&(lr[i].ik==lr[k].ik)&&(lr[i].il==lr[k].il)) {
        t=t+1.;
        float w=fmax(4.0,lr[i].fo/lr[i].si)/lr[i].si;//1.0;//
        ws+=w;
        u+=lr[i].fo*w;//*lr[i].fc*lr[i].fc/lr[i].dis;
        v+=1./(lr[i].si*lr[i].si);
        v2+=lr[i].si;
        // p=lr[i].phi;
        // ddi+=lr[i].dis;
        //         if (t>1) {printf("!%4d%4d%4d fo%12.6f sig%12.6f fc%12.6f phi%12.3f i%d  k%dw=%f dis%f\n",lr[i].ih,lr[i].ik,lr[i].il,lr[i].fo,lr[i].si,lr[i].fc,lr[i].phi,i,k,w,lr[i].dis);}
        i++;
      }
      m=n+1;
      float yy=(u/ws);
      lr[m].fo = sqrt(fmax(0.0f,yy));
      lr[m].so=sqrt(lr[m].fo*lr[m].fo+sqrt(1./v))-lr[m].fo;
      lr[m].si=1.0/sqrt(v);
      n=m;
      lr[n].ih=lr[k].ih;
      lr[n].ik=lr[k].ik;
      lr[n].il=lr[k].il;
    }
    //printf("%d %d %d \n",nr,n,i);
  }
  n++;
  nr=n;
  for (int i=0; i<nr; i++){
    V3 chkl=V3(lr[i].ih,lr[i].ik,lr[i].il);
    lr[i].fc=0.0;
    lr[i].fc=FF(chkl,wl,lr[i].phi,lr[i].dis);
    lr[i].fo =lr[i].fo * (lr[i].fc*lr[i].fc/lr[i].dis);//correct for dispersion
    if (lr[i].dis<=-665.0f) {
      lr[i].fc=0.0;
      continue;
    }
    if ((mol->exti!=-666.0)&&(mol->swat==-666.0)){
      lr[i].fc*=pow(1 + 0.001 * mol->exti * lr[i].fc * lr[i].fc  *mol->cell.wave * mol->cell.wave /sqrt(sintl2(chkl)),-0.25);
    }
    float xx=lr[i].fc*lr[i].fc;
    float yy=lr[i].fo*lr[i].fo;
    float v=1.0/(lr[i].si*lr[i].si);
    if (xx>0.001){
      swx2+=v*xx*xx;
      swxy+=v*yy*xx;
    }
  }
  float osf2=(mol->osf<=0.0)?swxy/swx2:mol->osf*mol->osf;//myosf;
  myosf=sqrt(osf2);
  // qDebug() << mol->osf << myosf << osf2 << swxy/swx2<<swxy <<swx2;
  //printf("%g %g %g\n",myosf,osf2,swxy/swx2);
  type.clear();
  bet.clear();
  sofs.clear();
  xyz.clear();
  isos.clear();
  //  myosf=mol->osf;
  resd=0.5f/sqrtf(resd);
  //printf("???? %f \n",resd);
  fprintf(fc6,
      "#\n# h,k,l, Fo-squared, sigma(Fo-squared), Fc and phi(calc)\n#\ndata_%s\n_shelx_title '%s'\n_shelx_refln_list_code          6\n"
      "_shelx_F_calc_maximum      %6.2f\n_exptl_crystal_F_000       %6.2f\n_reflns_d_resolution_high  %6.4f\n\nloop_\n_space_group_symop_operation_xyz\n"
      ,base.toStdString().c_str()
      ,mol->titl.toStdString().c_str()
      ,Fmax
      ,f000
      ,resd
      );
  for (int s=0; s<mol->cell.symmops.size();s++)
    fprintf(fc6,"'%s'\n",mol->symmcode2human(s).trimmed().toStdString().c_str());
  fprintf(fc6,
      "\n_cell_length_a   %8.4f\n_cell_length_b   %8.4f\n_cell_length_c   %8.4f\n_cell_angle_alpha %7.3f\n_cell_angle_beta  %7.3f\n_cell_angle_gamma %7.3f\n\n"
      "loop_\n_refln_index_h\n_refln_index_k\n_refln_index_l\n_refln_F_squared_meas\n_refln_F_squared_sigma\n_refln_F_calc\n_refln_phase_calc\n",
      mol->cell.a,mol->cell.b,mol->cell.c,mol->cell.al,mol->cell.be,mol->cell.ga
      );
  int igut=0;
  for (int i=0; i<nr; i++){
    /*
       fprintf(fc6,"%d %d %d %.2f %.2f %2f %.2f %.1f %f\n"
       ,lr[i].ih
       ,lr[i].ik
       ,lr[i].il
    //        ,(pow(lr[i].fo/mol->osf,2.0))/(1.0+lr[i].dis)
    ,pow(lr[i].fo/mol->osf,2.0)
    ,lr[i].si/(mol->osf*mol->osf)
    ,sqrt(lr[i].dis)
    ,lr[i].fc
    ,lr[i].phi
    ,lr[i].fc*lr[i].fc
    // ,lr[i].dis
    );// */

    float iosig = powf(lr[i].fo/myosf,2.0f)/(lr[i].si/(osf2));
    if ((lr[i].fc>0.001)&& (iosig>-1.0)){
      igut++;
      sfo+=lr[i].fo/myosf;
      sfoc+=fabs(lr[i].fo/myosf-lr[i].fc);
    }
    if (lr[i].fc>0.001f)
      fprintf(fc6,"%d %d %d %.2f %.2f %.2f %.1f\n"
          ,lr[i].ih
          ,lr[i].ik
          ,lr[i].il
          //        ,(pow(lr[i].fo/mol->osf,2.0))/(1.0+lr[i].dis)
          ,powf(lr[i].fo/myosf,2.0f)
          ,lr[i].si/(osf2)
          //,sqrt(lr[i].dis)
          ,lr[i].fc
          ,lr[i].phi
          // ,lr[i].fc*lr[i].fc
          // ,lr[i].dis
          );//  */
  }
  fclose(hkl);
  fclose(fc6);
  //printf("R1=%f %d %d %g %g \n",sfoc/sfo,igut,nr,sfoc,sfo);
  return mfcf;
}

float Scatt::sintl2(int h,int k, int l){
  V3 H=V3(h,k,l);
  float s=H*mol->cell.Gi*H;
  return s;
}
float Scatt::sintl2(V3 H){
  float s=H*mol->cell.Gi*H;
  return s;
}
void Scatt::sorthkl(int nr, Rec r[]){
  /*! sorts the reflection list
  */
  Rec *hilf= (Rec*) malloc(sizeof(Rec)*nr);
  if (hilf==NULL)return ;
  int i,j,k,nj,ni,spalte;int index[4096];
  for (spalte=0; spalte<3; spalte++){
    j=-999999;
    k=999999;
    switch (spalte) {
      case 0: for (i=0; i<nr; i++){ j=(j<r[i].ih)?r[i].ih:j; k=(k>r[i].ih)?r[i].ih:k; } break;
      case 1: for (i=0; i<nr; i++){ j=(j<r[i].ik)?r[i].ik:j; k=(k>r[i].ik)?r[i].ik:k; } break;
      case 2: for (i=0; i<nr; i++){ j=(j<r[i].il)?r[i].il:j; k=(k>r[i].il)?r[i].il:k; } break;
    }
    nj=-k;
    ni=(nj+j+1);
    for (i=0; i<=ni; i++) index[i]=0;
    for (i=0; i<nr; i++){
      switch (spalte){
        case 0: j=r[i].ih+nj; break;
        case 1: j=r[i].ik+nj; break;
        case 2: j=r[i].il+nj; break;
      }
      index[j]++;/*brauch ich das? -->JA!*/
      hilf[i].ih=r[i].ih;
      hilf[i].ik=r[i].ik;
      hilf[i].il=r[i].il;
      hilf[i].fo=r[i].fo;
      hilf[i].so=r[i].so;
      hilf[i].si=r[i].si;
      hilf[i].fc=r[i].fc;
      hilf[i].dis=r[i].dis;
      hilf[i].phi=r[i].phi;
    }/*/4*/
    j=0;
    for (i=0; i<ni; i++){
      k=j;
      j+=index[i];
      index[i]=k;
    }/*/5*/
    for (i=0; i<nr;i++){
      switch (spalte) {
        case 0: j=hilf[i].ih +nj;break;
        case 1: j=hilf[i].ik +nj;break;
        case 2: j=hilf[i].il +nj;break;
      }
      index[j]++;
      j=index[j]-1;
      r[j].ih=hilf[i].ih;
      r[j].ik=hilf[i].ik;
      r[j].il=hilf[i].il;
      r[j].fo=hilf[i].fo;
      r[j].so=hilf[i].so;
      r[j].si=hilf[i].si;
      r[j].fc=hilf[i].fc;
      r[j].dis=hilf[i].dis;
      r[j].phi=hilf[i].phi;
    }/*/6*/
  }/*/spalten*/
  free(hilf);
}

