/*
* Copyright Tim (xtimor@gmail.com)
*
* NMEA library is free software; you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
*/
/*
 *
 * NMEA library
 * URL: http://nmea.sourceforge.net
 * Author: Tim (xtimor@gmail.com)
 * Licence: http://www.gnu.org/licenses/lgpl.html
 * $Id: units.h 4 2007-08-27 13:11:03Z xtimor $
 *
 */

#ifndef __NMEA_UNITS_H__
#define __NMEA_UNITS_H__

#include "config.h"

/*
 * Distance units
 */

#define NMEA_TUD_YARDS      (1.0936)        //!< Yeards, meter * NMEA_TUD_YARDS = yard
#define NMEA_TUD_KNOTS      (1.852)         //!< Knots, kilometer / NMEA_TUD_KNOTS = knot
#define NMEA_TUD_MILES      (1.609)         //!< Miles, kilometer / NMEA_TUD_MILES = mile

/*
 * Speed units
 */

#define NMEA_TUS_MS         (3.6)           //!< Meters per seconds, (k/h) / NMEA_TUS_MS= (m/s)

#endif /* __NMEA_UNITS_H__ */
