# Generated by Django 5.1.5 on 2025-02-22 19:02

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('db', '0134_filestoreinscope_db_filestoreinscope_consistent_populate'),
    ]

    operations = [
        migrations.CreateModel(
            name='WorkerPool',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'name',
                    models.SlugField(
                        help_text='Human readable name of the worker pool',
                        unique=True,
                    ),
                ),
                ('enabled', models.BooleanField(default=True)),
                ('architectures', models.JSONField(default=list)),
                ('tags', models.JSONField(blank=True, default=list)),
                ('specifications', models.JSONField(default=dict)),
                ('instance_wide', models.BooleanField(default=True)),
                ('ephemeral', models.BooleanField(default=False)),
                ('limits', models.JSONField(blank=True, default=dict)),
                ('registered_at', models.DateTimeField()),
                (
                    'provider_account',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to='db.asset',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='ScopeWorkerPool',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('priority', models.IntegerField(default=0)),
                ('limits', models.JSONField(blank=True, default=dict)),
                (
                    'scope',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='db.scope',
                    ),
                ),
                (
                    'worker_pool',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='db.workerpool',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='WorkerPoolStatistics',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('runtime', models.IntegerField()),
                (
                    'worker',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to='db.worker',
                    ),
                ),
                (
                    'worker_pool',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='db.workerpool',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='WorkerPoolTaskExecutionStatistics',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('runtime', models.IntegerField()),
                (
                    'scope',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='db.scope',
                    ),
                ),
                (
                    'worker',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to='db.worker',
                    ),
                ),
                (
                    'worker_pool',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='db.workerpool',
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name='worker',
            name='instance_created_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='worker',
            name='worker_pool',
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to='db.workerpool',
            ),
        ),
        migrations.AddField(
            model_name='worker',
            name='worker_pool_data',
            field=models.JSONField(blank=True, null=True),
        ),
        migrations.AddIndex(
            model_name='workerpoolstatistics',
            index=models.Index(
                models.F('timestamp'), name='db_worker_pool_stat_ts_idx'
            ),
        ),
        migrations.AddIndex(
            model_name='workerpooltaskexecutionstatistics',
            index=models.Index(
                models.F('timestamp'), name='db_worker_pool_exec_ts_idx'
            ),
        ),
    ]
