/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "ExtensionGeneratorLogSyntaxHighlighter.h"

// -------------------- constructor --------------------
ExtensionGeneratorLogSyntaxHighlighter::ExtensionGeneratorLogSyntaxHighlighter(QTextDocument* parent) : camitk::SyntaxHighlighter(parent) {

    // in green: Found and not overwritten
    addRule(QStringLiteral(R"re(^- Found.*$)re"), QColor("#008f00"));
    addRule(QStringLiteral(R"re(^.* not overwritten$)re"), QColor("#008f00"));

    // in bold green: OK status, normal output
    addRule(QStringLiteral(R"re(^\[OK\] .*$)re"), QColor("#008f00"), QFont::Bold);
    addRule(QStringLiteral(R"re(^Standard Output:$)re"), QColor("#008f00"), QFont::Bold);

    // in orange: generating
    addRule(QStringLiteral(R"re(^- Generating .*$)re"), QColor("#d58e00"));

    // in bold orange: error
    addRule(QStringLiteral(R"re(^Standard Error:$)re"), QColor("#d58e00"), QFont::Bold);

    // file and directory information in blue
    addRule(QStringLiteral(R"re(^.*CamiTK file:.*$)re"), QColor("#016d9b"));
    addRule(QStringLiteral(R"re(^.* directory:.*$)re"), QColor("#016d9b"));
}
