/*
 * Copyright (C) Bigly Software, Inc, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

package com.biglybt.core.util;

import java.util.List;

public interface
ThreadPoolParent
	<T extends AERunnable>
{
	public String
	getName();
	
	public void
	setMaxThreads(
		int		max );
	
	public int
	getMaxThreads();
	
	public boolean
	isFull();
	
	public int
	getRunningCount();

	public void
	runTask(
		T		task );
	
	public void
	runTask(
		T			task,
		boolean		high_priority,
		boolean		manual_release );

	public List<T>
	getRunningTasks();
	
	public boolean
	isQueued(
		T			task );
	
	public void
	setWarnWhenFull();
	
	public void
	registerThreadAsChild(
		ThreadPoolTask.Worker		worker );
	
	public void
	deregisterThreadAsChild(
		ThreadPoolTask.Worker		worker );
}
