//! Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline secp256k1_montgomery_scalar 32 '2^256 - 432420386565659656852420866394968145599' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//! curve description: secp256k1_montgomery_scalar
//! machine_wordsize = 32 (from "32")
//! requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//! m = 0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141 (from "2^256 - 432420386565659656852420866394968145599")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//!   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248)
//!   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) in
//!                            if x1 & (2^256-1) < 2^255 then x1 & (2^256-1) else (x1 & (2^256-1)) - 2^256

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

/** fiat_secp256k1_montgomery_scalar_u1 represents values of 1 bits, stored in one byte. */
pub type fiat_secp256k1_montgomery_scalar_u1 = u8;
/** fiat_secp256k1_montgomery_scalar_i1 represents values of 1 bits, stored in one byte. */
pub type fiat_secp256k1_montgomery_scalar_i1 = i8;
/** fiat_secp256k1_montgomery_scalar_u2 represents values of 2 bits, stored in one byte. */
pub type fiat_secp256k1_montgomery_scalar_u2 = u8;
/** fiat_secp256k1_montgomery_scalar_i2 represents values of 2 bits, stored in one byte. */
pub type fiat_secp256k1_montgomery_scalar_i2 = i8;

/** The type fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element is a field element in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element(pub [u32; 8]);

impl core::ops::Index<usize> for fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element {
    type Output = u32;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

/** The type fiat_secp256k1_montgomery_scalar_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_secp256k1_montgomery_scalar_non_montgomery_domain_field_element(pub [u32; 8]);

impl core::ops::Index<usize> for fiat_secp256k1_montgomery_scalar_non_montgomery_domain_field_element {
    type Output = u32;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_secp256k1_montgomery_scalar_non_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}


/// The function fiat_secp256k1_montgomery_scalar_addcarryx_u32 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^32
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_addcarryx_u32(out1: &mut u32, out2: &mut fiat_secp256k1_montgomery_scalar_u1, arg1: fiat_secp256k1_montgomery_scalar_u1, arg2: u32, arg3: u32) {
  let x1: u64 = (((arg1 as u64) + (arg2 as u64)) + (arg3 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: fiat_secp256k1_montgomery_scalar_u1 = ((x1 >> 32) as fiat_secp256k1_montgomery_scalar_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_secp256k1_montgomery_scalar_subborrowx_u32 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^32
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_subborrowx_u32(out1: &mut u32, out2: &mut fiat_secp256k1_montgomery_scalar_u1, arg1: fiat_secp256k1_montgomery_scalar_u1, arg2: u32, arg3: u32) {
  let x1: i64 = (((arg2 as i64) - (arg1 as i64)) - (arg3 as i64));
  let x2: fiat_secp256k1_montgomery_scalar_i1 = ((x1 >> 32) as fiat_secp256k1_montgomery_scalar_i1);
  let x3: u32 = ((x1 & (0xffffffff as i64)) as u32);
  *out1 = x3;
  *out2 = (((0x0 as fiat_secp256k1_montgomery_scalar_i2) - (x2 as fiat_secp256k1_montgomery_scalar_i2)) as fiat_secp256k1_montgomery_scalar_u1);
}

/// The function fiat_secp256k1_montgomery_scalar_mulx_u32 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^32
///   out2 = ⌊arg1 * arg2 / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_mulx_u32(out1: &mut u32, out2: &mut u32, arg1: u32, arg2: u32) {
  let x1: u64 = ((arg1 as u64) * (arg2 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: u32 = ((x1 >> 32) as u32);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_secp256k1_montgomery_scalar_cmovznz_u32 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_cmovznz_u32(out1: &mut u32, arg1: fiat_secp256k1_montgomery_scalar_u1, arg2: u32, arg3: u32) {
  let x1: fiat_secp256k1_montgomery_scalar_u1 = (!(!arg1));
  let x2: u32 = ((((((0x0 as fiat_secp256k1_montgomery_scalar_i2) - (x1 as fiat_secp256k1_montgomery_scalar_i2)) as fiat_secp256k1_montgomery_scalar_i1) as i64) & (0xffffffff as i64)) as u32);
  let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_secp256k1_montgomery_scalar_mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_mul(out1: &mut fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element, arg1: &fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element, arg2: &fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element) {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[0]);
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x9, &mut x10, x8, (arg2[7]));
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x11, &mut x12, x8, (arg2[6]));
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x13, &mut x14, x8, (arg2[5]));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x15, &mut x16, x8, (arg2[4]));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x17, &mut x18, x8, (arg2[3]));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x19, &mut x20, x8, (arg2[2]));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x21, &mut x22, x8, (arg2[1]));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x23, &mut x24, x8, (arg2[0]));
  let mut x25: u32 = 0;
  let mut x26: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x25, &mut x26, 0x0, x24, x21);
  let mut x27: u32 = 0;
  let mut x28: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x27, &mut x28, x26, x22, x19);
  let mut x29: u32 = 0;
  let mut x30: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x29, &mut x30, x28, x20, x17);
  let mut x31: u32 = 0;
  let mut x32: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x31, &mut x32, x30, x18, x15);
  let mut x33: u32 = 0;
  let mut x34: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x33, &mut x34, x32, x16, x13);
  let mut x35: u32 = 0;
  let mut x36: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x35, &mut x36, x34, x14, x11);
  let mut x37: u32 = 0;
  let mut x38: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x37, &mut x38, x36, x12, x9);
  let x39: u32 = ((x38 as u32) + x10);
  let mut x40: u32 = 0;
  let mut x41: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x40, &mut x41, x23, 0x5588b13f);
  let mut x42: u32 = 0;
  let mut x43: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x42, &mut x43, x40, 0xffffffff);
  let mut x44: u32 = 0;
  let mut x45: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x44, &mut x45, x40, 0xffffffff);
  let mut x46: u32 = 0;
  let mut x47: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x46, &mut x47, x40, 0xffffffff);
  let mut x48: u32 = 0;
  let mut x49: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x48, &mut x49, x40, 0xfffffffe);
  let mut x50: u32 = 0;
  let mut x51: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x50, &mut x51, x40, 0xbaaedce6);
  let mut x52: u32 = 0;
  let mut x53: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x52, &mut x53, x40, 0xaf48a03b);
  let mut x54: u32 = 0;
  let mut x55: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x54, &mut x55, x40, 0xbfd25e8c);
  let mut x56: u32 = 0;
  let mut x57: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x56, &mut x57, x40, 0xd0364141);
  let mut x58: u32 = 0;
  let mut x59: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x58, &mut x59, 0x0, x57, x54);
  let mut x60: u32 = 0;
  let mut x61: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x60, &mut x61, x59, x55, x52);
  let mut x62: u32 = 0;
  let mut x63: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x62, &mut x63, x61, x53, x50);
  let mut x64: u32 = 0;
  let mut x65: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x64, &mut x65, x63, x51, x48);
  let mut x66: u32 = 0;
  let mut x67: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x66, &mut x67, x65, x49, x46);
  let mut x68: u32 = 0;
  let mut x69: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x68, &mut x69, x67, x47, x44);
  let mut x70: u32 = 0;
  let mut x71: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x70, &mut x71, x69, x45, x42);
  let x72: u32 = ((x71 as u32) + x43);
  let mut x73: u32 = 0;
  let mut x74: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x73, &mut x74, 0x0, x23, x56);
  let mut x75: u32 = 0;
  let mut x76: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x75, &mut x76, x74, x25, x58);
  let mut x77: u32 = 0;
  let mut x78: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x77, &mut x78, x76, x27, x60);
  let mut x79: u32 = 0;
  let mut x80: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x79, &mut x80, x78, x29, x62);
  let mut x81: u32 = 0;
  let mut x82: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x81, &mut x82, x80, x31, x64);
  let mut x83: u32 = 0;
  let mut x84: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x83, &mut x84, x82, x33, x66);
  let mut x85: u32 = 0;
  let mut x86: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x85, &mut x86, x84, x35, x68);
  let mut x87: u32 = 0;
  let mut x88: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x87, &mut x88, x86, x37, x70);
  let mut x89: u32 = 0;
  let mut x90: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x89, &mut x90, x88, x39, x72);
  let mut x91: u32 = 0;
  let mut x92: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x91, &mut x92, x1, (arg2[7]));
  let mut x93: u32 = 0;
  let mut x94: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x93, &mut x94, x1, (arg2[6]));
  let mut x95: u32 = 0;
  let mut x96: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x95, &mut x96, x1, (arg2[5]));
  let mut x97: u32 = 0;
  let mut x98: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x97, &mut x98, x1, (arg2[4]));
  let mut x99: u32 = 0;
  let mut x100: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x99, &mut x100, x1, (arg2[3]));
  let mut x101: u32 = 0;
  let mut x102: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x101, &mut x102, x1, (arg2[2]));
  let mut x103: u32 = 0;
  let mut x104: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x103, &mut x104, x1, (arg2[1]));
  let mut x105: u32 = 0;
  let mut x106: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x105, &mut x106, x1, (arg2[0]));
  let mut x107: u32 = 0;
  let mut x108: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x107, &mut x108, 0x0, x106, x103);
  let mut x109: u32 = 0;
  let mut x110: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x109, &mut x110, x108, x104, x101);
  let mut x111: u32 = 0;
  let mut x112: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x111, &mut x112, x110, x102, x99);
  let mut x113: u32 = 0;
  let mut x114: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x113, &mut x114, x112, x100, x97);
  let mut x115: u32 = 0;
  let mut x116: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x115, &mut x116, x114, x98, x95);
  let mut x117: u32 = 0;
  let mut x118: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x117, &mut x118, x116, x96, x93);
  let mut x119: u32 = 0;
  let mut x120: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x119, &mut x120, x118, x94, x91);
  let x121: u32 = ((x120 as u32) + x92);
  let mut x122: u32 = 0;
  let mut x123: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x122, &mut x123, 0x0, x75, x105);
  let mut x124: u32 = 0;
  let mut x125: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x124, &mut x125, x123, x77, x107);
  let mut x126: u32 = 0;
  let mut x127: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x126, &mut x127, x125, x79, x109);
  let mut x128: u32 = 0;
  let mut x129: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x128, &mut x129, x127, x81, x111);
  let mut x130: u32 = 0;
  let mut x131: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x130, &mut x131, x129, x83, x113);
  let mut x132: u32 = 0;
  let mut x133: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x132, &mut x133, x131, x85, x115);
  let mut x134: u32 = 0;
  let mut x135: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x134, &mut x135, x133, x87, x117);
  let mut x136: u32 = 0;
  let mut x137: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x136, &mut x137, x135, x89, x119);
  let mut x138: u32 = 0;
  let mut x139: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x138, &mut x139, x137, (x90 as u32), x121);
  let mut x140: u32 = 0;
  let mut x141: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x140, &mut x141, x122, 0x5588b13f);
  let mut x142: u32 = 0;
  let mut x143: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x142, &mut x143, x140, 0xffffffff);
  let mut x144: u32 = 0;
  let mut x145: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x144, &mut x145, x140, 0xffffffff);
  let mut x146: u32 = 0;
  let mut x147: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x146, &mut x147, x140, 0xffffffff);
  let mut x148: u32 = 0;
  let mut x149: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x148, &mut x149, x140, 0xfffffffe);
  let mut x150: u32 = 0;
  let mut x151: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x150, &mut x151, x140, 0xbaaedce6);
  let mut x152: u32 = 0;
  let mut x153: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x152, &mut x153, x140, 0xaf48a03b);
  let mut x154: u32 = 0;
  let mut x155: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x154, &mut x155, x140, 0xbfd25e8c);
  let mut x156: u32 = 0;
  let mut x157: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x156, &mut x157, x140, 0xd0364141);
  let mut x158: u32 = 0;
  let mut x159: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x158, &mut x159, 0x0, x157, x154);
  let mut x160: u32 = 0;
  let mut x161: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x160, &mut x161, x159, x155, x152);
  let mut x162: u32 = 0;
  let mut x163: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x162, &mut x163, x161, x153, x150);
  let mut x164: u32 = 0;
  let mut x165: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x164, &mut x165, x163, x151, x148);
  let mut x166: u32 = 0;
  let mut x167: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x166, &mut x167, x165, x149, x146);
  let mut x168: u32 = 0;
  let mut x169: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x168, &mut x169, x167, x147, x144);
  let mut x170: u32 = 0;
  let mut x171: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x170, &mut x171, x169, x145, x142);
  let x172: u32 = ((x171 as u32) + x143);
  let mut x173: u32 = 0;
  let mut x174: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x173, &mut x174, 0x0, x122, x156);
  let mut x175: u32 = 0;
  let mut x176: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x175, &mut x176, x174, x124, x158);
  let mut x177: u32 = 0;
  let mut x178: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x177, &mut x178, x176, x126, x160);
  let mut x179: u32 = 0;
  let mut x180: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x179, &mut x180, x178, x128, x162);
  let mut x181: u32 = 0;
  let mut x182: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x181, &mut x182, x180, x130, x164);
  let mut x183: u32 = 0;
  let mut x184: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x183, &mut x184, x182, x132, x166);
  let mut x185: u32 = 0;
  let mut x186: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x185, &mut x186, x184, x134, x168);
  let mut x187: u32 = 0;
  let mut x188: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x187, &mut x188, x186, x136, x170);
  let mut x189: u32 = 0;
  let mut x190: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x189, &mut x190, x188, x138, x172);
  let x191: u32 = ((x190 as u32) + (x139 as u32));
  let mut x192: u32 = 0;
  let mut x193: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x192, &mut x193, x2, (arg2[7]));
  let mut x194: u32 = 0;
  let mut x195: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x194, &mut x195, x2, (arg2[6]));
  let mut x196: u32 = 0;
  let mut x197: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x196, &mut x197, x2, (arg2[5]));
  let mut x198: u32 = 0;
  let mut x199: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x198, &mut x199, x2, (arg2[4]));
  let mut x200: u32 = 0;
  let mut x201: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x200, &mut x201, x2, (arg2[3]));
  let mut x202: u32 = 0;
  let mut x203: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x202, &mut x203, x2, (arg2[2]));
  let mut x204: u32 = 0;
  let mut x205: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x204, &mut x205, x2, (arg2[1]));
  let mut x206: u32 = 0;
  let mut x207: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x206, &mut x207, x2, (arg2[0]));
  let mut x208: u32 = 0;
  let mut x209: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x208, &mut x209, 0x0, x207, x204);
  let mut x210: u32 = 0;
  let mut x211: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x210, &mut x211, x209, x205, x202);
  let mut x212: u32 = 0;
  let mut x213: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x212, &mut x213, x211, x203, x200);
  let mut x214: u32 = 0;
  let mut x215: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x214, &mut x215, x213, x201, x198);
  let mut x216: u32 = 0;
  let mut x217: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x216, &mut x217, x215, x199, x196);
  let mut x218: u32 = 0;
  let mut x219: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x218, &mut x219, x217, x197, x194);
  let mut x220: u32 = 0;
  let mut x221: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x220, &mut x221, x219, x195, x192);
  let x222: u32 = ((x221 as u32) + x193);
  let mut x223: u32 = 0;
  let mut x224: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x223, &mut x224, 0x0, x175, x206);
  let mut x225: u32 = 0;
  let mut x226: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x225, &mut x226, x224, x177, x208);
  let mut x227: u32 = 0;
  let mut x228: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x227, &mut x228, x226, x179, x210);
  let mut x229: u32 = 0;
  let mut x230: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x229, &mut x230, x228, x181, x212);
  let mut x231: u32 = 0;
  let mut x232: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x231, &mut x232, x230, x183, x214);
  let mut x233: u32 = 0;
  let mut x234: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x233, &mut x234, x232, x185, x216);
  let mut x235: u32 = 0;
  let mut x236: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x235, &mut x236, x234, x187, x218);
  let mut x237: u32 = 0;
  let mut x238: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x237, &mut x238, x236, x189, x220);
  let mut x239: u32 = 0;
  let mut x240: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x239, &mut x240, x238, x191, x222);
  let mut x241: u32 = 0;
  let mut x242: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x241, &mut x242, x223, 0x5588b13f);
  let mut x243: u32 = 0;
  let mut x244: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x243, &mut x244, x241, 0xffffffff);
  let mut x245: u32 = 0;
  let mut x246: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x245, &mut x246, x241, 0xffffffff);
  let mut x247: u32 = 0;
  let mut x248: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x247, &mut x248, x241, 0xffffffff);
  let mut x249: u32 = 0;
  let mut x250: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x249, &mut x250, x241, 0xfffffffe);
  let mut x251: u32 = 0;
  let mut x252: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x251, &mut x252, x241, 0xbaaedce6);
  let mut x253: u32 = 0;
  let mut x254: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x253, &mut x254, x241, 0xaf48a03b);
  let mut x255: u32 = 0;
  let mut x256: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x255, &mut x256, x241, 0xbfd25e8c);
  let mut x257: u32 = 0;
  let mut x258: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x257, &mut x258, x241, 0xd0364141);
  let mut x259: u32 = 0;
  let mut x260: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x259, &mut x260, 0x0, x258, x255);
  let mut x261: u32 = 0;
  let mut x262: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x261, &mut x262, x260, x256, x253);
  let mut x263: u32 = 0;
  let mut x264: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x263, &mut x264, x262, x254, x251);
  let mut x265: u32 = 0;
  let mut x266: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x265, &mut x266, x264, x252, x249);
  let mut x267: u32 = 0;
  let mut x268: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x267, &mut x268, x266, x250, x247);
  let mut x269: u32 = 0;
  let mut x270: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x269, &mut x270, x268, x248, x245);
  let mut x271: u32 = 0;
  let mut x272: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x271, &mut x272, x270, x246, x243);
  let x273: u32 = ((x272 as u32) + x244);
  let mut x274: u32 = 0;
  let mut x275: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x274, &mut x275, 0x0, x223, x257);
  let mut x276: u32 = 0;
  let mut x277: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x276, &mut x277, x275, x225, x259);
  let mut x278: u32 = 0;
  let mut x279: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x278, &mut x279, x277, x227, x261);
  let mut x280: u32 = 0;
  let mut x281: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x280, &mut x281, x279, x229, x263);
  let mut x282: u32 = 0;
  let mut x283: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x282, &mut x283, x281, x231, x265);
  let mut x284: u32 = 0;
  let mut x285: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x284, &mut x285, x283, x233, x267);
  let mut x286: u32 = 0;
  let mut x287: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x286, &mut x287, x285, x235, x269);
  let mut x288: u32 = 0;
  let mut x289: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x288, &mut x289, x287, x237, x271);
  let mut x290: u32 = 0;
  let mut x291: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x290, &mut x291, x289, x239, x273);
  let x292: u32 = ((x291 as u32) + (x240 as u32));
  let mut x293: u32 = 0;
  let mut x294: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x293, &mut x294, x3, (arg2[7]));
  let mut x295: u32 = 0;
  let mut x296: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x295, &mut x296, x3, (arg2[6]));
  let mut x297: u32 = 0;
  let mut x298: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x297, &mut x298, x3, (arg2[5]));
  let mut x299: u32 = 0;
  let mut x300: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x299, &mut x300, x3, (arg2[4]));
  let mut x301: u32 = 0;
  let mut x302: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x301, &mut x302, x3, (arg2[3]));
  let mut x303: u32 = 0;
  let mut x304: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x303, &mut x304, x3, (arg2[2]));
  let mut x305: u32 = 0;
  let mut x306: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x305, &mut x306, x3, (arg2[1]));
  let mut x307: u32 = 0;
  let mut x308: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x307, &mut x308, x3, (arg2[0]));
  let mut x309: u32 = 0;
  let mut x310: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x309, &mut x310, 0x0, x308, x305);
  let mut x311: u32 = 0;
  let mut x312: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x311, &mut x312, x310, x306, x303);
  let mut x313: u32 = 0;
  let mut x314: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x313, &mut x314, x312, x304, x301);
  let mut x315: u32 = 0;
  let mut x316: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x315, &mut x316, x314, x302, x299);
  let mut x317: u32 = 0;
  let mut x318: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x317, &mut x318, x316, x300, x297);
  let mut x319: u32 = 0;
  let mut x320: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x319, &mut x320, x318, x298, x295);
  let mut x321: u32 = 0;
  let mut x322: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x321, &mut x322, x320, x296, x293);
  let x323: u32 = ((x322 as u32) + x294);
  let mut x324: u32 = 0;
  let mut x325: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x324, &mut x325, 0x0, x276, x307);
  let mut x326: u32 = 0;
  let mut x327: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x326, &mut x327, x325, x278, x309);
  let mut x328: u32 = 0;
  let mut x329: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x328, &mut x329, x327, x280, x311);
  let mut x330: u32 = 0;
  let mut x331: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x330, &mut x331, x329, x282, x313);
  let mut x332: u32 = 0;
  let mut x333: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x332, &mut x333, x331, x284, x315);
  let mut x334: u32 = 0;
  let mut x335: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x334, &mut x335, x333, x286, x317);
  let mut x336: u32 = 0;
  let mut x337: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x336, &mut x337, x335, x288, x319);
  let mut x338: u32 = 0;
  let mut x339: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x338, &mut x339, x337, x290, x321);
  let mut x340: u32 = 0;
  let mut x341: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x340, &mut x341, x339, x292, x323);
  let mut x342: u32 = 0;
  let mut x343: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x342, &mut x343, x324, 0x5588b13f);
  let mut x344: u32 = 0;
  let mut x345: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x344, &mut x345, x342, 0xffffffff);
  let mut x346: u32 = 0;
  let mut x347: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x346, &mut x347, x342, 0xffffffff);
  let mut x348: u32 = 0;
  let mut x349: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x348, &mut x349, x342, 0xffffffff);
  let mut x350: u32 = 0;
  let mut x351: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x350, &mut x351, x342, 0xfffffffe);
  let mut x352: u32 = 0;
  let mut x353: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x352, &mut x353, x342, 0xbaaedce6);
  let mut x354: u32 = 0;
  let mut x355: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x354, &mut x355, x342, 0xaf48a03b);
  let mut x356: u32 = 0;
  let mut x357: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x356, &mut x357, x342, 0xbfd25e8c);
  let mut x358: u32 = 0;
  let mut x359: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x358, &mut x359, x342, 0xd0364141);
  let mut x360: u32 = 0;
  let mut x361: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x360, &mut x361, 0x0, x359, x356);
  let mut x362: u32 = 0;
  let mut x363: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x362, &mut x363, x361, x357, x354);
  let mut x364: u32 = 0;
  let mut x365: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x364, &mut x365, x363, x355, x352);
  let mut x366: u32 = 0;
  let mut x367: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x366, &mut x367, x365, x353, x350);
  let mut x368: u32 = 0;
  let mut x369: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x368, &mut x369, x367, x351, x348);
  let mut x370: u32 = 0;
  let mut x371: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x370, &mut x371, x369, x349, x346);
  let mut x372: u32 = 0;
  let mut x373: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x372, &mut x373, x371, x347, x344);
  let x374: u32 = ((x373 as u32) + x345);
  let mut x375: u32 = 0;
  let mut x376: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x375, &mut x376, 0x0, x324, x358);
  let mut x377: u32 = 0;
  let mut x378: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x377, &mut x378, x376, x326, x360);
  let mut x379: u32 = 0;
  let mut x380: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x379, &mut x380, x378, x328, x362);
  let mut x381: u32 = 0;
  let mut x382: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x381, &mut x382, x380, x330, x364);
  let mut x383: u32 = 0;
  let mut x384: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x383, &mut x384, x382, x332, x366);
  let mut x385: u32 = 0;
  let mut x386: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x385, &mut x386, x384, x334, x368);
  let mut x387: u32 = 0;
  let mut x388: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x387, &mut x388, x386, x336, x370);
  let mut x389: u32 = 0;
  let mut x390: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x389, &mut x390, x388, x338, x372);
  let mut x391: u32 = 0;
  let mut x392: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x391, &mut x392, x390, x340, x374);
  let x393: u32 = ((x392 as u32) + (x341 as u32));
  let mut x394: u32 = 0;
  let mut x395: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x394, &mut x395, x4, (arg2[7]));
  let mut x396: u32 = 0;
  let mut x397: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x396, &mut x397, x4, (arg2[6]));
  let mut x398: u32 = 0;
  let mut x399: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x398, &mut x399, x4, (arg2[5]));
  let mut x400: u32 = 0;
  let mut x401: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x400, &mut x401, x4, (arg2[4]));
  let mut x402: u32 = 0;
  let mut x403: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x402, &mut x403, x4, (arg2[3]));
  let mut x404: u32 = 0;
  let mut x405: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x404, &mut x405, x4, (arg2[2]));
  let mut x406: u32 = 0;
  let mut x407: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x406, &mut x407, x4, (arg2[1]));
  let mut x408: u32 = 0;
  let mut x409: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x408, &mut x409, x4, (arg2[0]));
  let mut x410: u32 = 0;
  let mut x411: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x410, &mut x411, 0x0, x409, x406);
  let mut x412: u32 = 0;
  let mut x413: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x412, &mut x413, x411, x407, x404);
  let mut x414: u32 = 0;
  let mut x415: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x414, &mut x415, x413, x405, x402);
  let mut x416: u32 = 0;
  let mut x417: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x416, &mut x417, x415, x403, x400);
  let mut x418: u32 = 0;
  let mut x419: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x418, &mut x419, x417, x401, x398);
  let mut x420: u32 = 0;
  let mut x421: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x420, &mut x421, x419, x399, x396);
  let mut x422: u32 = 0;
  let mut x423: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x422, &mut x423, x421, x397, x394);
  let x424: u32 = ((x423 as u32) + x395);
  let mut x425: u32 = 0;
  let mut x426: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x425, &mut x426, 0x0, x377, x408);
  let mut x427: u32 = 0;
  let mut x428: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x427, &mut x428, x426, x379, x410);
  let mut x429: u32 = 0;
  let mut x430: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x429, &mut x430, x428, x381, x412);
  let mut x431: u32 = 0;
  let mut x432: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x431, &mut x432, x430, x383, x414);
  let mut x433: u32 = 0;
  let mut x434: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x433, &mut x434, x432, x385, x416);
  let mut x435: u32 = 0;
  let mut x436: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x435, &mut x436, x434, x387, x418);
  let mut x437: u32 = 0;
  let mut x438: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x437, &mut x438, x436, x389, x420);
  let mut x439: u32 = 0;
  let mut x440: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x439, &mut x440, x438, x391, x422);
  let mut x441: u32 = 0;
  let mut x442: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x441, &mut x442, x440, x393, x424);
  let mut x443: u32 = 0;
  let mut x444: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x443, &mut x444, x425, 0x5588b13f);
  let mut x445: u32 = 0;
  let mut x446: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x445, &mut x446, x443, 0xffffffff);
  let mut x447: u32 = 0;
  let mut x448: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x447, &mut x448, x443, 0xffffffff);
  let mut x449: u32 = 0;
  let mut x450: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x449, &mut x450, x443, 0xffffffff);
  let mut x451: u32 = 0;
  let mut x452: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x451, &mut x452, x443, 0xfffffffe);
  let mut x453: u32 = 0;
  let mut x454: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x453, &mut x454, x443, 0xbaaedce6);
  let mut x455: u32 = 0;
  let mut x456: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x455, &mut x456, x443, 0xaf48a03b);
  let mut x457: u32 = 0;
  let mut x458: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x457, &mut x458, x443, 0xbfd25e8c);
  let mut x459: u32 = 0;
  let mut x460: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x459, &mut x460, x443, 0xd0364141);
  let mut x461: u32 = 0;
  let mut x462: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x461, &mut x462, 0x0, x460, x457);
  let mut x463: u32 = 0;
  let mut x464: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x463, &mut x464, x462, x458, x455);
  let mut x465: u32 = 0;
  let mut x466: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x465, &mut x466, x464, x456, x453);
  let mut x467: u32 = 0;
  let mut x468: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x467, &mut x468, x466, x454, x451);
  let mut x469: u32 = 0;
  let mut x470: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x469, &mut x470, x468, x452, x449);
  let mut x471: u32 = 0;
  let mut x472: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x471, &mut x472, x470, x450, x447);
  let mut x473: u32 = 0;
  let mut x474: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x473, &mut x474, x472, x448, x445);
  let x475: u32 = ((x474 as u32) + x446);
  let mut x476: u32 = 0;
  let mut x477: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x476, &mut x477, 0x0, x425, x459);
  let mut x478: u32 = 0;
  let mut x479: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x478, &mut x479, x477, x427, x461);
  let mut x480: u32 = 0;
  let mut x481: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x480, &mut x481, x479, x429, x463);
  let mut x482: u32 = 0;
  let mut x483: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x482, &mut x483, x481, x431, x465);
  let mut x484: u32 = 0;
  let mut x485: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x484, &mut x485, x483, x433, x467);
  let mut x486: u32 = 0;
  let mut x487: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x486, &mut x487, x485, x435, x469);
  let mut x488: u32 = 0;
  let mut x489: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x488, &mut x489, x487, x437, x471);
  let mut x490: u32 = 0;
  let mut x491: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x490, &mut x491, x489, x439, x473);
  let mut x492: u32 = 0;
  let mut x493: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x492, &mut x493, x491, x441, x475);
  let x494: u32 = ((x493 as u32) + (x442 as u32));
  let mut x495: u32 = 0;
  let mut x496: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x495, &mut x496, x5, (arg2[7]));
  let mut x497: u32 = 0;
  let mut x498: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x497, &mut x498, x5, (arg2[6]));
  let mut x499: u32 = 0;
  let mut x500: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x499, &mut x500, x5, (arg2[5]));
  let mut x501: u32 = 0;
  let mut x502: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x501, &mut x502, x5, (arg2[4]));
  let mut x503: u32 = 0;
  let mut x504: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x503, &mut x504, x5, (arg2[3]));
  let mut x505: u32 = 0;
  let mut x506: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x505, &mut x506, x5, (arg2[2]));
  let mut x507: u32 = 0;
  let mut x508: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x507, &mut x508, x5, (arg2[1]));
  let mut x509: u32 = 0;
  let mut x510: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x509, &mut x510, x5, (arg2[0]));
  let mut x511: u32 = 0;
  let mut x512: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x511, &mut x512, 0x0, x510, x507);
  let mut x513: u32 = 0;
  let mut x514: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x513, &mut x514, x512, x508, x505);
  let mut x515: u32 = 0;
  let mut x516: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x515, &mut x516, x514, x506, x503);
  let mut x517: u32 = 0;
  let mut x518: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x517, &mut x518, x516, x504, x501);
  let mut x519: u32 = 0;
  let mut x520: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x519, &mut x520, x518, x502, x499);
  let mut x521: u32 = 0;
  let mut x522: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x521, &mut x522, x520, x500, x497);
  let mut x523: u32 = 0;
  let mut x524: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x523, &mut x524, x522, x498, x495);
  let x525: u32 = ((x524 as u32) + x496);
  let mut x526: u32 = 0;
  let mut x527: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x526, &mut x527, 0x0, x478, x509);
  let mut x528: u32 = 0;
  let mut x529: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x528, &mut x529, x527, x480, x511);
  let mut x530: u32 = 0;
  let mut x531: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x530, &mut x531, x529, x482, x513);
  let mut x532: u32 = 0;
  let mut x533: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x532, &mut x533, x531, x484, x515);
  let mut x534: u32 = 0;
  let mut x535: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x534, &mut x535, x533, x486, x517);
  let mut x536: u32 = 0;
  let mut x537: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x536, &mut x537, x535, x488, x519);
  let mut x538: u32 = 0;
  let mut x539: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x538, &mut x539, x537, x490, x521);
  let mut x540: u32 = 0;
  let mut x541: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x540, &mut x541, x539, x492, x523);
  let mut x542: u32 = 0;
  let mut x543: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x542, &mut x543, x541, x494, x525);
  let mut x544: u32 = 0;
  let mut x545: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x544, &mut x545, x526, 0x5588b13f);
  let mut x546: u32 = 0;
  let mut x547: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x546, &mut x547, x544, 0xffffffff);
  let mut x548: u32 = 0;
  let mut x549: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x548, &mut x549, x544, 0xffffffff);
  let mut x550: u32 = 0;
  let mut x551: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x550, &mut x551, x544, 0xffffffff);
  let mut x552: u32 = 0;
  let mut x553: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x552, &mut x553, x544, 0xfffffffe);
  let mut x554: u32 = 0;
  let mut x555: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x554, &mut x555, x544, 0xbaaedce6);
  let mut x556: u32 = 0;
  let mut x557: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x556, &mut x557, x544, 0xaf48a03b);
  let mut x558: u32 = 0;
  let mut x559: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x558, &mut x559, x544, 0xbfd25e8c);
  let mut x560: u32 = 0;
  let mut x561: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x560, &mut x561, x544, 0xd0364141);
  let mut x562: u32 = 0;
  let mut x563: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x562, &mut x563, 0x0, x561, x558);
  let mut x564: u32 = 0;
  let mut x565: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x564, &mut x565, x563, x559, x556);
  let mut x566: u32 = 0;
  let mut x567: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x566, &mut x567, x565, x557, x554);
  let mut x568: u32 = 0;
  let mut x569: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x568, &mut x569, x567, x555, x552);
  let mut x570: u32 = 0;
  let mut x571: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x570, &mut x571, x569, x553, x550);
  let mut x572: u32 = 0;
  let mut x573: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x572, &mut x573, x571, x551, x548);
  let mut x574: u32 = 0;
  let mut x575: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x574, &mut x575, x573, x549, x546);
  let x576: u32 = ((x575 as u32) + x547);
  let mut x577: u32 = 0;
  let mut x578: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x577, &mut x578, 0x0, x526, x560);
  let mut x579: u32 = 0;
  let mut x580: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x579, &mut x580, x578, x528, x562);
  let mut x581: u32 = 0;
  let mut x582: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x581, &mut x582, x580, x530, x564);
  let mut x583: u32 = 0;
  let mut x584: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x583, &mut x584, x582, x532, x566);
  let mut x585: u32 = 0;
  let mut x586: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x585, &mut x586, x584, x534, x568);
  let mut x587: u32 = 0;
  let mut x588: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x587, &mut x588, x586, x536, x570);
  let mut x589: u32 = 0;
  let mut x590: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x589, &mut x590, x588, x538, x572);
  let mut x591: u32 = 0;
  let mut x592: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x591, &mut x592, x590, x540, x574);
  let mut x593: u32 = 0;
  let mut x594: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x593, &mut x594, x592, x542, x576);
  let x595: u32 = ((x594 as u32) + (x543 as u32));
  let mut x596: u32 = 0;
  let mut x597: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x596, &mut x597, x6, (arg2[7]));
  let mut x598: u32 = 0;
  let mut x599: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x598, &mut x599, x6, (arg2[6]));
  let mut x600: u32 = 0;
  let mut x601: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x600, &mut x601, x6, (arg2[5]));
  let mut x602: u32 = 0;
  let mut x603: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x602, &mut x603, x6, (arg2[4]));
  let mut x604: u32 = 0;
  let mut x605: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x604, &mut x605, x6, (arg2[3]));
  let mut x606: u32 = 0;
  let mut x607: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x606, &mut x607, x6, (arg2[2]));
  let mut x608: u32 = 0;
  let mut x609: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x608, &mut x609, x6, (arg2[1]));
  let mut x610: u32 = 0;
  let mut x611: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x610, &mut x611, x6, (arg2[0]));
  let mut x612: u32 = 0;
  let mut x613: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x612, &mut x613, 0x0, x611, x608);
  let mut x614: u32 = 0;
  let mut x615: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x614, &mut x615, x613, x609, x606);
  let mut x616: u32 = 0;
  let mut x617: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x616, &mut x617, x615, x607, x604);
  let mut x618: u32 = 0;
  let mut x619: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x618, &mut x619, x617, x605, x602);
  let mut x620: u32 = 0;
  let mut x621: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x620, &mut x621, x619, x603, x600);
  let mut x622: u32 = 0;
  let mut x623: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x622, &mut x623, x621, x601, x598);
  let mut x624: u32 = 0;
  let mut x625: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x624, &mut x625, x623, x599, x596);
  let x626: u32 = ((x625 as u32) + x597);
  let mut x627: u32 = 0;
  let mut x628: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x627, &mut x628, 0x0, x579, x610);
  let mut x629: u32 = 0;
  let mut x630: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x629, &mut x630, x628, x581, x612);
  let mut x631: u32 = 0;
  let mut x632: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x631, &mut x632, x630, x583, x614);
  let mut x633: u32 = 0;
  let mut x634: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x633, &mut x634, x632, x585, x616);
  let mut x635: u32 = 0;
  let mut x636: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x635, &mut x636, x634, x587, x618);
  let mut x637: u32 = 0;
  let mut x638: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x637, &mut x638, x636, x589, x620);
  let mut x639: u32 = 0;
  let mut x640: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x639, &mut x640, x638, x591, x622);
  let mut x641: u32 = 0;
  let mut x642: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x641, &mut x642, x640, x593, x624);
  let mut x643: u32 = 0;
  let mut x644: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x643, &mut x644, x642, x595, x626);
  let mut x645: u32 = 0;
  let mut x646: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x645, &mut x646, x627, 0x5588b13f);
  let mut x647: u32 = 0;
  let mut x648: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x647, &mut x648, x645, 0xffffffff);
  let mut x649: u32 = 0;
  let mut x650: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x649, &mut x650, x645, 0xffffffff);
  let mut x651: u32 = 0;
  let mut x652: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x651, &mut x652, x645, 0xffffffff);
  let mut x653: u32 = 0;
  let mut x654: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x653, &mut x654, x645, 0xfffffffe);
  let mut x655: u32 = 0;
  let mut x656: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x655, &mut x656, x645, 0xbaaedce6);
  let mut x657: u32 = 0;
  let mut x658: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x657, &mut x658, x645, 0xaf48a03b);
  let mut x659: u32 = 0;
  let mut x660: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x659, &mut x660, x645, 0xbfd25e8c);
  let mut x661: u32 = 0;
  let mut x662: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x661, &mut x662, x645, 0xd0364141);
  let mut x663: u32 = 0;
  let mut x664: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x663, &mut x664, 0x0, x662, x659);
  let mut x665: u32 = 0;
  let mut x666: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x665, &mut x666, x664, x660, x657);
  let mut x667: u32 = 0;
  let mut x668: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x667, &mut x668, x666, x658, x655);
  let mut x669: u32 = 0;
  let mut x670: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x669, &mut x670, x668, x656, x653);
  let mut x671: u32 = 0;
  let mut x672: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x671, &mut x672, x670, x654, x651);
  let mut x673: u32 = 0;
  let mut x674: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x673, &mut x674, x672, x652, x649);
  let mut x675: u32 = 0;
  let mut x676: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x675, &mut x676, x674, x650, x647);
  let x677: u32 = ((x676 as u32) + x648);
  let mut x678: u32 = 0;
  let mut x679: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x678, &mut x679, 0x0, x627, x661);
  let mut x680: u32 = 0;
  let mut x681: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x680, &mut x681, x679, x629, x663);
  let mut x682: u32 = 0;
  let mut x683: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x682, &mut x683, x681, x631, x665);
  let mut x684: u32 = 0;
  let mut x685: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x684, &mut x685, x683, x633, x667);
  let mut x686: u32 = 0;
  let mut x687: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x686, &mut x687, x685, x635, x669);
  let mut x688: u32 = 0;
  let mut x689: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x688, &mut x689, x687, x637, x671);
  let mut x690: u32 = 0;
  let mut x691: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x690, &mut x691, x689, x639, x673);
  let mut x692: u32 = 0;
  let mut x693: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x692, &mut x693, x691, x641, x675);
  let mut x694: u32 = 0;
  let mut x695: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x694, &mut x695, x693, x643, x677);
  let x696: u32 = ((x695 as u32) + (x644 as u32));
  let mut x697: u32 = 0;
  let mut x698: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x697, &mut x698, x7, (arg2[7]));
  let mut x699: u32 = 0;
  let mut x700: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x699, &mut x700, x7, (arg2[6]));
  let mut x701: u32 = 0;
  let mut x702: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x701, &mut x702, x7, (arg2[5]));
  let mut x703: u32 = 0;
  let mut x704: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x703, &mut x704, x7, (arg2[4]));
  let mut x705: u32 = 0;
  let mut x706: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x705, &mut x706, x7, (arg2[3]));
  let mut x707: u32 = 0;
  let mut x708: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x707, &mut x708, x7, (arg2[2]));
  let mut x709: u32 = 0;
  let mut x710: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x709, &mut x710, x7, (arg2[1]));
  let mut x711: u32 = 0;
  let mut x712: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x711, &mut x712, x7, (arg2[0]));
  let mut x713: u32 = 0;
  let mut x714: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x713, &mut x714, 0x0, x712, x709);
  let mut x715: u32 = 0;
  let mut x716: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x715, &mut x716, x714, x710, x707);
  let mut x717: u32 = 0;
  let mut x718: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x717, &mut x718, x716, x708, x705);
  let mut x719: u32 = 0;
  let mut x720: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x719, &mut x720, x718, x706, x703);
  let mut x721: u32 = 0;
  let mut x722: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x721, &mut x722, x720, x704, x701);
  let mut x723: u32 = 0;
  let mut x724: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x723, &mut x724, x722, x702, x699);
  let mut x725: u32 = 0;
  let mut x726: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x725, &mut x726, x724, x700, x697);
  let x727: u32 = ((x726 as u32) + x698);
  let mut x728: u32 = 0;
  let mut x729: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x728, &mut x729, 0x0, x680, x711);
  let mut x730: u32 = 0;
  let mut x731: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x730, &mut x731, x729, x682, x713);
  let mut x732: u32 = 0;
  let mut x733: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x732, &mut x733, x731, x684, x715);
  let mut x734: u32 = 0;
  let mut x735: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x734, &mut x735, x733, x686, x717);
  let mut x736: u32 = 0;
  let mut x737: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x736, &mut x737, x735, x688, x719);
  let mut x738: u32 = 0;
  let mut x739: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x738, &mut x739, x737, x690, x721);
  let mut x740: u32 = 0;
  let mut x741: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x740, &mut x741, x739, x692, x723);
  let mut x742: u32 = 0;
  let mut x743: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x742, &mut x743, x741, x694, x725);
  let mut x744: u32 = 0;
  let mut x745: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x744, &mut x745, x743, x696, x727);
  let mut x746: u32 = 0;
  let mut x747: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x746, &mut x747, x728, 0x5588b13f);
  let mut x748: u32 = 0;
  let mut x749: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x748, &mut x749, x746, 0xffffffff);
  let mut x750: u32 = 0;
  let mut x751: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x750, &mut x751, x746, 0xffffffff);
  let mut x752: u32 = 0;
  let mut x753: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x752, &mut x753, x746, 0xffffffff);
  let mut x754: u32 = 0;
  let mut x755: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x754, &mut x755, x746, 0xfffffffe);
  let mut x756: u32 = 0;
  let mut x757: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x756, &mut x757, x746, 0xbaaedce6);
  let mut x758: u32 = 0;
  let mut x759: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x758, &mut x759, x746, 0xaf48a03b);
  let mut x760: u32 = 0;
  let mut x761: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x760, &mut x761, x746, 0xbfd25e8c);
  let mut x762: u32 = 0;
  let mut x763: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x762, &mut x763, x746, 0xd0364141);
  let mut x764: u32 = 0;
  let mut x765: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x764, &mut x765, 0x0, x763, x760);
  let mut x766: u32 = 0;
  let mut x767: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x766, &mut x767, x765, x761, x758);
  let mut x768: u32 = 0;
  let mut x769: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x768, &mut x769, x767, x759, x756);
  let mut x770: u32 = 0;
  let mut x771: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x770, &mut x771, x769, x757, x754);
  let mut x772: u32 = 0;
  let mut x773: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x772, &mut x773, x771, x755, x752);
  let mut x774: u32 = 0;
  let mut x775: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x774, &mut x775, x773, x753, x750);
  let mut x776: u32 = 0;
  let mut x777: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x776, &mut x777, x775, x751, x748);
  let x778: u32 = ((x777 as u32) + x749);
  let mut x779: u32 = 0;
  let mut x780: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x779, &mut x780, 0x0, x728, x762);
  let mut x781: u32 = 0;
  let mut x782: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x781, &mut x782, x780, x730, x764);
  let mut x783: u32 = 0;
  let mut x784: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x783, &mut x784, x782, x732, x766);
  let mut x785: u32 = 0;
  let mut x786: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x785, &mut x786, x784, x734, x768);
  let mut x787: u32 = 0;
  let mut x788: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x787, &mut x788, x786, x736, x770);
  let mut x789: u32 = 0;
  let mut x790: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x789, &mut x790, x788, x738, x772);
  let mut x791: u32 = 0;
  let mut x792: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x791, &mut x792, x790, x740, x774);
  let mut x793: u32 = 0;
  let mut x794: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x793, &mut x794, x792, x742, x776);
  let mut x795: u32 = 0;
  let mut x796: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x795, &mut x796, x794, x744, x778);
  let x797: u32 = ((x796 as u32) + (x745 as u32));
  let mut x798: u32 = 0;
  let mut x799: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x798, &mut x799, 0x0, x781, 0xd0364141);
  let mut x800: u32 = 0;
  let mut x801: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x800, &mut x801, x799, x783, 0xbfd25e8c);
  let mut x802: u32 = 0;
  let mut x803: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x802, &mut x803, x801, x785, 0xaf48a03b);
  let mut x804: u32 = 0;
  let mut x805: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x804, &mut x805, x803, x787, 0xbaaedce6);
  let mut x806: u32 = 0;
  let mut x807: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x806, &mut x807, x805, x789, 0xfffffffe);
  let mut x808: u32 = 0;
  let mut x809: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x808, &mut x809, x807, x791, 0xffffffff);
  let mut x810: u32 = 0;
  let mut x811: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x810, &mut x811, x809, x793, 0xffffffff);
  let mut x812: u32 = 0;
  let mut x813: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x812, &mut x813, x811, x795, 0xffffffff);
  let mut x814: u32 = 0;
  let mut x815: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x814, &mut x815, x813, x797, (0x0 as u32));
  let mut x816: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x816, x815, x798, x781);
  let mut x817: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x817, x815, x800, x783);
  let mut x818: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x818, x815, x802, x785);
  let mut x819: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x819, x815, x804, x787);
  let mut x820: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x820, x815, x806, x789);
  let mut x821: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x821, x815, x808, x791);
  let mut x822: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x822, x815, x810, x793);
  let mut x823: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x823, x815, x812, x795);
  out1[0] = x816;
  out1[1] = x817;
  out1[2] = x818;
  out1[3] = x819;
  out1[4] = x820;
  out1[5] = x821;
  out1[6] = x822;
  out1[7] = x823;
}

/// The function fiat_secp256k1_montgomery_scalar_square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_square(out1: &mut fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element, arg1: &fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element) {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[0]);
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x9, &mut x10, x8, (arg1[7]));
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x11, &mut x12, x8, (arg1[6]));
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x13, &mut x14, x8, (arg1[5]));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x15, &mut x16, x8, (arg1[4]));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x17, &mut x18, x8, (arg1[3]));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x19, &mut x20, x8, (arg1[2]));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x21, &mut x22, x8, (arg1[1]));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x23, &mut x24, x8, (arg1[0]));
  let mut x25: u32 = 0;
  let mut x26: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x25, &mut x26, 0x0, x24, x21);
  let mut x27: u32 = 0;
  let mut x28: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x27, &mut x28, x26, x22, x19);
  let mut x29: u32 = 0;
  let mut x30: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x29, &mut x30, x28, x20, x17);
  let mut x31: u32 = 0;
  let mut x32: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x31, &mut x32, x30, x18, x15);
  let mut x33: u32 = 0;
  let mut x34: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x33, &mut x34, x32, x16, x13);
  let mut x35: u32 = 0;
  let mut x36: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x35, &mut x36, x34, x14, x11);
  let mut x37: u32 = 0;
  let mut x38: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x37, &mut x38, x36, x12, x9);
  let x39: u32 = ((x38 as u32) + x10);
  let mut x40: u32 = 0;
  let mut x41: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x40, &mut x41, x23, 0x5588b13f);
  let mut x42: u32 = 0;
  let mut x43: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x42, &mut x43, x40, 0xffffffff);
  let mut x44: u32 = 0;
  let mut x45: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x44, &mut x45, x40, 0xffffffff);
  let mut x46: u32 = 0;
  let mut x47: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x46, &mut x47, x40, 0xffffffff);
  let mut x48: u32 = 0;
  let mut x49: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x48, &mut x49, x40, 0xfffffffe);
  let mut x50: u32 = 0;
  let mut x51: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x50, &mut x51, x40, 0xbaaedce6);
  let mut x52: u32 = 0;
  let mut x53: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x52, &mut x53, x40, 0xaf48a03b);
  let mut x54: u32 = 0;
  let mut x55: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x54, &mut x55, x40, 0xbfd25e8c);
  let mut x56: u32 = 0;
  let mut x57: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x56, &mut x57, x40, 0xd0364141);
  let mut x58: u32 = 0;
  let mut x59: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x58, &mut x59, 0x0, x57, x54);
  let mut x60: u32 = 0;
  let mut x61: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x60, &mut x61, x59, x55, x52);
  let mut x62: u32 = 0;
  let mut x63: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x62, &mut x63, x61, x53, x50);
  let mut x64: u32 = 0;
  let mut x65: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x64, &mut x65, x63, x51, x48);
  let mut x66: u32 = 0;
  let mut x67: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x66, &mut x67, x65, x49, x46);
  let mut x68: u32 = 0;
  let mut x69: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x68, &mut x69, x67, x47, x44);
  let mut x70: u32 = 0;
  let mut x71: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x70, &mut x71, x69, x45, x42);
  let x72: u32 = ((x71 as u32) + x43);
  let mut x73: u32 = 0;
  let mut x74: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x73, &mut x74, 0x0, x23, x56);
  let mut x75: u32 = 0;
  let mut x76: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x75, &mut x76, x74, x25, x58);
  let mut x77: u32 = 0;
  let mut x78: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x77, &mut x78, x76, x27, x60);
  let mut x79: u32 = 0;
  let mut x80: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x79, &mut x80, x78, x29, x62);
  let mut x81: u32 = 0;
  let mut x82: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x81, &mut x82, x80, x31, x64);
  let mut x83: u32 = 0;
  let mut x84: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x83, &mut x84, x82, x33, x66);
  let mut x85: u32 = 0;
  let mut x86: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x85, &mut x86, x84, x35, x68);
  let mut x87: u32 = 0;
  let mut x88: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x87, &mut x88, x86, x37, x70);
  let mut x89: u32 = 0;
  let mut x90: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x89, &mut x90, x88, x39, x72);
  let mut x91: u32 = 0;
  let mut x92: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x91, &mut x92, x1, (arg1[7]));
  let mut x93: u32 = 0;
  let mut x94: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x93, &mut x94, x1, (arg1[6]));
  let mut x95: u32 = 0;
  let mut x96: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x95, &mut x96, x1, (arg1[5]));
  let mut x97: u32 = 0;
  let mut x98: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x97, &mut x98, x1, (arg1[4]));
  let mut x99: u32 = 0;
  let mut x100: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x99, &mut x100, x1, (arg1[3]));
  let mut x101: u32 = 0;
  let mut x102: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x101, &mut x102, x1, (arg1[2]));
  let mut x103: u32 = 0;
  let mut x104: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x103, &mut x104, x1, (arg1[1]));
  let mut x105: u32 = 0;
  let mut x106: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x105, &mut x106, x1, (arg1[0]));
  let mut x107: u32 = 0;
  let mut x108: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x107, &mut x108, 0x0, x106, x103);
  let mut x109: u32 = 0;
  let mut x110: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x109, &mut x110, x108, x104, x101);
  let mut x111: u32 = 0;
  let mut x112: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x111, &mut x112, x110, x102, x99);
  let mut x113: u32 = 0;
  let mut x114: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x113, &mut x114, x112, x100, x97);
  let mut x115: u32 = 0;
  let mut x116: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x115, &mut x116, x114, x98, x95);
  let mut x117: u32 = 0;
  let mut x118: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x117, &mut x118, x116, x96, x93);
  let mut x119: u32 = 0;
  let mut x120: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x119, &mut x120, x118, x94, x91);
  let x121: u32 = ((x120 as u32) + x92);
  let mut x122: u32 = 0;
  let mut x123: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x122, &mut x123, 0x0, x75, x105);
  let mut x124: u32 = 0;
  let mut x125: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x124, &mut x125, x123, x77, x107);
  let mut x126: u32 = 0;
  let mut x127: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x126, &mut x127, x125, x79, x109);
  let mut x128: u32 = 0;
  let mut x129: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x128, &mut x129, x127, x81, x111);
  let mut x130: u32 = 0;
  let mut x131: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x130, &mut x131, x129, x83, x113);
  let mut x132: u32 = 0;
  let mut x133: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x132, &mut x133, x131, x85, x115);
  let mut x134: u32 = 0;
  let mut x135: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x134, &mut x135, x133, x87, x117);
  let mut x136: u32 = 0;
  let mut x137: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x136, &mut x137, x135, x89, x119);
  let mut x138: u32 = 0;
  let mut x139: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x138, &mut x139, x137, (x90 as u32), x121);
  let mut x140: u32 = 0;
  let mut x141: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x140, &mut x141, x122, 0x5588b13f);
  let mut x142: u32 = 0;
  let mut x143: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x142, &mut x143, x140, 0xffffffff);
  let mut x144: u32 = 0;
  let mut x145: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x144, &mut x145, x140, 0xffffffff);
  let mut x146: u32 = 0;
  let mut x147: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x146, &mut x147, x140, 0xffffffff);
  let mut x148: u32 = 0;
  let mut x149: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x148, &mut x149, x140, 0xfffffffe);
  let mut x150: u32 = 0;
  let mut x151: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x150, &mut x151, x140, 0xbaaedce6);
  let mut x152: u32 = 0;
  let mut x153: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x152, &mut x153, x140, 0xaf48a03b);
  let mut x154: u32 = 0;
  let mut x155: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x154, &mut x155, x140, 0xbfd25e8c);
  let mut x156: u32 = 0;
  let mut x157: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x156, &mut x157, x140, 0xd0364141);
  let mut x158: u32 = 0;
  let mut x159: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x158, &mut x159, 0x0, x157, x154);
  let mut x160: u32 = 0;
  let mut x161: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x160, &mut x161, x159, x155, x152);
  let mut x162: u32 = 0;
  let mut x163: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x162, &mut x163, x161, x153, x150);
  let mut x164: u32 = 0;
  let mut x165: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x164, &mut x165, x163, x151, x148);
  let mut x166: u32 = 0;
  let mut x167: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x166, &mut x167, x165, x149, x146);
  let mut x168: u32 = 0;
  let mut x169: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x168, &mut x169, x167, x147, x144);
  let mut x170: u32 = 0;
  let mut x171: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x170, &mut x171, x169, x145, x142);
  let x172: u32 = ((x171 as u32) + x143);
  let mut x173: u32 = 0;
  let mut x174: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x173, &mut x174, 0x0, x122, x156);
  let mut x175: u32 = 0;
  let mut x176: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x175, &mut x176, x174, x124, x158);
  let mut x177: u32 = 0;
  let mut x178: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x177, &mut x178, x176, x126, x160);
  let mut x179: u32 = 0;
  let mut x180: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x179, &mut x180, x178, x128, x162);
  let mut x181: u32 = 0;
  let mut x182: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x181, &mut x182, x180, x130, x164);
  let mut x183: u32 = 0;
  let mut x184: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x183, &mut x184, x182, x132, x166);
  let mut x185: u32 = 0;
  let mut x186: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x185, &mut x186, x184, x134, x168);
  let mut x187: u32 = 0;
  let mut x188: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x187, &mut x188, x186, x136, x170);
  let mut x189: u32 = 0;
  let mut x190: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x189, &mut x190, x188, x138, x172);
  let x191: u32 = ((x190 as u32) + (x139 as u32));
  let mut x192: u32 = 0;
  let mut x193: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x192, &mut x193, x2, (arg1[7]));
  let mut x194: u32 = 0;
  let mut x195: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x194, &mut x195, x2, (arg1[6]));
  let mut x196: u32 = 0;
  let mut x197: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x196, &mut x197, x2, (arg1[5]));
  let mut x198: u32 = 0;
  let mut x199: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x198, &mut x199, x2, (arg1[4]));
  let mut x200: u32 = 0;
  let mut x201: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x200, &mut x201, x2, (arg1[3]));
  let mut x202: u32 = 0;
  let mut x203: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x202, &mut x203, x2, (arg1[2]));
  let mut x204: u32 = 0;
  let mut x205: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x204, &mut x205, x2, (arg1[1]));
  let mut x206: u32 = 0;
  let mut x207: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x206, &mut x207, x2, (arg1[0]));
  let mut x208: u32 = 0;
  let mut x209: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x208, &mut x209, 0x0, x207, x204);
  let mut x210: u32 = 0;
  let mut x211: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x210, &mut x211, x209, x205, x202);
  let mut x212: u32 = 0;
  let mut x213: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x212, &mut x213, x211, x203, x200);
  let mut x214: u32 = 0;
  let mut x215: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x214, &mut x215, x213, x201, x198);
  let mut x216: u32 = 0;
  let mut x217: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x216, &mut x217, x215, x199, x196);
  let mut x218: u32 = 0;
  let mut x219: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x218, &mut x219, x217, x197, x194);
  let mut x220: u32 = 0;
  let mut x221: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x220, &mut x221, x219, x195, x192);
  let x222: u32 = ((x221 as u32) + x193);
  let mut x223: u32 = 0;
  let mut x224: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x223, &mut x224, 0x0, x175, x206);
  let mut x225: u32 = 0;
  let mut x226: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x225, &mut x226, x224, x177, x208);
  let mut x227: u32 = 0;
  let mut x228: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x227, &mut x228, x226, x179, x210);
  let mut x229: u32 = 0;
  let mut x230: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x229, &mut x230, x228, x181, x212);
  let mut x231: u32 = 0;
  let mut x232: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x231, &mut x232, x230, x183, x214);
  let mut x233: u32 = 0;
  let mut x234: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x233, &mut x234, x232, x185, x216);
  let mut x235: u32 = 0;
  let mut x236: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x235, &mut x236, x234, x187, x218);
  let mut x237: u32 = 0;
  let mut x238: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x237, &mut x238, x236, x189, x220);
  let mut x239: u32 = 0;
  let mut x240: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x239, &mut x240, x238, x191, x222);
  let mut x241: u32 = 0;
  let mut x242: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x241, &mut x242, x223, 0x5588b13f);
  let mut x243: u32 = 0;
  let mut x244: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x243, &mut x244, x241, 0xffffffff);
  let mut x245: u32 = 0;
  let mut x246: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x245, &mut x246, x241, 0xffffffff);
  let mut x247: u32 = 0;
  let mut x248: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x247, &mut x248, x241, 0xffffffff);
  let mut x249: u32 = 0;
  let mut x250: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x249, &mut x250, x241, 0xfffffffe);
  let mut x251: u32 = 0;
  let mut x252: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x251, &mut x252, x241, 0xbaaedce6);
  let mut x253: u32 = 0;
  let mut x254: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x253, &mut x254, x241, 0xaf48a03b);
  let mut x255: u32 = 0;
  let mut x256: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x255, &mut x256, x241, 0xbfd25e8c);
  let mut x257: u32 = 0;
  let mut x258: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x257, &mut x258, x241, 0xd0364141);
  let mut x259: u32 = 0;
  let mut x260: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x259, &mut x260, 0x0, x258, x255);
  let mut x261: u32 = 0;
  let mut x262: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x261, &mut x262, x260, x256, x253);
  let mut x263: u32 = 0;
  let mut x264: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x263, &mut x264, x262, x254, x251);
  let mut x265: u32 = 0;
  let mut x266: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x265, &mut x266, x264, x252, x249);
  let mut x267: u32 = 0;
  let mut x268: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x267, &mut x268, x266, x250, x247);
  let mut x269: u32 = 0;
  let mut x270: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x269, &mut x270, x268, x248, x245);
  let mut x271: u32 = 0;
  let mut x272: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x271, &mut x272, x270, x246, x243);
  let x273: u32 = ((x272 as u32) + x244);
  let mut x274: u32 = 0;
  let mut x275: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x274, &mut x275, 0x0, x223, x257);
  let mut x276: u32 = 0;
  let mut x277: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x276, &mut x277, x275, x225, x259);
  let mut x278: u32 = 0;
  let mut x279: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x278, &mut x279, x277, x227, x261);
  let mut x280: u32 = 0;
  let mut x281: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x280, &mut x281, x279, x229, x263);
  let mut x282: u32 = 0;
  let mut x283: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x282, &mut x283, x281, x231, x265);
  let mut x284: u32 = 0;
  let mut x285: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x284, &mut x285, x283, x233, x267);
  let mut x286: u32 = 0;
  let mut x287: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x286, &mut x287, x285, x235, x269);
  let mut x288: u32 = 0;
  let mut x289: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x288, &mut x289, x287, x237, x271);
  let mut x290: u32 = 0;
  let mut x291: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x290, &mut x291, x289, x239, x273);
  let x292: u32 = ((x291 as u32) + (x240 as u32));
  let mut x293: u32 = 0;
  let mut x294: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x293, &mut x294, x3, (arg1[7]));
  let mut x295: u32 = 0;
  let mut x296: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x295, &mut x296, x3, (arg1[6]));
  let mut x297: u32 = 0;
  let mut x298: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x297, &mut x298, x3, (arg1[5]));
  let mut x299: u32 = 0;
  let mut x300: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x299, &mut x300, x3, (arg1[4]));
  let mut x301: u32 = 0;
  let mut x302: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x301, &mut x302, x3, (arg1[3]));
  let mut x303: u32 = 0;
  let mut x304: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x303, &mut x304, x3, (arg1[2]));
  let mut x305: u32 = 0;
  let mut x306: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x305, &mut x306, x3, (arg1[1]));
  let mut x307: u32 = 0;
  let mut x308: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x307, &mut x308, x3, (arg1[0]));
  let mut x309: u32 = 0;
  let mut x310: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x309, &mut x310, 0x0, x308, x305);
  let mut x311: u32 = 0;
  let mut x312: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x311, &mut x312, x310, x306, x303);
  let mut x313: u32 = 0;
  let mut x314: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x313, &mut x314, x312, x304, x301);
  let mut x315: u32 = 0;
  let mut x316: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x315, &mut x316, x314, x302, x299);
  let mut x317: u32 = 0;
  let mut x318: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x317, &mut x318, x316, x300, x297);
  let mut x319: u32 = 0;
  let mut x320: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x319, &mut x320, x318, x298, x295);
  let mut x321: u32 = 0;
  let mut x322: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x321, &mut x322, x320, x296, x293);
  let x323: u32 = ((x322 as u32) + x294);
  let mut x324: u32 = 0;
  let mut x325: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x324, &mut x325, 0x0, x276, x307);
  let mut x326: u32 = 0;
  let mut x327: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x326, &mut x327, x325, x278, x309);
  let mut x328: u32 = 0;
  let mut x329: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x328, &mut x329, x327, x280, x311);
  let mut x330: u32 = 0;
  let mut x331: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x330, &mut x331, x329, x282, x313);
  let mut x332: u32 = 0;
  let mut x333: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x332, &mut x333, x331, x284, x315);
  let mut x334: u32 = 0;
  let mut x335: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x334, &mut x335, x333, x286, x317);
  let mut x336: u32 = 0;
  let mut x337: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x336, &mut x337, x335, x288, x319);
  let mut x338: u32 = 0;
  let mut x339: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x338, &mut x339, x337, x290, x321);
  let mut x340: u32 = 0;
  let mut x341: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x340, &mut x341, x339, x292, x323);
  let mut x342: u32 = 0;
  let mut x343: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x342, &mut x343, x324, 0x5588b13f);
  let mut x344: u32 = 0;
  let mut x345: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x344, &mut x345, x342, 0xffffffff);
  let mut x346: u32 = 0;
  let mut x347: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x346, &mut x347, x342, 0xffffffff);
  let mut x348: u32 = 0;
  let mut x349: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x348, &mut x349, x342, 0xffffffff);
  let mut x350: u32 = 0;
  let mut x351: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x350, &mut x351, x342, 0xfffffffe);
  let mut x352: u32 = 0;
  let mut x353: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x352, &mut x353, x342, 0xbaaedce6);
  let mut x354: u32 = 0;
  let mut x355: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x354, &mut x355, x342, 0xaf48a03b);
  let mut x356: u32 = 0;
  let mut x357: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x356, &mut x357, x342, 0xbfd25e8c);
  let mut x358: u32 = 0;
  let mut x359: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x358, &mut x359, x342, 0xd0364141);
  let mut x360: u32 = 0;
  let mut x361: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x360, &mut x361, 0x0, x359, x356);
  let mut x362: u32 = 0;
  let mut x363: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x362, &mut x363, x361, x357, x354);
  let mut x364: u32 = 0;
  let mut x365: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x364, &mut x365, x363, x355, x352);
  let mut x366: u32 = 0;
  let mut x367: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x366, &mut x367, x365, x353, x350);
  let mut x368: u32 = 0;
  let mut x369: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x368, &mut x369, x367, x351, x348);
  let mut x370: u32 = 0;
  let mut x371: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x370, &mut x371, x369, x349, x346);
  let mut x372: u32 = 0;
  let mut x373: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x372, &mut x373, x371, x347, x344);
  let x374: u32 = ((x373 as u32) + x345);
  let mut x375: u32 = 0;
  let mut x376: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x375, &mut x376, 0x0, x324, x358);
  let mut x377: u32 = 0;
  let mut x378: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x377, &mut x378, x376, x326, x360);
  let mut x379: u32 = 0;
  let mut x380: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x379, &mut x380, x378, x328, x362);
  let mut x381: u32 = 0;
  let mut x382: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x381, &mut x382, x380, x330, x364);
  let mut x383: u32 = 0;
  let mut x384: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x383, &mut x384, x382, x332, x366);
  let mut x385: u32 = 0;
  let mut x386: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x385, &mut x386, x384, x334, x368);
  let mut x387: u32 = 0;
  let mut x388: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x387, &mut x388, x386, x336, x370);
  let mut x389: u32 = 0;
  let mut x390: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x389, &mut x390, x388, x338, x372);
  let mut x391: u32 = 0;
  let mut x392: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x391, &mut x392, x390, x340, x374);
  let x393: u32 = ((x392 as u32) + (x341 as u32));
  let mut x394: u32 = 0;
  let mut x395: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x394, &mut x395, x4, (arg1[7]));
  let mut x396: u32 = 0;
  let mut x397: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x396, &mut x397, x4, (arg1[6]));
  let mut x398: u32 = 0;
  let mut x399: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x398, &mut x399, x4, (arg1[5]));
  let mut x400: u32 = 0;
  let mut x401: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x400, &mut x401, x4, (arg1[4]));
  let mut x402: u32 = 0;
  let mut x403: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x402, &mut x403, x4, (arg1[3]));
  let mut x404: u32 = 0;
  let mut x405: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x404, &mut x405, x4, (arg1[2]));
  let mut x406: u32 = 0;
  let mut x407: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x406, &mut x407, x4, (arg1[1]));
  let mut x408: u32 = 0;
  let mut x409: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x408, &mut x409, x4, (arg1[0]));
  let mut x410: u32 = 0;
  let mut x411: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x410, &mut x411, 0x0, x409, x406);
  let mut x412: u32 = 0;
  let mut x413: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x412, &mut x413, x411, x407, x404);
  let mut x414: u32 = 0;
  let mut x415: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x414, &mut x415, x413, x405, x402);
  let mut x416: u32 = 0;
  let mut x417: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x416, &mut x417, x415, x403, x400);
  let mut x418: u32 = 0;
  let mut x419: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x418, &mut x419, x417, x401, x398);
  let mut x420: u32 = 0;
  let mut x421: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x420, &mut x421, x419, x399, x396);
  let mut x422: u32 = 0;
  let mut x423: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x422, &mut x423, x421, x397, x394);
  let x424: u32 = ((x423 as u32) + x395);
  let mut x425: u32 = 0;
  let mut x426: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x425, &mut x426, 0x0, x377, x408);
  let mut x427: u32 = 0;
  let mut x428: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x427, &mut x428, x426, x379, x410);
  let mut x429: u32 = 0;
  let mut x430: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x429, &mut x430, x428, x381, x412);
  let mut x431: u32 = 0;
  let mut x432: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x431, &mut x432, x430, x383, x414);
  let mut x433: u32 = 0;
  let mut x434: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x433, &mut x434, x432, x385, x416);
  let mut x435: u32 = 0;
  let mut x436: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x435, &mut x436, x434, x387, x418);
  let mut x437: u32 = 0;
  let mut x438: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x437, &mut x438, x436, x389, x420);
  let mut x439: u32 = 0;
  let mut x440: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x439, &mut x440, x438, x391, x422);
  let mut x441: u32 = 0;
  let mut x442: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x441, &mut x442, x440, x393, x424);
  let mut x443: u32 = 0;
  let mut x444: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x443, &mut x444, x425, 0x5588b13f);
  let mut x445: u32 = 0;
  let mut x446: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x445, &mut x446, x443, 0xffffffff);
  let mut x447: u32 = 0;
  let mut x448: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x447, &mut x448, x443, 0xffffffff);
  let mut x449: u32 = 0;
  let mut x450: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x449, &mut x450, x443, 0xffffffff);
  let mut x451: u32 = 0;
  let mut x452: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x451, &mut x452, x443, 0xfffffffe);
  let mut x453: u32 = 0;
  let mut x454: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x453, &mut x454, x443, 0xbaaedce6);
  let mut x455: u32 = 0;
  let mut x456: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x455, &mut x456, x443, 0xaf48a03b);
  let mut x457: u32 = 0;
  let mut x458: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x457, &mut x458, x443, 0xbfd25e8c);
  let mut x459: u32 = 0;
  let mut x460: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x459, &mut x460, x443, 0xd0364141);
  let mut x461: u32 = 0;
  let mut x462: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x461, &mut x462, 0x0, x460, x457);
  let mut x463: u32 = 0;
  let mut x464: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x463, &mut x464, x462, x458, x455);
  let mut x465: u32 = 0;
  let mut x466: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x465, &mut x466, x464, x456, x453);
  let mut x467: u32 = 0;
  let mut x468: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x467, &mut x468, x466, x454, x451);
  let mut x469: u32 = 0;
  let mut x470: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x469, &mut x470, x468, x452, x449);
  let mut x471: u32 = 0;
  let mut x472: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x471, &mut x472, x470, x450, x447);
  let mut x473: u32 = 0;
  let mut x474: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x473, &mut x474, x472, x448, x445);
  let x475: u32 = ((x474 as u32) + x446);
  let mut x476: u32 = 0;
  let mut x477: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x476, &mut x477, 0x0, x425, x459);
  let mut x478: u32 = 0;
  let mut x479: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x478, &mut x479, x477, x427, x461);
  let mut x480: u32 = 0;
  let mut x481: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x480, &mut x481, x479, x429, x463);
  let mut x482: u32 = 0;
  let mut x483: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x482, &mut x483, x481, x431, x465);
  let mut x484: u32 = 0;
  let mut x485: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x484, &mut x485, x483, x433, x467);
  let mut x486: u32 = 0;
  let mut x487: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x486, &mut x487, x485, x435, x469);
  let mut x488: u32 = 0;
  let mut x489: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x488, &mut x489, x487, x437, x471);
  let mut x490: u32 = 0;
  let mut x491: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x490, &mut x491, x489, x439, x473);
  let mut x492: u32 = 0;
  let mut x493: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x492, &mut x493, x491, x441, x475);
  let x494: u32 = ((x493 as u32) + (x442 as u32));
  let mut x495: u32 = 0;
  let mut x496: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x495, &mut x496, x5, (arg1[7]));
  let mut x497: u32 = 0;
  let mut x498: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x497, &mut x498, x5, (arg1[6]));
  let mut x499: u32 = 0;
  let mut x500: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x499, &mut x500, x5, (arg1[5]));
  let mut x501: u32 = 0;
  let mut x502: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x501, &mut x502, x5, (arg1[4]));
  let mut x503: u32 = 0;
  let mut x504: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x503, &mut x504, x5, (arg1[3]));
  let mut x505: u32 = 0;
  let mut x506: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x505, &mut x506, x5, (arg1[2]));
  let mut x507: u32 = 0;
  let mut x508: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x507, &mut x508, x5, (arg1[1]));
  let mut x509: u32 = 0;
  let mut x510: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x509, &mut x510, x5, (arg1[0]));
  let mut x511: u32 = 0;
  let mut x512: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x511, &mut x512, 0x0, x510, x507);
  let mut x513: u32 = 0;
  let mut x514: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x513, &mut x514, x512, x508, x505);
  let mut x515: u32 = 0;
  let mut x516: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x515, &mut x516, x514, x506, x503);
  let mut x517: u32 = 0;
  let mut x518: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x517, &mut x518, x516, x504, x501);
  let mut x519: u32 = 0;
  let mut x520: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x519, &mut x520, x518, x502, x499);
  let mut x521: u32 = 0;
  let mut x522: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x521, &mut x522, x520, x500, x497);
  let mut x523: u32 = 0;
  let mut x524: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x523, &mut x524, x522, x498, x495);
  let x525: u32 = ((x524 as u32) + x496);
  let mut x526: u32 = 0;
  let mut x527: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x526, &mut x527, 0x0, x478, x509);
  let mut x528: u32 = 0;
  let mut x529: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x528, &mut x529, x527, x480, x511);
  let mut x530: u32 = 0;
  let mut x531: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x530, &mut x531, x529, x482, x513);
  let mut x532: u32 = 0;
  let mut x533: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x532, &mut x533, x531, x484, x515);
  let mut x534: u32 = 0;
  let mut x535: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x534, &mut x535, x533, x486, x517);
  let mut x536: u32 = 0;
  let mut x537: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x536, &mut x537, x535, x488, x519);
  let mut x538: u32 = 0;
  let mut x539: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x538, &mut x539, x537, x490, x521);
  let mut x540: u32 = 0;
  let mut x541: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x540, &mut x541, x539, x492, x523);
  let mut x542: u32 = 0;
  let mut x543: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x542, &mut x543, x541, x494, x525);
  let mut x544: u32 = 0;
  let mut x545: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x544, &mut x545, x526, 0x5588b13f);
  let mut x546: u32 = 0;
  let mut x547: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x546, &mut x547, x544, 0xffffffff);
  let mut x548: u32 = 0;
  let mut x549: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x548, &mut x549, x544, 0xffffffff);
  let mut x550: u32 = 0;
  let mut x551: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x550, &mut x551, x544, 0xffffffff);
  let mut x552: u32 = 0;
  let mut x553: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x552, &mut x553, x544, 0xfffffffe);
  let mut x554: u32 = 0;
  let mut x555: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x554, &mut x555, x544, 0xbaaedce6);
  let mut x556: u32 = 0;
  let mut x557: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x556, &mut x557, x544, 0xaf48a03b);
  let mut x558: u32 = 0;
  let mut x559: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x558, &mut x559, x544, 0xbfd25e8c);
  let mut x560: u32 = 0;
  let mut x561: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x560, &mut x561, x544, 0xd0364141);
  let mut x562: u32 = 0;
  let mut x563: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x562, &mut x563, 0x0, x561, x558);
  let mut x564: u32 = 0;
  let mut x565: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x564, &mut x565, x563, x559, x556);
  let mut x566: u32 = 0;
  let mut x567: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x566, &mut x567, x565, x557, x554);
  let mut x568: u32 = 0;
  let mut x569: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x568, &mut x569, x567, x555, x552);
  let mut x570: u32 = 0;
  let mut x571: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x570, &mut x571, x569, x553, x550);
  let mut x572: u32 = 0;
  let mut x573: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x572, &mut x573, x571, x551, x548);
  let mut x574: u32 = 0;
  let mut x575: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x574, &mut x575, x573, x549, x546);
  let x576: u32 = ((x575 as u32) + x547);
  let mut x577: u32 = 0;
  let mut x578: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x577, &mut x578, 0x0, x526, x560);
  let mut x579: u32 = 0;
  let mut x580: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x579, &mut x580, x578, x528, x562);
  let mut x581: u32 = 0;
  let mut x582: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x581, &mut x582, x580, x530, x564);
  let mut x583: u32 = 0;
  let mut x584: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x583, &mut x584, x582, x532, x566);
  let mut x585: u32 = 0;
  let mut x586: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x585, &mut x586, x584, x534, x568);
  let mut x587: u32 = 0;
  let mut x588: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x587, &mut x588, x586, x536, x570);
  let mut x589: u32 = 0;
  let mut x590: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x589, &mut x590, x588, x538, x572);
  let mut x591: u32 = 0;
  let mut x592: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x591, &mut x592, x590, x540, x574);
  let mut x593: u32 = 0;
  let mut x594: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x593, &mut x594, x592, x542, x576);
  let x595: u32 = ((x594 as u32) + (x543 as u32));
  let mut x596: u32 = 0;
  let mut x597: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x596, &mut x597, x6, (arg1[7]));
  let mut x598: u32 = 0;
  let mut x599: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x598, &mut x599, x6, (arg1[6]));
  let mut x600: u32 = 0;
  let mut x601: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x600, &mut x601, x6, (arg1[5]));
  let mut x602: u32 = 0;
  let mut x603: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x602, &mut x603, x6, (arg1[4]));
  let mut x604: u32 = 0;
  let mut x605: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x604, &mut x605, x6, (arg1[3]));
  let mut x606: u32 = 0;
  let mut x607: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x606, &mut x607, x6, (arg1[2]));
  let mut x608: u32 = 0;
  let mut x609: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x608, &mut x609, x6, (arg1[1]));
  let mut x610: u32 = 0;
  let mut x611: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x610, &mut x611, x6, (arg1[0]));
  let mut x612: u32 = 0;
  let mut x613: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x612, &mut x613, 0x0, x611, x608);
  let mut x614: u32 = 0;
  let mut x615: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x614, &mut x615, x613, x609, x606);
  let mut x616: u32 = 0;
  let mut x617: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x616, &mut x617, x615, x607, x604);
  let mut x618: u32 = 0;
  let mut x619: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x618, &mut x619, x617, x605, x602);
  let mut x620: u32 = 0;
  let mut x621: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x620, &mut x621, x619, x603, x600);
  let mut x622: u32 = 0;
  let mut x623: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x622, &mut x623, x621, x601, x598);
  let mut x624: u32 = 0;
  let mut x625: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x624, &mut x625, x623, x599, x596);
  let x626: u32 = ((x625 as u32) + x597);
  let mut x627: u32 = 0;
  let mut x628: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x627, &mut x628, 0x0, x579, x610);
  let mut x629: u32 = 0;
  let mut x630: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x629, &mut x630, x628, x581, x612);
  let mut x631: u32 = 0;
  let mut x632: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x631, &mut x632, x630, x583, x614);
  let mut x633: u32 = 0;
  let mut x634: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x633, &mut x634, x632, x585, x616);
  let mut x635: u32 = 0;
  let mut x636: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x635, &mut x636, x634, x587, x618);
  let mut x637: u32 = 0;
  let mut x638: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x637, &mut x638, x636, x589, x620);
  let mut x639: u32 = 0;
  let mut x640: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x639, &mut x640, x638, x591, x622);
  let mut x641: u32 = 0;
  let mut x642: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x641, &mut x642, x640, x593, x624);
  let mut x643: u32 = 0;
  let mut x644: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x643, &mut x644, x642, x595, x626);
  let mut x645: u32 = 0;
  let mut x646: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x645, &mut x646, x627, 0x5588b13f);
  let mut x647: u32 = 0;
  let mut x648: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x647, &mut x648, x645, 0xffffffff);
  let mut x649: u32 = 0;
  let mut x650: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x649, &mut x650, x645, 0xffffffff);
  let mut x651: u32 = 0;
  let mut x652: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x651, &mut x652, x645, 0xffffffff);
  let mut x653: u32 = 0;
  let mut x654: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x653, &mut x654, x645, 0xfffffffe);
  let mut x655: u32 = 0;
  let mut x656: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x655, &mut x656, x645, 0xbaaedce6);
  let mut x657: u32 = 0;
  let mut x658: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x657, &mut x658, x645, 0xaf48a03b);
  let mut x659: u32 = 0;
  let mut x660: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x659, &mut x660, x645, 0xbfd25e8c);
  let mut x661: u32 = 0;
  let mut x662: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x661, &mut x662, x645, 0xd0364141);
  let mut x663: u32 = 0;
  let mut x664: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x663, &mut x664, 0x0, x662, x659);
  let mut x665: u32 = 0;
  let mut x666: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x665, &mut x666, x664, x660, x657);
  let mut x667: u32 = 0;
  let mut x668: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x667, &mut x668, x666, x658, x655);
  let mut x669: u32 = 0;
  let mut x670: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x669, &mut x670, x668, x656, x653);
  let mut x671: u32 = 0;
  let mut x672: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x671, &mut x672, x670, x654, x651);
  let mut x673: u32 = 0;
  let mut x674: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x673, &mut x674, x672, x652, x649);
  let mut x675: u32 = 0;
  let mut x676: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x675, &mut x676, x674, x650, x647);
  let x677: u32 = ((x676 as u32) + x648);
  let mut x678: u32 = 0;
  let mut x679: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x678, &mut x679, 0x0, x627, x661);
  let mut x680: u32 = 0;
  let mut x681: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x680, &mut x681, x679, x629, x663);
  let mut x682: u32 = 0;
  let mut x683: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x682, &mut x683, x681, x631, x665);
  let mut x684: u32 = 0;
  let mut x685: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x684, &mut x685, x683, x633, x667);
  let mut x686: u32 = 0;
  let mut x687: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x686, &mut x687, x685, x635, x669);
  let mut x688: u32 = 0;
  let mut x689: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x688, &mut x689, x687, x637, x671);
  let mut x690: u32 = 0;
  let mut x691: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x690, &mut x691, x689, x639, x673);
  let mut x692: u32 = 0;
  let mut x693: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x692, &mut x693, x691, x641, x675);
  let mut x694: u32 = 0;
  let mut x695: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x694, &mut x695, x693, x643, x677);
  let x696: u32 = ((x695 as u32) + (x644 as u32));
  let mut x697: u32 = 0;
  let mut x698: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x697, &mut x698, x7, (arg1[7]));
  let mut x699: u32 = 0;
  let mut x700: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x699, &mut x700, x7, (arg1[6]));
  let mut x701: u32 = 0;
  let mut x702: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x701, &mut x702, x7, (arg1[5]));
  let mut x703: u32 = 0;
  let mut x704: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x703, &mut x704, x7, (arg1[4]));
  let mut x705: u32 = 0;
  let mut x706: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x705, &mut x706, x7, (arg1[3]));
  let mut x707: u32 = 0;
  let mut x708: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x707, &mut x708, x7, (arg1[2]));
  let mut x709: u32 = 0;
  let mut x710: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x709, &mut x710, x7, (arg1[1]));
  let mut x711: u32 = 0;
  let mut x712: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x711, &mut x712, x7, (arg1[0]));
  let mut x713: u32 = 0;
  let mut x714: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x713, &mut x714, 0x0, x712, x709);
  let mut x715: u32 = 0;
  let mut x716: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x715, &mut x716, x714, x710, x707);
  let mut x717: u32 = 0;
  let mut x718: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x717, &mut x718, x716, x708, x705);
  let mut x719: u32 = 0;
  let mut x720: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x719, &mut x720, x718, x706, x703);
  let mut x721: u32 = 0;
  let mut x722: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x721, &mut x722, x720, x704, x701);
  let mut x723: u32 = 0;
  let mut x724: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x723, &mut x724, x722, x702, x699);
  let mut x725: u32 = 0;
  let mut x726: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x725, &mut x726, x724, x700, x697);
  let x727: u32 = ((x726 as u32) + x698);
  let mut x728: u32 = 0;
  let mut x729: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x728, &mut x729, 0x0, x680, x711);
  let mut x730: u32 = 0;
  let mut x731: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x730, &mut x731, x729, x682, x713);
  let mut x732: u32 = 0;
  let mut x733: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x732, &mut x733, x731, x684, x715);
  let mut x734: u32 = 0;
  let mut x735: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x734, &mut x735, x733, x686, x717);
  let mut x736: u32 = 0;
  let mut x737: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x736, &mut x737, x735, x688, x719);
  let mut x738: u32 = 0;
  let mut x739: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x738, &mut x739, x737, x690, x721);
  let mut x740: u32 = 0;
  let mut x741: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x740, &mut x741, x739, x692, x723);
  let mut x742: u32 = 0;
  let mut x743: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x742, &mut x743, x741, x694, x725);
  let mut x744: u32 = 0;
  let mut x745: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x744, &mut x745, x743, x696, x727);
  let mut x746: u32 = 0;
  let mut x747: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x746, &mut x747, x728, 0x5588b13f);
  let mut x748: u32 = 0;
  let mut x749: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x748, &mut x749, x746, 0xffffffff);
  let mut x750: u32 = 0;
  let mut x751: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x750, &mut x751, x746, 0xffffffff);
  let mut x752: u32 = 0;
  let mut x753: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x752, &mut x753, x746, 0xffffffff);
  let mut x754: u32 = 0;
  let mut x755: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x754, &mut x755, x746, 0xfffffffe);
  let mut x756: u32 = 0;
  let mut x757: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x756, &mut x757, x746, 0xbaaedce6);
  let mut x758: u32 = 0;
  let mut x759: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x758, &mut x759, x746, 0xaf48a03b);
  let mut x760: u32 = 0;
  let mut x761: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x760, &mut x761, x746, 0xbfd25e8c);
  let mut x762: u32 = 0;
  let mut x763: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x762, &mut x763, x746, 0xd0364141);
  let mut x764: u32 = 0;
  let mut x765: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x764, &mut x765, 0x0, x763, x760);
  let mut x766: u32 = 0;
  let mut x767: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x766, &mut x767, x765, x761, x758);
  let mut x768: u32 = 0;
  let mut x769: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x768, &mut x769, x767, x759, x756);
  let mut x770: u32 = 0;
  let mut x771: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x770, &mut x771, x769, x757, x754);
  let mut x772: u32 = 0;
  let mut x773: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x772, &mut x773, x771, x755, x752);
  let mut x774: u32 = 0;
  let mut x775: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x774, &mut x775, x773, x753, x750);
  let mut x776: u32 = 0;
  let mut x777: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x776, &mut x777, x775, x751, x748);
  let x778: u32 = ((x777 as u32) + x749);
  let mut x779: u32 = 0;
  let mut x780: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x779, &mut x780, 0x0, x728, x762);
  let mut x781: u32 = 0;
  let mut x782: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x781, &mut x782, x780, x730, x764);
  let mut x783: u32 = 0;
  let mut x784: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x783, &mut x784, x782, x732, x766);
  let mut x785: u32 = 0;
  let mut x786: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x785, &mut x786, x784, x734, x768);
  let mut x787: u32 = 0;
  let mut x788: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x787, &mut x788, x786, x736, x770);
  let mut x789: u32 = 0;
  let mut x790: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x789, &mut x790, x788, x738, x772);
  let mut x791: u32 = 0;
  let mut x792: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x791, &mut x792, x790, x740, x774);
  let mut x793: u32 = 0;
  let mut x794: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x793, &mut x794, x792, x742, x776);
  let mut x795: u32 = 0;
  let mut x796: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x795, &mut x796, x794, x744, x778);
  let x797: u32 = ((x796 as u32) + (x745 as u32));
  let mut x798: u32 = 0;
  let mut x799: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x798, &mut x799, 0x0, x781, 0xd0364141);
  let mut x800: u32 = 0;
  let mut x801: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x800, &mut x801, x799, x783, 0xbfd25e8c);
  let mut x802: u32 = 0;
  let mut x803: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x802, &mut x803, x801, x785, 0xaf48a03b);
  let mut x804: u32 = 0;
  let mut x805: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x804, &mut x805, x803, x787, 0xbaaedce6);
  let mut x806: u32 = 0;
  let mut x807: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x806, &mut x807, x805, x789, 0xfffffffe);
  let mut x808: u32 = 0;
  let mut x809: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x808, &mut x809, x807, x791, 0xffffffff);
  let mut x810: u32 = 0;
  let mut x811: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x810, &mut x811, x809, x793, 0xffffffff);
  let mut x812: u32 = 0;
  let mut x813: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x812, &mut x813, x811, x795, 0xffffffff);
  let mut x814: u32 = 0;
  let mut x815: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x814, &mut x815, x813, x797, (0x0 as u32));
  let mut x816: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x816, x815, x798, x781);
  let mut x817: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x817, x815, x800, x783);
  let mut x818: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x818, x815, x802, x785);
  let mut x819: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x819, x815, x804, x787);
  let mut x820: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x820, x815, x806, x789);
  let mut x821: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x821, x815, x808, x791);
  let mut x822: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x822, x815, x810, x793);
  let mut x823: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x823, x815, x812, x795);
  out1[0] = x816;
  out1[1] = x817;
  out1[2] = x818;
  out1[3] = x819;
  out1[4] = x820;
  out1[5] = x821;
  out1[6] = x822;
  out1[7] = x823;
}

/// The function fiat_secp256k1_montgomery_scalar_add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_add(out1: &mut fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element, arg1: &fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element, arg2: &fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x15, &mut x16, x14, (arg1[7]), (arg2[7]));
  let mut x17: u32 = 0;
  let mut x18: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x17, &mut x18, 0x0, x1, 0xd0364141);
  let mut x19: u32 = 0;
  let mut x20: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x19, &mut x20, x18, x3, 0xbfd25e8c);
  let mut x21: u32 = 0;
  let mut x22: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x21, &mut x22, x20, x5, 0xaf48a03b);
  let mut x23: u32 = 0;
  let mut x24: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x23, &mut x24, x22, x7, 0xbaaedce6);
  let mut x25: u32 = 0;
  let mut x26: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x25, &mut x26, x24, x9, 0xfffffffe);
  let mut x27: u32 = 0;
  let mut x28: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x27, &mut x28, x26, x11, 0xffffffff);
  let mut x29: u32 = 0;
  let mut x30: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x29, &mut x30, x28, x13, 0xffffffff);
  let mut x31: u32 = 0;
  let mut x32: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x31, &mut x32, x30, x15, 0xffffffff);
  let mut x33: u32 = 0;
  let mut x34: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x33, &mut x34, x32, (x16 as u32), (0x0 as u32));
  let mut x35: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x35, x34, x17, x1);
  let mut x36: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x36, x34, x19, x3);
  let mut x37: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x37, x34, x21, x5);
  let mut x38: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x38, x34, x23, x7);
  let mut x39: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x39, x34, x25, x9);
  let mut x40: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x40, x34, x27, x11);
  let mut x41: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x41, x34, x29, x13);
  let mut x42: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x42, x34, x31, x15);
  out1[0] = x35;
  out1[1] = x36;
  out1[2] = x37;
  out1[3] = x38;
  out1[4] = x39;
  out1[5] = x40;
  out1[6] = x41;
  out1[7] = x42;
}

/// The function fiat_secp256k1_montgomery_scalar_sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_sub(out1: &mut fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element, arg1: &fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element, arg2: &fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x15, &mut x16, x14, (arg1[7]), (arg2[7]));
  let mut x17: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x17, x16, (0x0 as u32), 0xffffffff);
  let mut x18: u32 = 0;
  let mut x19: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x18, &mut x19, 0x0, x1, (x17 & 0xd0364141));
  let mut x20: u32 = 0;
  let mut x21: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x20, &mut x21, x19, x3, (x17 & 0xbfd25e8c));
  let mut x22: u32 = 0;
  let mut x23: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x22, &mut x23, x21, x5, (x17 & 0xaf48a03b));
  let mut x24: u32 = 0;
  let mut x25: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x24, &mut x25, x23, x7, (x17 & 0xbaaedce6));
  let mut x26: u32 = 0;
  let mut x27: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x26, &mut x27, x25, x9, (x17 & 0xfffffffe));
  let mut x28: u32 = 0;
  let mut x29: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x28, &mut x29, x27, x11, x17);
  let mut x30: u32 = 0;
  let mut x31: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x30, &mut x31, x29, x13, x17);
  let mut x32: u32 = 0;
  let mut x33: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x32, &mut x33, x31, x15, x17);
  out1[0] = x18;
  out1[1] = x20;
  out1[2] = x22;
  out1[3] = x24;
  out1[4] = x26;
  out1[5] = x28;
  out1[6] = x30;
  out1[7] = x32;
}

/// The function fiat_secp256k1_montgomery_scalar_opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_opp(out1: &mut fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element, arg1: &fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x1, &mut x2, 0x0, (0x0 as u32), (arg1[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x3, &mut x4, x2, (0x0 as u32), (arg1[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x5, &mut x6, x4, (0x0 as u32), (arg1[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x7, &mut x8, x6, (0x0 as u32), (arg1[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x9, &mut x10, x8, (0x0 as u32), (arg1[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x11, &mut x12, x10, (0x0 as u32), (arg1[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x13, &mut x14, x12, (0x0 as u32), (arg1[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x15, &mut x16, x14, (0x0 as u32), (arg1[7]));
  let mut x17: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x17, x16, (0x0 as u32), 0xffffffff);
  let mut x18: u32 = 0;
  let mut x19: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x18, &mut x19, 0x0, x1, (x17 & 0xd0364141));
  let mut x20: u32 = 0;
  let mut x21: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x20, &mut x21, x19, x3, (x17 & 0xbfd25e8c));
  let mut x22: u32 = 0;
  let mut x23: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x22, &mut x23, x21, x5, (x17 & 0xaf48a03b));
  let mut x24: u32 = 0;
  let mut x25: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x24, &mut x25, x23, x7, (x17 & 0xbaaedce6));
  let mut x26: u32 = 0;
  let mut x27: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x26, &mut x27, x25, x9, (x17 & 0xfffffffe));
  let mut x28: u32 = 0;
  let mut x29: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x28, &mut x29, x27, x11, x17);
  let mut x30: u32 = 0;
  let mut x31: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x30, &mut x31, x29, x13, x17);
  let mut x32: u32 = 0;
  let mut x33: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x32, &mut x33, x31, x15, x17);
  out1[0] = x18;
  out1[1] = x20;
  out1[2] = x22;
  out1[3] = x24;
  out1[4] = x26;
  out1[5] = x28;
  out1[6] = x30;
  out1[7] = x32;
}

/// The function fiat_secp256k1_montgomery_scalar_from_montgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^8) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_from_montgomery(out1: &mut fiat_secp256k1_montgomery_scalar_non_montgomery_domain_field_element, arg1: &fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element) {
  let x1: u32 = (arg1[0]);
  let mut x2: u32 = 0;
  let mut x3: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x2, &mut x3, x1, 0x5588b13f);
  let mut x4: u32 = 0;
  let mut x5: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x4, &mut x5, x2, 0xffffffff);
  let mut x6: u32 = 0;
  let mut x7: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x6, &mut x7, x2, 0xffffffff);
  let mut x8: u32 = 0;
  let mut x9: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x8, &mut x9, x2, 0xffffffff);
  let mut x10: u32 = 0;
  let mut x11: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x10, &mut x11, x2, 0xfffffffe);
  let mut x12: u32 = 0;
  let mut x13: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x12, &mut x13, x2, 0xbaaedce6);
  let mut x14: u32 = 0;
  let mut x15: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x14, &mut x15, x2, 0xaf48a03b);
  let mut x16: u32 = 0;
  let mut x17: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x16, &mut x17, x2, 0xbfd25e8c);
  let mut x18: u32 = 0;
  let mut x19: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x18, &mut x19, x2, 0xd0364141);
  let mut x20: u32 = 0;
  let mut x21: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x20, &mut x21, 0x0, x19, x16);
  let mut x22: u32 = 0;
  let mut x23: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x22, &mut x23, x21, x17, x14);
  let mut x24: u32 = 0;
  let mut x25: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x24, &mut x25, x23, x15, x12);
  let mut x26: u32 = 0;
  let mut x27: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x26, &mut x27, x25, x13, x10);
  let mut x28: u32 = 0;
  let mut x29: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x28, &mut x29, x27, x11, x8);
  let mut x30: u32 = 0;
  let mut x31: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x30, &mut x31, x29, x9, x6);
  let mut x32: u32 = 0;
  let mut x33: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x32, &mut x33, x31, x7, x4);
  let mut x34: u32 = 0;
  let mut x35: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x34, &mut x35, 0x0, x1, x18);
  let mut x36: u32 = 0;
  let mut x37: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x36, &mut x37, x35, (0x0 as u32), x20);
  let mut x38: u32 = 0;
  let mut x39: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x38, &mut x39, x37, (0x0 as u32), x22);
  let mut x40: u32 = 0;
  let mut x41: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x40, &mut x41, x39, (0x0 as u32), x24);
  let mut x42: u32 = 0;
  let mut x43: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x42, &mut x43, x41, (0x0 as u32), x26);
  let mut x44: u32 = 0;
  let mut x45: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x44, &mut x45, x43, (0x0 as u32), x28);
  let mut x46: u32 = 0;
  let mut x47: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x46, &mut x47, x45, (0x0 as u32), x30);
  let mut x48: u32 = 0;
  let mut x49: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x48, &mut x49, x47, (0x0 as u32), x32);
  let mut x50: u32 = 0;
  let mut x51: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x50, &mut x51, x49, (0x0 as u32), ((x33 as u32) + x5));
  let mut x52: u32 = 0;
  let mut x53: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x52, &mut x53, 0x0, x36, (arg1[1]));
  let mut x54: u32 = 0;
  let mut x55: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x54, &mut x55, x53, x38, (0x0 as u32));
  let mut x56: u32 = 0;
  let mut x57: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x56, &mut x57, x55, x40, (0x0 as u32));
  let mut x58: u32 = 0;
  let mut x59: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x58, &mut x59, x57, x42, (0x0 as u32));
  let mut x60: u32 = 0;
  let mut x61: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x60, &mut x61, x59, x44, (0x0 as u32));
  let mut x62: u32 = 0;
  let mut x63: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x62, &mut x63, x61, x46, (0x0 as u32));
  let mut x64: u32 = 0;
  let mut x65: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x64, &mut x65, x63, x48, (0x0 as u32));
  let mut x66: u32 = 0;
  let mut x67: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x66, &mut x67, x65, x50, (0x0 as u32));
  let mut x68: u32 = 0;
  let mut x69: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x68, &mut x69, x52, 0x5588b13f);
  let mut x70: u32 = 0;
  let mut x71: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x70, &mut x71, x68, 0xffffffff);
  let mut x72: u32 = 0;
  let mut x73: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x72, &mut x73, x68, 0xffffffff);
  let mut x74: u32 = 0;
  let mut x75: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x74, &mut x75, x68, 0xffffffff);
  let mut x76: u32 = 0;
  let mut x77: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x76, &mut x77, x68, 0xfffffffe);
  let mut x78: u32 = 0;
  let mut x79: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x78, &mut x79, x68, 0xbaaedce6);
  let mut x80: u32 = 0;
  let mut x81: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x80, &mut x81, x68, 0xaf48a03b);
  let mut x82: u32 = 0;
  let mut x83: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x82, &mut x83, x68, 0xbfd25e8c);
  let mut x84: u32 = 0;
  let mut x85: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x84, &mut x85, x68, 0xd0364141);
  let mut x86: u32 = 0;
  let mut x87: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x86, &mut x87, 0x0, x85, x82);
  let mut x88: u32 = 0;
  let mut x89: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x88, &mut x89, x87, x83, x80);
  let mut x90: u32 = 0;
  let mut x91: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x90, &mut x91, x89, x81, x78);
  let mut x92: u32 = 0;
  let mut x93: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x92, &mut x93, x91, x79, x76);
  let mut x94: u32 = 0;
  let mut x95: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x94, &mut x95, x93, x77, x74);
  let mut x96: u32 = 0;
  let mut x97: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x96, &mut x97, x95, x75, x72);
  let mut x98: u32 = 0;
  let mut x99: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x98, &mut x99, x97, x73, x70);
  let mut x100: u32 = 0;
  let mut x101: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x100, &mut x101, 0x0, x52, x84);
  let mut x102: u32 = 0;
  let mut x103: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x102, &mut x103, x101, x54, x86);
  let mut x104: u32 = 0;
  let mut x105: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x104, &mut x105, x103, x56, x88);
  let mut x106: u32 = 0;
  let mut x107: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x106, &mut x107, x105, x58, x90);
  let mut x108: u32 = 0;
  let mut x109: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x108, &mut x109, x107, x60, x92);
  let mut x110: u32 = 0;
  let mut x111: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x110, &mut x111, x109, x62, x94);
  let mut x112: u32 = 0;
  let mut x113: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x112, &mut x113, x111, x64, x96);
  let mut x114: u32 = 0;
  let mut x115: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x114, &mut x115, x113, x66, x98);
  let mut x116: u32 = 0;
  let mut x117: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x116, &mut x117, x115, ((x67 as u32) + (x51 as u32)), ((x99 as u32) + x71));
  let mut x118: u32 = 0;
  let mut x119: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x118, &mut x119, 0x0, x102, (arg1[2]));
  let mut x120: u32 = 0;
  let mut x121: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x120, &mut x121, x119, x104, (0x0 as u32));
  let mut x122: u32 = 0;
  let mut x123: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x122, &mut x123, x121, x106, (0x0 as u32));
  let mut x124: u32 = 0;
  let mut x125: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x124, &mut x125, x123, x108, (0x0 as u32));
  let mut x126: u32 = 0;
  let mut x127: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x126, &mut x127, x125, x110, (0x0 as u32));
  let mut x128: u32 = 0;
  let mut x129: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x128, &mut x129, x127, x112, (0x0 as u32));
  let mut x130: u32 = 0;
  let mut x131: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x130, &mut x131, x129, x114, (0x0 as u32));
  let mut x132: u32 = 0;
  let mut x133: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x132, &mut x133, x131, x116, (0x0 as u32));
  let mut x134: u32 = 0;
  let mut x135: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x134, &mut x135, x118, 0x5588b13f);
  let mut x136: u32 = 0;
  let mut x137: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x136, &mut x137, x134, 0xffffffff);
  let mut x138: u32 = 0;
  let mut x139: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x138, &mut x139, x134, 0xffffffff);
  let mut x140: u32 = 0;
  let mut x141: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x140, &mut x141, x134, 0xffffffff);
  let mut x142: u32 = 0;
  let mut x143: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x142, &mut x143, x134, 0xfffffffe);
  let mut x144: u32 = 0;
  let mut x145: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x144, &mut x145, x134, 0xbaaedce6);
  let mut x146: u32 = 0;
  let mut x147: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x146, &mut x147, x134, 0xaf48a03b);
  let mut x148: u32 = 0;
  let mut x149: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x148, &mut x149, x134, 0xbfd25e8c);
  let mut x150: u32 = 0;
  let mut x151: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x150, &mut x151, x134, 0xd0364141);
  let mut x152: u32 = 0;
  let mut x153: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x152, &mut x153, 0x0, x151, x148);
  let mut x154: u32 = 0;
  let mut x155: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x154, &mut x155, x153, x149, x146);
  let mut x156: u32 = 0;
  let mut x157: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x156, &mut x157, x155, x147, x144);
  let mut x158: u32 = 0;
  let mut x159: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x158, &mut x159, x157, x145, x142);
  let mut x160: u32 = 0;
  let mut x161: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x160, &mut x161, x159, x143, x140);
  let mut x162: u32 = 0;
  let mut x163: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x162, &mut x163, x161, x141, x138);
  let mut x164: u32 = 0;
  let mut x165: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x164, &mut x165, x163, x139, x136);
  let mut x166: u32 = 0;
  let mut x167: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x166, &mut x167, 0x0, x118, x150);
  let mut x168: u32 = 0;
  let mut x169: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x168, &mut x169, x167, x120, x152);
  let mut x170: u32 = 0;
  let mut x171: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x170, &mut x171, x169, x122, x154);
  let mut x172: u32 = 0;
  let mut x173: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x172, &mut x173, x171, x124, x156);
  let mut x174: u32 = 0;
  let mut x175: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x174, &mut x175, x173, x126, x158);
  let mut x176: u32 = 0;
  let mut x177: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x176, &mut x177, x175, x128, x160);
  let mut x178: u32 = 0;
  let mut x179: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x178, &mut x179, x177, x130, x162);
  let mut x180: u32 = 0;
  let mut x181: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x180, &mut x181, x179, x132, x164);
  let mut x182: u32 = 0;
  let mut x183: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x182, &mut x183, x181, ((x133 as u32) + (x117 as u32)), ((x165 as u32) + x137));
  let mut x184: u32 = 0;
  let mut x185: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x184, &mut x185, 0x0, x168, (arg1[3]));
  let mut x186: u32 = 0;
  let mut x187: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x186, &mut x187, x185, x170, (0x0 as u32));
  let mut x188: u32 = 0;
  let mut x189: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x188, &mut x189, x187, x172, (0x0 as u32));
  let mut x190: u32 = 0;
  let mut x191: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x190, &mut x191, x189, x174, (0x0 as u32));
  let mut x192: u32 = 0;
  let mut x193: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x192, &mut x193, x191, x176, (0x0 as u32));
  let mut x194: u32 = 0;
  let mut x195: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x194, &mut x195, x193, x178, (0x0 as u32));
  let mut x196: u32 = 0;
  let mut x197: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x196, &mut x197, x195, x180, (0x0 as u32));
  let mut x198: u32 = 0;
  let mut x199: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x198, &mut x199, x197, x182, (0x0 as u32));
  let mut x200: u32 = 0;
  let mut x201: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x200, &mut x201, x184, 0x5588b13f);
  let mut x202: u32 = 0;
  let mut x203: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x202, &mut x203, x200, 0xffffffff);
  let mut x204: u32 = 0;
  let mut x205: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x204, &mut x205, x200, 0xffffffff);
  let mut x206: u32 = 0;
  let mut x207: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x206, &mut x207, x200, 0xffffffff);
  let mut x208: u32 = 0;
  let mut x209: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x208, &mut x209, x200, 0xfffffffe);
  let mut x210: u32 = 0;
  let mut x211: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x210, &mut x211, x200, 0xbaaedce6);
  let mut x212: u32 = 0;
  let mut x213: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x212, &mut x213, x200, 0xaf48a03b);
  let mut x214: u32 = 0;
  let mut x215: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x214, &mut x215, x200, 0xbfd25e8c);
  let mut x216: u32 = 0;
  let mut x217: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x216, &mut x217, x200, 0xd0364141);
  let mut x218: u32 = 0;
  let mut x219: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x218, &mut x219, 0x0, x217, x214);
  let mut x220: u32 = 0;
  let mut x221: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x220, &mut x221, x219, x215, x212);
  let mut x222: u32 = 0;
  let mut x223: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x222, &mut x223, x221, x213, x210);
  let mut x224: u32 = 0;
  let mut x225: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x224, &mut x225, x223, x211, x208);
  let mut x226: u32 = 0;
  let mut x227: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x226, &mut x227, x225, x209, x206);
  let mut x228: u32 = 0;
  let mut x229: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x228, &mut x229, x227, x207, x204);
  let mut x230: u32 = 0;
  let mut x231: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x230, &mut x231, x229, x205, x202);
  let mut x232: u32 = 0;
  let mut x233: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x232, &mut x233, 0x0, x184, x216);
  let mut x234: u32 = 0;
  let mut x235: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x234, &mut x235, x233, x186, x218);
  let mut x236: u32 = 0;
  let mut x237: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x236, &mut x237, x235, x188, x220);
  let mut x238: u32 = 0;
  let mut x239: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x238, &mut x239, x237, x190, x222);
  let mut x240: u32 = 0;
  let mut x241: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x240, &mut x241, x239, x192, x224);
  let mut x242: u32 = 0;
  let mut x243: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x242, &mut x243, x241, x194, x226);
  let mut x244: u32 = 0;
  let mut x245: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x244, &mut x245, x243, x196, x228);
  let mut x246: u32 = 0;
  let mut x247: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x246, &mut x247, x245, x198, x230);
  let mut x248: u32 = 0;
  let mut x249: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x248, &mut x249, x247, ((x199 as u32) + (x183 as u32)), ((x231 as u32) + x203));
  let mut x250: u32 = 0;
  let mut x251: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x250, &mut x251, 0x0, x234, (arg1[4]));
  let mut x252: u32 = 0;
  let mut x253: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x252, &mut x253, x251, x236, (0x0 as u32));
  let mut x254: u32 = 0;
  let mut x255: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x254, &mut x255, x253, x238, (0x0 as u32));
  let mut x256: u32 = 0;
  let mut x257: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x256, &mut x257, x255, x240, (0x0 as u32));
  let mut x258: u32 = 0;
  let mut x259: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x258, &mut x259, x257, x242, (0x0 as u32));
  let mut x260: u32 = 0;
  let mut x261: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x260, &mut x261, x259, x244, (0x0 as u32));
  let mut x262: u32 = 0;
  let mut x263: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x262, &mut x263, x261, x246, (0x0 as u32));
  let mut x264: u32 = 0;
  let mut x265: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x264, &mut x265, x263, x248, (0x0 as u32));
  let mut x266: u32 = 0;
  let mut x267: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x266, &mut x267, x250, 0x5588b13f);
  let mut x268: u32 = 0;
  let mut x269: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x268, &mut x269, x266, 0xffffffff);
  let mut x270: u32 = 0;
  let mut x271: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x270, &mut x271, x266, 0xffffffff);
  let mut x272: u32 = 0;
  let mut x273: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x272, &mut x273, x266, 0xffffffff);
  let mut x274: u32 = 0;
  let mut x275: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x274, &mut x275, x266, 0xfffffffe);
  let mut x276: u32 = 0;
  let mut x277: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x276, &mut x277, x266, 0xbaaedce6);
  let mut x278: u32 = 0;
  let mut x279: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x278, &mut x279, x266, 0xaf48a03b);
  let mut x280: u32 = 0;
  let mut x281: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x280, &mut x281, x266, 0xbfd25e8c);
  let mut x282: u32 = 0;
  let mut x283: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x282, &mut x283, x266, 0xd0364141);
  let mut x284: u32 = 0;
  let mut x285: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x284, &mut x285, 0x0, x283, x280);
  let mut x286: u32 = 0;
  let mut x287: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x286, &mut x287, x285, x281, x278);
  let mut x288: u32 = 0;
  let mut x289: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x288, &mut x289, x287, x279, x276);
  let mut x290: u32 = 0;
  let mut x291: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x290, &mut x291, x289, x277, x274);
  let mut x292: u32 = 0;
  let mut x293: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x292, &mut x293, x291, x275, x272);
  let mut x294: u32 = 0;
  let mut x295: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x294, &mut x295, x293, x273, x270);
  let mut x296: u32 = 0;
  let mut x297: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x296, &mut x297, x295, x271, x268);
  let mut x298: u32 = 0;
  let mut x299: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x298, &mut x299, 0x0, x250, x282);
  let mut x300: u32 = 0;
  let mut x301: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x300, &mut x301, x299, x252, x284);
  let mut x302: u32 = 0;
  let mut x303: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x302, &mut x303, x301, x254, x286);
  let mut x304: u32 = 0;
  let mut x305: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x304, &mut x305, x303, x256, x288);
  let mut x306: u32 = 0;
  let mut x307: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x306, &mut x307, x305, x258, x290);
  let mut x308: u32 = 0;
  let mut x309: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x308, &mut x309, x307, x260, x292);
  let mut x310: u32 = 0;
  let mut x311: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x310, &mut x311, x309, x262, x294);
  let mut x312: u32 = 0;
  let mut x313: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x312, &mut x313, x311, x264, x296);
  let mut x314: u32 = 0;
  let mut x315: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x314, &mut x315, x313, ((x265 as u32) + (x249 as u32)), ((x297 as u32) + x269));
  let mut x316: u32 = 0;
  let mut x317: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x316, &mut x317, 0x0, x300, (arg1[5]));
  let mut x318: u32 = 0;
  let mut x319: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x318, &mut x319, x317, x302, (0x0 as u32));
  let mut x320: u32 = 0;
  let mut x321: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x320, &mut x321, x319, x304, (0x0 as u32));
  let mut x322: u32 = 0;
  let mut x323: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x322, &mut x323, x321, x306, (0x0 as u32));
  let mut x324: u32 = 0;
  let mut x325: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x324, &mut x325, x323, x308, (0x0 as u32));
  let mut x326: u32 = 0;
  let mut x327: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x326, &mut x327, x325, x310, (0x0 as u32));
  let mut x328: u32 = 0;
  let mut x329: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x328, &mut x329, x327, x312, (0x0 as u32));
  let mut x330: u32 = 0;
  let mut x331: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x330, &mut x331, x329, x314, (0x0 as u32));
  let mut x332: u32 = 0;
  let mut x333: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x332, &mut x333, x316, 0x5588b13f);
  let mut x334: u32 = 0;
  let mut x335: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x334, &mut x335, x332, 0xffffffff);
  let mut x336: u32 = 0;
  let mut x337: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x336, &mut x337, x332, 0xffffffff);
  let mut x338: u32 = 0;
  let mut x339: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x338, &mut x339, x332, 0xffffffff);
  let mut x340: u32 = 0;
  let mut x341: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x340, &mut x341, x332, 0xfffffffe);
  let mut x342: u32 = 0;
  let mut x343: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x342, &mut x343, x332, 0xbaaedce6);
  let mut x344: u32 = 0;
  let mut x345: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x344, &mut x345, x332, 0xaf48a03b);
  let mut x346: u32 = 0;
  let mut x347: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x346, &mut x347, x332, 0xbfd25e8c);
  let mut x348: u32 = 0;
  let mut x349: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x348, &mut x349, x332, 0xd0364141);
  let mut x350: u32 = 0;
  let mut x351: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x350, &mut x351, 0x0, x349, x346);
  let mut x352: u32 = 0;
  let mut x353: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x352, &mut x353, x351, x347, x344);
  let mut x354: u32 = 0;
  let mut x355: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x354, &mut x355, x353, x345, x342);
  let mut x356: u32 = 0;
  let mut x357: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x356, &mut x357, x355, x343, x340);
  let mut x358: u32 = 0;
  let mut x359: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x358, &mut x359, x357, x341, x338);
  let mut x360: u32 = 0;
  let mut x361: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x360, &mut x361, x359, x339, x336);
  let mut x362: u32 = 0;
  let mut x363: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x362, &mut x363, x361, x337, x334);
  let mut x364: u32 = 0;
  let mut x365: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x364, &mut x365, 0x0, x316, x348);
  let mut x366: u32 = 0;
  let mut x367: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x366, &mut x367, x365, x318, x350);
  let mut x368: u32 = 0;
  let mut x369: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x368, &mut x369, x367, x320, x352);
  let mut x370: u32 = 0;
  let mut x371: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x370, &mut x371, x369, x322, x354);
  let mut x372: u32 = 0;
  let mut x373: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x372, &mut x373, x371, x324, x356);
  let mut x374: u32 = 0;
  let mut x375: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x374, &mut x375, x373, x326, x358);
  let mut x376: u32 = 0;
  let mut x377: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x376, &mut x377, x375, x328, x360);
  let mut x378: u32 = 0;
  let mut x379: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x378, &mut x379, x377, x330, x362);
  let mut x380: u32 = 0;
  let mut x381: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x380, &mut x381, x379, ((x331 as u32) + (x315 as u32)), ((x363 as u32) + x335));
  let mut x382: u32 = 0;
  let mut x383: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x382, &mut x383, 0x0, x366, (arg1[6]));
  let mut x384: u32 = 0;
  let mut x385: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x384, &mut x385, x383, x368, (0x0 as u32));
  let mut x386: u32 = 0;
  let mut x387: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x386, &mut x387, x385, x370, (0x0 as u32));
  let mut x388: u32 = 0;
  let mut x389: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x388, &mut x389, x387, x372, (0x0 as u32));
  let mut x390: u32 = 0;
  let mut x391: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x390, &mut x391, x389, x374, (0x0 as u32));
  let mut x392: u32 = 0;
  let mut x393: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x392, &mut x393, x391, x376, (0x0 as u32));
  let mut x394: u32 = 0;
  let mut x395: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x394, &mut x395, x393, x378, (0x0 as u32));
  let mut x396: u32 = 0;
  let mut x397: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x396, &mut x397, x395, x380, (0x0 as u32));
  let mut x398: u32 = 0;
  let mut x399: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x398, &mut x399, x382, 0x5588b13f);
  let mut x400: u32 = 0;
  let mut x401: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x400, &mut x401, x398, 0xffffffff);
  let mut x402: u32 = 0;
  let mut x403: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x402, &mut x403, x398, 0xffffffff);
  let mut x404: u32 = 0;
  let mut x405: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x404, &mut x405, x398, 0xffffffff);
  let mut x406: u32 = 0;
  let mut x407: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x406, &mut x407, x398, 0xfffffffe);
  let mut x408: u32 = 0;
  let mut x409: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x408, &mut x409, x398, 0xbaaedce6);
  let mut x410: u32 = 0;
  let mut x411: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x410, &mut x411, x398, 0xaf48a03b);
  let mut x412: u32 = 0;
  let mut x413: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x412, &mut x413, x398, 0xbfd25e8c);
  let mut x414: u32 = 0;
  let mut x415: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x414, &mut x415, x398, 0xd0364141);
  let mut x416: u32 = 0;
  let mut x417: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x416, &mut x417, 0x0, x415, x412);
  let mut x418: u32 = 0;
  let mut x419: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x418, &mut x419, x417, x413, x410);
  let mut x420: u32 = 0;
  let mut x421: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x420, &mut x421, x419, x411, x408);
  let mut x422: u32 = 0;
  let mut x423: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x422, &mut x423, x421, x409, x406);
  let mut x424: u32 = 0;
  let mut x425: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x424, &mut x425, x423, x407, x404);
  let mut x426: u32 = 0;
  let mut x427: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x426, &mut x427, x425, x405, x402);
  let mut x428: u32 = 0;
  let mut x429: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x428, &mut x429, x427, x403, x400);
  let mut x430: u32 = 0;
  let mut x431: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x430, &mut x431, 0x0, x382, x414);
  let mut x432: u32 = 0;
  let mut x433: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x432, &mut x433, x431, x384, x416);
  let mut x434: u32 = 0;
  let mut x435: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x434, &mut x435, x433, x386, x418);
  let mut x436: u32 = 0;
  let mut x437: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x436, &mut x437, x435, x388, x420);
  let mut x438: u32 = 0;
  let mut x439: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x438, &mut x439, x437, x390, x422);
  let mut x440: u32 = 0;
  let mut x441: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x440, &mut x441, x439, x392, x424);
  let mut x442: u32 = 0;
  let mut x443: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x442, &mut x443, x441, x394, x426);
  let mut x444: u32 = 0;
  let mut x445: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x444, &mut x445, x443, x396, x428);
  let mut x446: u32 = 0;
  let mut x447: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x446, &mut x447, x445, ((x397 as u32) + (x381 as u32)), ((x429 as u32) + x401));
  let mut x448: u32 = 0;
  let mut x449: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x448, &mut x449, 0x0, x432, (arg1[7]));
  let mut x450: u32 = 0;
  let mut x451: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x450, &mut x451, x449, x434, (0x0 as u32));
  let mut x452: u32 = 0;
  let mut x453: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x452, &mut x453, x451, x436, (0x0 as u32));
  let mut x454: u32 = 0;
  let mut x455: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x454, &mut x455, x453, x438, (0x0 as u32));
  let mut x456: u32 = 0;
  let mut x457: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x456, &mut x457, x455, x440, (0x0 as u32));
  let mut x458: u32 = 0;
  let mut x459: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x458, &mut x459, x457, x442, (0x0 as u32));
  let mut x460: u32 = 0;
  let mut x461: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x460, &mut x461, x459, x444, (0x0 as u32));
  let mut x462: u32 = 0;
  let mut x463: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x462, &mut x463, x461, x446, (0x0 as u32));
  let mut x464: u32 = 0;
  let mut x465: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x464, &mut x465, x448, 0x5588b13f);
  let mut x466: u32 = 0;
  let mut x467: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x466, &mut x467, x464, 0xffffffff);
  let mut x468: u32 = 0;
  let mut x469: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x468, &mut x469, x464, 0xffffffff);
  let mut x470: u32 = 0;
  let mut x471: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x470, &mut x471, x464, 0xffffffff);
  let mut x472: u32 = 0;
  let mut x473: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x472, &mut x473, x464, 0xfffffffe);
  let mut x474: u32 = 0;
  let mut x475: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x474, &mut x475, x464, 0xbaaedce6);
  let mut x476: u32 = 0;
  let mut x477: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x476, &mut x477, x464, 0xaf48a03b);
  let mut x478: u32 = 0;
  let mut x479: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x478, &mut x479, x464, 0xbfd25e8c);
  let mut x480: u32 = 0;
  let mut x481: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x480, &mut x481, x464, 0xd0364141);
  let mut x482: u32 = 0;
  let mut x483: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x482, &mut x483, 0x0, x481, x478);
  let mut x484: u32 = 0;
  let mut x485: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x484, &mut x485, x483, x479, x476);
  let mut x486: u32 = 0;
  let mut x487: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x486, &mut x487, x485, x477, x474);
  let mut x488: u32 = 0;
  let mut x489: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x488, &mut x489, x487, x475, x472);
  let mut x490: u32 = 0;
  let mut x491: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x490, &mut x491, x489, x473, x470);
  let mut x492: u32 = 0;
  let mut x493: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x492, &mut x493, x491, x471, x468);
  let mut x494: u32 = 0;
  let mut x495: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x494, &mut x495, x493, x469, x466);
  let mut x496: u32 = 0;
  let mut x497: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x496, &mut x497, 0x0, x448, x480);
  let mut x498: u32 = 0;
  let mut x499: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x498, &mut x499, x497, x450, x482);
  let mut x500: u32 = 0;
  let mut x501: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x500, &mut x501, x499, x452, x484);
  let mut x502: u32 = 0;
  let mut x503: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x502, &mut x503, x501, x454, x486);
  let mut x504: u32 = 0;
  let mut x505: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x504, &mut x505, x503, x456, x488);
  let mut x506: u32 = 0;
  let mut x507: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x506, &mut x507, x505, x458, x490);
  let mut x508: u32 = 0;
  let mut x509: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x508, &mut x509, x507, x460, x492);
  let mut x510: u32 = 0;
  let mut x511: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x510, &mut x511, x509, x462, x494);
  let mut x512: u32 = 0;
  let mut x513: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x512, &mut x513, x511, ((x463 as u32) + (x447 as u32)), ((x495 as u32) + x467));
  let mut x514: u32 = 0;
  let mut x515: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x514, &mut x515, 0x0, x498, 0xd0364141);
  let mut x516: u32 = 0;
  let mut x517: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x516, &mut x517, x515, x500, 0xbfd25e8c);
  let mut x518: u32 = 0;
  let mut x519: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x518, &mut x519, x517, x502, 0xaf48a03b);
  let mut x520: u32 = 0;
  let mut x521: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x520, &mut x521, x519, x504, 0xbaaedce6);
  let mut x522: u32 = 0;
  let mut x523: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x522, &mut x523, x521, x506, 0xfffffffe);
  let mut x524: u32 = 0;
  let mut x525: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x524, &mut x525, x523, x508, 0xffffffff);
  let mut x526: u32 = 0;
  let mut x527: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x526, &mut x527, x525, x510, 0xffffffff);
  let mut x528: u32 = 0;
  let mut x529: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x528, &mut x529, x527, x512, 0xffffffff);
  let mut x530: u32 = 0;
  let mut x531: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x530, &mut x531, x529, (x513 as u32), (0x0 as u32));
  let mut x532: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x532, x531, x514, x498);
  let mut x533: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x533, x531, x516, x500);
  let mut x534: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x534, x531, x518, x502);
  let mut x535: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x535, x531, x520, x504);
  let mut x536: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x536, x531, x522, x506);
  let mut x537: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x537, x531, x524, x508);
  let mut x538: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x538, x531, x526, x510);
  let mut x539: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x539, x531, x528, x512);
  out1[0] = x532;
  out1[1] = x533;
  out1[2] = x534;
  out1[3] = x535;
  out1[4] = x536;
  out1[5] = x537;
  out1[6] = x538;
  out1[7] = x539;
}

/// The function fiat_secp256k1_montgomery_scalar_to_montgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_to_montgomery(out1: &mut fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element, arg1: &fiat_secp256k1_montgomery_scalar_non_montgomery_domain_field_element) {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[0]);
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x9, &mut x10, x8, 0x9d671cd5);
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x11, &mut x12, x8, 0x81c69bc5);
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x13, &mut x14, x8, 0xe697f5e4);
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x15, &mut x16, x8, 0x5bcd07c6);
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x17, &mut x18, x8, 0x741496c2);
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x19, &mut x20, x8, 0xe7cf878);
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x21, &mut x22, x8, 0x896cf214);
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x23, &mut x24, x8, 0x67d7d140);
  let mut x25: u32 = 0;
  let mut x26: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x25, &mut x26, 0x0, x24, x21);
  let mut x27: u32 = 0;
  let mut x28: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x27, &mut x28, x26, x22, x19);
  let mut x29: u32 = 0;
  let mut x30: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x29, &mut x30, x28, x20, x17);
  let mut x31: u32 = 0;
  let mut x32: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x31, &mut x32, x30, x18, x15);
  let mut x33: u32 = 0;
  let mut x34: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x33, &mut x34, x32, x16, x13);
  let mut x35: u32 = 0;
  let mut x36: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x35, &mut x36, x34, x14, x11);
  let mut x37: u32 = 0;
  let mut x38: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x37, &mut x38, x36, x12, x9);
  let mut x39: u32 = 0;
  let mut x40: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x39, &mut x40, x23, 0x5588b13f);
  let mut x41: u32 = 0;
  let mut x42: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x41, &mut x42, x39, 0xffffffff);
  let mut x43: u32 = 0;
  let mut x44: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x43, &mut x44, x39, 0xffffffff);
  let mut x45: u32 = 0;
  let mut x46: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x45, &mut x46, x39, 0xffffffff);
  let mut x47: u32 = 0;
  let mut x48: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x47, &mut x48, x39, 0xfffffffe);
  let mut x49: u32 = 0;
  let mut x50: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x49, &mut x50, x39, 0xbaaedce6);
  let mut x51: u32 = 0;
  let mut x52: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x51, &mut x52, x39, 0xaf48a03b);
  let mut x53: u32 = 0;
  let mut x54: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x53, &mut x54, x39, 0xbfd25e8c);
  let mut x55: u32 = 0;
  let mut x56: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x55, &mut x56, x39, 0xd0364141);
  let mut x57: u32 = 0;
  let mut x58: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x57, &mut x58, 0x0, x56, x53);
  let mut x59: u32 = 0;
  let mut x60: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x59, &mut x60, x58, x54, x51);
  let mut x61: u32 = 0;
  let mut x62: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x61, &mut x62, x60, x52, x49);
  let mut x63: u32 = 0;
  let mut x64: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x63, &mut x64, x62, x50, x47);
  let mut x65: u32 = 0;
  let mut x66: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x65, &mut x66, x64, x48, x45);
  let mut x67: u32 = 0;
  let mut x68: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x67, &mut x68, x66, x46, x43);
  let mut x69: u32 = 0;
  let mut x70: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x69, &mut x70, x68, x44, x41);
  let mut x71: u32 = 0;
  let mut x72: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x71, &mut x72, 0x0, x23, x55);
  let mut x73: u32 = 0;
  let mut x74: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x73, &mut x74, x72, x25, x57);
  let mut x75: u32 = 0;
  let mut x76: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x75, &mut x76, x74, x27, x59);
  let mut x77: u32 = 0;
  let mut x78: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x77, &mut x78, x76, x29, x61);
  let mut x79: u32 = 0;
  let mut x80: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x79, &mut x80, x78, x31, x63);
  let mut x81: u32 = 0;
  let mut x82: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x81, &mut x82, x80, x33, x65);
  let mut x83: u32 = 0;
  let mut x84: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x83, &mut x84, x82, x35, x67);
  let mut x85: u32 = 0;
  let mut x86: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x85, &mut x86, x84, x37, x69);
  let mut x87: u32 = 0;
  let mut x88: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x87, &mut x88, x86, ((x38 as u32) + x10), ((x70 as u32) + x42));
  let mut x89: u32 = 0;
  let mut x90: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x89, &mut x90, x1, 0x9d671cd5);
  let mut x91: u32 = 0;
  let mut x92: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x91, &mut x92, x1, 0x81c69bc5);
  let mut x93: u32 = 0;
  let mut x94: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x93, &mut x94, x1, 0xe697f5e4);
  let mut x95: u32 = 0;
  let mut x96: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x95, &mut x96, x1, 0x5bcd07c6);
  let mut x97: u32 = 0;
  let mut x98: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x97, &mut x98, x1, 0x741496c2);
  let mut x99: u32 = 0;
  let mut x100: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x99, &mut x100, x1, 0xe7cf878);
  let mut x101: u32 = 0;
  let mut x102: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x101, &mut x102, x1, 0x896cf214);
  let mut x103: u32 = 0;
  let mut x104: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x103, &mut x104, x1, 0x67d7d140);
  let mut x105: u32 = 0;
  let mut x106: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x105, &mut x106, 0x0, x104, x101);
  let mut x107: u32 = 0;
  let mut x108: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x107, &mut x108, x106, x102, x99);
  let mut x109: u32 = 0;
  let mut x110: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x109, &mut x110, x108, x100, x97);
  let mut x111: u32 = 0;
  let mut x112: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x111, &mut x112, x110, x98, x95);
  let mut x113: u32 = 0;
  let mut x114: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x113, &mut x114, x112, x96, x93);
  let mut x115: u32 = 0;
  let mut x116: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x115, &mut x116, x114, x94, x91);
  let mut x117: u32 = 0;
  let mut x118: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x117, &mut x118, x116, x92, x89);
  let mut x119: u32 = 0;
  let mut x120: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x119, &mut x120, 0x0, x73, x103);
  let mut x121: u32 = 0;
  let mut x122: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x121, &mut x122, x120, x75, x105);
  let mut x123: u32 = 0;
  let mut x124: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x123, &mut x124, x122, x77, x107);
  let mut x125: u32 = 0;
  let mut x126: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x125, &mut x126, x124, x79, x109);
  let mut x127: u32 = 0;
  let mut x128: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x127, &mut x128, x126, x81, x111);
  let mut x129: u32 = 0;
  let mut x130: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x129, &mut x130, x128, x83, x113);
  let mut x131: u32 = 0;
  let mut x132: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x131, &mut x132, x130, x85, x115);
  let mut x133: u32 = 0;
  let mut x134: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x133, &mut x134, x132, x87, x117);
  let mut x135: u32 = 0;
  let mut x136: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x135, &mut x136, x119, 0x5588b13f);
  let mut x137: u32 = 0;
  let mut x138: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x137, &mut x138, x135, 0xffffffff);
  let mut x139: u32 = 0;
  let mut x140: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x139, &mut x140, x135, 0xffffffff);
  let mut x141: u32 = 0;
  let mut x142: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x141, &mut x142, x135, 0xffffffff);
  let mut x143: u32 = 0;
  let mut x144: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x143, &mut x144, x135, 0xfffffffe);
  let mut x145: u32 = 0;
  let mut x146: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x145, &mut x146, x135, 0xbaaedce6);
  let mut x147: u32 = 0;
  let mut x148: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x147, &mut x148, x135, 0xaf48a03b);
  let mut x149: u32 = 0;
  let mut x150: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x149, &mut x150, x135, 0xbfd25e8c);
  let mut x151: u32 = 0;
  let mut x152: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x151, &mut x152, x135, 0xd0364141);
  let mut x153: u32 = 0;
  let mut x154: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x153, &mut x154, 0x0, x152, x149);
  let mut x155: u32 = 0;
  let mut x156: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x155, &mut x156, x154, x150, x147);
  let mut x157: u32 = 0;
  let mut x158: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x157, &mut x158, x156, x148, x145);
  let mut x159: u32 = 0;
  let mut x160: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x159, &mut x160, x158, x146, x143);
  let mut x161: u32 = 0;
  let mut x162: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x161, &mut x162, x160, x144, x141);
  let mut x163: u32 = 0;
  let mut x164: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x163, &mut x164, x162, x142, x139);
  let mut x165: u32 = 0;
  let mut x166: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x165, &mut x166, x164, x140, x137);
  let mut x167: u32 = 0;
  let mut x168: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x167, &mut x168, 0x0, x119, x151);
  let mut x169: u32 = 0;
  let mut x170: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x169, &mut x170, x168, x121, x153);
  let mut x171: u32 = 0;
  let mut x172: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x171, &mut x172, x170, x123, x155);
  let mut x173: u32 = 0;
  let mut x174: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x173, &mut x174, x172, x125, x157);
  let mut x175: u32 = 0;
  let mut x176: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x175, &mut x176, x174, x127, x159);
  let mut x177: u32 = 0;
  let mut x178: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x177, &mut x178, x176, x129, x161);
  let mut x179: u32 = 0;
  let mut x180: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x179, &mut x180, x178, x131, x163);
  let mut x181: u32 = 0;
  let mut x182: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x181, &mut x182, x180, x133, x165);
  let mut x183: u32 = 0;
  let mut x184: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x183, &mut x184, x182, (((x134 as u32) + (x88 as u32)) + ((x118 as u32) + x90)), ((x166 as u32) + x138));
  let mut x185: u32 = 0;
  let mut x186: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x185, &mut x186, x2, 0x9d671cd5);
  let mut x187: u32 = 0;
  let mut x188: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x187, &mut x188, x2, 0x81c69bc5);
  let mut x189: u32 = 0;
  let mut x190: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x189, &mut x190, x2, 0xe697f5e4);
  let mut x191: u32 = 0;
  let mut x192: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x191, &mut x192, x2, 0x5bcd07c6);
  let mut x193: u32 = 0;
  let mut x194: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x193, &mut x194, x2, 0x741496c2);
  let mut x195: u32 = 0;
  let mut x196: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x195, &mut x196, x2, 0xe7cf878);
  let mut x197: u32 = 0;
  let mut x198: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x197, &mut x198, x2, 0x896cf214);
  let mut x199: u32 = 0;
  let mut x200: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x199, &mut x200, x2, 0x67d7d140);
  let mut x201: u32 = 0;
  let mut x202: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x201, &mut x202, 0x0, x200, x197);
  let mut x203: u32 = 0;
  let mut x204: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x203, &mut x204, x202, x198, x195);
  let mut x205: u32 = 0;
  let mut x206: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x205, &mut x206, x204, x196, x193);
  let mut x207: u32 = 0;
  let mut x208: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x207, &mut x208, x206, x194, x191);
  let mut x209: u32 = 0;
  let mut x210: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x209, &mut x210, x208, x192, x189);
  let mut x211: u32 = 0;
  let mut x212: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x211, &mut x212, x210, x190, x187);
  let mut x213: u32 = 0;
  let mut x214: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x213, &mut x214, x212, x188, x185);
  let mut x215: u32 = 0;
  let mut x216: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x215, &mut x216, 0x0, x169, x199);
  let mut x217: u32 = 0;
  let mut x218: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x217, &mut x218, x216, x171, x201);
  let mut x219: u32 = 0;
  let mut x220: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x219, &mut x220, x218, x173, x203);
  let mut x221: u32 = 0;
  let mut x222: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x221, &mut x222, x220, x175, x205);
  let mut x223: u32 = 0;
  let mut x224: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x223, &mut x224, x222, x177, x207);
  let mut x225: u32 = 0;
  let mut x226: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x225, &mut x226, x224, x179, x209);
  let mut x227: u32 = 0;
  let mut x228: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x227, &mut x228, x226, x181, x211);
  let mut x229: u32 = 0;
  let mut x230: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x229, &mut x230, x228, x183, x213);
  let mut x231: u32 = 0;
  let mut x232: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x231, &mut x232, x215, 0x5588b13f);
  let mut x233: u32 = 0;
  let mut x234: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x233, &mut x234, x231, 0xffffffff);
  let mut x235: u32 = 0;
  let mut x236: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x235, &mut x236, x231, 0xffffffff);
  let mut x237: u32 = 0;
  let mut x238: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x237, &mut x238, x231, 0xffffffff);
  let mut x239: u32 = 0;
  let mut x240: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x239, &mut x240, x231, 0xfffffffe);
  let mut x241: u32 = 0;
  let mut x242: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x241, &mut x242, x231, 0xbaaedce6);
  let mut x243: u32 = 0;
  let mut x244: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x243, &mut x244, x231, 0xaf48a03b);
  let mut x245: u32 = 0;
  let mut x246: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x245, &mut x246, x231, 0xbfd25e8c);
  let mut x247: u32 = 0;
  let mut x248: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x247, &mut x248, x231, 0xd0364141);
  let mut x249: u32 = 0;
  let mut x250: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x249, &mut x250, 0x0, x248, x245);
  let mut x251: u32 = 0;
  let mut x252: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x251, &mut x252, x250, x246, x243);
  let mut x253: u32 = 0;
  let mut x254: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x253, &mut x254, x252, x244, x241);
  let mut x255: u32 = 0;
  let mut x256: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x255, &mut x256, x254, x242, x239);
  let mut x257: u32 = 0;
  let mut x258: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x257, &mut x258, x256, x240, x237);
  let mut x259: u32 = 0;
  let mut x260: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x259, &mut x260, x258, x238, x235);
  let mut x261: u32 = 0;
  let mut x262: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x261, &mut x262, x260, x236, x233);
  let mut x263: u32 = 0;
  let mut x264: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x263, &mut x264, 0x0, x215, x247);
  let mut x265: u32 = 0;
  let mut x266: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x265, &mut x266, x264, x217, x249);
  let mut x267: u32 = 0;
  let mut x268: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x267, &mut x268, x266, x219, x251);
  let mut x269: u32 = 0;
  let mut x270: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x269, &mut x270, x268, x221, x253);
  let mut x271: u32 = 0;
  let mut x272: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x271, &mut x272, x270, x223, x255);
  let mut x273: u32 = 0;
  let mut x274: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x273, &mut x274, x272, x225, x257);
  let mut x275: u32 = 0;
  let mut x276: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x275, &mut x276, x274, x227, x259);
  let mut x277: u32 = 0;
  let mut x278: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x277, &mut x278, x276, x229, x261);
  let mut x279: u32 = 0;
  let mut x280: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x279, &mut x280, x278, (((x230 as u32) + (x184 as u32)) + ((x214 as u32) + x186)), ((x262 as u32) + x234));
  let mut x281: u32 = 0;
  let mut x282: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x281, &mut x282, x3, 0x9d671cd5);
  let mut x283: u32 = 0;
  let mut x284: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x283, &mut x284, x3, 0x81c69bc5);
  let mut x285: u32 = 0;
  let mut x286: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x285, &mut x286, x3, 0xe697f5e4);
  let mut x287: u32 = 0;
  let mut x288: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x287, &mut x288, x3, 0x5bcd07c6);
  let mut x289: u32 = 0;
  let mut x290: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x289, &mut x290, x3, 0x741496c2);
  let mut x291: u32 = 0;
  let mut x292: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x291, &mut x292, x3, 0xe7cf878);
  let mut x293: u32 = 0;
  let mut x294: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x293, &mut x294, x3, 0x896cf214);
  let mut x295: u32 = 0;
  let mut x296: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x295, &mut x296, x3, 0x67d7d140);
  let mut x297: u32 = 0;
  let mut x298: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x297, &mut x298, 0x0, x296, x293);
  let mut x299: u32 = 0;
  let mut x300: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x299, &mut x300, x298, x294, x291);
  let mut x301: u32 = 0;
  let mut x302: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x301, &mut x302, x300, x292, x289);
  let mut x303: u32 = 0;
  let mut x304: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x303, &mut x304, x302, x290, x287);
  let mut x305: u32 = 0;
  let mut x306: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x305, &mut x306, x304, x288, x285);
  let mut x307: u32 = 0;
  let mut x308: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x307, &mut x308, x306, x286, x283);
  let mut x309: u32 = 0;
  let mut x310: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x309, &mut x310, x308, x284, x281);
  let mut x311: u32 = 0;
  let mut x312: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x311, &mut x312, 0x0, x265, x295);
  let mut x313: u32 = 0;
  let mut x314: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x313, &mut x314, x312, x267, x297);
  let mut x315: u32 = 0;
  let mut x316: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x315, &mut x316, x314, x269, x299);
  let mut x317: u32 = 0;
  let mut x318: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x317, &mut x318, x316, x271, x301);
  let mut x319: u32 = 0;
  let mut x320: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x319, &mut x320, x318, x273, x303);
  let mut x321: u32 = 0;
  let mut x322: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x321, &mut x322, x320, x275, x305);
  let mut x323: u32 = 0;
  let mut x324: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x323, &mut x324, x322, x277, x307);
  let mut x325: u32 = 0;
  let mut x326: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x325, &mut x326, x324, x279, x309);
  let mut x327: u32 = 0;
  let mut x328: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x327, &mut x328, x311, 0x5588b13f);
  let mut x329: u32 = 0;
  let mut x330: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x329, &mut x330, x327, 0xffffffff);
  let mut x331: u32 = 0;
  let mut x332: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x331, &mut x332, x327, 0xffffffff);
  let mut x333: u32 = 0;
  let mut x334: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x333, &mut x334, x327, 0xffffffff);
  let mut x335: u32 = 0;
  let mut x336: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x335, &mut x336, x327, 0xfffffffe);
  let mut x337: u32 = 0;
  let mut x338: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x337, &mut x338, x327, 0xbaaedce6);
  let mut x339: u32 = 0;
  let mut x340: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x339, &mut x340, x327, 0xaf48a03b);
  let mut x341: u32 = 0;
  let mut x342: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x341, &mut x342, x327, 0xbfd25e8c);
  let mut x343: u32 = 0;
  let mut x344: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x343, &mut x344, x327, 0xd0364141);
  let mut x345: u32 = 0;
  let mut x346: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x345, &mut x346, 0x0, x344, x341);
  let mut x347: u32 = 0;
  let mut x348: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x347, &mut x348, x346, x342, x339);
  let mut x349: u32 = 0;
  let mut x350: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x349, &mut x350, x348, x340, x337);
  let mut x351: u32 = 0;
  let mut x352: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x351, &mut x352, x350, x338, x335);
  let mut x353: u32 = 0;
  let mut x354: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x353, &mut x354, x352, x336, x333);
  let mut x355: u32 = 0;
  let mut x356: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x355, &mut x356, x354, x334, x331);
  let mut x357: u32 = 0;
  let mut x358: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x357, &mut x358, x356, x332, x329);
  let mut x359: u32 = 0;
  let mut x360: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x359, &mut x360, 0x0, x311, x343);
  let mut x361: u32 = 0;
  let mut x362: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x361, &mut x362, x360, x313, x345);
  let mut x363: u32 = 0;
  let mut x364: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x363, &mut x364, x362, x315, x347);
  let mut x365: u32 = 0;
  let mut x366: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x365, &mut x366, x364, x317, x349);
  let mut x367: u32 = 0;
  let mut x368: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x367, &mut x368, x366, x319, x351);
  let mut x369: u32 = 0;
  let mut x370: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x369, &mut x370, x368, x321, x353);
  let mut x371: u32 = 0;
  let mut x372: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x371, &mut x372, x370, x323, x355);
  let mut x373: u32 = 0;
  let mut x374: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x373, &mut x374, x372, x325, x357);
  let mut x375: u32 = 0;
  let mut x376: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x375, &mut x376, x374, (((x326 as u32) + (x280 as u32)) + ((x310 as u32) + x282)), ((x358 as u32) + x330));
  let mut x377: u32 = 0;
  let mut x378: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x377, &mut x378, x4, 0x9d671cd5);
  let mut x379: u32 = 0;
  let mut x380: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x379, &mut x380, x4, 0x81c69bc5);
  let mut x381: u32 = 0;
  let mut x382: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x381, &mut x382, x4, 0xe697f5e4);
  let mut x383: u32 = 0;
  let mut x384: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x383, &mut x384, x4, 0x5bcd07c6);
  let mut x385: u32 = 0;
  let mut x386: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x385, &mut x386, x4, 0x741496c2);
  let mut x387: u32 = 0;
  let mut x388: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x387, &mut x388, x4, 0xe7cf878);
  let mut x389: u32 = 0;
  let mut x390: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x389, &mut x390, x4, 0x896cf214);
  let mut x391: u32 = 0;
  let mut x392: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x391, &mut x392, x4, 0x67d7d140);
  let mut x393: u32 = 0;
  let mut x394: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x393, &mut x394, 0x0, x392, x389);
  let mut x395: u32 = 0;
  let mut x396: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x395, &mut x396, x394, x390, x387);
  let mut x397: u32 = 0;
  let mut x398: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x397, &mut x398, x396, x388, x385);
  let mut x399: u32 = 0;
  let mut x400: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x399, &mut x400, x398, x386, x383);
  let mut x401: u32 = 0;
  let mut x402: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x401, &mut x402, x400, x384, x381);
  let mut x403: u32 = 0;
  let mut x404: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x403, &mut x404, x402, x382, x379);
  let mut x405: u32 = 0;
  let mut x406: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x405, &mut x406, x404, x380, x377);
  let mut x407: u32 = 0;
  let mut x408: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x407, &mut x408, 0x0, x361, x391);
  let mut x409: u32 = 0;
  let mut x410: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x409, &mut x410, x408, x363, x393);
  let mut x411: u32 = 0;
  let mut x412: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x411, &mut x412, x410, x365, x395);
  let mut x413: u32 = 0;
  let mut x414: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x413, &mut x414, x412, x367, x397);
  let mut x415: u32 = 0;
  let mut x416: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x415, &mut x416, x414, x369, x399);
  let mut x417: u32 = 0;
  let mut x418: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x417, &mut x418, x416, x371, x401);
  let mut x419: u32 = 0;
  let mut x420: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x419, &mut x420, x418, x373, x403);
  let mut x421: u32 = 0;
  let mut x422: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x421, &mut x422, x420, x375, x405);
  let mut x423: u32 = 0;
  let mut x424: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x423, &mut x424, x407, 0x5588b13f);
  let mut x425: u32 = 0;
  let mut x426: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x425, &mut x426, x423, 0xffffffff);
  let mut x427: u32 = 0;
  let mut x428: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x427, &mut x428, x423, 0xffffffff);
  let mut x429: u32 = 0;
  let mut x430: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x429, &mut x430, x423, 0xffffffff);
  let mut x431: u32 = 0;
  let mut x432: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x431, &mut x432, x423, 0xfffffffe);
  let mut x433: u32 = 0;
  let mut x434: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x433, &mut x434, x423, 0xbaaedce6);
  let mut x435: u32 = 0;
  let mut x436: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x435, &mut x436, x423, 0xaf48a03b);
  let mut x437: u32 = 0;
  let mut x438: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x437, &mut x438, x423, 0xbfd25e8c);
  let mut x439: u32 = 0;
  let mut x440: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x439, &mut x440, x423, 0xd0364141);
  let mut x441: u32 = 0;
  let mut x442: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x441, &mut x442, 0x0, x440, x437);
  let mut x443: u32 = 0;
  let mut x444: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x443, &mut x444, x442, x438, x435);
  let mut x445: u32 = 0;
  let mut x446: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x445, &mut x446, x444, x436, x433);
  let mut x447: u32 = 0;
  let mut x448: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x447, &mut x448, x446, x434, x431);
  let mut x449: u32 = 0;
  let mut x450: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x449, &mut x450, x448, x432, x429);
  let mut x451: u32 = 0;
  let mut x452: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x451, &mut x452, x450, x430, x427);
  let mut x453: u32 = 0;
  let mut x454: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x453, &mut x454, x452, x428, x425);
  let mut x455: u32 = 0;
  let mut x456: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x455, &mut x456, 0x0, x407, x439);
  let mut x457: u32 = 0;
  let mut x458: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x457, &mut x458, x456, x409, x441);
  let mut x459: u32 = 0;
  let mut x460: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x459, &mut x460, x458, x411, x443);
  let mut x461: u32 = 0;
  let mut x462: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x461, &mut x462, x460, x413, x445);
  let mut x463: u32 = 0;
  let mut x464: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x463, &mut x464, x462, x415, x447);
  let mut x465: u32 = 0;
  let mut x466: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x465, &mut x466, x464, x417, x449);
  let mut x467: u32 = 0;
  let mut x468: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x467, &mut x468, x466, x419, x451);
  let mut x469: u32 = 0;
  let mut x470: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x469, &mut x470, x468, x421, x453);
  let mut x471: u32 = 0;
  let mut x472: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x471, &mut x472, x470, (((x422 as u32) + (x376 as u32)) + ((x406 as u32) + x378)), ((x454 as u32) + x426));
  let mut x473: u32 = 0;
  let mut x474: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x473, &mut x474, x5, 0x9d671cd5);
  let mut x475: u32 = 0;
  let mut x476: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x475, &mut x476, x5, 0x81c69bc5);
  let mut x477: u32 = 0;
  let mut x478: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x477, &mut x478, x5, 0xe697f5e4);
  let mut x479: u32 = 0;
  let mut x480: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x479, &mut x480, x5, 0x5bcd07c6);
  let mut x481: u32 = 0;
  let mut x482: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x481, &mut x482, x5, 0x741496c2);
  let mut x483: u32 = 0;
  let mut x484: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x483, &mut x484, x5, 0xe7cf878);
  let mut x485: u32 = 0;
  let mut x486: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x485, &mut x486, x5, 0x896cf214);
  let mut x487: u32 = 0;
  let mut x488: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x487, &mut x488, x5, 0x67d7d140);
  let mut x489: u32 = 0;
  let mut x490: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x489, &mut x490, 0x0, x488, x485);
  let mut x491: u32 = 0;
  let mut x492: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x491, &mut x492, x490, x486, x483);
  let mut x493: u32 = 0;
  let mut x494: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x493, &mut x494, x492, x484, x481);
  let mut x495: u32 = 0;
  let mut x496: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x495, &mut x496, x494, x482, x479);
  let mut x497: u32 = 0;
  let mut x498: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x497, &mut x498, x496, x480, x477);
  let mut x499: u32 = 0;
  let mut x500: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x499, &mut x500, x498, x478, x475);
  let mut x501: u32 = 0;
  let mut x502: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x501, &mut x502, x500, x476, x473);
  let mut x503: u32 = 0;
  let mut x504: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x503, &mut x504, 0x0, x457, x487);
  let mut x505: u32 = 0;
  let mut x506: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x505, &mut x506, x504, x459, x489);
  let mut x507: u32 = 0;
  let mut x508: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x507, &mut x508, x506, x461, x491);
  let mut x509: u32 = 0;
  let mut x510: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x509, &mut x510, x508, x463, x493);
  let mut x511: u32 = 0;
  let mut x512: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x511, &mut x512, x510, x465, x495);
  let mut x513: u32 = 0;
  let mut x514: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x513, &mut x514, x512, x467, x497);
  let mut x515: u32 = 0;
  let mut x516: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x515, &mut x516, x514, x469, x499);
  let mut x517: u32 = 0;
  let mut x518: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x517, &mut x518, x516, x471, x501);
  let mut x519: u32 = 0;
  let mut x520: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x519, &mut x520, x503, 0x5588b13f);
  let mut x521: u32 = 0;
  let mut x522: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x521, &mut x522, x519, 0xffffffff);
  let mut x523: u32 = 0;
  let mut x524: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x523, &mut x524, x519, 0xffffffff);
  let mut x525: u32 = 0;
  let mut x526: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x525, &mut x526, x519, 0xffffffff);
  let mut x527: u32 = 0;
  let mut x528: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x527, &mut x528, x519, 0xfffffffe);
  let mut x529: u32 = 0;
  let mut x530: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x529, &mut x530, x519, 0xbaaedce6);
  let mut x531: u32 = 0;
  let mut x532: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x531, &mut x532, x519, 0xaf48a03b);
  let mut x533: u32 = 0;
  let mut x534: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x533, &mut x534, x519, 0xbfd25e8c);
  let mut x535: u32 = 0;
  let mut x536: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x535, &mut x536, x519, 0xd0364141);
  let mut x537: u32 = 0;
  let mut x538: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x537, &mut x538, 0x0, x536, x533);
  let mut x539: u32 = 0;
  let mut x540: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x539, &mut x540, x538, x534, x531);
  let mut x541: u32 = 0;
  let mut x542: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x541, &mut x542, x540, x532, x529);
  let mut x543: u32 = 0;
  let mut x544: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x543, &mut x544, x542, x530, x527);
  let mut x545: u32 = 0;
  let mut x546: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x545, &mut x546, x544, x528, x525);
  let mut x547: u32 = 0;
  let mut x548: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x547, &mut x548, x546, x526, x523);
  let mut x549: u32 = 0;
  let mut x550: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x549, &mut x550, x548, x524, x521);
  let mut x551: u32 = 0;
  let mut x552: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x551, &mut x552, 0x0, x503, x535);
  let mut x553: u32 = 0;
  let mut x554: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x553, &mut x554, x552, x505, x537);
  let mut x555: u32 = 0;
  let mut x556: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x555, &mut x556, x554, x507, x539);
  let mut x557: u32 = 0;
  let mut x558: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x557, &mut x558, x556, x509, x541);
  let mut x559: u32 = 0;
  let mut x560: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x559, &mut x560, x558, x511, x543);
  let mut x561: u32 = 0;
  let mut x562: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x561, &mut x562, x560, x513, x545);
  let mut x563: u32 = 0;
  let mut x564: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x563, &mut x564, x562, x515, x547);
  let mut x565: u32 = 0;
  let mut x566: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x565, &mut x566, x564, x517, x549);
  let mut x567: u32 = 0;
  let mut x568: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x567, &mut x568, x566, (((x518 as u32) + (x472 as u32)) + ((x502 as u32) + x474)), ((x550 as u32) + x522));
  let mut x569: u32 = 0;
  let mut x570: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x569, &mut x570, x6, 0x9d671cd5);
  let mut x571: u32 = 0;
  let mut x572: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x571, &mut x572, x6, 0x81c69bc5);
  let mut x573: u32 = 0;
  let mut x574: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x573, &mut x574, x6, 0xe697f5e4);
  let mut x575: u32 = 0;
  let mut x576: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x575, &mut x576, x6, 0x5bcd07c6);
  let mut x577: u32 = 0;
  let mut x578: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x577, &mut x578, x6, 0x741496c2);
  let mut x579: u32 = 0;
  let mut x580: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x579, &mut x580, x6, 0xe7cf878);
  let mut x581: u32 = 0;
  let mut x582: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x581, &mut x582, x6, 0x896cf214);
  let mut x583: u32 = 0;
  let mut x584: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x583, &mut x584, x6, 0x67d7d140);
  let mut x585: u32 = 0;
  let mut x586: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x585, &mut x586, 0x0, x584, x581);
  let mut x587: u32 = 0;
  let mut x588: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x587, &mut x588, x586, x582, x579);
  let mut x589: u32 = 0;
  let mut x590: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x589, &mut x590, x588, x580, x577);
  let mut x591: u32 = 0;
  let mut x592: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x591, &mut x592, x590, x578, x575);
  let mut x593: u32 = 0;
  let mut x594: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x593, &mut x594, x592, x576, x573);
  let mut x595: u32 = 0;
  let mut x596: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x595, &mut x596, x594, x574, x571);
  let mut x597: u32 = 0;
  let mut x598: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x597, &mut x598, x596, x572, x569);
  let mut x599: u32 = 0;
  let mut x600: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x599, &mut x600, 0x0, x553, x583);
  let mut x601: u32 = 0;
  let mut x602: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x601, &mut x602, x600, x555, x585);
  let mut x603: u32 = 0;
  let mut x604: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x603, &mut x604, x602, x557, x587);
  let mut x605: u32 = 0;
  let mut x606: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x605, &mut x606, x604, x559, x589);
  let mut x607: u32 = 0;
  let mut x608: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x607, &mut x608, x606, x561, x591);
  let mut x609: u32 = 0;
  let mut x610: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x609, &mut x610, x608, x563, x593);
  let mut x611: u32 = 0;
  let mut x612: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x611, &mut x612, x610, x565, x595);
  let mut x613: u32 = 0;
  let mut x614: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x613, &mut x614, x612, x567, x597);
  let mut x615: u32 = 0;
  let mut x616: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x615, &mut x616, x599, 0x5588b13f);
  let mut x617: u32 = 0;
  let mut x618: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x617, &mut x618, x615, 0xffffffff);
  let mut x619: u32 = 0;
  let mut x620: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x619, &mut x620, x615, 0xffffffff);
  let mut x621: u32 = 0;
  let mut x622: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x621, &mut x622, x615, 0xffffffff);
  let mut x623: u32 = 0;
  let mut x624: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x623, &mut x624, x615, 0xfffffffe);
  let mut x625: u32 = 0;
  let mut x626: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x625, &mut x626, x615, 0xbaaedce6);
  let mut x627: u32 = 0;
  let mut x628: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x627, &mut x628, x615, 0xaf48a03b);
  let mut x629: u32 = 0;
  let mut x630: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x629, &mut x630, x615, 0xbfd25e8c);
  let mut x631: u32 = 0;
  let mut x632: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x631, &mut x632, x615, 0xd0364141);
  let mut x633: u32 = 0;
  let mut x634: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x633, &mut x634, 0x0, x632, x629);
  let mut x635: u32 = 0;
  let mut x636: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x635, &mut x636, x634, x630, x627);
  let mut x637: u32 = 0;
  let mut x638: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x637, &mut x638, x636, x628, x625);
  let mut x639: u32 = 0;
  let mut x640: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x639, &mut x640, x638, x626, x623);
  let mut x641: u32 = 0;
  let mut x642: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x641, &mut x642, x640, x624, x621);
  let mut x643: u32 = 0;
  let mut x644: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x643, &mut x644, x642, x622, x619);
  let mut x645: u32 = 0;
  let mut x646: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x645, &mut x646, x644, x620, x617);
  let mut x647: u32 = 0;
  let mut x648: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x647, &mut x648, 0x0, x599, x631);
  let mut x649: u32 = 0;
  let mut x650: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x649, &mut x650, x648, x601, x633);
  let mut x651: u32 = 0;
  let mut x652: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x651, &mut x652, x650, x603, x635);
  let mut x653: u32 = 0;
  let mut x654: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x653, &mut x654, x652, x605, x637);
  let mut x655: u32 = 0;
  let mut x656: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x655, &mut x656, x654, x607, x639);
  let mut x657: u32 = 0;
  let mut x658: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x657, &mut x658, x656, x609, x641);
  let mut x659: u32 = 0;
  let mut x660: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x659, &mut x660, x658, x611, x643);
  let mut x661: u32 = 0;
  let mut x662: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x661, &mut x662, x660, x613, x645);
  let mut x663: u32 = 0;
  let mut x664: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x663, &mut x664, x662, (((x614 as u32) + (x568 as u32)) + ((x598 as u32) + x570)), ((x646 as u32) + x618));
  let mut x665: u32 = 0;
  let mut x666: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x665, &mut x666, x7, 0x9d671cd5);
  let mut x667: u32 = 0;
  let mut x668: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x667, &mut x668, x7, 0x81c69bc5);
  let mut x669: u32 = 0;
  let mut x670: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x669, &mut x670, x7, 0xe697f5e4);
  let mut x671: u32 = 0;
  let mut x672: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x671, &mut x672, x7, 0x5bcd07c6);
  let mut x673: u32 = 0;
  let mut x674: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x673, &mut x674, x7, 0x741496c2);
  let mut x675: u32 = 0;
  let mut x676: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x675, &mut x676, x7, 0xe7cf878);
  let mut x677: u32 = 0;
  let mut x678: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x677, &mut x678, x7, 0x896cf214);
  let mut x679: u32 = 0;
  let mut x680: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x679, &mut x680, x7, 0x67d7d140);
  let mut x681: u32 = 0;
  let mut x682: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x681, &mut x682, 0x0, x680, x677);
  let mut x683: u32 = 0;
  let mut x684: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x683, &mut x684, x682, x678, x675);
  let mut x685: u32 = 0;
  let mut x686: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x685, &mut x686, x684, x676, x673);
  let mut x687: u32 = 0;
  let mut x688: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x687, &mut x688, x686, x674, x671);
  let mut x689: u32 = 0;
  let mut x690: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x689, &mut x690, x688, x672, x669);
  let mut x691: u32 = 0;
  let mut x692: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x691, &mut x692, x690, x670, x667);
  let mut x693: u32 = 0;
  let mut x694: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x693, &mut x694, x692, x668, x665);
  let mut x695: u32 = 0;
  let mut x696: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x695, &mut x696, 0x0, x649, x679);
  let mut x697: u32 = 0;
  let mut x698: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x697, &mut x698, x696, x651, x681);
  let mut x699: u32 = 0;
  let mut x700: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x699, &mut x700, x698, x653, x683);
  let mut x701: u32 = 0;
  let mut x702: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x701, &mut x702, x700, x655, x685);
  let mut x703: u32 = 0;
  let mut x704: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x703, &mut x704, x702, x657, x687);
  let mut x705: u32 = 0;
  let mut x706: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x705, &mut x706, x704, x659, x689);
  let mut x707: u32 = 0;
  let mut x708: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x707, &mut x708, x706, x661, x691);
  let mut x709: u32 = 0;
  let mut x710: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x709, &mut x710, x708, x663, x693);
  let mut x711: u32 = 0;
  let mut x712: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x711, &mut x712, x695, 0x5588b13f);
  let mut x713: u32 = 0;
  let mut x714: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x713, &mut x714, x711, 0xffffffff);
  let mut x715: u32 = 0;
  let mut x716: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x715, &mut x716, x711, 0xffffffff);
  let mut x717: u32 = 0;
  let mut x718: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x717, &mut x718, x711, 0xffffffff);
  let mut x719: u32 = 0;
  let mut x720: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x719, &mut x720, x711, 0xfffffffe);
  let mut x721: u32 = 0;
  let mut x722: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x721, &mut x722, x711, 0xbaaedce6);
  let mut x723: u32 = 0;
  let mut x724: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x723, &mut x724, x711, 0xaf48a03b);
  let mut x725: u32 = 0;
  let mut x726: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x725, &mut x726, x711, 0xbfd25e8c);
  let mut x727: u32 = 0;
  let mut x728: u32 = 0;
  fiat_secp256k1_montgomery_scalar_mulx_u32(&mut x727, &mut x728, x711, 0xd0364141);
  let mut x729: u32 = 0;
  let mut x730: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x729, &mut x730, 0x0, x728, x725);
  let mut x731: u32 = 0;
  let mut x732: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x731, &mut x732, x730, x726, x723);
  let mut x733: u32 = 0;
  let mut x734: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x733, &mut x734, x732, x724, x721);
  let mut x735: u32 = 0;
  let mut x736: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x735, &mut x736, x734, x722, x719);
  let mut x737: u32 = 0;
  let mut x738: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x737, &mut x738, x736, x720, x717);
  let mut x739: u32 = 0;
  let mut x740: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x739, &mut x740, x738, x718, x715);
  let mut x741: u32 = 0;
  let mut x742: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x741, &mut x742, x740, x716, x713);
  let mut x743: u32 = 0;
  let mut x744: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x743, &mut x744, 0x0, x695, x727);
  let mut x745: u32 = 0;
  let mut x746: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x745, &mut x746, x744, x697, x729);
  let mut x747: u32 = 0;
  let mut x748: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x747, &mut x748, x746, x699, x731);
  let mut x749: u32 = 0;
  let mut x750: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x749, &mut x750, x748, x701, x733);
  let mut x751: u32 = 0;
  let mut x752: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x751, &mut x752, x750, x703, x735);
  let mut x753: u32 = 0;
  let mut x754: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x753, &mut x754, x752, x705, x737);
  let mut x755: u32 = 0;
  let mut x756: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x755, &mut x756, x754, x707, x739);
  let mut x757: u32 = 0;
  let mut x758: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x757, &mut x758, x756, x709, x741);
  let mut x759: u32 = 0;
  let mut x760: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x759, &mut x760, x758, (((x710 as u32) + (x664 as u32)) + ((x694 as u32) + x666)), ((x742 as u32) + x714));
  let mut x761: u32 = 0;
  let mut x762: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x761, &mut x762, 0x0, x745, 0xd0364141);
  let mut x763: u32 = 0;
  let mut x764: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x763, &mut x764, x762, x747, 0xbfd25e8c);
  let mut x765: u32 = 0;
  let mut x766: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x765, &mut x766, x764, x749, 0xaf48a03b);
  let mut x767: u32 = 0;
  let mut x768: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x767, &mut x768, x766, x751, 0xbaaedce6);
  let mut x769: u32 = 0;
  let mut x770: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x769, &mut x770, x768, x753, 0xfffffffe);
  let mut x771: u32 = 0;
  let mut x772: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x771, &mut x772, x770, x755, 0xffffffff);
  let mut x773: u32 = 0;
  let mut x774: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x773, &mut x774, x772, x757, 0xffffffff);
  let mut x775: u32 = 0;
  let mut x776: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x775, &mut x776, x774, x759, 0xffffffff);
  let mut x777: u32 = 0;
  let mut x778: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x777, &mut x778, x776, (x760 as u32), (0x0 as u32));
  let mut x779: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x779, x778, x761, x745);
  let mut x780: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x780, x778, x763, x747);
  let mut x781: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x781, x778, x765, x749);
  let mut x782: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x782, x778, x767, x751);
  let mut x783: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x783, x778, x769, x753);
  let mut x784: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x784, x778, x771, x755);
  let mut x785: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x785, x778, x773, x757);
  let mut x786: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x786, x778, x775, x759);
  out1[0] = x779;
  out1[1] = x780;
  out1[2] = x781;
  out1[3] = x782;
  out1[4] = x783;
  out1[5] = x784;
  out1[6] = x785;
  out1[7] = x786;
}

/// The function fiat_secp256k1_montgomery_scalar_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_nonzero(out1: &mut u32, arg1: &[u32; 8]) {
  let x1: u32 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | (arg1[7]))))))));
  *out1 = x1;
}

/// The function fiat_secp256k1_montgomery_scalar_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_selectznz(out1: &mut [u32; 8], arg1: fiat_secp256k1_montgomery_scalar_u1, arg2: &[u32; 8], arg3: &[u32; 8]) {
  let mut x1: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x6, arg1, (arg2[5]), (arg3[5]));
  let mut x7: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x7, arg1, (arg2[6]), (arg3[6]));
  let mut x8: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x8, arg1, (arg2[7]), (arg3[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/// The function fiat_secp256k1_montgomery_scalar_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_to_bytes(out1: &mut [u8; 32], arg1: &[u32; 8]) {
  let x1: u32 = (arg1[7]);
  let x2: u32 = (arg1[6]);
  let x3: u32 = (arg1[5]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[3]);
  let x6: u32 = (arg1[2]);
  let x7: u32 = (arg1[1]);
  let x8: u32 = (arg1[0]);
  let x9: u8 = ((x8 & (0xff as u32)) as u8);
  let x10: u32 = (x8 >> 8);
  let x11: u8 = ((x10 & (0xff as u32)) as u8);
  let x12: u32 = (x10 >> 8);
  let x13: u8 = ((x12 & (0xff as u32)) as u8);
  let x14: u8 = ((x12 >> 8) as u8);
  let x15: u8 = ((x7 & (0xff as u32)) as u8);
  let x16: u32 = (x7 >> 8);
  let x17: u8 = ((x16 & (0xff as u32)) as u8);
  let x18: u32 = (x16 >> 8);
  let x19: u8 = ((x18 & (0xff as u32)) as u8);
  let x20: u8 = ((x18 >> 8) as u8);
  let x21: u8 = ((x6 & (0xff as u32)) as u8);
  let x22: u32 = (x6 >> 8);
  let x23: u8 = ((x22 & (0xff as u32)) as u8);
  let x24: u32 = (x22 >> 8);
  let x25: u8 = ((x24 & (0xff as u32)) as u8);
  let x26: u8 = ((x24 >> 8) as u8);
  let x27: u8 = ((x5 & (0xff as u32)) as u8);
  let x28: u32 = (x5 >> 8);
  let x29: u8 = ((x28 & (0xff as u32)) as u8);
  let x30: u32 = (x28 >> 8);
  let x31: u8 = ((x30 & (0xff as u32)) as u8);
  let x32: u8 = ((x30 >> 8) as u8);
  let x33: u8 = ((x4 & (0xff as u32)) as u8);
  let x34: u32 = (x4 >> 8);
  let x35: u8 = ((x34 & (0xff as u32)) as u8);
  let x36: u32 = (x34 >> 8);
  let x37: u8 = ((x36 & (0xff as u32)) as u8);
  let x38: u8 = ((x36 >> 8) as u8);
  let x39: u8 = ((x3 & (0xff as u32)) as u8);
  let x40: u32 = (x3 >> 8);
  let x41: u8 = ((x40 & (0xff as u32)) as u8);
  let x42: u32 = (x40 >> 8);
  let x43: u8 = ((x42 & (0xff as u32)) as u8);
  let x44: u8 = ((x42 >> 8) as u8);
  let x45: u8 = ((x2 & (0xff as u32)) as u8);
  let x46: u32 = (x2 >> 8);
  let x47: u8 = ((x46 & (0xff as u32)) as u8);
  let x48: u32 = (x46 >> 8);
  let x49: u8 = ((x48 & (0xff as u32)) as u8);
  let x50: u8 = ((x48 >> 8) as u8);
  let x51: u8 = ((x1 & (0xff as u32)) as u8);
  let x52: u32 = (x1 >> 8);
  let x53: u8 = ((x52 & (0xff as u32)) as u8);
  let x54: u32 = (x52 >> 8);
  let x55: u8 = ((x54 & (0xff as u32)) as u8);
  let x56: u8 = ((x54 >> 8) as u8);
  out1[0] = x9;
  out1[1] = x11;
  out1[2] = x13;
  out1[3] = x14;
  out1[4] = x15;
  out1[5] = x17;
  out1[6] = x19;
  out1[7] = x20;
  out1[8] = x21;
  out1[9] = x23;
  out1[10] = x25;
  out1[11] = x26;
  out1[12] = x27;
  out1[13] = x29;
  out1[14] = x31;
  out1[15] = x32;
  out1[16] = x33;
  out1[17] = x35;
  out1[18] = x37;
  out1[19] = x38;
  out1[20] = x39;
  out1[21] = x41;
  out1[22] = x43;
  out1[23] = x44;
  out1[24] = x45;
  out1[25] = x47;
  out1[26] = x49;
  out1[27] = x50;
  out1[28] = x51;
  out1[29] = x53;
  out1[30] = x55;
  out1[31] = x56;
}

/// The function fiat_secp256k1_montgomery_scalar_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_from_bytes(out1: &mut [u32; 8], arg1: &[u8; 32]) {
  let x1: u32 = (((arg1[31]) as u32) << 24);
  let x2: u32 = (((arg1[30]) as u32) << 16);
  let x3: u32 = (((arg1[29]) as u32) << 8);
  let x4: u8 = (arg1[28]);
  let x5: u32 = (((arg1[27]) as u32) << 24);
  let x6: u32 = (((arg1[26]) as u32) << 16);
  let x7: u32 = (((arg1[25]) as u32) << 8);
  let x8: u8 = (arg1[24]);
  let x9: u32 = (((arg1[23]) as u32) << 24);
  let x10: u32 = (((arg1[22]) as u32) << 16);
  let x11: u32 = (((arg1[21]) as u32) << 8);
  let x12: u8 = (arg1[20]);
  let x13: u32 = (((arg1[19]) as u32) << 24);
  let x14: u32 = (((arg1[18]) as u32) << 16);
  let x15: u32 = (((arg1[17]) as u32) << 8);
  let x16: u8 = (arg1[16]);
  let x17: u32 = (((arg1[15]) as u32) << 24);
  let x18: u32 = (((arg1[14]) as u32) << 16);
  let x19: u32 = (((arg1[13]) as u32) << 8);
  let x20: u8 = (arg1[12]);
  let x21: u32 = (((arg1[11]) as u32) << 24);
  let x22: u32 = (((arg1[10]) as u32) << 16);
  let x23: u32 = (((arg1[9]) as u32) << 8);
  let x24: u8 = (arg1[8]);
  let x25: u32 = (((arg1[7]) as u32) << 24);
  let x26: u32 = (((arg1[6]) as u32) << 16);
  let x27: u32 = (((arg1[5]) as u32) << 8);
  let x28: u8 = (arg1[4]);
  let x29: u32 = (((arg1[3]) as u32) << 24);
  let x30: u32 = (((arg1[2]) as u32) << 16);
  let x31: u32 = (((arg1[1]) as u32) << 8);
  let x32: u8 = (arg1[0]);
  let x33: u32 = (x31 + (x32 as u32));
  let x34: u32 = (x30 + x33);
  let x35: u32 = (x29 + x34);
  let x36: u32 = (x27 + (x28 as u32));
  let x37: u32 = (x26 + x36);
  let x38: u32 = (x25 + x37);
  let x39: u32 = (x23 + (x24 as u32));
  let x40: u32 = (x22 + x39);
  let x41: u32 = (x21 + x40);
  let x42: u32 = (x19 + (x20 as u32));
  let x43: u32 = (x18 + x42);
  let x44: u32 = (x17 + x43);
  let x45: u32 = (x15 + (x16 as u32));
  let x46: u32 = (x14 + x45);
  let x47: u32 = (x13 + x46);
  let x48: u32 = (x11 + (x12 as u32));
  let x49: u32 = (x10 + x48);
  let x50: u32 = (x9 + x49);
  let x51: u32 = (x7 + (x8 as u32));
  let x52: u32 = (x6 + x51);
  let x53: u32 = (x5 + x52);
  let x54: u32 = (x3 + (x4 as u32));
  let x55: u32 = (x2 + x54);
  let x56: u32 = (x1 + x55);
  out1[0] = x35;
  out1[1] = x38;
  out1[2] = x41;
  out1[3] = x44;
  out1[4] = x47;
  out1[5] = x50;
  out1[6] = x53;
  out1[7] = x56;
}

/// The function fiat_secp256k1_montgomery_scalar_set_one returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_set_one(out1: &mut fiat_secp256k1_montgomery_scalar_montgomery_domain_field_element) {
  out1[0] = 0x2fc9bebf;
  out1[1] = 0x402da173;
  out1[2] = 0x50b75fc4;
  out1[3] = 0x45512319;
  out1[4] = (0x1 as u32);
  out1[5] = (0x0 as u32);
  out1[6] = (0x0 as u32);
  out1[7] = (0x0 as u32);
}

/// The function fiat_secp256k1_montgomery_scalar_msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_msat(out1: &mut [u32; 9]) {
  out1[0] = 0xd0364141;
  out1[1] = 0xbfd25e8c;
  out1[2] = 0xaf48a03b;
  out1[3] = 0xbaaedce6;
  out1[4] = 0xfffffffe;
  out1[5] = 0xffffffff;
  out1[6] = 0xffffffff;
  out1[7] = 0xffffffff;
  out1[8] = (0x0 as u32);
}

/// The function fiat_secp256k1_montgomery_scalar_divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_divstep(out1: &mut u32, out2: &mut [u32; 9], out3: &mut [u32; 9], out4: &mut [u32; 8], out5: &mut [u32; 8], arg1: u32, arg2: &[u32; 9], arg3: &[u32; 9], arg4: &[u32; 8], arg5: &[u32; 8]) {
  let mut x1: u32 = 0;
  let mut x2: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x1, &mut x2, 0x0, (!arg1), (0x1 as u32));
  let x3: fiat_secp256k1_montgomery_scalar_u1 = (((x1 >> 31) as fiat_secp256k1_montgomery_scalar_u1) & (((arg3[0]) & (0x1 as u32)) as fiat_secp256k1_montgomery_scalar_u1));
  let mut x4: u32 = 0;
  let mut x5: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x4, &mut x5, 0x0, (!arg1), (0x1 as u32));
  let mut x6: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x6, x3, arg1, x4);
  let mut x7: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x7, x3, (arg2[0]), (arg3[0]));
  let mut x8: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x8, x3, (arg2[1]), (arg3[1]));
  let mut x9: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x9, x3, (arg2[2]), (arg3[2]));
  let mut x10: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x10, x3, (arg2[3]), (arg3[3]));
  let mut x11: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x11, x3, (arg2[4]), (arg3[4]));
  let mut x12: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x12, x3, (arg2[5]), (arg3[5]));
  let mut x13: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x13, x3, (arg2[6]), (arg3[6]));
  let mut x14: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x14, x3, (arg2[7]), (arg3[7]));
  let mut x15: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x15, x3, (arg2[8]), (arg3[8]));
  let mut x16: u32 = 0;
  let mut x17: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x16, &mut x17, 0x0, (0x1 as u32), (!(arg2[0])));
  let mut x18: u32 = 0;
  let mut x19: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x18, &mut x19, x17, (0x0 as u32), (!(arg2[1])));
  let mut x20: u32 = 0;
  let mut x21: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x20, &mut x21, x19, (0x0 as u32), (!(arg2[2])));
  let mut x22: u32 = 0;
  let mut x23: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x22, &mut x23, x21, (0x0 as u32), (!(arg2[3])));
  let mut x24: u32 = 0;
  let mut x25: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x24, &mut x25, x23, (0x0 as u32), (!(arg2[4])));
  let mut x26: u32 = 0;
  let mut x27: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x26, &mut x27, x25, (0x0 as u32), (!(arg2[5])));
  let mut x28: u32 = 0;
  let mut x29: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x28, &mut x29, x27, (0x0 as u32), (!(arg2[6])));
  let mut x30: u32 = 0;
  let mut x31: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x30, &mut x31, x29, (0x0 as u32), (!(arg2[7])));
  let mut x32: u32 = 0;
  let mut x33: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x32, &mut x33, x31, (0x0 as u32), (!(arg2[8])));
  let mut x34: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x34, x3, (arg3[0]), x16);
  let mut x35: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x35, x3, (arg3[1]), x18);
  let mut x36: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x36, x3, (arg3[2]), x20);
  let mut x37: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x37, x3, (arg3[3]), x22);
  let mut x38: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x38, x3, (arg3[4]), x24);
  let mut x39: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x39, x3, (arg3[5]), x26);
  let mut x40: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x40, x3, (arg3[6]), x28);
  let mut x41: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x41, x3, (arg3[7]), x30);
  let mut x42: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x42, x3, (arg3[8]), x32);
  let mut x43: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x43, x3, (arg4[0]), (arg5[0]));
  let mut x44: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x44, x3, (arg4[1]), (arg5[1]));
  let mut x45: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x45, x3, (arg4[2]), (arg5[2]));
  let mut x46: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x46, x3, (arg4[3]), (arg5[3]));
  let mut x47: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x47, x3, (arg4[4]), (arg5[4]));
  let mut x48: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x48, x3, (arg4[5]), (arg5[5]));
  let mut x49: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x49, x3, (arg4[6]), (arg5[6]));
  let mut x50: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x50, x3, (arg4[7]), (arg5[7]));
  let mut x51: u32 = 0;
  let mut x52: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x51, &mut x52, 0x0, x43, x43);
  let mut x53: u32 = 0;
  let mut x54: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x53, &mut x54, x52, x44, x44);
  let mut x55: u32 = 0;
  let mut x56: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x55, &mut x56, x54, x45, x45);
  let mut x57: u32 = 0;
  let mut x58: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x57, &mut x58, x56, x46, x46);
  let mut x59: u32 = 0;
  let mut x60: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x59, &mut x60, x58, x47, x47);
  let mut x61: u32 = 0;
  let mut x62: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x61, &mut x62, x60, x48, x48);
  let mut x63: u32 = 0;
  let mut x64: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x63, &mut x64, x62, x49, x49);
  let mut x65: u32 = 0;
  let mut x66: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x65, &mut x66, x64, x50, x50);
  let mut x67: u32 = 0;
  let mut x68: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x67, &mut x68, 0x0, x51, 0xd0364141);
  let mut x69: u32 = 0;
  let mut x70: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x69, &mut x70, x68, x53, 0xbfd25e8c);
  let mut x71: u32 = 0;
  let mut x72: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x71, &mut x72, x70, x55, 0xaf48a03b);
  let mut x73: u32 = 0;
  let mut x74: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x73, &mut x74, x72, x57, 0xbaaedce6);
  let mut x75: u32 = 0;
  let mut x76: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x75, &mut x76, x74, x59, 0xfffffffe);
  let mut x77: u32 = 0;
  let mut x78: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x77, &mut x78, x76, x61, 0xffffffff);
  let mut x79: u32 = 0;
  let mut x80: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x79, &mut x80, x78, x63, 0xffffffff);
  let mut x81: u32 = 0;
  let mut x82: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x81, &mut x82, x80, x65, 0xffffffff);
  let mut x83: u32 = 0;
  let mut x84: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x83, &mut x84, x82, (x66 as u32), (0x0 as u32));
  let x85: u32 = (arg4[7]);
  let x86: u32 = (arg4[6]);
  let x87: u32 = (arg4[5]);
  let x88: u32 = (arg4[4]);
  let x89: u32 = (arg4[3]);
  let x90: u32 = (arg4[2]);
  let x91: u32 = (arg4[1]);
  let x92: u32 = (arg4[0]);
  let mut x93: u32 = 0;
  let mut x94: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x93, &mut x94, 0x0, (0x0 as u32), x92);
  let mut x95: u32 = 0;
  let mut x96: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x95, &mut x96, x94, (0x0 as u32), x91);
  let mut x97: u32 = 0;
  let mut x98: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x97, &mut x98, x96, (0x0 as u32), x90);
  let mut x99: u32 = 0;
  let mut x100: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x99, &mut x100, x98, (0x0 as u32), x89);
  let mut x101: u32 = 0;
  let mut x102: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x101, &mut x102, x100, (0x0 as u32), x88);
  let mut x103: u32 = 0;
  let mut x104: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x103, &mut x104, x102, (0x0 as u32), x87);
  let mut x105: u32 = 0;
  let mut x106: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x105, &mut x106, x104, (0x0 as u32), x86);
  let mut x107: u32 = 0;
  let mut x108: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x107, &mut x108, x106, (0x0 as u32), x85);
  let mut x109: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x109, x108, (0x0 as u32), 0xffffffff);
  let mut x110: u32 = 0;
  let mut x111: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x110, &mut x111, 0x0, x93, (x109 & 0xd0364141));
  let mut x112: u32 = 0;
  let mut x113: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x112, &mut x113, x111, x95, (x109 & 0xbfd25e8c));
  let mut x114: u32 = 0;
  let mut x115: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x114, &mut x115, x113, x97, (x109 & 0xaf48a03b));
  let mut x116: u32 = 0;
  let mut x117: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x116, &mut x117, x115, x99, (x109 & 0xbaaedce6));
  let mut x118: u32 = 0;
  let mut x119: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x118, &mut x119, x117, x101, (x109 & 0xfffffffe));
  let mut x120: u32 = 0;
  let mut x121: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x120, &mut x121, x119, x103, x109);
  let mut x122: u32 = 0;
  let mut x123: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x122, &mut x123, x121, x105, x109);
  let mut x124: u32 = 0;
  let mut x125: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x124, &mut x125, x123, x107, x109);
  let mut x126: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x126, x3, (arg5[0]), x110);
  let mut x127: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x127, x3, (arg5[1]), x112);
  let mut x128: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x128, x3, (arg5[2]), x114);
  let mut x129: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x129, x3, (arg5[3]), x116);
  let mut x130: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x130, x3, (arg5[4]), x118);
  let mut x131: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x131, x3, (arg5[5]), x120);
  let mut x132: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x132, x3, (arg5[6]), x122);
  let mut x133: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x133, x3, (arg5[7]), x124);
  let x134: fiat_secp256k1_montgomery_scalar_u1 = ((x34 & (0x1 as u32)) as fiat_secp256k1_montgomery_scalar_u1);
  let mut x135: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x135, x134, (0x0 as u32), x7);
  let mut x136: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x136, x134, (0x0 as u32), x8);
  let mut x137: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x137, x134, (0x0 as u32), x9);
  let mut x138: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x138, x134, (0x0 as u32), x10);
  let mut x139: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x139, x134, (0x0 as u32), x11);
  let mut x140: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x140, x134, (0x0 as u32), x12);
  let mut x141: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x141, x134, (0x0 as u32), x13);
  let mut x142: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x142, x134, (0x0 as u32), x14);
  let mut x143: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x143, x134, (0x0 as u32), x15);
  let mut x144: u32 = 0;
  let mut x145: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x144, &mut x145, 0x0, x34, x135);
  let mut x146: u32 = 0;
  let mut x147: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x146, &mut x147, x145, x35, x136);
  let mut x148: u32 = 0;
  let mut x149: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x148, &mut x149, x147, x36, x137);
  let mut x150: u32 = 0;
  let mut x151: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x150, &mut x151, x149, x37, x138);
  let mut x152: u32 = 0;
  let mut x153: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x152, &mut x153, x151, x38, x139);
  let mut x154: u32 = 0;
  let mut x155: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x154, &mut x155, x153, x39, x140);
  let mut x156: u32 = 0;
  let mut x157: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x156, &mut x157, x155, x40, x141);
  let mut x158: u32 = 0;
  let mut x159: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x158, &mut x159, x157, x41, x142);
  let mut x160: u32 = 0;
  let mut x161: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x160, &mut x161, x159, x42, x143);
  let mut x162: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x162, x134, (0x0 as u32), x43);
  let mut x163: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x163, x134, (0x0 as u32), x44);
  let mut x164: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x164, x134, (0x0 as u32), x45);
  let mut x165: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x165, x134, (0x0 as u32), x46);
  let mut x166: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x166, x134, (0x0 as u32), x47);
  let mut x167: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x167, x134, (0x0 as u32), x48);
  let mut x168: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x168, x134, (0x0 as u32), x49);
  let mut x169: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x169, x134, (0x0 as u32), x50);
  let mut x170: u32 = 0;
  let mut x171: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x170, &mut x171, 0x0, x126, x162);
  let mut x172: u32 = 0;
  let mut x173: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x172, &mut x173, x171, x127, x163);
  let mut x174: u32 = 0;
  let mut x175: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x174, &mut x175, x173, x128, x164);
  let mut x176: u32 = 0;
  let mut x177: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x176, &mut x177, x175, x129, x165);
  let mut x178: u32 = 0;
  let mut x179: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x178, &mut x179, x177, x130, x166);
  let mut x180: u32 = 0;
  let mut x181: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x180, &mut x181, x179, x131, x167);
  let mut x182: u32 = 0;
  let mut x183: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x182, &mut x183, x181, x132, x168);
  let mut x184: u32 = 0;
  let mut x185: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x184, &mut x185, x183, x133, x169);
  let mut x186: u32 = 0;
  let mut x187: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x186, &mut x187, 0x0, x170, 0xd0364141);
  let mut x188: u32 = 0;
  let mut x189: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x188, &mut x189, x187, x172, 0xbfd25e8c);
  let mut x190: u32 = 0;
  let mut x191: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x190, &mut x191, x189, x174, 0xaf48a03b);
  let mut x192: u32 = 0;
  let mut x193: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x192, &mut x193, x191, x176, 0xbaaedce6);
  let mut x194: u32 = 0;
  let mut x195: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x194, &mut x195, x193, x178, 0xfffffffe);
  let mut x196: u32 = 0;
  let mut x197: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x196, &mut x197, x195, x180, 0xffffffff);
  let mut x198: u32 = 0;
  let mut x199: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x198, &mut x199, x197, x182, 0xffffffff);
  let mut x200: u32 = 0;
  let mut x201: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x200, &mut x201, x199, x184, 0xffffffff);
  let mut x202: u32 = 0;
  let mut x203: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_subborrowx_u32(&mut x202, &mut x203, x201, (x185 as u32), (0x0 as u32));
  let mut x204: u32 = 0;
  let mut x205: fiat_secp256k1_montgomery_scalar_u1 = 0;
  fiat_secp256k1_montgomery_scalar_addcarryx_u32(&mut x204, &mut x205, 0x0, x6, (0x1 as u32));
  let x206: u32 = ((x144 >> 1) | ((x146 << 31) & 0xffffffff));
  let x207: u32 = ((x146 >> 1) | ((x148 << 31) & 0xffffffff));
  let x208: u32 = ((x148 >> 1) | ((x150 << 31) & 0xffffffff));
  let x209: u32 = ((x150 >> 1) | ((x152 << 31) & 0xffffffff));
  let x210: u32 = ((x152 >> 1) | ((x154 << 31) & 0xffffffff));
  let x211: u32 = ((x154 >> 1) | ((x156 << 31) & 0xffffffff));
  let x212: u32 = ((x156 >> 1) | ((x158 << 31) & 0xffffffff));
  let x213: u32 = ((x158 >> 1) | ((x160 << 31) & 0xffffffff));
  let x214: u32 = ((x160 & 0x80000000) | (x160 >> 1));
  let mut x215: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x215, x84, x67, x51);
  let mut x216: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x216, x84, x69, x53);
  let mut x217: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x217, x84, x71, x55);
  let mut x218: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x218, x84, x73, x57);
  let mut x219: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x219, x84, x75, x59);
  let mut x220: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x220, x84, x77, x61);
  let mut x221: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x221, x84, x79, x63);
  let mut x222: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x222, x84, x81, x65);
  let mut x223: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x223, x203, x186, x170);
  let mut x224: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x224, x203, x188, x172);
  let mut x225: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x225, x203, x190, x174);
  let mut x226: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x226, x203, x192, x176);
  let mut x227: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x227, x203, x194, x178);
  let mut x228: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x228, x203, x196, x180);
  let mut x229: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x229, x203, x198, x182);
  let mut x230: u32 = 0;
  fiat_secp256k1_montgomery_scalar_cmovznz_u32(&mut x230, x203, x200, x184);
  *out1 = x204;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out2[5] = x12;
  out2[6] = x13;
  out2[7] = x14;
  out2[8] = x15;
  out3[0] = x206;
  out3[1] = x207;
  out3[2] = x208;
  out3[3] = x209;
  out3[4] = x210;
  out3[5] = x211;
  out3[6] = x212;
  out3[7] = x213;
  out3[8] = x214;
  out4[0] = x215;
  out4[1] = x216;
  out4[2] = x217;
  out4[3] = x218;
  out4[4] = x219;
  out4[5] = x220;
  out4[6] = x221;
  out4[7] = x222;
  out5[0] = x223;
  out5[1] = x224;
  out5[2] = x225;
  out5[3] = x226;
  out5[4] = x227;
  out5[5] = x228;
  out5[6] = x229;
  out5[7] = x230;
}

/// The function fiat_secp256k1_montgomery_scalar_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_secp256k1_montgomery_scalar_divstep_precomp(out1: &mut [u32; 8]) {
  out1[0] = 0x2b9cb4e9;
  out1[1] = 0xd7431a4d;
  out1[2] = 0x32d9c503;
  out1[3] = 0xab67d35a;
  out1[4] = 0x859ce35f;
  out1[5] = 0xadf6c7e5;
  out1[6] = 0x1df6c379;
  out1[7] = 0x61544145;
}
