// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: google/protobuf/api.proto

package types

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Api is a light-weight descriptor for an API Interface.
//
// Interfaces are also described as "protocol buffer services" in some contexts,
// such as by the "service" keyword in a .proto file, but they are different
// from API Services, which represent a concrete implementation of an interface
// as opposed to simply a description of methods and bindings. They are also
// sometimes simply referred to as "APIs" in other contexts, such as the name of
// this message itself. See https://cloud.google.com/apis/design/glossary for
// detailed terminology.
type Api struct {
	// The fully qualified name of this interface, including package name
	// followed by the interface's simple name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The methods of this interface, in unspecified order.
	Methods []*Method `protobuf:"bytes,2,rep,name=methods" json:"methods,omitempty"`
	// Any metadata attached to the interface.
	Options []*Option `protobuf:"bytes,3,rep,name=options" json:"options,omitempty"`
	// A version string for this interface. If specified, must have the form
	// `major-version.minor-version`, as in `1.10`. If the minor version is
	// omitted, it defaults to zero. If the entire version field is empty, the
	// major version is derived from the package name, as outlined below. If the
	// field is not empty, the version in the package name will be verified to be
	// consistent with what is provided here.
	//
	// The versioning schema uses [semantic
	// versioning](http://semver.org) where the major version number
	// indicates a breaking change and the minor version an additive,
	// non-breaking change. Both version numbers are signals to users
	// what to expect from different versions, and should be carefully
	// chosen based on the product plan.
	//
	// The major version is also reflected in the package name of the
	// interface, which must end in `v<major-version>`, as in
	// `google.feature.v1`. For major versions 0 and 1, the suffix can
	// be omitted. Zero major versions must only be used for
	// experimental, non-GA interfaces.
	//
	//
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Source context for the protocol buffer service represented by this
	// message.
	SourceContext *SourceContext `protobuf:"bytes,5,opt,name=source_context,json=sourceContext" json:"source_context,omitempty"`
	// Included interfaces. See [Mixin][].
	Mixins []*Mixin `protobuf:"bytes,6,rep,name=mixins" json:"mixins,omitempty"`
	// The source syntax of the service.
	Syntax Syntax `protobuf:"varint,7,opt,name=syntax,proto3,enum=google.protobuf.Syntax" json:"syntax,omitempty"`
}

func (m *Api) Reset()                    { *m = Api{} }
func (*Api) ProtoMessage()               {}
func (*Api) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

func (m *Api) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Api) GetMethods() []*Method {
	if m != nil {
		return m.Methods
	}
	return nil
}

func (m *Api) GetOptions() []*Option {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *Api) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Api) GetSourceContext() *SourceContext {
	if m != nil {
		return m.SourceContext
	}
	return nil
}

func (m *Api) GetMixins() []*Mixin {
	if m != nil {
		return m.Mixins
	}
	return nil
}

func (m *Api) GetSyntax() Syntax {
	if m != nil {
		return m.Syntax
	}
	return SYNTAX_PROTO2
}

func (*Api) XXX_MessageName() string {
	return "google.protobuf.Api"
}

// Method represents a method of an API interface.
type Method struct {
	// The simple name of this method.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A URL of the input message type.
	RequestTypeUrl string `protobuf:"bytes,2,opt,name=request_type_url,json=requestTypeUrl,proto3" json:"request_type_url,omitempty"`
	// If true, the request is streamed.
	RequestStreaming bool `protobuf:"varint,3,opt,name=request_streaming,json=requestStreaming,proto3" json:"request_streaming,omitempty"`
	// The URL of the output message type.
	ResponseTypeUrl string `protobuf:"bytes,4,opt,name=response_type_url,json=responseTypeUrl,proto3" json:"response_type_url,omitempty"`
	// If true, the response is streamed.
	ResponseStreaming bool `protobuf:"varint,5,opt,name=response_streaming,json=responseStreaming,proto3" json:"response_streaming,omitempty"`
	// Any metadata attached to the method.
	Options []*Option `protobuf:"bytes,6,rep,name=options" json:"options,omitempty"`
	// The source syntax of this method.
	Syntax Syntax `protobuf:"varint,7,opt,name=syntax,proto3,enum=google.protobuf.Syntax" json:"syntax,omitempty"`
}

func (m *Method) Reset()                    { *m = Method{} }
func (*Method) ProtoMessage()               {}
func (*Method) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

func (m *Method) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Method) GetRequestTypeUrl() string {
	if m != nil {
		return m.RequestTypeUrl
	}
	return ""
}

func (m *Method) GetRequestStreaming() bool {
	if m != nil {
		return m.RequestStreaming
	}
	return false
}

func (m *Method) GetResponseTypeUrl() string {
	if m != nil {
		return m.ResponseTypeUrl
	}
	return ""
}

func (m *Method) GetResponseStreaming() bool {
	if m != nil {
		return m.ResponseStreaming
	}
	return false
}

func (m *Method) GetOptions() []*Option {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *Method) GetSyntax() Syntax {
	if m != nil {
		return m.Syntax
	}
	return SYNTAX_PROTO2
}

func (*Method) XXX_MessageName() string {
	return "google.protobuf.Method"
}

// Declares an API Interface to be included in this interface. The including
// interface must redeclare all the methods from the included interface, but
// documentation and options are inherited as follows:
//
// - If after comment and whitespace stripping, the documentation
//   string of the redeclared method is empty, it will be inherited
//   from the original method.
//
// - Each annotation belonging to the service config (http,
//   visibility) which is not set in the redeclared method will be
//   inherited.
//
// - If an http annotation is inherited, the path pattern will be
//   modified as follows. Any version prefix will be replaced by the
//   version of the including interface plus the [root][] path if
//   specified.
//
// Example of a simple mixin:
//
//     package google.acl.v1;
//     service AccessControl {
//       // Get the underlying ACL object.
//       rpc GetAcl(GetAclRequest) returns (Acl) {
//         option (google.api.http).get = "/v1/{resource=**}:getAcl";
//       }
//     }
//
//     package google.storage.v2;
//     service Storage {
//       rpc GetAcl(GetAclRequest) returns (Acl);
//
//       // Get a data record.
//       rpc GetData(GetDataRequest) returns (Data) {
//         option (google.api.http).get = "/v2/{resource=**}";
//       }
//     }
//
// Example of a mixin configuration:
//
//     apis:
//     - name: google.storage.v2.Storage
//       mixins:
//       - name: google.acl.v1.AccessControl
//
// The mixin construct implies that all methods in `AccessControl` are
// also declared with same name and request/response types in
// `Storage`. A documentation generator or annotation processor will
// see the effective `Storage.GetAcl` method after inherting
// documentation and annotations as follows:
//
//     service Storage {
//       // Get the underlying ACL object.
//       rpc GetAcl(GetAclRequest) returns (Acl) {
//         option (google.api.http).get = "/v2/{resource=**}:getAcl";
//       }
//       ...
//     }
//
// Note how the version in the path pattern changed from `v1` to `v2`.
//
// If the `root` field in the mixin is specified, it should be a
// relative path under which inherited HTTP paths are placed. Example:
//
//     apis:
//     - name: google.storage.v2.Storage
//       mixins:
//       - name: google.acl.v1.AccessControl
//         root: acls
//
// This implies the following inherited HTTP annotation:
//
//     service Storage {
//       // Get the underlying ACL object.
//       rpc GetAcl(GetAclRequest) returns (Acl) {
//         option (google.api.http).get = "/v2/acls/{resource=**}:getAcl";
//       }
//       ...
//     }
type Mixin struct {
	// The fully qualified name of the interface which is included.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If non-empty specifies a path under which inherited HTTP paths
	// are rooted.
	Root string `protobuf:"bytes,2,opt,name=root,proto3" json:"root,omitempty"`
}

func (m *Mixin) Reset()                    { *m = Mixin{} }
func (*Mixin) ProtoMessage()               {}
func (*Mixin) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

func (m *Mixin) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Mixin) GetRoot() string {
	if m != nil {
		return m.Root
	}
	return ""
}

func (*Mixin) XXX_MessageName() string {
	return "google.protobuf.Mixin"
}
func init() {
	proto.RegisterType((*Api)(nil), "google.protobuf.Api")
	proto.RegisterType((*Method)(nil), "google.protobuf.Method")
	proto.RegisterType((*Mixin)(nil), "google.protobuf.Mixin")
}
func (this *Api) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*Api)
	if !ok {
		that2, ok := that.(Api)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if this.Name != that1.Name {
		if this.Name < that1.Name {
			return -1
		}
		return 1
	}
	if len(this.Methods) != len(that1.Methods) {
		if len(this.Methods) < len(that1.Methods) {
			return -1
		}
		return 1
	}
	for i := range this.Methods {
		if c := this.Methods[i].Compare(that1.Methods[i]); c != 0 {
			return c
		}
	}
	if len(this.Options) != len(that1.Options) {
		if len(this.Options) < len(that1.Options) {
			return -1
		}
		return 1
	}
	for i := range this.Options {
		if c := this.Options[i].Compare(that1.Options[i]); c != 0 {
			return c
		}
	}
	if this.Version != that1.Version {
		if this.Version < that1.Version {
			return -1
		}
		return 1
	}
	if c := this.SourceContext.Compare(that1.SourceContext); c != 0 {
		return c
	}
	if len(this.Mixins) != len(that1.Mixins) {
		if len(this.Mixins) < len(that1.Mixins) {
			return -1
		}
		return 1
	}
	for i := range this.Mixins {
		if c := this.Mixins[i].Compare(that1.Mixins[i]); c != 0 {
			return c
		}
	}
	if this.Syntax != that1.Syntax {
		if this.Syntax < that1.Syntax {
			return -1
		}
		return 1
	}
	return 0
}
func (this *Method) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*Method)
	if !ok {
		that2, ok := that.(Method)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if this.Name != that1.Name {
		if this.Name < that1.Name {
			return -1
		}
		return 1
	}
	if this.RequestTypeUrl != that1.RequestTypeUrl {
		if this.RequestTypeUrl < that1.RequestTypeUrl {
			return -1
		}
		return 1
	}
	if this.RequestStreaming != that1.RequestStreaming {
		if !this.RequestStreaming {
			return -1
		}
		return 1
	}
	if this.ResponseTypeUrl != that1.ResponseTypeUrl {
		if this.ResponseTypeUrl < that1.ResponseTypeUrl {
			return -1
		}
		return 1
	}
	if this.ResponseStreaming != that1.ResponseStreaming {
		if !this.ResponseStreaming {
			return -1
		}
		return 1
	}
	if len(this.Options) != len(that1.Options) {
		if len(this.Options) < len(that1.Options) {
			return -1
		}
		return 1
	}
	for i := range this.Options {
		if c := this.Options[i].Compare(that1.Options[i]); c != 0 {
			return c
		}
	}
	if this.Syntax != that1.Syntax {
		if this.Syntax < that1.Syntax {
			return -1
		}
		return 1
	}
	return 0
}
func (this *Mixin) Compare(that interface{}) int {
	if that == nil {
		if this == nil {
			return 0
		}
		return 1
	}

	that1, ok := that.(*Mixin)
	if !ok {
		that2, ok := that.(Mixin)
		if ok {
			that1 = &that2
		} else {
			return 1
		}
	}
	if that1 == nil {
		if this == nil {
			return 0
		}
		return 1
	} else if this == nil {
		return -1
	}
	if this.Name != that1.Name {
		if this.Name < that1.Name {
			return -1
		}
		return 1
	}
	if this.Root != that1.Root {
		if this.Root < that1.Root {
			return -1
		}
		return 1
	}
	return 0
}
func (this *Api) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Api)
	if !ok {
		that2, ok := that.(Api)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.Methods) != len(that1.Methods) {
		return false
	}
	for i := range this.Methods {
		if !this.Methods[i].Equal(that1.Methods[i]) {
			return false
		}
	}
	if len(this.Options) != len(that1.Options) {
		return false
	}
	for i := range this.Options {
		if !this.Options[i].Equal(that1.Options[i]) {
			return false
		}
	}
	if this.Version != that1.Version {
		return false
	}
	if !this.SourceContext.Equal(that1.SourceContext) {
		return false
	}
	if len(this.Mixins) != len(that1.Mixins) {
		return false
	}
	for i := range this.Mixins {
		if !this.Mixins[i].Equal(that1.Mixins[i]) {
			return false
		}
	}
	if this.Syntax != that1.Syntax {
		return false
	}
	return true
}
func (this *Method) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Method)
	if !ok {
		that2, ok := that.(Method)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.RequestTypeUrl != that1.RequestTypeUrl {
		return false
	}
	if this.RequestStreaming != that1.RequestStreaming {
		return false
	}
	if this.ResponseTypeUrl != that1.ResponseTypeUrl {
		return false
	}
	if this.ResponseStreaming != that1.ResponseStreaming {
		return false
	}
	if len(this.Options) != len(that1.Options) {
		return false
	}
	for i := range this.Options {
		if !this.Options[i].Equal(that1.Options[i]) {
			return false
		}
	}
	if this.Syntax != that1.Syntax {
		return false
	}
	return true
}
func (this *Mixin) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Mixin)
	if !ok {
		that2, ok := that.(Mixin)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Root != that1.Root {
		return false
	}
	return true
}
func (this *Api) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&types.Api{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Methods != nil {
		s = append(s, "Methods: "+fmt.Sprintf("%#v", this.Methods)+",\n")
	}
	if this.Options != nil {
		s = append(s, "Options: "+fmt.Sprintf("%#v", this.Options)+",\n")
	}
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	if this.SourceContext != nil {
		s = append(s, "SourceContext: "+fmt.Sprintf("%#v", this.SourceContext)+",\n")
	}
	if this.Mixins != nil {
		s = append(s, "Mixins: "+fmt.Sprintf("%#v", this.Mixins)+",\n")
	}
	s = append(s, "Syntax: "+fmt.Sprintf("%#v", this.Syntax)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Method) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&types.Method{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "RequestTypeUrl: "+fmt.Sprintf("%#v", this.RequestTypeUrl)+",\n")
	s = append(s, "RequestStreaming: "+fmt.Sprintf("%#v", this.RequestStreaming)+",\n")
	s = append(s, "ResponseTypeUrl: "+fmt.Sprintf("%#v", this.ResponseTypeUrl)+",\n")
	s = append(s, "ResponseStreaming: "+fmt.Sprintf("%#v", this.ResponseStreaming)+",\n")
	if this.Options != nil {
		s = append(s, "Options: "+fmt.Sprintf("%#v", this.Options)+",\n")
	}
	s = append(s, "Syntax: "+fmt.Sprintf("%#v", this.Syntax)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Mixin) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&types.Mixin{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Root: "+fmt.Sprintf("%#v", this.Root)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringApi(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Api) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Api) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Methods) > 0 {
		for _, msg := range m.Methods {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Options) > 0 {
		for _, msg := range m.Options {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	if m.SourceContext != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.SourceContext.Size()))
		n1, err := m.SourceContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.Mixins) > 0 {
		for _, msg := range m.Mixins {
			dAtA[i] = 0x32
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Syntax != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Syntax))
	}
	return i, nil
}

func (m *Method) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Method) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.RequestTypeUrl) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.RequestTypeUrl)))
		i += copy(dAtA[i:], m.RequestTypeUrl)
	}
	if m.RequestStreaming {
		dAtA[i] = 0x18
		i++
		if m.RequestStreaming {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.ResponseTypeUrl) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.ResponseTypeUrl)))
		i += copy(dAtA[i:], m.ResponseTypeUrl)
	}
	if m.ResponseStreaming {
		dAtA[i] = 0x28
		i++
		if m.ResponseStreaming {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Options) > 0 {
		for _, msg := range m.Options {
			dAtA[i] = 0x32
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Syntax != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Syntax))
	}
	return i, nil
}

func (m *Mixin) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mixin) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Root) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Root)))
		i += copy(dAtA[i:], m.Root)
	}
	return i, nil
}

func encodeVarintApi(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedApi(r randyApi, easy bool) *Api {
	this := &Api{}
	this.Name = string(randStringApi(r))
	if r.Intn(10) != 0 {
		v1 := r.Intn(5)
		this.Methods = make([]*Method, v1)
		for i := 0; i < v1; i++ {
			this.Methods[i] = NewPopulatedMethod(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v2 := r.Intn(5)
		this.Options = make([]*Option, v2)
		for i := 0; i < v2; i++ {
			this.Options[i] = NewPopulatedOption(r, easy)
		}
	}
	this.Version = string(randStringApi(r))
	if r.Intn(10) != 0 {
		this.SourceContext = NewPopulatedSourceContext(r, easy)
	}
	if r.Intn(10) != 0 {
		v3 := r.Intn(5)
		this.Mixins = make([]*Mixin, v3)
		for i := 0; i < v3; i++ {
			this.Mixins[i] = NewPopulatedMixin(r, easy)
		}
	}
	this.Syntax = Syntax([]int32{0, 1}[r.Intn(2)])
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedMethod(r randyApi, easy bool) *Method {
	this := &Method{}
	this.Name = string(randStringApi(r))
	this.RequestTypeUrl = string(randStringApi(r))
	this.RequestStreaming = bool(bool(r.Intn(2) == 0))
	this.ResponseTypeUrl = string(randStringApi(r))
	this.ResponseStreaming = bool(bool(r.Intn(2) == 0))
	if r.Intn(10) != 0 {
		v4 := r.Intn(5)
		this.Options = make([]*Option, v4)
		for i := 0; i < v4; i++ {
			this.Options[i] = NewPopulatedOption(r, easy)
		}
	}
	this.Syntax = Syntax([]int32{0, 1}[r.Intn(2)])
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedMixin(r randyApi, easy bool) *Mixin {
	this := &Mixin{}
	this.Name = string(randStringApi(r))
	this.Root = string(randStringApi(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyApi interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneApi(r randyApi) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringApi(r randyApi) string {
	v5 := r.Intn(100)
	tmps := make([]rune, v5)
	for i := 0; i < v5; i++ {
		tmps[i] = randUTF8RuneApi(r)
	}
	return string(tmps)
}
func randUnrecognizedApi(r randyApi, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldApi(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldApi(dAtA []byte, r randyApi, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateApi(dAtA, uint64(key))
		v6 := r.Int63()
		if r.Intn(2) == 0 {
			v6 *= -1
		}
		dAtA = encodeVarintPopulateApi(dAtA, uint64(v6))
	case 1:
		dAtA = encodeVarintPopulateApi(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateApi(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateApi(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateApi(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateApi(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Api) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Methods) > 0 {
		for _, e := range m.Methods {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.Options) > 0 {
		for _, e := range m.Options {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.SourceContext != nil {
		l = m.SourceContext.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Mixins) > 0 {
		for _, e := range m.Mixins {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.Syntax != 0 {
		n += 1 + sovApi(uint64(m.Syntax))
	}
	return n
}

func (m *Method) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.RequestTypeUrl)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.RequestStreaming {
		n += 2
	}
	l = len(m.ResponseTypeUrl)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ResponseStreaming {
		n += 2
	}
	if len(m.Options) > 0 {
		for _, e := range m.Options {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.Syntax != 0 {
		n += 1 + sovApi(uint64(m.Syntax))
	}
	return n
}

func (m *Mixin) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Root)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func sovApi(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozApi(x uint64) (n int) {
	return sovApi(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Api) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Api{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Methods:` + strings.Replace(fmt.Sprintf("%v", this.Methods), "Method", "Method", 1) + `,`,
		`Options:` + strings.Replace(fmt.Sprintf("%v", this.Options), "Option", "Option", 1) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`SourceContext:` + strings.Replace(fmt.Sprintf("%v", this.SourceContext), "SourceContext", "SourceContext", 1) + `,`,
		`Mixins:` + strings.Replace(fmt.Sprintf("%v", this.Mixins), "Mixin", "Mixin", 1) + `,`,
		`Syntax:` + fmt.Sprintf("%v", this.Syntax) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Method) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Method{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`RequestTypeUrl:` + fmt.Sprintf("%v", this.RequestTypeUrl) + `,`,
		`RequestStreaming:` + fmt.Sprintf("%v", this.RequestStreaming) + `,`,
		`ResponseTypeUrl:` + fmt.Sprintf("%v", this.ResponseTypeUrl) + `,`,
		`ResponseStreaming:` + fmt.Sprintf("%v", this.ResponseStreaming) + `,`,
		`Options:` + strings.Replace(fmt.Sprintf("%v", this.Options), "Option", "Option", 1) + `,`,
		`Syntax:` + fmt.Sprintf("%v", this.Syntax) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mixin) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Mixin{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Root:` + fmt.Sprintf("%v", this.Root) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringApi(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Api) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Api: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Api: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Methods", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Methods = append(m.Methods, &Method{})
			if err := m.Methods[len(m.Methods)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = append(m.Options, &Option{})
			if err := m.Options[len(m.Options)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceContext == nil {
				m.SourceContext = &SourceContext{}
			}
			if err := m.SourceContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mixins", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mixins = append(m.Mixins, &Mixin{})
			if err := m.Mixins[len(m.Mixins)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Syntax", wireType)
			}
			m.Syntax = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Syntax |= (Syntax(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Method) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Method: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Method: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestTypeUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestTypeUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestStreaming", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestStreaming = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseTypeUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseTypeUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseStreaming", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ResponseStreaming = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = append(m.Options, &Option{})
			if err := m.Options[len(m.Options)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Syntax", wireType)
			}
			m.Syntax = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Syntax |= (Syntax(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mixin) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mixin: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mixin: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Root", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Root = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipApi(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowApi
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthApi
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowApi
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipApi(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthApi = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowApi   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("google/protobuf/api.proto", fileDescriptorApi) }

var fileDescriptorApi = []byte{
	// 472 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x91, 0x31, 0x6f, 0x13, 0x31,
	0x14, 0xc7, 0xf3, 0xee, 0x92, 0x4b, 0x71, 0x45, 0x0a, 0x46, 0x02, 0x93, 0xc1, 0x3a, 0x55, 0x0c,
	0x27, 0x10, 0x17, 0x51, 0x3e, 0x41, 0x83, 0x50, 0x07, 0x84, 0x88, 0x2e, 0x20, 0x24, 0x96, 0x28,
	0x0d, 0x26, 0x9c, 0x74, 0x67, 0x1f, 0xb6, 0x03, 0xc9, 0x86, 0xc4, 0x37, 0x61, 0x42, 0x8c, 0x7c,
	0x03, 0xb6, 0x8e, 0x1d, 0x19, 0xc9, 0x75, 0x61, 0xec, 0xc8, 0x88, 0xec, 0x3b, 0x37, 0x25, 0x0d,
	0x12, 0xdd, 0xfc, 0xde, 0xff, 0xe7, 0xbf, 0xdf, 0xfb, 0x1b, 0xdd, 0x9e, 0x0a, 0x31, 0xcd, 0x58,
	0xaf, 0x90, 0x42, 0x8b, 0xc3, 0xd9, 0x9b, 0xde, 0xb8, 0x48, 0x63, 0x5b, 0xe0, 0x9d, 0x4a, 0x8a,
	0x9d, 0xd4, 0xbd, 0xb3, 0xce, 0x2a, 0x31, 0x93, 0x13, 0x36, 0x9a, 0x08, 0xae, 0xd9, 0x5c, 0x57,
	0x60, 0xb7, 0xbb, 0x4e, 0xe9, 0x45, 0x51, 0x9b, 0xec, 0x7e, 0xf7, 0x90, 0xbf, 0x5f, 0xa4, 0x18,
	0xa3, 0x26, 0x1f, 0xe7, 0x8c, 0x40, 0x08, 0xd1, 0x95, 0xc4, 0x9e, 0xf1, 0x03, 0xd4, 0xce, 0x99,
	0x7e, 0x2b, 0x5e, 0x2b, 0xe2, 0x85, 0x7e, 0xb4, 0xbd, 0x77, 0x2b, 0x5e, 0x1b, 0x20, 0x7e, 0x6a,
	0xf5, 0xc4, 0x71, 0xe6, 0x8a, 0x28, 0x74, 0x2a, 0xb8, 0x22, 0xfe, 0x3f, 0xae, 0x3c, 0xb3, 0x7a,
	0xe2, 0x38, 0x4c, 0x50, 0xfb, 0x3d, 0x93, 0x2a, 0x15, 0x9c, 0x34, 0xed, 0xe3, 0xae, 0xc4, 0x8f,
	0x51, 0xe7, 0xef, 0x7d, 0x48, 0x2b, 0x84, 0x68, 0x7b, 0x8f, 0x5e, 0xf0, 0x1c, 0x5a, 0xec, 0x51,
	0x45, 0x25, 0x57, 0xd5, 0xf9, 0x12, 0xc7, 0x28, 0xc8, 0xd3, 0x79, 0xca, 0x15, 0x09, 0xec, 0x48,
	0x37, 0x2f, 0x6e, 0x61, 0xe4, 0xa4, 0xa6, 0x70, 0x0f, 0x05, 0x6a, 0xc1, 0xf5, 0x78, 0x4e, 0xda,
	0x21, 0x44, 0x9d, 0x0d, 0x2b, 0x0c, 0xad, 0x9c, 0xd4, 0xd8, 0xee, 0x37, 0x0f, 0x05, 0x55, 0x10,
	0x1b, 0x63, 0x8c, 0xd0, 0x35, 0xc9, 0xde, 0xcd, 0x98, 0xd2, 0x23, 0x13, 0xfc, 0x68, 0x26, 0x33,
	0xe2, 0x59, 0xbd, 0x53, 0xf7, 0x9f, 0x2f, 0x0a, 0xf6, 0x42, 0x66, 0xf8, 0x1e, 0xba, 0xee, 0x48,
	0xa5, 0x25, 0x1b, 0xe7, 0x29, 0x9f, 0x12, 0x3f, 0x84, 0x68, 0x2b, 0x71, 0x16, 0x43, 0xd7, 0xc7,
	0x77, 0x0d, 0xac, 0x0a, 0xc1, 0x15, 0x5b, 0xf9, 0x56, 0x09, 0xee, 0x38, 0xc1, 0x19, 0xdf, 0x47,
	0xf8, 0x8c, 0x5d, 0x39, 0xb7, 0xac, 0xf3, 0x99, 0xcb, 0xca, 0xfa, 0xdc, 0x2f, 0x06, 0xff, 0xf9,
	0x8b, 0x97, 0x0e, 0xad, 0x87, 0x5a, 0x36, 0xf6, 0x8d, 0x91, 0x61, 0xd4, 0x94, 0x42, 0xe8, 0x3a,
	0x26, 0x7b, 0xee, 0x7f, 0x82, 0xe3, 0x25, 0x6d, 0xfc, 0x58, 0xd2, 0xc6, 0xe9, 0x92, 0xc2, 0xef,
	0x25, 0x85, 0x8f, 0x25, 0x85, 0x2f, 0x25, 0x85, 0xa3, 0x92, 0xc2, 0x71, 0x49, 0xe1, 0x67, 0x49,
	0xe1, 0x57, 0x49, 0x1b, 0xa7, 0xa6, 0x7f, 0x42, 0xe1, 0xe8, 0x84, 0x02, 0xba, 0x31, 0x11, 0xf9,
	0xfa, 0x2c, 0xfd, 0xad, 0xfd, 0x22, 0x1d, 0x98, 0x62, 0x00, 0xaf, 0x5a, 0x26, 0x3c, 0xf5, 0xd9,
	0xf3, 0x0f, 0x06, 0xfd, 0xaf, 0x1e, 0x3d, 0xa8, 0xd0, 0x81, 0x1b, 0xfb, 0x25, 0xcb, 0xb2, 0x27,
	0x5c, 0x7c, 0xe0, 0x26, 0x4b, 0x75, 0x18, 0x58, 0x8f, 0x87, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff,
	0x20, 0x4e, 0x03, 0x8e, 0xa6, 0x03, 0x00, 0x00,
}
