/* ----------------------------------------------------------------

SmillaEnlarger  -  resize, especially magnify bitmaps in high quality
    selectField.h: the select-widget within the EnlargerDialog

Copyright (C) 2009 Mischa Lusteck

This program is free software;
you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <http://www.gnu.org/licenses/>.

---------------------------------------------------------------------- */

#ifndef SELECTFIELD_H
#define SELECTFIELD_H

#include <QWidget>

const float MAXHEIGHT = 400.0;
const float MAXWIDTH  = 400.0;

class QImage;

class SelectField : public QWidget {
    Q_OBJECT
    Q_PROPERTY( QImage theImage READ theImage WRITE setTheImage)

private:
    QImage myImage;
    float zoom;
    float sX,sY;             // pos of topleft in image
    float imageW,  imageH;   // imagesize
    float selectW, selectH;  // selectSize
    QRect  selectBox;
    QSize  mySize;

    // shown part of the sourceImage
    float baseClipX0, baseClipY0,baseClipX1,baseClipY1;

    // for moving select-box
    bool  selectMoveMode;   // what to to at mouse-move
    float grabX,grabY;      // point in selectBox where it was grabbed

    // for clipping-select
    float clipX0,clipY0,clipX1,clipY1;

    // instead of drawing the source image into the field, which may be slow for big sizes,
    // use a screenImage, into which the needed clip of the source is drawn once at every clipping-change
    QImage screenImage;

public:
    SelectField( QWidget *parent=0 );
    ~SelectField( void );
    void setTheImage( const QImage & newImage );
    QImage theImage( void ) const { return myImage; }
    QSize sizeHint( void ) const;
    QSize minimumSizeHint( void ) const;
    void setSelectSize( float sW, float sH );
    void setClipRect( float cx0, float cy0, float cx1, float cy1 );
    void GetMarkedClipRect ( float & cx0, float & cy0, float & cx1, float & cy1 ) {
        cx0 = clipX0; cy0 = clipY0; cx1 = clipX1; cy1 = clipY1;
    }

signals:
    void selectionChanged( float x, float y );
    void clippingChanged ( float cx0, float cy0, float cx1, float cy1 );

 public slots:
    void moveSelection( float x, float y );   // try to move selectBox within image

protected:
    void mousePressEvent( QMouseEvent *event );
    void mouseMoveEvent( QMouseEvent *event );
    void mouseReleaseEvent( QMouseEvent *event );
    void paintEvent( QPaintEvent *event );

private:
    void UpdateSizeAndZoom( void ); // for myImage calculate zoom,size to fit into MAX-W,H
    void UpdateSelectBox( void );   // recalculate and draw selectBox ( after change of sX,sY,... )
    void CorrectSelect( void );     // check, if selection out of bounds, correct it if necessary
    void UpdateScreenImage( void ); // for changed souce or clipping: redraw screenImage

    // transform pos in widget to pos in srcImage
    float SrcX( int screenX ) { return float(screenX)/zoom  + baseClipX0; }
    float SrcY( int screenY ) { return float(screenY)/zoom  + baseClipY0; }
    // transform pos in srcImage to pos in widget
    int ScreenX( float x ) { return int( ( x - baseClipX0 )*zoom ); }
    int ScreenY( float y ) { return int( ( y - baseClipY0 )*zoom ); }
};

#endif // SELECTFIELD_H
