/* ----------------------------------------------------------------

SmillaEnlarger  -  resize, especially magnify bitmaps in high quality
    Array4D.h: 2-dim. vector4-array

Copyright (C) 2009 Mischa Lusteck

This program is free software;
you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <http://www.gnu.org/licenses/>.

---------------------------------------------------------------------- */

#ifndef ARRAY_4D_H
#define ARRAY_4D_H

#include "PointClass.h"
#include "ArraysTemplate.h"

using namespace std;
class ArrayARGB;

class MyArray4D : public BasicArray<Point4> {

public:
   MyArray4D(void) : BasicArray<Point4> () {}
   MyArray4D(int sx,int sy) : BasicArray<Point4> (sx,sy) {}

   MyArray4D *SmoothDouble(void)
      { return (MyArray4D *) BasicArray<Point4>::SmoothDouble(); }
   MyArray4D *ShrinkHalf(void)
      { return (MyArray4D *) BasicArray<Point4>::ShrinkHalf(); }
   MyArray4D *Shrink(int sizeXNew, int sizeYNew)
      { return (MyArray4D *) BasicArray<Point4>::Shrink(sizeXNew,sizeYNew); }
   MyArray4D *BlockyPixEnlarge(int sizeXNew, int sizeYNew)
      { return (MyArray4D *) BasicArray<Point4>::BlockyPixEnlarge(sizeXNew,sizeYNew); }
   MyArray4D *SplitLowFreq(int lenExp)
      { return (MyArray4D *) BasicArray<Point4>::SplitLowFreq(lenExp); }
   MyArray4D *Smooth(void)
      { return (MyArray4D *) BasicArray<Point4>::Smooth(); }
   MyArray4D *Clip(int leftX,int topY,int sizeXNew, int sizeYNew)
      { return (MyArray4D *) BasicArray<Point4>::Clip(leftX, topY, sizeXNew,  sizeYNew); }

   void CopyFromArray(ArrayARGB *srcArr, int srcX,int srcY);
};


// ArrayARGB is only a wrapper around existing data, e.g. a buffer or a QImage
// by destruction of the array, the data are not deleted
/*
typedef unsigned long uint32;
class ArrayARGB {

   int sizeX,sizeY;
    uint32 **rowBuf;              // list of pointers to rows
public:
   ArrayARGB(int sx,int sy, uint32 *buf);
   ArrayARGB(int sx,int sy, uint32 **bufList);
   ArrayARGB( ArrayARGB  & aSrc);
   ~ArrayARGB(void) { delete[] rowBuf; }

   uint32 GetU(int x, int y) const     { return rowBuf[ y ][ x ]; }
   void   Set(int x, int y, uint32 p ) { rowBuf[ y ][ x ] =  p; }
   Point4 Get(int x, int y) const      { return toPoint4( rowBuf[ y ][ x ] ); }
   void   Set(int x, int y, const Point4 & p ) { rowBuf[ y ][ x ] =  toARGB(p); }

   int SizeX(void) const { return sizeX; }
   int SizeY(void) const { return sizeY; }

   void CopyFromArray(const ArrayARGB & srcArr, int srcX,int srcY);
   void CopyFromArray(const MyArray4D & srcArr, int srcX,int srcY);
   void CopyToArray(BasicArray< Point4 > *dstArr, int srcX,int srcY);

   void Clip(int leftX,int topY, ArrayARGB & clipArr ) {
      clipArr.CopyFromArray( *this, leftX,topY);
   }

   void ShrinkClip(int sizeXNew, int sizeYNew, int dstX0, int dstY0, ArrayARGB *dst );
   inline Point4 toPoint4( uint32 a ) const;
   inline uint32 toARGB  ( const Point4 & p ) const;

private:
   void ShrinkLineClip(int y, float scaleX, int dstX0, int dstX1, Point4 *line);

};

inline Point4 ArrayARGB::toPoint4( uint32 a ) const {
    Point4 p;
    p.z = float(a&255)*(1.0/255.0);  a>>=8;
    p.y = float(a&255)*(1.0/255.0);  a>>=8;
    p.x = float(a&255)*(1.0/255.0);  a>>=8;
    p.w = float(a&255)*(1.0/255.0);
    return p;
}

inline uint32 ArrayARGB::toARGB  ( const Point4 & p ) const {
    uint32 a=0;
    a += uint32( p.w * 255.0 )&255; a<<=8;
    a += uint32( p.x * 255.0 )&255; a<<=8;
    a += uint32( p.y * 255.0 )&255; a<<=8;
    a += uint32( p.z * 255.0 )&255;
    return a;
}
*/
#endif
