/* ----------------------------------------------------------------

SmillaEnlarger  -  resize, especially magnify bitmaps in high quality
    EnlargerDialog.h: the Qt Dialog

Copyright (C) 2009 Mischa Lusteck

This program is free software;
you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <http://www.gnu.org/licenses/>.

---------------------------------------------------------------------- */

#ifndef ENLARGERDIALOG_H
#define ENLARGERDIALOG_H

#include <QtGui/QMainWindow>
#include <QDir>
#include "ImageEnlargerCode/FractTab.h"
#include "ImageEnlargerCode/EnlargeParam.h"

class QMimeData;
class QSettings;
class EnlargerThread;
class CalcQueue;

enum DialogMode { noEnlarge, previewEnlarge, fullEnlarge };

// when changing image format, what should stay constant: newWidth, newHeight or zoomFact ?
enum ZoomUpdateMode { useWidth, useHeight, useWidthAndHeight, useZoom };


namespace Ui
{
    class EnlargerDialog;
}

class EnlargerDialog : public QMainWindow
{
   Q_OBJECT
private:
   Ui::EnlargerDialog *ui;
   EnlargerThread *previewThread;
   DialogMode currentDialogMode;
   QString calcResultName;     // memorize the absolute path of result at start of calc.
   QString calcSrc, calcDst;   // filename of src, dst of current calc

   QDir srcDir, dstDir;
   QString currentSrcName;
   QString currentSrcPath;

   // used part of the sourceImage
   float baseClipX0, baseClipY0,baseClipX1,baseClipY1;

   // for managing the various zoom-setting-possibilities
   float zoomFact;
   float aspectX,aspectY;  // zoomX = zoomFact*aspectX, zoomY = zoomFact*aspectY, aspectX*aspectY=1.0
   bool  freeAspectRatio;  // aspect ratio mode: true allows aspect ratio changes
   int zoomInt;
   int newWidth,newHeight;
   int srcWidth,srcHeight;
   ZoomUpdateMode zoomUpdateMod;

   bool setZoom_recursionBlocker;     // avoid indirect self-calls of setZoom via diverse value-changes

    // history for clipping-undo
   float *historyClipX0, *historyClipY0;
   float *historyClipX1, *historyClipY1;
   int historyClipIdx;

   // Storing and retrieving Settings ( enlarging parameters )
   QSettings *theSettings;

   // List of Enlarge-Parameter-Settings ( names in ui->paramCOmbo )
   QList< EnlargeParamInt > paramSetVal;
   int currentParamIdx;

   // the calculation queue
   CalcQueue *theCalcQueue;

   // mini mode action
   QAction *miniModeA;


public:
   EnlargerDialog(QWidget *parent = 0);
   ~EnlargerDialog();
   bool TryOpenSource( QString fileName );
   void ZoomUseWidth ( void );
   void ZoomUseHeight( void );
   void ZoomUseWidthAndHeight( void );
   void ZoomUseZoom  ( void );
   float ZoomX( void ) { return aspectX * zoomFact; }
   float ZoomY( void ) { return aspectY * zoomFact; }
   int  AddParamSet( const QString & name, const EnlargeParamInt & p );

public slots:
   void SetNewWidth ( int v );
   void SetNewHeight( int v );
   void SetZoomInt  ( int v );
   void DoPreview( void );

protected:
   void closeEvent( QCloseEvent *event );
   void dragEnterEvent( QDragEnterEvent *event );
   void dropEvent( QDropEvent *event );

private slots:
   void slot_load1( void );
   void slot_load2( void );
   void slot_comboChanged( const QString & txt );
   void slot_checkBoxChanged( int state );
   void slot_queueCalc( void );
   void slot_showPreview( const QImage & result );
   void slot_showPreviewProgress( int val );
   void slot_paste( void );
   void stopPreview( void );
   void slot_applyClipping( void );
   void slot_setClipping( float cx0, float cy0, float cx1, float cy1 );
   void slot_resetClipping( void );
   void slot_ShowHelp( void );
   void InfoMessage( void );
   void HelpMessageMore( void );
   void BadAllocMessage( const QString & dstName );
   void slot_AddParam( void );
   void slot_DelParam( void );
   void slot_ParamCheckBoxChanged( int state );
   void slot_SetParamSlidersFromCombo( int idx );
   void slot_ShowJobCount( int endedJobs, int totalJobs );
   void slot_MessageToLog( const QString & message );
   void slot_QueueRemoveSelected( void );
   void slot_QueueClear( void );
   void slot_QueueRemoveEnded( void );
   void slot_ZoomRadioButton( void );
   void slot_WidthRadioButton( void );
   void slot_HeightRadioButton( void );
   void slot_MiniMode( bool b);

private:
   void MenuBarSetup( void );

   void ReadSettings( void );
   void WriteSettings( void );
   QString FindSettingsFile( void );

   void UpdateZoom( void ); // change zoom at format change, according to zoomUpdateMode
   void SetZoom( float zoomF );
   void ChangeAspectRatio( int dstWidth, int dstHeight );
   void ResetDialog( void );
   void SetSource(const  QImage & src );
   void CenterSelectBox( void );
   void ReadParameters( EnlargeParamInt & param );
   void FillComboBox( void );
   void SourceFromMimeData( const QMimeData *mimeData ); // for dropping, clipboard-paste
   void SetSourceDir( const QString & srcName );
   void SetDestDir( const QString & dstName );
   bool FileExistsMessage( const QString & fileName, const QString & dirName );
   bool AbortCalcMessage( int unfinishedJobs  );
   void AdjustDestName( void );
   void IncDestName( QString & dstName , const QDir & dDir );
   bool GetPaths( QString filePath, QString & srcPath, QString & dstPath, bool & isDir ); // check and modify filePath
   void ClippingHistoryUndo( void );
   void ClippingHistoryAdd( void );
   void ClippingHistoryClear( void );
   void SetToolTip( QWidget *widget, const QString & text );
   void SetToolTip( QWidget *w1,  QWidget *w2, const QString & text );
   void PrintStatusText( QString statusText );

 //int  AddParamSet( const QString & name, const EnlargeParamInt & p ); now public
   void DelParamSet( int idx );
   void ChangeParamSet( int idx, const EnlargeParamInt & p );
   void GetParamSliders( EnlargeParamInt & p );
   void SetParamSliders( const EnlargeParamInt & p );

   void BatchAutomaticOpen( QString filePath );
   void BatchAddJob( const QString & srcPath,  const QString & dstPath, const QString & dstName );
   void BatchProcessDir( const QString & srcPath,  const QString & dstPath );
};

#endif // ENLARGERDIALOG_H
