/*
 * Copyright (C) 2005-2006 Ruslan Popov <radz@yandex.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _CRTBRT_H
#define _CRTBRT_H 1

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <kino/image_filters.h>
#include <kino/kino_extra.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

class CrtBrtPlugin : public GDKImageFilter
{
 public:
  CrtBrtPlugin();
  ~CrtBrtPlugin();

  char *GetDescription( ) const;
  void FilterFrame( uint8_t *pixels, int width, int height,
		    double position, double delta_frame );
  void AttachWidgets( GtkBin *bin );
  void DetachWidgets( GtkBin *bin );
  void InterpretWidgets( GtkBin *bin );

  void ResetValues( void ) const;
  void Spin2Scale( const gchar * spinname, const gchar * scalename ) const;
  void Scale2Spin( const gchar * scalename, const gchar * spinname ) const;

 private:
  GladeXML * glade;
  GtkWidget * plugin_window;
  int bright;
  int contrast;

  uint8_t transform[256]; // transformation table

  void buildTransform( char brightness, char contrast );
};

#endif
