#!/bin/bash

if [ -f configure.in ]; then
    NAME=`grep AM_INIT_AUTOMAKE configure.in | sed 's/.*MAKE(\(.*\),.*/\1/'`
    echo "Plugin name is $NAME"
    sed 's/config\.h)/config\.h)\n\nAM_DISABLE_STATIC\nAC_PROG_CXX\nAM_PROG_LIBTOOL/' configure.in \
	> configure.in.kino
fi

if [ -f src/Makefile.am ]; then
    cat src/Makefile.am | \
	sed 's/file\.in/file\.in\n\nKINO_INCLUDE = $(prefix)\/include\/kino\nlibdir = $(prefix)\/lib\/kino/' | \
	sed 's/INCLUDES = \\/INCLUDES = $(GNOME_INCLUDEDIR) -I$(KINO_INCLUDE) \\/' | \
	sed "s/bin_PROGRAMS.*/lib_LTLIBRARIES = lib${NAME}plugin.la/" | \
 	sed "s/.*_SOURCES/lib${NAME}plugin_la_SOURCES/" | \
	sed "s/.*_LDADD.*/lib${NAME}plugin_la_LIBADD = \$(GNOME_LIBDIR) \$(GNOMEUI_LIBS)/" \
	> src/Makefile.am.kino
fi

exit
