#!/bin/bash

ERREXIT() {
    echo $1; exit 1
}

INSTALL() {
    mkdir -p $DESTDIR/$1 || ERREXIT "mkdir $DESTDIR/$1"
    cp $1/*.* $DESTDIR/$1/ || ERREXIT "cp $1/*.* $DESTDIR/$1/"
    chmod 644 $DESTDIR/$1/*.* || ERREXIT "chmod 644 $DESTDIR/$1/*.*"
}

if [ ! -z $1 ];then
  DESTDIR=$1/share/ffDiaporama/background 
else
  DESTDIR=/usr/share/ffDiaporama/background
fi

if [[ ! -d $DESTDIR ]];then
  ERREXIT "ffDiaporama must be installed before to install ffDiaporama-texturemate"
fi

DESTDIR=$DESTDIR/texturemate
mkdir $DESTDIR || ERREXIT "You must have administrator privilege to install ffDiaporama-texturemate"

echo "Install ffDiaporama-texturemate to $DESTDIR"

cp readme.txt $DESTDIR/readme.txt || ERREXIT "readme.txt"
chmod 644 $DESTDIR/readme.txt

INSTALL Asphalt
INSTALL Brick
INSTALL Cement
INSTALL Clay
INSTALL Clouds
INSTALL Cobblestone
INSTALL Digital
INSTALL Fabric
INSTALL Glass
INSTALL Granite
INSTALL Metal
INSTALL Paint
INSTALL Paper
INSTALL Plants
INSTALL Wall
INSTALL Wood

