/*

Copyright (C) 2009, Etienne Moutot <e.moutot@gmail.com>

This file is part of colorPickerWidget.

    colorPickerWidget is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    colorPickerWidget is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with colorPickerWidget.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <QtGui>
#include "colorpickerwidget.h"

ColorPickerWidget::ColorPickerWidget(QWidget *parent)
    : QWidget(parent)
{
    this->setGeometry(0,0,parent->width(),parent->height());
    ecran=0;
    colorTriangle = new QtColorTriangle(this);
    connect(colorTriangle, SIGNAL(colorChanged(QColor)), this, SLOT(changeColor(QColor)));

    action_copier = new QAction(tr("Copier la couleur"), this);
    action_copier->setIcon ( QIcon(":/Interface/Interface/copy.png") );
    action_coller = new QAction(tr("Coller la couleur"), this);
    action_coller->setIcon ( QIcon(":/Interface/Interface/paste.png") );

    action_entervalue = new QAction(tr("Saisir une valeur de couleur"), this);
    action_entervalue->setIcon ( QIcon(":/Interface/Interface/color.png") );

    connect(action_copier, SIGNAL(triggered()), this, SLOT(f_copier()));
    connect(action_coller, SIGNAL(triggered()), this, SLOT(f_coller()));
    connect(action_entervalue, SIGNAL(triggered()), this, SLOT(f_entervalue()));

    //this->setGeometry(0,0,150,150);

    /*colorView = new ColorViewer(this);
    colorView->setColor(colorTriangle->color());
        connect(colorTriangle, SIGNAL(colorChanged(QColor)), colorView, SLOT(changeColor(QColor)));

    pickColor = new QPushButton(tr("Pick a color"), this);
        connect(pickColor, SIGNAL(released()), this, SLOT(pickMode()));*/

    //layout = new QGridLayout;
    //layout->addWidget(  colorTriangle,  0, 0, 0, 0);
    //layout->addWidget(  colorView,      0, 2, 2, 1);
    //layout->addWidget(  pickColor,      2, 2, 1, 1);

    //setLayout(layout);
}

ColorPickerWidget::~ColorPickerWidget()
{
}

void ColorPickerWidget::f_entervalue()
{
    bool ok;

    QString wl_tmpr = QString("%1").arg(red, 0, 16); //QString::number(red);

    if ( wl_tmpr.length() < 2 )
    {
        wl_tmpr = "0" + wl_tmpr;
    }

    QString wl_tmpg = QString("%1").arg(green, 0, 16); //QString::number(red);

    if ( wl_tmpg.length() < 2 )
    {
        wl_tmpg = "0" + wl_tmpg;
    }

    QString wl_tmpb = QString("%1").arg(blue, 0, 16); //QString::number(red);

    if ( wl_tmpb.length() < 2 )
    {
        wl_tmpb = "0" + wl_tmpb;
    }

    //QByteArray result(qPrintable(wl_tmpr));

    //qDebug() << wl_tmpr; //QString("%1").arg(red, 0, 16) + QString("%1").arg(green, 0, 16) + QString("%1").arg(blue, 0, 16);

    QString text = QInputDialog::getText(this, "", tr("Entrez la valeur hexadécimal de la couleur (FFFFFF)"), QLineEdit::Normal,wl_tmpr + wl_tmpg + wl_tmpb,&ok);
    if (ok && !text.isEmpty())
    {
        if ( text.length() == 6 )
        {
            QString tmpv;

            tmpv = text.mid(0,2);
            red = tmpv.toULong(&ok,16);
            tmpv = text.mid(2,2);
            green = tmpv.toULong(&ok,16);
            tmpv = text.mid(4,2);
            blue = tmpv.toULong(&ok,16);
            setColor(red,green,blue);
        }
        else
        {
            QMessageBox::information(this, "", tr("Le code couleur n est pas valide. Il doit être sous la forme RRVVBB."));
        }
    }
}

void ColorPickerWidget::f_copier()
{
    emit copier(this);
}

void ColorPickerWidget::f_coller()
{
    emit coller(this);
}

void ColorPickerWidget::changeColor(QColor mycol)
{
	red = mycol.red();
	green = mycol.green();
	blue = mycol.blue();
	emit finchange();
}

void ColorPickerWidget::setColor(int wlred, int wlgreen, int wlblue)
{
	colorTriangle->setColor(QColor(wlred,wlgreen,wlblue));
	red = wlred;
	green = wlgreen;
	blue = wlblue;
}

void ColorPickerWidget::contextMenuEvent(QContextMenuEvent *event)
{
    QMenu menu(this);
    menu.addAction(action_copier);
    menu.addAction(action_coller);
    menu.addSeparator();
    menu.addAction(action_entervalue);
    menu.exec(event->globalPos());
}

void ColorPickerWidget::pickMode()
{
    if(ecran!=0)
        delete ecran;
    ecran = new screen;
        connect( ecran, SIGNAL(colorSelected(QColor)), colorTriangle, SLOT(setColor(QColor)) );
}
