
/**
 * @file userSettings.cpp
 *
 * @section LICENSE
 *
 * This file is part of receptiongreet.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *  @date 20.Aug 2011
 *  @author Pascal Audoux
 */

#include "userSettings.h"

// Qt
#include <QSettings>


bool userSettings::getDisplayOption( DisplayOptionType option )
{
    switch( option ) {
    case DISPLAY_RULE:
        return QSettings().value("display/rule", false ).toBool();
    case DISPLAY_COORD:
        return QSettings().value("display/coord", false ).toBool();
    case DISPLAY_ZONE:
        return QSettings().value("display/zone", true ).toBool();
    case DISPLAY_SHAPE:
        return QSettings().value("display/shape", false ).toBool();
    default :
        return false;

    }
}

void userSettings::setDisplayOption( DisplayOptionType option, bool state )
{
    switch( option ) {
    case DISPLAY_RULE:
        QSettings().setValue("display/rule", state );
        break;
    case DISPLAY_COORD:
        QSettings().setValue("display/coord", state );
        break;
    case DISPLAY_ZONE:
        QSettings().setValue("display/zone", state );
        break;
    case DISPLAY_SHAPE:
        QSettings().setValue("display/shape", state );
        break;
    default :
        return;
    }
}

/*void userSettings::setOtherOption( DisplayOptionType option, QString state )
{
    switch( option ) {
    case LAST_RENDER:
        QSettings().setValue("last/render", state );
        break;
    default :
        return;
    }
}*/

