/* ============================================================
 * File  : toolbar_bt4.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "toolbar_bt4.h"

toolbar_bt4::toolbar_bt4 ( QWidget * parent )
    : QPushButton(parent)
{
    this->setAttribute(Qt::WA_DeleteOnClose);
    this->setAttribute(Qt::WA_TranslucentBackground, true);
    x=0;
    is_over = 0;

    myfont.setPixelSize ( 10 );
    myfont.setBold(false);
}

void toolbar_bt4::enterEvent ( QEvent * )
{
    if ( x == 0 )
    {
        x = this->geometry().x();
        y = this->geometry().y();
        w = this->width();
        h = this->height();
    }
    is_over = 1;
}

void toolbar_bt4::leaveEvent ( QEvent * )
{
    is_over = 0;
}

void toolbar_bt4::mousePressEvent(QMouseEvent *)
{
    chgdir(this);
}

void toolbar_bt4::f_show()
{
    QPropertyAnimation *animation = new QPropertyAnimation(this, "geometry");
    animation->setDuration(250);
    animation->setStartValue(QRect(this->geometry().x(),this->geometry().y(),this->width(),this->height()));
    animation->setEndValue(QRect(this->geometry().x(),this->geometry().y()-30,this->width(),this->height()));
    animation->setEasingCurve(QEasingCurve::InOutCubic);
    animation->start();
}

void toolbar_bt4::f_delete(int timedelete)
{
    QPropertyAnimation *animation = new QPropertyAnimation(this, "geometry");
    connect(animation,SIGNAL(finished()),this,SLOT(f_end_delete()));
    animation->setDuration(250+timedelete);
    animation->setStartValue(QRect(this->geometry().x(),this->geometry().y(),this->width(),this->height()));
    animation->setEndValue(QRect(this->geometry().x(),this->geometry().y()+30,this->width(),this->height()));
    animation->setEasingCurve(QEasingCurve::InOutCubic);
    animation->start();
}

void toolbar_bt4::f_end_delete()
{
    this->close();
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void toolbar_bt4::paintEvent(QPaintEvent *)
{
    QPainter p;
    p.begin(this);

    if ( is_over == 0 )
    {
        p.drawPixmap(this->width()-50,0,QPixmap(":/Interface/Interface/pathbar1.png"));
    }
    else
    {
        p.drawPixmap(this->width()-50,0,QPixmap(":/Interface/Interface/pathbar2.png"));
    }

    p.setFont(myfont);
    p.drawText(QRect(0,0,this->width(),this->height()),Qt::AlignVCenter,this->text());
    p.end();
}

