/* ============================================================
 * File  : toolbar_bt3.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "toolbar_bt3.h"

toolbar_bt3::toolbar_bt3 ( QWidget * parent )
    : QPushButton(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        this->setAttribute(Qt::WA_TranslucentBackground, true);
        x=0;
}

void toolbar_bt3::enterEvent ( QEvent * )
{
        if ( x == 0 )
        {
            x = this->geometry().x();
            y = this->geometry().y();
            w = this->width();
            h = this->height();
        }

        if ( this->isEnabled() == true )
        {
            QPropertyAnimation *animation = new QPropertyAnimation(this, "geometry");
            animation->setDuration(150);
            animation->setStartValue(QRect(x,y,w,h));
            animation->setEndValue(QRect(this->geometry().x()-2,this->geometry().y()-2,this->width()+4,this->height()+4));
            animation->setEasingCurve(QEasingCurve::InOutBack);
            animation->start();
        }
}

void toolbar_bt3::leaveEvent ( QEvent * )
{
        if ( this->isEnabled() == true )
        {
            QPropertyAnimation *animation = new QPropertyAnimation(this, "geometry");
            animation->setDuration(150);
            animation->setStartValue(QRect(this->geometry().x(),this->geometry().y(),this->width(),this->height()));
            animation->setEndValue(QRect(x,y,w,h));
            animation->setEasingCurve(QEasingCurve::InOutBack);
            animation->start();
        }
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void toolbar_bt3::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);

        if ( this->isEnabled() == true )
        {
            if ( this->isChecked() == true )
            {
                p.drawPixmap(0,0,QPixmap(":/Interface/Interface/" + this->text().mid(2,this->text().length()-2) + "2.png").scaled(this->width(),this->height()));
            }
            else
            {
                p.drawPixmap(0,0,QPixmap(":/Interface/Interface/" + this->text().mid(2,this->text().length()-2) + ".png").scaled(this->width(),this->height()));
            }
        }
        else
        {
            p.drawPixmap(0,0,QPixmap(":/Interface/Interface/" + this->text().mid(2,this->text().length()-2) + "3.png").scaled(this->width(),this->height()));
        }
	p.end();
}

