/* ============================================================
 * File  : thptra.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include "thptra.h"
 
thptra::thptra()
{
	this->setTerminationEnabled(true);
        srcImage.load(":/Interface/Interface/reload.png");
        srcImage2.load(":/Interface/Interface/reload.png");
	srcImage3.load(":/Interface/Interface/reload.png");
	dstImage.load(":/Interface/Interface/reload.png");

        srcImage = srcImage.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );
        srcImage2 = srcImage2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );
	srcImage3 = srcImage3.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );
	dstImage = dstImage.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );
}

void thptra::run()
{
	if ( type_trans == 0 ) // *** Transitions par luma ***
	{
		if ( srcImage3.width() <= 0 || srcImage3.height() <= 0 )
		{
			emit myfin();
			return;
		}

		lumavalue = (float)((float)255/(float)100)*(float)sequence;

		if ( lumavalue >= 0 )
		{
			mycolor.setRed(lumavalue);
			mycolor.setGreen(lumavalue);
			mycolor.setBlue(lumavalue);
		}
		else
		{
			mycolor.setRed(0);
			mycolor.setGreen(0);
			mycolor.setBlue(0);
		}

		if ( invert == "0" )
		{
                        if ( mycolor.red() <= 215 )
                        {
                            mycolor2.setRed(mycolor.red()+40);
                            mycolor2.setGreen(mycolor.red()+40);
                            mycolor2.setBlue(mycolor.red()+40);
                        }
                        else
                        {
                            mycolor2.setRed(255);
                            mycolor2.setGreen(255);
                            mycolor2.setBlue(255);
                        }
		}
		else
		{
                        if ( mycolor.red() >= 40 )
                        {
                            mycolor2.setRed(mycolor.red()-40);
                            mycolor2.setGreen(mycolor.red()-40);
                            mycolor2.setBlue(mycolor.red()-40);
                        }
                        else
                        {
                            mycolor2.setRed(0);
                            mycolor2.setGreen(0);
                            mycolor2.setBlue(0);
                        }
		}

                QRgb *ltrt1 = reinterpret_cast<QRgb *>(srcImage.scanLine(0));
                QRgb *ltrt2 = reinterpret_cast<QRgb *>(srcImage2.scanLine(0));
                //QRgb *ltrt3 = reinterpret_cast<QRgb *>(srcImage3.scanLine(0));

		for (y = 0; y < srcImage.height(); y++)
		{
                        ltrt1 = reinterpret_cast<QRgb *>(srcImage.scanLine(y));
                        ltrt2 = reinterpret_cast<QRgb *>(srcImage2.scanLine(y));
                        //ltrt3 = reinterpret_cast<QRgb *>(srcImage3.scanLine(y));

			for (x = 0; x < srcImage.width(); x++) 
			{
                                srcPixel = ltrt1[x];
                                srcPixel2 = ltrt2[x];
                                srcPixel3 = srcImage3.pixel(x, y);

				tmpcolor1 = srcPixel;
				tmpcolor2 = srcPixel2;
				tmpcolor3 = srcPixel3;

				if ( invert == "0" )
				{
                                        if ( tmpcolor3.value() > mycolor.value() )
                                        {
                                                if ( tmpcolor3.value() <= mycolor2.value() )
                                                {
                                                        valuefade = 255-(float)((float)(tmpcolor3.value()-mycolor.value())*255)/(float)(mycolor2.value()-mycolor.value()); //(float)255+(((float)tmpcolor3.value()/(float)2.5)-((float)mycolor2.value()/(float)2.5))*(float)20;

                                                        tmpcolor3.setRed(tmpcolor1.red() * (1-(float)((float)valuefade/(float)255)) + tmpcolor2.red() * (float)((float)valuefade/(float)255));
                                                        tmpcolor3.setGreen(tmpcolor1.green() * (1-(float)((float)valuefade/(float)255)) + tmpcolor2.green() * (float)((float)valuefade/(float)255));
                                                        tmpcolor3.setBlue(tmpcolor1.blue() * (1-(float)((float)valuefade/(float)255)) + tmpcolor2.blue() * (float)((float)valuefade/(float)255));
                                                        dstPixel = tmpcolor3.rgb();
                                                        dstImage.setPixel(x, y, dstPixel);
                                                }
						else
						{
                                                        dstImage.setPixel(x, y, srcPixel);
                                                }
                                        }
					else
					{
                                                dstImage.setPixel(x, y, srcPixel2);
                                        }
				}
				else
				{
                                        if ( tmpcolor3.value() < mycolor.value() )
                                        {
                                                if ( tmpcolor3.value() >= mycolor2.value() )
                                                {
                                                        valuefade = 255-(float)((float)(mycolor.value()-tmpcolor3.value())*255)/(float)(mycolor.value()-mycolor2.value());

                                                        tmpcolor3.setRed(tmpcolor1.red() * (1-(float)((float)valuefade/(float)255)) + tmpcolor2.red() * (float)((float)valuefade/(float)255));
                                                        tmpcolor3.setGreen(tmpcolor1.green() * (1-(float)((float)valuefade/(float)255)) + tmpcolor2.green() * (float)((float)valuefade/(float)255));
                                                        tmpcolor3.setBlue(tmpcolor1.blue() * (1-(float)((float)valuefade/(float)255)) + tmpcolor2.blue() * (float)((float)valuefade/(float)255));
                                                        dstPixel = tmpcolor3.rgb();
                                                        dstImage.setPixel(x, y, dstPixel);
                                                }
						else
						{
                                                        dstImage.setPixel(x, y, srcPixel);
                                                }
                                        }
					else
					{
                                                dstImage.setPixel(x, y, srcPixel2);
                                        }
				}
			}
		}
	}
	else
	{
		// *** Fondu enchaine ***

                QRgb *ltrt1 = reinterpret_cast<QRgb *>(srcImage.scanLine(0));
                QRgb *ltrt2 = reinterpret_cast<QRgb *>(srcImage2.scanLine(0));

		for (y = 0; y < srcImage.height(); y++)
		{
                        ltrt1 = reinterpret_cast<QRgb *>(srcImage.scanLine(y));
                        ltrt2 = reinterpret_cast<QRgb *>(srcImage2.scanLine(y));

			for (x = 0; x < srcImage.width(); x++)
			{
                                srcPixel = ltrt1[x];
                                srcPixel2 = ltrt2[x];
				tmpcolor1 = srcPixel;
				tmpcolor2 = srcPixel2;
                                tmpcolor3.setRed(tmpcolor1.red() * (1-(float)((float)sequence/(float)100)) + tmpcolor2.red() * (float)((float)sequence/(float)100));
                                tmpcolor3.setGreen(tmpcolor1.green() * (1-(float)((float)sequence/(float)100)) + tmpcolor2.green() * (float)((float)sequence/(float)100));
                                tmpcolor3.setBlue(tmpcolor1.blue() * (1-(float)((float)sequence/(float)100)) + tmpcolor2.blue() * (float)((float)sequence/(float)100));
				dstPixel = tmpcolor3.rgb();
				dstImage.setPixel(x, y, dstPixel);
			}				
		}
	}
	emit myfin();
}

