/* ============================================================
 * File  : theme_navigator.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "theme_navigator.h"

theme_navigator::theme_navigator ( QWidget * parent )
    : QListWidget(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        action_licence = new QAction(tr("Afficher la licence"), this);
        action_licence->setIcon ( QIcon(":/Interface/Interface/info.png") );

        action_pack = new QAction(tr("Packager le thème"), this);
        action_pack->setIcon ( QIcon(":/Interface/Interface/archive.png") );

        connect(action_licence, SIGNAL(triggered()), this, SLOT(f_licence()));
        connect(action_pack, SIGNAL(triggered()), this, SLOT(f_pack()));
}

void theme_navigator::contextMenuEvent(QContextMenuEvent *event)
{
    if (currentItem() == NULL)
    {
            return;
    }
    else
    {
        if ( QFile::exists(pathname + "/" + currentItem()->text().mid(0,currentItem()->text().lastIndexOf("\n")) + "/licence.txt") == true )
        {
            QMenu menu(this);
            menu.addAction(action_licence);
            menu.addSeparator();
            menu.addAction(action_pack);
            menu.exec(event->globalPos());
        }
        else
        {
            QMenu menu(this);
            menu.addAction(action_pack);
            menu.exec(event->globalPos());
        }
    }
}

void theme_navigator::f_pack()
{
    emit pack(pathname , currentItem()->text().mid(0,currentItem()->text().lastIndexOf("\n")));
}

void theme_navigator::f_licence()
{
    emit licence(pathname + "/" + currentItem()->text().mid(0,currentItem()->text().lastIndexOf("\n")) + "/licence.txt");
}

void theme_navigator::f_load_theme()
{
	// *** CHARGEMENT DE LA BIBLIOTHEQUE DE THEMES ***
	this->clear();

	QDir tmpdir;
	tmpdir.setPath(pathname);
	tmpdir.setSorting(QDir::DirsFirst | QDir::Name);
	QDir tmpdir_niv2;
	int wl_int_001;
	QPainter p;

        QPixmap wl_pix_001(256,256);
	QPixmap wl_pix_002;

	QString wl_string_001;
	QString wl_string_002;

	QStringList filters;
	filters << "*";
	tmpdir.setNameFilters(filters);

	QStringList filters2;
        filters2 << "*.mpg" << "*.MPG" << "*.MPEG" << "*.mpeg" << "*.avi" << "*.AVI";

        //QByteArray newData;
     	QFile wmyfic;

	if ( pathname != top_pathname )
	{
		QListWidgetItem *item = new QListWidgetItem(this);
		item->setIcon(QIcon(":/Interface/Interface/goto_previous.png"));
		item->setText("..");
		item->setStatusTip("FOLDER");
	}

	foreach (wl_string_001, tmpdir.entryList(QDir::Dirs))
	{
		if ( wl_string_001.mid(0,1) != "." && wl_string_001.mid(0,5) != "FOLD_" )
		{
			tmpdir_niv2.setPath(pathname + "/" + wl_string_001 + "/");
			tmpdir_niv2.setNameFilters(filters2);
                        wg_pix_001.fill(QColor(0,0,0,0));
                        wg_pix_001.load(pathname + wl_string_001 + "/theme.jpg");
			wg_pix_001 = wg_pix_001.scaledToWidth(300,Qt::FastTransformation);
			if ( tmpdir_niv2.count() > 0 )
			{
				QPainter p;
				p.begin(&wg_pix_001);
                                /*p.setRenderHint(QPainter::Antialiasing,true);
				p.setBrush(QColor(250,250,250,200));
				p.drawRoundedRect(20, 20, 250, 50,5,5,Qt::AbsoluteSize);
				p.setPen(QColor(20,20,20));
				QFont myfont("Helvetica [Cronyx]", 30);
				p.setFont(myfont);
                                p.drawText(30,60,tr("Anime"));*/
                                p.drawPixmap(wg_pix_001.width()-50,wg_pix_001.height()-50,-1,-1,QPixmap(":/Interface/Interface/anim.png"));
				p.end();
			}

			QByteArray newData;
		     	wmyfic.setFileName(pathname + wl_string_001 + "/theme.txt");

			if ( !wmyfic.open( QIODevice::ReadOnly ))
			{
				qDebug() << "ERROR OPENING THEME IN : " + pathname + wl_string_001 + "/";
				return;
			}
			else
			{
				newData = wmyfic.readLine(0);
				wg_string_002 = QString::fromLocal8Bit(newData);
				wg_string_002 = wg_string_002.simplified();
				wg_string_002 = wg_string_002.mid(0, newData.count() - 1);

				if ( wg_string_002.left(8) == "ANIMATED" )
				{
					newData = wmyfic.readLine(0);
					newData = wmyfic.readLine(0);
					wg_string_002 = QString::fromLocal8Bit(newData);
					wg_string_002 = wg_string_002.simplified();
					wg_string_002 = wg_string_002.mid(0, newData.count() - 1);
				}

				wg_int_001 = wg_string_002.toInt();

				newData = wmyfic.readLine(0);
				wg_string_002 = QString::fromLocal8Bit(newData);
				wg_string_002 = wg_string_002.simplified();
				wg_string_002 = wg_string_002.mid(0, newData.count() - 1);

				wg_int_002 = wg_string_002.toInt();

				if ( wg_int_001 == 720 && wg_int_002 == 576 )
				{
					wg_string_002 = "PAL 4:3";
				}
				else
				{
					if ( wg_int_001 == 1024 && wg_int_002 == 576 )
					{
						wg_string_002 = "PAL 16:9";
					}
					else
					{
						wg_string_002 = "NTSC 4:3";
					}
				}
				wmyfic.close();
			}

			QListWidgetItem *item = new QListWidgetItem(this);
			item->setIcon(QIcon(wg_pix_001));
			item->setText(wl_string_001.mid(0,wl_string_001.length())+ "\n" + wg_string_002);
			item->setStatusTip("THEME");
		}
		else
		{
			if ( wl_string_001.mid(0,5) == "FOLD_" )
			{
				wl_pix_001.fill(QColor(0,0,0,0));
				p.begin(&wl_pix_001);
				p.setRenderHint(QPainter::Antialiasing,true);
                                p.setPen(QColor(0,0,0,220));
                                p.drawPixmap(0,0,QPixmap(":/Interface/Interface/f1.png"));
				tmpdir_niv2.setPath(pathname + wl_string_001 + "/");
				wl_int_001 = 0;
				foreach (wl_string_002, tmpdir_niv2.entryList(QDir::Dirs))
				{
					if ( wl_string_002.mid(0,1) != "." && wl_int_001 < 3 )
					{
                                                wl_pix_002.load(pathname + wl_string_001 + "/" + wl_string_002 + "/theme.jpg");
                                                wl_pix_002 = wl_pix_002.scaledToWidth ( 190, Qt::FastTransformation );
						if ( wl_int_001 == 0 )
						{
                                                        p.translate(60+(wl_pix_002.width()/2),59+(wl_pix_002.height()/2));
                                                        p.rotate(-88);
                                                        p.translate(-(60+(wl_pix_002.width()/2)),-(59+(wl_pix_002.height()/2)));
                                                        p.drawPixmap(60,59,wl_pix_002);
						}
						else
						{
							if ( wl_int_001 == 1 )
							{
                                                                p.resetTransform();
                                                                p.translate(40+(wl_pix_002.width()/2),59+(wl_pix_002.height()/2));
                                                                p.rotate(-92);
                                                                p.translate(-(40+(wl_pix_002.width()/2)),-(59+(wl_pix_002.height()/2)));
                                                                p.drawPixmap(40,59,wl_pix_002);
							}
							else
							{
                                                                p.resetTransform();
                                                                p.translate(20+(wl_pix_002.width()/2),59+(wl_pix_002.height()/2));
                                                                p.rotate(-96);
                                                                p.translate(-(20+(wl_pix_002.width()/2)),-(59+(wl_pix_002.height()/2)));
                                                                p.drawPixmap(20,59,wl_pix_002);
							}
						}

						wl_int_001++;
					}
				}
                                p.resetTransform();
                                p.drawPixmap(0,0,QPixmap(":/Interface/Interface/f2.png"));
				p.end();
				//
                                if ( wl_int_001 > 0 )
                                {
                                    QListWidgetItem *item = new QListWidgetItem(this);
                                    item->setIcon(wl_pix_001);
                                    item->setText(wl_string_001.mid(5,wl_string_001.length()-5));
                                    item->setStatusTip("FOLDER");
                                }
			}
		}
	}
	//this->sortItems( Qt::AscendingOrder );
}
