/* ============================================================
 * File  : project.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <QtGui>
#include "mainfrm.h"
#include "userSettings.h"

// ********************************
// *** ENREGISTREMENT DU PROJET ***
// ********************************

void mainfrm::f_save_1()
{
        if ( frame_smile->isVisible() == true )
        {
            f_saveas_smile();
            return;
        }
	// *** SAVE AS ***
	this->setDisabled(true);
	if ( hdl_current_menu != 0 )
	{
		hdl_current_menu->is_select = 0;
		hdl_current_menu = 0;
	}

	QString wmypro = QFileDialog::getSaveFileName(this, tr("Sauvegarder votre projet"), path_save, tr("Projet (*.mdvd)"));
       	if ( wmypro.isNull() )
       	{
		this->setEnabled(true);
		return;
       	}
	else
	{
		if ( wmypro.right(5) != ".mdvd" )
		{
			wmypro = wmypro + ".mdvd";
		}
		QString wl_str_001;
		path_always_save = wmypro;
   		wg_int_001 = wmypro.lastIndexOf( '/' );
    		if ( wg_int_001 != -1 )
    		{
        		path_save = wmypro.mid(0,wg_int_001);
    		}

		f_save_widgetonmenu();

		// *** SAUVEGARDE DES MEDIAS ***
	     	QFile wmyfic(path_project + "/DVD/SVP/prj_med.x");

		if ( !wmyfic.open( QIODevice::WriteOnly ))
		{
			qDebug() << "ERROR CREATING PROJECT MEDIA IN : " + path_project;
			return;
		}
		else
		{
			QTextStream out(&wmyfic);

			wg_int_001 = 0;
			out << QString::number(combo_format_dvd->currentIndex()) << endl;
			out << QString::number(dvdzone) << endl;

			while ( wg_int_001 < nbre_medias )
			{
				hdl_current_media = table_hdl_medias[wg_int_001];

				hdl_current_media->image.save(path_project + "/DVD/SVP/MDI" + QString::number(wg_int_001) + ".png","PNG");
				hdl_current_media->miniature.save(path_project + "/DVD/SVP/MDM" + QString::number(wg_int_001) + ".png","PNG");
				out << hdl_current_media->pathname_media.simplified() << endl;
				out << hdl_current_media->wl_width.simplified() << endl;
				out << hdl_current_media->wl_height.simplified() << endl;
				out << hdl_current_media->wl_fps.simplified() << endl;
				out << hdl_current_media->wl_duree.simplified() << endl;
				out << hdl_current_media->wl_format.simplified() << endl;
				out << hdl_current_media->wl_audio_channel.simplified() << endl;
                                out << QString::number(hdl_current_media->isdvd) << QString::number(hdl_current_media->issca) << endl;
				out << QString::number(hdl_current_media->dvdsize) << endl;
				out << QString::number(hdl_current_media->is_lock) << endl;
                                //out << QString::number(hdl_current_media->position.x()) << endl;
                                //out << QString::number(hdl_current_media->position.y()) << endl;
				out << QString::number(hdl_current_media->nbre_chapitres) << endl;
				out << hdl_current_media->wl_vbitrate << endl;
				out << hdl_current_media->wl_vbitrate_encode << endl;
				out << hdl_current_media->wl_sub_path << endl;
				out << QString::number(hdl_current_media->oldisdvd) << endl;
				out << hdl_current_media->wl_video_sync << endl;
				out << hdl_current_media->hue << endl;
				out << hdl_current_media->saturation << endl;
				out << hdl_current_media->contraste << endl;
				out << hdl_current_media->lumiere << "$E" << hdl_current_media->isdvdintro << endl;
				if ( checkBox_save_encode->isChecked() == true )
				{
					out << hdl_current_media->already_encode << endl;
				}
				else
				{
					out << "0" << endl;
				}

				wg_int_002 = 0;
				wg_string_001 = "";
				while ( wg_int_002 <= hdl_current_media->nbre_chapitres )
				{
					wg_string_001 = wg_string_001 + hdl_current_media->chapitres[wg_int_002] + ";";
					wg_pix_001 = hdl_current_media->icones_chapitres[wg_int_002].pixmap(hdl_current_media->miniature.width(),hdl_current_media->miniature.height(),QIcon::Normal,QIcon::On);
					wg_pix_001.save(path_project + "/DVD/SVP/C" + QString::number(wg_int_001) + "X" + QString::number(wg_int_002) + ".png","PNG");
					wg_int_002++;
				}
				out << wg_string_001.simplified() << endl;

				wg_int_002 = 0;
				wg_string_001 = "";
				while ( hdl_current_media->table_soundtrack[wg_int_002] != "" )
				{
					wg_string_001 = wg_string_001 + hdl_current_media->table_soundtrack[wg_int_002] + ";";
					wg_int_002++;
				}
				out << wg_string_001.simplified() << endl;
                                out << hdl_current_media->sub_pos << endl;
                                out << hdl_current_media->sub_size << endl;

				out << "------" << endl;
				wg_int_001++;
			}
			wmyfic.close();
		}

		// *** SAUVEGARDE DES POSITIONS DE MENUS DE L'ARBRE ***
	     	wmyfic.setFileName(path_project + "/DVD/SVP/prj_arb.x");

		if ( !wmyfic.open( QIODevice::WriteOnly ))
		{
			qDebug() << "ERROR CREATING PROJECT TREE IN : " + path_project;
			return;
		}
		else
		{
			int wl_int_001 = 0;
			QTextStream out(&wmyfic);

			while ( wl_int_001 <= nbre_menuth )
			{
				out << frame_syno->tab_pnt_item[wl_int_001]->geometry().x() << endl;
				out << frame_syno->tab_pnt_item[wl_int_001]->geometry().y() << endl;
				wl_int_001++;
			}
			wmyfic.close();
		}

		// *** SAUVEGARDE DES POSITIONS DE MEDIAS DE L'ARBRE ***
	     	wmyfic.setFileName(path_project + "/DVD/SVP/med_arb.x");

		if ( !wmyfic.open( QIODevice::WriteOnly ))
		{
			qDebug() << "ERROR CREATING PROJECT MEDIA TREE IN : " + path_project;
			return;
		}
		else
		{
			int wl_int_001 = 0;
			QTextStream out(&wmyfic);

			while ( wl_int_001 < nbre_medias )
			{
				out << frame_syno->tab_pnt_media[wl_int_001]->geometry().x() << endl;
				out << frame_syno->tab_pnt_media[wl_int_001]->geometry().y() << endl;
				wl_int_001++;
			}
			wmyfic.close();
		}

		// *** SAUVEGARDE DES MENUS BOUTONS ***
	     	wmyfic.setFileName(path_project + "/DVD/SVP/prj_bou.x");

		if ( !wmyfic.open( QIODevice::WriteOnly ))
		{
			qDebug() << "ERROR CREATING PROJECT BUTTONS IN : " + path_project;
			return;
		}
		else
		{
			wg_int_001=0;

			QTextStream out(&wmyfic);
			while ( wg_int_001 <= nbre_menuth )
			{
				out << table_menus_property[wg_int_001][0] << endl;
				out << table_menus_property[wg_int_001][1] << endl;
				out << table_menus_property[wg_int_001][2] << endl;
				out << table_menus_property[wg_int_001][3] << endl;
				out << table_menus_property[wg_int_001][4] << endl;
				out << table_menus_property[wg_int_001][5] << endl;
				out << table_menus_property[wg_int_001][6] << endl;
				out << table_menus_property[wg_int_001][7] << endl;
				out << table_menus_property[wg_int_001][8] << endl;
                                out << table_menus_property[wg_int_001][9] << endl;

                                if ( table_menus_property[wg_int_001][0].right(5) == ".MPEG" || table_menus_property[wg_int_001][0].right(5) == ".mpeg" || table_menus_property[wg_int_001][0].right(4) == ".MPG" || table_menus_property[wg_int_001][0].right(4) == ".mpg" || table_menus_property[wg_int_001][0].right(4) == ".AVI" || table_menus_property[wg_int_001][0].right(4) == ".avi" || table_menus_property[wg_int_001][0].right(4) == ".MP4" || table_menus_property[wg_int_001][0].right(4) == ".mp4" )
				{
			   		wg_int_002 = table_menus_property[wg_int_001][0].lastIndexOf( '/' );
			    		if ( wg_int_002 != -1 )
			    		{
						QFile::copy ( path_project+"/DVD/TEMP/"+table_menus_property[wg_int_001][0].mid(wg_int_002+1,table_menus_property[wg_int_001][0].length()-(wg_int_002+1))+".jpg", path_project+"/DVD/SVP/"+table_menus_property[wg_int_001][0].mid(wg_int_002+1,table_menus_property[wg_int_001][0].length()-(wg_int_002+1)) + ".jpg" );
					}
				}

				wg_int_002 = 0;
				while ( table_menus[wg_int_001][wg_int_002][0] != "$$$" )
				{
					hdl_current_menu = table_hdl_menus[wg_int_002];
					wg_string_001 = "";
					wg_int_003 = 0;
                                        while ( wg_int_003 < 27 )
					{
						if ( wg_int_003 != 4 )
						{
							wg_string_001 = wg_string_001 + table_menus[wg_int_001][wg_int_002][wg_int_003].simplified() + ";";
						}
						else
						{
							wg_string_001 = wg_string_001 + "*;";
						}
						wg_int_003++;
					}
					out << wg_string_001 << endl;

					wl_str_001 = table_menus[wg_int_001][wg_int_002][4];
					wl_str_001.replace(QString("\n"), QString("$-E#"));
					out << wl_str_001 << endl;

					wg_int_002++;
				}
				out << "------" << endl;
				table_hdl_menuth[wg_int_001]->draw_image.save(path_project + "/DVD/SVP/MTH" + QString::number(wg_int_001) + ".png","PNG");
				wg_int_001++;
			}
			wmyfic.close();
		}

		// *** SAUVEGARDE DU PROJET ***
	     	wmyfic.setFileName(path_project + "/DVD/prjsave.sh");

		if ( !wmyfic.open( QIODevice::WriteOnly ))
		{
			qDebug() << "ERROR CREATING BASH SAVING PROJECT IN : " + path_project;
			return;
		}
		else
		{
			QTextStream out(&wmyfic);
			out << "cd " + path_project + "/DVD/" << endl;
			out << "rm -f " + path_project + "/DVD/SVP/MEDIAS" << endl;
			if ( checkBox_save_encode->isChecked() == true )
			{
				out << "cp -rf " + path_project + "/DVD/MEDIAS " + path_project + "/DVD/SVP/" << endl;
			}
			out << "tar cf " + wmypro + " SVP" << endl;
			out << "rm -f prjsave.sh" << endl;
			wmyfic.close();

			wg_int_005 = 0;

			QString program = "bash";
			QStringList arguments;
	       		arguments << path_project + "/DVD/prjsave.sh";
		      	projectProcess.setProcessChannelMode(QProcess::MergedChannels);
		      	projectProcess.start(program,arguments);
		}
	}
}

void mainfrm::f_save_2()
{
	// *** SAVE ***
        if ( frame_smile->isVisible() == true )
        {
            f_save_smile();
            return;
        }


	this->setDisabled(true);
	if ( hdl_current_menu != 0 )
	{
		hdl_current_menu->is_select = 0;
		hdl_current_menu = 0;
	}

	actionCopier_le_bouton->setDisabled(true);
	actionColler_le_bouton->setDisabled(true);
	bt_bt_img->setDisabled(true);
	dial_alpha_menu->setDisabled(true);
	combo_quoilire_media->setDisabled(true);
	combo_quoilire_media_chapitre->setDisabled(true);
	combo_quoilire_menu->setDisabled(true);
	bttxt->setDisabled(true);
	frame_th_msk_idea->setDisabled(true);

	wg_int_001 = path_always_save.lastIndexOf( '/' );
	if ( wg_int_001 != -1 )
	{
		path_save = path_always_save.mid(0,wg_int_001);
	}

	f_save_widgetonmenu();
	QString wl_str_001;
	// *** SAUVEGARDE DES MEDIAS ***
     	QFile wmyfic(path_project + "/DVD/SVP/prj_med.x");

	if ( !wmyfic.open( QIODevice::WriteOnly ))
	{
		qDebug() << "ERROR CREATING PROJECT MEDIA IN : " + path_project;
		return;
	}
	else
	{
		QTextStream out(&wmyfic);

		wg_int_001 = 0;
		out << QString::number(combo_format_dvd->currentIndex()) << endl;
		out << QString::number(dvdzone) << endl;

		while ( wg_int_001 < nbre_medias )
		{
			hdl_current_media = table_hdl_medias[wg_int_001];

			hdl_current_media->image.save(path_project + "/DVD/SVP/MDI" + QString::number(wg_int_001) + ".png","PNG");
			hdl_current_media->miniature.save(path_project + "/DVD/SVP/MDM" + QString::number(wg_int_001) + ".png","PNG");
			out << hdl_current_media->pathname_media.simplified() << endl;
			out << hdl_current_media->wl_width.simplified() << endl;
			out << hdl_current_media->wl_height.simplified() << endl;
			out << hdl_current_media->wl_fps.simplified() << endl;
			out << hdl_current_media->wl_duree.simplified() << endl;
			out << hdl_current_media->wl_format.simplified() << endl;
			out << hdl_current_media->wl_audio_channel.simplified() << endl;
                        out << QString::number(hdl_current_media->isdvd) << QString::number(hdl_current_media->issca) << endl;
			out << QString::number(hdl_current_media->dvdsize) << endl;
			out << QString::number(hdl_current_media->is_lock) << endl;
                        //out << QString::number(hdl_current_media->position.x()) << endl;
                        //out << QString::number(hdl_current_media->position.y()) << endl;
			out << QString::number(hdl_current_media->nbre_chapitres) << endl;
			out << hdl_current_media->wl_vbitrate << endl;
			out << hdl_current_media->wl_vbitrate_encode << endl;
			out << hdl_current_media->wl_sub_path << endl;
			out << QString::number(hdl_current_media->oldisdvd) << endl;
			out << hdl_current_media->wl_video_sync << endl;
			out << hdl_current_media->hue << endl;
			out << hdl_current_media->saturation << endl;
			out << hdl_current_media->contraste << endl;
			out << hdl_current_media->lumiere << "$E" << hdl_current_media->isdvdintro << endl;
			if ( checkBox_save_encode->isChecked() == true )
			{
				out << hdl_current_media->already_encode << endl;
			}
			else
			{
				out << "0" << endl;
			}

			wg_int_002 = 0;
			wg_string_001 = "";
			while ( wg_int_002 <= hdl_current_media->nbre_chapitres )
			{
				wg_string_001 = wg_string_001 + hdl_current_media->chapitres[wg_int_002] + ";";
				wg_pix_001 = hdl_current_media->icones_chapitres[wg_int_002].pixmap(hdl_current_media->miniature.width(),hdl_current_media->miniature.height(),QIcon::Normal,QIcon::On);
				wg_pix_001.save(path_project + "/DVD/SVP/C" + QString::number(wg_int_001) + "X" + QString::number(wg_int_002) + ".png","PNG");
				wg_int_002++;
			}
			out << wg_string_001.simplified() << endl;

			wg_int_002 = 0;
			wg_string_001 = "";
			while ( hdl_current_media->table_soundtrack[wg_int_002] != "" )
			{
				wg_string_001 = wg_string_001 + hdl_current_media->table_soundtrack[wg_int_002] + ";";
				wg_int_002++;
			}
			out << wg_string_001.simplified() << endl;
                        out << hdl_current_media->sub_pos << endl;
                        out << hdl_current_media->sub_size << endl;

			out << "------" << endl;
			wg_int_001++;
		}
		wmyfic.close();
	}

	// *** SAUVEGARDE DES POSITIONS DE MENUS DE L'ARBRE ***
     	wmyfic.setFileName(path_project + "/DVD/SVP/prj_arb.x");

	if ( !wmyfic.open( QIODevice::WriteOnly ))
	{
		qDebug() << "ERROR CREATING PROJECT TREE IN : " + path_project;
		return;
	}
	else
	{
		int wl_int_001 = 0;
		QTextStream out(&wmyfic);

		while ( wl_int_001 <= nbre_menuth )
		{
			out << frame_syno->tab_pnt_item[wl_int_001]->geometry().x() << endl;
			out << frame_syno->tab_pnt_item[wl_int_001]->geometry().y() << endl;
			wl_int_001++;
		}
		wmyfic.close();
	}

	// *** SAUVEGARDE DES POSITIONS DE MEDIAS DE L'ARBRE ***
     	wmyfic.setFileName(path_project + "/DVD/SVP/med_arb.x");

	if ( !wmyfic.open( QIODevice::WriteOnly ))
	{
		qDebug() << "ERROR CREATING PROJECT MEDIA TREE IN : " + path_project;
		return;
	}
	else
	{
		int wl_int_001 = 0;
		QTextStream out(&wmyfic);

		while ( wl_int_001 < nbre_medias )
		{
			out << frame_syno->tab_pnt_media[wl_int_001]->geometry().x() << endl;
			out << frame_syno->tab_pnt_media[wl_int_001]->geometry().y() << endl;
			wl_int_001++;
		}
		wmyfic.close();
	}

	// *** SAUVEGARDE DES MENUS BOUTONS ***
     	wmyfic.setFileName(path_project + "/DVD/SVP/prj_bou.x");

	if ( !wmyfic.open( QIODevice::WriteOnly ))
	{
		qDebug() << "ERROR CREATING PROJECT BUTTONS IN : " + path_project;
		return;
	}
	else
	{
		wg_int_001=0;
		QTextStream out(&wmyfic);
		while ( wg_int_001 <= nbre_menuth )
		{
			out << table_menus_property[wg_int_001][0] << endl;
			out << table_menus_property[wg_int_001][1] << endl;
			out << table_menus_property[wg_int_001][2] << endl;
			out << table_menus_property[wg_int_001][3] << endl;
			out << table_menus_property[wg_int_001][4] << endl;
			out << table_menus_property[wg_int_001][5] << endl;
			out << table_menus_property[wg_int_001][6] << endl;
			out << table_menus_property[wg_int_001][7] << endl;
			out << table_menus_property[wg_int_001][8] << endl;
                        out << table_menus_property[wg_int_001][9] << endl;

                        if ( table_menus_property[wg_int_001][0].right(5) == ".MPEG" || table_menus_property[wg_int_001][0].right(5) == ".mpeg" || table_menus_property[wg_int_001][0].right(4) == ".MPG" || table_menus_property[wg_int_001][0].right(4) == ".mpg" || table_menus_property[wg_int_001][0].right(4) == ".AVI" || table_menus_property[wg_int_001][0].right(4) == ".avi" || table_menus_property[wg_int_001][0].right(4) == ".MP4" || table_menus_property[wg_int_001][0].right(4) == ".mp4" )
			{
		   		wg_int_002 = table_menus_property[wg_int_001][0].lastIndexOf( '/' );
		    		if ( wg_int_002 != -1 )
		    		{
					QFile::copy ( path_project+"/DVD/TEMP/"+table_menus_property[wg_int_001][0].mid(wg_int_002+1,table_menus_property[wg_int_001][0].length()-(wg_int_002+1))+".jpg", path_project+"/DVD/SVP/"+table_menus_property[wg_int_001][0].mid(wg_int_002+1,table_menus_property[wg_int_001][0].length()-(wg_int_002+1)) + ".jpg" );
				}
			}

			wg_int_002 = 0;
			while ( table_menus[wg_int_001][wg_int_002][0] != "$$$" )
			{
				hdl_current_menu = table_hdl_menus[wg_int_002];
				wg_string_001 = "";
				wg_int_003 = 0;
                                while ( wg_int_003 < 27 )
				{
					if ( wg_int_003 != 4 )
					{
						wg_string_001 = wg_string_001 + table_menus[wg_int_001][wg_int_002][wg_int_003].simplified() + ";";
					}
					else
					{
						wg_string_001 = wg_string_001 + "*;";
					}
					wg_int_003++;
				}
				out << wg_string_001 << endl;

				wl_str_001 = table_menus[wg_int_001][wg_int_002][4];
				wl_str_001.replace(QString("\n"), QString("$-E#"));
				out << wl_str_001 << endl;

				wg_int_002++;
			}
			out << "------" << endl;
			table_hdl_menuth[wg_int_001]->draw_image.save(path_project + "/DVD/SVP/MTH" + QString::number(wg_int_001) + ".png","PNG");
			wg_int_001++;
		}
		wmyfic.close();
	}

	// *** SAUVEGARDE DU PROJET ***
     	wmyfic.setFileName(path_project + "/DVD/prjsave.sh");

	if ( !wmyfic.open( QIODevice::WriteOnly ))
	{
		qDebug() << "ERROR CREATING BASH SAVING PROJECT IN : " + path_project;
		return;
	}
	else
	{
		QTextStream out(&wmyfic);
		out << "cd " + path_project + "/DVD/" << endl;
		out << "rm -f " + path_project + "/DVD/SVP/MEDIAS" << endl;
		if ( checkBox_save_encode->isChecked() == true )
		{
			out << "cp -rf " + path_project + "/DVD/MEDIAS " + path_project + "/DVD/SVP/" << endl;
		}
		out << "tar cf " + path_always_save + " SVP" << endl;
		out << "rm -f prjsave.sh" << endl;
		wmyfic.close();

		wg_int_005 = 0;

		QString program = "bash";
		QStringList arguments;
       		arguments << path_project + "/DVD/prjsave.sh";
	      	projectProcess.setProcessChannelMode(QProcess::MergedChannels);
	      	projectProcess.start(program,arguments);
	}
}

// ************************************************
// *** POINT DE SORTIE POUR GESTION DES PROJETS ***
// ************************************************

void mainfrm::projectend(int, QProcess::ExitStatus)
{
	if ( wg_int_005 == 0 )
	{
		
		QMessageBox::information(this, name_application, tr("Sauvegarde du projet terminee"));
		this->setEnabled(true);
		actionEnregistrer_2->setEnabled(true);
                if ( frame_smile->isVisible() == true )
                {
                    this->setWindowTitle(tr("2ManDVD - Creation de diaporamas : ") + path_always_save);
                }
                else
                {
                    this->setWindowTitle(tr("2ManDVD - Creation de DVD Videos : ") + path_always_save);
                }
		return;
	}

	if ( wg_int_005 == 1 )
	{
		f_open_2();
                if ( frame_smile->isVisible() == true )
                {
                    this->setWindowTitle(tr("2ManDVD - Creation de diaporamas : ") + path_always_save);
                }
                else
                {
                    this->setWindowTitle(tr("2ManDVD - Creation de DVD Videos : ") + path_always_save);
                }
		return;
	}

}

// ***************************
// *** OUVERTURE DU PROJET ***
// ***************************

void mainfrm::f_open_from_start()
{
	QString wmypro = QFileDialog::getOpenFileName(
        	this,
        	tr("Ouvrir un projet"),
        	path_save,
                "(*.mdvd *.smil)");
	if ( wmypro.isNull() )
	{
	}
	else
	{
		if ( line_path_projet->text() != "" )
		{                   
	   		int wl_int_001 = wmypro.lastIndexOf( '/' );
	    		if ( wl_int_001 != -1 )
	    		{
				path_save = wmypro.mid(0,wl_int_001);
	    		}
			path_project = line_path_projet->text();

                        if ( wmypro.right(5) == ".smil" )
                        {
                            f_openfs_smile(wmypro);
                            return;
                        }

			QFile wmyficext;
			QTextStream outext(&wmyficext);

			wmyficext.setFileName(path_project + "/.delall.sh");
			wmyficext.open( QIODevice::WriteOnly );
			outext << "rm -rf " + path_project + "/DVD" << endl;
			outext << "rm -f " + path_project + "/.delall.sh" << endl;
			outext << "exit" << endl;
			wmyficext.close();
			QString programf = "bash";
			QStringList argumentsf;
			argumentsf << path_project + "/.delall.sh";

		      	proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
			proc_ffmpeg.start(programf,argumentsf);

			proc_ffmpeg.waitForFinished(-1);

			if ( f_create_env() == true )
			{
				path_always_save = wmypro;
				frame_editor->lower();
				frame_editor->show();
                thread_ani->hdlmsk = mask_interface;
				thread_ani->sens = 0;
				frame_new_proj->hide();

				smenuBar->setEnabled(true);

		                // *** SAUVEGARDE LES INFOS DE LA DERNIERE SESSION ***
		                QDir currentDir = QDir::homePath();
		                QFile configfile( currentDir.path() + "/.2mandvd.cnf" );
		                if (configfile.open(QIODevice::WriteOnly))
		                {
		                        QTextStream out(&configfile);
		                        out << line_path_projet->text() << endl;
					if ( checkBox_save_encode->isChecked() == true )
					{
			                        out << "1" << endl;
					}
					else
					{
			                        out << "0" << endl;
					}
					if ( combo_format_vmax->currentIndex() == 0 )
					{
						out << "2600" << endl;
						wl_vmax = 2600;
					}
					else
					{
						if ( combo_format_vmax->currentIndex() == 1 )
						{
							out << "5000" << endl;
							wl_vmax = 5000;
						}
						else
						{
							out << "9800" << endl;
							wl_vmax = 9800;
						}
					}
					out << combo_format_audio->currentIndex() << endl;
                                        out << QString::number(spin_thread->value()) << endl;
                                        out << QString::number(combo_player->currentIndex()) << endl;
                                        out << cb_aa->isChecked() << endl;
                                        out << cb_dr->isChecked() << endl;
                                        out << QString::number(combo_vmemory->currentIndex()) << endl;
		                        configfile.close();
		                }

                                //QTimer::singleShot(10, this, SLOT(f_run_ani()));

		   		wg_int_001 = wmypro.lastIndexOf( '/' );
		    		if ( wg_int_001 != -1 )
		    		{
					path_save = wmypro.mid(0,wg_int_001);
		    		}

				QFile wmyfic(path_project + "/DVD/prjopen.sh");
				if ( !wmyfic.open( QIODevice::WriteOnly ))
				{
					qDebug() << "ERROR CREATING BASH SAVING PROJECT IN : " + path_project;
					return;
				}
				else
				{
					this->setDisabled(true);
					QTextStream out(&wmyfic);
					out << "cd " + path_project + "/DVD/" << endl;
					out << "tar xf " + wmypro << endl;
					out << "cp -rf " + path_project + "/DVD/SVP/MEDIAS " + path_project + "/DVD/"<< endl;
					out << "rm -f prjopen.sh" << endl;
					out << "exit" << endl;
					wmyfic.close();

					wg_int_005 = 1;

					QString program = "bash";
					QStringList arguments;
			       		arguments << path_project + "/DVD/prjopen.sh";
				      	projectProcess.setProcessChannelMode(QProcess::MergedChannels);
				      	projectProcess.start(program,arguments);
				}
			}
			else
			{
				qDebug() << "ERROR CREATING ENVIRONEMENT ************************************";
				QMessageBox::information(this, name_application, tr("Impossible de créer les dossiers de travail"));
				this->setEnabled(true);
			}
		}
		else
		{
			QMessageBox::information(this, name_application, tr("Vous devez choisir un dossier pour les fichiers de travail"));
		}
	}
}

void mainfrm::f_open_1()
{
        QString wmypro;
        if ( frame_smile->isVisible() == true )
        {
            wmypro = QFileDialog::getOpenFileName(
                this,
                tr("Ouvrir un projet"),
                path_save,
                "(*.smil)");
        }
        else
        {
            wmypro = QFileDialog::getOpenFileName(
        	this,
        	tr("Ouvrir un projet"),
        	path_save,
                "(*.mdvd)");
        }
	if ( wmypro.isNull() )
	{
		return;
	}
	else
	{
   		int wl_int_001 = wmypro.lastIndexOf( '/' );
    		if ( wl_int_001 != -1 )
    		{
        		path_save = wmypro.mid(0,wl_int_001);
    		}

		path_always_save = wmypro;

                if ( wmypro.right(5) == ".smil" )
                {
                    whereopenfrom = 1;

                    //delete pntmygl;
                    //delete hdl_fr3d;

                    if ( nbre_audio_track > 0 )
                    {
                        delete hdl_audio;
                    }

                    f_openfs_smile(wmypro);
                    return;
                }

		QFile wmyfic(path_project + "/DVD/prjopen.sh");
		if ( !wmyfic.open( QIODevice::WriteOnly ))
		{
			qDebug() << "ERROR CREATING BASH SAVING PROJECT IN : " + path_project;
			return;
		}
		else
		{
			this->setDisabled(true);
			QTextStream out(&wmyfic);
			out << "cd " + path_project + "/DVD/" << endl;
			out << "tar xf " + wmypro << endl;
			out << "cp -rf " + path_project + "/DVD/SVP/MEDIAS " + path_project + "/DVD/"<< endl;
			out << "rm -f prjopen.sh" << endl;
			wmyfic.close();

			wg_int_005 = 1;

			QString program = "bash";
			QStringList arguments;
	       		arguments << path_project + "/DVD/prjopen.sh";
		      	projectProcess.setProcessChannelMode(QProcess::MergedChannels);
		      	projectProcess.start(program,arguments);
		}
	}
}

void mainfrm::f_open_ext(QString wmypro)
{
	f_create_env();

	wg_int_001 = wmypro.lastIndexOf( '/' );
	if ( wg_int_001 != -1 )
	{
		path_save = wmypro.mid(0,wg_int_001);
	}

	path_always_save = wmypro;

	QFile wmyfic(path_project + "/DVD/prjopen.sh");
	if ( !wmyfic.open( QIODevice::WriteOnly ))
	{
		qDebug() << "ERROR CREATING BASH SAVING PROJECT IN : " + path_project;
		return;
	}
	else
	{
		this->setDisabled(true);
		QTextStream out(&wmyfic);
		out << "cd " + path_project + "/DVD/" << endl;
		out << "tar xf " + wmypro << endl;
		out << "cp -rf " + path_project + "/DVD/SVP/MEDIAS " + path_project + "/DVD/"<< endl;
		out << "rm -f prjopen.sh" << endl;
		wmyfic.close();

		wg_int_005 = 1;

		QString program = "bash";
		QStringList arguments;
       		arguments << path_project + "/DVD/prjopen.sh";
	      	projectProcess.setProcessChannelMode(QProcess::MergedChannels);
	      	projectProcess.start(program,arguments);
	}
}

void mainfrm::f_open_2()
{
        // *** NETTOYAGE DE LA VUE ARBORESCENTE ***
        /*int wl_int_001 = 0;

        while ( wl_int_001 < nbre_menuth )
        {
            delete frame_syno->tab_pnt_item[wl_int_001];
            wl_int_001++;
        }
        wl_int_001 = 0;
        while ( wl_int_001 < nbre_medias )
        {
            delete frame_syno->tab_pnt_media[wl_int_001];
            wl_int_001++;
        }*/

        must_update = 0;
	f_init_proj();
	dvd_actual_size = 0;
	// *** CHARGEMENT DES MEDIAS ***

	QByteArray newData;
	QStringList wl_explode;
     	QFile wmyfic(path_project + "/DVD/SVP/prj_med.x");

	if ( !wmyfic.open( QIODevice::ReadOnly ))
	{
		qDebug() << "ERROR OPENING MEDIA IN : " + path_project;
		return;
	}
	else
	{
		newData = wmyfic.readLine(0);
		wg_string_001 = QString::fromLocal8Bit(newData);
		wg_string_001 = wg_string_001.simplified();
		wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
		combo_format_dvd->setCurrentIndex(wg_string_001.toInt());

		if ( combo_format_dvd->currentIndex() == 0 )
		{
			dvdxsize = 720;
			dvdysize = 576;
			dvd_standard = "pal";
			dvd_format = "4/3";
		}
		else
		{
			if ( combo_format_dvd->currentIndex() == 1 )
			{
				dvdxsize = 1024;
				dvdysize = 576;
				dvd_standard = "pal";
				dvd_format = "16/9";
			}
			else
			{
                                if ( combo_format_dvd->currentIndex() == 2 )
                                {
                                        dvdxsize = 720;
                                        dvdysize = 480;
                                        dvd_standard = "ntsc";
                                        dvd_format = "4/3";
                                }
                                else
                                {
                                        dvdxsize = 1024;
                                        dvdysize = 480;
                                        dvd_standard = "ntsc";
                                        dvd_format = "16/9";
                                }
			}
		}

                f_resize_project();

		newData = wmyfic.readLine(0);
		wg_string_001 = QString::fromLocal8Bit(newData);
		wg_string_001 = wg_string_001.simplified();
		wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
		dvdzone = wg_string_001.toInt();

                /*frame_support_editor->setGeometry(0,0,frame_editor->width(),frame_editor->height());
                screen_designer->setGeometry((frame_support_editor->width()-dvdxsize)/2,(frame_support_editor->height()-dvdysize)/2,dvdxsize,dvdysize);
		background_menu->setGeometry(0,0,dvdxsize,dvdysize);
                safety_zone->setGeometry(0,0,dvdxsize,dvdysize);*/

		newData = wmyfic.readLine(0);
		wg_int_001 = 0;
		while ( wmyfic.atEnd() == false )
		{
			media *newmedia = new media(frame_mediatheque,frame_mediatheque);
			hdl_current_media = newmedia;
			table_hdl_medias[nbre_medias] = newmedia;

			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->pathname_media = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->wl_width = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->wl_height = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->wl_fps = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->wl_duree = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->wl_format = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->wl_audio_channel = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
                        wg_string_001 = wg_string_001.mid(0, 1);
			hdl_current_media->isdvd = wg_string_001.toInt();

                        if ( newData.count() == 2 )
                        {
                            hdl_current_media->issca = 0;
                        }
                        else
                        {
                            wg_string_001 = QString::fromLocal8Bit(newData);
                            wg_string_001 = wg_string_001.simplified();
                            wg_string_001 = wg_string_001.mid(1, 1);
                            hdl_current_media->issca = wg_string_001.toInt();
                        }

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->dvdsize = wg_string_001.toInt();

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->is_lock = wg_string_001.toInt();

                        /*newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->position.setX(wg_string_001.toInt());

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                        hdl_current_media->position.setY(wg_string_001.toInt());*/

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->nbre_chapitres = wg_string_001.toInt();

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->wl_vbitrate = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->wl_vbitrate_encode = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->wl_sub_path = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->oldisdvd = wg_string_001.toInt();

			// *** SYNC AUDIO/VIDEO ***

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->wl_video_sync = wg_string_001;

			// *** EFFECTS ***

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->hue = wg_string_001.toInt();

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->saturation = wg_string_001.toInt();

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->contraste = wg_string_001.toInt();

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);

			int wl_search_intro = wg_string_001.lastIndexOf( "$E" );
			if ( wl_search_intro != -1 )
			{
				hdl_current_media->lumiere = wg_string_001.mid(0,wl_search_intro).toInt();
				hdl_current_media->isdvdintro = wg_string_001.mid(wg_string_001.length()-1,1).toInt();
			}
			else
			{
				hdl_current_media->lumiere = wg_string_001.toInt();
				hdl_current_media->isdvdintro = 0;
			}

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			hdl_current_media->already_encode = wg_string_001.toInt();

			//

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			wl_explode = wg_string_001.split(";",QString::KeepEmptyParts);

			wg_int_002 = 0;

                        while ( wg_int_002 < hdl_current_media->nbre_chapitres )
			{
				hdl_current_media->chapitres[wg_int_002] = wl_explode.at(wg_int_002);
				hdl_current_media->icones_chapitres[wg_int_002].addPixmap(path_project + "/DVD/SVP/C" + QString::number(wg_int_001) + "X" + QString::number(wg_int_002) + ".png",QIcon::Normal,QIcon::On);
				wg_int_002++;
			}

			// *** CHARGEMENT DES LANGUES DU MEDIA ***
			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			wl_explode = wg_string_001.split(";",QString::KeepEmptyParts);
			wg_int_002 = 0;

                        if ( wg_string_001 != "" )
                        {
                            while ( wg_int_002 < wl_explode.count() )
                            {
                                    hdl_current_media->table_soundtrack[wg_int_002] = wl_explode.at(wg_int_002);
                                    wg_int_002++;
                            }
                        }

			if ( newmedia->image.load(path_project + "/DVD/SVP/MDI" + QString::number(wg_int_001) + ".png") == false )
			{
				qDebug() << "ERROR LOADING IMAGE BUTTON " + path_project + "/DVD/SVP/MDI" + QString::number(wg_int_001) + ".png";
			}

			if ( newmedia->miniature.load(path_project + "/DVD/SVP/MDM" + QString::number(wg_int_001) + ".png") == false )
			{
				qDebug() << "ERROR LOADING IMAGE MINIATURE " + path_project + "/DVD/SVP/MDM" + QString::number(wg_int_001) + ".png";
			}

                        newData = wmyfic.readLine(0);
                        wg_string_001 = QString::fromLocal8Bit(newData);
                        wg_string_001 = wg_string_001.simplified();
                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                        hdl_current_media->sub_pos = wg_string_001.toInt();

                        newData = wmyfic.readLine(0);
                        wg_string_001 = QString::fromLocal8Bit(newData);
                        wg_string_001 = wg_string_001.simplified();
                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                        hdl_current_media->sub_size = wg_string_001.toInt();

			combo_quoilire_media->insertItem(wg_int_001+1, hdl_current_media->pathname_media);
			combo_quoilire_media->setItemIcon(wg_int_001+1, QIcon(hdl_current_media->miniature));

                        newmedia->setGeometry((frame_mediatheque->width()-142)/2, (nbre_medias*120)+(10*(nbre_medias+1)), 142, 120);

                        if ( (nbre_medias*120)+(10*(nbre_medias+1))+120 > frame_mediatheque->height() )
                        {
                            frame_mediatheque->setGeometry(0,frame_mediatheque->geometry().y(),frame_mediatheque->width(),frame_mediatheque->height()+280);
                            if ( myeffect_global->opacity() < 1.0 )
                            {
                                QPropertyAnimation *animation = new QPropertyAnimation(myeffect_global_sb_medias, "opacity");
                                animation->setDuration(1000);
                                animation->setStartValue(qreal(0.0));
                                animation->setEndValue(qreal(1.0));
                                animation->start();
                            }
                        }

			newmedia->show();
			//newmedia->hdlpar = frame_mediatheque;
			newmedia->repaint();

			// *** CONNECTION DES EVENTS ***

			connect(newmedia, SIGNAL(delete_media(media*) ),this, SLOT(f_delete_media(media*)));
			connect(newmedia, SIGNAL(thumbnail_media(media*) ),this, SLOT(f_thumbnail_media(media*)));
			connect(newmedia, SIGNAL(chapitre_media(media*) ),this, SLOT(f_chapitre_media(media*)));
			connect(newmedia, SIGNAL(select_media(media*,int) ),this, SLOT(f_select_media(media*,int)));
			connect(newmedia, SIGNAL(affiche_info(media*) ),this, SLOT(f_affiche_info(media*)));
			connect(newmedia, SIGNAL(cache_info(media*) ),this, SLOT(f_cache_info(media*)));
			connect(newmedia, SIGNAL(encode_media(media*) ),this, SLOT(f_encode_media(media*)));
			connect(newmedia, SIGNAL(soundtrack(media*) ),this, SLOT(f_affiche_language(media*)));
			connect(newmedia, SIGNAL(effets(media*) ),this, SLOT(f_effets_media(media*)));
			connect(newmedia, SIGNAL(introdvd(media*) ),this, SLOT(f_introdvd(media*)));
                        connect(newmedia, SIGNAL(sca_media(media*) ),this, SLOT(f_scamedia(media*)));

			// *** CREATION DU MEDIA DANS L'ARBORESCENCE ***
                        item_media *newmediaarb = new item_media(frame_syno);
			if ( nbre_medias == 0 && nbre_menuth == 0 )
			{
				newmediaarb->setGeometry( 2, 0, 142, 120 );
			}
			else
			{
				int wl_calcpos = 2+(150*((nbre_medias + nbre_menuth)-1));
				int wl_multi = 1;
                                if ( wl_calcpos > 780 )
                                {
                                        wl_multi = ((float)wl_calcpos/(float)780);
                                        wl_calcpos = wl_calcpos - (wl_multi*780);
                                        newmediaarb->setGeometry( 2+wl_calcpos, 150*(wl_multi+1), 142, 120 );
                                }
                                else
                                {
                                        newmediaarb->setGeometry( wl_calcpos, 150*wl_multi, 142, 120 );
                                }
			}
			connect(newmediaarb, SIGNAL(item_move(item_media*) ),this, SLOT(f_itemmedia_move(item_media*)));
			connect(newmediaarb, SIGNAL(sg_ren_media(media*) ),this, SLOT(f_itemmedia_ren(media*)));
			newmediaarb->hdlmedia = newmedia;
                        newmediaarb->fond = newmedia->image;
			newmediaarb->show();
                        frame_syno->tab_pnt_media[nbre_medias] = newmediaarb;

			nbre_medias++;
			wg_int_001++;
			// *** RECALCUL DE LA JAUGE ***
			f_calcul_jauge(hdl_current_media->dvdsize);

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			if ( wg_string_001.mid(0,3) != "---" )
			{
				QMessageBox::information(this, name_application, tr("Sauvegarde du projet corrompue. Le chargement rique d'etre eronne."));
				qDebug() << wg_string_001;
			}
			else
			{
				newData = wmyfic.readLine(0);
			}
		}
		wmyfic.close();
	}
	// *** CHARGEMENT DES MENUS ***

	wmyfic.setFileName(path_project + "/DVD/SVP/prj_bou.x");
	if ( !wmyfic.open( QIODevice::ReadOnly ))
	{
		qDebug() << "ERROR OPENING MENUS IN : " + path_project;
		return;
	}
	else
	{
		newData = wmyfic.readLine(0);
		wg_int_001 = 0;
		while ( wmyfic.atEnd() == false )
		{
                    qDebug() << "BBBBB";
			f_create_new_menu();
			table_hdl_menuth[nbre_menuth] = hdl_current_menuth;
			hdl_current_menuth->setGeometry( 2+(nbre_menuth*106), 0, 106, 106);
			hdl_current_menuth->draw_image = QPixmap(path_project + "/DVD/SVP/MTH" + QString::number(wg_int_001) + ".png");
			if ( nbre_menuth == 0 )
			{
				hdl_current_menuth->is_edit = 1;
			}
			else
			{
				hdl_current_menuth->is_edit = 0;
			}
			hdl_current_menuth->is_first = nbre_menuth + 1;
			hdl_current_menuth->show();

			if ( nbre_menuth > 0 )
			{
				combo_quoilire_menu->insertItem(nbre_menuth+1,"Menu " + QString::number(nbre_menuth));
			}

			wg_string_001 = QString::fromLocal8Bit(newData);

                        //wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			table_menus_property[wg_int_001][0] = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);

			if ( table_menus_property[wg_int_001][0] != "" )
			{
				table_menus_property[wg_int_001][1] = wg_string_001;
                                if ( table_menus_property[wg_int_001][0].right(5) == ".MPEG" || table_menus_property[wg_int_001][0].right(5) == ".mpeg" || table_menus_property[wg_int_001][0].right(4) == ".MPG" || table_menus_property[wg_int_001][0].right(4) == ".mpg" || table_menus_property[wg_int_001][0].right(4) == ".AVI" || table_menus_property[wg_int_001][0].right(4) == ".avi" || table_menus_property[wg_int_001][0].right(4) == ".MP4" || table_menus_property[wg_int_001][0].right(4) == ".mp4" )
				{
			   		wg_int_002 = table_menus_property[wg_int_001][0].lastIndexOf( '/' );
			    		if ( wg_int_002 != -1 )
			    		{
                                                if ( QFile::copy ( path_project+"/DVD/SVP/"+table_menus_property[wg_int_001][0].mid(wg_int_002+1,table_menus_property[wg_int_001][0].length()-(wg_int_002+1))+".jpg", path_project+"/DVD/TEMP/"+table_menus_property[wg_int_001][0].mid(wg_int_002+1,table_menus_property[wg_int_001][0].length()-(wg_int_002+1)) + ".jpg" ) )
						{
						}
						else
						{
							qDebug() << "ERROR COPYING THUMBNAIL IMAGE OF ANIMATED BACKGROUND MENU IN OPENING PROJECT";
							qDebug() << path_project+"/DVD/SVP/"+table_menus_property[wg_int_001][0].mid(wg_int_002+1,table_menus_property[wg_int_001][0].length()-(wg_int_002+1))+".jpg" << " " << path_project+"/DVD/TEMP/"+table_menus_property[wg_int_001][0].mid(wg_int_002+1,table_menus_property[wg_int_001][0].length()-(wg_int_002+1)) + ".jpg";
                                                }
					}
				}

				if (nbre_menuth == 0 )
				{
                                        if ( table_menus_property[wg_int_001][0].right(5) == ".MPEG" || table_menus_property[wg_int_001][0].right(5) == ".mpeg" || table_menus_property[wg_int_001][0].right(4) == ".MPG" || table_menus_property[wg_int_001][0].right(4) == ".mpg" || table_menus_property[wg_int_001][0].right(4) == ".AVI" || table_menus_property[wg_int_001][0].right(4) == ".avi" || table_menus_property[wg_int_001][0].right(4) == ".MP4" || table_menus_property[wg_int_001][0].right(4) == ".mp4" )
					{
						current_menu_background = table_menus_property[wg_int_001][0];
				   		wg_int_002 = current_menu_background.lastIndexOf( '/' );

                                                if ( wg_int_002 != -1 )
                                                {
                                                    background_menu->setPixmap(path_project+"/DVD/TEMP/"+current_menu_background.mid(wg_int_002+1,current_menu_background.length()-(wg_int_002+1))+".jpg");
                                                }
						else
						{
							qDebug() << "ERROR IN BACKGROUND NAME NO / : " << current_menu_background;
							background_menu->setPixmap(QPixmap(path_project+"/DVD/TEMP/nofd.png"));
						}
					}
					else
					{
						current_menu_background = table_menus_property[wg_int_001][0];
						scale_current_menu_background = wg_string_001.toInt();

                                                if ( scale_current_menu_background != 2 || table_menus_property[wg_int_001][0].mid(0,1) != " " )
                                                {
                                                    f_generation_scale();
                                                }
                                                else
                                                {
                                                    wl_explode = table_menus_property[wg_int_001][0].split(" ", QString::SkipEmptyParts);
                                                    QPixmap wl_img_001(dvdxsize,dvdysize);

                                                    QString wl_red = wl_explode[0];
                                                    QString wl_green = wl_explode[1];
                                                    QString wl_blue = wl_explode[2];
                                                    QString wl_red_2 = wl_explode[3];
                                                    QString wl_green_2 = wl_explode[4];
                                                    QString wl_blue_2 = wl_explode[5];
                                                    QString wl_checked = wl_explode[6];

                                                    QPainter p;
                                                    p.begin(&wl_img_001);
                                                    p.setPen(Qt::NoPen);
                                                    p.setRenderHint(QPainter::Antialiasing,true);

                                                    if ( wl_checked == "0" )
                                                    {
                                                        QLinearGradient Gradient1(0.0,0.0,0.0,wl_img_001.height());
                                                        Gradient1.setColorAt(0.0, QColor(wl_red.toInt(),wl_green.toInt(),wl_blue.toInt(),255));
                                                        Gradient1.setColorAt(1.0, QColor(wl_red_2.toInt(),wl_green_2.toInt(),wl_blue_2.toInt(),255));
                                                        p.setBrush(Gradient1);
                                                    }
                                                    else
                                                    {
                                                        QRadialGradient Gradient1(dvdxsize/2,dvdysize/2,dvdxsize/2,dvdxsize/2,dvdysize/2);
                                                        Gradient1.setColorAt(0.0, QColor(wl_red.toInt(),wl_green.toInt(),wl_blue.toInt(),255));
                                                        Gradient1.setColorAt(1.0, QColor(wl_red_2.toInt(),wl_green_2.toInt(),wl_blue_2.toInt(),255));
                                                        p.setBrush(Gradient1);
                                                    }

                                                    p.drawRect(0, 0, wl_img_001.width(), wl_img_001.height());
                                                    p.end();

                                                    background_menu->setPixmap(wl_img_001);
                                                }
					}
				}
			}
			else
			{
				table_menus_property[wg_int_001][1] = "";
				background_menu->setPixmap(QPixmap(path_project+"/DVD/TEMP/nofd.png"));;
			}
			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			table_menus_property[wg_int_001][2] = wg_string_001;

			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			table_menus_property[wg_int_001][3] = wg_string_001;

			if ( nbre_menuth == 0 )
			{
				QString wl_str_001 = table_menus_property[wg_int_001][2];
				QStringList wl_explode = wl_str_001.split(";",QString::KeepEmptyParts);
				pntwheel1->setColor(wl_explode.at(0).toInt(),wl_explode.at(1).toInt(),wl_explode.at(2).toInt());

				wl_str_001 = table_menus_property[wg_int_001][3];
				wl_explode = wl_str_001.split(";",QString::KeepEmptyParts);
				pntwheel2->setColor(wl_explode.at(0).toInt(),wl_explode.at(1).toInt(),wl_explode.at(2).toInt());
			}

			newData = wmyfic.readLine(0); // *** AUDIO ***
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			table_menus_property[wg_int_001][4] = wg_string_001;

			newData = wmyfic.readLine(0); // *** VIDEO D'INTRO ***
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			table_menus_property[wg_int_001][5] = wg_string_001;

			newData = wmyfic.readLine(0); // *** OPACITE DES OVERLAYS ***
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			table_menus_property[wg_int_001][6] = wg_string_001;

			newData = wmyfic.readLine(0); // *** LOOP DU MENU ***
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			table_menus_property[wg_int_001][7] = wg_string_001;

			newData = wmyfic.readLine(0); // *** MUSIQUE TRANSITION CALCULEE ***
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.simplified();
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			table_menus_property[wg_int_001][8] = wg_string_001;

                        newData = wmyfic.readLine(0); // *** DESSIN FOND DU MENU ***
                        wg_string_001 = QString::fromLocal8Bit(newData);
                        wg_string_001 = wg_string_001.simplified();
                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                        table_menus_property[wg_int_001][9] = wg_string_001;

			if ( nbre_menuth == 0 )
			{
				current_menu_audio = table_menus_property[wg_int_001][4];

				if ( current_menu_audio != "" )
				{
					screen_designer->has_sound = 1;
				}
				else
				{
					screen_designer->has_sound = 0;
				}

				current_menu_intro = table_menus_property[wg_int_001][5];
				current_loop = table_menus_property[wg_int_001][7].mid(0,1).toInt();
				loop_length = table_menus_property[wg_int_001][7].mid(1,table_menus_property[wg_int_001][7].length()-1).toInt();
				dial_opacity_overlay->setValue(table_menus_property[wg_int_001][6].toInt());
                                current_pencil_draw = table_menus_property[wg_int_001][9];

                                if ( current_pencil_draw == "" )
                                {
                                    QPixmap wl_pix_001(dvdxsize,dvdysize);
                                    wl_pix_001.fill(QColor(0,0,0,0));
                                    frame_pencil_draw->setPixmap(wl_pix_001);
                                    frame_support_drawing_menu->draw_user = wl_pix_001.toImage();
                                }
                                else
                                {
                                    QPixmap wl_pix_001(path_project + "/DVD/SVP/" + current_pencil_draw);
                                    frame_pencil_draw->setPixmap(wl_pix_001);
                                    frame_support_drawing_menu->draw_user = wl_pix_001.toImage();
                                }

				if ( current_menu_intro == "" )
				{
					is_is_intro->setToolTip("");
					is_is_intro->is_active = 0;
					is_is_intro->repaint();
					screen_designer->has_intro = 0;
				}
				else
				{
					is_is_intro->setToolTip(current_menu_intro);
					is_is_intro->is_active = 1;
					is_is_intro->repaint();
					screen_designer->has_intro = 1;
				}

				if ( current_menu_audio == "" )
				{
					is_is_sound->setToolTip("");
					is_is_sound->is_active = 0;
					is_is_sound->repaint();
				}
				else
				{
					is_is_sound->setToolTip(current_menu_audio);
					is_is_sound->is_active = 1;
					is_is_sound->repaint();
				}
			}

			newData = wmyfic.readLine(0); 
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);

			wg_int_002 = 0;

			while ( wg_string_001.mid(0,3) != "---" )
			{
                            qDebug() << "CCCCCC";
				wl_explode = wg_string_001.split(";",QString::KeepEmptyParts);
				table_menus[wg_int_001][wg_int_002][0] = wl_explode.at(0);
				table_menus[wg_int_001][wg_int_002][1] = wl_explode.at(1);
				table_menus[wg_int_001][wg_int_002][2] = wl_explode.at(2);
				table_menus[wg_int_001][wg_int_002][3] = wl_explode.at(3);
				//table_menus[wg_int_001][wg_int_002][4] = wl_explode.at(4);
				table_menus[wg_int_001][wg_int_002][5] = wl_explode.at(5);
				table_menus[wg_int_001][wg_int_002][6] = wl_explode.at(6);
				table_menus[wg_int_001][wg_int_002][7] = wl_explode.at(7);
				table_menus[wg_int_001][wg_int_002][8] = wl_explode.at(8);
				table_menus[wg_int_001][wg_int_002][9] = wl_explode.at(9);
				table_menus[wg_int_001][wg_int_002][10] = wl_explode.at(10);
				table_menus[wg_int_001][wg_int_002][11] = wl_explode.at(11);
				table_menus[wg_int_001][wg_int_002][12] = wl_explode.at(12);
				table_menus[wg_int_001][wg_int_002][13] = wl_explode.at(13);
				table_menus[wg_int_001][wg_int_002][14] = wl_explode.at(14);
				table_menus[wg_int_001][wg_int_002][15] = wl_explode.at(15);
				table_menus[wg_int_001][wg_int_002][16] = wl_explode.at(16);
				table_menus[wg_int_001][wg_int_002][17] = wl_explode.at(17);
				table_menus[wg_int_001][wg_int_002][18] = wl_explode.at(18);
				table_menus[wg_int_001][wg_int_002][19] = wl_explode.at(19);
				table_menus[wg_int_001][wg_int_002][20] = wl_explode.at(20);
				table_menus[wg_int_001][wg_int_002][21] = wl_explode.at(21);
				table_menus[wg_int_001][wg_int_002][22] = wl_explode.at(22);
				table_menus[wg_int_001][wg_int_002][23] = wl_explode.at(23);
				table_menus[wg_int_001][wg_int_002][24] = wl_explode.at(24);
				table_menus[wg_int_001][wg_int_002][25] = wl_explode.at(25);
                                table_menus[wg_int_001][wg_int_002][26] = wl_explode.at(26);

				newData = wmyfic.readLine(0);
				wg_string_001 = QString::fromLocal8Bit(newData);
				wg_string_001 = wg_string_001.simplified();
				wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
				
				wg_string_001.replace(QString("$-E#"),QString("\n"));
				//wg_string_001.replace(QString("\n"),QString(""));

				table_menus[wg_int_001][wg_int_002][4] = wg_string_001;
				if (nbre_menuth == 0 )
				{
					f_create_menu_movie();
				}

				wg_int_002++;
				//
				newData = wmyfic.readLine(0);
				wg_string_001 = QString::fromLocal8Bit(newData);
				wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			}

			table_menus[wg_int_001][wg_int_002][0] = "$$$";

			wg_int_001++;
			nbre_menuth++;
			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
		}

		nbre_menuth--;
		hdl_current_menuth = table_hdl_menuth[0];
		wmyfic.close();
	}

	// *** CHARGEMENT DES MENUS DANS L'ARBRE ***
	wmyfic.setFileName(path_project + "/DVD/SVP/prj_arb.x");
	if ( !wmyfic.open( QIODevice::ReadOnly ))
	{
	}
	else
	{
		newData = wmyfic.readLine(0);
		wg_string_001 = QString::fromLocal8Bit(newData);
		wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
		wg_int_001 = 0;
		while ( wmyfic.atEnd() == false )
		{
			frame_syno->tab_pnt_item[wg_int_001]->setGeometry(wg_string_001.toInt(),0,frame_syno->tab_pnt_item[wg_int_001]->width(),frame_syno->tab_pnt_item[wg_int_001]->height());
			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			frame_syno->tab_pnt_item[wg_int_001]->setGeometry(frame_syno->tab_pnt_item[wg_int_001]->geometry().x(),wg_string_001.toInt(),frame_syno->tab_pnt_item[wg_int_001]->width(),frame_syno->tab_pnt_item[wg_int_001]->height());
			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			wg_int_001++;
		}
		wmyfic.close();
	}

	// *** CHARGEMENT DES MEDIAS DANS L'ARBRE ***
	wmyfic.setFileName(path_project + "/DVD/SVP/med_arb.x");
	if ( !wmyfic.open( QIODevice::ReadOnly ))
	{
	}
	else
	{
		newData = wmyfic.readLine(0);
		wg_string_001 = QString::fromLocal8Bit(newData);
		wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
		wg_int_001 = 0;
		while ( wmyfic.atEnd() == false )
		{
			frame_syno->tab_pnt_media[wg_int_001]->setGeometry(wg_string_001.toInt(),0,frame_syno->tab_pnt_media[wg_int_001]->width(),frame_syno->tab_pnt_media[wg_int_001]->height());
			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			frame_syno->tab_pnt_media[wg_int_001]->setGeometry(frame_syno->tab_pnt_media[wg_int_001]->geometry().x(),wg_string_001.toInt(),frame_syno->tab_pnt_media[wg_int_001]->width(),frame_syno->tab_pnt_media[wg_int_001]->height());
			newData = wmyfic.readLine(0);
			wg_string_001 = QString::fromLocal8Bit(newData);
			wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			wg_int_001++;
		}
		wmyfic.close();
	}

        if ( ((nbre_menuth+1)*110) > frame_support_menu_th_contain->width()-30 )
	{
		frame_support_menuthumb->setGeometry(0,0,((nbre_menuth+1)*110),106);
		scroll_timeline->setMaximum(((nbre_menuth+1)*110)-frame_support_menu_th_contain->width());
		scroll_timeline->setEnabled(true);
                scroll_timeline->show();
	}
	else
	{
		frame_support_menuthumb->setGeometry(0,0,frame_support_menu_th_contain->width(),106);
		scroll_timeline->setMaximum(0);
		scroll_timeline->setDisabled(true);
                scroll_timeline->hide();
	}

	actionEnregistrer_2->setEnabled(true);
	this->setEnabled(true);
	hdl_current_menu = 0;
	must_update = 1;


        // *** ON PLACE LES CADENAS SUR LES MEDIAS ***
        f_save_widgetonmenu();

        int wl_int_008;
        int wl_int_009=0;
        int wl_int_010=0;
        int wl_int_011=0;
        int wl_int_012=0;

        while ( wl_int_009 <= nbre_medias-1 )
        {
                wl_int_010 = 0;
                wl_int_011 = 0;

                while ( wl_int_010 <= nbre_menuth && wl_int_011 == 0 )
                {
                        wl_int_012 = 0;
                        while ( table_menus[wl_int_010][wl_int_012][0] != "$$$" && wl_int_012 == 0 )
                        {
                                if ( table_menus[wl_int_010][wl_int_012][5] == table_hdl_medias[wl_int_009]->pathname_media )
                                {
                                        wl_int_011 = 1;
                                }
                                wl_int_008 = table_menus[wl_int_010][wl_int_012][22].lastIndexOf( table_hdl_medias[wl_int_009]->pathname_media );

                                if ( wl_int_008 != -1 )
                                {
                                        wl_int_011 = 1;
                                }
                                wl_int_012++;
                        }
                        wl_int_010++;
                }
                if ( wl_int_011 == 0 )
                {
                        table_hdl_medias[wl_int_009]->is_lock = 0;
                }
                else
                {
                        table_hdl_medias[wl_int_009]->is_lock = 1;
                }
                wl_int_009++;
        }

        hdl_current_media = 0;
}

void mainfrm::f_create_new_menu()
{
	menu_th *newmenu = new menu_th(frame_support_menuthumb);
	connect(newmenu, SIGNAL(select_menuth(menu_th*) ),this, SLOT(f_select_menuth(menu_th*)));
        connect(newmenu, SIGNAL(delete_menuth(menu_th*) ),this, SLOT(f_delete_menuth(menu_th*)));
        connect(newmenu, SIGNAL(dupliquer_menuth(menu_th*) ),this, SLOT(f_dupliquer_menuth(menu_th*)));
	hdl_current_menuth = newmenu;

	item_menu *newmenuarb = new item_menu(frame_syno);
	if ( nbre_menuth == 0 && nbre_medias == 0 )
	{
		newmenuarb->setGeometry( 2, 0, 106, 106 );
	}
	else
	{
		newmenuarb->setGeometry( 2+(110*((nbre_medias + nbre_menuth)-1)), 110, 106, 106 );
	}
        newmenuarb->num_menu = nbre_menuth;
	connect(newmenuarb, SIGNAL(item_move(item_menu*) ),this, SLOT(f_item_move(item_menu*)));
	connect(newmenuarb, SIGNAL(item_select(item_menu*) ),this, SLOT(f_item_select(item_menu*)));
	connect(newmenuarb, SIGNAL(add_link(item_menu*,int) ),this, SLOT(f_add_link(item_menu*,int)));
	connect(newmenuarb, SIGNAL(add_link_media(item_menu*,QString) ),this, SLOT(f_add_link_media(item_menu*,QString)));
	connect(newmenuarb, SIGNAL(edit_menu_tree(item_menu*) ),this, SLOT(f_edit_menu_tree(item_menu*)));
	newmenuarb->show();
	frame_syno->tab_pnt_item[nbre_menuth] = newmenuarb;
}

void mainfrm::f_dupliquer_menuth(menu_th *hdlm)
{
    if ( nbre_menuth < 19 )
    {
            // *** AJOUT D'UN MENU AU PROJET DVD ***
            must_update = 0;
            f_update_thumb_menu();
            nbre_menuth++;

            // *** SAUVEGARDE DES INFORMATIONS DU MENU ***
            f_save_widgetonmenu();
            // *** CREATION MINIATURE DU NOUVEAU MENU ***
            menu_th *newmenu = new menu_th(frame_support_menuthumb);
            newmenu->setGeometry( 2+(nbre_menuth*106), 0, 106, 106 );
            newmenu->draw_image = QPixmap(path_project+"/DVD/TEMP/nofd.png").scaledToWidth ( 88, Qt::FastTransformation );
            //newmenu->draw_image.fill(QColor(0,0,0));
            newmenu->is_edit = 0;
            newmenu->is_first = nbre_menuth + 1;
            newmenu->show();
            table_hdl_menuth[nbre_menuth] = newmenu;
            connect(newmenu, SIGNAL(select_menuth(menu_th*) ),this, SLOT(f_select_menuth(menu_th*)));
            connect(newmenu, SIGNAL(delete_menuth(menu_th*) ),this, SLOT(f_delete_menuth(menu_th*)));
            connect(newmenu, SIGNAL(dupliquer_menuth(menu_th*) ),this, SLOT(f_dupliquer_menuth(menu_th*)));
            //hdl_current_menuth = newmenu;

            // *** CREATION DU MENU DANS L'ARBORESCENCE ***
            item_menu *newmenuarb = new item_menu(frame_syno);
            if ( nbre_menuth == 0 && nbre_medias == 0 )
            {
                    newmenuarb->setGeometry( 2, 0, 106, 106 );
            }
            else
            {
                    int wl_calcpos = 2+(110*((nbre_medias+nbre_menuth)-1));
                    int wl_multi = 1;
                    if ( wl_calcpos > 780 )
                    {
                            wl_multi = ((float)wl_calcpos/(float)780);
                            wl_calcpos = wl_calcpos - (wl_multi*780);
                            newmenuarb->setGeometry( 2+wl_calcpos, 110*(wl_multi+1), 106, 106 );
                    }
                    else
                    {
                            newmenuarb->setGeometry( wl_calcpos, 110*wl_multi, 106, 106 );
                    }
            }
            connect(newmenuarb, SIGNAL(item_move(item_menu*) ),this, SLOT(f_item_move(item_menu*)));
            connect(newmenuarb, SIGNAL(item_select(item_menu*) ),this, SLOT(f_item_select(item_menu*)));
            connect(newmenuarb, SIGNAL(add_link(item_menu*,int) ),this, SLOT(f_add_link(item_menu*,int)));
            connect(newmenuarb, SIGNAL(add_link_media(item_menu*,QString) ),this, SLOT(f_add_link_media(item_menu*,QString)));
            connect(newmenuarb, SIGNAL(edit_menu_tree(item_menu*) ),this, SLOT(f_edit_menu_tree(item_menu*)));
            newmenuarb->show();
            frame_syno->tab_pnt_item[nbre_menuth] = newmenuarb;
            frame_syno->tab_pnt_item[nbre_menuth]->num_menu = nbre_menuth;

            int wl_int_001 = 0;
            while ( wl_int_001 < nbre_medias )
            {
                    frame_syno->tab_pnt_item[nbre_menuth]->table_medias[wl_int_001] = table_hdl_medias[wl_int_001]->pathname_media;
                    wl_int_001++;
            }

            wl_int_001 = 0;
            while ( wl_int_001 <= nbre_menuth )
            {
                    frame_syno->tab_pnt_item[wl_int_001]->nbre_menus = nbre_menuth;
                    wl_int_001++;
            }

            combo_quoilire_menu->insertItem(nbre_menuth+1,"Menu " + QString::number(nbre_menuth));

            //current_menu_background = path_project+"/DVD/TEMP/nofd.png";
            //scale_current_menu_background = 0;
            //background_menu->setPixmap(QPixmap(current_menu_background));

            must_update = 1;

            if ( ((nbre_menuth+1)*110) > frame_support_menu_th_contain->width()-30 )
            {
                    frame_support_menuthumb->setGeometry(0,0,((nbre_menuth+1)*110),106);
                    scroll_timeline->setMaximum(((nbre_menuth+1)*110)-frame_support_menu_th_contain->width());
                    scroll_timeline->setEnabled(true);
                    scroll_timeline->show();
            }
            else
            {
                    frame_support_menuthumb->setGeometry(0,0,frame_support_menu_th_contain->width(),106);
                    scroll_timeline->setMaximum(0);
                    scroll_timeline->setDisabled(true);
                    scroll_timeline->hide();
            }
            //f_update_thumb_menu();
    }
    else
    {
            QMessageBox::information(this, name_application, tr("Vous ne pouvez plus ajouter de nouveaux menus. Maximum atteint."));
            return;
    }
    //f_add_menu();

    int wl_int_001=0;
    while ( table_hdl_menuth[wl_int_001] != hdlm && wl_int_001 < nbre_menuth )
    {
            wl_int_001++;
    }

    table_hdl_menuth[nbre_menuth]->draw_image = table_hdl_menuth[wl_int_001]->draw_image;

    table_menus_property[nbre_menuth][0] = table_menus_property[wl_int_001][0];
    table_menus_property[nbre_menuth][1] = table_menus_property[wl_int_001][1];
    table_menus_property[nbre_menuth][2] = table_menus_property[wl_int_001][2];
    table_menus_property[nbre_menuth][3] = table_menus_property[wl_int_001][3];
    table_menus_property[nbre_menuth][4] = table_menus_property[wl_int_001][4];
    table_menus_property[nbre_menuth][5] = table_menus_property[wl_int_001][5];
    table_menus_property[nbre_menuth][6] = table_menus_property[wl_int_001][6];
    table_menus_property[nbre_menuth][7] = table_menus_property[wl_int_001][7];
    table_menus_property[nbre_menuth][8] = table_menus_property[wl_int_001][8];
    table_menus_property[nbre_menuth][9] = table_menus_property[wl_int_001][9];

    int wl_int_002 = 0;
    int wl_int_003 = 0;

    while ( table_menus[wl_int_001][wl_int_002][0] != "$$$" )
    {
            wl_int_003 = 0;
            while ( wl_int_003 < 27 )
            {
                    table_menus[nbre_menuth][wl_int_002][wl_int_003] = table_menus[wl_int_001][wl_int_002][wl_int_003];
                    wl_int_003++;
            }
            wl_int_002++;
    }
    table_menus[nbre_menuth][wl_int_002][0] = "$$$";
    table_hdl_menuth[nbre_menuth]->repaint();
}


// **********************
// *** NOUVEAU PROJET ***
// **********************
void mainfrm::f_new_1()
{
	frame_editor->lower();
	frame_editor->show();

        if ( frame_smile->isVisible() == false )
        {
            f_init_proj();
        }
        else
        {
            // *** SUPPRESSION DES VIGNETTES DE DIAPOS ***
            delete pntmygl;

            if ( nbre_audio_track > 0 )
            {
                delete hdl_audio;
            }

            int wl_int_001 = 0;
            while ( wl_int_001 < nbre_diapos )
            {
                delete table_hdl_diapo[wl_int_001];
                wl_int_001++;
            }
            nbre_diapos = 0;

            frame_smile->hide();
            menuEdition->setEnabled(true);
            menuAffichage->setEnabled(true);
            menuInsertion->setEnabled(true);
            menuMenu->setEnabled(true);
            menuMenu->show();
            menuG_n_ration->setEnabled(true);
            menuA_propos->setEnabled(true);

            actionOuvrir->setEnabled(true);
            actionEnregistrer->setEnabled(true);
            actionEnregistrer_2->setEnabled(true);

            actionAfficher_cacher_les_coordonn_es->setEnabled(true);
            actionAfficher_cacher_les_r_gles->setEnabled(true);
            actionAfficher_cacher_les_zones_de_s_curit->setEnabled(true);
            actionAfficher_cacher_les_contours->setEnabled(true);
            actionArborescence_du_projet->setEnabled(true);
            actionReinitialiser_les_coordonn_es->setEnabled(true);
        }
        //smenuBar->setDisabled(true);

	// *** MASK DE FOND ***
        //mask_interface->show();
        //mask_interface->raise();

        // *** PREPARATION DE L'INTERFACE POUR DEMARRAGE DE 2MANDVD ***
        smenuBar->hide();
        //this->setGeometry((QApplication::desktop()->width()-frame_new_proj->width())/2,(QApplication::desktop()->height()-frame_new_proj->height())/2,frame_new_proj->width(),frame_new_proj->height());
        this->setGeometry((QApplication::desktop()->screenGeometry(0).width()-frame_new_proj->width())/2,(QApplication::desktop()->screenGeometry(0).height()-frame_new_proj->height())/2,frame_new_proj->width(),frame_new_proj->height());
        this->setMinimumSize(frame_new_proj->width(),frame_new_proj->height());
        this->setMaximumSize(frame_new_proj->width(),frame_new_proj->height());
        frame_new_proj->setGeometry(0,0,frame_new_proj->width(),frame_new_proj->height());

	// *** AFFICHAGE DE LA FENETRE NOUVEAU PROJET ***
        actionDiaporama_automatique->setDisabled(true);
        actionReinitialiser_les_coordonn_es->setDisabled(true);
        actionAjouter_une_diapositive->setDisabled(true);
        actionAfficher_cacher_grille_de_placement->setDisabled(true);
        actionAjouter_un_bouton->setEnabled(true);
        actionAjouter_plusieurs_boutons->setEnabled(true);
        actionAjouter_une_zone_de_texte->setEnabled(true);
	frame_new_proj->show();
	frame_new_proj->raise();
}

// **********************************
// *** REINITIALISATION DU PROJET ***
// **********************************

void mainfrm::f_init_proj()
{
	f_delete_widgetonmenu();
        frame_render_smile->hide();

	// *** DELETE DES MEDIAS ***

	wg_int_001 = 0;
	while ( wg_int_001 < nbre_medias )
	{
		delete table_hdl_medias[wg_int_001];
                delete frame_syno->tab_pnt_media[wg_int_001];
		wg_int_001++;
	}
	nbre_medias = 0;

	// *** DELETE MENUS ***
	wg_int_001 = 0;
	while ( wg_int_001 <= nbre_menuth )
	{
		delete table_hdl_menuth[wg_int_001];
		delete frame_syno->tab_pnt_item[wg_int_001];
		wg_int_001++;
	}

        QPixmap wl_pix_001(dvdxsize,dvdysize);
        wl_pix_001.fill(QColor(0,0,0,0));
        frame_pencil_draw->setPixmap(wl_pix_001);
        frame_support_drawing_menu->draw_user = wl_pix_001.toImage();
        current_pencil_draw = "";

	nbre_menuth = 0;
	nbre_menus_wo_label = 0;
	current_menu_background = "";
	scale_current_menu_background = 0;
	current_menu_audio = "";
	current_menu_intro = "";
	hdl_current_menu = 0;
	nbre_medias = 0;
	actionOrdre_de_tabulation->setDisabled(true);

	must_update = 0;
	bttxt->setPlainText("");
	combo_quoilire_media->clear();
	combo_quoilire_media_chapitre->clear();
	combo_select_langue->clear();
	combo_quoilire_menu->clear();
	combo_quoilire_media->insertItem(0,wg_str_int_002);
	combo_quoilire_menu->insertItem(0,wg_str_int_002);
	combo_quoilire_menu->insertItem(1,wg_str_int_003);
	check_anim->setChecked(false);

	must_update = 1;

	actionCopier_le_bouton->setDisabled(true);
	actionColler_le_bouton->setDisabled(true);
	check_anim->setDisabled(true);
	bt_bt_img->setDisabled(true);
	dial_alpha_menu->setDisabled(true);
	combo_quoilire_media->setDisabled(true);
	combo_quoilire_media_chapitre->setDisabled(true);
	combo_select_langue->setDisabled(true);
	combo_quoilire_menu->setDisabled(true);
	bttxt->setDisabled(true);
	frame_th_msk_idea->setDisabled(true);

        actionAfficher_cacher_les_r_gles->setChecked( userSettings::getDisplayOption( userSettings::DISPLAY_RULE ) );
        displayRegle( userSettings::getDisplayOption( userSettings::DISPLAY_RULE ) );
        actionAfficher_cacher_les_coordonn_es->setChecked( userSettings::getDisplayOption( userSettings::DISPLAY_COORD ) );
        displayCoord( userSettings::getDisplayOption( userSettings::DISPLAY_COORD ) );
        actionAfficher_cacher_les_zones_de_s_curit->setChecked( userSettings::getDisplayOption( userSettings::DISPLAY_ZONE ) );
        displayZone( userSettings::getDisplayOption( userSettings::DISPLAY_ZONE ) );
        actionAfficher_cacher_les_contours->setChecked( userSettings::getDisplayOption( userSettings::DISPLAY_SHAPE ) );
        displayContours( userSettings::getDisplayOption( userSettings::DISPLAY_SHAPE ) );
}

void mainfrm::f_resize_project()
{
    smenuBar->show();
    frame_editor->show();
    this->setWindowTitle(tr("2ManDVD - Creation de DVD Videos"));
    this->setMinimumSize(dvdxsize+frame_pro->width(),dvdysize+bottom_menu->height()+smenuBar->height());
    this->setMaximumSize(dvdxsize+frame_pro->width(),dvdysize+bottom_menu->height()+smenuBar->height());
    this->setGeometry((QApplication::desktop()->screenGeometry(0).width()-(dvdxsize+frame_pro->width()))/2,(QApplication::desktop()->screenGeometry(0).height()-(dvdysize+bottom_menu->height()))/2,dvdxsize+frame_pro->width(),dvdysize+bottom_menu->height()+smenuBar->height());

    frame_infos->hide();
    scroll_timeline->hide();

    frame_mediatheque->dvdysize = dvdysize;

    bottom_menu->setGeometry(0,this->height()-(bottom_menu->height()+smenuBar->height()),this->width(),bottom_menu->height());
    frame_pro->setGeometry(this->width()-frame_pro->width(),0,frame_pro->width(),bottom_menu->geometry().y());
    frame_editor->setGeometry(0,0,this->width(),this->height());
    jauge_dvd->setGeometry(0,bottom_menu->geometry().y()-9,80,80);
    //frame_advanced_text->setGeometry(this->width()-(frame_pro->width()+frame_advanced_text->width()+10),100,frame_advanced_text->width(),frame_advanced_text->height());
    frame_advanced_text->setGeometry(frame_pro->width(),110,frame_advanced_text->width(),frame_advanced_text->height());

    frame_top_tool->setGeometry((this->width()-frame_pro->width()-frame_top_tool->width())/2,-8,frame_top_tool->width(),frame_top_tool->height());
    frame_top_tool->show();
    frame_top_tool->raise();
    bt_opc_render->setGeometry((this->width()-48)/2,(bottom_menu->height()-48)/2,bt_opc_render->width(),bt_opc_render->height());
    bt_view_infos->setGeometry(bt_opc_render->geometry().x()-20,5,bt_view_infos->width(),bt_view_infos->height());

    frame_licence->setGeometry((this->width()-frame_licence->width())/2,(this->height()-frame_licence->height())/2,frame_licence->width(),frame_licence->height());

    frame_drawing_menu->setGeometry(0,0,this->width(),this->height()-smenuBar->height());
    frame_tool_drawing_menu->setGeometry(10,frame_drawing_menu->height()-frame_tool_drawing_menu->height(),this->width()-20,frame_tool_drawing_menu->height());
    frame_support_drawing_menu->setGeometry(160,10,dvdxsize,dvdysize);
    bt_close_drawing_menu->setGeometry(frame_tool_drawing_menu->width()-bt_close_drawing_menu->width(),10,bt_close_drawing_menu->width(),bt_close_drawing_menu->height());
    bt_cancel_drawing_menu->setGeometry(bt_close_drawing_menu->geometry().x()-10-bt_close_drawing_menu->width(),10,bt_close_drawing_menu->width(),bt_close_drawing_menu->height());

    frame_support_editor->setGeometry(0,0,frame_editor->width(),frame_editor->height());
    screen_designer->setGeometry(0,0,dvdxsize,dvdysize);
    background_menu->setGeometry(0,0,dvdxsize,dvdysize);

    frame_tab_info->setGeometry(0,(screen_designer->height()-frame_tab_info->height())/2,dvdxsize,frame_tab_info->height());

    label_numenu->setGeometry(10+frame_is_is->width()+10,3,frame_tab_info->width()-(10+frame_is_is->width()+10),frame_is_is->height()-3);
    safety_zone->setGeometry(0,0,dvdxsize,dvdysize);
    magnetic_grid->setGeometry(0,0,dvdxsize,dvdysize);
    frame_pencil_draw->setGeometry(0,0,dvdxsize,dvdysize);
    frame_lst_menus->setGeometry(0,this->height(),frame_support_editor->width()-frame_pro->width(),frame_lst_menus->height());
    frame_lst_menus->lower();
    frame_support_menu_th_contain->setGeometry(10,36,frame_lst_menus->width()-20,122);
    scroll_timeline->setGeometry(2,frame_support_menu_th_contain->height()-18,frame_support_menu_th_contain->width()-4,14);

    frame_txtbase->setGeometry(10,154,frame_txtbase->width(),frame_txtbase->height());

    //this->setGeometry(this->geometry().x(),this->geometry().y(),dvdxsize+frame_pro->width(),dvdysize+bottom_menu->height()+smenuBar->height());

    //frame_support_editor->setGeometry(0,0,frame_editor->width(),frame_editor->height());
    //screen_designer->setGeometry(0,0,dvdxsize,dvdysize);

    bt_switch_property->setGeometry(this->width()-(bt_switch_property->width()+5),(bottom_menu->height()-bt_switch_property->height())/2,bt_switch_property->width(),bt_switch_property->height());
    bt_switch_themes->setGeometry(bt_switch_property->geometry().x()-(bt_switch_property->width()+5),(bottom_menu->height()-bt_switch_property->height())/2,bt_switch_property->width(),bt_switch_property->height());
    bt_switch_medias->setGeometry(bt_switch_themes->geometry().x()-(bt_switch_property->width()+5),(bottom_menu->height()-bt_switch_property->height())/2,bt_switch_property->width(),bt_switch_property->height());

    tabwidget_main->setGeometry(10,10,frame_pro->width()-20,frame_pro->height()-20);
    frame_th_msk_idea->setGeometry(10,10,tabwidget_main->width()-20,tabwidget_main->height()-80);
    bt_import_mask->setGeometry(10,tabwidget_main->height()-66,frame_th_msk_idea->width(),bt_import_mask->height());
    frame_th_the_idea->setGeometry(10,10,tabwidget_main->width()-20,tabwidget_main->height()-80);
    bt_add_theme->setGeometry(10,tabwidget_main->height()-66,frame_th_the_idea->width(),bt_add_theme->height());
    frame_th_obj_idea->setGeometry(10,10,tabwidget_main->width()-20,tabwidget_main->height()-80);
    bt_import_obj->setGeometry(10,tabwidget_main->height()-66,frame_th_the_idea->width(),bt_add_theme->height());

    frame_left_menu->setGeometry(0,0,frame_pro->width(),frame_pro->height());

    mask_interface->setGeometry(0,0,this->width(),this->height());
    mask_interface->hide();

    frame_dispatch->setGeometry(0,0,this->width(),this->height()-smenuBar->height());
    frame_help_dispatch->setGeometry(10,frame_dispatch->height()-(frame_help_dispatch->height()+10),frame_help_dispatch->width(),frame_help_dispatch->height());

    label_fond_options->setGeometry(0,0,frame_help_dispatch->width(),frame_help_dispatch->height());
    label_fond_options->lower();
    frame_render->setGeometry((this->width()-frame_render->width())/2,(this->height()-frame_render->height())/2,frame_render->width(),frame_render->height());
    frame_iso->setGeometry((this->width()-frame_iso->width())/2,(this->height()-frame_iso->height())/2,frame_iso->width(),frame_iso->height());
    frame_burn->setGeometry((this->width()-frame_burn->width())/2,(this->height()-frame_burn->height())/2,frame_burn->width(),frame_burn->height());
    frame_customize->setGeometry((this->width()-frame_customize->width())/2,(this->height()-frame_customize->height())/2,frame_customize->width(),frame_customize->height());
    frame_advanced->setGeometry((this->width()-frame_advanced->width())/2,(this->height()-frame_advanced->height())/2,frame_advanced->width(),frame_advanced->height());

    frame_edit_overlay->setGeometry((this->width()-frame_edit_overlay->width())/2,(this->height()-frame_edit_overlay->height())/2,frame_edit_overlay->width(),frame_edit_overlay->height());

    frame_preferences->setGeometry((this->width()-frame_preferences->width())/2,(this->height()-frame_preferences->height())/2,frame_preferences->width(),frame_preferences->height());

    // *** PREVIEW DE FIN ***
    frame_preview_finish->setGeometry(0,0,this->width(),this->height()-smenuBar->height());
    frame_telecommande->setGeometry(frame_preview_finish->width()-260,10,250,frame_preview_finish->height()-20);
    bt_close_preview_finish->setGeometry(10,frame_telecommande->height()-(10+bt_close_preview_finish->height()),frame_telecommande->width()-20,bt_close_preview_finish->height());
    frame_player_result->setGeometry(10,10,frame_preview_finish->width()-280,frame_preview_finish->height()-20);

    // *** DIVERS ***

    frame_tree->setGeometry(0,0,this->width(),this->height());
    frame_syno->setGeometry(20,20,this->width()-40,this->height()-(40+smenuBar->height()));

    frame_preview_image->setGeometry(this->width()-(frame_preview_image->width()+15),this->height()-(frame_preview_image->height()+40),frame_preview_image->width(),frame_preview_image->height());
    frame_scale_background->setGeometry(0,0,this->width(),this->height()-smenuBar->height());
    solution_scale_1->setGeometry((frame_scale_background->width()-650)/2,(frame_scale_background->height()-270)/2,300,300);
    solution_scale_2->setGeometry(solution_scale_1->geometry().x()+350,solution_scale_1->geometry().y(),300,300);
    label_scale_background->setGeometry(0,0,this->width(),solution_scale_1->geometry().y());

    frame_scale_media->setGeometry(0,0,this->width(),this->height()-smenuBar->height());
    solution_scale_3->setGeometry((frame_scale_media->width()-850)/2,(frame_scale_media->height()-270)/2,400,320);
    solution_scale_4->setGeometry(solution_scale_3->geometry().x()+450,solution_scale_3->geometry().y(),400,320);
    label_scale_media->setGeometry(0,0,this->width(),solution_scale_3->geometry().y());

    frame_endencoding->setGeometry((this->width()-frame_endencoding->width())/2,(this->height()-frame_endencoding->height())/2,frame_endencoding->width(),frame_endencoding->height());
    frame_transitions->setGeometry((frame_editor->width()-frame_transitions->width())/2,(this->height()-frame_transitions->height())/2,frame_transitions->width(),frame_transitions->height());

    bt_dispatch_1->setGeometry((this->width()-470)/2,(this->height()-270)/2,130,130);
    bt_dispatch_2->setGeometry(bt_dispatch_1->geometry().x()+170,bt_dispatch_1->geometry().y(),130,130);
    bt_dispatch_3->setGeometry(bt_dispatch_2->geometry().x()+170,bt_dispatch_2->geometry().y(),130,130);
    bt_dispatch_4->setGeometry((this->width()-300)/2,bt_dispatch_1->geometry().y()+170,130,130);
    bt_dispatch_5->setGeometry(bt_dispatch_4->geometry().x()+170,bt_dispatch_4->geometry().y(),130,130);
    label_dispatch->setGeometry(0,bt_dispatch_1->geometry().y()-200,this->width(),200);

    frame_apropos->setGeometry((this->width()-frame_apropos->width())/2,(this->height()-frame_apropos->height())/2,frame_apropos->width(),frame_apropos->height());
    frame_overlays->setGeometry((this->width()-frame_overlays->width())/2,(this->height()-frame_overlays->height())/2,frame_overlays->width(),frame_overlays->height());

    frame_choose_thumb->setGeometry(0,0,this->width(),this->height()-smenuBar->height());
    label_img_thumb->setGeometry(10,20,this->width()-20,this->height()-80);
    hdlpf->setGeometry(0,0,label_img_thumb->width(),label_img_thumb->height());
    hdlpf->resize(label_img_thumb->width(),label_img_thumb->height());
    frame_bt_thumb->setGeometry(10,this->height()-(40+smenuBar->height()),this->width()-20,40);
    bt_valid_thumb->setGeometry(this->width()-(bt_valid_thumb->width()+20),5,bt_valid_thumb->width(),bt_valid_thumb->height());

    slnbimg->setGeometry(bt_valid_thumb->geometry().x()-(slnbimg->width()+10),18,slnbimg->width(),slnbimg->height());
    label_pos_med_thumb_2->setGeometry(bt_valid_thumb->geometry().x()-(slnbimg->width()+10),5,slnbimg->width(),label_pos_med_thumb_2->height());

    frame_mapzone->setGeometry((this->width() - frame_mapzone->width())/2,(this->height() - frame_mapzone->height())/2,frame_mapzone->width(),frame_mapzone->height());
    label_pos_med_thumb->setGeometry(10,5,300,bt_valid_thumb->height());
    label_mouse->setGeometry(10,this->height()-(label_mouse->height()+30),label_mouse->width(),label_mouse->height());

    frame_add_theme->setGeometry((this->width() - frame_add_theme->width())/2,(this->height() - frame_add_theme->height())/2,frame_add_theme->width(),frame_add_theme->height());
    stamp_position_extract->setGeometry(this->width() - (stamp_position_extract->width()+30),30,stamp_position_extract->width(),stamp_position_extract->height());
    frame_fond_designer_overlays->lower();

    // *** BIBLIOTHEQUE AJOUT DE MEDIAS ***

    frame_medias->setGeometry(10,10,frame_pro->width()-20,frame_pro->height()-20);
    support_frame_mediatheque->setGeometry(0,0,frame_medias->width(),frame_medias->height());
    frame_mediatheque->setGeometry(0,0,support_frame_mediatheque->width()-sb_medias->width(),support_frame_mediatheque->height());
    sb_medias->setGeometry(frame_mediatheque->width()+1,0,sb_medias->width(),support_frame_mediatheque->height());

    myeffect_global->setOpacity(qreal(0.0));

    //frame_directory->setGeometry((this->width()-frame_directory->width())/2,(this->height()-frame_directory->height())/2,frame_directory->width(),frame_directory->height());
    frame_directory->setGeometry(0,0,this->width()-frame_pro->width(),frame_pro->height());
    media_media->setGeometry(10,60,frame_directory->width()-20,frame_directory->height()-100);
    bt_close_navigator->setGeometry(frame_directory->width()-bt_close_navigator->width()-10,frame_directory->height()-36,bt_close_navigator->width(),bt_close_navigator->height());
    frame_support_path->setGeometry(10,15,media_media->width(),frame_support_path->height());

    frame_deg_bas->setGeometry(0,frame_medias->height()-frame_deg_bas->height(),frame_medias->width(),frame_deg_bas->height());
    frame_deg_bas->raise();
    frame_deg_haut->setGeometry(0,0,frame_medias->width(),frame_deg_haut->height());
    frame_deg_haut->raise();

    frame_reencode->setGeometry((this->width()-frame_reencode->width())/2,(this->height()-frame_reencode->height())/2,frame_reencode->width(),frame_reencode->height());

    frame_chapitrage->setGeometry(0,0,this->width(),this->height()-smenuBar->height());
    frame_fond_menu_chapitrage->setGeometry(frame_chapitrage->width() - frame_fond_menu_chapitrage->width(),0,frame_fond_menu_chapitrage->width(),frame_chapitrage->height());

    frame_reglages->setGeometry(frame_chapitrage->width() - frame_fond_menu_chapitrage->width(),0,frame_fond_menu_chapitrage->width(),frame_chapitrage->height());
    bt_close_effects->setGeometry(10,frame_chapitrage->height()-41,frame_fond_menu_chapitrage->width()-20,31);

    lst_chapters->setGeometry(10,10,frame_fond_menu_chapitrage->width()-20,frame_chapitrage->height()-250);
    frame_autochap->setGeometry(10,frame_chapitrage->height()-205,frame_fond_menu_chapitrage->width()-20,121);
    label_3->setGeometry(10,1,frame_autochap->width()-20,41);
    combo_autochapter->setGeometry((frame_autochap->width()-80)/2,44,80,31);
    bt_valide_autochapter->setGeometry(10,80,frame_autochap->width()-20,32);
    bt_player_mark_chapter->setGeometry(10,frame_chapitrage->height()-240,frame_fond_menu_chapitrage->width()-20,31);
    bt_close_chapter->setGeometry(10,frame_chapitrage->height()-41,frame_fond_menu_chapitrage->width()-20,31);

    frame_support_player->setGeometry(40,40,frame_chapitrage->width()-(frame_fond_menu_chapitrage->width()+80),frame_chapitrage->height()-60);
    label_sticker_length->setGeometry(10,frame_support_player->geometry().y()+frame_support_player->height()-5,frame_support_player->width(),28);
    frame_player_media->setGeometry(20,20,frame_support_player->width()-40,frame_support_player->height()-130);
    frame_progress_player->setGeometry(20,21+frame_player_media->height(),frame_support_player->width()-40,frame_progress_player->height());
    frame_ctrl_player->setGeometry((frame_player_media->width()-frame_ctrl_player->width())/2,frame_support_player->height()-75,frame_ctrl_player->width(),frame_ctrl_player->height());
    slider_player->setGeometry(0,5,frame_progress_player->width(),21);
    bt_mute_sound->setGeometry(20,frame_ctrl_player->geometry().y()+17,32,32);
    bt_capture->setGeometry(bt_mute_sound->geometry().x()+40,frame_ctrl_player->geometry().y()+17,32,32);
    frame_quoifaire_after->setGeometry((this->width()-frame_quoifaire_after->width())/2,(this->height()-frame_quoifaire_after->height())/2,frame_quoifaire_after->width(),frame_quoifaire_after->height());

    frame_language->setGeometry((this->width()-frame_language->width())/2,(this->height()-frame_language->height())/2,frame_language->width(),frame_language->height());

    // *** EDITEUR DE MENUS ***

    //frame_is_is->setGeometry(this->width()-(frame_pro->width()+frame_is_is->width()+10),bottom_menu->geometry().y()-(frame_is_is->height()+10),frame_is_is->width(),frame_is_is->height());
    //frame_is_is->show();
    //frame_is_is->raise();

    frame_organize->setGeometry(screen_designer->geometry().x(),screen_designer->geometry().y(),dvdxsize,dvdysize);

    h_regle->wgheight = frame_editor->height()-smenuBar->height()-bottom_menu->height()-h_regle->height();
    v_regle->wgwidth = frame_editor->width()-frame_pro->width()-v_regle->width();
    h_regle->setGeometry(0,h_regle->geometry().y(),frame_editor->width()-frame_pro->width(),21);
    v_regle->setGeometry(v_regle->geometry().x(),0,21,frame_editor->height()-bottom_menu->height()-smenuBar->height());

    frame_medias->hide();
    tabwidget_main->hide();
    frame_left_menu->show();
    frame_left_menu->raise();
    bt_switch_property->setChecked(true);

    // *** CREATION DE L'IMAGE DE FOND DE MENU VIDE ***
    QPixmap wl_pix_001(dvdxsize,dvdysize);
    wl_pix_001.fill(QColor(0,0,0,0));

    QImage wl_img_001(dvdxsize,dvdysize,QImage::Format_ARGB32);
    wl_img_001.fill(0);

    QPainter p;
    p.begin(&wl_img_001);
    QFont myfont;
    p.setPen(QColor(200,200,255));
    myfont.setFamily("Nimbus Sans L");
    myfont.setPixelSize ( 40 );
    myfont.setBold(true);
    p.setFont(myfont);
    p.drawText(QRect(40,dvdysize-250,dvdxsize-40,40), Qt::AlignVCenter, tr("Nouveau menu"));
    myfont.setPixelSize ( 20 );
    myfont.setBold(false);
    p.setFont(myfont);
    p.drawText(QRect(40,dvdysize-200,dvdxsize-40,30), Qt::AlignVCenter, tr("Choisissez un arriere plan pour votre menu"));
    p.end();

    wl_img_001 = blur_shadow(wl_img_001);

    p.begin(&wl_pix_001);
    p.setRenderHint(QPainter::Antialiasing,true);
    p.setPen(QColor(200,200,200));
    //p.drawPixmap ( 0, 0, QPixmap(":/Interface/Interface/stripes.jpg") );

    QRadialGradient Gradient1(wl_pix_001.width()/2,wl_pix_001.height()/2,wl_pix_001.width()/2,wl_pix_001.width()/2,wl_pix_001.height()/2);
    Gradient1.setColorAt(1.0, QColor(97,101,117,255));
    Gradient1.setColorAt(0.0, QColor(141,149,165,255));
    p.setBrush(Gradient1);
    p.drawRect(0,0,wl_pix_001.width(),wl_pix_001.height());

    p.drawImage ( 0, 0, wl_img_001 );
    p.setPen(QColor(255,255,255));
    p.drawRect(0,0,dvdxsize,dvdysize);
    myfont.setPixelSize ( 40 );
    myfont.setBold(true);
    p.setFont(myfont);
    p.drawText(QRect(40,dvdysize-250,dvdxsize-40,40), Qt::AlignVCenter, tr("Nouveau menu"));
    myfont.setPixelSize ( 20 );
    myfont.setBold(false);
    p.setFont(myfont);
    p.drawText(QRect(40,dvdysize-200,dvdxsize-40,30), Qt::AlignVCenter, tr("Choisissez un arriere plan pour votre menu"));
    p.end();

    wl_pix_001.save(path_project+"/DVD/TEMP/nofd.png","PNG");
    must_update = 0;

    background_menu->setPixmap(wl_pix_001);
    thread_ani->pix_001 = thread_ani->pix_001.scaled(this->width(),this->height());
}

// ********************************************************
// *** OUVERTURE FERMETURE DE LA BARRE D'OUTILS DU HAUT ***
// ********************************************************

void mainfrm::f_openclose_toolbar()
{
    if ( frame_top_tool->geometry().y() >= -10 )
    {
        frame_top_tool->raise();
        QPropertyAnimation *animation = new QPropertyAnimation(frame_top_tool, "geometry");
        connect(animation,SIGNAL(finished()),this,SLOT(f_openclose_toolbar_end()));
        animation->setDuration(200);
        animation->setStartValue(QRect(frame_top_tool->geometry().x(),frame_top_tool->geometry().y(),frame_top_tool->width(),frame_top_tool->height()));
        animation->setEndValue(QRect(frame_top_tool->geometry().x(),frame_top_tool->geometry().y()-frame_top_tool->height(),frame_top_tool->width(),frame_top_tool->height()));
        //animation->setEasingCurve(QEasingCurve::InOutCubic);
        bt_opc_toolbar->setDisabled(true);
        animation->start();
    }
    else
    {
        frame_top_tool->raise();
        QPropertyAnimation *animation = new QPropertyAnimation(frame_top_tool, "geometry");
        connect(animation,SIGNAL(finished()),this,SLOT(f_openclose_toolbar_end()));
        animation->setDuration(200);
        animation->setStartValue(QRect(frame_top_tool->geometry().x(),frame_top_tool->geometry().y(),frame_top_tool->width(),frame_top_tool->height()));
        animation->setEndValue(QRect(frame_top_tool->geometry().x(),frame_top_tool->geometry().y()+frame_top_tool->height(),frame_top_tool->width(),frame_top_tool->height()));
        //animation->setEasingCurve(QEasingCurve::OutCubic);
        bt_opc_toolbar->setDisabled(true);
        animation->start();
    }
}

void mainfrm::f_openclose_toolbar_end()
{
    bt_opc_toolbar->setEnabled(true);
}

// ***********************************
// *** FONCTIONS PROJETS DIAPORAMA ***
// ***********************************

void mainfrm::f_saveas_smile()
{
    this->setDisabled(true);
    QString wmypro = QFileDialog::getSaveFileName(this, tr("Sauvegarder votre projet"), path_save, tr("Projet (*.smil)"));
    if ( wmypro.isNull() )
    {
            this->setEnabled(true);
            return;
    }
    else
    {
            if ( wmypro.right(5) != ".smil" )
            {
                    wmypro = wmypro + ".smil";
            }
            path_always_save = wmypro;
            wg_int_001 = wmypro.lastIndexOf( '/' );
            if ( wg_int_001 != -1 )
            {
                    path_save = wmypro.mid(0,wg_int_001);
            }
            pntmygl->f_save_diapo(num_current_diapo);


            QDir mydir(path_project);

            if ( mydir.mkdir("SVP") == true || mydir.exists("SVP") == true )
            {

                QFile wmyfic(path_project + "/SVP/prj_smi.x");

                if ( !wmyfic.open( QIODevice::WriteOnly ))
                {
                        qDebug() << "ERROR CREATING PROJECT IN : " + path_project;
                        this->setEnabled(true);
                        return;
                }
                else
                {
                        QTextStream out(&wmyfic);

                        if ( nbre_audio_track > 0 )
                        {
                            out << QString::number(hdl_audio->position) << "$#$" << QString::number(hdl_audio->length_media) << "$#$" << hdl_audio->title_audio << "$#$" << QString::number(hdl_audio->is_fade_in) << "$#$" << QString::number(hdl_audio->is_fade_out) << endl;
                        }
                        else
                        {
                            out << "" << endl;
                        }

                        out << QString::number(combo_format_dvd->currentIndex()) << endl;
                        out << QString::number(pntmygl->is_anaglyph) << endl;
                        out << QString::number(combo_od->currentIndex()) << endl;
                        out << QString::number(combo_og->currentIndex()) << endl;
                        out << QString::number(sl_esp_ana->value()) << endl;

                        int wl_int_001 = 0;
                        int wl_int_002;

                        while ( wl_int_001 < nbre_diapos )
                        {
                            wl_int_002 = 1;
                            while ( wl_int_002 < 43 && pntmygl->tab_save_diapo[wl_int_001][wl_int_002] != "$#$" )
                            {
                                out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002] << endl;
                                wl_int_002++;
                            }
                            out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002] << endl;
                            out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002+1] << endl;
                            out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002+2] << endl;
                            out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002+3] << endl;
                            out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002+4] << endl;
                            out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002+5] << endl;
                            table_hdl_diapo[wl_int_001]->draw_image.save(path_project + "/SVP/" + QString::number(wl_int_001) + ".png");
                            wl_int_001++;
                            out << "----------" << endl;
                        }
                        wmyfic.close();

                        // *** SAUVEGARDE DU PROJET ***
                        wmyfic.setFileName(path_project + "/prjsave.sh");

                        if ( !wmyfic.open( QIODevice::WriteOnly ))
                        {
                                qDebug() << "ERROR CREATING BASH SAVING PROJECT IN : " + path_project;
                                return;
                        }
                        else
                        {
                                QTextStream out(&wmyfic);
                                out << "cd " + path_project << endl;
                                out << "tar cf " + wmypro + " SVP" << endl;
                                out << "rm -rf SVP" << endl;
                                out << "rm -f prjsave.sh" << endl;
                                wmyfic.close();

                                wg_int_005 = 0;

                                QString program = "bash";
                                QStringList arguments;
                                arguments << path_project + "/prjsave.sh";
                                projectProcess.setProcessChannelMode(QProcess::MergedChannels);
                                projectProcess.start(program,arguments);
                        }
                }
            }
            else
            {
                qDebug() << "ERROR CREATING SVP DIRECTORY IN " << path_project;
                QMessageBox::information(this, name_application, tr("Erreur creation dossier sauvegarde dans : ") + path_project);
            }
    }
    this->setEnabled(true);
}

void mainfrm::f_save_smile()
{
    this->setDisabled(true);

    pntmygl->f_save_diapo(num_current_diapo);


    QDir mydir(path_project);

    if ( mydir.mkdir("SVP") == true || mydir.exists("SVP") == true )
    {

        QFile wmyfic(path_project + "/SVP/prj_smi.x");

        if ( !wmyfic.open( QIODevice::WriteOnly ))
        {
                qDebug() << "ERROR CREATING PROJECT IN : " + path_project;
                this->setEnabled(true);
                return;
        }
        else
        {
                QTextStream out(&wmyfic);

                if ( nbre_audio_track > 0 )
                {
                    out << QString::number(hdl_audio->position) << "$#$" << QString::number(hdl_audio->length_media) << "$#$" << hdl_audio->title_audio << "$#$" << QString::number(hdl_audio->is_fade_in) << "$#$" << QString::number(hdl_audio->is_fade_out) << endl;
                }
                else
                {
                    out << "" << endl;
                }
                out << QString::number(combo_format_dvd->currentIndex()) << endl;

                out << QString::number(pntmygl->is_anaglyph) << endl;
                out << QString::number(combo_od->currentIndex()) << endl;
                out << QString::number(combo_og->currentIndex()) << endl;
                out << QString::number(sl_esp_ana->value()) << endl;

                int wl_int_001 = 0;
                int wl_int_002;

                while ( wl_int_001 < nbre_diapos )
                {
                    wl_int_002 = 1;
                    while ( wl_int_002 < 43 && pntmygl->tab_save_diapo[wl_int_001][wl_int_002] != "$#$" )
                    {
                        out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002] << endl;
                        wl_int_002++;
                    }
                    out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002] << endl;
                    out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002+1] << endl;
                    out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002+2] << endl;
                    out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002+3] << endl;
                    out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002+4] << endl;
                    out << pntmygl->tab_save_diapo[wl_int_001][wl_int_002+5] << endl;
                    table_hdl_diapo[wl_int_001]->draw_image.save(path_project + "/SVP/" + QString::number(wl_int_001) + ".png");
                    wl_int_001++;
                    out << "----------" << endl;
                }
                wmyfic.close();

                // *** SAUVEGARDE DU PROJET ***
                wmyfic.setFileName(path_project + "/prjsave.sh");

                if ( !wmyfic.open( QIODevice::WriteOnly ))
                {
                        qDebug() << "ERROR CREATING BASH SAVING PROJECT IN : " + path_project;
                        return;
                }
                else
                {
                        QTextStream out(&wmyfic);
                        out << "cd " + path_project << endl;
                        out << "tar cf " + path_always_save + " SVP" << endl;
                        out << "rm -rf SVP" << endl;
                        out << "rm -f prjsave.sh" << endl;
                        wmyfic.close();

                        wg_int_005 = 0;

                        QString program = "bash";
                        QStringList arguments;
                        arguments << path_project + "/prjsave.sh";
                        projectProcess.setProcessChannelMode(QProcess::MergedChannels);
                        projectProcess.start(program,arguments);
                }
        }
    }
    else
    {
        qDebug() << "ERROR CREATING TEMP DIRECTORY";
    }
    this->setEnabled(true);
}

void mainfrm::f_openfs_smile(QString proj)
{
    if ( line_path_projet->text() != "" )
    {
            int wl_int_001 = 0;

            while ( wl_int_001 < nbre_diapos )
            {
                delete table_hdl_diapo[wl_int_001];
                wl_int_001++;
            }

            nbre_diapos = 1;
            QString tmpaudio = "";

            wl_int_001 = proj.lastIndexOf( '/' );
            if ( wl_int_001 != -1 )
            {
                    path_save = proj.mid(0,wl_int_001);
            }
            path_project = line_path_projet->text();

            QFile wmyficext;
            QTextStream outext(&wmyficext);

            wmyficext.setFileName(path_project + "/opensmi.sh");
            wmyficext.open( QIODevice::WriteOnly );
            outext << "cd " + path_project << endl;
            outext << "tar xf " + proj << endl;
            outext << "rm -f " + path_project + "/opensmi.sh" << endl;
            outext << "exit" << endl;
            wmyficext.close();

            QString programf = "bash";
            QStringList argumentsf;
            QStringList wl_explode9;
            argumentsf << path_project + "/opensmi.sh";

            proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
            proc_ffmpeg.start(programf,argumentsf);
            proc_ffmpeg.waitForFinished(-1);

            QByteArray newData;
            QFile wmyfic(path_project + "/SVP/prj_smi.x");

            if ( !wmyfic.open( QIODevice::ReadOnly ))
            {
                    qDebug() << "ERROR OPENING SMILE IN : " + path_project;
                    return;
            }
            else
            {
                    nbre_diapos = 0;

                    newData = wmyfic.readLine(0);
                    wg_string_001 = QString::fromLocal8Bit(newData);
                    wg_string_001 = wg_string_001.simplified();
                    wg_string_001 = wg_string_001.mid(0, newData.count() - 1);

                    if ( wg_string_001 != "" )
                    {
                        tmpaudio = wg_string_001;
                    }

                    newData = wmyfic.readLine(0);
                    wg_string_001 = QString::fromLocal8Bit(newData);
                    wg_string_001 = wg_string_001.simplified();
                    wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                    combo_format_dvd->setCurrentIndex(wg_string_001.toInt());

                    f_scale_project();
                    pntmygl->resize(dvdxsize,dvdysize);
                    screen_timeline->setGeometry((pntmygl->width()-700)/2,5,700,40);
                    frame_lcd_position->setGeometry(screen_timeline->geometry().x()+screen_timeline->width()+5,(frame_bottom_slide->height()-frame_lcd_position->height())/2,frame_lcd_position->width(),frame_lcd_position->height());

                    newData = wmyfic.readLine(0);
                    wg_string_001 = QString::fromLocal8Bit(newData);
                    wg_string_001 = wg_string_001.simplified();
                    wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                    pntmygl->is_anaglyph = wg_string_001.toInt();

                    must_update = 0;

                    if ( pntmygl->is_anaglyph > 0 )
                    {
                        check_anaglyph->setChecked(true);
                        pntmygl->is_anaglyph = 1;
                    }
                    else
                    {
                        check_anaglyph->setChecked(false);
                        pntmygl->is_anaglyph = 0;
                    }

                    newData = wmyfic.readLine(0);
                    wg_string_001 = QString::fromLocal8Bit(newData);
                    wg_string_001 = wg_string_001.simplified();
                    wg_string_001 = wg_string_001.mid(0, newData.count() - 1);

                    combo_od->setCurrentIndex(wg_string_001.toInt());

                    newData = wmyfic.readLine(0);
                    wg_string_001 = QString::fromLocal8Bit(newData);
                    wg_string_001 = wg_string_001.simplified();
                    wg_string_001 = wg_string_001.mid(0, newData.count() - 1);

                    combo_og->setCurrentIndex(wg_string_001.toInt());

                    newData = wmyfic.readLine(0);
                    wg_string_001 = QString::fromLocal8Bit(newData);
                    wg_string_001 = wg_string_001.simplified();
                    wg_string_001 = wg_string_001.mid(0, newData.count() - 1);

                    sl_esp_ana->setValue(wg_string_001.toInt());

                    must_update = 1;

                    newData = wmyfic.readLine(0);
                    wg_string_001 = QString::fromLocal8Bit(newData);
                    wg_string_001 = wg_string_001.simplified();
                    wg_string_001 = wg_string_001.mid(0, newData.count() - 1);

                    wl_int_001 = 0;
                    int wl_int_002 = 1;
                    int wl_int_003 = 0;

                    while ( wmyfic.atEnd() == false )
                    {
                        if ( wg_string_001.mid(0,6) != "------" )
                        {
                            pntmygl->tab_save_diapo[wl_int_001][wl_int_002] = wg_string_001;
                            //qDebug() << "DIAP = " << wl_int_001 << " " << wl_int_002 << " " << pntmygl->tab_save_diapo[wl_int_001][wl_int_002];

                            wl_int_002++;
                        }
                        else
                        {
                            diapos_th *newdiapo = new diapos_th(timeline_diapo);

                            table_hdl_diapo[nbre_diapos] = newdiapo;

                            connect(newdiapo, SIGNAL(select_diapoth(diapos_th*) ),this, SLOT(f_select_diapos_th(diapos_th*)));
                            connect(newdiapo, SIGNAL(delete_diapoth(diapos_th*) ),this, SLOT(f_delete_diaposth(diapos_th*)));
                            connect(newdiapo, SIGNAL(theme_diapoth(diapos_th*) ),this, SLOT(f_theme_diaposth(diapos_th*)));
                            connect(newdiapo, SIGNAL(dupliquer_diapoth(diapos_th*) ),this, SLOT(f_dupliquer_diaposth(diapos_th*)));
                            connect(newdiapo, SIGNAL(enter_diath(diapos_th*) ),this, SLOT(f_enter_diath(diapos_th*)));
                            connect(newdiapo, SIGNAL(leave_diath(diapos_th*) ),this, SLOT(f_leave_diath(diapos_th*)));

                            newdiapo->setGeometry( nbre_diapos * 60, 0, 50, 50 );
                            newdiapo->draw_image.load(path_project + "/SVP/" + QString::number(nbre_diapos) + ".png");
                            newdiapo->is_edit = 0;
                            if ( nbre_diapos == 0 )
                            {
                                //newdiapo->is_first = 1;
                                newdiapo->is_edit = 1;
                                hdl_current_diapo = newdiapo;
                            }
                            newdiapo->show();

                            timeline_diapo->repaint();

                            /*wl_int_003 = 0;
                            while ( wl_int_003 < 20 )
                            {
                                screen_timeline->tab_mark[wl_int_003][0] = "";
                                screen_timeline->tab_mark[wl_int_003][1] = "";
                                screen_timeline->tab_mark[wl_int_003][2] = "";
                                wl_int_003++;
                            }*/
                            timeline_diapo->tab_duration[nbre_diapos] = pntmygl->tab_save_diapo[wl_int_001][wl_int_002-5].toInt();

                            wl_explode9 = pntmygl->tab_save_diapo[wl_int_001][wl_int_002-3].split("}",QString::KeepEmptyParts);
                            if ( wl_explode9.at(0) != "" )
                            {
                                timeline_diapo->tab_transition[nbre_diapos] = wl_explode9.at(1).toInt();
                            }
                            nbre_diapos++;
                            timeline_diapo->max_diapo = nbre_diapos;

                            wl_int_001++;
                            wl_int_002 = 1;
                        }

                        newData = wmyfic.readLine(0);
                        wg_string_001 = QString::fromLocal8Bit(newData);
                        wg_string_001 = wg_string_001.simplified();
                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                        //combo_format_dvd->setCurrentIndex(wg_string_001.toInt());
                    }

                    if ( wg_string_001.mid(0,6) == "------" )
                    {
                        diapos_th *newdiapo = new diapos_th(timeline_diapo);

                        table_hdl_diapo[nbre_diapos] = newdiapo;

                        connect(newdiapo, SIGNAL(select_diapoth(diapos_th*) ),this, SLOT(f_select_diapos_th(diapos_th*)));
                        connect(newdiapo, SIGNAL(delete_diapoth(diapos_th*) ),this, SLOT(f_delete_diaposth(diapos_th*)));
                        connect(newdiapo, SIGNAL(theme_diapoth(diapos_th*) ),this, SLOT(f_theme_diaposth(diapos_th*)));
                        connect(newdiapo, SIGNAL(dupliquer_diapoth(diapos_th*) ),this, SLOT(f_dupliquer_diaposth(diapos_th*)));
                        connect(newdiapo, SIGNAL(enter_diath(diapos_th*) ),this, SLOT(f_enter_diath(diapos_th*)));
                        connect(newdiapo, SIGNAL(leave_diath(diapos_th*) ),this, SLOT(f_leave_diath(diapos_th*)));

                        newdiapo->setGeometry( nbre_diapos * 60, 0, 50, 50 );
                        newdiapo->draw_image.load(path_project + "/SVP/" + QString::number(nbre_diapos) + ".png");
                        newdiapo->is_edit = 0;
                        if ( nbre_diapos == 0 )
                        {
                            //newdiapo->is_first = 1;
                            newdiapo->is_edit = 1;
                            hdl_current_diapo = newdiapo;
                        }
                        newdiapo->show();

                        timeline_diapo->repaint();

                        timeline_diapo->tab_duration[nbre_diapos] = pntmygl->tab_save_diapo[wl_int_001][wl_int_002-5].toInt();

                        wl_explode9 = pntmygl->tab_save_diapo[wl_int_001][wl_int_002-3].split("}",QString::KeepEmptyParts);
                        if ( wl_explode9.at(0) != "" )
                        {
                            timeline_diapo->tab_transition[nbre_diapos] = wl_explode9.at(1).toInt();
                        }

                        nbre_diapos++;
                        timeline_diapo->max_diapo = nbre_diapos;
                    }

                    wl_int_003 = 0;
                    while ( wl_int_003 < 20 )
                    {
                        screen_timeline->tab_mark[wl_int_003][0] = "";
                        screen_timeline->tab_mark[wl_int_003][1] = "";
                        screen_timeline->tab_mark[wl_int_003][2] = "";
                        wl_int_003++;
                    }

                    wmyfic.close();

                    if ( (nbre_diapos*70) > timeline_diapo->width() )
                    {
                        timeline_diapo->setGeometry(timeline_diapo->geometry().x(),0,nbre_diapos*70,timeline_diapo->height());
                        scroll_timeline_smile->setMaximum(timeline_diapo->width()-frame_support_timeline->width());

                        //qDebug() << myeffect_global->opacity();

                        if ( myeffect_global->opacity() < 1.0 )
                        {
                            QPropertyAnimation *animation = new QPropertyAnimation(myeffect_global, "opacity");
                            animation->setDuration(1000);
                            animation->setStartValue(qreal(myeffect_global->opacity()));
                            animation->setEndValue(qreal(1.0));
                            animation->start();
                        }
                    }

                    num_current_diapo = 0;

                    f_load_diapo(0);

                    //f_select_diapos_th(table_hdl_diapo[0]);

                    spin_length_diapo->setValue(pntmygl->length_diapo);
                    screen_timeline->num_select = 0;
                    screen_timeline->pos_x = 10;
                    screen_timeline->repaint();
                    pntmygl->f_follow_timeline(10);


                    if ( tmpaudio != "" )
                    {
                        QStringList wl_explode = tmpaudio.split("$#$",QString::KeepEmptyParts);

                        audio_editor *newad = new audio_editor(timeline_diapo);

                        hdl_audio = newad;

                        nbre_audio_track = 1;
                        timeline_diapo->nbre_audio_track = nbre_audio_track;

                        newad->length_media = wl_explode.at(1).toInt();
                        newad->position = wl_explode.at(0).toInt();
                        newad->title_audio = wl_explode.at(2);

                        if ( wl_explode.count() > 3 )
                        {
                            newad->is_fade_in = wl_explode.at(3).toInt();
                            newad->is_fade_out = wl_explode.at(4).toInt();
                        }

                        connect(newad, SIGNAL(recalc()),this, SLOT(f_recalc_length_audio()));
                        connect(newad, SIGNAL(s_del_sound()),this, SLOT(f_s_del_sound_from_audiotrack()));

                        hdl_audio->setGeometry(newad->position*60,66,60,18);
                        hdl_audio->repaint();

                        f_recalc_length_audio();
                    }
                    else
                    {
                        nbre_audio_track = 0;
                        timeline_diapo->nbre_audio_track = nbre_audio_track;
                    }

                    actionEnregistrer_2->setEnabled(true);
                    path_always_save = proj;
                    this->setWindowTitle(tr("2ManDVD - Creation de diaporamas : ") + path_always_save);

                    /*wmyficext.setFileName(path_project + "/opensmi.sh");
                    wmyficext.open( QIODevice::WriteOnly );
                    outext << "rm -rf " + path_project + "/SVP" << endl;
                    outext << "rm -f " + path_project + "/opensmi.sh" << endl;
                    outext << "exit" << endl;
                    wmyficext.close();
                    QString programf = "bash";
                    QStringList argumentsf;
                    argumentsf << path_project + "/opensmi.sh";

                    proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
                    proc_ffmpeg.start(programf,argumentsf);

                    proc_ffmpeg.waitForFinished(-1);*/
                }
        }
}
