/* ============================================================
 * File  : mylstfiles.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "mylstfiles.h"

mylstfiles::mylstfiles ( QWidget * parent )
    : QListWidget(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        //this->setAttribute(Qt::WA_TranslucentBackground, true);
}

void mylstfiles::mouseMoveEvent(QMouseEvent *event)
{
	if (!(event->buttons() & Qt::LeftButton)) return;
	if (currentItem() == NULL) 
	{
		return;
	}
	else
	{

		QList<QListWidgetItem *> lstmul = this->selectedItems();

		if ( lstmul.count() > 0 )
		{
			if ( lstmul.at(0)->statusTip() == "$$VIDF" )
			{
				QIcon iconedrag = currentItem()->icon();
				currentselect = iconedrag.pixmap ( 128, 128, QIcon::Normal ,  QIcon::On);
				currentselectindex = this->selectedIndexes().at(0).row();
				//
				QMimeData *mimedata = new QMimeData;
				QList<QUrl> lsturl;
				QUrl myurl;
				myurl.setPath(current_path + "/" + lstmul.at(0)->text());
				lsturl.insert ( 0, myurl );
				current_filename = current_path + "/" + lstmul.at(0)->text();
				mimedata->setUrls(lsturl);
				QDrag *drag = new QDrag(this);
			 	drag->setMimeData(mimedata);
				drag->setPixmap(currentselect);
				drag->exec(Qt::MoveAction);
			}
		}
	}
}

void mylstfiles::mouseDoubleClickEvent ( QMouseEvent * )
{
	QList<QListWidgetItem *> lstmul = this->selectedItems();
	if ( lstmul.count() > 0 )
	{
		if ( lstmul.at(0)->statusTip() == "$$VIDF" )
		{
			QIcon iconedrag = currentItem()->icon();
			currentselect = iconedrag.pixmap ( 128, 128, QIcon::Normal ,  QIcon::On);
			currentselectindex = this->selectedIndexes().at(0).row();
			current_filename = current_path + "/" + lstmul.at(0)->text();
			emit media_dble_import();
		}
		else
		{
                    if ( lstmul.at(0)->statusTip() != "$$OTHER" )
                    {
			emit media_chdir();
                    }
		}
	}
}

Qt::DropActions mylstfiles::supportedDropActions () const
{
	return Qt::CopyAction | Qt::MoveAction;
}
