/* ============================================================
 * File  : menu_th.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "menu_th.h"

menu_th::menu_th ( QWidget * parent )
    : QLabel(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
	this->setMouseTracking (true);
	this->setScaledContents (true);
	is_first = 0;
	action_supprimer = new QAction(tr("Supprimer le menu"), this);
	action_supprimer->setIcon ( QIcon(":/Interface/Interface/trash.png") );

        action_dupliquer = new QAction(tr("Dupliquer le menu"), this);
        action_dupliquer->setIcon ( QIcon(":/Interface/Interface/copy.png") );

        connect(action_supprimer, SIGNAL(triggered()), this, SLOT(supprimer()));
        connect(action_dupliquer, SIGNAL(triggered()), this, SLOT(dupliquer()));
}

void menu_th::supprimer()
{
        emit delete_menuth(this);
	this->close(); 
}

void menu_th::dupliquer()
{
        emit dupliquer_menuth(this);
}

void menu_th::mousePressEvent ( QMouseEvent * event ) 
{
	if (!(event->buttons() & Qt::LeftButton)) return;
        //if (event->type() != QEvent::MouseButtonDblClick ) return;
	emit select_menuth(this);
}

void menu_th::contextMenuEvent(QContextMenuEvent *event)
{
        //if ( is_edit == 1 )
        //{
		if ( is_first == 1 )
		{
			action_supprimer->setDisabled(true);
		}
		else
		{
			action_supprimer->setEnabled(true);
		}

		QMenu menu(this);
		menu.addAction(action_supprimer);
                menu.addSeparator();
                menu.addAction(action_dupliquer);
		menu.exec(event->globalPos());
        //}
}

void menu_th::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
	p.drawPixmap ( QRect(9,9,88,88),draw_image );
	if ( is_edit == 1 )
	{
		p.drawPixmap(0,0,QPixmap(":/Interface/Interface/case_menu_select.png"));
	}
	else
	{
		p.drawPixmap(0,0,QPixmap(":/Interface/Interface/case_menu.png"));
	}
	p.setPen(QColor(20,20,20));
	p.drawText(QRect(10,80,this->width()-10,20), Qt::AlignVCenter, "Menu " + QString::number(is_first-1));
	p.end();
}

