/* ============================================================
 * File  : menu_editor.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "menu_editor.h"

menu_editor::menu_editor ( QWidget * parent )
    : QLabel(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        this->setAcceptDrops(true);
        this->setMouseTracking(true);

	is_copy = 0;
	has_sound = 0;
	has_intro = 0;

	action_addone = new QAction(tr("Ajouter un bouton"), this);
	action_addone->setIcon ( QIcon(":/Interface/Interface/new.png") );
	action_addmul = new QAction(tr("Ajouter plusieurs boutons"), this);
	action_addmul->setIcon ( QIcon(":/Interface/Interface/newm.png") );
        action_addone_txt = new QAction(tr("Ajouter un label"), this);
        action_addone_txt->setIcon ( QIcon(":/Interface/Interface/label.png") );
        action_pencil = new QAction(tr("Dessiner sur le menu"), this);
        action_pencil->setIcon ( QIcon(":/Interface/Interface/pencil.png") );


	action_customize = new QAction(tr("Image d'arriere plan"), this);
	action_customize->setIcon ( QIcon(":/Interface/Interface/btimg.png") );

	action_intro_load = new QAction(tr("Charger un media"), this);
	action_intro_load->setIcon ( QIcon(":/Interface/Interface/finder.png") );

	action_intro_calc = new QAction(tr("Transition animee"), this);
	action_intro_calc->setIcon ( QIcon(":/Interface/Interface/execute.png") );

	action_intro_cancel = new QAction(tr("Supprimer la video d'introduction"), this);
	action_intro_cancel->setIcon ( QIcon(":/Interface/Interface/trash.png") );
	action_paste = new QAction(tr("Coller le bouton"), this);
	action_paste->setIcon ( QIcon(":/Interface/Interface/paste.png") );

	action_zik_load = new QAction(tr("Charger une bande son"), this);
	action_zik_load->setIcon ( QIcon(":/Interface/Interface/finder.png") );
	action_zik_cancel = new QAction(tr("Supprimer la bande son"), this);
	action_zik_cancel->setIcon ( QIcon(":/Interface/Interface/trash.png") );

	action_color_overlays = new QAction(tr("Couleurs des overlays"), this);
	action_color_overlays->setIcon ( QIcon(":/Interface/Interface/customize.png") );

        action_menu_pro = new QAction(tr("Paramètres du menu"), this);
        action_menu_pro->setIcon ( QIcon(":/Interface/Interface/btimg.png") );

	connect(action_addone, SIGNAL(triggered()), this, SLOT(f_addone()));
	connect(action_addmul, SIGNAL(triggered()), this, SLOT(f_addmul()));
        connect(action_addone_txt, SIGNAL(triggered()), this, SLOT(f_addone_txt()));
	connect(action_customize, SIGNAL(triggered()), this, SLOT(customize()));
        connect(action_pencil, SIGNAL(triggered()), this, SLOT(f_pencil()));
	connect(action_intro_load, SIGNAL(triggered()), this, SLOT(f_load_intro()));
	connect(action_intro_cancel, SIGNAL(triggered()), this, SLOT(f_cancel_intro()));
	connect(action_zik_load, SIGNAL(triggered()), this, SLOT(f_load_zik()));
	connect(action_zik_cancel, SIGNAL(triggered()), this, SLOT(f_cancel_zik()));
	connect(action_paste, SIGNAL(triggered()), this, SLOT(f_paste()));
	connect(action_intro_calc, SIGNAL(triggered()), this, SLOT(f_calc()));
	connect(action_color_overlays, SIGNAL(triggered()), this, SLOT(f_coverl()));
        connect(action_menu_pro, SIGNAL(triggered()), this, SLOT(f_openpro()));
}

void menu_editor::f_openpro()
{
        emit menu_openpro();
}

void menu_editor::f_pencil()
{
        emit menu_pencil();
}

void menu_editor::f_coverl()
{
	emit color_overlays();
}

void menu_editor::f_calc()
{
	emit intro_calc();
}

void menu_editor::f_paste()
{
	emit paste_menu();
}

void menu_editor::f_load_intro()
{
	emit loadintro();
}

void menu_editor::f_cancel_intro()
{
	emit cancelintro();
}

void menu_editor::f_load_zik()
{
	emit loadzik();
}

void menu_editor::f_cancel_zik()
{
	emit cancelzik();
}

void menu_editor::f_addone()
{
	emit addone();
}

void menu_editor::f_addmul()
{
	emit addmul();
}

void menu_editor::f_addone_txt()
{
        emit addone_txt();
}

void menu_editor::customize()
{
	emit customize_background();
}

void menu_editor::contextMenuEvent(QContextMenuEvent *event)
{
	xevent = event->x();
	yevent = event->y();

        /*QtPieMenu *main_m;
        QtPieMenu *m_insert;
        main_m = new QtPieMenu("Root menu", this, "Root menu", 10, 50);

        m_insert = new QtPieMenu("Insertion", main_m, "Edit menu", 10, 50);
        m_insert->insertItem(QIcon(":/Interface/Interface/new.png"), this, SLOT(f_addone()));
        m_insert->insertItem(QIcon(":/Interface/Interface/newm.png"), this, SLOT(f_addmul()));
        m_insert->insertItem(QIcon(":/Interface/Interface/label.png"), this, SLOT(f_addone()));
        //markMenu->setItemWeight(2, 0);
        //markMenu->setItemWeight(2, 2);

        main_m->insertItem(m_insert);

        main_m->insertItem(tr("Arrière\nplan"), this, SLOT(customize()));
        main_m->insertItem(tr("Actions"), this, SLOT(customize()));
        main_m->popup(event->globalPos());*/


        QMenu menu(this);
	menu.addAction(action_addone);
	menu.addAction(action_addmul);
        menu.addAction(action_addone_txt);
        menu.addSeparator();
        menu.addAction(action_pencil);
	menu.addSeparator();
	menu.addAction(action_customize);
	menu.addSeparator();
	menu.addAction(action_color_overlays);
	menu.addSeparator();
	QMenu *menuintro = menu.addMenu(QIcon(":/Interface/Interface/media.png"),tr("Video d'introduction"));
	menuintro->addAction(action_intro_load);
	menuintro->addAction(action_intro_calc);
	menuintro->addSeparator();
	menuintro->addAction(action_intro_cancel);
	QMenu *menuzik = menu.addMenu(QIcon(":/Interface/Interface/son.png"),tr("Bande son"));
	menuzik->addAction(action_zik_load);
	menuzik->addAction(action_zik_cancel);
	menu.addSeparator();
	if ( is_copy == 0 )
	{
		action_paste->setDisabled(true);
	}
	else
	{
		action_paste->setEnabled(true);
	}

	if ( has_sound == 1 )
	{
		action_zik_load->setDisabled(true);
		action_zik_cancel->setEnabled(true);
	}
	else
	{
		action_zik_load->setEnabled(true);
		action_zik_cancel->setDisabled(true);
	}

	if ( has_intro == 1 )
	{
		action_intro_cancel->setEnabled(true);
	}
	else
	{
		action_intro_cancel->setDisabled(true);
	}

	menu.addAction(action_paste);
        menu.addSeparator();
        menu.addAction(action_menu_pro);
        menu.exec(event->globalPos());
}

// **********************************
// *** AJOUTER LE MEDIA AU PROJET ***
// **********************************
void menu_editor::dragEnterEvent(QDragEnterEvent *event)
{
        event->acceptProposedAction();
}

void menu_editor::dropEvent(QDropEvent *event)
{
        drop_x = event->pos().x();
        drop_y = event->pos().y();

        QList<QUrl> myurl = event->mimeData()->urls();
        wg_str_001 = myurl[0].toString(QUrl::None);

        emit drop_to_editor();
}
