/* ============================================================
 * File  : mainfrm.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <QtGui>
#include "mainfrm.h"
#include "userSettings.h"

// ***************************************************************
// *** DEFINITION DU STYLE D'UN SLIDER POUR CHANGEMENT BITRATE ***
// ***************************************************************

class H_Slider_Theme_1 : public QWindowsStyle
{
        public:
        const QImage IMG_SLIDER_HANDLE;
        const QImage IMG_SLIDER_GROOVE;

        H_Slider_Theme_1 ()
                //: IMG_SLIDER_HANDLE (":/new/prefix2/Interface/Theme/folder.png"),
                //IMG_SLIDER_GROOVE (":/new/prefix2/Interface/Theme/folder.png")
        {
        };

        virtual void drawComplexControl (ComplexControl control,
                   const QStyleOptionComplex* option,
                   QPainter* painter,
                   const QWidget* widget) const;
};

void
        H_Slider_Theme_1::drawComplexControl (ComplexControl control,
                const QStyleOptionComplex* option,
                QPainter* painter,
                const QWidget* widget) const
{
                switch (control)
                {
                        case (QStyle::CC_Slider):
                                if (const QStyleOptionSlider *sliderOption = qstyleoption_cast<const QStyleOptionSlider *>(option))
                                {
                                        QRect groove = QCommonStyle::subControlRect (CC_Slider, sliderOption, SC_SliderGroove, widget);
                                        QRect handle = QCommonStyle::subControlRect (CC_Slider, sliderOption, SC_SliderHandle, widget);

                                        if ((sliderOption->subControls & SC_SliderGroove) && groove.isValid())
                                        {
                                                painter->setRenderHint(QPainter::Antialiasing,true);
                                                painter->drawPixmap(0,0,-1,-1,QPixmap(":/Interface/Interface/fond_pb.png"));
                                        }

                                        if (sliderOption->subControls & SC_SliderHandle)
                                        {
                                                if ( handle.x () > 0 )
                                                {
                                                        painter->drawPixmap(0,0,-1,-1,QPixmap(":/Interface/Interface/fond_pb2.png"),0,0,handle.x()+10,-1);
                                                }
                                                painter->setPen(Qt::SolidLine);
                                                painter->setBrush(QColor(205,224,228,255));
                                                QPointF points[3] = {
                                                        QPointF(handle.x(), 0),
                                                        QPointF(handle.x()+10, 0),
                                                        QPointF(handle.x()+10,10),
                                                };
                                                painter->drawPolygon(points, 3);
                                        }
                                }
                                break;
                                default:
                                QWindowsStyle::drawComplexControl (control, option, painter, widget);
                }
}

// **************************************************************
// *** DEFINITION DU STYLE D'UN SLIDER POUR DIFFERENTS SLIDER ***
// **************************************************************

class H_Slider_Theme_2 : public QWindowsStyle
{
        protected:

        public:
        const QImage IMG_SLIDER_HANDLE;
        const QImage IMG_SLIDER_GROOVE;

        H_Slider_Theme_2 ()
                //: IMG_SLIDER_HANDLE (":/new/prefix2/Interface/Theme/folder.png"),
                //IMG_SLIDER_GROOVE (":/new/prefix2/Interface/Theme/folder.png")
        {
        };

        virtual void drawComplexControl (ComplexControl control,
                   const QStyleOptionComplex* option,
                   QPainter* painter,
                   const QWidget* widget) const;
};

void
        H_Slider_Theme_2::drawComplexControl (ComplexControl control,
                const QStyleOptionComplex* option,
                QPainter* painter,
                const QWidget* widget) const
{
                switch (control)
                {
                        case (QStyle::CC_Slider):
                                if (const QStyleOptionSlider *sliderOption = qstyleoption_cast<const QStyleOptionSlider *>(option))
                                {
                                        QRect groove = QCommonStyle::subControlRect (CC_Slider, sliderOption, SC_SliderGroove, widget);
                                        QRect handle = QCommonStyle::subControlRect (CC_Slider, sliderOption, SC_SliderHandle, widget);

                                        if ((sliderOption->subControls & SC_SliderGroove) && groove.isValid())
                                        {
                                                QLinearGradient Gradient(0.0,0.0,0.0,widget->height());
                                                Gradient.setColorAt(0.0, QColor(204,204,204));
                                                Gradient.setColorAt(1.0, QColor(176,176,176));
                                                painter->setRenderHint(QPainter::Antialiasing,true);
                                                painter->setPen(QColor(119,119,119));
                                                painter->setBrush(Gradient);
                                                painter->drawRect(0,0,widget->width(),widget->height());
                                        }

                                        QPalette mypal = QApplication::palette();

                                        if (sliderOption->subControls & SC_SliderHandle)
                                        {
                                                if ( handle.x () > 0 )
                                                {
                                                        QLinearGradient Gradient(0.0,0.0,0.0,widget->height());
                                                        if ( widget->whatsThis() == "" )
                                                        {
                                                            if ( widget->isEnabled() == true )
                                                            {
                                                                QColor wl_color_1 = mypal.color(QPalette::Normal, QPalette::Highlight);
                                                                Gradient.setColorAt(0.0, wl_color_1.darker(80));
                                                                Gradient.setColorAt(1.0, wl_color_1);
                                                            }
                                                            else
                                                            {
                                                                QColor wl_color_1 = mypal.color(QPalette::Inactive, QPalette::Window);
                                                                Gradient.setColorAt(0.0, wl_color_1.darker(80));
                                                                Gradient.setColorAt(1.0, wl_color_1.darker(60));
                                                            }
                                                        }
                                                        else
                                                        {
                                                            if ( widget->isEnabled() == true )
                                                            {
                                                                if ( widget->whatsThis() == "R" )
                                                                {
                                                                        Gradient.setColorAt(0.0, QColor(252,98,1));
                                                                        Gradient.setColorAt(1.0, QColor(255,37,0));
                                                                }
                                                                else
                                                                {
                                                                        if ( widget->whatsThis() == "G" )
                                                                        {
                                                                                Gradient.setColorAt(0.0, QColor(159,255,0));
                                                                                Gradient.setColorAt(1.0, QColor(24,234,0));
                                                                        }
                                                                        else
                                                                        {
                                                                            if ( widget->whatsThis() == "B" )
                                                                            {
                                                                                    Gradient.setColorAt(0.0, QColor(0,159,255));
                                                                                    Gradient.setColorAt(1.0, QColor(0,24,234));
                                                                            }
                                                                            else
                                                                            {
                                                                                    Gradient.setColorAt(0.0, QColor(255,255,255));
                                                                                    Gradient.setColorAt(1.0, QColor(222,222,222));
                                                                            }
                                                                        }
                                                                }
                                                            }
                                                            else
                                                            {
                                                                QColor wl_color_1 = mypal.color(QPalette::Inactive, QPalette::Window);
                                                                Gradient.setColorAt(0.0, wl_color_1.darker(80));
                                                                Gradient.setColorAt(1.0, wl_color_1.darker(60));
                                                            }
                                                        }
                                                        painter->setRenderHint(QPainter::Antialiasing,true);
                                                        painter->setPen(QColor(119,119,119));
                                                        painter->setBrush(Gradient);
                                                        painter->drawRect(0,0,handle.x()+8,widget->height());
                                                }
                                                else
                                                {
                                                        QLinearGradient Gradient(0.0,0.0,0.0,widget->height());
                                                        if ( widget->whatsThis() == "" )
                                                        {
                                                            if ( widget->isEnabled() == true )
                                                            {
                                                                QColor wl_color_1 = mypal.color(QPalette::Normal, QPalette::Highlight);
                                                                Gradient.setColorAt(0.0, wl_color_1.darker(80));
                                                                Gradient.setColorAt(1.0, wl_color_1);
                                                            }
                                                            else
                                                            {
                                                                QColor wl_color_1 = mypal.color(QPalette::Inactive, QPalette::Window);
                                                                Gradient.setColorAt(0.0, wl_color_1.darker(80));
                                                                Gradient.setColorAt(1.0, wl_color_1.darker(60));
                                                            }
                                                        }
                                                        else
                                                        {
                                                            if ( widget->isEnabled() == true )
                                                            {
                                                                if ( widget->whatsThis() == "R" )
                                                                {
                                                                        Gradient.setColorAt(0.0, QColor(252,98,1));
                                                                        Gradient.setColorAt(1.0, QColor(255,37,0));
                                                                }
                                                                else
                                                                {
                                                                        if ( widget->whatsThis() == "G" )
                                                                        {
                                                                                Gradient.setColorAt(0.0, QColor(159,255,0));
                                                                                Gradient.setColorAt(1.0, QColor(24,234,0));
                                                                        }
                                                                        else
                                                                        {
                                                                            if ( widget->whatsThis() == "B" )
                                                                            {
                                                                                    Gradient.setColorAt(0.0, QColor(0,159,255));
                                                                                    Gradient.setColorAt(1.0, QColor(0,24,234));
                                                                            }
                                                                            else
                                                                            {
                                                                                    Gradient.setColorAt(0.0, QColor(255,255,255));
                                                                                    Gradient.setColorAt(1.0, QColor(222,222,222));
                                                                            }
                                                                        }
                                                                }
                                                            }
                                                            else
                                                            {
                                                                QColor wl_color_1 = mypal.color(QPalette::Inactive, QPalette::Window);
                                                                Gradient.setColorAt(0.0, wl_color_1.darker(80));
                                                                Gradient.setColorAt(1.0, wl_color_1.darker(60));
                                                            }
                                                        }
                                                        painter->setRenderHint(QPainter::Antialiasing,true);
                                                        painter->setPen(QColor(119,119,119));
                                                        painter->setBrush(Gradient);
                                                        painter->drawRect(0,0,8,widget->height());
                                                }
                                                painter->setPen(QColor(255,255,255));
                                                QFont myfont;
                                                //myfont.setFamily("Nimbus Sans L");
                                                myfont.setPixelSize ( 10 );
                                                myfont.setBold(false);
                                                QColor wl_color_2 = mypal.color(QPalette::Active, QPalette::Text);
                                                painter->setPen(wl_color_2);
                                                painter->setFont(myfont);
                                                painter->drawText(QRect(5,0,widget->width()-5,widget->height()), Qt::AlignVCenter,widget->statusTip());
                                                painter->setPen(Qt::SolidLine);
                                                painter->setBrush(QColor(119,119,119,200));
                                                painter->drawLine(handle.x()+8,0,handle.x()+8,widget->height());
                                                painter->setBrush(QColor(0,0,0,255));
                                                QPointF points[3] = {
                                                        QPointF(handle.x()+6, 0),
                                                        QPointF(handle.x()+10, 0),
                                                        QPointF(handle.x()+8,4),
                                                };
                                                painter->drawPolygon(points, 3);
                                                QPointF points2[3] = {
                                                        QPointF(handle.x()+6, widget->height()),
                                                        QPointF(handle.x()+10, widget->height()),
                                                        QPointF(handle.x()+8,widget->height()-4),
                                                };
                                                painter->drawPolygon(points2, 3);
                                        }
                                }
                                break;
                                default:
                                QWindowsStyle::drawComplexControl (control, option, painter, widget);
                }
}

// ***************************************
// *** POINT D'ENTREE DE L'APPLICATION ***
// ***************************************

mainfrm::mainfrm(QWidget *parent) : QMainWindow(parent)
{
        QPixmap pixmap(":/Interface/Interface/splash.png");
        QPixmap pixmap1(":/Interface/Interface/splash1.png");
        QPixmap pixmap2(":/Interface/Interface/splash2.png");
        QPixmap pixmap3(":/Interface/Interface/splash3.png");
        QSplashScreen splash(pixmap);

        Qt::Alignment spal = Qt::AlignCenter | Qt::AlignBottom;
        splash.show();
        splash.showMessage("Loading interface",spal,Qt::white);
        //
        QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
        QTextCodec::setCodecForTr(QTextCodec::codecForName("UTF-8"));

        qDebug() << "LOCALE : " << QLocale::system().name().left(2);

        QString(DEF_BIBLIOTHEQUE);
        QString(DEF_TRANSLATIONS);
        QString(DEF_FAKE);

        // *** TEST SI COPIE BIBLIOTHEQUE DANS HOME ***

        QDir mydir( QDir::homePath() + "/.2ManDVD_Library/Bibliotheque/Luma" );
        //QDir mydir_2( QDir::homePath() + "/.2ManDVD_Library/Bibliotheque/");

        if ( mydir.exists() == false )
        {
            mydir.setPath(QDir::homePath());
            mydir.mkdir(".2ManDVD_Library");
            /*if ( mydir.mkdir(".2ManDVD_Library") == false && mydir_2.exists() == false )
            {
                qDebug()  << "ERROR CREATING FOLDER FOR 2MANDVD LIBRARY " << QDir::homePath() + "/.2ManDVD_Library";
                QMessageBox::information(this, name_application, tr("Erreur creation dossier bibliotheque : ") +  QDir::homePath() + "/.2ManDVD_Library");
            }
            else
            {*/
                qDebug()  << "COPY 2MANDVD LIBRARY INTO " << QDir::homePath() + "/.2ManDVD_Library/";

                QFile wmyficext;
                QTextStream outext(&wmyficext);

                wmyficext.setFileName(QDir::homePath() + "/.2ManDVD_Library/.copy.sh");
                wmyficext.open( QIODevice::WriteOnly );
                outext << "cd " + QDir::homePath() + "/.2ManDVD_Library/" << endl;
                outext << "cp -rf " << (QString)DEF_BIBLIOTHEQUE + "Bibliotheque . " << endl;
                outext << "exit" << endl;
                wmyficext.close();
                QString programf = "bash";
                QStringList argumentsf;
                argumentsf << QDir::homePath() + "/.2ManDVD_Library/.copy.sh";

                proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
                proc_ffmpeg.start(programf,argumentsf);

                proc_ffmpeg.waitForFinished(-1);

            //}
        }


        if ( QLocale::system().name().left(2) != "fr" )
	{
		QTranslator *qtTranslator = new QTranslator(this);

                if (qtTranslator->load("2mandvd_" + QLocale::system().name().left(2), (QString)DEF_TRANSLATIONS) == true )
		{
			qApp->installTranslator(qtTranslator);
		}
		else
		{
                        if (qtTranslator->load("2mandvd_en", (QString)DEF_TRANSLATIONS) == true )
			{
				qApp->installTranslator(qtTranslator);
			}
			else
			{
				qDebug() << "ERROR LOADING ENGLISH LANGUAGE";
			}
		}
        }

	setupUi(this);

        // *** ZONE 3D ET REGLES DE BASE ***
        frame_smile->hide();

        // *** PREPARATION DE L'INTERFACE POUR DEMARRAGE DE 2MANDVD ***
        smenuBar->hide();
        this->setGeometry((QApplication::desktop()->screenGeometry(0).width()-frame_new_proj->width())/2,(QApplication::desktop()->screenGeometry(0).height()-frame_new_proj->height())/2,frame_new_proj->width(),frame_new_proj->height());
        this->setMinimumSize(frame_new_proj->width(),frame_new_proj->height());
        this->setMaximumSize(frame_new_proj->width(),frame_new_proj->height());
        frame_new_proj->setGeometry(0,0,frame_new_proj->width(),frame_new_proj->height());

        frame_apropos->setStatusTip(tr("A propos ... 2ManDVD ") + "1.8.5");
        mysynctime.start();

	nbre_threads = QThread::idealThreadCount();
	if ( nbre_threads <= 0 )
	{
		nbre_threads = 1;
	}
        if ( nbre_threads > 8 )
        {
                nbre_threads = 8;
        }
        spin_thread->setValue(nbre_threads);

        hdlpf = new PictureFlow(label_img_thumb);
        hdlpf->setBackgroundColor(QApplication::palette().color(QPalette::Normal, QPalette::Window));
        hdlpf->setReflectionEffect(PictureFlow::PlainReflection);
        hdlpf->setSlideSize(QSize(400, 320));
	connect(hdlpf, SIGNAL(nximg()),this, SLOT(f_next_thumb()));
	connect(hdlpf, SIGNAL(pvimg()),this, SLOT(f_prev_thumb()));

	// *** INITIALISATIONS ***
	QDir homeDir = QDir::homePath();

	path_img_menu = homeDir.path();
	path_media_import = homeDir.path();
        path_media_import_smile = homeDir.path();
	path_background = homeDir.path();
	path_save = homeDir.path();
	path_capture = homeDir.path();
	path_language = homeDir.path();

        // *** PREPARATION DE LA BARRE DE NAVIGATION ***
        QStringList wl_explode = path_media_import.split("/",QString::SkipEmptyParts);
        int wl_int_001 = 0;
        lengthbar = 0;

        toolbar_bt4 *newpt;

        newpt = new toolbar_bt4(frame_support_path);
        connect(newpt, SIGNAL(chgdir(toolbar_bt4*)),this, SLOT(f_chgdir(toolbar_bt4*)));
        newpt->setGeometry(6,3,21,26);
        newpt->setText("/");
        newpt->show();

        newpt = new toolbar_bt4(frame_support_path_smile);
        connect(newpt, SIGNAL(chgdir(toolbar_bt4*)),this, SLOT(f_chgdir_smile(toolbar_bt4*)));
        newpt->setGeometry(6,3,21,26);
        newpt->setText("/");
        newpt->show();

        lengthbar = 24;
        lengthbar_smile = 24;
        int wl_larg_txt = 0;

        while ( wl_int_001 < wl_explode.count() )
        {
                newpt = new toolbar_bt4(frame_support_path);
                connect(newpt, SIGNAL(chgdir(toolbar_bt4*)),this, SLOT(f_chgdir(toolbar_bt4*)));

                QFontMetrics fm(newpt->myfont);
                wl_larg_txt = fm.width(wl_explode.at(wl_int_001));

                newpt->setGeometry(lengthbar+3,3,wl_larg_txt+15,26);
                lengthbar = lengthbar + newpt->width()+3;
                newpt->setText(wl_explode.at(wl_int_001));
                newpt->show();
                table_hdl_medbrow[wl_int_001] = newpt;
                wl_int_001++;
        }

        wl_int_001 = 0;
        while ( wl_int_001 < wl_explode.count() )
        {
                newpt = new toolbar_bt4(frame_support_path_smile);
                connect(newpt, SIGNAL(chgdir(toolbar_bt4*)),this, SLOT(f_chgdir_smile(toolbar_bt4*)));

                QFontMetrics fm(newpt->myfont);
                wl_larg_txt = fm.width(wl_explode.at(wl_int_001));

                newpt->setGeometry(lengthbar_smile+3,3,wl_larg_txt+15,26);
                lengthbar_smile = lengthbar_smile + newpt->width()+3;
                newpt->setText(wl_explode.at(wl_int_001));
                newpt->show();
                table_hdl_medbrow_smile[wl_int_001] = newpt;
                wl_int_001++;
        }

	name_application = "2ManDVD";
	nbre_medias = 0;
	draw_contours = 0;
	current_media = 0;
	is_new_create = 0;
	nbre_menus = 0;
	nbre_menus_wo_label = 0;
        nbre_diapos = 0;
        remember_status = 0;
        must_update = 0;
	dvd_actual_size = 0;
	hdl_current_menu = 0;
	special_delete = 0;
	dvdzone = 0;
        nbre_audio_track = 0;
        timeline_diapo->nbre_audio_track = nbre_audio_track;
	current_tool = 2;
	player_isplaying = false;
	dvdxsize = 720;
	dvdysize = 576;
	current_menu_audio = "";
	current_menu_intro = "";
	path_always_save = "";
        whereopenfrom = 0;

        frame_slider_pos->wl_action = "FAKEFORARBO2";
        frame_slider_pos_thumb->wl_action = "FAKEFORARBO2";

	wg_str_int_001 = tr("Debut de la video");
	wg_str_int_002 = tr("Aucune action");
	wg_str_int_003 = tr("Menu principal");
	wg_str_int_004 = tr("Aucun");
	wg_str_int_005 = tr("Pause");
	wg_str_int_006 = tr("Original soundtrack");

	// *** CREATION DE L'INTERFACE ***
        frame_player_media->setAttribute(Qt::WA_NoSystemBackground);
        frame_player_media->setAttribute(Qt::WA_PaintOnScreen,true);
        frame_player_media->setAttribute(Qt::WA_PaintUnclipped,true);

        frame_player_result->setAttribute(Qt::WA_NoSystemBackground);
        frame_player_result->setAttribute(Qt::WA_PaintOnScreen,true);
        frame_player_result->setAttribute(Qt::WA_PaintUnclipped,true);

        frame_player_adjust->setAttribute(Qt::WA_NoSystemBackground);
        frame_player_adjust->setAttribute(Qt::WA_PaintOnScreen,true);
        frame_player_adjust->setAttribute(Qt::WA_PaintUnclipped,true);

	H_Slider_Theme_1* style_hslider1 = new H_Slider_Theme_1();
	slider_bitrate->setStyle(style_hslider1);

	H_Slider_Theme_2* style_hslider2 = new H_Slider_Theme_2();
	dial_alpha_menu->setStyle(style_hslider2);
	dial_opacity_shadow->setStyle(style_hslider2);
	dial_angle_shadow->setStyle(style_hslider2);
	slider_player->setStyle(style_hslider2);
        slider_player_thumb->setStyle(style_hslider2);
	slider_con->setStyle(style_hslider2);
	slider_bri->setStyle(style_hslider2);
	slider_sat->setStyle(style_hslider2);
        slider_sub_pos->setStyle(style_hslider2);
        slider_sub_siz->setStyle(style_hslider2);
	designer_brush_width->setStyle(style_hslider2);
        pencil_brush_width->setStyle(style_hslider2);
        pencil_brush_opacity->setStyle(style_hslider2);
        pencil_brush_opacity_2->setStyle(style_hslider2);
	slider_custo_red->setStyle(style_hslider2);
	slider_custo_green->setStyle(style_hslider2);
	slider_custo_blue->setStyle(style_hslider2);
	slider_custo_opacity->setStyle(style_hslider2);

    slider_slide_red->setStyle(style_hslider2);
    slider_slide_green->setStyle(style_hslider2);
    slider_slide_blue->setStyle(style_hslider2);

        slider_opa_slide->setStyle(style_hslider2);
        slider_blur_img->setStyle(style_hslider2);
        sl_esp_ana->setStyle(style_hslider2);
        sl_sca_diapo->setStyle(style_hslider2);
        sl_part_nombre->setStyle(style_hslider2);
        sl_part_size->setStyle(style_hslider2);
        sl_part_prof->setStyle(style_hslider2);
        sl_part_speed->setStyle(style_hslider2);

        slider_size_x_scale->setStyle(style_hslider2);
        slider_size_y_scale->setStyle(style_hslider2);
        slider_size_x_scale_2->setStyle(style_hslider2);
        slider_size_y_scale_2->setStyle(style_hslider2);

	// *** MISE EN PLACE DE L'INTERFACE ****

        QPixmap wl_pix_001(QApplication::desktop()->width(),QApplication::desktop()->height());

	mask_interface->setGeometry(0,0,QApplication::desktop()->width(),QApplication::desktop()->height());
	mask_interface->show();
	mask_interface->raise();

        frame_directory_smile->hide();
        frame_trans_smile_prev->hide();
	frame_infos->hide();
	frame_render->hide();
	frame_directory->hide();
	frame_scale_background->hide();
        frame_scale_media->hide();
	frame_dispatch->hide();
	frame_chapitrage->hide();
	frame_endencoding->hide();
	lst_chapters_2->hide();
	h_regle->hide();
	v_regle->hide();
        frame_tab_info->hide();
	sur_blend->hide();
	frame_apropos->hide();
        frame_drawing_menu->hide();
	frame_choose_thumb->hide();
	frame_iso->hide();
	frame_customize->hide();
	frame_burn->hide();
	frame_reencode->hide();
	frame_overlays->hide();
	frame_advanced->hide();
	frame_transitions->hide();
	safety_zone->hide();
        magnetic_grid->hide();
	frame_quoifaire_after->hide();
	frame_mapzone->hide();
	frame_organize->hide();
	label_mouse->hide();
	frame_add_theme->hide();
	stamp_position_extract->hide();
	frame_preview_image->hide();
	frame_language->hide();
	frame_edit_overlay->hide();
	frame_preferences->hide();
	frame_tree->hide();
	list_language_2->hide();
	list_after_2->hide();
	frame_preview_finish->hide();
	frame_adjust_thumb->hide();
        tabwidget_main->hide();
        frame_medias->hide();
        scroll_timeline->hide();
        frame_left_menu->show();
        frame_support_preview_anim->hide();
        frame_licence->hide();
        //frame_smile->hide();
        frame_image_editor->hide();
        frame_choose_encode->hide();
        frame_render_smile->hide();
        frame_holy_param->hide();
        frame_holy->hide();
        frame_load_diapo->hide();
        frame_smile_effect->hide();

	bt_bt_img->setDisabled(true);
	bttxt->setDisabled(true);
	frame_th_msk_idea->setDisabled(true);
	combo_quoilire_media->setDisabled(true);
	combo_quoilire_media_chapitre->setDisabled(true);
	combo_quoilire_menu->setDisabled(true);
	combo_select_langue->setDisabled(true);
	check_anim->setDisabled(true);
	smenuBar->setDisabled(true);
	dial_alpha_menu->setDisabled(true);
	actionEnregistrer_2->setDisabled(true);
	actionGraver_le_DVD->setDisabled(true);
	actionGenerer_l_image_ISO_du_DVD->setDisabled(true);
	actionRevoir_la_derniere_generation->setDisabled(true);
	actionOrdre_de_tabulation->setDisabled(true);
	actionCopier_le_bouton->setDisabled(true);
	actionColler_le_bouton->setDisabled(true);
        combo_format_dvd->setDisabled(true);

	fond_preview->setGeometry(0,0,frame_preview_image->width(),frame_preview_image->height());

	bt_dispatch_1->pixbt.load(":/Interface/Interface/multi2.png");
	bt_dispatch_2->pixbt.load(":/Interface/Interface/multi3.png");
	bt_dispatch_3->pixbt.load(":/Interface/Interface/multi4.png");
	bt_dispatch_4->pixbt.load(":/Interface/Interface/multi5.png");
	bt_dispatch_5->pixbt.load(":/Interface/Interface/multi6.png");

	bt_dispatch_1->pixbu.load(":/Interface/Interface/multi2_1.png");
	bt_dispatch_2->pixbu.load(":/Interface/Interface/multi3_1.png");
	bt_dispatch_3->pixbu.load(":/Interface/Interface/multi4_1.png");
	bt_dispatch_4->pixbu.load(":/Interface/Interface/multi5_1.png");
	bt_dispatch_5->pixbu.load(":/Interface/Interface/multi6_1.png");

        h_regle->setGeometry(0,(this->height()-31)/2,frame_editor->width()-frame_pro->width(),21);
        v_regle->setGeometry((this->width()-31)/2,0,21,frame_editor->height()-bottom_menu->height()-smenuBar->height());

	label_position->setText(tr("Position : 0;0"));
	label_size->setText(tr("Taille : 0x0"));
	label_rotation->setText(tr("Rotation : 0"));

	frame_support_menuthumb->setGeometry(0,0,530,106);

	bt_dispatch_1->hasback = 1;
	bt_dispatch_2->hasback = 1;
	bt_dispatch_3->hasback = 1;
	bt_dispatch_4->hasback = 1;
	bt_dispatch_5->hasback = 1;

	// *** CREATION DES COLOR WHEEL ***
        wheel_red = 0;
        wheel_green = 0;
        wheel_blue = 0;

        pntwheel1 = new ColorPickerWidget(wheel_over);
        connect(pntwheel1, SIGNAL(finchange()),this, SLOT(f_preview_overlay()));
        connect(pntwheel1, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel1, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));
	pntwheel1->show();

        pntwheel2 = new ColorPickerWidget(wheel_clic);
	connect(pntwheel2, SIGNAL(finchange()),this, SLOT(f_preview_overlay()));
        connect(pntwheel2, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel2, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));
	pntwheel2->show();

        pntwheel3 = new ColorPickerWidget(wheel_txt);
	pntwheel3->setColor(0,0,0);
	pntwheel3->show();
	connect(pntwheel3, SIGNAL(finchange()),this, SLOT(f_valide_color_txt()));
        connect(pntwheel3, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel3, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));

        pntwheel4 = new ColorPickerWidget(wheel_txt_shadow);
	pntwheel4->setColor(0,0,0);
	pntwheel4->show();
	connect(pntwheel4, SIGNAL(finchange()),this, SLOT(f_valide_color_txt_shadow()));
        connect(pntwheel4, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel4, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));

        pntwheel5 = new ColorPickerWidget(wheel_txt_dispatch);
        connect(pntwheel5, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel5, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));
	pntwheel5->setColor(255,255,255);
	pntwheel5->show();

        pntwheel6 = new ColorPickerWidget(wheel_pencil);
        connect(pntwheel6, SIGNAL(finchange()),this, SLOT(f_valide_color_pencil()));
        connect(pntwheel6, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel6, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));
        pntwheel6->setColor(255,255,255);
        pntwheel6->show();

        pntwheel7 = new ColorPickerWidget(wheel_pencil_2);
        connect(pntwheel7, SIGNAL(finchange()),this, SLOT(f_valide_color_pencil_2()));
        connect(pntwheel7, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel7, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));
        pntwheel7->setColor(255,255,255);
        pntwheel7->show();

        pntwheel8 = new ColorPickerWidget(wheel_back_slide);
        connect(pntwheel8, SIGNAL(finchange()),this, SLOT(f_color_back_slide()));
        connect(pntwheel8, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel8, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));
        pntwheel8->setColor(0,0,0);
        pntwheel8->show();

        pntwheel9 = new ColorPickerWidget(wheel_fog);
        connect(pntwheel9, SIGNAL(finchange()),this, SLOT(f_color_fog()));
        connect(pntwheel9, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel9, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));
        pntwheel9->setColor(220,220,220);
        pntwheel9->show();

        pntwheel10 = new ColorPickerWidget(wheel_txt_col_slide);
        connect(pntwheel10, SIGNAL(finchange()),this, SLOT(f_color_txt_slide()));
        connect(pntwheel10, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel10, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));
        pntwheel10->setColor(255,255,255);
        pntwheel10->show();

        pntwheel11 = new ColorPickerWidget(wheel_backmenu);
        connect(pntwheel11, SIGNAL(finchange()),this, SLOT(f_color_fd_menu()));
        connect(pntwheel11, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel11, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));
        pntwheel11->setColor(0,0,0);
        pntwheel11->show();

        pntwheel12 = new ColorPickerWidget(wheel_backmenu_2);
        connect(pntwheel12, SIGNAL(finchange()),this, SLOT(f_color_fd_menu()));
        connect(pntwheel12, SIGNAL(copier(ColorPickerWidget*)),this, SLOT(f_triangle_copier(ColorPickerWidget*)));
        connect(pntwheel12, SIGNAL(coller(ColorPickerWidget*)),this, SLOT(f_triangle_coller(ColorPickerWidget*)));
        pntwheel12->setColor(0,0,0);
        pntwheel12->show();

	// *** DEFINITION DES THREADS ***
        thread_ani = new thani();
	connect(thread_ani, SIGNAL(finanim()),this, SLOT(f_update_thumb_menu()));
	connect(thread_ani, SIGNAL(lockbar()),this, SLOT(f_lockbar()));
	connect(thread_ani, SIGNAL(fincache()),this, SLOT(f_gene_mencoder()));
        /*connect(thread_ani, SIGNAL(refreshit()),this, SLOT(f_refreshit()));*/

        thread_blend = new thblend();
        connect(thread_blend, SIGNAL(stepend()),this, SLOT(f_update_blend()));
        connect(thread_blend, SIGNAL(endblend()),this, SLOT(f_end_blend()));

        thread_img = new thimg();
	connect(thread_img, SIGNAL(myfin()),this, SLOT(f_refresh_customize()));

        thread_trans = new thptra();
	connect(thread_trans, SIGNAL(myfin()),this, SLOT(f_update_trans()));

        thread_save = new thsave();

	// *** DEFINITIONS DE BASE DES COMBOS ***
	combo_quoilire_media->insertItem(0,wg_str_int_002);

	combo_quoilire_menu->insertItem(0,wg_str_int_002);
	combo_quoilire_menu->insertItem(1,wg_str_int_003);

	combo_format_dvd->insertItem(0,"PAL 4/3");
	combo_format_dvd->setItemIcon(0, QIcon(":/Interface/Interface/palntsc.png"));
	combo_format_dvd->insertItem(1,"PAL 16/9");
	combo_format_dvd->setItemIcon(1, QIcon(":/Interface/Interface/palntsc.png"));
	combo_format_dvd->insertItem(2,"NTSC 4/3");
	combo_format_dvd->setItemIcon(2, QIcon(":/Interface/Interface/palntsc.png"));
	combo_format_dvd->insertItem(3,"NTSC 16/9");
	combo_format_dvd->setItemIcon(3, QIcon(":/Interface/Interface/palntsc.png"));

	combo_format_vmax->insertItem(0,tr("2600 Kbps (Basse)"));
	combo_format_vmax->insertItem(1,tr("5000 Kbps (Recommande)"));
	combo_format_vmax->insertItem(2,tr("9800 Kbps (Haute)"));

	combo_format_audio->insertItem(0,tr("MP2 - Stereo"));
	combo_format_audio->insertItem(1,tr("AC3 - Dolby"));
	combo_format_audio->setCurrentIndex(1);

        combo_player->insertItem(0,"Xine");
        combo_player->insertItem(1,"MPlayer (DVDNAV Experimental)");
        combo_player->setCurrentIndex(0);

        combo_od->insertItem(0,tr("Rouge"));
        combo_od->insertItem(1,tr("Vert"));
        combo_od->insertItem(2,tr("Bleu"));
        combo_od->insertItem(3,tr("Magenta"));
        combo_od->insertItem(4,tr("Cyan"));
        combo_od->setCurrentIndex(3);

        combo_og->insertItem(0,tr("Rouge"));
        combo_og->insertItem(1,tr("Vert"));
        combo_og->insertItem(2,tr("Bleu"));
        combo_og->insertItem(3,tr("Magenta"));
        combo_og->insertItem(4,tr("Cyan"));
        combo_og->setCurrentIndex(1);

        combo_fmt_smile->insertItem(0,tr("MPEG2 - Qualite haute"));
        combo_fmt_smile->setItemIcon(0, QIcon(":/Interface/Interface/mpg.png"));
        combo_fmt_smile->insertItem(1,tr("MPEG2 - Qualite normale"));
        combo_fmt_smile->setItemIcon(1, QIcon(":/Interface/Interface/mpg.png"));
        combo_fmt_smile->insertItem(2,tr("MPEG2 - Qualite basse"));
        combo_fmt_smile->setItemIcon(2, QIcon(":/Interface/Interface/mpg.png"));
        combo_fmt_smile->insertItem(3,tr("JPEG - Qualite haute"));
        combo_fmt_smile->setItemIcon(3, QIcon(":/Interface/Interface/img.png"));
        combo_fmt_smile->insertItem(4,tr("JPEG - Qualite normale"));
        combo_fmt_smile->setItemIcon(4, QIcon(":/Interface/Interface/img.png"));
        combo_fmt_smile->insertItem(5,tr("JPEG - Qualite basse"));
        combo_fmt_smile->setItemIcon(5, QIcon(":/Interface/Interface/img.png"));
        combo_fmt_smile->insertItem(6,tr("WEB - Youtube"));
        combo_fmt_smile->setItemIcon(6, QIcon(":/Interface/Interface/youtube.png"));
        combo_fmt_smile->insertItem(7,tr("MPEG4 - HD"));
        combo_fmt_smile->setItemIcon(7, QIcon(":/Interface/Interface/hd.png"));
        combo_fmt_smile->setCurrentIndex(1);

        combo_pardiapauto->insertItem(0,tr("Par nom"));
        combo_pardiapauto->insertItem(1,tr("Par date"));
        combo_pardiapauto->insertItem(2,tr("Par taille disque"));
        combo_pardiapauto->setCurrentIndex(0);

        combo_vmemory->insertItem(0,tr("Normales"));
        combo_vmemory->insertItem(1,tr("Grandes"));
        combo_vmemory->insertItem(2,tr("Tres grandes"));
        combo_vmemory->setCurrentIndex(0);

        combo_fmtpn->insertItem(0,tr("PAL"));
        combo_fmtpn->insertItem(1,tr("NTSC"));
        combo_fmtpn->setCurrentIndex(0);

        combo_fmt14->insertItem(0,tr("4:3"));
        combo_fmt14->insertItem(1,tr("16:9"));
        combo_fmt14->setCurrentIndex(0);

        // *** EFFECTS ***
        myeffect_global = new QGraphicsOpacityEffect();
        myeffect_global->setOpacity(0.0);
        scroll_timeline_smile->setAttribute(Qt::WA_TranslucentBackground, true);
        scroll_timeline_smile->setGraphicsEffect(myeffect_global);

        myeffect_global_sb_medias = new QGraphicsOpacityEffect();
        myeffect_global_sb_medias->setOpacity(0.0);
        sb_medias->setAttribute(Qt::WA_TranslucentBackground, true);
        sb_medias->setGraphicsEffect(myeffect_global_sb_medias);

	// *** CHARGEMENT DES BIBLIOTHEQUES ***

        splash.showMessage("Loading themes and masks",spal,Qt::white);
        splash.setPixmap(pixmap1);

	QDir tmpdir;
        tmpdir.setPath(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/");
	QStringList filters;
	filters << "*.png" << "*.PNG";
	tmpdir.setNameFilters(filters);

	QListWidgetItem *item = new QListWidgetItem(frame_th_msk_idea);
	item->setIcon(QIcon(":/Interface/Interface/error.png"));
	item->setText(wg_str_int_004);

        QListWidgetItem *item2 = new QListWidgetItem(frame_th_msk_smile);
        item2->setIcon(QIcon(":/Interface/Interface/error.png"));
        item2->setText(wg_str_int_004);

	QPixmap wl_pix_002;
	QPainter p;
	foreach (wg_string_001, tmpdir.entryList(QDir::Files))
	{
		if ( wg_string_001.mid(0,3) != "2t_" )
		{
                        wl_pix_001.fill(QColor(0,0,0,0));
                        wl_pix_001.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/" + wg_string_001);
                        if ( wl_pix_002.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/2t_" + wg_string_001) == true )
			{
				p.begin(&wl_pix_001);
				p.drawPixmap(0,0,wl_pix_002);
				p.end();
			}
			QListWidgetItem *item = new QListWidgetItem(frame_th_msk_idea);
			item->setIcon(wl_pix_001);
			item->setText(wg_string_001.mid(0,wg_string_001.length()-4));
                        QListWidgetItem *item2 = new QListWidgetItem(frame_th_msk_smile);
                        item2->setIcon(wl_pix_001);
                        item2->setText(wg_string_001.mid(0,wg_string_001.length()-4));
		}
	}
	frame_th_msk_idea->sortItems( Qt::AscendingOrder );
        frame_th_msk_smile->sortItems( Qt::AscendingOrder );

        tmpdir.setPath(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/");
	filters << "*.gif";
	tmpdir.setNameFilters(filters);

	foreach (wg_string_001, tmpdir.entryList(QDir::Files))
	{
                wl_pix_001.fill(QColor(0,0,0,0));
                wl_pix_001.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + wg_string_001);
		QListWidgetItem *item = new QListWidgetItem(frame_th_obj_idea);
		item->setIcon(wl_pix_001);
		item->setText(wg_string_001.mid(0,wg_string_001.length()-4));

                QListWidgetItem *item2 = new QListWidgetItem(frame_th_ani_smile);
                item2->setIcon(wl_pix_001);
                item2->setText(wg_string_001.mid(0,wg_string_001.length()-4));
	}
	frame_th_obj_idea->sortItems( Qt::AscendingOrder );
        frame_th_ani_smile->sortItems( Qt::AscendingOrder );

	// *** FLAGS ***

        frame_th_the_idea->pathname = QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/";
        frame_th_the_idea->top_pathname = QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/";
	frame_th_the_idea->f_load_theme(); // *** THEMES ***

        // *** TRANSITIONS ***
        splash.showMessage("Loading transitions",spal,Qt::white);
        splash.setPixmap(pixmap2);

        tmpdir.setPath(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/");
	filters << "*.png" << "*.PNG";
	tmpdir.setNameFilters(filters);
	QString wlfile;
        int wl_pos_cpt = 1;
        nombre_transitions = 0;
        lst_trans_smile->insertItem(0,wg_str_int_004);
        combo_pardiapauto_trans->insertItem(0,wg_str_int_004);

	foreach (wlfile, tmpdir.entryList())
	{
                wg_pix_001.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/"+wlfile);
		wg_pix_001 = wg_pix_001.scaledToWidth( 128, Qt::FastTransformation );
		QListWidgetItem *item = new QListWidgetItem(lst_transitions);
		item->setIcon(QIcon(wg_pix_001));
                item->setText(wlfile.mid(0,wlfile.length()-4));

                lst_trans_smile->insertItem(wl_pos_cpt,wlfile.mid(0,wlfile.length()-4));
                lst_trans_smile->setItemIcon(wl_pos_cpt, QIcon(wg_pix_001));

                combo_pardiapauto_trans->insertItem(wl_pos_cpt,wlfile.mid(0,wlfile.length()-4));
                combo_pardiapauto_trans->setItemIcon(wl_pos_cpt, QIcon(wg_pix_001));

                nombre_transitions++;
                wl_pos_cpt++;
	}

        combo_pardiapauto_trans->setCurrentIndex(combo_pardiapauto_trans->findText("crossfade"));

        QFile lumafile( QDir::homePath() + "/.2ManDVD_Library/" + "/Bibliotheque/table_luma.dat" );

        wl_pos_cpt = 0;
        QStringList wl_expluma;
        QByteArray newData;
        int oldposluma = 1;

        if (lumafile.open(QFile::ReadOnly))
        {
            while ( lumafile.atEnd() == false )
            {
                newData = lumafile.readLine(0);
                wg_string_001 = QString::fromLocal8Bit(newData);
                wg_string_001 = wg_string_001.simplified();
                wg_string_001 = wg_string_001.mid(0, newData.count() - 1);

                wl_expluma = wg_string_001.split(";",QString::KeepEmptyParts);

                if ( oldposluma != wl_expluma.at(0).toInt() )
                {
                    trans_page_count[oldposluma] = wl_pos_cpt;
                    wl_pos_cpt = 0;
                    oldposluma = wl_expluma.at(0).toInt();
                }
                table_lumas[wl_expluma.at(0).toInt()][wl_pos_cpt] = wl_expluma.at(1);
                table_lumas[wl_expluma.at(0).toInt()][wl_pos_cpt+1] = "";

                wl_pos_cpt++;
             }
             trans_page_count[oldposluma] = wl_pos_cpt;
             lumafile.close();
        }
        table_lumas[wl_expluma.at(0).toInt()+1][0] = "";

        // *** MODELES 3D ***
        QFile modelefile( QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/3d/ani3d.dat" );
        wl_pos_cpt = 0;
        int wl_pos_cpt_2 = 0;
        nombre_themes_3d = 0;
        QString wl_name = "";
        QString wl_coord = "";

        if (modelefile.open(QFile::ReadOnly))
        {

            while ( modelefile.atEnd() == false )
            {
                newData = modelefile.readLine(0);
                wg_string_001 = QString::fromLocal8Bit(newData);
                wg_string_001 = wg_string_001.simplified();
                wg_string_001 = wg_string_001.mid(0, newData.count() - 1);

                if ( wl_pos_cpt == 0 )
                {
                    wl_name = wg_string_001;
                    wl_pos_cpt++;
                }
                else
                {
                    if ( wg_string_001.mid(0,3) == "---" )
                    {
                        QListWidgetItem *item = new QListWidgetItem(frame_support_th3d);
                        item->setIcon(QIcon(":/Interface/Interface/theme.png"));
                        item->setStatusTip(wl_coord);
                        item->setText(wl_name);

                        wl_pos_cpt_2++;
                        wl_pos_cpt = 0;
                        wl_coord = "";
                        nombre_themes_3d++;
                    }
                    else
                    {
                        if ( wl_coord == "" )
                        {
                            wl_coord = wg_string_001;
                        }
                        else
                        {
                            wl_coord = wl_coord + "_" + wg_string_001;
                        }
                    }
                }
            }

            frame_support_th3d->sortItems(Qt::AscendingOrder);
            modelefile.close();
        }

        // *** DIAPORAMA ***
        connect(screen_timeline, SIGNAL(position_timeline(int)),this, SLOT(f_display_position_timeline(int)));
        connect(screen_timeline, SIGNAL(mark()),this, SLOT(f_mark_pos()));
        connect(screen_timeline, SIGNAL(deplace_keyframe()),this, SLOT(f_deplace_keyframe()));
        connect(screen_timeline, SIGNAL(mark_visible(int)),this, SLOT(f_mark_visible(int)));
        connect(screen_timeline, SIGNAL(s_delete_position(int)),this, SLOT(f_s_delete_position(int)));
        connect(screen_timeline, SIGNAL(enter_timeline()),frame_lcd_position, SLOT(letvisible()));
        connect(screen_timeline, SIGNAL(exit_timeline()),frame_lcd_position, SLOT(lethidden()));
        connect(bt_cancel_slideshow, SIGNAL(clicked()),this, SLOT(f_bt_cancel_slideshow()));

        connect(spin_length_diapo, SIGNAL(valueChanged(int)),this, SLOT(f_change_length_diapo(int)));
        connect(spintrandur, SIGNAL(valueChanged(int)),this, SLOT(f_change_length_translide(int)));
        connect(bt_play_diapo, SIGNAL(clicked()),this, SLOT(f_play_diapo()));
        connect(bt_rwd_diapo, SIGNAL(clicked()),this, SLOT(f_rwd_diapo()));
        connect(bt_fwd_diapo, SIGNAL(clicked()),this, SLOT(f_fwd_diapo()));

        connect(bt_pro_smile, SIGNAL(clicked()),this, SLOT(f_pro_smile()));
        connect(bt_thm_smile, SIGNAL(clicked()),this, SLOT(f_thm_smile()));

        connect(timeline_diapo, SIGNAL(new_diapo()),this, SLOT(f_add_diapo()));
        connect(timeline_diapo, SIGNAL(godrop()),this, SLOT(f_godrop_diapo()));
        connect(timeline_diapo, SIGNAL(e_action_talea()),this, SLOT(f_action_talea()));
        connect(timeline_diapo, SIGNAL(s_add_sound()),this, SLOT(f_s_add_sound()));
        connect(timeline_diapo, SIGNAL(s_add_snd_drop(QString)),this, SLOT(f_s_add_sound_step_2(QString)));

        connect(timeline_diapo, SIGNAL(s_adj_sound()),this, SLOT(f_s_adj_sound()));
        connect(timeline_diapo, SIGNAL(s_del_sound()),this, SLOT(f_s_del_sound()));
        connect(timeline_diapo, SIGNAL(s_action_diapauto()),this, SLOT(f_actionDiaporama_automatique()));
        connect(timeline_diapo, SIGNAL(s_action_diapauto_fi()),this, SLOT(f_action_diapauto_fi()));
        connect(timeline_diapo, SIGNAL(s_slide_lst(int)),this, SLOT(f_s_slide_lst(int)));
        connect(timeline_diapo, SIGNAL(s_action_adjtime(int)),this, SLOT(f_s_action_adjtime(int)));

        connect(scroll_timeline_smile, SIGNAL(valueChanged(int)),this, SLOT(f_scroll_timeline_smile(int)));

        connect(slider_opa_slide, SIGNAL(valueChanged(int)),this, SLOT(f_slider_opa_slide(int)));
        connect(slider_blur_img, SIGNAL(valueChanged(int)),this, SLOT(f_slider_blur_slide(int)));

        connect(frame_th_msk_smile, SIGNAL(itemDoubleClicked ( QListWidgetItem* )),this, SLOT(f_select_them_smile()));
        connect(frame_support_th3d, SIGNAL(itemDoubleClicked ( QListWidgetItem* )),this, SLOT(f_load_theme_3d()));

        connect(lst_trans_smile, SIGNAL(currentIndexChanged(int)),this, SLOT(f_lst_trans_smile_changed(int)));

        connect(actionDiaporama_automatique, SIGNAL(triggered()),this, SLOT(f_actionDiaporama_automatique()));
        connect(actionAjouter_une_diapositive, SIGNAL(triggered()),this, SLOT(f_add_diapo()));

        connect(actionAfficher_cacher_grille_de_placement, SIGNAL(triggered()),this, SLOT(f_showhide_grid()));

        connect(bt_ok_param_diapauto, SIGNAL(clicked()), this, SLOT(f_actionDiaporama_automatique_1()));
        connect(bt_cancel_param_diapauto, SIGNAL(clicked()), this, SLOT(f_cancel_actionDiaporama_automatique()));

        connect(dial_smile_light, SIGNAL(valueChanged(int)),this, SLOT(f_dial_smile_light(int)));
        connect(dial_smile_contrast, SIGNAL(valueChanged(int)),this, SLOT(f_dial_smile_contraste(int)));

        connect(slider_slide_red, SIGNAL(valueChanged(int)),this, SLOT(f_slider_slide_color(int)));
        connect(slider_slide_green, SIGNAL(valueChanged(int)),this, SLOT(f_slider_slide_color(int)));
        connect(slider_slide_blue, SIGNAL(valueChanged(int)),this, SLOT(f_slider_slide_color(int)));

        connect(slider_size_x_scale, SIGNAL(valueChanged(int)),this, SLOT(f_slider_slide_chsize(int)));
        connect(slider_size_y_scale, SIGNAL(valueChanged(int)),this, SLOT(f_slider_slide_chsize(int)));
        connect(slider_size_x_scale_2, SIGNAL(valueChanged(int)),this, SLOT(f_slider_slide_chsize(int)));
        connect(slider_size_y_scale_2, SIGNAL(valueChanged(int)),this, SLOT(f_slider_slide_chsize(int)));

        connect(bt_valid_coord, SIGNAL(clicked()), this, SLOT(f_valid_coord_diapo()));

        connect(txt_px, SIGNAL(textChanged(QString)), this, SLOT(f_px_changed(QString)));
        connect(txt_py, SIGNAL(textChanged(QString)), this, SLOT(f_py_changed(QString)));
        connect(txt_pz, SIGNAL(textChanged(QString)), this, SLOT(f_pz_changed(QString)));

        connect(txt_rx, SIGNAL(textChanged(QString)), this, SLOT(f_rx_changed(QString)));
        connect(txt_ry, SIGNAL(textChanged(QString)), this, SLOT(f_ry_changed(QString)));
        connect(txt_rz, SIGNAL(textChanged(QString)), this, SLOT(f_rz_changed(QString)));

        connect(lst_calques, SIGNAL(itemChanged(QListWidgetItem*)), this, SLOT(f_chk_calq(QListWidgetItem*)));
        connect(lst_calques, SIGNAL(select_clq(QListWidgetItem*)), this, SLOT(f_chk_calq(QListWidgetItem*)));
        connect(lst_calques, SIGNAL(delete_row(int)),this, SLOT(f_delete_image_fc(int)));
        connect(lst_calques, SIGNAL(s_action_replace(int)),this, SLOT(f_action_replace(int)));
        connect(lst_calques, SIGNAL(s_action_ef_image(int)),this, SLOT(f_action_ef_image(int)));
        connect(lst_calques, SIGNAL(s_action_dupliquer(int)),this, SLOT(f_action_dupliquer(int)));

        connect(lst_calques, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(f_select_clq(QListWidgetItem*)));

        connect(frame_image_editor, SIGNAL(s_cancel_image()),this, SLOT(f_s_cancel_image()));
        connect(frame_image_editor, SIGNAL(s_valide_image()),this, SLOT(f_s_valide_image()));

        connect(bt_close_param_render, SIGNAL(clicked()), this, SLOT(f_bt_close_param_render()));
        connect(bt_start_param_render, SIGNAL(clicked()), this, SLOT(f_bt_start_param_render()));
        connect(bt_path_render_smile, SIGNAL(clicked()), this, SLOT(f_bt_open_folder_render()));

        connect(combo_fmt_smile, SIGNAL(currentIndexChanged(int)),this, SLOT(f_combo_fmt_smile(int)));

        connect(chkradial,SIGNAL(stateChanged(int)),this,SLOT(f_chkradial(int)));

        connect(bt_choose_trans, SIGNAL(clicked()),this, SLOT(f_open_trans_smile()));
        connect(tabWidget_transsmile, SIGNAL(currentChanged(int)),this, SLOT(f_changed_tab_smile_trans(int)));
        connect(bt_close_prev_trans_smile, SIGNAL(clicked()),this, SLOT(f_close_prev_trans_smile()));
        connect(bt_close_prev_trans_none, SIGNAL(clicked()),this, SLOT(f_close_prev_trans_smile_none()));

        connect(bt_cancel_smeff, SIGNAL(clicked()),this, SLOT(f_cancel_smeff()));
        connect(bt_reinit_smeff, SIGNAL(clicked()),this, SLOT(f_reinit_smeff()));
        connect(bt_valide_smeff, SIGNAL(clicked()),this, SLOT(f_valide_smeff()));
        connect(bt_showhide_smeff, SIGNAL(clicked()),this, SLOT(f_showhide_smeff()));

        connect(bt_eff_1, SIGNAL(clicked()),this, SLOT(f_smeff_1()));
        connect(bt_eff_2, SIGNAL(clicked()),this, SLOT(f_smeff_2()));
        connect(bt_eff_3, SIGNAL(clicked()),this, SLOT(f_smeff_3()));
        connect(bt_eff_4, SIGNAL(clicked()),this, SLOT(f_smeff_4()));
        connect(bt_eff_5, SIGNAL(clicked()),this, SLOT(f_smeff_5()));
        connect(bt_eff_6, SIGNAL(clicked()),this, SLOT(f_smeff_6()));
        connect(bt_eff_7, SIGNAL(clicked()),this, SLOT(f_smeff_7()));
        connect(bt_eff_8, SIGNAL(clicked()),this, SLOT(f_smeff_8()));
        connect(bt_eff_9, SIGNAL(clicked()),this, SLOT(f_smeff_9()));
        connect(bt_eff_10, SIGNAL(clicked()),this, SLOT(f_smeff_10()));

        connect(bt_find_folder_diashow, SIGNAL(clicked()),this, SLOT(f_actionDiaporama_automatique_find()));

        connect(media_media_smile, SIGNAL(media_chdir()),this, SLOT(f_move_directory_smile()));
        //connect(media_media_smile, SIGNAL(media_dble_import()),this, SLOT(f_drop_dble_smile()));
        connect(bt_close_navigator_smile, SIGNAL(clicked()),this, SLOT(f_close_navigator_smile()));
        connect(bt_import_navigator_smile, SIGNAL(clicked()),this, SLOT(f_close_import_navigator_smile()));

	// *** PROJETS ***
	connect(bt_find_place, SIGNAL(clicked()),this, SLOT(f_find_place()));
	connect(&projectProcess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(projectend(int, QProcess::ExitStatus)));

	connect(bt_open_old, SIGNAL(clicked()),this, SLOT(f_open_from_start()));

        connect(bt_open_old_2, SIGNAL(clicked()),this, SLOT(f_start_2()));
        //connect(bt_open_old_3, SIGNAL(clicked()),this, SLOT(f_start_3()));
        //connect(bt_open_old_4, SIGNAL(clicked()),this, SLOT(f_start_4()));
        //connect(bt_open_old_5, SIGNAL(clicked()),this, SLOT(f_start_5()));
        connect(bt_open_old_6, SIGNAL(clicked()),this, SLOT(f_start_6()));
        connect(bt_open_old_7, SIGNAL(clicked()),this, SLOT(f_start_7()));
        //connect(bt_open_old_8, SIGNAL(clicked()),this, SLOT(f_start_8()));
        //connect(bt_open_old_9, SIGNAL(clicked()),this, SLOT(f_start_9()));

	// *** TOOLBAR ***

        connect(bt_opc_toolbar, SIGNAL(clicked()),this, SLOT(f_openclose_toolbar()));
        connect(bt_view_arbo, SIGNAL(clicked()),this, SLOT(f_view_arborescence()));
        connect(bt_view_magnetic, SIGNAL(clicked()),this, SLOT(f_view_magnetic()));
        connect(bt_view_infos, SIGNAL(clicked()),this, SLOT(f_view_tabinfos()));

	connect(actionAfficher_cacher_les_r_gles, SIGNAL(triggered()),this, SLOT(f_showhide_regle()));
	connect(actionAfficher_cacher_les_coordonn_es, SIGNAL(triggered()),this, SLOT(f_showhide_coor()));
	connect(actionAfficher_cacher_les_zones_de_s_curit, SIGNAL(triggered()),this, SLOT(f_showhide_safe()));
        connect(actionAfficher_cacher_les_contours, SIGNAL(triggered()),this, SLOT(f_view_contours()));

	connect(actionCapturer_une_image_du_menu, SIGNAL(triggered()),this, SLOT(f_screengrab_menu()));

	connect(actionOuvrir, SIGNAL(triggered()),this, SLOT(f_open_1()));
	connect(actionEnregistrer, SIGNAL(triggered()),this, SLOT(f_save_1()));
	connect(actionEnregistrer_2, SIGNAL(triggered()),this, SLOT(f_save_2()));
	connect(actionNouveau, SIGNAL(triggered()),this, SLOT(f_new_1()));
	connect(actionA_propos_de_2ManDVD, SIGNAL(triggered()),this, SLOT(f_apropos_open()));
	connect(bt_close_propos, SIGNAL(clicked()),this, SLOT(f_apropos_close()));
	connect(actionParam_tres_avanc_s, SIGNAL(triggered()),this, SLOT(f_advanced_open()));

	connect(actionMenu_pr_c_dent, SIGNAL(triggered()),this, SLOT(f_previous_menu()));
	connect(actionMenu_suivant, SIGNAL(triggered()),this, SLOT(f_next_menu()));
	connect(actionCouleurs_des_overlays, SIGNAL(triggered()),this, SLOT(f_overlay_menu()));

	connect(actionGraver_le_DVD, SIGNAL(triggered()),this, SLOT(f_open_burn_2()));
	connect(actionGenerer_l_image_ISO_du_DVD, SIGNAL(triggered()),this, SLOT(f_create_iso()));

	connect(actionRevoir_la_derniere_generation, SIGNAL(triggered()),this, SLOT(f_view_result()));

	connect(actionOrdre_de_tabulation, SIGNAL(triggered()),this, SLOT(f_view_tabulation()));

	connect(actionZone_du_DVD, SIGNAL(triggered()),this, SLOT(f_view_zone()));

	connect(actionArborescence_du_projet, SIGNAL(triggered()),this, SLOT(f_view_arborescence()));

        connect(actionDessiner_sur_le_menu, SIGNAL(triggered()),this, SLOT(f_menu_pencil()));

	// *** PARAMETRES AVANCES ***
	connect(bt_close_advanced, SIGNAL(clicked()),this, SLOT(f_advanced_close()));
	connect(check_loop_back,SIGNAL(stateChanged(int)),this,SLOT(f_put_loop(int)));

	// *** GESTION DES MEDIAS ***
	connect(bt_close_navigator, SIGNAL(clicked()),this, SLOT(f_close_import_bibmedia()));
	connect(media_media, SIGNAL(media_chdir()),this, SLOT(f_move_directory()));
	connect(media_media, SIGNAL(media_dble_import()),this, SLOT(f_drop_dble()));

	connect(frame_mediatheque, SIGNAL(drop_to_panel()),this, SLOT(f_drop_to_panel()));
	connect(frame_mediatheque, SIGNAL(load_media()),this, SLOT(f_open_import_bibmedia()));
        connect(frame_mediatheque, SIGNAL(wheel_scroll()),this, SLOT(f_wheel_scroll()));

	connect(bt_valide_quoifaire_after, SIGNAL(clicked()),this, SLOT(f_close_quoifaire_media()));
	connect(bt_add_tolist_quoifaire, SIGNAL(clicked()),this, SLOT(f_add_quoifaire_media()));
	connect(list_after, SIGNAL(delete_row(int)),this, SLOT(f_delete_quoifaire_media(int)));

	connect(bt_close_language, SIGNAL(clicked()),this, SLOT(f_close_language()));

	connect(bt_add_language, SIGNAL(clicked()),this, SLOT(f_search_language()));
	connect(list_language, SIGNAL(delete_row(int)),this, SLOT(f_delete_language(int)));

        connect(solution_scale_3, SIGNAL(clicked()),this, SLOT(f_scamedia_1()));
        connect(solution_scale_4, SIGNAL(clicked()),this, SLOT(f_scamedia_2()));

        connect(sb_medias, SIGNAL(valueChanged(int)),this, SLOT(f_scroll_medias(int)));

	// *** GESTION DES ZONES ***
	connect(bt_zone_0, SIGNAL(clicked()),this, SLOT(f_aff_zone_0()));
	connect(bt_zone_1, SIGNAL(clicked()),this, SLOT(f_aff_zone_1()));
	connect(bt_zone_2, SIGNAL(clicked()),this, SLOT(f_aff_zone_2()));
	connect(bt_zone_3, SIGNAL(clicked()),this, SLOT(f_aff_zone_3()));
	connect(bt_zone_4, SIGNAL(clicked()),this, SLOT(f_aff_zone_4()));
	connect(bt_zone_5, SIGNAL(clicked()),this, SLOT(f_aff_zone_5()));
	connect(bt_zone_6, SIGNAL(clicked()),this, SLOT(f_aff_zone_6()));
	connect(bt_valide_zone, SIGNAL(clicked()),this, SLOT(f_valide_zone()));

	// *** GESTION DES THUMBNAILS ***
	connect(bt_valid_thumb, SIGNAL(clicked()),this, SLOT(f_valid_thumb()));
        connect(slnbimg, SIGNAL(valueChanged(int)),this, SLOT(f_reload_thumb(int)));

	// *** GESTION DES TITRES ***
        connect(actionAjouter_une_zone_de_texte, SIGNAL(triggered()),this, SLOT(f_ajoute_label()));
        connect(bt_conf_txt, SIGNAL(clicked()),this, SLOT(f_showhide_txtadv()));

	// *** GESTION DES MENUS BOUTONS ***
        connect(actionAjouter_un_bouton, SIGNAL(triggered()),this, SLOT(f_ajoute_menu_from_menubar()));
        connect(actionAjouter_plusieurs_boutons, SIGNAL(triggered()),this, SLOT(f_dispatch_menu()));

	connect(bt_dispatch_1, SIGNAL(clicked()),this, SLOT(f_dispatch_1()));
	connect(bt_dispatch_2, SIGNAL(clicked()),this, SLOT(f_dispatch_2()));
	connect(bt_dispatch_3, SIGNAL(clicked()),this, SLOT(f_dispatch_3()));
	connect(bt_dispatch_4, SIGNAL(clicked()),this, SLOT(f_dispatch_4()));
	connect(bt_dispatch_5, SIGNAL(clicked()),this, SLOT(f_dispatch_5()));
	connect(combo_typehelp, SIGNAL(currentIndexChanged(int)),this, SLOT(f_combo_typehelp_changed(int)));
	connect(combo_typehelp_chapter, SIGNAL(currentIndexChanged(int)),this, SLOT(f_combo_typehelpchapter_changed(int)));

	connect(bt_import_mask, SIGNAL(clicked()),this, SLOT(f_import_mask()));
	connect(bt_bt_img, SIGNAL(clicked()),this, SLOT(f_image_menu()));

	connect(bttxt,SIGNAL(textChanged()),this,SLOT(f_put_txt_on_bt()));
	connect(bttxt,SIGNAL(sh_unp()),this,SLOT(extevent()));

	connect(font_txt,SIGNAL(currentFontChanged(QFont)),this,SLOT(f_font_txt_on_bt(QFont)));

	connect(bt_fmt_1,SIGNAL(clicked()),this,SLOT(f_fmtfont_txt_on_bt_1()));
	connect(bt_fmt_2,SIGNAL(clicked()),this,SLOT(f_fmtfont_txt_on_bt_2()));
	connect(bt_fmt_3,SIGNAL(clicked()),this,SLOT(f_fmtfont_txt_on_bt_3()));
	connect(bt_fmt_4,SIGNAL(clicked()),this,SLOT(f_fmtfont_txt_on_bt_4()));
	connect(bt_fmt_5,SIGNAL(clicked()),this,SLOT(f_fmtfont_txt_on_bt_5()));
	connect(bt_fmt_6,SIGNAL(clicked()),this,SLOT(f_fmtfont_txt_on_bt_6()));

	connect(dial_angle_shadow, SIGNAL(valueChanged(int)),this, SLOT(f_shadowtext_angle(int)));
	connect(dial_opacity_shadow, SIGNAL(valueChanged(int)),this, SLOT(f_shadowtext_opacity(int)));
        connect(spin_font_size, SIGNAL(valueChanged(int)),this, SLOT(f_fonttext_size(int)));

	connect(frame_th_msk_idea, SIGNAL(itemDoubleClicked ( QListWidgetItem* )),this, SLOT(f_select_mask()));
	connect(frame_th_obj_idea, SIGNAL(itemDoubleClicked ( QListWidgetItem* )),this, SLOT(f_select_object()));
        connect(frame_th_obj_idea, SIGNAL(itemClicked ( QListWidgetItem * )),this, SLOT(f_select_item_object(QListWidgetItem *)));
        connect(frame_th_obj_idea, SIGNAL(affhide_anim ()),this, SLOT(f_affhide_anim()));
        connect(bt_import_obj, SIGNAL(clicked()),this, SLOT(f_import_obj()));

        connect(bt_zoom, SIGNAL(clicked()),this, SLOT(f_menu_zoom()));
        connect(bt_rotate, SIGNAL(clicked()),this, SLOT(f_menu_rotate()));
        connect(bt_grab, SIGNAL(clicked()),this, SLOT(f_menu_grab()));
        connect(bt_shear, SIGNAL(clicked()),this, SLOT(f_menu_shear()));

	connect(check_anim,SIGNAL(clicked()),this,SLOT(f_put_anim()));

	// *** GESTION DES MENUS ***
	connect(bt_add_menu, SIGNAL(clicked()),this, SLOT(f_add_menu()));
	connect(combo_quoilire_media, SIGNAL(currentIndexChanged(int)),this, SLOT(f_quoilire_changed(int)));
	connect(combo_quoilire_media_chapitre, SIGNAL(currentIndexChanged(int)),this, SLOT(f_quoilire_chapitre_changed(int)));
	connect(combo_quoilire_menu, SIGNAL(currentIndexChanged(int)),this, SLOT(f_quoilire_menu_changed(int)));
	connect(combo_select_langue, SIGNAL(currentIndexChanged(int)),this, SLOT(f_quoilire_audio_changed(int)));

	connect(scroll_timeline, SIGNAL(valueChanged(int)),this, SLOT(f_scroll_timeline(int)));

	connect(solution_scale_1, SIGNAL(clicked()),this, SLOT(f_valide_scale_background_1()));
	connect(solution_scale_2, SIGNAL(clicked()),this, SLOT(f_valide_scale_background_2()));

	connect(bt_valide_overlay, SIGNAL(clicked()),this, SLOT(f_valide_overlay()));

	connect(dial_alpha_menu, SIGNAL(valueChanged(int)),this, SLOT(f_menu_opacity(int)));

    connect(bt_load_img_bk, SIGNAL(clicked()),this, SLOT(f_select_background()));

	// *** THEMES ***
        connect(frame_th_the_idea, SIGNAL(itemDoubleClicked ( QListWidgetItem* )),this, SLOT(f_select_them()));
        connect(frame_th_the_idea, SIGNAL(licence ( QString )),this, SLOT(f_licence(QString)));
        connect(frame_th_the_idea, SIGNAL(pack ( QString, QString )),this, SLOT(f_pack(QString, QString)));

	connect(bt_add_theme, SIGNAL(clicked()),this, SLOT(f_add_theme()));

	connect(bt_valid_add_theme, SIGNAL(clicked()),this, SLOT(f_add_theme()));
	connect(bt_cancel_add_theme, SIGNAL(clicked()),this, SLOT(f_cancel_add_theme()));
	connect(bt_add_theme_categorie, SIGNAL(clicked()),this, SLOT(f_add_theme_categorie()));
        connect(bt_close_licence, SIGNAL(clicked()),this, SLOT(f_close_licence()));

	// *** PROCESS ***
	connect(&process_ident_media, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(f_ident_media(int, QProcess::ExitStatus)));
	connect(&process_ident_media, SIGNAL(readyReadStandardOutput()), this, SLOT(f_lecture_console_extract()));

	connect(&process_extract_img, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(f_generation_vignette(int, QProcess::ExitStatus)));
	connect(&process_extract_thu, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(f_generation_thu(int, QProcess::ExitStatus)));

	// *** CHAPITRAGE ***
	connect(bt_player_play_stop, SIGNAL(clicked()),this, SLOT(player_play_video()));
	connect(bt_player_mark_chapter, SIGNAL(clicked()),this, SLOT(player_add_chapter()));
	connect(lst_chapters, SIGNAL(gochapter(QString)),this, SLOT(player_go_chapter(QString)));
	connect(lst_chapters, SIGNAL(delete_row(QString)),lst_chapters_2, SLOT(f_delete_row(QString)));

	connect(bt_valide_autochapter, SIGNAL(clicked()),this, SLOT(player_auto_chapter()));
	connect(bt_close_chapter, SIGNAL(clicked()),this, SLOT(player_close()));
	connect(bt_mute_sound, SIGNAL(clicked()),this, SLOT(player_mute()));
	connect(bt_capture, SIGNAL(clicked()),this, SLOT(player_capture()));

	// *** MPLAYER ***
	connect(bt_avance_player, SIGNAL(clicked()),this, SLOT(player_avance()));
	connect(bt_recul_player, SIGNAL(clicked()),this, SLOT(player_recule()));

	connect(slider_player, SIGNAL(sliderPressed()),this, SLOT(player_start_seek()));
	connect(slider_player, SIGNAL(sliderReleased()),this, SLOT(player_stop_seek()));
        connect(slider_player, SIGNAL(valueChanged(int)),this, SLOT(player_move_seek(int)));

	connect(slider_bri, SIGNAL(valueChanged(int)),this, SLOT(player_bri(int)));
	connect(slider_con, SIGNAL(valueChanged(int)),this, SLOT(player_con(int)));
	connect(slider_sat, SIGNAL(valueChanged(int)),this, SLOT(player_sat(int)));
        connect(slider_sub_pos, SIGNAL(valueChanged(int)),this, SLOT(player_sub_pos(int)));
        connect(slider_sub_siz, SIGNAL(valueChanged(int)),this, SLOT(player_sub_siz(int)));

	connect(bt_init_effects, SIGNAL(clicked()),this, SLOT(f_init_effects()));
	connect(bt_close_effects, SIGNAL(clicked()),this, SLOT(f_close_effects()));

	connect(&mplayerProcess, SIGNAL(readyReadStandardOutput()), this, SLOT(player_read_stdout()));

	// *** MPLAYER THUMBNAIL CHOOSER ***
	connect(bt_plth_val, SIGNAL(clicked()),this, SLOT(player_thu_valide()));
        connect(bt_plth_can, SIGNAL(clicked()),this, SLOT(player_thu_cancel()));

        connect(slider_player_thumb, SIGNAL(valueChanged(int)),this, SLOT(player_thu_move_seek(int)));

	// *** GENERATION ***
	connect(actionG_n_rer_le_DVD, SIGNAL(triggered()),this, SLOT(f_go_render_dvd()));
        connect(bt_opc_render, SIGNAL(clicked()),this, SLOT(f_go_render_dvd()));

	connect(&renderProcess, SIGNAL(readyReadStandardOutput()), this, SLOT(render_stdout()));
	connect(bt_cancel_encoding, SIGNAL(clicked()),this, SLOT(f_encoding_end()));
	connect(&renderProcess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(render_end(int, QProcess::ExitStatus)));
	connect(bt_view_result, SIGNAL(clicked()),this, SLOT(f_view_result()));
	connect(bt_return_edit, SIGNAL(clicked()),this, SLOT(f_close_endencoding()));

	// *** DIVERS ***
	connect(&thviProcess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(thvi_end(int, QProcess::ExitStatus)));
	connect(bt_create_iso, SIGNAL(clicked()),this, SLOT(f_create_iso()));
	connect(bt_burn_dvd, SIGNAL(clicked()),this, SLOT(f_open_burn()));
	connect(bt_cancel_burn, SIGNAL(clicked()),this, SLOT(f_cancel_burn()));
	connect(bt_go_burn, SIGNAL(clicked()),this, SLOT(f_go_burn()));
	connect(&isoProcess, SIGNAL(readyReadStandardOutput()), this, SLOT(f_read_outiso()));
	connect(&idvProcess, SIGNAL(readyReadStandardError()), this, SLOT(f_read_outiso()));
	connect(&isoProcess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(f_giso_end(int, QProcess::ExitStatus)));
	connect(&idvProcess, SIGNAL(readyReadStandardOutput()), this, SLOT(f_read_outidv()));
	connect(&idvProcess, SIGNAL(readyReadStandardError()), this, SLOT(f_read_outidv()));
	connect(&idvProcess, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(f_idvd_end(int, QProcess::ExitStatus)));
	connect(bt_valide_customize, SIGNAL(clicked()),this, SLOT(f_valide_customize()));
        connect(bt_cancel_customize, SIGNAL(clicked()),this, SLOT(f_cancel_customize()));

	connect(&proc_ffmpeg, SIGNAL(readyReadStandardOutput()), this, SLOT(f_read_ffmpeg()));
	connect(&proc_ffmpeg, SIGNAL(readyReadStandardError()), this, SLOT(f_read_ffmpeg()));

	connect(slider_custo_red, SIGNAL(valueChanged(int)),this, SLOT(f_custo_red(int)));
	connect(slider_custo_green, SIGNAL(valueChanged(int)),this, SLOT(f_custo_green(int)));
	connect(slider_custo_blue, SIGNAL(valueChanged(int)),this, SLOT(f_custo_blue(int)));
	connect(slider_custo_opacity, SIGNAL(valueChanged(int)),this, SLOT(f_custo_opacity(int)));

	connect(screen_designer, SIGNAL(customize_background()),this, SLOT(f_select_background()));
	connect(screen_designer, SIGNAL(addone()),this, SLOT(f_ajoute_menu()));
	connect(screen_designer, SIGNAL(addmul()),this, SLOT(f_dispatch_menu()));
        connect(screen_designer, SIGNAL(addone_txt()),this, SLOT(f_ajoute_menu_txt()));
	connect(screen_designer, SIGNAL(loadintro()),this, SLOT(f_select_intro()));
	connect(screen_designer, SIGNAL(cancelintro()),this, SLOT(f_cancel_intro()));
	connect(screen_designer, SIGNAL(paste_menu()),this, SLOT(f_paste_menu()));
	connect(screen_designer, SIGNAL(loadzik()),this, SLOT(f_select_sound()));
	connect(screen_designer, SIGNAL(cancelzik()),this, SLOT(f_cancel_sound()));
	connect(screen_designer, SIGNAL(intro_calc()),this, SLOT(f_intro_calc()));
	connect(screen_designer, SIGNAL(color_overlays()),this, SLOT(f_color_overlays()));
        connect(screen_designer, SIGNAL(menu_pencil()),this, SLOT(f_menu_pencil()));
        connect(screen_designer, SIGNAL(drop_to_editor()),this, SLOT(f_drop_to_editor()));
        connect(screen_designer, SIGNAL(menu_openpro()),this, SLOT(f_advanced_open()));

	connect(bt_close_reencode, SIGNAL(clicked()),this, SLOT(f_close_reencode()));
	connect(slider_bitrate, SIGNAL(valueChanged(int)),this, SLOT(f_bitarte_change(int)));

	// *** TRANSITIONS CALCULEES ***
	connect(bt_valide_intro_calc, SIGNAL(clicked()),this, SLOT(f_valide_intro_calc()));
	connect(bt_cancel_intro_calc, SIGNAL(clicked()),this, SLOT(f_cancel_intro_calc()));
        connect(lst_transitions, SIGNAL(itemClicked ( QListWidgetItem* )),this, SLOT(f_change_transition(QListWidgetItem*)));
	connect(bt_find_zik_intro, SIGNAL(clicked()),this, SLOT(f_find_intro_zik()));
        connect(dial_trans_length, SIGNAL(valueChanged(int)),this, SLOT(f_dial_trans_length(int)));

	// *** AUTRES FONCTIONS ***
	connect(actionCopier_le_bouton, SIGNAL(triggered()),this, SLOT(f_copy_bt_2()));
	connect(actionColler_le_bouton, SIGNAL(triggered()),this, SLOT(f_paste_bt_2()));

        connect(frame_syno, SIGNAL(arbo_new_menu()),this, SLOT(f_arbo_new_menu()));
	connect(dial_opacity_overlay, SIGNAL(valueChanged(int)),this, SLOT(f_preview_overlay()));

	// *** PREFERENCES ***
	connect(actionPreferences, SIGNAL(triggered()),this, SLOT(f_open_preferences()));
	connect(bt_close_preferences, SIGNAL(clicked()),this, SLOT(f_close_preferences()));

	// *** GESTION DES OVERLAYS ***
	connect(bt_close_editoverlay, SIGNAL(clicked()),this, SLOT(f_close_editoverlay()));
        connect(bt_close_editoverlay_cancel, SIGNAL(clicked()),this, SLOT(f_close_editoverlay_cancel()));
	connect(designer_brush_width, SIGNAL(valueChanged(int)),this, SLOT(f_designer_brush_width(int)));
	connect(bt_tool_designer_1, SIGNAL(clicked()),this, SLOT(f_tool_designer_1()));
	connect(bt_tool_designer_2, SIGNAL(clicked()),this, SLOT(f_tool_designer_2()));
	connect(bt_tool_designer_3, SIGNAL(clicked()),this, SLOT(f_tool_designer_3()));
	connect(bt_tool_designer_4, SIGNAL(clicked()),this, SLOT(f_tool_designer_4()));
	connect(bt_tool_designer_5, SIGNAL(clicked()),this, SLOT(f_tool_designer_5()));
        connect(bt_tool_designer_6, SIGNAL(clicked()),this, SLOT(f_tool_designer_6()));

	// *** DVDNAV ***
	connect(dvdnavtop, SIGNAL(clicked()),this, SLOT(f_dvdnav_1()));
	connect(dvdnavleft, SIGNAL(clicked()),this, SLOT(f_dvdnav_2()));
	connect(dvdnavright, SIGNAL(clicked()),this, SLOT(f_dvdnav_3()));
	connect(dvdnavbottom, SIGNAL(clicked()),this, SLOT(f_dvdnav_4()));
	connect(dvdnavok, SIGNAL(clicked()),this, SLOT(f_dvdnav_5()));
	connect(dvdnavmenu, SIGNAL(clicked()),this, SLOT(f_dvdnav_6()));
	connect(dvdnavprevious, SIGNAL(clicked()),this, SLOT(f_dvdnav_7()));
	connect(dvdnavnext, SIGNAL(clicked()),this, SLOT(f_dvdnav_8()));
	connect(dvdnavplay, SIGNAL(clicked()),this, SLOT(f_dvdnav_9()));
        connect(bt_close_preview_finish, SIGNAL(clicked()),this, SLOT(f_close_dvdnav()));

        // *** GESTION DU MENU DU BAS ***
        connect(bt_affhide_menus, SIGNAL(clicked()),this, SLOT(f_showhide_lstmenu()));
        connect(bt_switch_medias, SIGNAL(clicked()),this, SLOT(f_showhide_lstmedias()));
        connect(bt_switch_themes, SIGNAL(clicked()),this, SLOT(f_showhide_lstthemes()));
        connect(bt_switch_property, SIGNAL(clicked()),this, SLOT(f_showhide_lstproperty()));

        // *** DESIGNER DU MENU ***
        connect(tool_pencil_1, SIGNAL(clicked()),this, SLOT(f_tool_pencil_1()));
        connect(tool_pencil_2, SIGNAL(clicked()),this, SLOT(f_tool_pencil_2()));
        connect(tool_pencil_3, SIGNAL(clicked()),this, SLOT(f_tool_pencil_3()));
        connect(tool_pencil_4, SIGNAL(clicked()),this, SLOT(f_tool_pencil_4()));
        connect(tool_pencil_5, SIGNAL(clicked()),this, SLOT(f_tool_pencil_5()));
        connect(tool_pencil_6, SIGNAL(clicked()),this, SLOT(f_tool_pencil_6()));
        connect(tool_pencil_7, SIGNAL(clicked()),this, SLOT(f_tool_pencil_7()));
        connect(pencil_brush_width, SIGNAL(valueChanged(int)),this, SLOT(f_pencil_brush_width(int)));
        connect(pencil_brush_opacity, SIGNAL(valueChanged(int)),this, SLOT(f_pencil_brush_opacity(int)));
        connect(pencil_brush_opacity_2, SIGNAL(valueChanged(int)),this, SLOT(f_pencil_brush_opacity_2(int)));
        connect(pencil_check_bt, SIGNAL(stateChanged(int)),this, SLOT(f_pencil_check_bt(int)));
        connect(pencil_check_bt_2, SIGNAL(stateChanged(int)),this, SLOT(f_pencil_check_bt_2(int)));
        connect(bt_close_drawing_menu, SIGNAL(clicked()),this, SLOT(f_close_pencil_menu()));
        connect(bt_cancel_drawing_menu, SIGNAL(clicked()),this, SLOT(f_cancel_pencil_menu()));

	// *** TEST DES DEPENDANCES ***
        splash.showMessage("Control dependancies",spal,Qt::white);
        splash.setPixmap(pixmap3);
	QFile wmyficext;
	QTextStream outext(&wmyficext);

	wmyficext.setFileName(homeDir.path() + "/.mdvdep.sh");
	wmyficext.open( QIODevice::WriteOnly );
	outext << "mplex" << endl;
	outext << "ffmpeg" << endl;
	outext << "mencoder" << endl;
	outext << "ffmpegthumbnailer" << endl;
        outext << "sox -h" << endl;
	outext << "dvdauthor" << endl;
    outext << "genisoimage" << endl;
        outext << "exif" << endl;
	outext << "growisofs" << endl;
	outext << "mpeg2enc" << endl;
    outext << "convert" << endl;
        outext << "jpegtopnm /dev/null" << endl;
        outext << "cat " << (QString)DEF_FAKE << "/fake.pl" << endl;
        outext << "rm -f " << homeDir.path() << "/.mdvdep.sh" << endl;
	outext << "exit" << endl;
	wmyficext.close();
	QString programf = "bash";
	QStringList argumentsf;
	argumentsf << homeDir.path() + "/.mdvdep.sh";

      	proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
	proc_ffmpeg.start(programf,argumentsf);

        proc_ffmpeg.waitForFinished(-1);
	QByteArray buffer(proc_ffmpeg.readAllStandardOutput());
	wg_string_003 = wg_string_003 + buffer;

    isnotify = 0;

	wg_string_002 = "";

	wg_int_002 = wg_string_003.lastIndexOf( "mjpegtools" );
	if (wg_int_002 == -1)
	{
		wg_string_002 = "MPLEX\n";
	}

	wg_int_002 = wg_string_003.lastIndexOf( "FFmpeg version" );
	if (wg_int_002 == -1)
	{
            wg_int_002 = wg_string_003.lastIndexOf( "ffmpeg version" );
            if (wg_int_002 == -1)
            {
                    wg_string_002 = "FFMPEG\n";
            }
	}

	wg_int_002 = wg_string_003.lastIndexOf( "MPlayer" );
	if (wg_int_002 == -1)
	{
		wg_string_002 = wg_string_002 + "MPlayer / Mencoder\n";
	}

	wg_int_002 = wg_string_003.lastIndexOf( "ffmpegthumbnailer [options]" );
	if (wg_int_002 == -1)
	{
		wg_string_002 = wg_string_002 + "ffmpegthumbnailer\n";
	}

        wg_int_002 = wg_string_003.lastIndexOf( "--ids" );
        if (wg_int_002 == -1)
        {
                wg_string_002 = wg_string_002 + "exif\n";
        }

	wg_int_002 = wg_string_003.lastIndexOf( "SoX" );
	if (wg_int_002 == -1)
	{
		wg_string_002 = wg_string_002 + "sox\n";
	}
        else
        {
            wg_int_002 = wg_string_003.lastIndexOf( "mp3" );
            if (wg_int_002 == -1)
            {
                    wg_string_002 = wg_string_002 + "SOX is compiled without mpeg audio support. 2ManDVD should failed\n";
            }
        }

	wg_int_002 = wg_string_003.lastIndexOf( "syntax: dvdauthor" );
	if (wg_int_002 == -1)
	{
		wg_string_002 = wg_string_002 + "dvdauthor\n";
	}
        else
        {
            wg_int_002 = wg_string_003.lastIndexOf( "0.7." );
            if (wg_int_002 == -1)
            {
                dvdauthor_version = 7;
            }
            else
            {
                dvdauthor_version = 6;
            }
        }

	wg_int_002 = wg_string_003.lastIndexOf( "Encoding profile" );
	if (wg_int_002 == -1)
	{
		wg_string_002 = wg_string_002 + "mpeg2enc (Bad MJPEGTOOLS)\n";
	}

    wg_int_002 = wg_string_003.lastIndexOf( "genisoimage:" );
    if (wg_int_002 == -1)
    {
        wg_string_002 = wg_string_002 + "genisoimage\n";
    }

	wg_int_002 = wg_string_003.lastIndexOf( "growisofs:" );
	if (wg_int_002 == -1)
	{
		wg_string_002 = wg_string_002 + "growisofs\n";
        }

        wg_int_002 = wg_string_003.lastIndexOf( "jpegtopnm:" );
        if (wg_int_002 == -1)
        {
            wg_int_002 = wg_string_003.lastIndexOf( "Empty input file" );
            if (wg_int_002 == -1)
            {
                wg_string_002 = wg_string_002 + "jpegtopnm (netpbm)\n";
            }
        }

        wg_int_002 = wg_string_003.lastIndexOf( "-polaroid" );
        if (wg_int_002 == -1)
        {
            wg_string_002 = wg_string_002 + "ImageMagick\n";
        }

        wg_int_002 = wg_string_003.lastIndexOf( "elsif ($data eq" );
        if (wg_int_002 == -1)
        {
            wg_string_002 = wg_string_002 + "Le fichier fake.pl n'est pas present dans : " + (QString)DEF_FAKE  + "\n";
        }

        // *** DOIT ON RECUPERER LES INFOS DE LA DERNIERE SESSION ***
        QDir currentDir = QDir::homePath();
        QFile configfile( currentDir.path() + "/.2mandvd.cnf" );
        if (configfile.open(QFile::ReadOnly))
        {
                newData = configfile.readLine(0);
                wg_string_001 = QString::fromLocal8Bit(newData);
                wg_string_001 = wg_string_001.simplified();
                wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                line_path_projet->setText(wg_string_001);
		if (  configfile.atEnd() == false )
		{
		        newData = configfile.readLine(0);
		        wg_string_001 = QString::fromLocal8Bit(newData);
		        wg_string_001 = wg_string_001.simplified();
		        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			if ( wg_string_001 == "0" )
			{
				checkBox_save_encode->setChecked(false);
			}
			else
			{
				checkBox_save_encode->setChecked(true);
			}
		}
		if (  configfile.atEnd() == false )
		{
		        newData = configfile.readLine(0);
		        wg_string_001 = QString::fromLocal8Bit(newData);
		        wg_string_001 = wg_string_001.simplified();
		        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
			wl_vmax = wg_string_001.toInt();
			if ( wl_vmax == 5000 )
			{
				combo_format_vmax->setCurrentIndex(1);
			}
			else
			{
				if ( wl_vmax == 9800 )
				{
					combo_format_vmax->setCurrentIndex(2);
				}
				else
				{
					combo_format_vmax->setCurrentIndex(0);
				}
			}

			if (  configfile.atEnd() == false )
			{
				newData = configfile.readLine(0);
				wg_string_001 = QString::fromLocal8Bit(newData);
				wg_string_001 = wg_string_001.simplified();
				wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
				combo_format_audio->setCurrentIndex(wg_string_001.toInt());
			}
		}
		else
		{
			wl_vmax = 5000;
			combo_format_vmax->setCurrentIndex(1);
		}
                if (  configfile.atEnd() == false )
                {
                        newData = configfile.readLine(0);
                        wg_string_001 = QString::fromLocal8Bit(newData);
                        wg_string_001 = wg_string_001.simplified();
                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                        nbre_threads = wg_string_001.toInt();
                        spin_thread->setValue(nbre_threads);
                }
                if (  configfile.atEnd() == false )
                {
                        newData = configfile.readLine(0);
                        wg_string_001 = QString::fromLocal8Bit(newData);
                        wg_string_001 = wg_string_001.simplified();
                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                        combo_player->setCurrentIndex(wg_string_001.toInt());
                }
                else
                {
                        combo_player->setCurrentIndex(0);
                }
                if (  configfile.atEnd() == false )
                {
                        newData = configfile.readLine(0);
                        wg_string_001 = QString::fromLocal8Bit(newData);
                        wg_string_001 = wg_string_001.simplified();
                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                        if ( wg_string_001.toInt() == 1 )
                        {
                            cb_aa->setChecked(true);
                        }
                        else
                        {
                            cb_aa->setChecked(false);
                        }
                }
                else
                {
                        cb_aa->setChecked(false);
                }

                if (  configfile.atEnd() == false )
                {
                        newData = configfile.readLine(0);
                        wg_string_001 = QString::fromLocal8Bit(newData);
                        wg_string_001 = wg_string_001.simplified();
                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                        if ( wg_string_001.toInt() == 1 )
                        {
                            cb_dr->setChecked(true);
                        }
                        else
                        {
                            cb_dr->setChecked(false);
                        }
                }
                else
                {
                        cb_dr->setChecked(true);
                }

                if (  configfile.atEnd() == false )
                {
                        newData = configfile.readLine(0);
                        wg_string_001 = QString::fromLocal8Bit(newData);
                        wg_string_001 = wg_string_001.simplified();
                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                        combo_vmemory->setCurrentIndex(wg_string_001.toInt());
                }
                else
                {
                        combo_vmemory->setCurrentIndex(0);
                }

                configfile.close();
		bt_open_old->setEnabled(true);

                // *** TEST EXISTENCE DU DOSSIER DE TRAVAIL ***
                QDir mydir(line_path_projet->text());

                if ( mydir.exists()  == false )
                {
                    QMessageBox::information(this, name_application, tr("Le dossier temporaire n existe pas. Pensez a le changer ou l'application ne fonctionnera pas correctement : ") + line_path_projet->text());
                }

        }
	else
	{
		// *** PREMIER LANCEMENT DE 2MANDVD ***
		QMessageBox::information(this, name_application, tr("Ceci est le premier lancement de 2ManDVD.\n Afin de pouvoir fonctionner 2ManDVD necessite que vous choisissiez un repertoire de travail dans lequel seront stockes vos productions.\n Vous pourrez modifier cet emplacement par la suite si vous le souhaitez."));
		QString mydir = QFileDialog::getExistingDirectory( this, tr("Choisissez un repertoire de travail"), "~", QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
		while ( mydir.isNull() == true )
		{
			mydir = QFileDialog::getExistingDirectory( this, tr("Choisissez un repertoire de travail"), "~", QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
		}
		line_path_projet->setText(mydir);
		
		QDir currentDir = QDir::homePath();
		QFile configfile( currentDir.path() + "/.2mandvd.cnf" );
		if (configfile.open(QIODevice::WriteOnly))
		{
			QTextStream out(&configfile);
			out << line_path_projet->text() << endl;
			if ( checkBox_save_encode->isChecked() == true )
			{
				out << "1" << endl;
			}
			else
			{
				out << "0" << endl;
			}
			if ( combo_format_vmax->currentIndex() == 0 )
			{
				out << "2600" << endl;
				wl_vmax = 2600;
			}
			else
			{
				if ( combo_format_vmax->currentIndex() == 1 )
				{
					out << "5000" << endl;
					wl_vmax = 5000;
				}
				else
				{
					out << "9800" << endl;
					wl_vmax = 9800;
				}
			}
			out << combo_format_audio->currentIndex() << endl;
			out << QString::number(spin_thread->value()) << endl;
			out << QString::number(combo_player->currentIndex()) << endl;
                        out << "0" << endl;
                        out << "1" << endl;
                        out << "0" << endl;
			configfile.close();
		}
                checkBox_save_encode->setChecked(false);
                cb_aa->setChecked(false);
                cb_dr->setChecked(true);
                combo_player->setCurrentIndex(0);
                combo_vmemory->setCurrentIndex(0);
	}
	// *** AFFICHAGE DE LA FENETRE NOUVEAU PROJET ***
	if ( wg_string_002 != "" )
	{
		QMessageBox::information(this, name_application, tr("ATTENTION ! il manque certaines dependances pour le bon fonctionnement de l'application. Liste des dependances manquantes : \n") + wg_string_002);
	}

        // *** TODO TEST ***

        QPixmap pix_001(":/Interface/Interface/reload.png");
        pix_001.fill(QColor(0,0,0));
        mask_interface->setPixmap(pix_001);
        mask_interface->setAttribute(Qt::WA_TranslucentBackground, true);
        mask_interface->setGraphicsEffect(thread_ani->myeffect);
        thread_ani->hdlmsk = mask_interface;

        // *** FIN TODO TEST ***

	QString openargument = QCoreApplication::arguments().last();

	if (openargument.right(7) != "2ManDVD" && openargument.right(9) != "./2ManDVD")
	{
		if ( line_path_projet->text() == "" )
		{
                        actionDiaporama_automatique->setDisabled(true);
                        actionReinitialiser_les_coordonn_es->setDisabled(true);
                        actionAjouter_une_diapositive->setDisabled(true);
                        actionAfficher_cacher_grille_de_placement->setDisabled(true);
                        actionAjouter_un_bouton->setEnabled(true);
                        actionAjouter_plusieurs_boutons->setEnabled(true);
                        actionAjouter_une_zone_de_texte->setEnabled(true);
			frame_new_proj->show();
			frame_new_proj->raise();
		}
		else
		{
			path_project = line_path_projet->text();
			frame_new_proj->hide();
			f_open_ext(openargument);
			//
			frame_editor->lower();
			mask_interface->hide();
			frame_new_proj->hide();

			smenuBar->setEnabled(true);
		}
	}
	else
	{
                actionDiaporama_automatique->setDisabled(true);
                actionReinitialiser_les_coordonn_es->setDisabled(true);
                actionAjouter_une_diapositive->setDisabled(true);
                actionAfficher_cacher_grille_de_placement->setDisabled(true);
                actionAjouter_un_bouton->setEnabled(true);
                actionAjouter_plusieurs_boutons->setEnabled(true);
                actionAjouter_une_zone_de_texte->setEnabled(true);
		frame_new_proj->show();
		frame_new_proj->raise();
	}
        must_update = 1;
}

// **********************
// *** GESTION PROJET ***
// **********************

void mainfrm::f_start_2()
{
    if ( combo_fmtpn->currentIndex() == 0 && combo_fmt14->currentIndex() == 0 )
    {
        combo_format_dvd->setCurrentIndex(0);
        f_valide_new_projet();
        return;
    }

    if ( combo_fmtpn->currentIndex() == 0 && combo_fmt14->currentIndex() == 1 )
    {
        combo_format_dvd->setCurrentIndex(1);
        f_valide_new_projet();
        return;
    }

    if ( combo_fmtpn->currentIndex() == 1 && combo_fmt14->currentIndex() == 0 )
    {
        combo_format_dvd->setCurrentIndex(2);
        f_valide_new_projet();
        return;
    }

    if ( combo_fmtpn->currentIndex() == 1 && combo_fmt14->currentIndex() == 1 )
    {
        combo_format_dvd->setCurrentIndex(3);
        f_valide_new_projet();
        return;
    }
}

void mainfrm::f_start_6()
{
    if ( combo_fmtpn->currentIndex() == 0 && combo_fmt14->currentIndex() == 0 )
    {
        combo_format_dvd->setCurrentIndex(0);
        f_valide_new_projet_slideshow();
        return;
    }

    if ( combo_fmtpn->currentIndex() == 0 && combo_fmt14->currentIndex() == 1 )
    {
        combo_format_dvd->setCurrentIndex(1);
        f_valide_new_projet_slideshow();
        return;
    }

    if ( combo_fmtpn->currentIndex() == 1 && combo_fmt14->currentIndex() == 0 )
    {
        combo_format_dvd->setCurrentIndex(2);
        f_valide_new_projet_slideshow();
        return;
    }

    if ( combo_fmtpn->currentIndex() == 1 && combo_fmt14->currentIndex() == 1 )
    {
        combo_format_dvd->setCurrentIndex(3);
        f_valide_new_projet_slideshow();
        return;
    }
}

void mainfrm::f_start_7()
{
    if ( combo_fmtpn->currentIndex() == 0 && combo_fmt14->currentIndex() == 0 )
    {
        combo_format_dvd->setCurrentIndex(0);
    }

    if ( combo_fmtpn->currentIndex() == 0 && combo_fmt14->currentIndex() == 1 )
    {
        combo_format_dvd->setCurrentIndex(1);
    }

    if ( combo_fmtpn->currentIndex() == 1 && combo_fmt14->currentIndex() == 0 )
    {
        combo_format_dvd->setCurrentIndex(2);
    }

    if ( combo_fmtpn->currentIndex() == 1 && combo_fmt14->currentIndex() == 1 )
    {
        combo_format_dvd->setCurrentIndex(3);
    }

    frame_holy_param->setGeometry(0,0,frame_holy_param->width(),frame_holy_param->height());
    this->setMinimumSize(frame_holy_param->width(),frame_holy_param->height());
    this->setMaximumSize(frame_holy_param->width(),frame_holy_param->height());
    this->setGeometry((QApplication::desktop()->screenGeometry(0).width()-frame_holy_param->width())/2,(QApplication::desktop()->screenGeometry(0).height()-frame_holy_param->height())/2,frame_holy_param->width(),frame_holy_param->height());
    frame_holy_param->show();
    frame_holy_param->raise();
}

void mainfrm::f_valide_new_projet()
{
	if ( line_path_projet->text() != "" )
	{
		// *** DEMARRAGE D'UN NOUVEAU PROJET ***
		if ( combo_format_dvd->currentIndex() == 0 )
		{
			dvdxsize = 720;
			dvdysize = 576;
			dvd_standard = "pal";
			dvd_format = "4/3";
		}
		else
		{
			if ( combo_format_dvd->currentIndex() == 1 )
			{
				dvdxsize = 1024;
				dvdysize = 576;
				dvd_standard = "pal";
				dvd_format = "16/9";
			}
			else
			{
				if ( combo_format_dvd->currentIndex() == 2 )
				{
					dvdxsize = 720;
					dvdysize = 480;
					dvd_standard = "ntsc";
					dvd_format = "4/3";
				}
				else
				{
					dvdxsize = 1024;
					dvdysize = 480;
					dvd_standard = "ntsc";
					dvd_format = "16/9";
				}
			}
		}

                tabwidget_main->hide();
                frame_medias->show();
                frame_left_menu->hide();

		path_project = line_path_projet->text();

		path_always_save = "";
		actionEnregistrer_2->setDisabled(true);

		QFile wmyficext;
		QTextStream outext(&wmyficext);

		wmyficext.setFileName(path_project + "/DVD/GENE/delall.sh");
		wmyficext.open( QIODevice::WriteOnly );
		outext << "rm -rf " + path_project + "/DVD" << endl;
		outext << "exit" << endl;
                wmyficext.close();

		QString programf = "bash";
		QStringList argumentsf;
		argumentsf << path_project + "/DVD/GENE/delall.sh";

	      	proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
		proc_ffmpeg.start(programf,argumentsf);
		proc_ffmpeg.waitForFinished(-1);
		if ( f_create_env() == true )
		{
			frame_new_proj->hide();

			smenuBar->setEnabled(true);

                        // *** SAUVEGARDE LES INFOS DE LA DERNIERE SESSION ***
                        QDir currentDir = QDir::homePath();
                        QFile configfile( currentDir.path() + "/.2mandvd.cnf" );
                        if (configfile.open(QIODevice::WriteOnly))
                        {
                                QTextStream out(&configfile);
                                out << line_path_projet->text() << endl;
				if ( checkBox_save_encode->isChecked() == true )
				{
	                                out << "1" << endl;
				}
				else
				{
	                                out << "0" << endl;
				}
				if ( combo_format_vmax->currentIndex() == 0 )
				{
					out << "2600" << endl;
					wl_vmax = 2600;
				}
				else
				{
					if ( combo_format_vmax->currentIndex() == 1 )
					{
						out << "5000" << endl;
						wl_vmax = 5000;
					}
					else
					{
						out << "9800" << endl;
						wl_vmax = 9800;
					}
				}
				out << combo_format_audio->currentIndex() << endl;
                                out << QString::number(spin_thread->value()) << endl;
                                out << QString::number(combo_player->currentIndex()) << endl;
                                out << cb_aa->isChecked() << endl;
                                out << cb_dr->isChecked() << endl;
                                configfile.close();
                        }
			dvd_actual_size = 0;
			f_calcul_jauge(0);
		}
		else
		{
			qDebug() << "ERROR CREATING ENVIRONEMENT ************************************";
			QMessageBox::information(this, name_application, tr("Impossible de créer les dossiers de travail"));
		}

                f_resize_project();

                f_update_thumb_menu();
                actionAfficher_cacher_les_r_gles->setChecked( userSettings::getDisplayOption( userSettings::DISPLAY_RULE ) );
                displayRegle( userSettings::getDisplayOption( userSettings::DISPLAY_RULE ) );
                actionAfficher_cacher_les_coordonn_es->setChecked( userSettings::getDisplayOption( userSettings::DISPLAY_COORD ) );
                displayCoord( userSettings::getDisplayOption( userSettings::DISPLAY_COORD ) );
                actionAfficher_cacher_les_zones_de_s_curit->setChecked( userSettings::getDisplayOption( userSettings::DISPLAY_ZONE ) );
                displayZone( userSettings::getDisplayOption( userSettings::DISPLAY_ZONE ) );
                actionAfficher_cacher_les_contours->setChecked( userSettings::getDisplayOption( userSettings::DISPLAY_SHAPE ) );
                displayContours( userSettings::getDisplayOption( userSettings::DISPLAY_SHAPE ) );
	}
	else
	{
		QMessageBox::information(this, name_application, tr("Vous devez choisir un dossier pour les fichiers de travail"));
	}
}

void mainfrm::f_find_place()
{
	// *** DOSSIER POUR FICHIERS TEMPORAIRES DU PROJET ***
	QDir currentDir = QDir::homePath();
	QString wl_preselect = currentDir.path();
	if ( line_path_projet->text() != "" )
	{
		wl_preselect = line_path_projet->text();
	}

	QString mydir = QFileDialog::getExistingDirectory( this, tr("Choisissez un repertoire de travail"), wl_preselect, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
        if ( mydir.isNull() )
        {
        }
	else
	{
		line_path_projet->setText(mydir);
		bt_open_old->setEnabled(true);
	}
}

bool mainfrm::f_create_env()
{
	dvd_total_size=4300;
        frame_support_editor->setGeometry(0,0,frame_editor->width(),frame_editor->height());
        screen_designer->setGeometry(0,0,dvdxsize,dvdysize);
	background_menu->setGeometry(0,0,dvdxsize,dvdysize);
        safety_zone->setGeometry(0,0,dvdxsize,dvdysize);
        magnetic_grid->setGeometry(0,0,dvdxsize,dvdysize);
        frame_pencil_draw->setGeometry(0,0,dvdxsize,dvdysize);

        frame_lst_menus->setGeometry(0,this->height(),frame_support_editor->width()-frame_pro->width(),frame_lst_menus->height());
        frame_lst_menus->lower();
        frame_support_menu_th_contain->setGeometry(10,36,frame_lst_menus->width()-20,122);
        scroll_timeline->setGeometry(2,frame_support_menu_th_contain->height()-18,frame_support_menu_th_contain->width()-4,14);

	actionGraver_le_DVD->setDisabled(true);
	actionGenerer_l_image_ISO_du_DVD->setDisabled(true);
	actionRevoir_la_derniere_generation->setDisabled(true);

        // *** CREATION MINIATURE DU MENU PRINCIPAL ***
        hdl_current_menuth = new menu_th(frame_support_menuthumb);
        hdl_current_menuth->setGeometry( 2, 0, 106, 106 );
        hdl_current_menuth->is_first = 1;
        hdl_current_menuth->is_edit = 1;
        hdl_current_menuth->draw_image = QPixmap(":/Interface/Interface/default_bt.png");
        hdl_current_menuth->show();
        connect(hdl_current_menuth, SIGNAL(select_menuth(menu_th*) ),this, SLOT(f_select_menuth(menu_th*)));
        connect(hdl_current_menuth, SIGNAL(dupliquer_menuth(menu_th*) ),this, SLOT(f_dupliquer_menuth(menu_th*)));

        frame_syno->tab_pnt_item[0] = new item_menu(frame_syno);
        frame_syno->tab_pnt_item[0]->setGeometry( 2, 0, 106, 106 );
        frame_syno->tab_pnt_item[0]->show();

        connect(frame_syno->tab_pnt_item[0], SIGNAL(item_move(item_menu*) ),this, SLOT(f_item_move(item_menu*)));
        connect(frame_syno->tab_pnt_item[0], SIGNAL(item_select(item_menu*) ),this, SLOT(f_item_select(item_menu*)));
        connect(frame_syno->tab_pnt_item[0], SIGNAL(add_link(item_menu*,int) ),this, SLOT(f_add_link(item_menu*,int)));
        connect(frame_syno->tab_pnt_item[0], SIGNAL(add_link_media(item_menu*,QString) ),this, SLOT(f_add_link_media(item_menu*,QString)));
        connect(frame_syno->tab_pnt_item[0], SIGNAL(edit_menu_tree(item_menu*) ),this, SLOT(f_edit_menu_tree(item_menu*)));

        nbre_menuth = 0;
        current_loop = 0;
        loop_length = 5;
        table_hdl_menuth[nbre_menuth] = hdl_current_menuth;

	// *** CREATION DE LA STRUCTURE DE BASE ***
	QDir QDpath_project(path_project);
	if ( QDpath_project.mkpath ( "DVD/MAIN" ) == true )
	{
		if ( QDpath_project.mkpath ( "DVD/MEDIAS" ) == true )
		{
			if ( QDpath_project.mkpath ( "DVD/TEMP" ) == true )
			{
				if ( QDpath_project.mkpath ( "DVD/GENE" ) == true )
				{
					if ( QDpath_project.mkpath ( "DVD/SVP" ) == true )
                                        {
                                                must_update = 0;

                                                dial_opacity_overlay->setValue(100);
                                                pntwheel1->setColor(255,0,0);
                                                pntwheel2->setColor(0,255,0);

						must_update = 1;

                                                f_preview_overlay();

						f_update_thumb_menu();

                                                f_change_directory(path_media_import);

                                                return true;
					}
					else
					{
						return false;
					}
				}
				else
				{
					return false;
				}
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}

// *****************************
// *** GESTION DE LA FENETRE ***
// *****************************

void mainfrm::f_close()
{
    // ****************************************
    // *** Point de sortie de l'application ***
    // ****************************************

    if ( frame_smile->isVisible() == true )
    {
        delete pntmygl;
    }

    QDir currentDir = QDir::homePath();
    QFile myfic(currentDir.path() + "/.delete2MANDVD.sh");

    if ( !myfic.open( QIODevice::WriteOnly ))
    {
            qDebug() << "ERROR CREATING EXTRACT SCRIPT IN YOUR HOME DIRECTORY : " + currentDir.path();
            return;
    }
    else
    {
            QTextStream out(&myfic);
            out << "#!/bin/bash" << endl;
            out << "rm -rf " + path_project + "/DVD/" << endl;
            out << "rm -rf " + path_project + "/RDR/" << endl;
            out << "rm -f .delete2MANDVD.sh" << endl;
            myfic.close();

            QString program = "bash";
            QStringList arguments;
            arguments << currentDir.path() + "/.delete2MANDVD.sh";
            process_one_shot.setProcessChannelMode ( QProcess::MergedChannels );
            process_one_shot.start( program, arguments );
    }
    if ( mplayerProcess.state() == QProcess::Starting || mplayerProcess.state() == QProcess::Running )
    {
            mplayerProcess.kill();
    }
    mplayerProcess.waitForFinished(1000);
}

void mainfrm::keyPressEvent( QKeyEvent *k )
{
    if ( k->key() == Qt::Key_Escape)
    {
    }

    if ( frame_smile->isVisible() == false )
    {       
        if ( k->key() == Qt::Key_Shift && hdl_current_menu != 0 )
    	{
		hdl_current_menu->shift_press = 1;
    	}
        if ( k->key() == Qt::Key_Delete && hdl_current_menu != 0  && frame_organize->isVisible() == false && frame_editor->isEnabled() == true )
    	{
		hdl_current_menu->supprimer();
    	}
    }
    else
    {
        if ( k->key() == Qt::Key_Shift )
        {
            pntmygl->is_shift = 1;
        }

        if ( k->key() == Qt::Key_Control )
        {
            pntmygl->is_ctrl = 1;
        }

        if ( k->key() == Qt::Key_Delete && pntmygl->num_select > 0 )
        {
            pntmygl->f_delete_image();
        }
    }
}

void mainfrm::keyReleaseEvent( QKeyEvent *k )
{
    if ( frame_smile->isVisible() == false )
    {
    	if ( k->key() == Qt::Key_Shift && hdl_current_menu != 0 )
    	{
		hdl_current_menu->shift_press = 0;
    	}       
    }
    else
    {
        if ( k->key() == Qt::Key_Shift )
        {
            pntmygl->is_shift = 0;
        }

        if ( k->key() == Qt::Key_Control )
        {
            pntmygl->is_ctrl = 0;
        }
    }
}

void mainfrm::extevent()
{
    	if ( hdl_current_menu != 0 )
    	{
		hdl_current_menu->shift_press = 0;
    	}
}

// **************************
// *** GESTION DES MEDIAS ***
// **************************

void mainfrm::f_open_import_bibmedia()
{
        // *** OUVERTURE FENETRE DE RECHERCHE DES MEDIAS ***

        smenuBar->setDisabled(true);
        bottom_menu->setDisabled(true);
        screen_designer->setDisabled(true);
	frame_directory->show();
	frame_directory->raise();
        jauge_dvd->raise();
        frame_mediatheque->is_open = 1;

        if ( frame_infos->isVisible() == true )
        {
            wg_int_008 = 1;
            frame_infos->hide();
        }
        else
        {
            wg_int_008 = 0;
        }
}

void mainfrm::f_close_import_bibmedia()
{
        // *** FERMETURE FENETRE DE RECHERCHE DES MEDIAS ***

        smenuBar->setEnabled(true);
        bottom_menu->setEnabled(true);
        screen_designer->setEnabled(true);
	frame_directory->hide();
        frame_mediatheque->is_open = 0;

        if ( wg_int_008 == 1 )
        {
            frame_infos->setVisible(true);
        }
}

void mainfrm::f_lecture_console_extract()
{
	Process_Data = process_ident_media.readAllStandardOutput();
	wg_string_001 = wg_string_001 + QString::fromLocal8Bit(Process_Data);
}

void mainfrm::f_ident_media(int, QProcess::ExitStatus)
{
	wg_string_001.replace(QByteArray("\n"), QByteArray(" "));
	wg_string_001.replace(QByteArray("\r"), QByteArray(" "));

      	int i = wg_string_001.indexOf("MPEG-PS", 0);
	int isdvd;
        if ( i != -1 )
        {
		isdvd = 1;
	}
	else
	{
		isdvd = 0;
	}
	// *** IDENTIFICATION DU MEDIA ***
	QString media_width = "";
	QString media_height = "";
	QString media_fps = "";
	QString media_length = "";
	QString media_format = "";
	QString media_audio_channel = "";
	QString media_video_bitrate = "";
	QString media_video_sync = "";
        int issca = 0;

	int j = 0;

	// *** RESOLUTION ***
      	i = wg_string_001.indexOf("ID_VIDEO_WIDTH=", 0);
	if ( i != -1 )
	{
		j = i + 15;
		while ( wg_string_001.mid(j,1) != " " )
		{
			media_width = media_width + wg_string_001.mid(j,1);
			j++;
		}
	}
      	i = wg_string_001.indexOf("ID_VIDEO_HEIGHT=", 0);
	if ( i != -1 )
	{
		j = i + 16;
		while ( wg_string_001.mid(j,1) != " " )
		{
			media_height = media_height + wg_string_001.mid(j,1);
			j++;
		}
	}

        if ( combo_format_dvd->currentIndex() < 2 )
        {
            if ( (media_width.toInt() != 720 || media_height.toInt() != 576) )
            {
		isdvd = 0;
                issca = 1;
            }
        }
        else
        {
            if ( (media_width.toInt() != 720 || media_height.toInt() != 480) )
            {
                isdvd = 0;
                issca = 1;
            }
        }

	// *** FPS ***
      	i = wg_string_001.indexOf("ID_VIDEO_FPS=", 0);
	if ( i != -1 )
	{
		j = i + 13;
		while ( wg_string_001.mid(j,1) != " " )
		{
			media_fps = media_fps + wg_string_001.mid(j,1);
			j++;
		}
	}

	// *** DUREE DU MEDIA ***
      	i = wg_string_001.indexOf("ID_LENGTH=", 0);
	if ( i != -1 )
	{
		j = i + 10;
		while ( wg_string_001.mid(j,1) != " " && wg_string_001.mid(j,1) != "." )
		{
			media_length = media_length + wg_string_001.mid(j,1);
			j++;
		}
	}

	// *** FORMAT DU MEDIA ***
      	i = wg_string_001.lastIndexOf("ID_VIDEO_ASPECT=");
	if ( i != -1 )
	{
		j = i + 16;
		while ( wg_string_001.mid(j,1) != " " )
		{
			media_format = media_format + wg_string_001.mid(j,1);
			j++;
		}
	}

	if (media_format.toFloat() == 0)
	{
		if ( dvd_format == "4/3" )
		{
			media_format = "1.3333";
		}
		else
		{
			media_format = "1.7777";
		}
	}

	// *** NOMBRE DE CANAUX AUDIO ***
      	i = wg_string_001.lastIndexOf("ID_AUDIO_NCH=");
	if ( i != -1 )
	{
		j = i + 13;
		while ( wg_string_001.mid(j,1) != " " )
		{
			media_audio_channel = media_audio_channel + wg_string_001.mid(j,1);
			j++;
		}
	}

	// *** NOMBRE DE CANAUX AUDIO ***
      	i = wg_string_001.lastIndexOf("ID_VIDEO_BITRATE=");
	if ( i != -1 )
	{
		j = i + 17;
		while ( wg_string_001.mid(j,1) != " " )
		{
			media_video_bitrate = media_video_bitrate + wg_string_001.mid(j,1);
			j++;
		}
	}

	if ( media_video_bitrate == "" || media_video_bitrate == "0" ) //|| media_video_bitrate.toInt() > 5000000 )
	{
		media_video_bitrate = "5000000";
	}

	// *** CODEC AUDIO ***
        i = wg_string_001.lastIndexOf("ID_AUDIO_CODEC=a52");
	if ( i == -1 )
	{
	      	i = wg_string_001.lastIndexOf("ID_AUDIO_CODEC=ac3");
		if ( i == -1 )
		{
                    i = wg_string_001.lastIndexOf("ID_AUDIO_CODEC=ffmp2");
                    if ( i == -1 )
                    {
                        i = wg_string_001.lastIndexOf("ID_AUDIO_CODEC=ffac3");
                        if ( i == -1 )
                        {
                                isdvd = 0;
                        }
                    }
		}
	}

	// *** NOMBRE DE CANAUX AUDIO ***
      	i = wg_string_001.lastIndexOf("--av_fine_ms");
	if ( i != -1 )
	{
		j = i + 13;
		while ( wg_string_001.mid(j,1) != " " )
		{
			media_video_sync = media_video_sync + wg_string_001.mid(j,1);
			j++;
		}
	}
	if ( media_video_sync != "" && media_video_sync != "0" )
	{
		QMessageBox msgBox;
		msgBox.setText(tr("L'audio et la video ne sont pas synchrones."));
		msgBox.setInformativeText(tr("Voulez vous que le programme les realigne automatiquement lors de la generation ?"));
		msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
		msgBox.setDefaultButton(QMessageBox::Yes);
		int ret = msgBox.exec();

		switch (ret) {
			case QMessageBox::Yes:
				hdl_current_media->wl_video_sync = media_video_sync;
				isdvd = 0;
			break;
			case QMessageBox::No:
				hdl_current_media->wl_video_sync = "";
			break;
		}
	}
	else
	{
		media_video_sync = "";
	}

	// *** SAUVEGARDE DES VALEURS ***
        hdl_current_media->issca = issca;
	hdl_current_media->wl_duree = media_length;
	hdl_current_media->wl_width = media_width;
	hdl_current_media->wl_height = media_height;
	hdl_current_media->wl_fps = media_fps;
	hdl_current_media->wl_format = media_format;
	hdl_current_media->wl_audio_channel = media_audio_channel;
	hdl_current_media->isdvd = isdvd;
	hdl_current_media->wl_vbitrate = QString::number(media_video_bitrate.toLong());
	hdl_current_media->wl_vbitrate_encode = hdl_current_media->wl_vbitrate;
	hdl_current_media->wl_video_sync = media_video_sync;

        // *** AJOUT DU MEDIA A LA COMBO ***
        must_update = 0;
        combo_quoilire_media->clear();
        combo_quoilire_media->insertItem(0,wg_str_int_002);
        i=0;
        while (i <= nbre_medias )
        {
                hdl_current_media = table_hdl_medias[i];
                combo_quoilire_media->insertItem(i+1, hdl_current_media->pathname_media);
                combo_quoilire_media->setItemIcon(i+1, QIcon(hdl_current_media->miniature));
                i++;
        }
        must_update = 1;

	// *** RECUPERATION TAILLE DU FICHIER ***
	if ( isdvd == 1 )
	{
		QFileInfo fi(hdl_current_media->pathname_media);
		qint64 value = fi.size();
		hdl_current_media->dvdsize = value / 1048576;
	}
	else
	{
		hdl_current_media->dvdsize = (((long)(hdl_current_media->wl_vbitrate_encode.toLong())*(long)hdl_current_media->wl_duree.toInt())/(long)8)/(long)1048576;
	}
	frame_directory->setEnabled(true);
	f_calcul_jauge(hdl_current_media->dvdsize);
	hdl_current_media->repaint();
	nbre_medias++;

        // *** ECRAN DE REDIMENSSIONNEMENT ***
        if ( issca > 0 )
        {
            f_scamedia(hdl_current_media);
        }
}

// ****************************************************
// *** CHANGEMENT DU BITRATE DU MEDIA ET REENCODAGE ***
// ****************************************************

void mainfrm::f_encode_media(media *hdlmedia)
{
        thread_ani->hdlmsk = mask_interface;
        thread_ani->sens = 1;
        thread_ani->isrender = 0;

        mask_interface->show();
        mask_interface->raise();

        QTimer::singleShot(5, this, SLOT(f_run_ani()));

	label_actual_bitrate->setText(tr("Bitrate video : ") + QString::number(hdlmedia->wl_vbitrate_encode.toInt()));
	label_taille_video->setText(tr("Taille approximative : ") + QString::number((((long)hdlmedia->wl_vbitrate_encode.toLong()*(long)hdlmedia->wl_duree.toInt())/(long)8)/(long)1048576) + " Mo");
	slider_bitrate->setMaximum(wl_vmax*1000);
	slider_bitrate->setValue(hdlmedia->wl_vbitrate_encode.toLong());
	frame_reencode->show();
	frame_reencode->raise();
}

void mainfrm::f_bitarte_change(int value)
{
	label_actual_bitrate->setText(tr("Bitrate video : ") + QString::number(value));
	label_taille_video->setText(tr("Taille approximative : ") + QString::number((((long)value*(long)hdl_current_media->wl_duree.toInt())/(long)8)/(long)1048576) + " Mo");
}

void mainfrm::f_close_reencode()
{
	if ( hdl_current_media->wl_vbitrate_encode != hdl_current_media->wl_vbitrate )
	{
		hdl_current_media->isdvd = 0;
		hdl_current_media->already_encode = 0;
		hdl_current_media->repaint();
	}

	hdl_current_media->wl_vbitrate_encode = QString::number(slider_bitrate->value());
	f_calcul_jauge(-hdl_current_media->dvdsize);

	hdl_current_media->dvdsize = (((long)(hdl_current_media->wl_vbitrate_encode.toLong())*(long)hdl_current_media->wl_duree.toLong())/(long)8)/(long)1048576;

	f_calcul_jauge(hdl_current_media->dvdsize);
	frame_reencode->hide();

        thread_ani->hdlmsk = mask_interface;
        thread_ani->sens = 0;
        thread_ani->isrender = 0;

        QTimer::singleShot(5, this, SLOT(f_run_ani()));
        smenuBar->setEnabled(true);
}

void mainfrm::f_delete_media(media *hdlmedia)
{
	// ****************************
	// *** SUPPRESSION DU MEDIA ***
	// ****************************

        QMessageBox msgBox;
        msgBox.setText(tr("Suppression d'un media"));
        msgBox.setInformativeText(tr("Etes vous sur de vouloir supprimer ce media de votre projet ?"));
        msgBox.setStandardButtons(QMessageBox::No | QMessageBox::Yes);
        msgBox.setDefaultButton(QMessageBox::Yes);
        int ret = msgBox.exec();
        switch (ret) {
                case QMessageBox::No:
                        return;
                        break;
        }

        f_save_widgetonmenu();

        // *** ON VERIFIS D'ABORD SI LE MEDIA EST UTILISE ***
        int wl_int_001 = 0;
        int wl_int_002 = 0;
        int wl_int_003 = 0;
        int wl_int_out = 0;

        while ( wl_int_001 <= nbre_menuth && wl_int_out == 0 )
        {
                wl_int_002 = 0;
                while ( table_menus[wl_int_001][wl_int_002][0] != "$$$" && wl_int_out == 0 )
                {
                        if ( table_menus[wl_int_001][wl_int_002][5] == hdlmedia->pathname_media )
                        {
                                wl_int_out = 1;
                        }
                        wl_int_003 = table_menus[wl_int_001][wl_int_002][22].lastIndexOf( hdlmedia->pathname_media );
                        if ( wl_int_003 != -1 )
                        {
                                wl_int_out = 1;
                        }
                        wl_int_002++;
                }
                wl_int_001++;
        }
        if ( wl_int_out == 0 )
        {
            combo_quoilire_media->removeItem(combo_quoilire_media->findText( hdlmedia->pathname_media, Qt::MatchExactly | Qt::MatchCaseSensitive));

            hdlmedia->close();
            int i=0;
            while ( table_hdl_medias[i] != hdlmedia && i < nbre_medias )
            {
                    i++;
            }
            f_calcul_jauge(-hdlmedia->dvdsize);
            //
            if ( table_hdl_medias[i] == hdlmedia )
            {
                    delete frame_syno->tab_pnt_media[i];
                    int j=i;
                    while ( j < nbre_medias-1 )
                    {
                            table_hdl_medias[j] = table_hdl_medias[j+1];
                            frame_syno->tab_pnt_media[j] = frame_syno->tab_pnt_media[j+1];

                            QPropertyAnimation *animation = new QPropertyAnimation(table_hdl_medias[j], "geometry");
                            animation->setDuration(250);
                            animation->setStartValue(QRect(table_hdl_medias[j]->geometry().x(),table_hdl_medias[j]->geometry().y(),table_hdl_medias[j]->width(),table_hdl_medias[j]->height()));
                            animation->setEndValue(QRect(table_hdl_medias[j]->geometry().x(),table_hdl_medias[j]->geometry().y()-130,table_hdl_medias[j]->width(),table_hdl_medias[j]->height()));
                            animation->setEasingCurve(QEasingCurve::InOutCubic);
                            animation->start();

                            j++;
                    }
                    nbre_medias--;
            }
            else
            {
                    qDebug() << "LOGICAL ERROR IN MEMORY WHEN REMOVING A MEDIA";
            }
        }
        else
        {
            QMessageBox::information(this, name_application, tr("Vous ne pouvez pas supprimer ce media.\nIl est actuellement utilise dans votre projet."));
            return;
        }

        // *** DOIT TON CACHER LA SCROLLBAR ***

        if ( ((nbre_medias+1)*120)+(10*(nbre_medias+1))+120 < frame_mediatheque->height() )
        {
            frame_mediatheque->setGeometry(0,0,frame_mediatheque->width(),frame_mediatheque->height()+280);

            if ( myeffect_global_sb_medias->opacity() > 0.0 )
            {
                QPropertyAnimation *animation = new QPropertyAnimation(myeffect_global_sb_medias, "opacity");
                animation->setDuration(1000);
                animation->setStartValue(qreal(1.0));
                animation->setEndValue(qreal(0.0));
                animation->start();
            }
        }

        wg_int_001++;
        hdl_current_media = 0;
}

void mainfrm::f_chapitre_media(media *hdlmedia)
{
	// *** OUVERTURE FENETRE CHAPITRAGE DU MEDIA ***

	// **********************************
	// *** RAPPEL CHAPITRAGE DU MEDIA ***
	// **********************************

	lst_chapters->clear();
	lst_chapters_2->clear();

	for (wg_int_001 = 0; wg_int_001 < hdl_current_media->nbre_chapitres; ++wg_int_001) 
	{
		QListWidgetItem *item = new QListWidgetItem(lst_chapters);
		item->setText(hdlmedia->chapitres[wg_int_001]);
		item->setIcon(hdlmedia->icones_chapitres[wg_int_001]);

		QListWidgetItem *item2 = new QListWidgetItem(lst_chapters_2);
		item2->setText(hdlmedia->chapitres[wg_int_001]);
		item2->setIcon(hdlmedia->icones_chapitres[wg_int_001]);
	}


	// *** AFFICHAGE DUREE + AJOUT DES BUTEES DE CONTROLE ***
	QTime wl_time(0,0,0);
	wl_time = wl_time.addSecs(hdlmedia->wl_duree.toInt());

        label_sticker_length->setText("Media : " + hdlmedia->pathname_media + " - Duree du media : " + wl_time.toString("hh:mm:ss"));
	label_sticker_length->show();

	if ( hdlmedia->wl_duree.toInt() < 100 )
	{
		frame_autochap->setDisabled(true);
	}
	else
	{
		frame_autochap->setEnabled(true);
                combo_autochapter->setMaximum(hdlmedia->wl_duree.toInt()/60);
	}

	frame_fond_menu_chapitrage->show();
	frame_reglages->hide();

	slider_player->setStatusTip(hdlmedia->pathname_media);

        smenuBar->setDisabled(true);

	frame_chapitrage->show();
	frame_chapitrage->raise();

	// *** LECTURE DU MEDIA ***
	player_open_video(hdlmedia->pathname_media);
}

void mainfrm::f_effets_media(media *hdlmedia)
{
	// *** AFFICHAGE DUREE + AJOUT DES BUTEES DE CONTROLE ***
	label_sticker_length->hide();
	frame_fond_menu_chapitrage->hide();
	frame_reglages->show();

	must_update = 0;

	slider_con->setValue(hdlmedia->contraste);
	slider_bri->setValue(hdlmedia->lumiere);
	slider_sat->setValue(hdlmedia->saturation);
        slider_sub_pos->setValue(hdl_current_media->sub_pos);
        slider_sub_siz->setValue(hdl_current_media->sub_size);

	must_update = 1;

	slider_player->setStatusTip(hdlmedia->pathname_media);
        smenuBar->setDisabled(true);
        slider_con->setEnabled(true);
        slider_bri->setEnabled(true);
        slider_sat->setEnabled(true);

	frame_chapitrage->show();
	frame_chapitrage->raise();

	// *** LECTURE DU MEDIA ***
	player_open_video(hdlmedia->pathname_media);
}

void mainfrm::f_close_effects()
{
	if ( player_isplaying == true )
	{
		mplayerProcess.write("pause \n");
		player_isplaying = false;
	}
	mplayerProcess.kill();
        if ( hdl_current_media->saturation != slider_sat->value() || hdl_current_media->contraste != slider_con->value() || hdl_current_media->lumiere != slider_bri->value() || hdl_current_media->sub_pos != slider_sub_pos->value() || hdl_current_media->sub_size != slider_sub_siz->value() )
	{
		hdl_current_media->already_encode = 0;
	}
	hdl_current_media->saturation = slider_sat->value();
	hdl_current_media->contraste = slider_con->value();
	hdl_current_media->lumiere = slider_bri->value();
        hdl_current_media->sub_pos = slider_sub_pos->value();
        hdl_current_media->sub_size = slider_sub_siz->value();
	must_update = 0;
	frame_chapitrage->hide();
        smenuBar->setEnabled(true);
}

void mainfrm::f_select_media(media *hdlmedia, int)
{
	// **************************
	// *** SELECTION DU MEDIA ***
	// **************************

	hdl_current_media = hdlmedia;

	wg_int_001=0;
	while ( wg_int_001 < nbre_medias )
	{
		if ( table_hdl_medias[wg_int_001] == hdlmedia )
		{
			table_hdl_medias[wg_int_001]->is_select = 1;
		}
		else
		{
			table_hdl_medias[wg_int_001]->is_select = 0;
		}
		table_hdl_medias[wg_int_001]->repaint();
		wg_int_001++;
	}
}

void mainfrm::f_ajoute_label()
{
	// *** NOUVEAU LABEL ***
	f_ajoute_menu_new(100,100,128,128);
	hdl_current_menu->islabel = 1;
	bttxt->setPlainText(tr("Titre"));
	f_update_thumb_menu();
}

// ***********************************
// *** GESTION DES MENUS (BOUTONS) ***
// ***********************************

void mainfrm::f_drop_to_editor()
{ 
    if ( screen_designer->wg_str_001.mid(0,4) == "$MED" )
    {
        f_ajoute_menu_new(screen_designer->drop_x,screen_designer->drop_y,128,128);
        hdl_current_menu->quoilire = screen_designer->wg_str_001.remove(0, 4);
        hdl_current_menu->quoilirechapitre = wg_str_int_001;
        hdl_current_menu->audio_track = wg_str_int_006;
        hdl_current_menu->islabel = 0;
        nbre_menus_wo_label++;
        hdl_current_menu->taborder = nbre_menus_wo_label;
        f_select_menu(hdl_current_menu);
        check_anim->setChecked(true);
        f_put_anim();
        //screen_designer->wg_str_001 = "";

        // *** ON PLACE LES CADENAS SUR LES MEDIAS ***
        f_save_widgetonmenu();

        wg_int_001=0;
        wg_int_002=0;
        wg_int_003=0;
        int wl_int_008;

        while ( wg_int_001 <= nbre_medias-1 )
        {
                wg_int_002 = 0;
                wg_int_004 = 0;
                while ( wg_int_002 <= nbre_menuth && wg_int_004 == 0 )
                {
                        wg_int_003 = 0;
                        while ( table_menus[wg_int_002][wg_int_003][0] != "$$$" && wg_int_004 == 0 )
                        {
                                if ( table_menus[wg_int_002][wg_int_003][5] == table_hdl_medias[wg_int_001]->pathname_media )
                                {
                                        wg_int_004 = 1;
                                }
                                wl_int_008 = table_menus[wg_int_002][wg_int_003][22].lastIndexOf( table_hdl_medias[wg_int_001]->pathname_media );
                                if ( wl_int_008 != -1 )
                                {
                                        wg_int_004 = 1;
                                }
                                wg_int_003++;
                        }
                        wg_int_002++;
                }
                if ( wg_int_004 == 0 )
                {
                        table_hdl_medias[wg_int_001]->is_lock = 0;
                }
                else
                {
                        table_hdl_medias[wg_int_001]->is_lock = 1;
                }
                table_hdl_medias[wg_int_001]->repaint();
                wg_int_001++;
        }
    }
    else
    {
        if ( screen_designer->wg_str_001.mid(0,4) == "$ANI" )
        {
            f_select_object_from_drop();
        }
    }
}

void mainfrm::f_menu_lower(menu* hdlmenu)
{
	if ( hdlmenu->zindex > 0 )
	{
		int wl_mid_z = hdlmenu->zindex;
		wg_int_002 = 0;
		while ( wg_int_002 < nbre_menus )
		{
			if ( hdlmenu != table_hdl_menus[wg_int_002] )
			{
				if ( table_hdl_menus[wg_int_002]->zindex < wl_mid_z )
				{
					table_hdl_menus[wg_int_002]->zindex = table_hdl_menus[wg_int_002]->zindex++;
				}
			}
			else
			{
				table_hdl_menus[wg_int_002]->zindex = 0;
			}
			wg_int_002++;
		}
                magnetic_grid->lower();
		hdlmenu->lower();
		safety_zone->lower();
                frame_pencil_draw->lower();
		background_menu->lower();
	}
}

void mainfrm::f_menu_front(menu* hdlmenu)
{
	if ( hdlmenu->zindex < nbre_menus )
	{
		int wl_mid_z = hdlmenu->zindex;
		wg_int_002 = 0;
		while ( wg_int_002 < nbre_menus )
		{
			if ( hdlmenu != table_hdl_menus[wg_int_002] )
			{
				if ( table_hdl_menus[wg_int_002]->zindex > wl_mid_z )
				{
					table_hdl_menus[wg_int_002]->zindex = table_hdl_menus[wg_int_002]->zindex--;
				}
			}
			else
			{
				table_hdl_menus[wg_int_002]->zindex = nbre_menus-1;
			}
			wg_int_002++;
		}
		hdlmenu->raise();
	}
}

void mainfrm::f_goto_menu(menu* hdlmenu)
{
	if ( hdlmenu->quoilire.mid(3,hdlmenu->quoilire.length()-3) == wg_str_int_003 )
	{
                //tmp_hdl_menu_th = table_hdl_menuth[0];
                //f_select_menuth_step_2();
                special_delete = 1;
                hdl_current_menuth->is_edit = 0;

                thread_blend->srcImage = QPixmap::grabWidget(screen_designer).toImage();
                tmp_hdl_menu_th = table_hdl_menuth[0];
                sur_blend->setPixmap(QPixmap::fromImage(thread_blend->srcImage,Qt::AutoColor));
                sur_blend->setGeometry(screen_designer->geometry().x(),screen_designer->geometry().y(),screen_designer->width(),screen_designer->height());
                sur_blend->show();
                sur_blend->raise();
                // *** SAUVEGARDE DES INFORMATIONS DU MENU ***
                f_save_widgetonmenu();

                f_select_menuth_step_2();
                thread_blend->srcImage2 = QPixmap::grabWidget(screen_designer).toImage();
                thread_blend->dstImage = thread_blend->srcImage;
                thread_blend->sequence = 0;
                QTimer::singleShot(5, this, SLOT(f_run_bld()));
                special_delete = 0;
	}
	else
	{
		wg_string_001 = hdlmenu->quoilire;
		wg_string_003 = wg_string_001.remove(0,8);
                hdl_current_menuth->is_edit = 0;

                /*tmp_hdl_menu_th = table_hdl_menuth[wg_string_003.toInt()];
                f_select_menuth_step_2();*/
                special_delete = 1;
                thread_blend->srcImage = QPixmap::grabWidget(screen_designer).toImage();
                tmp_hdl_menu_th = table_hdl_menuth[wg_string_003.toInt()];

                sur_blend->setPixmap(QPixmap::fromImage(thread_blend->srcImage,Qt::AutoColor));
                sur_blend->setGeometry(screen_designer->geometry().x(),screen_designer->geometry().y(),screen_designer->width(),screen_designer->height());
                sur_blend->show();
                sur_blend->raise();

                // *** SAUVEGARDE DES INFORMATIONS DU MENU ***
                f_save_widgetonmenu();
                f_select_menuth_step_2();
                thread_blend->srcImage2 = QPixmap::grabWidget(screen_designer).toImage();
                thread_blend->dstImage = thread_blend->srcImage;
                thread_blend->sequence = 0;
                QTimer::singleShot(5, this, SLOT(f_run_bld()));
                special_delete = 0;
	}
}

/*void mainfrm::f_redraw_menu(menu*)
{
	f_put_txt_on_bt();
	//hdl_current_menu->repaint();
}*/

void mainfrm::f_color_overlays()
{
	f_overlay_menu();
}

void mainfrm::f_copy_bt_2()
{
	if ( hdl_current_menu != 0 )
	{
		f_copy_menu(hdl_current_menu);
	}
}

void mainfrm::f_paste_bt_2()
{
	screen_designer->xevent = 100;
	screen_designer->yevent = 100;
	f_paste_menu();
}

void mainfrm::f_copy_menu(menu* hdlmenu)
{
	copy_table_menus[0] = QString::number(hdlmenu->geometry().x());
	copy_table_menus[1] = QString::number(hdlmenu->geometry().y());
	copy_table_menus[2] = QString::number(hdlmenu->width());
	copy_table_menus[3] = QString::number(hdlmenu->height());
	copy_table_menus[4] = hdlmenu->back_image;
	copy_table_menus[5] = hdlmenu->quoilire;
	copy_table_menus[6] = hdlmenu->path_mask;
	copy_table_menus[7] = QString::number(hdlmenu->rotation);
	copy_table_menus[8] = QString::number(hdlmenu->img_x_size);
	copy_table_menus[9] = hdlmenu->quoilirechapitre;
	copy_table_menus[10] = QString::number(hdlmenu->img_y_size);
	copy_table_menus[11] = QString::number(hdlmenu->islabel);
	copy_table_menus[12] = QString::number(hdlmenu->shadow);
	copy_table_menus[13] = hdlmenu->color_mask_over;
	copy_table_menus[14] = QString::number(hdlmenu->anim_thumb);
	copy_table_menus[15] = QString::number(hdlmenu->zindex);
	//copy_table_menus[16] = QString::number(hdlmenu->taborder);
	copy_table_menus[17] = QString::number(hdlmenu->alpha_menu);
	copy_table_menus[18] = hdlmenu->shadow_color + "$" + QString::number(hdlmenu->shadow_opacity) + "$" + QString::number(hdlmenu->shadow_angle) + "$";
	copy_table_menus[19] = hdlmenu->audio_track;
	copy_table_menus[20] = QString::number(hdlmenu->shear_value_x);
	copy_table_menus[21] = QString::number(hdlmenu->shear_value_y);
	copy_table_menus[22] = "";
	copy_table_menus[23] = "";

	QString wl_str_001 = "";

	if ( hdlmenu->isbold == true )
	{
		wl_str_001 = "1";
	}
	else
	{
		wl_str_001 = "0";
	}

	if ( hdlmenu->isitalic == true )
	{
		wl_str_001 = wl_str_001 + "1";
	}
	else
	{
		wl_str_001 = wl_str_001 + "0";
	}

	if ( hdlmenu->isunderline == true )
	{
		wl_str_001 = wl_str_001 + "1";
	}
	else
	{
		wl_str_001 = wl_str_001 + "0";
	}

	wl_str_001 = wl_str_001 + QString::number(hdlmenu->isalign);

	copy_table_menus[24] = wl_str_001;
	copy_table_menus[25] = hdlmenu->pos_thumb;
        copy_table_menus[26] = QString::number(hdlmenu->font_size);
	screen_designer->is_copy = 1;
	actionColler_le_bouton->setEnabled(true);
}

void mainfrm::f_paste_menu()
{
	if ( nbre_menus < 19 )
	{
		wg_int_001=0;
		while ( table_hdl_menuth[wg_int_001] != hdl_current_menuth && wg_int_001 < nbre_menuth )
		{
			wg_int_001++;
		}

		if ( table_hdl_menuth[wg_int_001] == hdl_current_menuth )
		{
			wg_int_002 = nbre_menus;

			table_menus[wg_int_001][wg_int_002][0] = QString::number(screen_designer->xevent);
			table_menus[wg_int_001][wg_int_002][1] = QString::number(screen_designer->yevent);
			table_menus[wg_int_001][wg_int_002][2] = copy_table_menus[2];
			table_menus[wg_int_001][wg_int_002][3] = copy_table_menus[3];
			table_menus[wg_int_001][wg_int_002][4] = copy_table_menus[4];
			table_menus[wg_int_001][wg_int_002][5] = copy_table_menus[5];
			table_menus[wg_int_001][wg_int_002][6] = copy_table_menus[6];
			table_menus[wg_int_001][wg_int_002][7] = copy_table_menus[7];
			table_menus[wg_int_001][wg_int_002][8] = copy_table_menus[8];
			table_menus[wg_int_001][wg_int_002][9] = copy_table_menus[9];
			table_menus[wg_int_001][wg_int_002][10] = copy_table_menus[10];
			table_menus[wg_int_001][wg_int_002][11] = copy_table_menus[11];
			table_menus[wg_int_001][wg_int_002][12] = copy_table_menus[12];
			table_menus[wg_int_001][wg_int_002][13] = copy_table_menus[13];
			table_menus[wg_int_001][wg_int_002][14] = copy_table_menus[14];
			table_menus[wg_int_001][wg_int_002][15] = QString::number(nbre_menus);
			table_menus[wg_int_001][wg_int_002][16] = QString::number(nbre_menus+1); //nbre_menus_wo_label;
			table_menus[wg_int_001][wg_int_002][17] = copy_table_menus[17];
			table_menus[wg_int_001][wg_int_002][18] = copy_table_menus[18];
			table_menus[wg_int_001][wg_int_002][19] = copy_table_menus[19];
			table_menus[wg_int_001][wg_int_002][20] = copy_table_menus[20];
			table_menus[wg_int_001][wg_int_002][21] = copy_table_menus[21];
			table_menus[wg_int_001][wg_int_002][22] = copy_table_menus[22];
			table_menus[wg_int_001][wg_int_002][23] = copy_table_menus[23];
			table_menus[wg_int_001][wg_int_002][24] = copy_table_menus[24];
			table_menus[wg_int_001][wg_int_002][25] = copy_table_menus[25];
                        table_menus[wg_int_001][wg_int_002][26] = copy_table_menus[26];
	
			f_create_menu_movie();
			if ( hdl_current_menu->islabel == 0 )
			{
				hdl_current_menu->taborder = nbre_menus_wo_label;
			}
		}
	}
	else
	{
		QMessageBox::information(this, name_application, tr("Nombre maximum de boutons sur un menu atteint"));
	}
}

/*void mainfrm::f_put_shadow(int state)
{
	if ( must_update == 1 )
	{
		if ( bttxt->toPlainText() != "" )
		{
			hdl_current_menu->shadow = state;
			hdl_current_menu->shadow_color = QString::number(pntwheel4->red) + "^" + QString::number(pntwheel4->green) + "^" + QString::number(pntwheel4->blue) + "^";
			hdl_current_menu->shadow_opacity = dial_opacity_shadow->value();
			hdl_current_menu->shadow_angle = dial_angle_shadow->value();
			f_put_txt_on_bt();
		}
	}
}*/

void mainfrm::f_shadowtext_angle(int angle)
{
	if ( must_update == 1 )
	{
		if ( bttxt->toPlainText() != "" )
		{
			hdl_current_menu->shadow_angle = angle;
			f_put_txt_on_bt();
		}
	}
}

void mainfrm::f_shadowtext_opacity(int value)
{
	if ( must_update == 1 )
	{
		if ( bttxt->toPlainText() != "" )
		{
			hdl_current_menu->shadow_opacity = value;
			f_put_txt_on_bt();
		}
	}
}

void mainfrm::f_fonttext_size(int value)
{
    if ( must_update == 1 )
    {
            if ( bttxt->toPlainText() != "" )
            {
                    hdl_current_menu->font_size = value;
                    f_put_txt_on_bt();
            }
    }
}

void mainfrm::f_put_anim()
{
	if ( check_anim->isChecked() == true )
	{
		f_image_menu_video();
		hdl_current_menu->anim_thumb = 1;
	}
	else
	{
		hdl_current_menu->anim_thumb = 0;
		hdl_current_menu->charge_image(":/Interface/Interface/default_bt.png");
		hdl_current_menu->set_opacity(hdl_current_menu->alpha_menu);
		hdl_current_menu->pos_thumb = "NA";
	}
	hdl_current_menu->repaint();
}

void mainfrm::f_ajoute_menu()
{
	// *** NOUVEAU BOUTON MENU ***
        f_ajoute_menu_new(screen_designer->xevent,screen_designer->yevent,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_select_menu(hdl_current_menu);
	f_update_thumb_menu();
}

void mainfrm::f_ajoute_menu_txt()
{
        // *** NOUVEAU BOUTON MENU ***
        f_ajoute_menu_new(screen_designer->xevent,screen_designer->yevent,128,128);
        hdl_current_menu->islabel = 1;
        f_select_menu(hdl_current_menu);
        bttxt->setPlainText(tr("Titre"));
        f_update_thumb_menu();
}

void mainfrm::f_ajoute_menu_from_menubar()
{
        // *** NOUVEAU BOUTON MENU ***
        f_ajoute_menu_new(100,100,128,128);
        hdl_current_menu->islabel = 0;
        nbre_menus_wo_label++;
        hdl_current_menu->taborder = nbre_menus_wo_label;
        f_select_menu(hdl_current_menu);
        f_update_thumb_menu();
}

void mainfrm::f_rsc_txt(int indic)
{
    if ( indic == 2 )
    {
        spin_font_size->setValue(spin_font_size->value()+1);
    }
    else
    {
        spin_font_size->setValue(spin_font_size->value()-1);
    }
}

void mainfrm::f_put_txt_on_bt()
{
	if ( must_update == 1 )
	{
		if ( bttxt->toPlainText() != "" )
		{
			if ( check_anim->isChecked() == true )
			{
				check_anim->setChecked(false);
				hdl_current_menu->pos_thumb = "NA";
			}
                        QFont myfont(font_txt->currentFont());

			if ( hdl_current_menu->isbold == true )
			{
                                myfont.setBold(true);
			}

			if ( hdl_current_menu->isitalic == true )
			{
                                myfont.setItalic(true);
			}

			if ( hdl_current_menu->isunderline == true )
			{
                                myfont.setUnderline(true);
			}

			QString wl_str_001 = bttxt->toPlainText();
                        myfont.setPixelSize(spin_font_size->value());

			// *** RECHERCHE DE LA LIGNE LA PLUS LONGUE ***

			QStringList wl_explode = wl_str_001.split("\n",QString::KeepEmptyParts);
			int wl_int_001 = 0;
			int wl_int_002 = 0;
			int wl_int_003 = 0;

			while ( wl_int_001 < wl_explode.count() )
			{
				if ( wl_explode.at(wl_int_001).length() > wl_int_003 )
				{
					wl_int_003 = wl_explode.at(wl_int_001).length();
					wl_int_002 = wl_int_001;
				}
				wl_int_001++;
			}

			//

                        QFontMetrics fm(myfont);

                        int wl_larg_txt = fm.width(wl_explode.at(wl_int_002))+20;
                        hdl_current_menu->draw_image = hdl_current_menu->draw_image.scaled(wl_larg_txt,(spin_font_size->value()+15)*(wl_explode.count()+1));
                        hdl_current_menu->img_x_size = wl_larg_txt;
                        hdl_current_menu->img_y_size = spin_font_size->value()*(wl_explode.count()+1);

                        hdl_current_menu->setGeometry(hdl_current_menu->geometry().x(),hdl_current_menu->geometry().y(),wl_larg_txt,(spin_font_size->value()+15)*(wl_explode.count()+1));

                        if ( wl_larg_txt < 50 )
			{
				wl_larg_txt = 50;
                                hdl_current_menu->img_x_size = wl_larg_txt;
			}

                        QPixmap wl_pix_001(wl_larg_txt,hdl_current_menu->draw_image.height());
			wl_pix_001.fill(QColor(0,0,0,0));

			QPainter p;
			p.begin(&wl_pix_001);
			p.setRenderHint(QPainter::Antialiasing,true);
                        p.setFont(myfont);

                        if ( hdl_current_menu->shadow > 0 )
			{
				QImage wl_ims_1(wl_larg_txt,hdl_current_menu->draw_image.height(),QImage::Format_ARGB32);
				wl_ims_1.fill(0);
				QPainter t;
				t.begin(&wl_ims_1);
				t.setRenderHint(QPainter::Antialiasing,true);
                                t.setFont(myfont);
				t.setPen(QColor(pntwheel4->red,pntwheel4->green,pntwheel4->blue,hdl_current_menu->shadow_opacity));

                                int wl_x = 10+(5*cos((M_PI*hdl_current_menu->shadow_angle)/180));
				int wl_y = 10+(5*sin((M_PI*hdl_current_menu->shadow_angle)/180)); 

				t.drawText(QRect(wl_x,wl_y,wl_larg_txt-20,hdl_current_menu->draw_image.height()-20), Qt::AlignVCenter | hdl_current_menu->isalign, bttxt->toPlainText());
				t.end();
				wl_ims_1 = blur_shadow(wl_ims_1);
				p.drawImage(0,0,wl_ims_1,0,0,-1,-1,Qt::AutoColor);
                        }

                        p.setPen(QColor(pntwheel3->red,pntwheel3->green,pntwheel3->blue));
                        p.drawText(QRect(10,10,wl_larg_txt-20,hdl_current_menu->draw_image.height()-20), Qt::AlignVCenter | hdl_current_menu->isalign, bttxt->toPlainText());
			p.end();

			int sx = hdl_current_menu->shear_value_x;
			int sy = hdl_current_menu->shear_value_y;

			if ( hdl_current_menu->shear_value_x < 0 )
			{
				sx = hdl_current_menu->shear_value_x * -1;
			}

			if ( hdl_current_menu->shear_value_y < 0 )
			{
				sy = hdl_current_menu->shear_value_y * -1;
			}

			double angleradian = (M_PI*hdl_current_menu->rotation)/180;
			float mcos = cos(angleradian);
			float msin = sin(angleradian);

			if ( mcos < 0 )
			{
				mcos=mcos*-1;
			}
			if ( msin < 0 )
			{
				msin=msin*-1;
			}

                        if ( hdl_current_menu->rotation < 90)
                        {
                                hdl_current_menu->menu_width = ((hdl_current_menu->img_x_size+sy) * cos(angleradian))+((hdl_current_menu->img_y_size+sx) * sin(angleradian));
                                hdl_current_menu->menu_height = ((hdl_current_menu->img_y_size+sx) * cos(angleradian))+((hdl_current_menu->img_x_size+sy) * sin(angleradian));
                        }
                        else
                        {
                                float mcos = cos(angleradian);
                                float msin = sin(angleradian);

                                if ( mcos < 0 )
                                {
                                        mcos=mcos*-1;
                                }
                                if ( msin < 0 )
                                {
                                        msin=msin*-1;
                                }
                                hdl_current_menu->menu_width = ((hdl_current_menu->img_x_size+sy) * mcos)+((hdl_current_menu->img_y_size+sx) * msin);
                                hdl_current_menu->menu_height = ((hdl_current_menu->img_x_size+sy) * msin)+((hdl_current_menu->img_y_size+sx) * mcos);
                        }

                        /*if ( is_new_create == 0 )
                        {*/
                            hdl_current_menu->menu_x = hdl_current_menu->geometry().x();
                            hdl_current_menu->menu_y = hdl_current_menu->geometry().y();
                        /*}
                        else
                        {*/
                         //   hdl_current_menu->menu_x = hdl_current_menu->geometry().x()+((hdl_current_menu->width()-hdl_current_menu->menu_width)/2);
                         //   hdl_current_menu->menu_y = hdl_current_menu->geometry().y()+((hdl_current_menu->height()-hdl_current_menu->menu_height)/2);
                        //}

                        hdl_current_menu->setGeometry(hdl_current_menu->menu_x,hdl_current_menu->menu_y,hdl_current_menu->menu_width,hdl_current_menu->menu_height);

                        hdl_current_menu->draw_image = wl_pix_001;
			hdl_current_menu->original = wl_pix_001;
			hdl_current_menu->anim_thumb = 0;
			hdl_current_menu->repaint();

			hdl_current_menu->back_image = "$TXT$" + QString::number(pntwheel3->red) + "^" + QString::number(pntwheel3->green) + "^" + QString::number(pntwheel3->blue) + "^" + font_txt->currentFont().toString() + "^!" + bttxt->toPlainText();
			if ( hdl_current_menu->path_mask != "" )
			{
				hdl_current_menu->path_mask = "";
				hdl_current_menu->path_over_mask = "";
				hdl_current_menu->color_mask_over = "";
			}
			frame_th_msk_idea->setDisabled(true);
		}
		else
		{
			hdl_current_menu->back_image = "";
			hdl_current_menu->img_x_size = 128;
			hdl_current_menu->img_y_size = 128;
			hdl_current_menu->menu_width = 128;
			hdl_current_menu->menu_height = 128;
			hdl_current_menu->charge_image("");
			hdl_current_menu->path_mask = "";
			hdl_current_menu->path_over_mask = "";
			hdl_current_menu->color_mask_over = "";
			hdl_current_menu->setGeometry(hdl_current_menu->menu_x,hdl_current_menu->menu_y,hdl_current_menu->menu_width,hdl_current_menu->menu_height);
			hdl_current_menu->repaint();
			frame_th_msk_idea->setEnabled(true);
		}
                hdl_current_menu->set_opacity(hdl_current_menu->alpha_menu);
	}
}

void mainfrm::f_valide_color_txt()
{
	if ( must_update == 1 )
	{
		if ( bttxt->toPlainText() != "" )
		{
			f_put_txt_on_bt();
			hdl_current_menu->back_image = "$TXT$" + QString::number(pntwheel3->red) + "^" + QString::number(pntwheel3->green) + "^" + QString::number(pntwheel3->blue) + "^" + font_txt->currentFont().toString() + "^!" + bttxt->toPlainText();
			hdl_current_menu->path_mask = "";
		}
	}
}

void mainfrm::f_valide_color_txt_shadow()
{
	if ( must_update == 1 )
	{
		if ( bttxt->toPlainText() != "" )
		{
			f_put_txt_on_bt();
			hdl_current_menu->shadow_color = QString::number(pntwheel4->red) + "^" + QString::number(pntwheel4->green) + "^" + QString::number(pntwheel4->blue) + "^";
		}
	}
}

void mainfrm::f_color_fd_menu()
{
    if ( frame_editor->isVisible() == true )
    {
        scale_current_menu_background = 2;
        QPixmap wl_pix_001(dvdxsize,dvdysize);

        QString wl_red = QString::number(pntwheel11->red);
        QString wl_green = QString::number(pntwheel11->green);
        QString wl_blue = QString::number(pntwheel11->blue);
        QString wl_red_2 = QString::number(pntwheel12->red);
        QString wl_green_2 = QString::number(pntwheel12->green);
        QString wl_blue_2 = QString::number(pntwheel12->blue);

        QPainter p;
        p.begin(&wl_pix_001);
        p.setPen(Qt::NoPen);
        p.setRenderHint(QPainter::Antialiasing,true);

        if ( chkradial->isChecked() == false )
        {
            current_menu_background = " " + wl_red + " " + wl_green + " " + wl_blue + " " + wl_red_2 + " " + wl_green_2 + " " + wl_blue_2 + " 0";
            QLinearGradient Gradient1(0.0,0.0,0.0,wl_pix_001.height());
            Gradient1.setColorAt(0.0, QColor(wl_red.toInt(),wl_green.toInt(),wl_blue.toInt(),255));
            Gradient1.setColorAt(1.0, QColor(wl_red_2.toInt(),wl_green_2.toInt(),wl_blue_2.toInt(),255));
            p.setBrush(Gradient1);
        }
        else
        {
            current_menu_background = " " + wl_red + " " + wl_green + " " + wl_blue + " " + wl_red_2 + " " + wl_green_2 + " " + wl_blue_2 + " 2";
            QRadialGradient Gradient1(dvdxsize/2,dvdysize/2,dvdxsize/2,dvdxsize/2,dvdysize/2);
            Gradient1.setColorAt(0.0, QColor(wl_red.toInt(),wl_green.toInt(),wl_blue.toInt(),255));
            Gradient1.setColorAt(1.0, QColor(wl_red_2.toInt(),wl_green_2.toInt(),wl_blue_2.toInt(),255));
            p.setBrush(Gradient1);
        }

        p.drawRect(0, 0, wl_pix_001.width(), wl_pix_001.height());
        p.end();

        background_menu->setPixmap(wl_pix_001);
        f_update_thumb_menu();
    }
}

void mainfrm::f_chkradial(int state)
{
    if ( frame_editor->isVisible() == true )
    {
        scale_current_menu_background = 2;
        QPixmap wl_pix_001(dvdxsize,dvdysize);

        QString wl_red = QString::number(pntwheel11->red);
        QString wl_green = QString::number(pntwheel11->green);
        QString wl_blue = QString::number(pntwheel11->blue);
        QString wl_red_2 = QString::number(pntwheel12->red);
        QString wl_green_2 = QString::number(pntwheel12->green);
        QString wl_blue_2 = QString::number(pntwheel12->blue);

        current_menu_background = " " + wl_red + " " + wl_green + " " + wl_blue + " " + wl_red_2 + " " + wl_green_2 + " " + wl_blue_2 + " " + QString::number(state);

        QPainter p;
        p.begin(&wl_pix_001);
        p.setPen(Qt::NoPen);
        p.setRenderHint(QPainter::Antialiasing,true);

        if ( state == 0 )
        {
            QLinearGradient Gradient1(0.0,0.0,0.0,wl_pix_001.height());
            Gradient1.setColorAt(0.0, QColor(wl_red.toInt(),wl_green.toInt(),wl_blue.toInt(),255));
            Gradient1.setColorAt(1.0, QColor(wl_red_2.toInt(),wl_green_2.toInt(),wl_blue_2.toInt(),255));
            p.setBrush(Gradient1);
        }
        else
        {
            QRadialGradient Gradient1(dvdxsize/2,dvdysize/2,dvdxsize/2,dvdxsize/2,dvdysize/2);
            Gradient1.setColorAt(0.0, QColor(wl_red.toInt(),wl_green.toInt(),wl_blue.toInt(),255));
            Gradient1.setColorAt(1.0, QColor(wl_red_2.toInt(),wl_green_2.toInt(),wl_blue_2.toInt(),255));
            p.setBrush(Gradient1);
        }

        p.drawRect(0, 0, wl_pix_001.width(), wl_pix_001.height());
        p.end();

        background_menu->setPixmap(wl_pix_001);
        f_update_thumb_menu();
    }
}

void mainfrm::f_font_txt_on_bt(QFont)
{
	if ( must_update == 1 )
	{
		if ( bttxt->toPlainText() != "" )
		{
			f_put_txt_on_bt();
		}
	}
}

void mainfrm::f_fmtfont_txt_on_bt_1()
{
	if ( must_update == 1 )
	{
		if ( hdl_current_menu != 0 )
		{
			if ( bt_fmt_1->isChecked() == true )
			{
				hdl_current_menu->isbold = true;
			}
			else
			{
				hdl_current_menu->isbold = false;
			}
			f_put_txt_on_bt();
		}
	}
}

void mainfrm::f_fmtfont_txt_on_bt_2()
{
	if ( must_update == 1 )
	{
		if ( hdl_current_menu != 0 )
		{
			if ( bt_fmt_2->isChecked() == true )
			{
				hdl_current_menu->isitalic = true;
			}
			else
			{
				hdl_current_menu->isitalic = false;
			}
			f_put_txt_on_bt();
		}
	}
}

void mainfrm::f_fmtfont_txt_on_bt_3()
{
	if ( must_update == 1 )
	{
		if ( hdl_current_menu != 0 )
		{
			if ( bt_fmt_3->isChecked() == true )
			{
				hdl_current_menu->isunderline = true;
			}
			else
			{
				hdl_current_menu->isunderline = false;
			}
			f_put_txt_on_bt();
		}
	}
}

void mainfrm::f_fmtfont_txt_on_bt_4()
{
	if ( must_update == 1 )
	{
		if ( hdl_current_menu != 0 )
		{
			hdl_current_menu->isalign = 1;
			f_put_txt_on_bt();
		}
	}
}

void mainfrm::f_fmtfont_txt_on_bt_5()
{
	if ( must_update == 1 )
	{
		if ( hdl_current_menu != 0 )
		{
			hdl_current_menu->isalign = 4;
			f_put_txt_on_bt();
		}
	}
}

void mainfrm::f_fmtfont_txt_on_bt_6()
{
	if ( must_update == 1 )
	{
		if ( hdl_current_menu != 0 )
		{
			hdl_current_menu->isalign = 2;
			f_put_txt_on_bt();
		}
	}
}

void mainfrm::f_showhide_txtadv()
{
    bt_conf_txt->setDisabled(true);
    if ( frame_advanced_text->geometry().x() < 10 )
    {
        QPropertyAnimation *animationtop = new QPropertyAnimation(frame_txtbase, "geometry");
        animationtop->setDuration(200);
        animationtop->setStartValue(QRect(frame_txtbase->geometry().x(),frame_txtbase->geometry().y(),frame_txtbase->width(),frame_txtbase->height()));
        animationtop->setEndValue(QRect(frame_txtbase->geometry().x(),154,frame_txtbase->width(),frame_txtbase->height()));
        //animation->setEasingCurve(QEasingCurve::InOutBack);
        animationtop->setEasingCurve(QEasingCurve::InOutCubic);
        animationtop->start();

        QPropertyAnimation *animation = new QPropertyAnimation(frame_advanced_text, "geometry");
        connect(animation,SIGNAL(finished()),this,SLOT(f_showhide_txtadv_end()));
        animation->setDuration(250);
        animation->setStartValue(QRect(frame_advanced_text->geometry().x(),frame_advanced_text->geometry().y(),frame_advanced_text->width(),frame_advanced_text->height()));
        animation->setEndValue(QRect(frame_advanced_text->geometry().x()+frame_pro->width(),frame_advanced_text->geometry().y(),frame_advanced_text->width(),frame_advanced_text->height()-80));
        animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();
    }
    else
    {
        QPropertyAnimation *animationtop = new QPropertyAnimation(frame_txtbase, "geometry");
        animationtop->setDuration(200);
        animationtop->setStartValue(QRect(frame_txtbase->geometry().x(),frame_txtbase->geometry().y(),frame_txtbase->width(),frame_txtbase->height()));
        animationtop->setEndValue(QRect(frame_txtbase->geometry().x(),10,frame_txtbase->width(),frame_txtbase->height()));
        //animation->setEasingCurve(QEasingCurve::InOutBack);
        animationtop->setEasingCurve(QEasingCurve::InOutCubic);
        animationtop->start();

        QPropertyAnimation *animation = new QPropertyAnimation(frame_advanced_text, "geometry");
        connect(animation,SIGNAL(finished()),this,SLOT(f_showhide_txtadv_end()));
        animation->setDuration(250);
        animation->setStartValue(QRect(frame_advanced_text->geometry().x(),frame_advanced_text->geometry().y(),frame_advanced_text->width(),frame_advanced_text->height()));
        animation->setEndValue(QRect(frame_advanced_text->geometry().x()-frame_pro->width(),frame_advanced_text->geometry().y(),frame_advanced_text->width(),frame_advanced_text->height()+80));
        //animation->setEasingCurve(QEasingCurve::InOutBack);
        animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();
    }
}

void mainfrm::f_showhide_txtadv_end()
{
    bt_conf_txt->setEnabled(true);
}

void mainfrm::f_dispatch_menu()
{
        // *** FENETRE DISPATCHING AUTO DES BOUTONS ***
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 1;
	thread_ani->isrender = 0;
	position_dispatch = 0;
	position_media_dispatch = 9999;
	//
	QPixmap wlpixmap = QPixmap::grabWidget(screen_designer);
	wlpixmap = wlpixmap.scaledToHeight ( 130, Qt::FastTransformation );
	bt_dispatch_1->wl_fond = wlpixmap;
	bt_dispatch_2->wl_fond = wlpixmap;
	bt_dispatch_3->wl_fond = wlpixmap;
	bt_dispatch_4->wl_fond = wlpixmap;
	bt_dispatch_5->wl_fond = wlpixmap;
	//
	combo_typehelp_chapter->setDisabled(true);
	checkBox_typehelp_animated->setDisabled(true);
	checkBox_typehelp_title->setDisabled(true);
	font_txt_dispatch->setDisabled(true);
	wheel_txt_dispatch->setDisabled(true);
	//
	combo_typehelp->clear();
	combo_typehelp_chapter->clear();
	combo_typehelp_chapter->setDisabled(true);
	combo_typehelp->insertItem(0,tr("Boutons vierges"));
	combo_typehelp->setItemIcon(0, QIcon(":/Interface/Interface/default_bt.png"));
	combo_typehelp->insertSeparator( 1 );

	int wl_int_001 = 0;

	while ( wl_int_001 < nbre_medias )
	{
		combo_typehelp->insertItem(wl_int_001+2,table_hdl_medias[wl_int_001]->pathname_media);
		combo_typehelp->setItemIcon(wl_int_001+2, QIcon(table_hdl_medias[wl_int_001]->image));
		wl_int_001++;
	}

	mask_interface->show();
	mask_interface->raise();

	frame_dispatch->show();
	frame_dispatch->raise();
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_combo_typehelp_changed(int valsel)
{
	if ( valsel < 2 )
	{
		combo_typehelp_chapter->clear();
		combo_typehelp_chapter->setDisabled(true);
		checkBox_typehelp_animated->setDisabled(true);
		checkBox_typehelp_title->setDisabled(true);
		font_txt_dispatch->setDisabled(true);
		wheel_txt_dispatch->setDisabled(true);
	}
	else
	{
		combo_typehelp_chapter->clear();
		combo_typehelp_chapter->setEnabled(true);
		position_dispatch = 0;
		position_media_dispatch = 9999;

		int wl_int_001 = 0;

		while ( wl_int_001 < nbre_medias && table_hdl_medias[wl_int_001]->pathname_media != combo_typehelp->currentText())
		{
			wl_int_001++;
		}

		if ( table_hdl_medias[wl_int_001]->pathname_media == combo_typehelp->currentText() )
		{
			int wl_int_002 = 0;
			position_media_dispatch = wl_int_001;
			while ( wl_int_002 < table_hdl_medias[wl_int_001]->nbre_chapitres )
			{
				combo_typehelp_chapter->insertItem(wl_int_002,table_hdl_medias[wl_int_001]->chapitres[wl_int_002]);
				combo_typehelp_chapter->setItemIcon(wl_int_002, QIcon(table_hdl_medias[wl_int_001]->icones_chapitres[wl_int_002]));
				wl_int_002++;
			}
			if ( wl_int_002 > 0 )
			{
				combo_typehelp_chapter->setEnabled(true);
				checkBox_typehelp_animated->setEnabled(true);
				checkBox_typehelp_title->setEnabled(true);
				font_txt_dispatch->setEnabled(true);
				wheel_txt_dispatch->setEnabled(true);
			}
			else
			{
				combo_typehelp_chapter->setDisabled(true);
				checkBox_typehelp_animated->setEnabled(true);
				checkBox_typehelp_title->setEnabled(true);
				font_txt_dispatch->setEnabled(true);
				wheel_txt_dispatch->setEnabled(true);
			}
		}
	}
}

void mainfrm::f_combo_typehelpchapter_changed(int valsel)
{
	position_dispatch = valsel;
}

void mainfrm::f_dispatch_declare()
{
	if ( hdl_current_menu != 0 && combo_typehelp->currentIndex() > 1 && position_media_dispatch != 9999 )
	{
		if ( position_dispatch < combo_typehelp_chapter->count() )
		{
			hdl_current_menu->quoilire = combo_typehelp->currentText();

			hdl_current_menu->quoilirechapitre = combo_typehelp_chapter->itemText(position_dispatch);
			// *** MINIATURE DU CHAPITRE ***
			//hdl_current_menu->draw_image = table_hdl_medias[position_media_dispatch]->miniature.scaledToWidth(hdl_current_menu->img_x_size,Qt::FastTransformation);
			hdl_current_menu->draw_image = table_hdl_medias[position_media_dispatch]->icones_chapitres[position_dispatch].pixmap( hdl_current_menu->draw_image.width(), hdl_current_menu->draw_image.height(), QIcon::Normal, QIcon::On );
			hdl_current_menu->original = table_hdl_medias[position_media_dispatch]->icones_chapitres[position_dispatch].pixmap( 500, 500 / (hdl_current_menu->draw_image.width()/hdl_current_menu->draw_image.height()), QIcon::Normal, QIcon::On );

			hdl_current_menu->charge_image("EXT_VIDEO_EXT");
			hdl_current_menu->back_image="EXT_VIDEO_EXT";

			if ( checkBox_typehelp_animated->isChecked() == true )
			{
				hdl_current_menu->anim_thumb = 1;
			}
			else
			{
				hdl_current_menu->anim_thumb = 0;
			}

			if ( checkBox_typehelp_title->isChecked() == true )
			{
				f_ajoute_menu_new(hdl_current_menu->geometry().x(),hdl_current_menu->geometry().y()+hdl_current_menu->img_y_size+40,hdl_current_menu->width(),60);
				hdl_current_menu->islabel = 1;
				QPixmap wl_pix_001(hdl_current_menu->width(),60);
				wl_pix_001.fill(QColor(0,0,0,0));
				QPainter p;
				p.begin(&wl_pix_001);
				p.setRenderHint(QPainter::Antialiasing,true);
				p.setFont(font_txt_dispatch->currentFont());
				p.setPen(QColor(pntwheel5->red,pntwheel5->green,pntwheel5->blue));
				p.drawText(QRect(0,0,hdl_current_menu->width(),60), Qt::AlignVCenter | Qt::AlignLeft, table_hdl_medias[position_media_dispatch]->chapitres[position_dispatch]);
				p.end();

				hdl_current_menu->img_x_size = wl_pix_001.width();
				hdl_current_menu->img_y_size = wl_pix_001.height();
				hdl_current_menu->draw_image = wl_pix_001; //.scaled(hdl_current_menu->img_x_size,hdl_current_menu->img_y_size);
				hdl_current_menu->original = wl_pix_001;
				hdl_current_menu->anim_thumb = 0;
				hdl_current_menu->repaint();

				hdl_current_menu->back_image = "$TXT$" + QString::number(pntwheel5->red) + "^" + QString::number(pntwheel5->green) + "^" + QString::number(pntwheel5->blue) + "^" + font_txt_dispatch->currentFont().toString() + "^!" + table_hdl_medias[position_media_dispatch]->chapitres[position_dispatch];  //166;195;310;128;*;;;0;310;;128;0;0;;0;0;1;255;0^0^0^$255$0$;
//$TXT$255^255^255^Myriad Apple [adobe],9,-1,5,50,0,0,0,0,0^!coucou
				hdl_current_menu->path_mask = "";
				hdl_current_menu->path_over_mask = "";
				hdl_current_menu->color_mask_over = "";
				hdl_current_menu->setGeometry(hdl_current_menu->geometry().x(),hdl_current_menu->geometry().y(),hdl_current_menu->width(),hdl_current_menu->img_y_size);
				frame_th_msk_idea->setDisabled(true);
			}
			position_dispatch++;
		}
		else
		{
			if ( position_dispatch == 0 )
			{
				hdl_current_menu->quoilire = combo_typehelp->currentText();

				hdl_current_menu->quoilirechapitre = wg_str_int_001;
				// *** MINIATURE DU CHAPITRE ***
				//hdl_current_menu->draw_image = table_hdl_medias[position_media_dispatch]->miniature.scaledToWidth(hdl_current_menu->img_x_size,Qt::FastTransformation);
				hdl_current_menu->draw_image = table_hdl_medias[position_media_dispatch]->miniature.scaled( hdl_current_menu->draw_image.width(), hdl_current_menu->draw_image.height());
				hdl_current_menu->original = table_hdl_medias[position_media_dispatch]->miniature;

				hdl_current_menu->charge_image("EXT_VIDEO_EXT");
				hdl_current_menu->back_image="EXT_VIDEO_EXT";

				if ( checkBox_typehelp_animated->isChecked() == true )
				{
					hdl_current_menu->anim_thumb = 1;
				}
				else
				{
					hdl_current_menu->anim_thumb = 0;
				}

				if ( checkBox_typehelp_title->isChecked() == true )
				{
					f_ajoute_menu_new(hdl_current_menu->geometry().x(),hdl_current_menu->geometry().y()+hdl_current_menu->img_y_size+40,hdl_current_menu->width(),60);
					hdl_current_menu->islabel = 1;
					QPixmap wl_pix_001(hdl_current_menu->width(),60);
					wl_pix_001.fill(QColor(0,0,0,0));
					QPainter p;
					p.begin(&wl_pix_001);
					p.setRenderHint(QPainter::Antialiasing,true);
					p.setFont(font_txt_dispatch->currentFont());
					p.setPen(QColor(pntwheel5->red,pntwheel5->green,pntwheel5->blue));
					int wl2_int_001 = table_hdl_medias[position_media_dispatch]->pathname_media.lastIndexOf( '/' );

					p.drawText(QRect(0,0,hdl_current_menu->width(),60), Qt::AlignVCenter | Qt::AlignLeft, table_hdl_medias[position_media_dispatch]->pathname_media.mid(wl2_int_001 + 1, table_hdl_medias[position_media_dispatch]->pathname_media.length() - (wl2_int_001 + 1)));
					p.end();

					hdl_current_menu->img_x_size = wl_pix_001.width();
					hdl_current_menu->img_y_size = wl_pix_001.height();
					hdl_current_menu->draw_image = wl_pix_001; //.scaled(hdl_current_menu->img_x_size,hdl_current_menu->img_y_size);
					hdl_current_menu->original = wl_pix_001;
					hdl_current_menu->anim_thumb = 0;
					hdl_current_menu->repaint();

					hdl_current_menu->back_image = "$TXT$" + QString::number(pntwheel5->red) + "^" + QString::number(pntwheel5->green) + "^" + QString::number(pntwheel5->blue) + "^" + font_txt_dispatch->currentFont().toString() + "^!" + table_hdl_medias[position_media_dispatch]->pathname_media.mid(wl2_int_001 + 1, table_hdl_medias[position_media_dispatch]->pathname_media.length() - (wl2_int_001 + 1));  
					hdl_current_menu->path_mask = "";
					hdl_current_menu->path_over_mask = "";
					hdl_current_menu->color_mask_over = "";
					hdl_current_menu->setGeometry(hdl_current_menu->geometry().x(),hdl_current_menu->geometry().y(),hdl_current_menu->width(),hdl_current_menu->img_y_size);
					frame_th_msk_idea->setDisabled(true);
				}

			}
		}
	}
}

void mainfrm::f_dispatch_1()
{
	int wl_int_001 = (dvdxsize-296)/2;
	int wl_int_002 = (dvdysize-128)/2;

	f_ajoute_menu_new(wl_int_001,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();

	f_ajoute_menu_new(wl_int_001+168,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();

	//
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 0;
	frame_dispatch->hide();
	smenuBar->setEnabled(true);
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_dispatch_2()
{
	int wl_int_001 = (dvdxsize-296)/2;
	int wl_int_002 = (dvdysize-296)/2;
	f_ajoute_menu_new(wl_int_001,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+168,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+84,wl_int_002+192,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	//
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 0;
	frame_dispatch->hide();
	smenuBar->setEnabled(true);
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_dispatch_3()
{
	int wl_int_001 = (dvdxsize-296)/2;
	int wl_int_002 = (dvdysize-296)/2;
	f_ajoute_menu_new(wl_int_001,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+168,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001,wl_int_002+192,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+168,wl_int_002+192,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	//
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 0;
	frame_dispatch->hide();
	smenuBar->setEnabled(true);
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_dispatch_4()
{
	int wl_int_001 = (dvdxsize-464)/2;
	int wl_int_002 = (dvdysize-296)/2;
	f_ajoute_menu_new(wl_int_001,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+168,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+336,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+84,wl_int_002+192,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+252,wl_int_002+192,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	//
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 0;
	frame_dispatch->hide();
	smenuBar->setEnabled(true);
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_dispatch_5()
{
	int wl_int_001 = (dvdxsize-464)/2;
	int wl_int_002 = (dvdysize-296)/2;
	f_ajoute_menu_new(wl_int_001,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+168,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+336,wl_int_002,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001,wl_int_002+192,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+168,wl_int_002+192,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	f_ajoute_menu_new(wl_int_001+336,wl_int_002+192,128,128);
	hdl_current_menu->islabel = 0;
	nbre_menus_wo_label++;
	hdl_current_menu->taborder = nbre_menus_wo_label;
	f_dispatch_declare();
	//
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 0;
	frame_dispatch->hide();
	smenuBar->setEnabled(true);
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_select_menu(menu *hdlmenu)
{
	// *** SELECTION DU MENU ET AFFICHAGE DES VALEURS ***
	must_update = 0;
        int wl_int_001 = 0;

        while ( wl_int_001 < nbre_menus )
	{
		if ( h_regle->isVisible() == true )
		{
                        table_hdl_menus[wl_int_001]->is_ruler = 1;
		}
		else
		{
                        table_hdl_menus[wl_int_001]->is_ruler = 0;
		}

                if ( table_hdl_menus[wl_int_001] == hdlmenu )
		{
                        table_hdl_menus[wl_int_001]->is_select = 1;
		}
		else
		{
                        table_hdl_menus[wl_int_001]->is_select = 0;
		}
                table_hdl_menus[wl_int_001]->repaint();
                wl_int_001++;
	}

	bt_bt_img->setEnabled(true);
	dial_alpha_menu->setEnabled(true);
	bttxt->setEnabled(true);
	// *** EXTRACTION POUR LE CAS D'UN BOUTON TEXTE ***
	wg_string_001 = hdlmenu->back_image;
	wg_string_002 = "";

	if ( wg_string_001.mid(0,5) == "$TXT$" )
	{
		wg_int_001 = 5;
		wg_int_002 = 0;
		while ( wg_string_001.mid(wg_int_001,1) != "!" && wg_int_002 < 4 )
		{
			if ( wg_string_001.mid(wg_int_001,1) == "^" )
			{
				if ( wg_int_002 == 0 )
				{
					pntwheel3->red = wg_string_002.toInt();
					wg_string_002 = "";
				}
				if ( wg_int_002 == 1 )
				{
					pntwheel3->green = wg_string_002.toInt();
					wg_string_002 = "";
				}
				if ( wg_int_002 == 2 )
				{
					pntwheel3->blue = wg_string_002.toInt();
					wg_string_002 = "";
					pntwheel3->setColor(pntwheel3->red,pntwheel3->green,pntwheel3->blue);
				}
				if ( wg_int_002 == 3 )
				{
					font_txt->setCurrentFont(QFont(wg_string_002));
				}
				wg_int_002++;
			}
			else
			{
				wg_string_002 = wg_string_002 + wg_string_001.mid(wg_int_001,1);
			}
			wg_int_001++;
		}

		QString wl_string_001 = hdlmenu->shadow_color;
		wg_string_002 = "";
		int wl_int_001 = 0;
		wg_int_002 = 0;
		if ( wl_string_001.length() > 0 )
		{
			while ( wg_int_002 < 3 )
			{
				if ( wl_string_001.mid(wl_int_001,1) == "^" )
				{
					if ( wg_int_002 == 0 )
					{
						pntwheel4->red = wg_string_002.toInt();
						wg_string_002 = "";
					}
					if ( wg_int_002 == 1 )
					{
						pntwheel4->green = wg_string_002.toInt();
						wg_string_002 = "";
					}
					if ( wg_int_002 == 2 )
					{
						pntwheel4->blue = wg_string_002.toInt();
						wg_string_002 = "";
						pntwheel4->setColor(pntwheel4->red,pntwheel4->green,pntwheel4->blue);
					}
					wg_int_002++;
				}
				else
				{
					wg_string_002 = wg_string_002 + wl_string_001.mid(wl_int_001,1);
				}
				wl_int_001++;
			}
		}
		else
		{
		}

		bttxt->setPlainText(wg_string_001.mid(wg_int_001+1,wg_string_001.length() - wg_int_001));
		frame_th_msk_idea->setDisabled(true);
	}
	else
	{
		bttxt->setPlainText("");
		frame_th_msk_idea->setEnabled(true);
	}
	dial_angle_shadow->setValue(hdlmenu->shadow_angle);
	dial_opacity_shadow->setValue(hdlmenu->shadow_opacity);
        spin_font_size->setValue(hdlmenu->font_size);

	if ( hdlmenu->isbold == true )
	{
		bt_fmt_1->setChecked(true);
	}
	else
	{
		bt_fmt_1->setChecked(false);
	}

	if ( hdlmenu->isitalic == true )
	{
		bt_fmt_2->setChecked(true);
	}
	else
	{
		bt_fmt_2->setChecked(false);
	}

	if ( hdlmenu->isunderline == true )
	{
		bt_fmt_3->setChecked(true);
	}
	else
	{
		bt_fmt_3->setChecked(false);
	}

	if ( hdlmenu->isalign == 1 )
	{
		bt_fmt_4->setChecked(true);
	}
	else
	{
                if ( hdlmenu->isalign == 4 )
		{
			bt_fmt_5->setChecked(true);
		}
		else
		{
                        if ( hdlmenu->isalign == 2 )
			{
				bt_fmt_6->setChecked(true);
			}
		}	
	}

	if ( hdlmenu->anim_thumb == 0 )
	{
		check_anim->setChecked(false);
	}
	else
	{
		check_anim->setChecked(true);
	}

        //frame_th_msk_idea->setEnabled(true);

	// *** AFFICHAGE DES VALEURS ***
	if ( hdlmenu->quoilire.mid(0,3) != "!M!" )
	{
		if ( hdlmenu->islabel == 0 )
		{
			if ( combo_quoilire_media->findText( hdlmenu->quoilire, Qt::MatchExactly | Qt::MatchCaseSensitive) > 0 )
			{
				combo_quoilire_media->setCurrentIndex(combo_quoilire_media->findText( hdlmenu->quoilire, Qt::MatchExactly | Qt::MatchCaseSensitive));
				// *** CHARGEMENT DES CHAPITRES S'ILS EXISTENT ***
				wg_int_001=0;
				wg_int_002=0;
				while ( wg_int_001 < nbre_medias && wg_int_002 == 0 )
				{
					if ( table_hdl_medias[wg_int_001]->pathname_media == combo_quoilire_media->currentText() )
					{
						wg_int_002 = 1;
					}
					else
					{
						wg_int_001++;
					}
				}
				if ( wg_int_002 == 1 && table_hdl_medias[wg_int_001]->nbre_chapitres > 0 )
				{
					combo_quoilire_media_chapitre->clear();
					combo_quoilire_media_chapitre->insertItem(0,wg_str_int_001);
					for (wg_int_003 = 0; wg_int_003 < table_hdl_medias[wg_int_001]->nbre_chapitres; ++wg_int_003) 
					{
						combo_quoilire_media_chapitre->insertItem(wg_int_003+1,table_hdl_medias[wg_int_001]->chapitres[wg_int_003]);
						combo_quoilire_media_chapitre->setItemIcon(wg_int_003+1, QIcon(table_hdl_medias[wg_int_001]->icones_chapitres[wg_int_003]));
					}
					combo_quoilire_media_chapitre->setEnabled(true);
				}
				else
				{
					combo_quoilire_media_chapitre->clear();
					combo_quoilire_media_chapitre->insertItem(0,wg_str_int_001);
					combo_quoilire_media_chapitre->setDisabled(true);
				}
				combo_quoilire_media_chapitre->setCurrentIndex(combo_quoilire_media_chapitre->findText( hdlmenu->quoilirechapitre, Qt::MatchExactly | Qt::MatchCaseSensitive));

				if ( combo_quoilire_media->currentIndex() > 0 )
				{
					combo_quoilire_menu->setDisabled(true);
					combo_quoilire_menu->setCurrentIndex(0);
					combo_quoilire_media->setEnabled(true);
					combo_select_langue->setEnabled(true);
					check_anim->setEnabled(true);
				}
				else
				{
					combo_quoilire_media->setEnabled(true);
					combo_quoilire_media_chapitre->setDisabled(true);
					combo_quoilire_media_chapitre->setCurrentIndex(0);
					combo_select_langue->setEnabled(true);
					combo_quoilire_menu->setEnabled(true);
					check_anim->setDisabled(true);
				}
			}
			else
			{
				combo_quoilire_media_chapitre->clear();
				combo_quoilire_media->setCurrentIndex(0);
				combo_quoilire_menu->setCurrentIndex(0);
				combo_quoilire_menu->setEnabled(true);
				combo_quoilire_media->setEnabled(true);
				combo_select_langue->setDisabled(true);
				combo_quoilire_media_chapitre->setDisabled(true);
				check_anim->setDisabled(true);
			}
		}
		else
		{
                        //frame_th_msk_idea->setDisabled(true);
			combo_quoilire_media_chapitre->clear();
			combo_quoilire_media->setCurrentIndex(0);
			combo_quoilire_menu->setCurrentIndex(0);
			combo_quoilire_menu->setDisabled(true);
			combo_quoilire_media->setDisabled(true);
			combo_quoilire_media_chapitre->setDisabled(true);
			check_anim->setDisabled(true);
		}
	}
	else
	{
		//if ( hdlmenu->quoilire.mid(0,3) == "!M!" )
		//{
			if ( combo_quoilire_menu->findText( hdlmenu->quoilire.mid(3,hdlmenu->quoilire.length()-3), Qt::MatchExactly | Qt::MatchCaseSensitive) >= 0 && hdlmenu->quoilire.mid(3,hdlmenu->quoilire.length()-3) != wg_str_int_002 )
			{
				combo_quoilire_menu->setCurrentIndex(combo_quoilire_menu->findText( hdlmenu->quoilire.mid(3,hdlmenu->quoilire.length()-3), Qt::MatchExactly | Qt::MatchCaseSensitive));
				combo_quoilire_media->setCurrentIndex(0);
				combo_quoilire_media->setDisabled(true);
				check_anim->setDisabled(true);
				combo_quoilire_media_chapitre->clear();
				combo_quoilire_media_chapitre->setDisabled(true);
				combo_quoilire_media_chapitre->setCurrentIndex(0);
				combo_quoilire_menu->setEnabled(true);
				combo_select_langue->setDisabled(true);
			}
			else
			{
				hdlmenu->quoilire = "";
				combo_quoilire_media_chapitre->clear();
				combo_quoilire_menu->setCurrentIndex(0);
				combo_quoilire_media->setCurrentIndex(0);
				combo_quoilire_media->setEnabled(true);
				combo_quoilire_menu->setEnabled(true);
				check_anim->setDisabled(true);
				combo_select_langue->setDisabled(true);
			}
		/*}
		else
		{
			combo_quoilire_media->setEnabled(true);
			combo_quoilire_menu->setEnabled(true);
			check_anim->setDisabled(true);
		}*/
	}
	// *** OPACITE ***
	dial_alpha_menu->setValue(hdlmenu->alpha_menu);

	// *** LANGUAGE ***
	f_display_language();
	if ( hdlmenu->audio_track != "" )
	{
		if ( combo_select_langue->findText( hdlmenu->audio_track, Qt::MatchExactly | Qt::MatchCaseSensitive) >= 0 )
		{
			combo_select_langue->setCurrentIndex(combo_select_langue->findText( hdlmenu->audio_track, Qt::MatchExactly | Qt::MatchCaseSensitive));
		}
		else
		{
			combo_select_langue->setCurrentIndex(-1);
		}
	}
	else
	{
		combo_select_langue->setCurrentIndex(-1);
	}

	// *** ON DEVEROUILLE LE PANNEAU D'EDITION ***

	hdl_current_menu = hdlmenu;

        if ( magnetic_grid->isVisible() == true )
        {
            hdl_current_menu->is_magnetic = 1;
        }
        else
        {
            hdl_current_menu->is_magnetic = 0;
        }

	actionCopier_le_bouton->setEnabled(true);
	hdl_current_menu->tool = current_tool;
	must_update = 1;
	//
	f_affiche_info_pos(hdl_current_menu);
	hdl_current_menu->change_cursor();
}

void mainfrm::f_image_menu()
{
	// *** CHOIX DE L'IMAGE DU BOUTON MENU ***

	frame_pro->setDisabled(true);

	menuProjet->setDisabled(true);
	menuMenu->setDisabled(true);
	menuAffichage->setDisabled(true);
	menuG_n_ration->setDisabled(true);
	menuEdition->setDisabled(true);
	actionMenu_pr_c_dent->setDisabled(true);
	actionMenu_suivant->setDisabled(true);
	actionCouleurs_des_overlays->setDisabled(true);
	actionParam_tres_avanc_s->setDisabled(true);
	menuA_propos->setDisabled(true);
	frame_editor->setDisabled(true);

	frame_lst_menus->hide();

	myfileopen *hdlfopen = new myfileopen(this);
	hdlfopen->setDirectory(path_background);
	hdlfopen->source = 1;
	hdlfopen->setWindowTitle(tr("Image du bouton"));
        hdlfopen->setFilter("(*.PNG *.png *.jpg *.JPG *.jeg *.JPEG *.MPG *.mpg *.AVI *.avi *.gif *.GIF *.MPEG *.mpeg)");
	connect(hdlfopen, SIGNAL(change_image(QString)),this, SLOT(f_open_ipreview(QString)));
	connect(hdlfopen, SIGNAL(filesSelected( const QStringList )),this, SLOT(f_close_ipreview( const QStringList )));
	connect(hdlfopen, SIGNAL(f_close()),this, SLOT(f_cancel_ipreview()));
	connect(hdlfopen, SIGNAL(finished(int)),this, SLOT(f_cancel_ipreview()));

	pntfiled = hdlfopen;

	hdlfopen->show();
	hdlfopen->raise();
}

void mainfrm::f_image_menu_video()
{
	// *** RECUPERATION DE L'IMAGE DE LA VIDEO ASSOCIEE AU BOUTON MENU ***

        int wl_int_001=0;
        while ( wl_int_001 < nbre_medias && table_hdl_medias[wl_int_001]->pathname_media != combo_quoilire_media->currentText() )
	{
                wl_int_001++;
	}

        if ( wl_int_001 < nbre_medias )
	{
                if ( table_hdl_medias[wl_int_001]->pathname_media == combo_quoilire_media->currentText() )
		{
			if ( combo_quoilire_media_chapitre->currentIndex() <= 0 )
			{
				// *** IMAGE TOTALITE DU MEDIA ***
                                hdl_current_menu->draw_image = table_hdl_medias[wl_int_001]->miniature.scaledToWidth(hdl_current_menu->img_x_size,Qt::FastTransformation);
                                hdl_current_menu->original = table_hdl_medias[wl_int_001]->miniature;
			}
			else
			{
				// *** MINIATURE DU CHAPITRE ***
                                hdl_current_menu->draw_image = table_hdl_medias[wl_int_001]->miniature.scaledToWidth(hdl_current_menu->img_x_size,Qt::FastTransformation);
                                hdl_current_menu->draw_image = table_hdl_medias[wl_int_001]->icones_chapitres[combo_quoilire_media_chapitre->currentIndex()-1].pixmap( hdl_current_menu->draw_image.width(), hdl_current_menu->draw_image.height(), QIcon::Normal, QIcon::On );
                                hdl_current_menu->original = table_hdl_medias[wl_int_001]->icones_chapitres[combo_quoilire_media_chapitre->currentIndex()-1].pixmap( 500, 500 / (hdl_current_menu->draw_image.width()/hdl_current_menu->draw_image.height()), QIcon::Normal, QIcon::On );
			}
                        hdl_current_menu->img_x_size = hdl_current_menu->draw_image.width();
                        hdl_current_menu->img_y_size = hdl_current_menu->draw_image.height();


			hdl_current_menu->charge_image("EXT_VIDEO_EXT");
			hdl_current_menu->back_image="EXT_VIDEO_EXT";
			must_update = 0;
                        if ( hdl_current_menu->anim_thumb != 0 )
			{
				hdl_current_menu->anim_thumb = 0;
				check_anim->setChecked(false);
                        }
			bttxt->setPlainText("");
			must_update = 1;
			if ( hdl_current_menu->path_mask != "" )
			{
				hdl_current_menu->charge_mask(hdl_current_menu->path_mask);
			}
                        hdl_current_menu->setGeometry(hdl_current_menu->menu_x,hdl_current_menu->menu_y,hdl_current_menu->menu_width,hdl_current_menu->menu_height);
                        hdl_current_menu->repaint();
		}
		else
		{
			qDebug() << "LOGICAL ERROR IN MEMORY WHEN SEARCHING MEDIA FOR PICTURE BUTTON";
		}
	}
}

void mainfrm::f_select_mask()
{
	// *** SELECTION DU MASK DU BOUTON ***
	QList<QListWidgetItem *> selectmsk = frame_th_msk_idea->selectedItems();
	QListWidgetItem *msktxt = new QListWidgetItem;
	msktxt = selectmsk.at(0);

	if ( msktxt->text() != wg_str_int_004 )
	{
                hdl_current_menu->charge_mask(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/" + msktxt->text() + ".png");
	}
	else
	{
		hdl_current_menu->path_mask = "";
		hdl_current_menu->path_over_mask = "";
		hdl_current_menu->draw_image = hdl_current_menu->original.scaled( hdl_current_menu->draw_image.width(), hdl_current_menu->draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );
		hdl_current_menu->set_opacity(hdl_current_menu->alpha_menu);
		hdl_current_menu->repaint();
	}
	frame_th_msk_idea->clearSelection();
}

void mainfrm::f_menu_zoom()
{
	// *** OUTILS SCALE ***
        if ( hdl_current_menu != 0 )
        {
            hdl_current_menu->tool = 0;
        }
	current_tool = 0;
}

void mainfrm::f_menu_rotate()
{
	// *** OUTILS ROTATE ***
        if ( hdl_current_menu != 0 )
        {
            hdl_current_menu->tool = 1;
        }
	current_tool = 1;
}

void mainfrm::f_menu_grab()
{
	// *** OUTILS GRAB ***
        if ( hdl_current_menu != 0 )
        {
            hdl_current_menu->tool = 2;
        }
	current_tool = 2;
}

void mainfrm::f_menu_shear()
{
	// *** OUTILS SHEAR ***
        if ( hdl_current_menu != 0 )
        {
            hdl_current_menu->tool = 3;
        }
	current_tool = 3;
}

void mainfrm::f_quoilire_chapitre_changed(int)
{
	if ( must_update == 1 )
	{
		hdl_current_menu->quoilirechapitre = combo_quoilire_media_chapitre->currentText();
		if ( hdl_current_menu->back_image == "EXT_VIDEO_EXT" )
		{
			f_image_menu_video();
			hdl_current_menu->repaint();
		}
	}
}

void mainfrm::f_quoilire_audio_changed(int)
{
	if ( must_update == 1 )
	{
		hdl_current_menu->audio_track = combo_select_langue->currentText();
	}
}

void mainfrm::f_quoilire_menu_changed(int indexsel)
{
	if ( must_update == 1 )
	{
		if ( indexsel > 0 )
		{
			hdl_current_menu->quoilire = "!M!" + combo_quoilire_menu->currentText();
			combo_quoilire_media->setCurrentIndex(0);
			combo_quoilire_media->setDisabled(true);
			check_anim->setDisabled(true);
		}
		else
		{
			hdl_current_menu->quoilire = "";
			combo_quoilire_media->setCurrentIndex(0);
			combo_quoilire_media->setEnabled(true);
			check_anim->setDisabled(true);
		}
	}
}

void mainfrm::f_quoilire_changed(int indexsel)
{
	// *** QUOI LIRE COMME VIDEO SUR CLIC DU BOUTON ***
	if ( must_update == 1 )
	{
		int ret;
		if ( hdl_current_menu->quoilire != combo_quoilire_media->currentText() && hdl_current_menu->back_image == "EXT_VIDEO_EXT" )
		{
			if ( hdl_current_menu->quoi_faire != "" && indexsel == 0 )
			{
				QMessageBox msgBox;
				msgBox.setText("ATTENTION PLAYLIST");
				msgBox.setInformativeText(tr("Ce bouton contient une playlist qui sera perdue si vous changez l'association a ce media. Etes vous sur de vouloir continuer ?"));
				msgBox.setStandardButtons(QMessageBox::No | QMessageBox::Yes);
				msgBox.setDefaultButton(QMessageBox::Yes);
				ret = msgBox.exec();
				switch (ret) {
					case QMessageBox::Yes:
						hdl_current_menu->quoi_faire = "";
						hdl_current_menu->back_image = "";
						hdl_current_menu->charge_image("");
						hdl_current_menu->repaint();
						break;
					case QMessageBox::No:
						must_update = 0;
						if ( combo_quoilire_media->findText( hdl_current_menu->quoilire, Qt::MatchExactly | Qt::MatchCaseSensitive) > 0 )
						{
							combo_quoilire_media->setCurrentIndex(combo_quoilire_media->findText( hdl_current_menu->quoilire, Qt::MatchExactly | Qt::MatchCaseSensitive));
						}
						else
						{
							qDebug() << "ERROR FINDING JUMPING MEDIA WHEN CONTROL PLAYLIST";
						}
						must_update = 1;
						return;
						break;
					default:
						break;
				}
			}
			//else
			//{
				//f_image_menu_video();
				//hdl_current_menu->back_image = "";
				//hdl_current_menu->charge_image("");
				//hdl_current_menu->repaint();
			//}
		}

		if ( indexsel > 0 )
		{
			combo_quoilire_menu->setCurrentIndex(0);
			combo_quoilire_menu->setDisabled(true);
                        hdl_current_menu->quoi_faire = "";
                        hdl_current_menu->quoilirechapitre = "";
			hdl_current_menu->quoilire = combo_quoilire_media->currentText();
                        check_anim->setChecked(false);
			check_anim->setEnabled(true);

                        // *** RECHERCHE DU MEDIA POUR VOIR S'IL Y A DES CHAPITRES ***
                        int wl_int_001=0;
                        int wl_int_002=0;
                        int wl_int_003=0;
                        while ( wl_int_001 < nbre_medias && wl_int_002 == 0 )
                        {
                                if ( table_hdl_medias[wl_int_001]->pathname_media == combo_quoilire_media->currentText() )
                                {
                                        wl_int_002 = 1;
                                }
                                else
                                {
                                        wl_int_001++;
                                }
                        }

                        if ( wl_int_002 == 1 && table_hdl_medias[wl_int_001]->nbre_chapitres > 0 )
                        {
                                combo_quoilire_media_chapitre->clear();
                                combo_quoilire_media_chapitre->insertItem(0,wg_str_int_001);
                                for (wl_int_003 = 0; wl_int_003 < table_hdl_medias[wl_int_001]->nbre_chapitres; ++wl_int_003)
                                {
                                        combo_quoilire_media_chapitre->insertItem(wl_int_003+1,table_hdl_medias[wl_int_001]->chapitres[wl_int_003]);
                                        combo_quoilire_media_chapitre->setItemIcon(wl_int_003+1, QIcon(table_hdl_medias[wl_int_001]->icones_chapitres[wl_int_003]));
                                }
                                combo_quoilire_media_chapitre->setEnabled(true);
                        }
                        else
                        {
                                combo_quoilire_media_chapitre->clear();
                                combo_quoilire_media_chapitre->insertItem(0,wg_str_int_001);
                                combo_quoilire_media_chapitre->setDisabled(true);
                        }

                        f_display_language();

                        if ( hdl_current_menu->back_image == "EXT_VIDEO_EXT" && indexsel > 0 )
                        {
                                f_image_menu_video();
                        }
                        else
                        {
                                if ( hdl_current_menu->back_image == "EXT_VIDEO_EXT" && indexsel == 0 )
                                {
                                        hdl_current_menu->back_image = "";
                                        hdl_current_menu->charge_image("");
                                        hdl_current_menu->repaint();
                                }
                        }

		}
		else
		{
			if ( hdl_current_menu->quoi_faire != "" )
			{
				QMessageBox msgBox;
				msgBox.setText("ATTENTION PLAYLIST");
				msgBox.setInformativeText(tr("Ce bouton contient une playlist qui sera perdue si vous changez l'association a ce media. Etes vous sur de vouloir continuer ?"));
				msgBox.setStandardButtons(QMessageBox::No | QMessageBox::Yes);
				msgBox.setDefaultButton(QMessageBox::Yes);
				ret = msgBox.exec();
				switch (ret) {
					case QMessageBox::Yes:
						hdl_current_menu->quoi_faire = "";
						hdl_current_menu->quoilire = "";
						hdl_current_menu->quoilirechapitre = "";
						combo_quoilire_menu->setCurrentIndex(0);
						combo_quoilire_menu->setEnabled(true);
						check_anim->setDisabled(true);
						check_anim->setChecked(false);
						break;
					case QMessageBox::No:
						must_update = 0;
						if ( combo_quoilire_media->findText( hdl_current_menu->quoilire, Qt::MatchExactly | Qt::MatchCaseSensitive) > 0 )
						{
							//qDebug() << hdl_current_menu->quoilire << " " << combo_quoilire_media->findText( hdl_current_menu->quoilire, Qt::MatchExactly | Qt::MatchCaseSensitive);
							combo_quoilire_media->setCurrentIndex(combo_quoilire_media->findText( hdl_current_menu->quoilire, Qt::MatchExactly | Qt::MatchCaseSensitive));
						}
						else
						{
							qDebug() << "ERROR FINDING JUMPING MEDIA WHEN CONTROL PLAYLIST";
						}
						must_update = 1;
						return;
						break;
					default:
						break;
				}
			}
			else
			{
				hdl_current_menu->quoi_faire = "";
				hdl_current_menu->quoilire = "";
				hdl_current_menu->quoilirechapitre = "";

                                combo_quoilire_media_chapitre->clear();
                                combo_select_langue->clear();

				combo_quoilire_menu->setCurrentIndex(0);
				combo_quoilire_menu->setEnabled(true);
				check_anim->setDisabled(true);
				check_anim->setChecked(false);
			}
		}

	}

        // *** ON PLACE LES CADENAS SUR LES MEDIAS ***
        f_save_widgetonmenu();

        wg_int_001=0;
        wg_int_002=0;
        wg_int_003=0;
        int wl_int_008;

        while ( wg_int_001 <= nbre_medias-1 )
        {
                wg_int_002 = 0;
                wg_int_004 = 0;
                while ( wg_int_002 <= nbre_menuth && wg_int_004 == 0 )
                {
                        wg_int_003 = 0;
                        while ( table_menus[wg_int_002][wg_int_003][0] != "$$$" && wg_int_004 == 0 )
                        {
                                if ( table_menus[wg_int_002][wg_int_003][5] == table_hdl_medias[wg_int_001]->pathname_media )
                                {
                                        wg_int_004 = 1;
                                }
                                wl_int_008 = table_menus[wg_int_002][wg_int_003][22].lastIndexOf( table_hdl_medias[wg_int_001]->pathname_media );
                                if ( wl_int_008 != -1 )
                                {
                                        wg_int_004 = 1;
                                }
                                wg_int_003++;
                        }
                        wg_int_002++;
                }
                if ( wg_int_004 == 0 )
                {
                        table_hdl_medias[wg_int_001]->is_lock = 0;
                }
                else
                {
                        table_hdl_medias[wg_int_001]->is_lock = 1;
                }
                wg_int_001++;
        }
        hdl_current_media = 0;

}

void mainfrm::f_delete_menu(menu *hdlmenu)
{
	// *** RECHERCHE DE LA POSITION DU MENU ***
	int wl_int_001=0;
	while ( table_hdl_menus[wl_int_001] != hdlmenu && wl_int_001 < nbre_menus )
	{
		wl_int_001++;
	}
	//
	if ( table_hdl_menus[wl_int_001] == hdlmenu )
	{
		int wl_old_zindex = table_hdl_menus[wl_int_001]->zindex;
		int wl_old_tindex = table_hdl_menus[wl_int_001]->taborder;
                int wl_old_islabel = table_hdl_menus[wl_int_001]->islabel;

		if ( wl_old_islabel == 0 )
		{
			nbre_menus_wo_label--;
		}

		// *** DECALAGE DES POINTEURS ***

		while ( wl_int_001 < nbre_menus-1 )
		{
			table_hdl_menus[wl_int_001] = table_hdl_menus[wl_int_001+1];
			wl_int_001++;
		}
		nbre_menus--;

		// *** ON CACHE LES INFOS DE NAVIGATION ***
                //frame_info_navi->hide();
                frame_info_navi->f_hide();

		// *** DECALAGE DES ZINDEX ET DES ORDRES DE TABULATION ***

		wl_int_001 = 0;
		while ( wl_int_001 < nbre_menus )
		{
			if ( table_hdl_menus[wl_int_001]->zindex > wl_old_zindex )
			{
				table_hdl_menus[wl_int_001]->zindex = table_hdl_menus[wl_int_001]->zindex--;
			}

			if ( table_hdl_menus[wl_int_001]->taborder > wl_old_tindex && table_hdl_menus[wl_int_001]->islabel == 0 && wl_old_islabel == 0 )
			{
				if ( table_hdl_menus[wl_int_001]->taborder > 0 )
				{
					table_hdl_menus[wl_int_001]->taborder = table_hdl_menus[wl_int_001]->taborder--;
				}
			}

			wl_int_001++;
		}

		//
		if ( nbre_menus == 0 )
		{
			actionOrdre_de_tabulation->setDisabled(true);
		}

		must_update = 0;
		combo_quoilire_media->setCurrentIndex(0);
		combo_quoilire_media_chapitre->setCurrentIndex(0);
		combo_quoilire_menu->setCurrentIndex(0);
		combo_quoilire_media->setDisabled(true);
		bt_bt_img->setDisabled(true);
		dial_alpha_menu->setDisabled(true);
		bttxt->setPlainText("");
		bttxt->setDisabled(true);
		frame_th_msk_idea->setDisabled(true);
		combo_quoilire_media->setDisabled(true);
		check_anim->setDisabled(true);
		combo_quoilire_media_chapitre->setDisabled(true);
		combo_select_langue->setDisabled(true);
		combo_quoilire_menu->setDisabled(true);
		must_update = 1;
		hdl_current_menu = 0;
		actionCopier_le_bouton->setDisabled(true);

                // *** ON PLACE LES CADENAS SUR LES MEDIAS ***
                f_save_widgetonmenu();

                wg_int_001=0;
                wg_int_002=0;
                wg_int_003=0;
                int wl_int_008;

                while ( wg_int_001 <= nbre_medias-1 )
                {
                        wg_int_002 = 0;
                        wg_int_004 = 0;
                        while ( wg_int_002 <= nbre_menuth && wg_int_004 == 0 )
                        {
                                wg_int_003 = 0;
                                while ( table_menus[wg_int_002][wg_int_003][0] != "$$$" && wg_int_004 == 0 )
                                {
                                        if ( table_menus[wg_int_002][wg_int_003][5] == table_hdl_medias[wg_int_001]->pathname_media )
                                        {
                                                wg_int_004 = 1;
                                        }
                                        wl_int_008 = table_menus[wg_int_002][wg_int_003][22].lastIndexOf( table_hdl_medias[wg_int_001]->pathname_media );
                                        if ( wl_int_008 != -1 )
                                        {
                                                wg_int_004 = 1;
                                        }
                                        wg_int_003++;
                                }
                                wg_int_002++;
                        }
                        if ( wg_int_004 == 0 )
                        {
                                table_hdl_medias[wg_int_001]->is_lock = 0;
                        }
                        else
                        {
                                table_hdl_medias[wg_int_001]->is_lock = 1;
                        }
                        table_hdl_medias[wg_int_001]->repaint();
                        wg_int_001++;
                }

                f_update_thumb_menu();
	}
	else
	{
		qDebug() << "LOGICAL ERROR IN MEMORY WHEN REMOVING A MENU";
	}
}

void mainfrm::f_release_menu(menu*)
{
	f_update_thumb_menu();
}

// ************************************
// *** DEFINITION DE FONCTIONS CLES ***
// ************************************

void mainfrm::f_run_ani()
{
    thread_ani->run();
}

void mainfrm::f_run_bld()
{
    thread_blend->run();
}

void mainfrm::f_lockbar()
{
    smenuBar->setDisabled(true);
}

/*void mainfrm::f_refreshit()
{
    this->repaint();
}*/

void mainfrm::displayCoord( bool state )
{
    if ( state )
    {
        if ( frame_smile->isVisible() == true )
        {
            f_switch_coo_diapo();
        }
        else
        {
            frame_infos->setGeometry((this->width() - frame_infos->width())/2,((this->height()-smenuBar->height()) - frame_infos->height())/2, frame_infos->width(), frame_infos->height());
            frame_infos->show();
            frame_infos->raise();
        }
    }
    else
    {
        frame_infos->hide();
    }
}

void mainfrm::f_showhide_coor()
{
    if ( frame_smile->isVisible() == true )
    {
        f_switch_coo_diapo();
    }
    else
    {
        bool newState = actionAfficher_cacher_les_coordonn_es->isChecked();  //!  frame_infos->isVisible();
        userSettings::setDisplayOption( userSettings::DISPLAY_COORD, newState );
        displayCoord( newState );
    }
}

void mainfrm::displayZone( bool state )
{
    if ( state )
    {
        safety_zone->show();
    }
    else
    {
        safety_zone->hide();
    }
}

void mainfrm::f_view_magnetic()
{
    if ( magnetic_grid->isVisible() == false )
    {
        magnetic_grid->show();
    }
    else
    {
        magnetic_grid->hide();
    }
}

void mainfrm::f_showhide_safe()
{
    bool newState = actionAfficher_cacher_les_zones_de_s_curit->isChecked(); // ! safety_zone->isVisible();
    userSettings::setDisplayOption( userSettings::DISPLAY_ZONE, newState );
    displayZone( newState );
}

void mainfrm::f_generation_scale()
{
	QPixmap wl_pix_001(dvdxsize,dvdysize);
	QImage wl_img_001(current_menu_background);
	QImage wl_img_002;
	// *** GENERATION DES FORMATS DE SCALE ***
	if ( scale_current_menu_background == 1 )
	{
		wl_pix_001.fill(QColor(0,0,0));
		if ( wl_img_001.width() > wl_img_001.height() )
		{
			wl_img_002 = wl_img_001.scaledToWidth ( dvdxsize, Qt::FastTransformation );
		}
		else
		{
			wl_img_002 = wl_img_001.scaledToHeight ( dvdysize, Qt::FastTransformation );
		}
		QPainter p;
		p.begin(&wl_pix_001);
		p.drawImage((wl_pix_001.width() - wl_img_002.width()) / 2, (wl_pix_001.height() - wl_img_002.height()) / 2, wl_img_002, 0, 0, -1, -1 );
		p.end();

		background_menu->setPixmap(wl_pix_001);
	}
	else
	{
		wl_pix_001.fill(QColor(0,0,0));
		if ( wl_img_001.width() > wl_img_001.height() )
		{
			wl_img_002 = wl_img_001.scaledToHeight ( dvdysize, Qt::FastTransformation );
		}
		else
		{
			wl_img_002 = wl_img_001.scaledToWidth ( dvdxsize, Qt::FastTransformation );
		}
		QPainter p;
		p.begin(&wl_pix_001);
		p.drawImage((wl_pix_001.width() - wl_img_002.width()) / 2, (wl_pix_001.height() - wl_img_002.height()) / 2, wl_img_002, 0, 0, -1, -1 );
		p.end();

		background_menu->setPixmap(wl_pix_001);
	}
}

void mainfrm::f_affiche_info_pos(menu *hdlm)
{
	label_position->setText(tr("Position : ") + QString::number(hdlm->menu_x) + ";" + QString::number(hdlm->menu_y));
	label_size->setText(tr("Taille : ") + QString::number(hdlm->menu_width) + "x" + QString::number(hdlm->menu_height));
	label_rotation->setText(tr("Rotation : ") + QString::number(hdlm->rotation));
}

void mainfrm::f_ajoute_menu_new(int x, int y, int w, int h)
{
	if ( nbre_menus < 19 )
	{
		// *** NOUVEAU BOUTON MENU ***
		menu *newmenu = new menu(screen_designer);
		newmenu->charge_image(":/Interface/Interface/default_bt.png");
                newmenu->setGeometry(x,y,w,h);
                newmenu->show();
		newmenu->menu_x = x;
		newmenu->menu_y = y;
		newmenu->menu_width = w;
		newmenu->menu_height = h;
		newmenu->img_x_size = w;
		newmenu->img_y_size = h;
		newmenu->iscontours = draw_contours;
		newmenu->rotation = 0;
		newmenu->teta0 = 0;
		connect(newmenu, SIGNAL(delete_menu(menu*) ),this, SLOT(f_delete_menu(menu*)));
		connect(newmenu, SIGNAL(customize_menu(menu*) ),this, SLOT(f_customize_menu(menu*)));
		connect(newmenu, SIGNAL(call_charge_image() ),this, SLOT(f_image_menu()));
		connect(newmenu, SIGNAL(call_charge_image_video() ),this, SLOT(f_image_menu_video()));
		connect(newmenu, SIGNAL(change_position(menu*) ),this, SLOT(f_affiche_info_pos(menu*)));
		connect(newmenu, SIGNAL(release_menu(menu*) ),this, SLOT(f_release_menu(menu*)));
		connect(newmenu, SIGNAL(select_menu(menu*) ),this, SLOT(f_select_menu(menu*)));
		connect(newmenu, SIGNAL(affiche_navi(menu*) ),this, SLOT(f_menu_navi_on(menu*)));
		connect(newmenu, SIGNAL(cache_navi(menu*) ),this, SLOT(f_menu_navi_off(menu*)));
		connect(newmenu, SIGNAL(go_lower(menu*) ),this, SLOT(f_menu_lower(menu*)));
		connect(newmenu, SIGNAL(go_front(menu*) ),this, SLOT(f_menu_front(menu*)));
		connect(newmenu, SIGNAL(copy_menu(menu*) ),this, SLOT(f_copy_menu(menu*)));
		connect(newmenu, SIGNAL(goto_menu(menu*) ),this, SLOT(f_goto_menu(menu*)));
                //connect(newmenu, SIGNAL(has_scale(menu*) ),this, SLOT(f_redraw_menu(menu*)));
		connect(newmenu, SIGNAL(halign(menu*) ),this, SLOT(f_halign_menu(menu*)));
		connect(newmenu, SIGNAL(valign(menu*) ),this, SLOT(f_valign_menu(menu*)));
		connect(newmenu, SIGNAL(talign(menu*) ),this, SLOT(f_talign_menu(menu*)));
		connect(newmenu, SIGNAL(quoifaire(menu*) ),this, SLOT(f_select_quoifaire_after(menu*)));
		connect(newmenu, SIGNAL(editoverlay(menu*) ),this, SLOT(f_edit_overlay(menu*)));
		connect(newmenu, SIGNAL(tobt(menu*) ),this, SLOT(f_tobt(menu*)));
		connect(newmenu, SIGNAL(adjust(menu*) ),this, SLOT(f_adjust_th(menu*)));
                connect(newmenu, SIGNAL(drop_to_a_menu(menu*)),this, SLOT(f_drop_to_a_menu(menu*)));
                connect(newmenu, SIGNAL(rsc_txt(int)),this, SLOT(f_rsc_txt(int)));

		table_hdl_menus[nbre_menus] = newmenu;
		newmenu->zindex = nbre_menus;
		newmenu->taborder = 0;
		nbre_menus++;

		hdl_current_menu = newmenu;
		actionCopier_le_bouton->setEnabled(true);

		f_select_menu(hdl_current_menu);
		//dial_angle_shadow->setValue(hdlmenu->shadow_angle);
		//dial_opacity_shadow->setValue(hdlmenu->shadow_opacity);

		actionOrdre_de_tabulation->setEnabled(true);
	}
	else
	{
		hdl_current_menu = 0;
	}
}

void mainfrm::f_create_menu_movie()
{
	// *** CREATION D'UN BOUTON SUR LE MENU LORS DU RECHARGEMENT DU MENU ***
	menu *newmenu = new menu(screen_designer);
	connect(newmenu, SIGNAL(delete_menu(menu*) ),this, SLOT(f_delete_menu(menu*)));
	connect(newmenu, SIGNAL(customize_menu(menu*) ),this, SLOT(f_customize_menu(menu*)));
	connect(newmenu, SIGNAL(call_charge_image() ),this, SLOT(f_image_menu()));
	connect(newmenu, SIGNAL(call_charge_image_video() ),this, SLOT(f_image_menu_video()));
	connect(newmenu, SIGNAL(select_menu(menu*) ),this, SLOT(f_select_menu(menu*)));
	connect(newmenu, SIGNAL(change_position(menu*) ),this, SLOT(f_affiche_info_pos(menu*)));
	connect(newmenu, SIGNAL(release_menu(menu*) ),this, SLOT(f_release_menu(menu*)));
	connect(newmenu, SIGNAL(affiche_navi(menu*) ),this, SLOT(f_menu_navi_on(menu*)));
	connect(newmenu, SIGNAL(cache_navi(menu*) ),this, SLOT(f_menu_navi_off(menu*)));
	connect(newmenu, SIGNAL(go_lower(menu*) ),this, SLOT(f_menu_lower(menu*)));
	connect(newmenu, SIGNAL(go_front(menu*) ),this, SLOT(f_menu_front(menu*)));
	connect(newmenu, SIGNAL(copy_menu(menu*) ),this, SLOT(f_copy_menu(menu*)));
	connect(newmenu, SIGNAL(goto_menu(menu*) ),this, SLOT(f_goto_menu(menu*)));
        //connect(newmenu, SIGNAL(has_scale(menu*) ),this, SLOT(f_redraw_menu(menu*)));
	connect(newmenu, SIGNAL(halign(menu*) ),this, SLOT(f_halign_menu(menu*)));
	connect(newmenu, SIGNAL(valign(menu*) ),this, SLOT(f_valign_menu(menu*)));
	connect(newmenu, SIGNAL(talign(menu*) ),this, SLOT(f_talign_menu(menu*)));
	connect(newmenu, SIGNAL(quoifaire(menu*) ),this, SLOT(f_select_quoifaire_after(menu*)));
	connect(newmenu, SIGNAL(editoverlay(menu*) ),this, SLOT(f_edit_overlay(menu*)));
	connect(newmenu, SIGNAL(tobt(menu*) ),this, SLOT(f_tobt(menu*)));
	connect(newmenu, SIGNAL(adjust(menu*) ),this, SLOT(f_adjust_th(menu*)));
        connect(newmenu, SIGNAL(drop_to_a_menu(menu*)),this, SLOT(f_drop_to_a_menu(menu*)));
        connect(newmenu, SIGNAL(rsc_txt(int)),this, SLOT(f_rsc_txt(int)));

	table_hdl_menus[nbre_menus] = newmenu;
	hdl_current_menu = newmenu;

	actionCopier_le_bouton->setEnabled(true);

	//newmenu->setGeometry(table_menus[wg_int_001][wg_int_002][0].toInt(),table_menus[wg_int_001][wg_int_002][1].toInt(),table_menus[wg_int_001][wg_int_002][2].toInt(),table_menus[wg_int_001][wg_int_002][3].toInt());
	
	newmenu->menu_x = table_menus[wg_int_001][wg_int_002][0].toInt();
	newmenu->menu_y = table_menus[wg_int_001][wg_int_002][1].toInt();
	newmenu->back_image = table_menus[wg_int_001][wg_int_002][4];
	newmenu->is_select = 0;
	newmenu->iscontours = draw_contours;
	newmenu->quoilire = table_menus[wg_int_001][wg_int_002][5];
	newmenu->path_mask = table_menus[wg_int_001][wg_int_002][6];
	newmenu->menu_width = table_menus[wg_int_001][wg_int_002][2].toInt();
	newmenu->menu_height = table_menus[wg_int_001][wg_int_002][3].toInt();
        newmenu->rotation = table_menus[wg_int_001][wg_int_002][7].toFloat();

	newmenu->img_x_size = table_menus[wg_int_001][wg_int_002][8].toInt();
	newmenu->quoilirechapitre = table_menus[wg_int_001][wg_int_002][9];
	newmenu->img_y_size = table_menus[wg_int_001][wg_int_002][10].toInt();
	newmenu->islabel = table_menus[wg_int_001][wg_int_002][11].toInt();
	newmenu->shadow = table_menus[wg_int_001][wg_int_002][12].toInt();
	newmenu->color_mask_over = table_menus[wg_int_001][wg_int_002][13];
	newmenu->anim_thumb = table_menus[wg_int_001][wg_int_002][14].toInt();
	newmenu->zindex = table_menus[wg_int_001][wg_int_002][15].toInt();
	newmenu->taborder = table_menus[wg_int_001][wg_int_002][16].toInt();
	newmenu->alpha_menu = table_menus[wg_int_001][wg_int_002][17].toInt();
	newmenu->audio_track = table_menus[wg_int_001][wg_int_002][19];
	newmenu->shear_value_x = table_menus[wg_int_001][wg_int_002][20].toInt();
	newmenu->shear_value_y = table_menus[wg_int_001][wg_int_002][21].toInt();
	newmenu->quoi_faire = table_menus[wg_int_001][wg_int_002][22];
	newmenu->quoi_overlay = table_menus[wg_int_001][wg_int_002][23];

	if ( table_menus[wg_int_001][wg_int_002][24].mid(0,1) == "1" )
	{
		newmenu->isbold = true;
	}
	else
	{
		newmenu->isbold = false;
	}

	if ( table_menus[wg_int_001][wg_int_002][24].mid(1,1) == "1" )
	{
		newmenu->isitalic = true;
	}
	else
	{
		newmenu->isitalic = false;
	}

	if ( table_menus[wg_int_001][wg_int_002][24].mid(2,1) == "1" )
	{
		newmenu->isunderline = true;
	}
	else
	{
		newmenu->isunderline = false;
	}

	newmenu->isalign = table_menus[wg_int_001][wg_int_002][24].mid(3,1).toInt();
	newmenu->pos_thumb = table_menus[wg_int_001][wg_int_002][25];
        newmenu->font_size = table_menus[wg_int_001][wg_int_002][26].toInt();

	if ( table_menus[wg_int_001][wg_int_002][18].mid(0,1) == "$" || table_menus[wg_int_001][wg_int_002][18].length() < 1 )
	{
		newmenu->shadow_angle = 0;
		newmenu->shadow_opacity = 100;
		newmenu->shadow_color = "";
	}
	else
	{
		QString wl_string_001 = table_menus[wg_int_001][wg_int_002][18];
		QString wl_string_002 = "";
		int wl_int_001 = 0;
		int wl_int_002 = 0;

		while ( wl_int_002 < 3 )
		{
			if ( wl_string_001.mid(wl_int_001,1) == "$" )
			{
				if ( wl_int_002 == 0 )
				{
					newmenu->shadow_color = wl_string_002;
					wl_string_002 = "";
				}
				if ( wl_int_002 == 1 )
				{
					newmenu->shadow_opacity = wl_string_002.toInt();
					wl_string_002 = "";
				}
				if ( wl_int_002 == 2 )
				{
					newmenu->shadow_angle = wl_string_002.toInt();
					wl_string_002 = "";
				}
				wl_int_002++;
			}
			else
			{
				wl_string_002 = wl_string_002 + wl_string_001.mid(wl_int_001,1);
			}
			wl_int_001++;
		}
	}

	if ( newmenu->back_image == "" )
	{
		newmenu->charge_image("");
	}
	else
	{
		if ( newmenu->back_image == "EXT_VIDEO_EXT" )
		{
			wg_int_003=0;
			while ( wg_int_003 < nbre_medias && table_hdl_medias[wg_int_003]->pathname_media != newmenu->quoilire )
			{
				wg_int_003++;
			}
                        //qDebug() << wg_int_003 << " " << nbre_medias << " " << table_hdl_medias[wg_int_003]->pathname_media << " " << newmenu->quoilire << " " << newmenu->quoilirechapitre << " " << wg_str_int_001;
                        //qDebug() << table_hdl_medias[wg_int_003]->pathname_media << " " << newmenu->quoilire << " " << newmenu->quoilirechapitre << " " << wg_str_int_001;
			if ( table_hdl_medias[wg_int_003]->pathname_media == newmenu->quoilire && newmenu->quoilirechapitre == wg_str_int_001 )
			{
				newmenu->draw_image = table_hdl_medias[wg_int_003]->miniature.scaledToWidth(newmenu->img_x_size,Qt::FastTransformation);
				newmenu->original = table_hdl_medias[wg_int_003]->miniature;
				newmenu->back_image="EXT_VIDEO_EXT";
			}
			else
			{
				if ( newmenu->quoilirechapitre != "" )
				{
					wg_int_004=0;
					while ( wg_int_004 < table_hdl_medias[wg_int_003]->nbre_chapitres && table_hdl_medias[wg_int_003]->chapitres[wg_int_004] != newmenu->quoilirechapitre )
					{
						wg_int_004++;
					}

					if ( table_hdl_medias[wg_int_003]->chapitres[wg_int_004] == newmenu->quoilirechapitre )
					{
						// *** MINIATURE DU CHAPITRE ***
						newmenu->draw_image = table_hdl_medias[wg_int_003]->miniature.scaledToWidth(newmenu->img_x_size,Qt::FastTransformation);
						newmenu->draw_image = table_hdl_medias[wg_int_003]->icones_chapitres[wg_int_004].pixmap( newmenu->img_x_size, newmenu->img_x_size/(newmenu->draw_image.width()/newmenu->draw_image.height()), QIcon::Normal, QIcon::On );
						newmenu->original = table_hdl_medias[wg_int_003]->icones_chapitres[wg_int_004].pixmap( 500, 500 / (newmenu->draw_image.width()/newmenu->draw_image.height()), QIcon::Normal, QIcon::On );

						newmenu->reload_charge_image("EXT_VIDEO_EXT");
						newmenu->back_image="EXT_VIDEO_EXT";
					}

				}
				else
				{
					qDebug() << "LOGICAL ERROR IN MEMORY WHEN SEARCHING MEDIA CHAPTER FOR PICTURE BUTTON IN RELOADING MENU";
				}
			}
			newmenu->set_opacity(newmenu->alpha_menu);
		}
		else
		{
			if ( newmenu->back_image.mid(0,5) == "$TXT$" )
			{
				// *** EXTRACTION POUR LE CAS D'UN BOUTON TEXTE ***
				wg_string_001 = newmenu->back_image;
				wg_string_002 = "";
				must_update = 0;

				wg_int_006 = 5;
				wg_int_007 = 0;
				while ( wg_string_001.mid(wg_int_006,1) != "!" && wg_int_007 < 4 )
				{
					if ( wg_string_001.mid(wg_int_006,1) == "^" )
					{
						if ( wg_int_007 == 0 )
						{
							pntwheel3->red = wg_string_002.toInt();
							wg_string_002 = "";
						}
						if ( wg_int_007 == 1 )
						{
							pntwheel3->green = wg_string_002.toInt();
							wg_string_002 = "";
						}
						if ( wg_int_007 == 2 )
						{
							pntwheel3->blue = wg_string_002.toInt();
							wg_string_002 = "";
							pntwheel3->setColor(pntwheel3->red,pntwheel3->green,pntwheel3->blue);
						}
						if ( wg_int_007 == 3 )
						{
							font_txt->setCurrentFont(QFont(wg_string_002));
						}
						wg_int_007++;
					}
					else
					{
						wg_string_002 = wg_string_002 + wg_string_001.mid(wg_int_006,1);
					}
					wg_int_006++;
				}

				//
				wg_string_003 = newmenu->shadow_color;
				wg_string_002 = "";
				wg_int_008 = 0;
				wg_int_007 = 0;
				if ( wg_string_003.length() > 0 )
				{
					while ( wg_int_007 < 3 )
					{
						if ( wg_string_003.mid(wg_int_008,1) == "^" )
						{
							if ( wg_int_007 == 0 )
							{
								pntwheel4->red = wg_string_002.toInt();
								wg_string_002 = "";
							}
							if ( wg_int_007 == 1 )
							{
								pntwheel4->green = wg_string_002.toInt();
								wg_string_002 = "";
							}
							if ( wg_int_007 == 2 )
							{
								pntwheel4->blue = wg_string_002.toInt();
								wg_string_002 = "";
								pntwheel4->setColor(pntwheel4->red,pntwheel4->green,pntwheel4->blue);
							}
							wg_int_007++;
						}
						else
						{
							wg_string_002 = wg_string_002 + wg_string_003.mid(wg_int_008,1);
						}
						wg_int_008++;
					}
				}
				//

				bttxt->setPlainText(wg_string_001.mid(wg_int_006+1,wg_string_001.length() - (wg_int_006+1)));
                                spin_font_size->setValue(newmenu->font_size);
				must_update = 1;

				QPixmap wl_pix_001(newmenu->img_x_size,newmenu->img_y_size);
				newmenu->draw_image = wl_pix_001; //.scaled(newmenu->img_x_size,newmenu->img_y_size);
				is_new_create = 1;
                                newmenu->setGeometry(newmenu->menu_x,newmenu->menu_y,newmenu->menu_width,newmenu->menu_height);
                                f_put_txt_on_bt();
				is_new_create = 0;

				must_update = 0;
				bttxt->setPlainText("");
				must_update = 1;
			}
			else
			{
				newmenu->reload_charge_image(newmenu->back_image);
			}
		}
	}

	if ( newmenu->path_mask != "" )
	{
		newmenu->charge_mask(newmenu->path_mask);
	}

        if ( newmenu->back_image.mid(0,5) != "$TXT$" )
        {
            int sx = newmenu->shear_value_x;
            int sy = newmenu->shear_value_y;

            if ( newmenu->shear_value_x < 0 )
            {
                    sx = newmenu->shear_value_x * -1;
            }

            if ( newmenu->shear_value_y < 0 )
            {
                    sy = newmenu->shear_value_y * -1;
            }

            double angleradian = (M_PI*newmenu->rotation)/180;

            if ( newmenu->rotation < 90)
            {
                    newmenu->menu_width = ((newmenu->img_x_size+sy) * cos(angleradian))+((newmenu->img_y_size+sx) * sin(angleradian));
                    newmenu->menu_height = ((newmenu->img_y_size+sx) * cos(angleradian))+((newmenu->img_x_size+sy) * sin(angleradian));
            }
            else
            {
                    float mcos = cos(angleradian);
                    float msin = sin(angleradian);

                    if ( mcos < 0 )
                    {
                            mcos=mcos*-1;
                    }
                    if ( msin < 0 )
                    {
                            msin=msin*-1;
                    }
                    newmenu->menu_width = ((newmenu->img_x_size+sy) * mcos)+((newmenu->img_y_size+sx) * msin);
                    newmenu->menu_height = ((newmenu->img_x_size+sy) * msin)+((newmenu->img_y_size+sx) * mcos);
            }

            newmenu->setGeometry(newmenu->menu_x,newmenu->menu_y,newmenu->menu_width,newmenu->menu_height);
        }

	nbre_menus++;
	if ( newmenu->islabel == 0 )
	{
		nbre_menus_wo_label++;
	}
	actionOrdre_de_tabulation->setEnabled(true);
	newmenu->show();
}

void mainfrm::f_drop_to_a_menu(menu* hdlm)
{
    if ( hdlm->wg_str_001.mid(0,4) == "$MED" )
    {
        hdlm->quoilire = hdlm->wg_str_001.remove(0, 4);
        hdlm->islabel = 0;
        hdlm->audio_track = "";
        hdlm->quoilirechapitre = wg_str_int_001;
        int wl_int_001 = 0;
        while ( wl_int_001 < nbre_menus )
        {
                if ( h_regle->isVisible() == true )
                {
                        table_hdl_menus[wl_int_001]->is_ruler = 1;
                }
                else
                {
                        table_hdl_menus[wl_int_001]->is_ruler = 0;
                }

                if ( table_hdl_menus[wl_int_001] == hdlm )
                {
                        table_hdl_menus[wl_int_001]->is_select = 1;
                }
                else
                {
                        table_hdl_menus[wl_int_001]->is_select = 0;
                }
                table_hdl_menus[wl_int_001]->repaint();
                wl_int_001++;
        }
        must_update = 0;
        if ( combo_quoilire_media->findText( hdlm->quoilire, Qt::MatchExactly | Qt::MatchCaseSensitive) < 0 )
        {
            qDebug() << "ERROR FINDING MEDIA ON DRAGGING A MEDIA ON A BUTTON";
        }
        else
        {
            combo_quoilire_media->setCurrentIndex(combo_quoilire_media->findText( hdlm->quoilire, Qt::MatchExactly | Qt::MatchCaseSensitive));
        }

        // *** CHARGEMENT DES CHAPITRES S'ILS EXISTENT ***
        wg_int_001=0;
        wg_int_002=0;
        while ( wg_int_001 < nbre_medias && wg_int_002 == 0 )
        {
                if ( table_hdl_medias[wg_int_001]->pathname_media == combo_quoilire_media->currentText() )
                {
                        wg_int_002 = 1;
                }
                else
                {
                        wg_int_001++;
                }
        }
        if ( wg_int_002 == 1 && table_hdl_medias[wg_int_001]->nbre_chapitres > 0 )
        {
                combo_quoilire_media_chapitre->clear();
                combo_quoilire_media_chapitre->insertItem(0,wg_str_int_001);
                for (wg_int_003 = 0; wg_int_003 < table_hdl_medias[wg_int_001]->nbre_chapitres; ++wg_int_003)
                {
                        combo_quoilire_media_chapitre->insertItem(wg_int_003+1,table_hdl_medias[wg_int_001]->chapitres[wg_int_003]);
                        combo_quoilire_media_chapitre->setItemIcon(wg_int_003+1, QIcon(table_hdl_medias[wg_int_001]->icones_chapitres[wg_int_003]));
                }
                combo_quoilire_media_chapitre->setEnabled(true);
        }
        else
        {
                combo_quoilire_media_chapitre->clear();
                combo_quoilire_media_chapitre->insertItem(0,wg_str_int_001);
                combo_quoilire_media_chapitre->setDisabled(true);
        }
        combo_quoilire_media_chapitre->setCurrentIndex(combo_quoilire_media_chapitre->findText( hdlm->quoilirechapitre, Qt::MatchExactly | Qt::MatchCaseSensitive));

        if ( combo_quoilire_media->currentIndex() > 0 )
        {
                combo_quoilire_menu->setDisabled(true);
                combo_quoilire_menu->setCurrentIndex(0);
                combo_quoilire_media->setEnabled(true);
                combo_select_langue->setEnabled(true);
                check_anim->setEnabled(true);
        }
        else
        {
                combo_quoilire_media->setEnabled(true);
                combo_quoilire_media_chapitre->setDisabled(true);
                combo_quoilire_media_chapitre->setCurrentIndex(0);
                combo_select_langue->setEnabled(true);
                combo_quoilire_menu->setEnabled(true);
                check_anim->setDisabled(true);
        }

        f_display_language();
        if ( hdlm->audio_track != "" )
        {
                if ( combo_select_langue->findText( hdlm->audio_track, Qt::MatchExactly | Qt::MatchCaseSensitive) >= 0 )
                {
                        combo_select_langue->setCurrentIndex(combo_select_langue->findText( hdlm->audio_track, Qt::MatchExactly | Qt::MatchCaseSensitive));
                }
                else
                {
                        combo_select_langue->setCurrentIndex(-1);
                }
        }
        else
        {
                combo_select_langue->setCurrentIndex(-1);
        }

        must_update = 1;
        //f_select_menu(hdl_current_menu);

        hdlm->wg_str_001 = "";

        if ( hdlm->back_image == "EXT_VIDEO_EXT" )
        {
                hdl_current_menu = hdlm;
                f_image_menu_video();
                hdlm->repaint();
        }

        // *** ON PLACE LES CADENAS SUR LES MEDIAS ***
        f_save_widgetonmenu();

        wg_int_001=0;
        wg_int_002=0;
        wg_int_003=0;
        int wl_int_008;

        while ( wg_int_001 <= nbre_medias-1 )
        {
                wg_int_002 = 0;
                wg_int_004 = 0;
                while ( wg_int_002 <= nbre_menuth && wg_int_004 == 0 )
                {
                        wg_int_003 = 0;
                        while ( table_menus[wg_int_002][wg_int_003][0] != "$$$" && wg_int_004 == 0 )
                        {
                                if ( table_menus[wg_int_002][wg_int_003][5] == table_hdl_medias[wg_int_001]->pathname_media )
                                {
                                        wg_int_004 = 1;
                                }
                                wl_int_008 = table_menus[wg_int_002][wg_int_003][22].lastIndexOf( table_hdl_medias[wg_int_001]->pathname_media );
                                if ( wl_int_008 != -1 )
                                {
                                        wg_int_004 = 1;
                                }
                                wg_int_003++;
                        }
                        wg_int_002++;
                }
                if ( wg_int_004 == 0 )
                {
                        table_hdl_medias[wg_int_001]->is_lock = 0;
                }
                else
                {
                        table_hdl_medias[wg_int_001]->is_lock = 1;
                }
                table_hdl_medias[wg_int_001]->repaint();
                wg_int_001++;
        }
    }
}

void mainfrm::f_menu_opacity(int value)
{
	if ( must_update == 1 )
	{
		if ( hdl_current_menu->path_mask != "" )
		{
			if ( hdl_current_menu->isovermask == 1 )
			{
				hdl_current_menu->set_opacity(value);
				hdl_current_menu->mask = hdl_current_menu->original_mask.scaled( hdl_current_menu->draw_image.width(), hdl_current_menu->draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );
				hdl_current_menu->draw_image.setMask(hdl_current_menu->mask.mask());
				QPainter p;
				p.begin(&hdl_current_menu->draw_image);
				QPixmap wl_pix_002 = hdl_current_menu->over_mask.scaled( hdl_current_menu->draw_image.width(), hdl_current_menu->draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );
				p.drawPixmap ( QRect(0,0,-1,-1),wl_pix_002 );
				p.end();
			}
			else
			{
				// *** MASK SPECIAL SANS OVERMASK ***
				hdl_current_menu->set_opacity(value);
				QImage wl_image = hdl_current_menu->draw_image.toImage();
				wl_image = wl_image.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );

				hdl_current_menu->mask = hdl_current_menu->original_mask.scaled( hdl_current_menu->draw_image.width(), hdl_current_menu->draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );
				QImage wl_image_2 = hdl_current_menu->mask.toImage();
				wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );

				QPainter g;

				QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

				g.begin(&wl_image);
				g.setCompositionMode ( mode );
				g.drawImage(QRect(0,0,-1,-1),wl_image_2);
				g.end();
				hdl_current_menu->draw_image = QPixmap::fromImage( wl_image, Qt::AutoColor );
			}
		}
		else
		{
			hdl_current_menu->set_opacity(value);
		}
		hdl_current_menu->repaint();
	}
}

// *********************************
// *** ALIGNEMENT SUR LES REGLES ***
// *********************************

void mainfrm::f_halign_menu(menu* hdlm)
{
        if ( h_regle->geometry().y()-frame_support_editor->geometry().y()-hdlm->height() > 0 && h_regle->geometry().y()-frame_support_editor->geometry().y()-hdlm->height() < dvdysize-hdlm->height() )
	{
                hdlm->setGeometry(hdlm->geometry().x(),h_regle->geometry().y()-frame_support_editor->geometry().y()-hdlm->height(),hdlm->width(),hdlm->height());
                hdlm->menu_y = h_regle->geometry().y()-frame_support_editor->geometry().y()-hdlm->height();
	}
	else
	{
                if ( h_regle->geometry().y()-frame_support_editor->geometry().y()-hdlm->height() < 0 )
		{
			hdlm->setGeometry(hdlm->geometry().x(),0,hdlm->width(),hdlm->height());
			hdlm->menu_y = 0;
		}
		else
		{
			hdlm->setGeometry(hdlm->geometry().x(),dvdysize-hdlm->height(),hdlm->width(),hdlm->height());
			hdlm->menu_y = dvdysize-hdlm->height();
		}
	}
}

void mainfrm::f_valign_menu(menu* hdlm)
{
	if ( (v_regle->geometry().x()-frame_support_editor->geometry().x())+v_regle->width() > 0 && (v_regle->geometry().x()-frame_support_editor->geometry().x())+v_regle->width() < dvdxsize )
	{
		hdlm->setGeometry((v_regle->geometry().x()-frame_support_editor->geometry().x())+v_regle->width(),hdlm->geometry().y(),hdlm->width(),hdlm->height());
		hdlm->menu_x = (v_regle->geometry().x()-frame_support_editor->geometry().x())+v_regle->width();
	}
	else
	{
		if ( (v_regle->geometry().x()-frame_support_editor->geometry().x())+v_regle->width() < 0 )
		{
			hdlm->setGeometry(0,hdlm->geometry().y(),hdlm->width(),hdlm->height());
			hdlm->menu_x = 0;
		}
		else
		{
			hdlm->setGeometry(dvdxsize-hdlm->width(),hdlm->geometry().y(),hdlm->width(),hdlm->height());
			hdlm->menu_x = dvdxsize-hdlm->width();
		}
	}
}

void mainfrm::f_talign_menu(menu* hdlm)
{
	f_halign_menu(hdlm);
	f_valign_menu(hdlm);
}

void mainfrm::f_tobt(menu* hdlm)
{
        nbre_menus_wo_label++;
        hdlm->taborder = nbre_menus_wo_label;
	hdlm->islabel = 0;
	f_select_menu(hdlm);
}

void mainfrm::f_adjust_th(menu* hdlm)
{
        hdl_current_menu = hdlm;
        frame_adjust_thumb->setGeometry((this->width()-frame_adjust_thumb->width())/2,(this->height()-frame_adjust_thumb->height())/2,frame_adjust_thumb->width(),frame_adjust_thumb->height());
        frame_slider_pos_thumb->hide();
        //frame_slider_pos_thumb->setGeometry(frame_support_slider_thumb->geometry().x()+(float)((float)((float)0*(float)slider_player_thumb->width())/(float)slider_player_thumb->maximum())+10,frame_support_slider_thumb->geometry().y()+30,60,31);

        thread_ani->hdlmsk = mask_interface;
        thread_ani->sens = 1;
        thread_ani->isrender = 0;
        mask_interface->show();
        mask_interface->raise();

        thread_ani->run();
        thread_ani->wait();

        frame_adjust_thumb->show();
        frame_adjust_thumb->raise();

        player_thu_open_video(hdlm->quoilire);
}

// *******************************
// *** CUSTOMIZATION DES MASKS ***
// *******************************

void mainfrm::f_customize_menu(menu* hdlm)
{
	QPixmap wl_pix_001(preview_customize->width(),preview_customize->height());
	//wg_pix_002.load(":/Interface/Interface/fd_transparent.png");
	QPixmap wlpixmap = QPixmap::grabWidget(background_menu);
	wg_pix_002 = wlpixmap.copy(hdl_current_menu->menu_x,hdl_current_menu->menu_y,hdl_current_menu->menu_width,hdl_current_menu->menu_height);
	wg_pix_002 = wg_pix_002.scaled(preview_customize->width(),preview_customize->height());
	wg_pix_001.load(hdlm->path_over_mask);

	wg_pix_003 = wg_pix_001.scaledToHeight(preview_customize->height(), Qt::FastTransformation);

	QPainter p;
	p.begin(&wl_pix_001);
	p.drawPixmap(0,0,-1,-1,wg_pix_002);
	p.drawPixmap((wl_pix_001.width()-wg_pix_003.width())/2,(wl_pix_001.height()-wg_pix_003.height())/2,-1,-1,wg_pix_003);
	p.end();

	if ( hdlm->color_mask_over == "" )
	{
		must_update = 0;
		slider_custo_red->setValue(0);
		slider_custo_green->setValue(0);
		slider_custo_blue->setValue(0);
		slider_custo_opacity->setValue(255);
		must_update = 1;
		preview_customize->setPixmap(wl_pix_001);
	}
	else
	{
		QStringList wl_explode = hdlm->color_mask_over.split("$",QString::KeepEmptyParts);
		must_update = 0;
		slider_custo_red->setValue(wl_explode.at(0).toInt());
		slider_custo_green->setValue(wl_explode.at(1).toInt());
		slider_custo_blue->setValue(wl_explode.at(2).toInt());
		slider_custo_opacity->setValue(wl_explode.at(3).toInt());
		must_update = 1;

		thread_img->rouge = slider_custo_red->value();
		thread_img->vert = slider_custo_green->value();
		thread_img->bleu = slider_custo_blue->value();
		thread_img->opacity = slider_custo_opacity->value();

		thread_img->wlimg = wg_pix_001.toImage().convertToFormat(QImage::Format_ARGB32, Qt::AutoColor);
		thread_img->run();
	}

        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 1;
	thread_ani->isrender = 0;
	mask_interface->show();
	mask_interface->raise();
	frame_customize->show();
	frame_customize->raise();
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_valide_customize()
{
    if ( frame_smile->isVisible() == true )
    {
        QStringList wl_explode = pntmygl->tab_diapo[pntmygl->num_select][3].split("%*",QString::KeepEmptyParts);
        pntmygl->tab_diapo[pntmygl->num_select][3] = wl_explode.at(0) + "%*" + QString::number(slider_custo_red->value()) + "%*" + QString::number(slider_custo_green->value()) + "%*" + QString::number(slider_custo_blue->value()) + "%*" + QString::number(slider_custo_opacity->value());
        pntmygl->f_reload_img(pntmygl->num_select);
        frame_customize->hide();
        mask_interface->hide();
        smenuBar->setEnabled(true);
    }
    else
    {
	hdl_current_menu->color_mask_over = QString::number(slider_custo_red->value()) + "$" + QString::number(slider_custo_green->value()) + "$" + QString::number(slider_custo_blue->value()) + "$" + QString::number(slider_custo_opacity->value());
	hdl_current_menu->charge_mask(hdl_current_menu->path_mask);
	frame_customize->hide();
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 0;
        thread_ani->isrender = 0;
        QTimer::singleShot(5, this, SLOT(f_run_ani()));
        smenuBar->setEnabled(true);
    }
}

void mainfrm::f_cancel_customize()
{
    if ( frame_smile->isVisible() == true )
    {
        frame_customize->hide();
        mask_interface->hide();
        smenuBar->setEnabled(true);
    }
    else
    {
        frame_customize->hide();
        thread_ani->hdlmsk = mask_interface;
        thread_ani->sens = 0;
        thread_ani->isrender = 0;
        QTimer::singleShot(5, this, SLOT(f_run_ani()));
        smenuBar->setEnabled(true);
    }
}

void mainfrm::f_custo_red(int value)
{
	if ( must_update == 1 )
	{
		thread_img->rouge = value;
		thread_img->vert = slider_custo_green->value();
		thread_img->bleu = slider_custo_blue->value();
		thread_img->opacity = slider_custo_opacity->value();

		thread_img->wlimg = wg_pix_001.toImage().convertToFormat(QImage::Format_ARGB32, Qt::AutoColor);
		thread_img->run();
	}
}

void mainfrm::f_custo_green(int value)
{
	if ( must_update == 1 )
	{
		thread_img->rouge = slider_custo_red->value();
		thread_img->vert = value;
		thread_img->bleu = slider_custo_blue->value();
		thread_img->opacity = slider_custo_opacity->value();

		thread_img->wlimg = wg_pix_001.toImage().convertToFormat(QImage::Format_ARGB32, Qt::AutoColor);
		thread_img->run();
	}
}

void mainfrm::f_custo_blue(int value)
{
	if ( must_update == 1 )
	{
		thread_img->rouge = slider_custo_red->value();
		thread_img->vert = slider_custo_green->value();
		thread_img->bleu = value;
		thread_img->opacity = slider_custo_opacity->value();

		thread_img->wlimg = wg_pix_001.toImage().convertToFormat(QImage::Format_ARGB32, Qt::AutoColor);
		thread_img->run();
	}
}

void mainfrm::f_custo_opacity(int value)
{
	if ( must_update == 1 )
	{
		thread_img->rouge = slider_custo_red->value();
		thread_img->vert = slider_custo_green->value();
		thread_img->bleu = slider_custo_blue->value();
		thread_img->opacity = value;

		thread_img->wlimg = wg_pix_001.toImage().convertToFormat(QImage::Format_ARGB32, Qt::AutoColor);
		thread_img->run();
	}
}

void mainfrm::f_refresh_customize()
{
	QPixmap wl_pix_001(preview_customize->width(),preview_customize->height());
	wl_pix_001.fill(QColor(0,0,0,0));
	QImage wl_img_001 = thread_img->wlimg.scaledToHeight(preview_customize->height(), Qt::FastTransformation);
	QPainter p;
	p.begin(&wl_pix_001);
	p.drawPixmap(0,0,-1,-1,wg_pix_002);
	p.drawImage( (wl_pix_001.width()-wl_img_001.width())/2,(wl_pix_001.height()-wl_img_001.height())/2, wl_img_001, 0, 0, -1, -1, Qt::AutoColor );
	p.end();
	preview_customize->setPixmap(wl_pix_001);
}

void mainfrm::f_update_thumb_menu()
{
	// *** CAPTURE DU MENU ***
    /*if ( mask_interface->isVisible() == true )
    {
        mask_interface->hide();
    }*/
	QPixmap wlpixmap = QPixmap::grabWidget(screen_designer);
	hdl_current_menuth->draw_image = wlpixmap.scaledToWidth ( 88, Qt::FastTransformation );
	hdl_current_menuth->repaint();
	//smenuBar->setEnabled(true);
}

void mainfrm::f_delete_widgetonmenu()
{
	// *** SUPPRESSION DE TOUS LES WIDGETS DU MENU COURANT ***
	int wl_int_001 = 0;
	while ( wl_int_001 < nbre_menus )
	{
		table_hdl_menus[wl_int_001]->close();
		wl_int_001++;
	}
	nbre_menus = 0;
	nbre_menus_wo_label = 0;
}

void mainfrm::f_save_widgetonmenu()
{
	// *** SAUVEGARDE DES INFORMATIONS DU MENU ***
	QString wl_str_001 = "";
	wg_int_001=0;
	while ( table_hdl_menuth[wg_int_001] != hdl_current_menuth && wg_int_001 < nbre_menuth )
	{
		wg_int_001++;
	}
	if ( table_hdl_menuth[wg_int_001] == hdl_current_menuth )
	{
		wg_int_002 = 0;
		while ( wg_int_002 < nbre_menus )
		{
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][0] = QString::number(table_hdl_menus[wg_int_002]->geometry().x());
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][1] = QString::number(table_hdl_menus[wg_int_002]->geometry().y());
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][2] = QString::number(table_hdl_menus[wg_int_002]->width());
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][3] = QString::number(table_hdl_menus[wg_int_002]->height());
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][4] = table_hdl_menus[wg_int_002]->back_image;
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][5] = table_hdl_menus[wg_int_002]->quoilire;
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][6] = table_hdl_menus[wg_int_002]->path_mask;
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][7] = QString::number(table_hdl_menus[wg_int_002]->rotation);
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][8] = QString::number(table_hdl_menus[wg_int_002]->img_x_size);
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][9] = table_hdl_menus[wg_int_002]->quoilirechapitre;
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][10] = QString::number(table_hdl_menus[wg_int_002]->img_y_size);
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][11] = QString::number(table_hdl_menus[wg_int_002]->islabel);
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][12] = QString::number(table_hdl_menus[wg_int_002]->shadow);
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][13] = table_hdl_menus[wg_int_002]->color_mask_over;
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][14] = QString::number(table_hdl_menus[wg_int_002]->anim_thumb);
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][15] = QString::number(table_hdl_menus[wg_int_002]->zindex);
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][16] = QString::number(table_hdl_menus[wg_int_002]->taborder);
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][17] = QString::number(table_hdl_menus[wg_int_002]->alpha_menu);
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][18] = table_hdl_menus[wg_int_002]->shadow_color + "$" + QString::number(table_hdl_menus[wg_int_002]->shadow_opacity) + "$" + QString::number(table_hdl_menus[wg_int_002]->shadow_angle) + "$";
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][19] = table_hdl_menus[wg_int_002]->audio_track;
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][20] = QString::number(table_hdl_menus[wg_int_002]->shear_value_x);
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][21] = QString::number(table_hdl_menus[wg_int_002]->shear_value_y);
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][22] = table_hdl_menus[wg_int_002]->quoi_faire;
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][23] = table_hdl_menus[wg_int_002]->quoi_overlay;

			if ( table_hdl_menus[wg_int_002]->isbold == true )
			{
				wl_str_001 = "1";
			}
			else
			{
				wl_str_001 = "0";
			}

			if ( table_hdl_menus[wg_int_002]->isitalic == true )
			{
				wl_str_001 = wl_str_001 + "1";
			}
			else
			{
				wl_str_001 = wl_str_001 + "0";
			}

			if ( table_hdl_menus[wg_int_002]->isunderline == true )
			{
				wl_str_001 = wl_str_001 + "1";
			}
			else
			{
				wl_str_001 = wl_str_001 + "0";
			}

			wl_str_001 = wl_str_001 + QString::number(table_hdl_menus[wg_int_002]->isalign);

			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][24] = wl_str_001;
			table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][25] = table_hdl_menus[wg_int_002]->pos_thumb;
                        table_menus[wg_int_001][table_hdl_menus[wg_int_002]->zindex][26] = QString::number(table_hdl_menus[wg_int_002]->font_size);

			wg_int_002++;
		}
		table_menus[wg_int_001][wg_int_002][0] = "$$$";

		table_menus_property[wg_int_001][0] = current_menu_background;
		table_menus_property[wg_int_001][1] = QString::number(scale_current_menu_background);
		table_menus_property[wg_int_001][2] = QString::number(pntwheel1->red) + ";" + QString::number(pntwheel1->green) + ";" + QString::number(pntwheel1->blue);
		table_menus_property[wg_int_001][3] = QString::number(pntwheel2->red) + ";" + QString::number(pntwheel2->green) + ";" + QString::number(pntwheel2->blue);
		table_menus_property[wg_int_001][4] = current_menu_audio;
		table_menus_property[wg_int_001][5] = current_menu_intro;
		table_menus_property[wg_int_001][6] = QString::number(dial_opacity_overlay->value());
		table_menus_property[wg_int_001][7] = QString::number(current_loop) + QString::number(loop_length);
		table_menus_property[wg_int_001][8] = current_intro_zik;
                table_menus_property[wg_int_001][9] = current_pencil_draw;
	}
	else
	{
		qDebug() << "LOGICAL MEMORY ERROR SEARCHING POSITION FOR SAVING MENU";
	}
}

void mainfrm::f_update_blend()
{
        sur_blend->setPixmap(QPixmap::fromImage(thread_blend->dstImage,Qt::AutoColor));

        QTimer::singleShot(5, this, SLOT(f_run_bld()));
}

void mainfrm::f_end_blend()
{
        screen_designer->show();
        //screen_designer->raise();
        sur_blend->hide();
        f_update_thumb_menu();
        bt_affhide_menus->setEnabled(true);
        bt_view_arbo->setEnabled(true);
        bt_opc_toolbar->setEnabled(true);
        bt_view_magnetic->setEnabled(true);

        f_view_tabinfos();

        if ( remember_status == 1 )
        {
            h_regle->show();
            v_regle->show();
        }
}

void mainfrm::f_calcul_jauge(long value)
{
	// *** CALCUL TAILLE DVD ***
	dvd_actual_size = dvd_actual_size + value;
	int wl_int_001 = 0;

	// *** GENERATION DE LA JAUGE ***
	QPixmap wl_pix_001(":/Interface/Interface/dvd_empty.png");
	QPixmap wl_pix_002(":/Interface/Interface/dvd_theme.png");
        QPixmap wl_pix_003(":/Interface/Interface/dvd_theme_full.png");

	if ( dvd_actual_size > 0 )
	{
                if ( (wl_pix_001.height() * dvd_actual_size)/dvd_total_size <= wl_pix_001.height() )
		{
			wl_int_001 = (wl_pix_001.height() * dvd_actual_size)/dvd_total_size;
			QPainter p;
			p.begin(&wl_pix_001);
                        /*QFont myfont;
                        p.setPen(QColor(0,0,0));
                        myfont.setPixelSize ( 14 );
			myfont.setBold(true);
                        p.setFont(myfont);*/
			p.drawPixmap(0, wl_pix_001.height()-wl_int_001, wl_pix_002, 0, wl_pix_001.height()-wl_int_001, -1, wl_int_001);
                        //p.drawText(QRect(2,wl_pix_001.height()-16,50,14), Qt::AlignVCenter, QString::number((100 * dvd_actual_size)/dvd_total_size) + "%");
			p.end();
			jauge_dvd->setPixmap(wl_pix_001);
		}
		else
		{
			QPainter p;
			p.begin(&wl_pix_001);
                        /*QFont myfont;
                        p.setPen(QColor(0,0,0));
                        myfont.setPixelSize ( 14 );
			myfont.setBold(true);
                        p.setFont(myfont);*/
                        //p.drawText(QRect(2,wl_pix_001.height()-16,50,14), Qt::AlignVCenter, QString::number((100 * dvd_actual_size)/dvd_total_size) + "%");
                        p.drawPixmap(0, 0, wl_pix_003, 0, 0, -1, -1);
			p.end();
			jauge_dvd->setPixmap(wl_pix_001);
                        QMessageBox::information(this, name_application, tr("Vous avez dépassé la taille maximum de votre DVD."));
		}
	}
	else
	{
		QPainter p;
		p.begin(&wl_pix_001);
                /*QFont myfont;
                p.setPen(QColor(0,0,0));
                myfont.setPixelSize ( 14 );
		myfont.setBold(true);
                p.setFont(myfont);*/
		p.drawPixmap(0, wl_pix_001.height()-wl_int_001, wl_pix_002, 0, wl_pix_001.height()-wl_int_001, -1, wl_int_001);
                //p.drawText(QRect(2,wl_pix_001.height()-16,50,14), Qt::AlignVCenter, QString::number((100 * dvd_actual_size)/dvd_total_size) + "%");
		p.end();
		jauge_dvd->setPixmap(wl_pix_001);
	}
}

// ***********************************
// *** GESTION DES MENUS THUMBNAIL ***
// ***********************************

void mainfrm::f_add_menu()
{
	if ( nbre_menuth < 19 )
	{
		// *** AJOUT D'UN MENU AU PROJET DVD ***
		must_update = 0;
		hdl_current_menuth->is_edit = 0;

		f_update_thumb_menu();
		nbre_menuth++;

		// *** SAUVEGARDE DES INFORMATIONS DU MENU ***
		f_save_widgetonmenu();
		// *** SUPPRESSION DE TOUS LES ELEMENTS DU MENU COURANT ***
		f_delete_widgetonmenu();

		bttxt->setPlainText("");
		// *** CREATION MINIATURE DU NOUVEAU MENU ***
		menu_th *newmenu = new menu_th(frame_support_menuthumb);
		newmenu->setGeometry( 2+(nbre_menuth*106), 0, 106, 106 );
                newmenu->draw_image = QPixmap(path_project+"/DVD/TEMP/nofd.png").scaledToWidth ( 88, Qt::FastTransformation );
		//newmenu->draw_image.fill(QColor(0,0,0));
		newmenu->is_edit = 1;
		newmenu->is_first = nbre_menuth + 1;
		newmenu->show();
		table_hdl_menuth[nbre_menuth] = newmenu;
                table_menus[nbre_menuth][0][0] = "$$$";
		connect(newmenu, SIGNAL(select_menuth(menu_th*) ),this, SLOT(f_select_menuth(menu_th*)));
                connect(newmenu, SIGNAL(delete_menuth(menu_th*) ),this, SLOT(f_delete_menuth(menu_th*)));
                connect(newmenu, SIGNAL(dupliquer_menuth(menu_th*) ),this, SLOT(f_dupliquer_menuth(menu_th*)));
		hdl_current_menuth = newmenu;

		// *** CREATION DU MENU DANS L'ARBORESCENCE ***
		item_menu *newmenuarb = new item_menu(frame_syno);
		if ( nbre_menuth == 0 && nbre_medias == 0 )
		{
			newmenuarb->setGeometry( 2, 0, 106, 106 );
		}
		else
		{
			int wl_calcpos = 2+(110*((nbre_medias+nbre_menuth)-1));
			int wl_multi = 1;
                        if ( wl_calcpos > 780 )
			{
                                wl_multi = ((float)wl_calcpos/(float)780);
                                wl_calcpos = wl_calcpos - (wl_multi*780);
				newmenuarb->setGeometry( 2+wl_calcpos, 110*(wl_multi+1), 106, 106 );
			}
			else
			{
				newmenuarb->setGeometry( wl_calcpos, 110*wl_multi, 106, 106 );
			}
		}
                newmenuarb->num_menu = nbre_menuth;
		connect(newmenuarb, SIGNAL(item_move(item_menu*) ),this, SLOT(f_item_move(item_menu*)));
		connect(newmenuarb, SIGNAL(item_select(item_menu*) ),this, SLOT(f_item_select(item_menu*)));
		connect(newmenuarb, SIGNAL(add_link(item_menu*,int) ),this, SLOT(f_add_link(item_menu*,int)));
		connect(newmenuarb, SIGNAL(add_link_media(item_menu*,QString) ),this, SLOT(f_add_link_media(item_menu*,QString)));
		connect(newmenuarb, SIGNAL(edit_menu_tree(item_menu*) ),this, SLOT(f_edit_menu_tree(item_menu*)));
		newmenuarb->show();
		frame_syno->tab_pnt_item[nbre_menuth] = newmenuarb;

		combo_quoilire_menu->insertItem(nbre_menuth+1,"Menu " + QString::number(nbre_menuth));

		current_menu_background = path_project+"/DVD/TEMP/nofd.png";
		scale_current_menu_background = 0;
		background_menu->setPixmap(QPixmap(current_menu_background));
                current_pencil_draw = "";

                QPixmap wl_pix_001(dvdxsize,dvdysize);
                wl_pix_001.fill(QColor(0,0,0,0));
                frame_pencil_draw->setPixmap(wl_pix_001);
                frame_support_drawing_menu->draw_user = wl_pix_001.toImage();

		//f_generation_scale();

		// *** ON VEROUILLE LA BARRE D'OUTILS ***
		current_menu_audio = "";
		current_menu_intro = "";
		current_loop = 0;

		is_is_intro->setToolTip("");
		is_is_intro->is_active = 0;
		is_is_intro->repaint();

		is_is_sound->setToolTip("");
		is_is_sound->is_active = 0;
		is_is_sound->repaint();

		bt_bt_img->setDisabled(true);
		dial_alpha_menu->setDisabled(true);
		combo_quoilire_media->setDisabled(true);
		combo_quoilire_media_chapitre->setDisabled(true);
		combo_select_langue->setDisabled(true);
		combo_quoilire_menu->setDisabled(true);
		bttxt->setDisabled(true);
		frame_th_msk_idea->setDisabled(true);
		actionOrdre_de_tabulation->setDisabled(true);
		must_update = 1;

                if ( ((nbre_menuth+1)*110) > frame_support_menu_th_contain->width()-30 )
		{
			frame_support_menuthumb->setGeometry(0,0,((nbre_menuth+1)*110),106);
			scroll_timeline->setMaximum(((nbre_menuth+1)*110)-frame_support_menu_th_contain->width());
			scroll_timeline->setEnabled(true);
                        scroll_timeline->show();
		}
		else
		{
			frame_support_menuthumb->setGeometry(0,0,frame_support_menu_th_contain->width(),106);
			scroll_timeline->setMaximum(0);
			scroll_timeline->setDisabled(true);
                        scroll_timeline->hide();
		}
		//f_update_thumb_menu();
	}
	else
	{
		QMessageBox::information(this, name_application, tr("Vous ne pouvez plus ajouter de nouveaux menus. Maximum atteint."));
	}
}

void mainfrm::f_previous_menu()
{
	// *** RECHERCHE DE LA POSITION DU MENU SELECTIONNE ***
	wg_int_001=0;
	while ( table_hdl_menuth[wg_int_001] != hdl_current_menuth && wg_int_001 < nbre_menuth )
	{
		wg_int_001++;
	}
	if ( table_hdl_menuth[wg_int_001] == hdl_current_menuth && wg_int_001 != 0 )
	{
                hdl_current_menuth->is_edit = 0;
                f_update_thumb_menu();
                // *** SAUVEGARDE DES INFORMATIONS DU MENU ***
                f_save_widgetonmenu();
                thread_blend->srcImage = QPixmap::grabWidget(screen_designer).toImage();
                sur_blend->setPixmap(QPixmap::fromImage(thread_blend->srcImage,Qt::AutoColor));
                sur_blend->setGeometry(screen_designer->geometry().x(),screen_designer->geometry().y(),screen_designer->width(),screen_designer->height());
                sur_blend->show();
                sur_blend->raise();
                special_delete = 1;
                tmp_hdl_menu_th = table_hdl_menuth[wg_int_001-1];
                f_select_menuth_step_2();
                special_delete = 0;
                thread_blend->srcImage2 = QPixmap::grabWidget(screen_designer).toImage();
                thread_blend->dstImage = thread_blend->srcImage;
                thread_blend->sequence = 0;
                QTimer::singleShot(5, this, SLOT(f_run_bld()));
	}
}

void mainfrm::f_next_menu()
{
	// *** RECHERCHE DE LA POSITION DU MENU SELECTIONNE ***
	wg_int_001=0;
	while ( table_hdl_menuth[wg_int_001] != hdl_current_menuth && wg_int_001 < nbre_menuth )
	{
		wg_int_001++;
	}
	if ( table_hdl_menuth[wg_int_001] == hdl_current_menuth && wg_int_001 < nbre_menuth )
	{
                hdl_current_menuth->is_edit = 0;
                f_update_thumb_menu();
                // *** SAUVEGARDE DES INFORMATIONS DU MENU ***
                f_save_widgetonmenu();
                thread_blend->srcImage = QPixmap::grabWidget(screen_designer).toImage();
                sur_blend->setPixmap(QPixmap::fromImage(thread_blend->srcImage,Qt::AutoColor));
                sur_blend->setGeometry(screen_designer->geometry().x(),screen_designer->geometry().y(),screen_designer->width(),screen_designer->height());
                sur_blend->show();
                sur_blend->raise();
                special_delete = 1;
                tmp_hdl_menu_th = table_hdl_menuth[wg_int_001+1];
                f_select_menuth_step_2();
                special_delete = 0;
                thread_blend->srcImage2 = QPixmap::grabWidget(screen_designer).toImage();
                thread_blend->dstImage = thread_blend->srcImage;
                thread_blend->sequence = 0;
                QTimer::singleShot(5, this, SLOT(f_run_bld())); 
	}
}

void mainfrm::f_preview_overlay()
{
    if ( must_update == 1 )
    {
	QPixmap wl_pix_001(90,40);
	wl_pix_001.fill(QColor(0,0,0,0));
	QPainter p;
	p.begin(&wl_pix_001);
	p.drawPixmap(0, 0, QPixmap(":/Interface/Interface/fd_transparent.png"), 0, 0, 90, 40);
        p.drawPixmap(0, 0, QPixmap(":/Interface/Interface/back_transparent.png"), 0, 0, 90, 40);
	p.setPen(Qt::NoPen);
	p.setBrush(QColor(pntwheel1->red,pntwheel1->green,pntwheel1->blue,dial_opacity_overlay->value()));
	p.drawRect(0,0,45,40);
	p.setBrush(QColor(pntwheel2->red,pntwheel2->green,pntwheel2->blue,dial_opacity_overlay->value()));
	p.drawRect(45,0,45,40);
	p.setPen(QColor(0,0,0));
	p.setBrush(QColor(0,0,0,0));
	p.drawRect(0,0,89,39);
	p.end();
	overlay_preview->setPixmap(wl_pix_001);
    }
}

void mainfrm::f_overlay_menu()
{
	mask_interface->show();
	mask_interface->raise();
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 1;
	thread_ani->isrender = 0;
        must_update = 1;
	f_preview_overlay();
	frame_overlays->show();
	frame_overlays->raise();
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_valide_overlay()
{
	mask_interface->show();
	mask_interface->raise();
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 2;
	thread_ani->isrender = 0;
	smenuBar->setEnabled(true);
	frame_overlays->hide();
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_delete_menuth(menu_th* hdlmenuth)
{
	// *** RECHERCHE DE LA POSITION DU MENU SELECTIONNE ***
        int wl_int_001=0;
        while ( table_hdl_menuth[wl_int_001] != hdlmenuth && wl_int_001 < nbre_menuth )
	{
                wl_int_001++;
	}

        if ( table_hdl_menuth[wl_int_001] == hdlmenuth )
	{
		// *** DECALAGE DES POINTEURS DE MENU ***
                wg_int_002 = wl_int_001;
		delete frame_syno->tab_pnt_item[wg_int_002];
		while ( wg_int_002 < nbre_menuth )
		{
			table_hdl_menuth[wg_int_002] = table_hdl_menuth[wg_int_002+1];

			table_menus_property[wg_int_002][0] = table_menus_property[wg_int_002+1][0];
			table_menus_property[wg_int_002][1] = table_menus_property[wg_int_002+1][1];
			table_menus_property[wg_int_002][2] = table_menus_property[wg_int_002+1][2];
			table_menus_property[wg_int_002][3] = table_menus_property[wg_int_002+1][3];
			table_menus_property[wg_int_002][4] = table_menus_property[wg_int_002+1][4];
			table_menus_property[wg_int_002][5] = table_menus_property[wg_int_002+1][5];
			table_menus_property[wg_int_002][6] = table_menus_property[wg_int_002+1][6];
			table_menus_property[wg_int_002][7] = table_menus_property[wg_int_002+1][7];
			table_menus_property[wg_int_002][8] = table_menus_property[wg_int_002+1][8];
                        table_menus_property[wg_int_002][9] = table_menus_property[wg_int_002+1][9];

                        //table_hdl_menuth[wg_int_002+1]->setGeometry( 2+(wg_int_002*106), 0, 106, 106 );
                        QPropertyAnimation *animation = new QPropertyAnimation(table_hdl_menuth[wg_int_002+1], "geometry");
                        animation->setDuration(250);
                        animation->setStartValue(QRect(table_hdl_menuth[wg_int_002+1]->geometry().x(),table_hdl_menuth[wg_int_002+1]->geometry().y(),table_hdl_menuth[wg_int_002+1]->width(),table_hdl_menuth[wg_int_002+1]->height()));
                        animation->setEndValue(QRect(table_hdl_menuth[wg_int_002+1]->geometry().x()-106,table_hdl_menuth[wg_int_002+1]->geometry().y(),table_hdl_menuth[wg_int_002+1]->width(),table_hdl_menuth[wg_int_002+1]->height()));
                        animation->setEasingCurve(QEasingCurve::InOutBack);
                        animation->start();

			table_hdl_menuth[wg_int_002+1]->is_first = table_hdl_menuth[wg_int_002+1]->is_first--;
			table_hdl_menuth[wg_int_002+1]->repaint();

			// *** DECALAGE DES MENUS DE L'ARBORESCENCE ***
			frame_syno->tab_pnt_item[wg_int_002] = frame_syno->tab_pnt_item[wg_int_002+1];

			wg_int_002++;
		}
		// *** DECALAGE DES BOUTONS ***
                wg_int_002 = wl_int_001;

		while ( wg_int_002 < nbre_menuth )
		{
			wg_int_003 = 0;
			while ( table_menus[wg_int_002+1][wg_int_003][0] != "$$$" )
			{
				wg_int_004 = 0;
				while ( wg_int_004 < 25 )
				{
					table_menus[wg_int_002][wg_int_003][wg_int_004] = table_menus[wg_int_002+1][wg_int_003][wg_int_004];
					wg_int_004++;
				}
				wg_int_003++;
			}
			table_menus[wg_int_002][wg_int_003][0] = "$$$";
			wg_int_002++;
		}

		// *** REVALIDATION DES REFERENCES DES BOUTONS ***
		wg_int_002 = 0;
		while ( wg_int_002 < nbre_menuth )
		{
			wg_int_003 = 0;
			while ( table_menus[wg_int_002][wg_int_003][0] != "$$$" )
			{
                                if ( table_menus[wg_int_002][wg_int_003][5] == "!M!Menu " + QString::number(wl_int_001) )
				{
					table_menus[wg_int_002][wg_int_003][5] = "";
				}
				else
				{
					if ( table_menus[wg_int_002][wg_int_003][5].left(8) == "!M!Menu " )
					{
						wg_string_001 = table_menus[wg_int_002][wg_int_003][5];
						wg_string_001.remove(0,8);
						wg_int_004 = wg_string_001.toInt();

                                                if ( wg_int_004 > wl_int_001 )
						{
							table_menus[wg_int_002][wg_int_003][5] = "!M!Menu " + QString::number(wg_int_004-1);
						}
					}
				}
				wg_int_003++;
			}
			wg_int_002++;
		}

		nbre_menuth--;

		//
                if ( ((nbre_menuth+1)*110) > frame_support_menu_th_contain->width()-30 )
		{
			frame_support_menuthumb->setGeometry(0,0,((nbre_menuth+1)*100),106);
			scroll_timeline->setMaximum(((nbre_menuth+1)*100)-frame_support_menu_th_contain->width());
			scroll_timeline->setEnabled(true);
                        scroll_timeline->show();
		}
		else
		{
			frame_support_menuthumb->setGeometry(0,0,frame_support_menu_th_contain->width(),106);
			scroll_timeline->setMaximum(0);
			scroll_timeline->setDisabled(true);
                        scroll_timeline->hide();
		}
		//
		must_update = 0;

		combo_quoilire_menu->clear();
		combo_quoilire_menu->insertItem(0,wg_str_int_002);
		combo_quoilire_menu->insertItem(1,wg_str_int_003);
		wg_int_002 = 0;
		while ( wg_int_002 < nbre_menuth )
		{
			combo_quoilire_menu->insertItem(wg_int_002+2,"Menu " + QString::number(wg_int_002+1));
			wg_int_002++;
		}

		combo_quoilire_media->setCurrentIndex(0);
		combo_quoilire_media_chapitre->setCurrentIndex(0);
		combo_quoilire_menu->setCurrentIndex(0);
		combo_quoilire_media->setDisabled(true);
		bt_bt_img->setDisabled(true);
		dial_alpha_menu->setDisabled(true);
		bttxt->setDisabled(true);
		frame_th_msk_idea->setDisabled(true);
		combo_quoilire_media->setDisabled(true);
		check_anim->setDisabled(true);
		combo_select_langue->setDisabled(true);
		combo_quoilire_media_chapitre->setDisabled(true);
		combo_quoilire_menu->setDisabled(true);
		must_update = 1;
		hdl_current_menu = 0;
		actionCopier_le_bouton->setDisabled(true);

                if ( hdlmenuth == hdl_current_menuth )
                {
                    QPropertyAnimation *animation2 = new QPropertyAnimation(frame_lst_menus, "geometry");
                    animation2->setDuration(400);
                    animation2->setStartValue(QRect(frame_lst_menus->geometry().x(),frame_lst_menus->geometry().y(),frame_lst_menus->width(),frame_lst_menus->height()));
                    animation2->setEndValue(QRect(frame_lst_menus->geometry().x(),frame_lst_menus->geometry().y()+160+bottom_menu->height(),frame_lst_menus->width(),frame_lst_menus->height()));
                    animation2->setEasingCurve(QEasingCurve::InOutCubic);
                    animation2->start();

                    QPropertyAnimation *animation = new QPropertyAnimation(sur_blend, "geometry");
                    //connect(animation,SIGNAL(finished()),this,SLOT(f_select_menuth_step_2()));
                    animation->setDuration(700);
                    animation->setStartValue(QRect(sur_blend->geometry().x(),sur_blend->geometry().y(),sur_blend->width(),sur_blend->height()));
                    animation->setEndValue(QRect(screen_designer->geometry().x(),screen_designer->geometry().y(),screen_designer->width(),screen_designer->height()+100));
                    animation->setEasingCurve(QEasingCurve::InOutCubic);
                    animation->start();

                    bt_switch_medias->setEnabled(true);
                    bt_switch_themes->setEnabled(true);
                    bt_switch_property->setEnabled(true);
                    bt_opc_render->setEnabled(true);
                    bt_view_infos->setEnabled(true);
                    frame_pro->setEnabled(true);
                    smenuBar->setEnabled(true);

                    special_delete = 1;

                    if ( wl_int_001 > 0 )
                    {
                        tmp_hdl_menu_th = table_hdl_menuth[wl_int_001-1];
                        f_select_menuth_step_2();
                    }
                    else
                    {
                        tmp_hdl_menu_th = table_hdl_menuth[0];
                        f_select_menuth_step_2();
                    }
                    special_delete = 0;

                    thread_blend->srcImage = QPixmap::grabWidget(sur_blend).toImage().copy(0,0,dvdxsize,dvdysize);
                    thread_blend->srcImage2 = QPixmap::grabWidget(screen_designer).toImage();
                    thread_blend->dstImage = thread_blend->srcImage;
                    thread_blend->sequence = 0;
                    QTimer::singleShot(5, this, SLOT(f_run_bld()));

                    frame_top_tool->show();
                    frame_top_tool->raise();
                }
	}
	else
	{
		qDebug() << "ERROR FINDING MENU FOR DELETING";
	}
}

void mainfrm::f_select_menuth(menu_th* hdlmenuth)
{
    if ( hdlmenuth != hdl_current_menuth )
    {
        QPropertyAnimation *animation2 = new QPropertyAnimation(frame_lst_menus, "geometry");
        animation2->setDuration(400);
        animation2->setStartValue(QRect(frame_lst_menus->geometry().x(),frame_lst_menus->geometry().y(),frame_lst_menus->width(),frame_lst_menus->height()));
        animation2->setEndValue(QRect(frame_lst_menus->geometry().x(),frame_lst_menus->geometry().y()+160+bottom_menu->height(),frame_lst_menus->width(),frame_lst_menus->height()));
        animation2->setEasingCurve(QEasingCurve::InOutCubic);
        animation2->start();

        tmp_hdl_menu_th = hdlmenuth;
        QPropertyAnimation *animation = new QPropertyAnimation(sur_blend, "geometry");
        connect(animation,SIGNAL(finished()),this,SLOT(f_select_menuth_step_2()));
        animation->setDuration(700);
        animation->setStartValue(QRect(sur_blend->geometry().x(),sur_blend->geometry().y(),sur_blend->width(),sur_blend->height()));
        animation->setEndValue(QRect(screen_designer->geometry().x(),screen_designer->geometry().y(),screen_designer->width(),screen_designer->height()+100));
        animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();

        bt_switch_medias->setEnabled(true);
        bt_switch_themes->setEnabled(true);
        bt_opc_render->setEnabled(true);
        bt_view_infos->setEnabled(true);
        bt_switch_property->setEnabled(true);
        frame_pro->setEnabled(true);
        smenuBar->setEnabled(true);

        frame_top_tool->show();
        frame_top_tool->raise();
    }
}

void mainfrm::f_select_menuth_step_2()
{
        bt_affhide_menus->setDisabled(true);
        bt_view_arbo->setDisabled(true);
        bt_opc_toolbar->setDisabled(true);
        bt_view_magnetic->setDisabled(true);
        must_update = 0;

        if ( special_delete == 0 )
        {
            thread_blend->srcImage = sur_blend->pixmap()->toImage();
            hdl_current_menuth->is_edit = 0;
            // *** CHANGEMENT DU MENU COURANT ***
            f_update_thumb_menu();
            // *** SAUVEGARDE DES INFORMATIONS DU MENU ***
            f_save_widgetonmenu();
        }

        bttxt->setPlainText("");

        // *** SUPPRESSION DE TOUS LES ELEMENTS DU MENU COURANT ***
        f_delete_widgetonmenu();

        actionOrdre_de_tabulation->setDisabled(true);

        // *** RECHERCHE DE LA POSITION DU MENU SELECTIONNE ***
        wg_int_001=0;
        while ( table_hdl_menuth[wg_int_001] != tmp_hdl_menu_th && wg_int_001 < nbre_menuth )
        {
                wg_int_001++;
        }

        // *** CHARGEMENT BACKGROUND ET AUTRES THEMES ***
        current_menu_background = table_menus_property[wg_int_001][0];

        scale_current_menu_background = table_menus_property[wg_int_001][1].toInt();
        current_menu_audio = table_menus_property[wg_int_001][4];

        current_menu_intro = table_menus_property[wg_int_001][5];
        current_intro_zik = table_menus_property[wg_int_001][8];
        current_pencil_draw = table_menus_property[wg_int_001][9];

        if ( current_pencil_draw == "" )
        {
            QPixmap wl_pix_001(dvdxsize,dvdysize);
            wl_pix_001.fill(QColor(0,0,0,0));
            frame_pencil_draw->setPixmap(wl_pix_001);
            frame_support_drawing_menu->draw_user = wl_pix_001.toImage();
        }
        else
        {
            QPixmap wl_pix_001(path_project + "/DVD/SVP/" + current_pencil_draw);
            frame_pencil_draw->setPixmap(wl_pix_001);
            frame_support_drawing_menu->draw_user = wl_pix_001.toImage();
        }

        current_loop = table_menus_property[wg_int_001][7].mid(0,1).toInt();
        loop_length = table_menus_property[wg_int_001][7].mid(1,table_menus_property[wg_int_001][7].length()-1).toInt();

        if ( current_menu_intro == "" )
        {
                is_is_intro->setToolTip("");
                is_is_intro->is_active = 0;
                screen_designer->has_intro = 0;               
        }
        else
        {
                is_is_intro->setToolTip(current_menu_intro);
                is_is_intro->is_active = 1;
                screen_designer->has_intro = 1;
        }

        is_is_intro->repaint();

        if ( current_menu_audio == "" )
        {
                is_is_sound->setToolTip("");
                is_is_sound->is_active = 0;
                screen_designer->has_sound = 0;          
        }
        else
        {
                is_is_sound->setToolTip(current_menu_audio);
                is_is_sound->is_active = 1;
                screen_designer->has_sound = 1;
        }

        is_is_sound->repaint();

        if ( current_menu_background != "" && current_menu_background != path_project+"/DVD/TEMP/nofd.png" )
        {
                if ( current_menu_background.right(5) != ".MPEG" && current_menu_background.right(5) != ".mpeg" && current_menu_background.right(4) != ".MPG" && current_menu_background.right(4) != ".mpg" && current_menu_background.right(4) != ".AVI" && current_menu_background.right(4) != ".avi" && current_menu_background.right(4) != ".MP4" && current_menu_background.right(4) != ".mp4" )
                {
                    if ( current_menu_background.mid(0,1) == " " )
                    {
                        QStringList wl_explode = current_menu_background.split(" ", QString::SkipEmptyParts);

                        QString wl_red = wl_explode[0];
                        QString wl_green = wl_explode[1];
                        QString wl_blue = wl_explode[2];
                        QString wl_red_2 = wl_explode[3];
                        QString wl_green_2 = wl_explode[4];
                        QString wl_blue_2 = wl_explode[5];
                        QString wl_checked = wl_explode[6];

                        QPixmap wl_pix_001(dvdxsize,dvdysize);

                        QPainter p;
                        p.begin(&wl_pix_001);
                        p.setPen(Qt::NoPen);
                        p.setRenderHint(QPainter::Antialiasing,true);

                        if ( wl_checked == "0" )
                        {
                            QLinearGradient Gradient1(0.0,0.0,0.0,wl_pix_001.height());
                            Gradient1.setColorAt(0.0, QColor(wl_red.toInt(),wl_green.toInt(),wl_blue.toInt(),255));
                            Gradient1.setColorAt(1.0, QColor(wl_red_2.toInt(),wl_green_2.toInt(),wl_blue_2.toInt(),255));
                            p.setBrush(Gradient1);
                        }
                        else
                        {
                            QRadialGradient Gradient1(dvdxsize/2,dvdysize/2,dvdxsize/2,dvdxsize/2,dvdysize/2);
                            Gradient1.setColorAt(0.0, QColor(wl_red.toInt(),wl_green.toInt(),wl_blue.toInt(),255));
                            Gradient1.setColorAt(1.0, QColor(wl_red_2.toInt(),wl_green_2.toInt(),wl_blue_2.toInt(),255));
                            p.setBrush(Gradient1);
                        }

                        p.drawRect(0, 0, wl_pix_001.width(), wl_pix_001.height());
                        p.end();

                        background_menu->setPixmap(wl_pix_001);
                        hdl_current_menuth = tmp_hdl_menu_th;
                        pntwheel11->setColor(wl_red.toInt(),wl_green.toInt(),wl_blue.toInt());
                        pntwheel12->setColor(wl_red_2.toInt(),wl_green_2.toInt(),wl_blue_2.toInt());

                        if ( wl_checked == "2" )
                        {
                            chkradial->setChecked(true);
                        }
                        else
                        {
                            chkradial->setChecked(false);
                        }
                    }
                    else
                    {
                        f_generation_scale();
                    }
                }
                else
                {
                        wg_int_002 = current_menu_background.lastIndexOf( '/' );
                        if ( wg_int_002 != -1 )
                        {
                                background_menu->setPixmap(path_project+"/DVD/TEMP/"+current_menu_background.mid(wg_int_002+1,current_menu_background.length()-(wg_int_002+1))+".jpg");
                        }
                        else
                        {
                                qDebug() << "ERROR IN BACKGROUND NAME NO / : " << current_menu_background;
                                background_menu->setPixmap(QPixmap(path_project+"/DVD/TEMP/nofd.png"));
                        }
                }
        }
        else
        {
                // *** AUCUN FOND DEFINIS ***
                background_menu->setPixmap(QPixmap(path_project+"/DVD/TEMP/nofd.png"));
        }

        QString wl_str_001 = table_menus_property[wg_int_001][2];
        QStringList wl_explode = wl_str_001.split(";",QString::KeepEmptyParts);
        pntwheel1->setColor(wl_explode.at(0).toInt(),wl_explode.at(1).toInt(),wl_explode.at(2).toInt());

        wl_str_001 = table_menus_property[wg_int_001][3];
        wl_explode = wl_str_001.split(";",QString::KeepEmptyParts);
        pntwheel2->setColor(wl_explode.at(0).toInt(),wl_explode.at(1).toInt(),wl_explode.at(2).toInt());

        dial_opacity_overlay->setValue(table_menus_property[wg_int_001][6].toInt());

        // *** CREATION DES BOUTONS SUR LE MENU ***
        if ( table_hdl_menuth[wg_int_001] == tmp_hdl_menu_th )
        {
                wg_int_002 = 0;
                while ( table_menus[wg_int_001][wg_int_002][0] != "$$$" )
                {
                        f_create_menu_movie();
                        wg_int_002++;
                }
                hdl_current_menuth = tmp_hdl_menu_th;
                hdl_current_menuth->is_edit = 1;
                hdl_current_menuth->repaint();
        }
        else
        {
                qDebug() << "MEMORY ERROR SEARCHING SELECT MENUTH";
        }

        // *** BLOCAGE DES BARRES D'OUTILS ***
        hdl_current_menu = 0;
        actionCopier_le_bouton->setDisabled(true);
        must_update = 0;
        combo_quoilire_media->setCurrentIndex(0);
        combo_quoilire_media_chapitre->setCurrentIndex(0);
        combo_quoilire_menu->setCurrentIndex(0);
        combo_quoilire_media->setDisabled(true);
        combo_select_langue->setDisabled(true);
        bt_bt_img->setDisabled(true);
        dial_alpha_menu->setDisabled(true);
        bttxt->setDisabled(true);
        frame_th_msk_idea->setDisabled(true);
        combo_quoilire_media->setDisabled(true);
        check_anim->setDisabled(true);
        combo_quoilire_media_chapitre->setDisabled(true);
        combo_quoilire_menu->setDisabled(true);
        must_update = 1;
        //
        bt_view_arbo->setEnabled(true);
        bt_opc_toolbar->setEnabled(true);
        bt_view_magnetic->setEnabled(true);
        frame_top_tool->raise();

        if ( special_delete == 0 )
        {
            thread_blend->srcImage2 = QPixmap::grabWidget(screen_designer).toImage();
            thread_blend->dstImage = thread_blend->srcImage;
            thread_blend->sequence = 0;
            QTimer::singleShot(5, this, SLOT(f_run_bld()));
        }
}

// *************************
// *** GESTION DES MENUS ***
// *************************

void mainfrm::f_select_background()
{
	// *** CHOIX DE L'ARRIERE PLAN ***
	frame_pro->setDisabled(true);

	menuProjet->setDisabled(true);
	menuMenu->setDisabled(true);
	menuAffichage->setDisabled(true);
	menuG_n_ration->setDisabled(true);
	menuEdition->setDisabled(true);
	actionMenu_pr_c_dent->setDisabled(true);
	actionMenu_suivant->setDisabled(true);
	actionCouleurs_des_overlays->setDisabled(true);
	actionParam_tres_avanc_s->setDisabled(true);
	menuA_propos->setDisabled(true);
	frame_editor->setDisabled(true);

	frame_lst_menus->hide();

	myfileopen *hdlfopen = new myfileopen(this);
	hdlfopen->setDirectory(path_background);
	hdlfopen->source = 0;
	hdlfopen->setWindowTitle(tr("Arriere plan du menu"));
        hdlfopen->setFilter("(*.PNG *.png *.jpg *.JPG *.jeg *.JPEG *.MPG *.mpg *.MPEG *.mpeg *.AVI *.avi *.mp4 *.MP4)");
	connect(hdlfopen, SIGNAL(change_image(QString)),this, SLOT(f_open_ipreview(QString)));
	connect(hdlfopen, SIGNAL(filesSelected( const QStringList )),this, SLOT(f_close_ipreview( const QStringList )));
	connect(hdlfopen, SIGNAL(f_close()),this, SLOT(f_cancel_ipreview()));
	connect(hdlfopen, SIGNAL(finished(int)),this, SLOT(f_cancel_ipreview()));

	pntfiled = hdlfopen;

	hdlfopen->show();
	hdlfopen->raise();
}

void mainfrm::thvi_end(int, QProcess::ExitStatus)
{
	QPixmap wl_pix_001(dvdxsize,dvdysize);
	wl_pix_001.fill(QColor(0,0,0));

	QPixmap wl_pix_002(path_project + "/DVD/TEMP/" + wg_string_004 + ".jpg");

	QPixmap wl_pix_003 = wl_pix_002.scaledToWidth(dvdxsize, Qt::FastTransformation);

	QPainter p;
	p.begin(&wl_pix_001);
	p.drawPixmap((wl_pix_001.width() - wl_pix_003.width()) / 2, (wl_pix_001.height() - wl_pix_003.height()) / 2, wl_pix_003 );
	p.end();

	wl_pix_001.save(path_project + "/DVD/TEMP/" + wg_string_004 + ".jpg");

	background_menu->setPixmap(wl_pix_001);
	f_update_thumb_menu();
}

void mainfrm::f_valide_scale_background_1()
{
	current_menu_background = wg_string_001;
	scale_current_menu_background = 1;
	background_menu->setPixmap(wg_pix_001);
	frame_scale_background->hide();
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 0;
	smenuBar->setEnabled(true);
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_valide_scale_background_2()
{
	current_menu_background = wg_string_001;
	scale_current_menu_background = 2;
	background_menu->setPixmap(wg_pix_002);
	frame_scale_background->hide();
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 0;
	smenuBar->setEnabled(true);
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

// *************************
// *** DIVERS TRAITEMENT ***
// *************************

void mainfrm::f_apropos_open()
{
    thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 1;
	thread_ani->isrender = 0;
	mask_interface->show();
	mask_interface->raise();
	frame_apropos->show();
	frame_apropos->raise();
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_apropos_close()
{
        if ( frame_smile->isVisible() == true )
        {
            mask_interface->hide();
            smenuBar->setEnabled(true);

            frame_apropos->hide();
        }
        else
        {
            thread_ani->hdlmsk = mask_interface;
            thread_ani->sens = 0;
            thread_ani->isrender = 999;
            frame_apropos->hide();
            smenuBar->setEnabled(true);
            QTimer::singleShot(5, this, SLOT(f_run_ani()));
        }
}

void mainfrm::f_advanced_open()
{
	if ( current_loop == 0 )
	{
		check_loop_back->setChecked(false);
	}
	else
	{
		check_loop_back->setChecked(true);
	}
	spin_duree_vig->setValue(loop_length);
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 1;
	thread_ani->isrender = 0;
	mask_interface->show();
	mask_interface->raise();
	frame_advanced->show();
	frame_advanced->raise();
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_advanced_close()
{
	loop_length = spin_duree_vig->value();
        thread_ani->hdlmsk = mask_interface;
	thread_ani->sens = 0;
	frame_advanced->hide();
	smenuBar->setEnabled(true);
	QTimer::singleShot(5, this, SLOT(f_run_ani()));
}

void mainfrm::f_put_loop(int)
{
	// *** LE MENU DOIT IL ETRE UNE BOUCLE VIDEO ***
	if ( check_loop_back->isChecked() == true )
	{
		current_loop = 1;
	}
	else
	{
		current_loop = 0;
	}
}

// **********************************
// *** CAPTURE DE L'IMAGE DU MENU ***
// **********************************

void mainfrm::f_screengrab_menu()
{
    if ( frame_smile->isVisible() == false )
    {
        if ( hdl_current_menu != 0 )
	{
		hdl_current_menu->is_select = 0;
		hdl_current_menu = 0;
		actionCopier_le_bouton->setDisabled(true);
		bt_bt_img->setDisabled(true);
		dial_alpha_menu->setDisabled(true);
		combo_quoilire_media->setDisabled(true);
		combo_quoilire_media_chapitre->setDisabled(true);
		combo_select_langue->setDisabled(true);
		combo_quoilire_menu->setDisabled(true);
		bttxt->setDisabled(true);
		frame_th_msk_idea->setDisabled(true);
	}
	int wl_int_001=0;
	while ( wl_int_001 < nbre_medias )
	{
		table_hdl_medias[wl_int_001]->is_select = 0;
		table_hdl_medias[wl_int_001]->repaint();
		wl_int_001++;
	}
	QPixmap wlpixmap = QPixmap::grabWidget(screen_designer);
	QString wmyimg = QFileDialog::getSaveFileName(this, tr("Sauvegarder l'image"), path_capture, tr("Image (*.jpg)"));
       	if ( wmyimg.isNull() )
       	{
		return;
       	}
	else
	{
   		wg_int_001 = wmyimg.lastIndexOf( '/' );
    		if ( wg_int_001 != -1 )
    		{
        		path_capture = wmyimg.mid(0,wg_int_001);
    		}

		if ( wmyimg.right(4) != ".jpg" )
		{
			wmyimg = wmyimg + ".jpg";
		}
		wlpixmap.save(wmyimg,"JPEG");
	}
    }
    else
    {
        QImage myimg = pntmygl->grabFrameBuffer ( false );

        QString wmyimg = QFileDialog::getSaveFileName(this, tr("Sauvegarder l'image"), path_capture, tr("Image (*.jpg)"));
        if ( wmyimg.isNull() )
        {
                return;
        }
        else
        {
            wg_int_001 = wmyimg.lastIndexOf( '/' );
            if ( wg_int_001 != -1 )
            {
                    path_capture = wmyimg.mid(0,wg_int_001);
            }

            if ( wmyimg.right(4) != ".jpg" )
            {
                    wmyimg = wmyimg + ".jpg";
            }

            myimg.save(wmyimg,"JPEG");
        }
    }
}

// *******************
// *** MENU DU BAS ***
// *******************

void mainfrm::f_showhide_lstmenu()
{
    if ( sur_blend->isVisible() == false )
    {
        f_save_widgetonmenu();

        bt_switch_medias->setDisabled(true);
        bt_switch_themes->setDisabled(true);
        bt_view_infos->setDisabled(true);
        bt_view_magnetic->setDisabled(true);
        bt_switch_property->setDisabled(true);
        bt_opc_toolbar->setDisabled(true);
        bt_opc_render->setDisabled(true);
        bt_view_arbo->setDisabled(true);
        frame_pro->setDisabled(true);
        smenuBar->setDisabled(true);
        bt_add_menu->setDisabled(true);

        if ( h_regle->isVisible() == true )
        {
            remember_status = 1;
            h_regle->hide();
            v_regle->hide();
        }

        bt_affhide_menus->setDisabled(true);
        QPixmap wl_pix_001 = QPixmap::grabWidget(screen_designer);
        QPixmap wl_pix_002 = wl_pix_001.copy(0,wl_pix_001.height()-100,wl_pix_001.width(),100);

        QImage wl_img_001 = wl_pix_002.toImage();
        QImage wl_img_002 = wl_img_001.mirrored(false,true);
        QImage wl_img_003(wl_pix_001.width(),wl_pix_001.height()+100,QImage::Format_ARGB32);
        wl_img_003.fill(0);

        wl_img_002 = wl_img_002.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );
        wl_img_002 = blur_shadow(wl_img_002);

        QPainter p;
        p.begin(&wl_img_002);
        QPainter::CompositionMode mode = (QPainter::CompositionMode)6;
        p.setCompositionMode ( mode );
        p.setBackgroundMode(Qt::TransparentMode);
        QLinearGradient mygradient2(0,0,0,wl_img_002.height());
        mygradient2.setColorAt(0.0,QColor(255,255,255,50));
        mygradient2.setColorAt(1.0,QColor(0,0,0,0));
        p.fillRect ( 0, 0, wl_img_002.width(), wl_img_002.height(), QBrush( mygradient2 ));
        p.end();

        p.begin(&wl_img_003);
        p.drawPixmap(0,0,wl_pix_001.width(),wl_pix_001.height(),wl_pix_001);
        p.drawImage(0,wl_img_003.height()-100,wl_img_002,0,0,-1,100);
        p.end();

        sur_blend->setPixmap(QPixmap::fromImage(wl_img_003,Qt::AutoColor));
        sur_blend->setGeometry(screen_designer->geometry().x(),screen_designer->geometry().y(),screen_designer->width(),screen_designer->height()+100);
        sur_blend->show();
        sur_blend->raise();
        screen_designer->hide();

        bottom_menu->raise();
        frame_top_tool->hide();

        QPropertyAnimation *animation = new QPropertyAnimation(sur_blend, "geometry");
        animation->setDuration(700);
        animation->setStartValue(QRect(screen_designer->geometry().x(),screen_designer->geometry().y(),screen_designer->width(),screen_designer->height()+100));
        animation->setEndValue(QRect((dvdxsize-(dvdxsize/1.3))/2,20,dvdxsize/1.3,dvdysize/1.3));
        animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();

        QPropertyAnimation *animation2 = new QPropertyAnimation(frame_lst_menus, "geometry");
        connect(animation2,SIGNAL(finished()),this,SLOT(f_switch_lstmenu_2()));
        animation2->setDuration(1000);
        animation2->setStartValue(QRect(frame_lst_menus->geometry().x(),frame_lst_menus->geometry().y(),frame_lst_menus->width(),frame_lst_menus->height()));
        animation2->setEndValue(QRect(frame_lst_menus->geometry().x(),this->height()-bottom_menu->height()-frame_lst_menus->height()-smenuBar->height()-10,frame_lst_menus->width(),frame_lst_menus->height()));
        animation2->setEasingCurve(QEasingCurve::InOutCubic);
        animation2->start();
    }
    else
    {
        bt_affhide_menus->setDisabled(true);

        bottom_menu->raise();

        QPropertyAnimation *animation2 = new QPropertyAnimation(frame_lst_menus, "geometry");
        animation2->setDuration(400);
        animation2->setStartValue(QRect(frame_lst_menus->geometry().x(),frame_lst_menus->geometry().y(),frame_lst_menus->width(),frame_lst_menus->height()));
        animation2->setEndValue(QRect(frame_lst_menus->geometry().x(),frame_lst_menus->geometry().y()+160+bottom_menu->height(),frame_lst_menus->width(),frame_lst_menus->height()));
        animation2->setEasingCurve(QEasingCurve::InOutCubic);
        animation2->start();

        QPropertyAnimation *animation = new QPropertyAnimation(sur_blend, "geometry");
        connect(animation,SIGNAL(finished()),this,SLOT(f_switch_lstmenu_close()));
        animation->setDuration(700);
        animation->setStartValue(QRect(sur_blend->geometry().x(),sur_blend->geometry().y(),sur_blend->width(),sur_blend->height()));
        animation->setEndValue(QRect(screen_designer->geometry().x(),screen_designer->geometry().y(),screen_designer->width(),screen_designer->height()+100));
        animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();
    }
}

void mainfrm::f_switch_lstmenu()
{
    thread_blend->srcImage = QPixmap::grabWidget(sur_blend).toImage().copy(0,0,dvdxsize,dvdysize);
    thread_blend->srcImage2 = QPixmap::grabWidget(screen_designer).toImage();
    thread_blend->dstImage = thread_blend->srcImage;
    thread_blend->sequence = 0;
    sur_blend->setPixmap(QPixmap::grabWidget(sur_blend));
    sur_blend->setGeometry(screen_designer->geometry().x(),screen_designer->geometry().y(),screen_designer->width(),screen_designer->height());
    sur_blend->show();
    sur_blend->raise();
    f_run_bld();
    //
    screen_designer->show();
    bt_affhide_menus->setEnabled(true);
    bt_view_arbo->setEnabled(true);
    bt_opc_toolbar->setEnabled(true);
    bt_view_magnetic->setEnabled(true);

    frame_top_tool->show();
    frame_top_tool->raise();
}

void mainfrm::f_switch_lstmenu_2()
{
    bt_affhide_menus->setEnabled(true);
    bt_add_menu->setEnabled(true);
}

void mainfrm::f_switch_lstmenu_close()
{
    thread_blend->srcImage = QPixmap::grabWidget(sur_blend).toImage().copy(0,0,dvdxsize,dvdysize);
    thread_blend->srcImage2 = QPixmap::grabWidget(screen_designer).toImage();
    thread_blend->dstImage = thread_blend->srcImage;
    thread_blend->sequence = 0;
    sur_blend->setPixmap(QPixmap::grabWidget(sur_blend));
    sur_blend->setGeometry(screen_designer->geometry().x(),screen_designer->geometry().y(),screen_designer->width(),screen_designer->height());
    sur_blend->show();
    sur_blend->raise();
    f_run_bld();

    bt_switch_medias->setEnabled(true);
    bt_switch_themes->setEnabled(true);
    bt_switch_property->setEnabled(true);
    bt_view_arbo->setEnabled(true);
    bt_view_magnetic->setEnabled(true);
    bt_view_magnetic->setEnabled(true);
    bt_opc_render->setEnabled(true);
    bt_opc_toolbar->setEnabled(true);
    bt_view_infos->setEnabled(true);
    frame_pro->setEnabled(true);
    smenuBar->setEnabled(true);
    bt_affhide_menus->setEnabled(true);
    bt_view_arbo->setEnabled(true);
    frame_top_tool->show();
    frame_top_tool->raise();
}

void mainfrm::f_showhide_lstmedias()
{
    frame_medias->show();
    tabwidget_main->hide();
    frame_left_menu->hide();
}

void mainfrm::f_showhide_lstthemes()
{
    tabwidget_main->show();
    frame_medias->hide();
    frame_left_menu->hide();
}

void mainfrm::f_showhide_lstproperty()
{
    frame_left_menu->show();
    frame_medias->hide();
    tabwidget_main->hide();
}
