/* ============================================================
 * File  : lst_diapos.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "lst_diapos.h"

lst_diapos::lst_diapos ( QWidget * parent )
    : QFrame(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        this->setAcceptDrops(true);
        this->setMouseTracking(true);

        QLabel *winsert = new QLabel(this);
        pntinsert = winsert;

        insert_movie = new QMovie(":/Interface/Interface/insertion.gif");
        if ( insert_movie->isValid() == false )
        {
                qDebug() << "ERROR LOADING PICTURE INSERT IN TIMELINE";
        }
        else
        {
                insert_movie->setCacheMode( QMovie::CacheAll );
                insert_movie->jumpToFrame( 0 );
        }
        pntinsert->setGeometry( 100, 3, 32, 32);
        pntinsert->setMovie ( insert_movie );
        pntinsert->setScaledContents (true);

        myeffect = new QGraphicsOpacityEffect();
        myeffect->setOpacity(0.0);
        pntinsert->setAttribute(Qt::WA_TranslucentBackground, true);
        pntinsert->setGraphicsEffect(myeffect);

        QPalette mypal = QApplication::palette();
        wg_color_1 = mypal.color(QPalette::Window);
        wg_color_3 = mypal.color(QPalette::Text);
        wg_color_3.setAlpha(150);

        action_nouveau = new QAction(tr("Ajouter une diapositive"), this);
        action_nouveau->setIcon ( QIcon(":/Interface/Interface/new.png") );

        action_diapauto = new QAction(tr("Diaporama automatique"), this);
        action_diapauto->setIcon ( QIcon(":/Interface/Interface/rand.png") );

        action_talea = new QAction(tr("Ajouter une transition aleatoire a toutes les diapositives"), this);
        action_talea->setIcon ( QIcon(":/Interface/Interface/roll.png") );

        action_add_sound = new QAction(tr("Ajouter une bande son"), this);
        action_add_sound->setIcon ( QIcon(":/Interface/Interface/sound.png") );

        action_del_sound = new QAction(tr("Supprimer bande son"), this);
        action_del_sound->setIcon ( QIcon(":/Interface/Interface/trash.png") );

        action_adj_sound = new QAction(tr("Ajuster la duree du diaporama a la bande son"), this);
        action_adj_sound->setIcon ( QIcon(":/Interface/Interface/chapitrage.png") );

        action_diapauto_fi = new QAction(tr("Ajouter des diapositives a partir d'images"), this);
        action_diapauto_fi->setIcon ( QIcon(":/Interface/Interface/new.png") );

        action_adjtime = new QAction(("Ajuster"), this);
        action_adjtime->setIcon ( QIcon(":/Interface/Interface/time.png") );

        connect(action_nouveau, SIGNAL(triggered()), this, SLOT(f_new_diapo()));
        connect(action_talea, SIGNAL(triggered()), this, SLOT(f_action_talea()));

        connect(action_add_sound, SIGNAL(triggered()), this, SLOT(f_add_sound()));
        connect(action_del_sound, SIGNAL(triggered()), this, SLOT(f_del_sound()));
        connect(action_adj_sound, SIGNAL(triggered()), this, SLOT(f_adj_sound()));

        connect(action_diapauto, SIGNAL(triggered()), this, SLOT(f_action_diapauto()));
        connect(action_diapauto_fi, SIGNAL(triggered()), this, SLOT(f_action_diapauto_fi()));
        connect(action_adjtime, SIGNAL(triggered()), this, SLOT(f_action_adjtime()));

        wg_int_001 = 0;
        while ( wg_int_001 < 400 )
        {
            tab_duration[wg_int_001] = 0;
            tab_transition[wg_int_001] = 0;
            wg_int_001++;
        }

        myfont.setPixelSize ( 12 );
        myfont.setBold(true);

        nbre_audio_track = 0;
        num_current_diapo = 0;
}

void lst_diapos::wheelEvent(QWheelEvent *event)
{
    if ( event->delta() > 0 )
    {
        emit s_slide_lst(1);
    }
    else
    {
        emit s_slide_lst(2);
    }
}

void lst_diapos::contextMenuEvent(QContextMenuEvent *event)
{
        QMenu menu(this);
        menu.addAction(action_nouveau);
        menu.addAction(action_diapauto);
        menu.addAction(action_diapauto_fi);
        menu.addSeparator();
        menu.addAction(action_talea);

        action_adjtime->setText(tr("Ajuster la duree de toutes les diapos a : ") + QString::number(tab_duration[num_current_diapo]) + " sec");
        menu.addAction(action_adjtime);
        menu.addSeparator();
        if ( nbre_audio_track < 1 )
        {
            menu.addAction(action_add_sound);
        }
        else
        {
            menu.addAction(action_del_sound);
            menu.addAction(action_adj_sound);
        }
        menu.exec(event->globalPos());
}

void lst_diapos::f_action_adjtime()
{
    emit s_action_adjtime(tab_duration[num_current_diapo]);
}

void lst_diapos::f_action_diapauto_fi()
{
    emit s_action_diapauto_fi();
}

void lst_diapos::f_action_diapauto()
{
    emit s_action_diapauto();
}

void lst_diapos::f_add_sound()
{
    emit s_add_sound();
}

void lst_diapos::f_adj_sound()
{
    emit s_adj_sound();
}

void lst_diapos::f_del_sound()
{
    emit s_del_sound();
}

void lst_diapos::f_action_talea()
{
    emit e_action_talea();
}

void lst_diapos::f_new_diapo()
{
    emit new_diapo();
}

void lst_diapos::paintEvent(QPaintEvent *)
{
    QPainter p;
    p.begin(this);
    p.setPen(Qt::NoPen);
    p.setRenderHint(QPainter::Antialiasing,true);

    QPen mypen;
    mypen.setColor(wg_color_3); //.darker(135));
    mypen.setStyle(Qt::DotLine);
    mypen.setWidth(1);
    p.setPen(mypen);
    //p.drawLine(0,54,this->width(),54);

    wg_int_001 = 0;

    wg_cumul = 0;

    while ( wg_int_001 < max_diapo )
    {
        wg_cumul = wg_cumul + (tab_duration[wg_int_001]-tab_transition[wg_int_001]);
        p.drawLine(((wg_int_001+1)*60)-5,0,((wg_int_001+1)*60)-5,this->height());
        p.setFont(myfont);
        p.drawText(QRect(((wg_int_001+1)*60)-3,52,60,14), Qt::AlignLeft,QString::number(wg_cumul));
        wg_int_001++;
    }

    p.end();
}

void lst_diapos::dragMoveEvent( QDragMoveEvent * event )
{
        if ( event->pos().x() < (max_diapo) * 60 && max_diapo > -1 )
        {
                pntinsert->setGeometry( (int)((event->pos().x() / 60)*60)+4, 14, 52, 32);
        }
        else
        {
                pntinsert->setGeometry( (int)((max_diapo-1)*60)+4, 14, 52, 32);
        }
}

void lst_diapos::dropEvent(QDropEvent *event)
{
        drop_x = event->pos().x();
        insert_movie->stop();

        if ( event->mimeData()->hasUrls() == true )
        {
                QList<QUrl> myurl = event->mimeData()->urls();
                QString wl_str_001;
                wl_str_001 = myurl[0].toString(QUrl::None);
                if ( wl_str_001.mid(0,6) == "file:/" && ( wl_str_001.right(4) == ".MP3" || wl_str_001.right(4) == ".mp3" || wl_str_001.right(4) == ".WAV" || wl_str_001.right(4) == ".wav" ) )
                {
                    emit s_add_snd_drop(wl_str_001.mid(7,wl_str_001.length()-7));
                }
        }
        else
        {
                if (event->mimeData()->hasText())
                {
                        wl_pathname = event->mimeData()->text();
                        event->acceptProposedAction();
                        emit godrop();
                }
        }
        QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "opacity");
        connect(animation,SIGNAL(finished()),this,SLOT(f_leave()));
        animation->setDuration(300);
        animation->setStartValue(myeffect->opacity());
        animation->setEndValue(0.0);
        animation->start();
}

void lst_diapos::dragLeaveEvent ( QDragLeaveEvent * )
{
        QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "opacity");
        connect(animation,SIGNAL(finished()),this,SLOT(f_leave()));
        animation->setDuration(300);
        animation->setStartValue(myeffect->opacity());
        animation->setEndValue(0.0);
        animation->start();
        insert_movie->stop();
}

void lst_diapos::dragEnterEvent(QDragEnterEvent *event)
{
        event->acceptProposedAction();
        QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "opacity");
        animation->setDuration(300);
        animation->setStartValue(myeffect->opacity());
        animation->setEndValue(1.0);
        animation->start();

        pntinsert->raise();
        insert_movie->start();
}

void lst_diapos::f_leave()
{
    pntinsert->setGeometry(0, -40, 52, 32);
}

Qt::DropActions lst_diapos::supportedDropActions () const
{
        // returns what actions are supported when dropping
        return Qt::CopyAction | Qt::MoveAction;
}
