/* ============================================================
 * File  : list_themes.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "list_themes.h"

list_themes::list_themes ( QWidget * parent )
    : QListWidget(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        //this->setMouseTracking(true);
}

void list_themes::enterEvent ( QEvent * )
{
        //emit affhide_anim();
}

void list_themes::leaveEvent ( QEvent * )
{
        emit affhide_anim();
}

void list_themes::mouseMoveEvent(QMouseEvent *event )
{
        if (!(event->buttons() & Qt::LeftButton)) return;

        if (currentItem() == NULL)
        {
                return;
        }
        else
        {

                QList<QListWidgetItem *> lstmul = this->selectedItems();

                if ( lstmul.count() > 0 )
                {                
                    QMimeData *mimedata = new QMimeData;
                    QList<QUrl> lsturl;
                    QUrl myurl;
                    myurl.setPath("$ANI" + lstmul.at(0)->text());
                    lsturl.insert ( 0, myurl );
                    mimedata->setUrls(lsturl);
                    emit affhide_anim();
                    QPixmap wl_pix(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/"+lstmul.at(0)->text());

                    QDrag *drag = new QDrag(this);
                    drag->setMimeData(mimedata);
                    drag->setPixmap(wl_pix);
                    drag->exec(Qt::MoveAction);
                }
        }
}
