/* ============================================================
 * File  : is_is.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "is_is.h"

is_is::is_is ( QWidget * parent )
    : QLabel(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
	is_active = 0;
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void is_is::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
        p.setRenderHint(QPainter::Antialiasing,true);
        QPen mypen;
        mypen.setStyle(Qt::DotLine);
        mypen.setColor(QColor(150,150,150,200));
        p.setPen(mypen);
	if ( is_active == 0 )
	{
		p.drawPixmap(5,5,QPixmap(":/Interface/Interface/" + this->whatsThis().mid(2,this->whatsThis().length()-2) + "1.png"));
	}
	else
	{
		p.drawPixmap(5,5,QPixmap(":/Interface/Interface/" + this->whatsThis().mid(2,this->whatsThis().length()-2) + ".png"));
	}
	p.drawRoundedRect(1, 1, this->width()-2, this->height()-2,10,10,Qt::AbsoluteSize);
	p.end();
}

