/* ============================================================
 * File  : frame_info_2.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "frame_info_2.h"

frame_info_2::frame_info_2 ( QWidget * parent )
    : QFrame(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
	wl_action = "";
	wl_playlist = "";
	wl_row_playlist = 0;
	myfont.setPixelSize ( 11 );
	myfont.setBold(false);
}

void frame_info_2::f_show()
{
    this->raise();
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void frame_info_2::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
	p.setPen(Qt::NoPen);
        p.setFont(myfont);
        p.setRenderHint(QPainter::Antialiasing,true);

        if ( wl_action != "FAKEFORARBO2" )
        {
            QLinearGradient Gradient1(0.0,20.0,0.0,this->height()-20);
            Gradient1.setColorAt(0.0, QColor(40,40,40,230));
            Gradient1.setColorAt(0.7, QColor(40,40,40,250));
            p.setBrush(Gradient1);
            p.drawRoundedRect(0, 20, this->width(), this->height()-20,3,3,Qt::AbsoluteSize);
            QPointF points[3] = {
                    QPointF(25.0, 20),
                    QPointF(45.0, 20),
                    QPointF(35.0, 0)
            };
            p.setBrush(QColor(40,40,40,230));
            p.drawPolygon(points, 3);
        }
        else
        {
            QLinearGradient Gradient1(0.0,5.0,0.0,this->height()-5);
            Gradient1.setColorAt(0.0, QColor(40,40,40,230));
            Gradient1.setColorAt(0.7, QColor(40,40,40,250));
            p.setBrush(Gradient1);
            p.drawRoundedRect(0, 5, this->width(), this->height()-5,3,3,Qt::AbsoluteSize);
            QPointF points[3] = {
                    QPointF(35.0, 5),
                    QPointF(25.0, 5),
                    QPointF(30.0, 0)
            };
            p.setBrush(QColor(40,40,40,230));
            p.drawPolygon(points, 3);
            myfont.setPixelSize ( 9 );
            p.setFont(myfont);
            p.setPen(QColor(255,255,255));
            QTime wl_time(0,0,0);
            wl_time = wl_time.addSecs(wl_playlist.toInt());
            p.drawText(QRect(0,5,this->width(),this->height()-5), Qt::AlignCenter,wl_time.toString("hh:mm:ss"));
        }

        if ( wl_action != "FAKEFORARBO" && wl_action != "FAKEFORARBO2" )
	{
		if ( wl_action == "" )
		{
                        p.drawPixmap(5,22,32,32,QPixmap(":/Interface/Interface/error.png"));
			p.setPen(QColor(240,240,240));
                        p.drawText(QRect(37,20,this->width()-37,this->height()-20), Qt::AlignCenter,tr("Aucune action n'est associee a ce bouton"));
		}
		else
		{
			if ( wl_playlist == "" )
			{
                                p.drawPixmap(5,22,32,32,QPixmap(":/Interface/Interface/select.png"));
				p.setPen(QColor(240,240,240));
                                p.drawText(QRect(37,20,this->width()-37,this->height()-20), Qt::AlignCenter,wl_action);
			}
			else
			{
                                p.drawPixmap(5,22,32,32,QPixmap(":/Interface/Interface/select.png"));
				p.setPen(QColor(240,240,240));
                                p.drawText(QRect(37,20,this->width()-37,this->height()-(20+(wl_row_playlist*12))), Qt::AlignCenter,wl_action);
                                myfont.setPixelSize ( 10 );
                                p.setFont(myfont);
				p.setPen(QColor(132,212,44));
                                p.drawText(QRect(37,this->height()-((wl_row_playlist*15)),this->width()-37,15*wl_row_playlist), Qt::AlignCenter,wl_playlist);
                                myfont.setPixelSize ( 11 );
			}
		}
	}
	p.end();
}

