/* ============================================================
 * File  : frame_chapters.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "frame_chapters.h"

frame_chapters::frame_chapters(QWidget *parent)
    : QListWidget(parent)
{
	setSelectionMode(QAbstractItemView::SingleSelection);
	action_delete = new QAction(tr("Supprimer le chapitre"), this);
	action_delete->setIcon ( QIcon(":/Interface/Interface/trash.png") );
	connect(action_delete, SIGNAL(triggered()), this, SLOT(delete_chapitres()));
}

void frame_chapters::delete_chapitres()
{
        QList<QListWidgetItem *> selectitem = this->selectedItems();
        int wl_int_002 = this->selectedItems().size();
	for (int wl_int_001 = 0; wl_int_001 < wl_int_002; wl_int_001++) 
	{
		this->removeItemWidget(selectitem.at(wl_int_001));
		this->takeItem(QListWidget::row(selectitem.at(wl_int_001)));
		emit delete_row(selectitem.at(wl_int_001)->text());
        }
}

void frame_chapters::f_delete_row(QString pos)
{
	QList<QListWidgetItem *> delitem = this->findItems( pos, Qt::MatchExactly );
	if ( delitem.size() > 0 ) 
	{
		this->removeItemWidget(delitem.at(0));
		this->takeItem(QListWidget::row(delitem.at(0)));
	}
}

void frame_chapters::mouseDoubleClickEvent(QMouseEvent *)
{
	QList<QListWidgetItem *> selectitem = this->selectedItems();
	if ( selectitem.count() == 0 ) 
	{
		return;
	}
	else
	{
		emit gochapter(selectitem.at(0)->text());
	}
}

void frame_chapters::contextMenuEvent(QContextMenuEvent *event)
{
	if (currentItem() == NULL) 
	{
		return;
	}
	else
	{
		QMenu menu(this);
		menu.addAction(action_delete);
		menu.exec(event->globalPos());
	}
}

