/* ============================================================
 * File  : flag.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "flag.h"

flag::flag ( QWidget * parent )
    : QLabel(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);

	position = 1;

	myfont.setFamily("DejaVu Sans Condensed");
	myfont.setPixelSize ( 20 );
	myfont.setBold(true);
}

void flag::wheelEvent(QWheelEvent *event)
{
	if ( event->delta() > 0 )
	{
		if ( position < maximum )
		{ 
			position++;
			this->repaint();
		}
	}
	else
	{
		if ( position > 1 )
		{ 
			position--;
			this->repaint();
		}
	}
	emit change_pos();
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void flag::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
	p.setRenderHint(QPainter::Antialiasing,true);
	p.drawPixmap(0,0,QPixmap(":/Interface/Interface/sticker_2.png"));
	p.setPen(QColor(255,255,255));
	p.setFont(myfont);
	p.drawText(QRect(0,0,this->width(),this->height()), Qt::AlignVCenter | Qt::AlignHCenter, QString::number(position));
	p.end();
}

