/* ============================================================
 * File  : effect_bt.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "effect_bt.h"

effect_bt::effect_bt ( QWidget * parent )
    : QPushButton(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        this->setAttribute(Qt::WA_TranslucentBackground, true);
        x=0;
}

void effect_bt::enterEvent ( QEvent * )
{
        if ( x == 0 )
        {
            x = this->geometry().x();
            y = this->geometry().y();
            w = this->width();
            h = this->height();
        }

        if ( this->isEnabled() == true )
        {
            QPropertyAnimation *animation = new QPropertyAnimation(this, "geometry");
            animation->setDuration(250);
            animation->setStartValue(QRect(x,y,w,h));
            animation->setEndValue(QRect(this->geometry().x()-5,this->geometry().y()-5,this->width()+10,this->height()+10));
            //animation->setEasingCurve(QEasingCurve::InOutBack);
            animation->start();
        }
}

void effect_bt::leaveEvent ( QEvent * )
{
        if ( this->isEnabled() == true )
        {
            QPropertyAnimation *animation = new QPropertyAnimation(this, "geometry");
            animation->setDuration(250);
            animation->setStartValue(QRect(this->geometry().x(),this->geometry().y(),this->width(),this->height()));
            animation->setEndValue(QRect(x,y,w,h));
            //animation->setEasingCurve(QEasingCurve::InOutBack);
            animation->start();
        }
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void effect_bt::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
        p.drawImage(QRect(0,0,-1,-1),wl_img_1.scaled(this->width(),this->height()));
        p.setBrush(QColor(0,0,0,150));
        p.setPen(QColor(255,255,255));

        QFont myfont;
        myfont.setPixelSize ( 11 );

        p.setFont(myfont);
        p.setPen(Qt::NoPen);
        p.drawRect(0,this->height()-14,this->width(),14);

        p.setPen(QColor(255,255,255));
        p.drawText(0,this->height()-12,this->width(),12,Qt::AlignCenter,this->toolTip());
        p.end();
}

