/* ============================================================
 * File  : edit_overlay.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <QtGui>
#include "mainfrm.h"

void mainfrm::f_edit_overlay(menu *hdlm)
{
	smenuBar->setDisabled(true);

	if ( hdl_current_menu->quoi_overlay == "" )	
	{
		frame_designer_overlays->draw_user.fill(0);
		QPixmap wl_pix_001 = hdl_current_menu->draw_image;
		if ( wl_pix_001.width() > wl_pix_001.height() )
		{
			wl_pix_001 = wl_pix_001.scaledToWidth ( frame_designer_overlays->width(), Qt::FastTransformation );
			if ( wl_pix_001.height() >frame_designer_overlays->height() )
			{
				wl_pix_001 = wl_pix_001.scaledToHeight ( frame_designer_overlays->height(), Qt::FastTransformation );
			}
		}
		else
		{
			wl_pix_001 = wl_pix_001.scaledToHeight ( frame_designer_overlays->height(), Qt::FastTransformation );
			if ( wl_pix_001.width() >frame_designer_overlays->width() )
			{
				wl_pix_001 = wl_pix_001.scaledToWidth ( frame_designer_overlays->width(), Qt::FastTransformation );
			}
		}
		QPixmap wl_pix_002 = wl_pix_001;
		wl_pix_001.fill(QColor(0,0,0));
		wl_pix_001.setMask(wl_pix_002.mask());
		frame_designer_overlays->draw_user = wl_pix_001.toImage();
		frame_designer_overlays->draw_user = frame_designer_overlays->draw_user.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );
		//frame_designer_overlays->repaint();
	}
	else
	{
		frame_designer_overlays->draw_user.load(path_project+"/DVD/SVP/"+hdl_current_menu->quoi_overlay);
		frame_designer_overlays->draw_user = frame_designer_overlays->draw_user.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );
	}

        QPixmap wl_pix_001(frame_designer_overlays->draw_user.width(),frame_designer_overlays->draw_user.height());
        wl_pix_001.fill(QColor(0,0,0,0));
        QPainter p;
        p.begin(&wl_pix_001);
        p.drawPixmap(0,0,frame_designer_overlays->draw_user.width(),frame_designer_overlays->draw_user.height(),hdlm->draw_image.scaled(frame_designer_overlays->draw_user.width(),frame_designer_overlays->draw_user.height()));
        p.end();
        frame_fond_designer_overlays->setPixmap(wl_pix_001);

        thread_ani->hdlmsk = mask_interface;
        thread_ani->sens = 1;
        thread_ani->isrender = 0;
        mask_interface->show();
        mask_interface->raise();

        QTimer::singleShot(5, this, SLOT(f_run_ani()));
	frame_edit_overlay->show();
	frame_edit_overlay->raise();
}

void mainfrm::f_close_editoverlay_cancel()
{
    thread_ani->hdlmsk = mask_interface;
    thread_ani->sens = 0;
    thread_ani->isrender = 0;
    mask_interface->show();
    mask_interface->raise();

    QTimer::singleShot(5, this, SLOT(f_run_ani()));
    frame_edit_overlay->hide();
    smenuBar->setEnabled(true);
}

void mainfrm::f_close_editoverlay()
{
	if ( hdl_current_menu->quoi_overlay == "" )	
	{
		if ( frame_designer_overlays->is_modification == 1 )
		{
			QString wl_str_001 = QString::number(QDate::currentDate().toJulianDay()) + QTime::currentTime().toString("hhmmss") + ".png";
			frame_designer_overlays->draw_user.save(path_project+"/DVD/SVP/"+wl_str_001,"PNG");
			hdl_current_menu->quoi_overlay = wl_str_001;
		}
	}
	else
	{
		frame_designer_overlays->draw_user.save(path_project+"/DVD/SVP/"+hdl_current_menu->quoi_overlay,"PNG");
	}
        thread_ani->hdlmsk = mask_interface;
        thread_ani->sens = 0;
        thread_ani->isrender = 0;
        mask_interface->show();
        mask_interface->raise();

        QTimer::singleShot(5, this, SLOT(f_run_ani()));
	frame_edit_overlay->hide();
	smenuBar->setEnabled(true);
}

void mainfrm::f_designer_brush_width(int epaisseur)
{
	frame_designer_overlays->brush_width = epaisseur;
}

void mainfrm::f_tool_designer_1()
{
	frame_designer_overlays->tool = 0;
}

void mainfrm::f_tool_designer_2()
{
	frame_designer_overlays->tool = 1;
}

void mainfrm::f_tool_designer_3()
{
	frame_designer_overlays->tool = 2;
}

void mainfrm::f_tool_designer_4()
{
	frame_designer_overlays->tool = 3;
}

void mainfrm::f_tool_designer_5()
{
	frame_designer_overlays->draw_user.fill(0);
	frame_designer_overlays->is_modification = 1;
	frame_designer_overlays->repaint();
}

void mainfrm::f_tool_designer_6()
{
        frame_designer_overlays->tool = 4;
}
