/* ============================================================
 * File  : designer.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "designer.h"

designer::designer ( QWidget * parent )
    : QFrame(parent)
{
        setMouseTracking(true);
	draw_user.load(":/Interface/Interface/reload.png");
	draw_user = draw_user.scaled(401,291);
	draw_user.fill(0);
	draw_user = draw_user.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor ); //_Premultiplied
	dragPosition = QPoint(0,0);
	brush_width = 10;
	tool = 0;
	is_in = 0;
	is_draw_ct = 0;
}

void designer::mouseMoveEvent(QMouseEvent *event)
{
	mouse_x = event->x();
	mouse_y = event->y();
	if ((event->buttons() & Qt::LeftButton) )
	{
		QPen brush_pen;
		brush_pen.setColor(QColor(0,0,0));
		brush_pen.setWidth(brush_width);
		brush_pen.setJoinStyle(Qt::RoundJoin);
		brush_pen.setCapStyle(Qt::RoundCap);

		QPainter p;
		p.begin(&draw_user);
		p.setBackgroundMode(Qt::TransparentMode);
		p.setRenderHint(QPainter::Antialiasing,true);

		if ( tool == 0 )
		{
			p.setPen(brush_pen);
			p.drawLine(old_mouse_x,old_mouse_y,mouse_x,mouse_y);
		}
		else
		{
			if ( tool == 1 )
			{
				QPainter::CompositionMode mode = (QPainter::CompositionMode)3;
				p.setCompositionMode ( mode );
				brush_pen.setColor(QColor(0,0,0,0));
				p.setPen(brush_pen);
				p.drawLine(old_mouse_x,old_mouse_y,mouse_x,mouse_y);
			}
		}
		p.end();

		old_mouse_x = event->x();
		old_mouse_y = event->y();
	}

	this->repaint();
}

void designer::mousePressEvent ( QMouseEvent * event ) 
{
	old_mouse_x = event->x();
	old_mouse_y = event->y();

	draw_ct_x = event->x();
	draw_ct_y = event->y();
	is_draw_ct = 1;
	is_modification = 1;

	if ((event->buttons() & Qt::LeftButton) )
	{
		QPen brush_pen;
		brush_pen.setColor(QColor(0,0,0));
		brush_pen.setWidth(brush_width);
		brush_pen.setJoinStyle(Qt::RoundJoin);
		brush_pen.setCapStyle(Qt::RoundCap);

		QPainter p;
		p.begin(&draw_user);
		p.setBackgroundMode(Qt::TransparentMode);
		p.setRenderHint(QPainter::Antialiasing,true);

		if ( tool == 0 )
		{
			p.setPen(brush_pen);
			p.drawPoint(old_mouse_x,old_mouse_y);
		}
		else
		{
			if ( tool == 1 )
			{
				QPainter::CompositionMode mode = (QPainter::CompositionMode)3;
				p.setCompositionMode ( mode );
				brush_pen.setColor(QColor(0,0,0,0));
				p.setPen(brush_pen);
				p.drawPoint(old_mouse_x,old_mouse_y);
			}
		}
		p.end();
	}

	this->repaint();
}

void designer::mouseReleaseEvent ( QMouseEvent * ) 
{
	is_draw_ct = 0;
	if ( tool == 2 )
	{
		QPen brush_pen;
		brush_pen.setColor(QColor(0,0,0));
		brush_pen.setWidth(brush_width);
		brush_pen.setJoinStyle(Qt::RoundJoin);
		brush_pen.setCapStyle(Qt::RoundCap);
		QPainter p;
		p.begin(&draw_user);
		p.setPen(brush_pen);
		p.setBackgroundMode(Qt::TransparentMode);
		p.setRenderHint(QPainter::Antialiasing,true);
		p.drawRect(draw_ct_x,draw_ct_y,mouse_x-draw_ct_x,mouse_y-draw_ct_y);
		p.end();

		this->repaint();
		return;
	}
	if ( tool == 3 )
	{
		QPen brush_pen;
		brush_pen.setColor(QColor(0,0,0));
		brush_pen.setWidth(brush_width);
		brush_pen.setJoinStyle(Qt::RoundJoin);
		brush_pen.setCapStyle(Qt::RoundCap);
		QPainter p;
		p.begin(&draw_user);
		p.setPen(brush_pen);
		p.setBackgroundMode(Qt::TransparentMode);
		p.setRenderHint(QPainter::Antialiasing,true);
		p.drawEllipse(draw_ct_x,draw_ct_y,mouse_x-draw_ct_x,mouse_y-draw_ct_y);
		p.end();

		this->repaint();
		return;
	}
        if ( tool == 4 )
        {
                QPen brush_pen;
                brush_pen.setColor(QColor(0,0,0));
                brush_pen.setWidth(brush_width);
                brush_pen.setJoinStyle(Qt::RoundJoin);
                brush_pen.setCapStyle(Qt::RoundCap);
                QPainter p;
                p.begin(&draw_user);
                p.setPen(brush_pen);
                p.setBackgroundMode(Qt::TransparentMode);
                p.setRenderHint(QPainter::Antialiasing,true);
                p.drawLine(draw_ct_x,draw_ct_y,mouse_x,mouse_y);
                p.end();

                this->repaint();
                return;
        }
}

void designer::enterEvent(QEvent *)
{
	is_in = 1;
	this->repaint();
}

void designer::leaveEvent(QEvent *)
{
	is_in = 0;
	this->repaint();
}

void designer::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
	p.drawImage(QRect(0,0,-1,-1),draw_user);
	QBrush mybrush;
	mybrush.setColor(QColor(255,212,44,200));
	mybrush.setStyle(Qt::DiagCrossPattern);
	p.setBrush(mybrush);
	p.setPen(Qt::NoPen);
	p.drawRect(draw_user.width(),0,this->width()-draw_user.width(),this->height());
	p.drawRect(0,draw_user.height(),this->width(),this->height()-draw_user.height());
	p.setRenderHint(QPainter::Antialiasing,true);
	QPen brush_pen;
	brush_pen.setColor(QColor(255,255,255));
	brush_pen.setJoinStyle(Qt::RoundJoin);
	brush_pen.setCapStyle(Qt::RoundCap);
	p.setBrush(QColor(0,0,0,0));
	if ( tool < 2 && is_in == 1 )
	{
		brush_pen.setWidth(1);
		p.setPen(brush_pen);
		p.drawEllipse(mouse_x-(brush_width/2),mouse_y-(brush_width/2),brush_width,brush_width);
		//p.drawPoint(mouse_x,mouse_y);
	}
	else
	{
		if ( is_draw_ct == 1 && tool == 2 )
		{
			brush_pen.setWidth(brush_width);
			p.setPen(brush_pen);
			p.drawRect(draw_ct_x,draw_ct_y,mouse_x-draw_ct_x,mouse_y-draw_ct_y);
		}
		else
		{
			if ( is_draw_ct == 1 && tool == 3 )
			{
				brush_pen.setWidth(brush_width);
				p.setPen(brush_pen);
				p.drawEllipse(draw_ct_x,draw_ct_y,mouse_x-draw_ct_x,mouse_y-draw_ct_y);
			}
                        else
                        {
                                if ( is_draw_ct == 1 && tool == 4 )
                                {
                                        brush_pen.setWidth(brush_width);
                                        p.setPen(brush_pen);
                                        p.drawLine(draw_ct_x,draw_ct_y,mouse_x,mouse_y);
                                }
                        }
		}
	}
	p.end();
}

