/* ============================================================
 * File  : audio_editor.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "audio_editor.h"

audio_editor::audio_editor ( QWidget * parent )
    : QLabel(parent)
{
	this->setMouseTracking(true);
	this->setScaledContents(true);
	this->setAutoFillBackground(true);

        position = 0;
        length_media = 0;
        nbre_diapos = 0;

        is_fade_in = 0;
        is_fade_out = 0;

        QPalette mypal = QApplication::palette();
        wg_color_1 = mypal.color(QPalette::Normal, QPalette::Text);
        wg_color_2 = mypal.color(QPalette::Normal, QPalette::Light);
        wg_color_5 = mypal.color(QPalette::Normal, QPalette::Highlight);
        wg_color_2.setAlpha(100);

        myeffect = new QGraphicsColorizeEffect();
        myeffect->setStrength(0);
        myeffect->setColor(wg_color_1);
        this->setAttribute(Qt::WA_TranslucentBackground, true);
        this->setGraphicsEffect(myeffect);

        fadein = new QAction(tr("Fondu en entree"), this);
        fadein->setIcon ( QIcon(":/Interface/Interface/fadein.png") );
        fadeout = new QAction(tr("Fondu en sortie"), this);
        fadeout->setIcon ( QIcon(":/Interface/Interface/fadeout.png") );
        action_del_sound = new QAction(tr("Supprimer bande son"), this);
        action_del_sound->setIcon ( QIcon(":/Interface/Interface/trash.png") );

        connect(fadein, SIGNAL(triggered()), this, SLOT(f_fadein()));
        connect(fadeout, SIGNAL(triggered()), this, SLOT(f_fadeout()));
        connect(action_del_sound, SIGNAL(triggered()), this, SLOT(f_del_sound()));
}

void audio_editor::f_del_sound()
{
    emit s_del_sound();
    this->close();
}

void audio_editor::f_fadein()
{
    if ( is_fade_in == 0 )
    {
        is_fade_in = 1;
    }
    else
    {
        is_fade_in = 0;
    }
    this->repaint();
}

void audio_editor::f_fadeout()
{
    if ( is_fade_out == 0 )
    {
        is_fade_out = 1;
    }
    else
    {
        is_fade_out = 0;
    }
    this->repaint();
}

void audio_editor::contextMenuEvent(QContextMenuEvent *event)
{
        QMenu menu(this);
        menu.addAction(fadein);
        menu.addAction(fadeout);
        menu.addSeparator();
        menu.addAction(action_del_sound);
        menu.exec(event->globalPos());
}

void audio_editor::mouseMoveEvent(QMouseEvent *event)
{
	if (!(event->buttons() & Qt::LeftButton)) return;
        if (event->globalPos().x() - dragPosition.x() < 10) return;
        position = (event->globalPos().x() - dragPosition.x())/60;
        if ( position > nbre_diapos ) return;
        move((position*60),this->geometry().y());
        emit recalc();
}

void audio_editor::mousePressEvent ( QMouseEvent * event ) 
{
	dragPosition = event->globalPos() - frameGeometry().topLeft();
}

void audio_editor::enterEvent(QEvent *)
{
        QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "strength");
        animation->setDuration(500);
        animation->setStartValue(myeffect->strength());
        animation->setEndValue(0.6);
        //animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();
}

void audio_editor::leaveEvent(QEvent *)
{
        QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "strength");
        animation->setDuration(500);
        animation->setStartValue(myeffect->strength());
        animation->setEndValue(0.0);
        //animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();
}

void audio_editor::paintEvent(QPaintEvent *)
{
        QPainter p;
        p.begin(this);
        p.setRenderHint(QPainter::Antialiasing,true);
        p.setPen(wg_color_2); //Qt::NoPen);
        p.setBrush(wg_color_2);
        p.drawRoundedRect(1, 1, this->width()-2, this->height()-2,6,6,Qt::AbsoluteSize);

        if ( is_fade_in == 1 )
        {
            points_fad[0].setX(6);
            points_fad[0].setY(this->height()-2);

            points_fad[1].setX(56);
            points_fad[1].setY(2);
        }
        else
        {
            points_fad[0].setX(6);
            points_fad[0].setY(this->height()-2);

            points_fad[1].setX(6);
            points_fad[1].setY(2);
        }

        if ( is_fade_out == 1 )
        {
            points_fad[2].setX(this->width()-56);
            points_fad[2].setY(2);

            points_fad[3].setX(this->width()-6);
            points_fad[3].setY(this->height()-2);
        }
        else
        {
            points_fad[2].setX(this->width()-6);
            points_fad[2].setY(2);

            points_fad[3].setX(this->width()-6);
            points_fad[3].setY(this->height()-2);
        }

        p.setBrush(wg_color_5);
        p.drawPolygon(points_fad,4);

        p.setPen(wg_color_1);
        p.drawText(QRect(10,0,this->width()-14,this->height()), Qt::AlignVCenter, title_audio);

        p.end();
}
