% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/izlog.R
\name{iz}
\alias{iz}
\alias{izlog}
\title{Calculate Laboratory Measurements from z/zlog Values}
\usage{
iz(x, limits, probs = c(0.025, 0.975))

izlog(x, limits, probs = c(0.025, 0.975))
}
\arguments{
\item{x}{\code{numeric}, z/zlog values.}

\item{limits}{\code{numeric} or \code{matrix}, lower and upper reference limits. Has to
be of length 2 for \code{numeric} or a two-column \code{matrix} with as many rows as
elements in \code{x}.}

\item{probs}{\code{numeric}, probabilities of the lower and upper reference limit,
default: \code{c(0.025, 0.975)} (spanning 95 \%). Has to be of length 2 for
\code{numeric} or a two-column \code{matrix} with as many rows as elements in \code{x}.}
}
\value{
\code{numeric}, laboratory measurements.
}
\description{
Inverse function to z or z(log) for laboratory measurement standardisation
as proposed in Hoffmann 2017 et al.
}
\details{
The inverse z value is calculated as follows (assuming that the limits where
0.025 and 0.975 quantiles):
\eqn{x = z * (limits_2 - limits_1)/3.92 + (limits_1 + limits_2)/2}

The inverse z(log) value is calculated as follows (assuming that the limits
where 0.025 and 0.975 quantiles):
\eqn{x = \exp(z * (\log(limits_2) - \log(limits_1))/3.92 + (\log(limits_1) + \log(limits_2))/2)}
}
\examples{
iz(z(1:10, limits = c(2, 8)), limits = c(2, 8))

# from Hoffmann et al. 2017
albuminzlog <- c(-0.15, -2.25, -1.15, 0.08, 1.57, -0.15, -4.53, -3.16, -5.70)
izlog(albuminzlog, limits = c(35, 52))

bilirubinzlog <- c(0.85, 0.57, -1.96, -0.43, 2.04, 3.12, 2.90, 5.72, 1.88)

limits <- cbind(
    lower = rep(c(35, 2), c(length(albuminzlog), length(bilirubinzlog))),
    upper = rep(c(52, 21), c(length(albuminzlog), length(bilirubinzlog)))
)
izlog(c(albuminzlog, bilirubinzlog), limits = limits)
}
\references{
Georg Hoffmann, Frank Klawonn, Ralf Lichtinghagen, and Matthias Orth.
2017.
"The Zlog-Value as Basis for the Standardization of Laboratory Results."
LaboratoriumsMedizin 41 (1): 23–32.
\doi{10.1515/labmed-2016-0087}.
}
\seealso{
\code{\link[=zlog]{zlog()}}
}
\author{
Sebastian Gibb
}
