% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_prep_hud.R
\name{zi_prep_hud}
\alias{zi_prep_hud}
\title{Convert HUD Crosswalk Data to Finalized Crosswalk}
\usage{
zi_prep_hud(.data, by, return_max = TRUE)
}
\arguments{
\item{.data}{The output from \code{zi_load_crosswalk()} with HUD data.}

\item{by}{Character scalar; the column name to use for identifying the best
match for a given ZIP Code. This could be either \code{"residential"},
\code{"commercial"}, or \code{"total"}.}

\item{return_max}{Logical scalar; if \code{TRUE} (default), only the county
with the highest proportion of the ZIP Code type will be returned. If the
ZIP Code straddles two states, two records will be returned. If \code{FALSE},
all records for the ZIP Code will be returned. Where a tie exists (i.e.
two counties each contain half of all addresses), the county with the lowest
\code{GEOID} value will be returned.}
}
\value{
A tibble that has been further prepared for use as a crosswalk.
}
\description{
The output from \code{zi_load_crosswalk()} for HUD data requires
    additional processing to be used in the \code{zi_crosswalk()} function.
    This function prepares the HUD data for use in joins.
}
\examples{
# load sample crosswalk data
mo_xwalk <- zi_mo_hud

  # the above data can be replicated with the following code:
  # zi_load_crosswalk(zip_source = "HUD", year = 2023, qtr = 1,
  #   target = "COUNTY", query = "MO")

# prep crosswalk
# when a ZIP Code crosses county boundaries, the portion with the largest
# number of residential addresses will be returned
zi_prep_hud(mo_xwalk, by = "residential", return_max = TRUE)

}
