% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ymd.R
\name{ymd}
\alias{ymd}
\title{Convert 'YMD' format integer or string to Date}
\usage{
ymd(x, ...)
}
\arguments{
\item{x}{An integer or string vector in 'YMD' format. Double
values without the decimal part are allowed.}

\item{...}{The same as \code{x}. It will be merged into one vector with \code{x}.
It's convinient for interactive use.}
}
\value{
A Date object. When the parse fails for certain input,
the value returned would be \code{NA}, silently.
}
\description{
Transform integer or strings vectors in 'YMD' format to Date objects.
It intends to only support limited formats (no separator or one of
'.', ' ', '-' and '/' separators). See the possible formats in examples.
}
\examples{
ymd(c(210326, 19981225))
ymd(c("2020/1/8", "20 1 7", "1998.7.1", "1990-02-03"))
ymd(210420, 180322)

}
