% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_title.R
\name{drop_title.dvec}
\alias{drop_title.dvec}
\title{Drop Title for Decorated Vector}
\usage{
\method{drop_title}{dvec}(x, ..., with_title = getOption("yamlet_with_title", TRUE))
}
\arguments{
\item{x}{dvec}

\item{...}{ignored arguments}

\item{with_title}{whether to drop title}
}
\value{
dvec
}
\description{
Drops title for decorated vectors.
If option \code{with_title} is TRUE
and x has a 'units' attribute,
it removes the title attribute. See also 
\code{\link{make_title}} for coordinated use.
}
\examples{
library(magrittr)
1 \%>\% 
as_dvec(label = 'length', guide = 'mm') \%>\%
resolve \%>\%
desolve
}
\seealso{
Other labels: 
\code{\link{alias.data.frame}()},
\code{\link{append_units}()},
\code{\link{append_units.data.frame}()},
\code{\link{append_units.default}()},
\code{\link{drop_title}()},
\code{\link{drop_title.decorated}()},
\code{\link{drop_title.default}()},
\code{\link{make_title}()},
\code{\link{make_title.decorated}()},
\code{\link{make_title.default}()},
\code{\link{make_title.dvec}()},
\code{\link{sub_units}()}
}
\concept{labels}
\keyword{internal}
