% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xxhash.R
\name{xxhash_raw}
\alias{xxhash_raw}
\title{Calculate the hash of a raw vector or string}
\usage{
xxhash_raw(vec, algo = "xxh128", as_raw = FALSE)
}
\arguments{
\item{vec}{raw vector or single character string}

\item{algo}{Select the specific xxhash algorithm. Default: 'xxh128'.
(the latest algorithm in the xxhash family)
Valid values: 'xxh32', 'xxh64', 'xxh128', 'xxh3'}

\item{as_raw}{Return the hash as a raw vector of bytes instead of string?
Default: FALSE.  If TRUE, then the raw bytes are returned in big-endian
order - which is what \code{xxHash} considers the \emph{canonical} form.}
}
\value{
String representation of hash. If \code{as_raw = TRUE} then a 
        raw vector is returned instead.
}
\description{
This performs a hash of the raw bytes - not of the serialized representation.
}
\examples{
vec <- "hello"
xxhash_raw(vec)
vec <- as.raw(c(0x01, 0x02, 0x99))
xxhash_raw(vec)
}
