% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarginalReferenceSampler.R
\name{MarginalReferenceSampler}
\alias{MarginalReferenceSampler}
\title{Marginal Reference Sampler}
\description{
Samples complete observations from reference data to replace feature values.
This approach samples from the marginal distribution while preserving within-row
feature dependencies.
}
\details{
This sampler implements what is called "marginal imputation" in the SAGE literature
(Covert et al. 2020). For each observation, it samples a complete row from reference
data and takes the specified feature values from that row. This approach:
\itemize{
\item Samples from the marginal distribution \eqn{P(X_S)} where S is the set of features
\item Preserves dependencies \strong{within} the sampled reference row
\item Breaks dependencies \strong{between} test and reference data
}

\strong{Terminology note:} In SAGE literature, this is called "marginal imputation" because
features outside the coalition are "imputed" by sampling from their marginal distribution.
We use \code{MarginalReferenceSampler} to avoid confusion with missing data imputation and to
clarify that it samples from reference data.

\strong{Comparison with other samplers:}
\itemize{
\item \code{MarginalPermutationSampler}: Shuffles each feature independently, breaking all row structure
\item \code{MarginalReferenceSampler}: Samples complete rows, preserving within-row dependencies
\item \code{ConditionalSampler}: Samples from \eqn{P(X_S | X_{-S})}, conditioning on other features
}

\strong{Use in SAGE:}

This is the default approach for \code{MarginalSAGE}. For a test observation x and features
to marginalize S, it samples a reference row x_ref and creates a "hybrid" observation
combining x's coalition features with x_ref's marginalized features.
}
\examples{
library(mlr3)
task = tgen("friedman1")$generate(n = 100)

# Default: uses all task data as reference
sampler = MarginalReferenceSampler$new(task)
sampled = sampler$sample("important1", row_ids = 1:10)

# Subsample reference data to 50 rows
sampler_subsampled = MarginalReferenceSampler$new(task, n_samples = 50L)
sampled2 = sampler_subsampled$sample("important1", row_ids = 1:10)

}
\references{
Covert I, Lundberg S, Lee S (2020).
\dQuote{Understanding Global Feature Contributions With Additive Importance Measures.}
In \emph{Advances in Neural Information Processing Systems}, volume 33, 17212--17223.
\url{https://proceedings.neurips.cc/paper/2020/hash/c7bf0b7c1a86d5eb3be2c722cf2cf746-Abstract.html}.
}
\section{Super classes}{
\code{\link[xplainfi:FeatureSampler]{xplainfi::FeatureSampler}} -> \code{\link[xplainfi:MarginalSampler]{xplainfi::MarginalSampler}} -> \code{MarginalReferenceSampler}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{reference_data}}{(\code{\link[data.table:data.table]{data.table}})
Reference data to sample from for marginalization.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MarginalReferenceSampler-new}{\code{MarginalReferenceSampler$new()}}
\item \href{#method-MarginalReferenceSampler-clone}{\code{MarginalReferenceSampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureSampler" data-id="print"><a href='../../xplainfi/html/FeatureSampler.html#method-FeatureSampler-print'><code>xplainfi::FeatureSampler$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="MarginalSampler" data-id="sample"><a href='../../xplainfi/html/MarginalSampler.html#method-MarginalSampler-sample'><code>xplainfi::MarginalSampler$sample()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="MarginalSampler" data-id="sample_newdata"><a href='../../xplainfi/html/MarginalSampler.html#method-MarginalSampler-sample_newdata'><code>xplainfi::MarginalSampler$sample_newdata()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MarginalReferenceSampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-MarginalReferenceSampler-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of the MarginalReferenceSampler class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarginalReferenceSampler$new(task, n_samples = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link[mlr3:Task]{mlr3::Task}) Task to sample from.}

\item{\code{n_samples}}{(\code{integer(1)} | \code{NULL}) Number of reference samples to use.
If \code{NULL}, uses all task data as reference.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MarginalReferenceSampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MarginalReferenceSampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarginalReferenceSampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
