% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_symmetry.R
\name{test_symmetry}
\alias{test_symmetry}
\title{test the symmetry of a matrix}
\usage{
test_symmetry(x, tol = .Machine$double.eps)
}
\arguments{
\item{x}{a matrix}

\item{tol}{a single numeric value with the tolerance for comparison}
}
\value{
a character value with the possible values "symmetric",
"skewed" or "none".
}
\description{
This function tells you whether a matrix is symmetric,
skewed symmetric, or not symmetric. It's used by \code{\link{tskrr}}
to determine which kind of homologous network is represented by
the label matrix.
}
\examples{
mat1 <- matrix(c(1,0,0,1),ncol = 2)
test_symmetry(mat1)
mat2 <- matrix(c(1,0,0,-1), ncol = 2)
test_symmetry(mat2)
mat3 <- matrix(1:4, ncol = 2)
test_symmetry(mat3)

}
\seealso{
\code{\link{tskrrHomogeneous}} for
more information on the values for the slot \code{symmetry}
}
