% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance_functions.R
\name{scalar_covariance_i_j}
\alias{scalar_covariance_i_j}
\title{Compute the approximate covariance at a point for lag windows defined by i,j}
\usage{
scalar_covariance_i_j(f_data, i, j, times)
}
\arguments{
\item{f_data}{the functional data matrix with observed functions in the columns}

\item{i, j}{the indices i,j in 1:T that we are computing the covariance for}

\item{times}{A vector with 4 columns containing indices specifying which subset of f_data to consider}
}
\value{
A numeric value; the covariance of the functional data at a point for lag
windows defined by i,j.
}
\description{
`scalar_covariance_i_j` computes the approximate covariance at a point of the functional data
for lag windows defined by i,j; a scalarized version of covariance_i_j that takes point estimates.
}
