% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransformMidsWithPrepareData.R
\name{TransformMidsWithPrepareData}
\alias{TransformMidsWithPrepareData}
\title{Apply PrepareData to Imputed Datasets and Return New MIDS Object}
\usage{
TransformMidsWithPrepareData(mids_obj, M_C1, M_C2, Y_C1, Y_C2)
}
\arguments{
\item{mids_obj}{A \code{mids} object created by the \code{mice} package, containing multiply imputed datasets.}

\item{M_C1}{A character vector specifying the names of mediator variables under Condition 1 (e.g., pre-test).}

\item{M_C2}{A character vector specifying the names of mediator variables under Condition 2 (e.g., post-test).}

\item{Y_C1}{A character string specifying the outcome variable under Condition 1.}

\item{Y_C2}{A character string specifying the outcome variable under Condition 2.}
}
\value{
A new \code{mids} object where each imputed dataset has been processed using \code{PrepareData()}.
}
\description{
This function applies the \code{PrepareData()} preprocessing step to each imputed dataset in a \code{mids} object
and returns a new \code{mids} object with the transformed data. It is designed for use in within-subject mediation analysis
pipelines when working with multiply imputed data.
}
\details{
The function performs the following steps:
\itemize{
\item Extracts all imputed datasets from the original \code{mids} object.
\item Applies \code{PrepareData()} to each imputed dataset using the specified within-subject mediator and outcome variables.
\item Combines all processed datasets into a long format and reconstructs a new \code{mids} object via \code{mice::as.mids()}.
}
This enables subsequent analyses to operate on a version of the multiply imputed data where difference scores and averages
have already been computed.
}
\keyword{internal}
