% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MClav_StdLav2.R
\name{StdLav2}
\alias{StdLav2}
\title{Standardize Parameter Estimates in a Lavaan Model}
\usage{
StdLav2(est, object)
}
\arguments{
\item{est}{A numeric vector of parameter estimates (free parameters).}

\item{object}{A fitted lavaan model object (used to extract model structure).}
}
\value{
A numeric vector of fully standardized parameter estimates (including intercepts and defined parameters).
}
\description{
Applies full standardization (including intercepts) to a fitted lavaan model
by converting to RAM form, performing standardization, and converting back to lavaan matrix structure.
}
\details{
The function extracts the model's RAM representation via \code{Lav2RAM2}, applies \code{StdRAM2} standardization,
restores the standardized GLIST via \code{RAM2Lav2}, and retrieves standardized user-defined parameter estimates
with \code{lav_model_get_parameters()}.
}
\keyword{internal}
