% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_workflow_set.R
\name{as_workflow_set}
\alias{as_workflow_set}
\title{Convert existing objects to a workflow set}
\usage{
as_workflow_set(...)
}
\arguments{
\item{...}{One or more named objects. Names should be unique and the
objects should have at least one of the following classes: \code{workflow},
\code{iteration_results}, \code{tune_results}, \code{resample_results}, or \code{tune_race}. Each
\code{tune_results} element should also contain the original workflow
(accomplished using the \code{save_workflow} option in the control function).}
}
\value{
A workflow set. Note that the \code{option} column will not reflect the
options that were used to create each object.
}
\description{
Use existing objects to create a workflow set. A list of objects that are
either simple workflows or objects that have class \code{"tune_results"} can be
converted into a workflow set.
}
\note{
The package supplies two pre-generated workflow sets, \code{two_class_set}
and \code{chi_features_set}, and associated sets of model fits
\code{two_class_res} and \code{chi_features_res}.

The \verb{two_class_*} objects are based on a binary classification problem
using the \code{two_class_dat} data from the modeldata package. The six
models utilize either a bare formula or a basic recipe utilizing
\code{recipes::step_YeoJohnson()} as a preprocessor, and a decision tree,
logistic regression, or MARS model specification. See \code{?two_class_set}
for source code.

The \verb{chi_features_*} objects are based on a regression problem using the
\code{Chicago} data from the modeldata package. Each of the three models
utilize a linear regression model specification, with three different
recipes of varying complexity. The objects are meant to approximate the
sequence of models built in Section 1.3 of Kuhn and Johnson (2019). See
\code{?chi_features_set} for source code.
}
\examples{

# ------------------------------------------------------------------------------
# Existing results

# Use the already worked example to show how to add tuned
# objects to a workflow set
two_class_res

results <- two_class_res |> purrr::pluck("result")
names(results) <- two_class_res$wflow_id

# These are all objects that have been resampled or tuned:
purrr::map_chr(results, \(x) class(x)[1])

# Use rlang's !!! operator to splice in the elements of the list
new_set <- as_workflow_set(!!!results)

# ------------------------------------------------------------------------------
# Make a set from unfit workflows

library(parsnip)
library(workflows)

lr_spec <- logistic_reg()

main_effects <-
  workflow() |>
  add_model(lr_spec) |>
  add_formula(Class ~ .)

interactions <-
  workflow() |>
  add_model(lr_spec) |>
  add_formula(Class ~ (.)^2)

as_workflow_set(main = main_effects, int = interactions)
}
