% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedCox.R
\name{cox_score_rhogamma}
\alias{cox_score_rhogamma}
\title{Cox score with rho-gamma weights}
\usage{
cox_score_rhogamma(
  beta,
  time,
  delta,
  z,
  w_hat = rep(1, length(time)),
  wt_rg = rep(1, length(time)),
  score_only = TRUE
)
}
\arguments{
\item{beta}{Log hazard ratio parameter.}

\item{time}{Numeric vector of event times.}

\item{delta}{Numeric vector of event indicators.}

\item{z}{Numeric vector of group indicators.}

\item{w_hat}{Numeric vector of weights.}

\item{wt_rg}{Numeric vector of rho-gamma weights.}

\item{score_only}{Logical; if TRUE, returns only the score.}
}
\value{
Numeric value of the score or a list with additional results.
}
\description{
Calculates the Cox score statistic for weighted log-rank tests.
}
