\name{weightedScores-package}
\alias{weightedScores-package}
\docType{package}
\title{Weighted Scores Method for Regression Models with Dependent Data}
\description{
The weighted scores method and CL1 information criteria as an intermediate step for variable/correlation selection for longitudinal ordinal and count data in Nikoloulopoulos, Joe and Chaganty (2011)  and Nikoloulopoulos (2016, 2017).
}
\details{
This package contains \R functions to implement: 
\itemize{
\item The weighted scores method for regression models with dependent data and negative binomial  (Nikoloulopoulos, Joe and Chaganty, 2011), GLM (Nikoloulopoulos, 2016) and ordinal probit/logistic (Nikoloulopoulos, 2017) margins.


\item The composite likelihood information criteria for regression models with dependent data and ordinal probit/logistic  margins (Nikoloulopoulos, 2016, 2017). 



}



}
\author{
Aristidis K. Nikoloulopoulos.
}
\references{

Nikoloulopoulos, A.K., Joe, H. and Chaganty, N.R. (2011)
Weighted scores method for regression models with dependent data.
\emph{Biostatistics}, \bold{12}, 653--665. \doi{10.1093/biostatistics/kxr005}.

Nikoloulopoulos, A.K. (2016)
Correlation structure and variable selection in generalized estimating equations via composite likelihood information criteria.
\emph{Statistics in Medicine}, \bold{35}, 2377--2390. \doi{10.1002/sim.6871}.

Nikoloulopoulos, A.K. (2017)
Weighted scores method for longitudinal  ordinal data.
\emph{Arxiv e-prints}, <arXiv:1510.07376>. \url{https://arxiv.org/abs/1510.07376}.

}
\keyword{package}
