% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_layout}
\alias{plot_layout}
\title{Layout of the Probability Plot}
\usage{
plot_layout(
  x,
  y = NULL,
  distribution = c("weibull", "lognormal", "loglogistic", "sev", "normal", "logistic",
    "exponential"),
  title_main = "Probability Plot",
  title_x = "Characteristic",
  title_y = "Unreliability",
  plot_method = c("plotly", "ggplot2")
)
}
\arguments{
\item{x}{A numeric vector which consists of lifetime data. \code{x} is used to
specify the grid of the plot.}

\item{y}{Optional argument. If used, it is a numeric vector which consists of
failure probabilities with respect to \code{x}.}

\item{distribution}{Supposed distribution of the random variable.}

\item{title_main}{A character string which is assigned to the main title.}

\item{title_x}{A character string which is assigned to the title of the x axis.}

\item{title_y}{A character string which is assigned to the title of the y axis.}

\item{plot_method}{Package, which is used for generating the plot output.}
}
\value{
A plot object containing the layout of the probability plot.
}
\description{
This function is used to create the layout of a probability plot. It is
called inside of \link{plot_prob} to determine the appearance of the grid with
respect to the given characteristic \code{x}.
}
\keyword{internal}
